/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.BannerRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class BannerRecorder {
    private final RuntimeValue<BannerRuntimeConfig> bannerRuntimeConfig;

    public BannerRecorder(RuntimeValue<BannerRuntimeConfig> bannerRuntimeConfig) {
        this.bannerRuntimeConfig = bannerRuntimeConfig;
    }

    public RuntimeValue<Optional<Supplier<String>>> provideBannerSupplier(String bannerText) {
        if (this.bannerRuntimeConfig.getValue().enabled()) {
            return new RuntimeValue<Optional<Supplier<String>>>(Optional.of(new ConstantSupplier(bannerText)));
        }
        return new RuntimeValue<Optional<Supplier<String>>>(Optional.empty());
    }

    private static final class ConstantSupplier
    implements Supplier<String> {
        private final String value;

        public ConstantSupplier(String value) {
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }
    }
}

