/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams.topics;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;

public record ConfiguredInternalTopic(String name, int numberOfPartitions, Optional<Short> replicationFactor, Map<String, String> topicConfigs) {
    public ConfiguredInternalTopic {
        Objects.requireNonNull(name, "name can't be null");
        Topic.validate((String)name);
        if (numberOfPartitions < 1) {
            throw new IllegalArgumentException("Number of partitions must be at least 1.");
        }
        topicConfigs = Collections.unmodifiableMap(Objects.requireNonNull(topicConfigs, "topicConfigs can't be null"));
    }

    public StreamsGroupDescribeResponseData.TopicInfo asStreamsGroupDescribeTopicInfo() {
        return new StreamsGroupDescribeResponseData.TopicInfo().setName(this.name).setPartitions(this.numberOfPartitions).setReplicationFactor(this.replicationFactor.orElse((short)0).shortValue()).setTopicConfigs(this.topicConfigs.entrySet().stream().map(y -> new StreamsGroupDescribeResponseData.KeyValue().setKey((String)y.getKey()).setValue((String)y.getValue())).toList());
    }
}

