/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.common.KafkaFuture;

public class DescribeLogDirsResult {
    private final Map<Integer, KafkaFuture<Map<String, LogDirDescription>>> futures;

    DescribeLogDirsResult(Map<Integer, KafkaFuture<Map<String, LogDirDescription>>> futures) {
        this.futures = futures;
    }

    public Map<Integer, KafkaFuture<Map<String, LogDirDescription>>> descriptions() {
        return this.futures;
    }

    public KafkaFuture<Map<Integer, Map<String, LogDirDescription>>> allDescriptions() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(v -> {
            HashMap<Integer, Map<String, LogDirDescription>> descriptions = new HashMap<Integer, Map<String, LogDirDescription>>(this.futures.size());
            for (Map.Entry<Integer, KafkaFuture<Map<String, LogDirDescription>>> entry : this.futures.entrySet()) {
                try {
                    descriptions.put(entry.getKey(), entry.getValue().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return descriptions;
        });
    }
}

