/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class TryCatchBlock
implements HasOwner<JavaCodeUnit>,
HasSourceCodeLocation {
    private final JavaCodeUnit owner;
    private final Set<JavaClass> caughtThrowables;
    private final SourceCodeLocation sourceCodeLocation;
    private final Set<JavaAccess<?>> accessesContainedInTryBlock;
    private final boolean declaredInLambda;

    TryCatchBlock(DomainBuilders.TryCatchBlockBuilder builder) {
        this.owner = Preconditions.checkNotNull(builder.getOwner());
        this.caughtThrowables = ImmutableSet.copyOf(builder.getCaughtThrowables());
        this.sourceCodeLocation = Preconditions.checkNotNull(builder.getSourceCodeLocation());
        this.accessesContainedInTryBlock = ImmutableSet.copyOf(builder.getAccessesContainedInTryBlock());
        this.declaredInLambda = builder.isDeclaredInLambda();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOwner() {
        return this.owner;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getCaughtThrowables() {
        return this.caughtThrowables;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAccessesContainedInTryBlock() {
        return this.accessesContainedInTryBlock;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isDeclaredInLambda() {
        return this.declaredInLambda;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("owner", this.owner.getFullName()).add("caughtThrowables", HasName.Utils.namesOf(this.caughtThrowables)).add("location", this.sourceCodeLocation).toString();
    }
}

