/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.registry.NotificationDescriptor;

public class NotificationRegistry {
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.notifications";
    private static NotificationRegistry instance;
    private final Map<String, NotificationDescriptor> notifications = new HashMap<String, NotificationDescriptor>();

    private NotificationRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("notification".equals(element.getName())) {
                NotificationDescriptor descriptor = new NotificationDescriptor(element);
                this.notifications.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
    }

    @NotNull
    public static synchronized NotificationRegistry getInstance() {
        if (instance == null) {
            instance = new NotificationRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    @NotNull
    public Collection<NotificationDescriptor> getNotifications() {
        return this.notifications.values();
    }

    @Nullable
    public NotificationDescriptor getNotification(@NotNull String id) {
        return this.notifications.get(id);
    }
}

