﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/comprehend/model/StopEventsDetectionJobRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Comprehend::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StopEventsDetectionJobRequest::SerializePayload() const {
  JsonValue payload;

  if (m_jobIdHasBeenSet) {
    payload.WithString("JobId", m_jobId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StopEventsDetectionJobRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Comprehend_20171127.StopEventsDetectionJob"));
  return headers;
}
