/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/itemattr.h>
        #include <wx/colour.h>
        #include <wx/font.h>


PyDoc_STRVAR(doc_wxItemAttr_GetBackgroundColour, "GetBackgroundColour() -> Colour\n"
"\n"
"Returns the currently set background colour.");

extern "C" {static PyObject *meth_wxItemAttr_GetBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_GetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemAttr, &sipCpp))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetBackgroundColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_GetBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_GetFont, "GetFont() -> Font\n"
"\n"
"Returns the currently set font.");

extern "C" {static PyObject *meth_wxItemAttr_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemAttr, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->GetFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_GetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_GetTextColour, "GetTextColour() -> Colour\n"
"\n"
"Returns the currently set text colour.");

extern "C" {static PyObject *meth_wxItemAttr_GetTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_GetTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemAttr, &sipCpp))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetTextColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_GetTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_HasBackgroundColour, "HasBackgroundColour() -> bool\n"
"\n"
"Returns true if the currently set background colour is valid.");

extern "C" {static PyObject *meth_wxItemAttr_HasBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_HasBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBackgroundColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_HasBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_HasColours, "HasColours() -> bool\n"
"\n"
"Returns true if either text or background colour is set.");

extern "C" {static PyObject *meth_wxItemAttr_HasColours(PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_HasColours(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasColours();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_HasColours, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_HasFont, "HasFont() -> bool\n"
"\n"
"Returns true if the currently set font is valid.");

extern "C" {static PyObject *meth_wxItemAttr_HasFont(PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_HasFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFont();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_HasFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_HasTextColour, "HasTextColour() -> bool\n"
"\n"
"Returns true if the currently set text colour is valid.");

extern "C" {static PyObject *meth_wxItemAttr_HasTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_HasTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasTextColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_HasTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_IsDefault, "IsDefault() -> bool\n"
"\n"
"Returns true if this object has no custom attributes set.");

extern "C" {static PyObject *meth_wxItemAttr_IsDefault(PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_IsDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxItemAttr, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDefault();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_IsDefault, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_SetBackgroundColour, "SetBackgroundColour(colour) -> None\n"
"\n"
"Sets a new background colour.");

extern "C" {static PyObject *meth_wxItemAttr_SetBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_SetBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxItemAttr, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackgroundColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_SetBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_SetFont, "SetFont(font) -> None\n"
"\n"
"Sets a new font.");

extern "C" {static PyObject *meth_wxItemAttr_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont* font;
        ::wxItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxItemAttr, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_SetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxItemAttr_SetTextColour, "SetTextColour(colour) -> None\n"
"\n"
"Sets a new text colour.");

extern "C" {static PyObject *meth_wxItemAttr_SetTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxItemAttr_SetTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxItemAttr *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxItemAttr, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ItemAttr, sipName_SetTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxItemAttr___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxItemAttr___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxItemAttr *sipCpp = reinterpret_cast< ::wxItemAttr *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxItemAttr));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr* other;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxItemAttr, &other))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxItemAttr::operator!=(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxItemAttr, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxItemAttr___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxItemAttr___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxItemAttr *sipCpp = reinterpret_cast< ::wxItemAttr *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxItemAttr));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxItemAttr* other;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxItemAttr, &other))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxItemAttr::operator==(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxItemAttr, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxItemAttr(void *, int);}
static void release_wxItemAttr(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxItemAttr *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxItemAttr(Py_ssize_t);}
static void *array_wxItemAttr(Py_ssize_t sipNrElem)
{
    return new ::wxItemAttr[sipNrElem];
}


extern "C" {static void array_delete_wxItemAttr(void *);}
static void array_delete_wxItemAttr(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxItemAttr *>(sipCpp);
}


extern "C" {static void assign_wxItemAttr(void *, Py_ssize_t, void *);}
static void assign_wxItemAttr(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxItemAttr *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxItemAttr *>(sipSrc);
}


extern "C" {static void *copy_wxItemAttr(const void *, Py_ssize_t);}
static void *copy_wxItemAttr(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxItemAttr(reinterpret_cast<const ::wxItemAttr *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxItemAttr(sipSimpleWrapper *);}
static void dealloc_wxItemAttr(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxItemAttr(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxItemAttr(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxItemAttr(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxItemAttr *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxItemAttr();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxColour* colText;
        int colTextState = 0;
        const ::wxColour* colBack;
        int colBackState = 0;
        const ::wxFont* font;

        static const char *sipKwdList[] = {
            sipName_colText,
            sipName_colBack,
            sipName_font,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1J9", sipType_wxColour, &colText, &colTextState, sipType_wxColour, &colBack, &colBackState, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxItemAttr(*colText, *colBack, *font);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colText), sipType_wxColour, colTextState);
            sipReleaseType(const_cast< ::wxColour *>(colBack), sipType_wxColour, colBackState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxItemAttr* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxItemAttr, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxItemAttr(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxItemAttr[] = {
    {(void *)slot_wxItemAttr___ne__, ne_slot},
    {(void *)slot_wxItemAttr___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxItemAttr[] = {
    {sipName_GetBackgroundColour, meth_wxItemAttr_GetBackgroundColour, METH_VARARGS, doc_wxItemAttr_GetBackgroundColour},
    {sipName_GetFont, meth_wxItemAttr_GetFont, METH_VARARGS, doc_wxItemAttr_GetFont},
    {sipName_GetTextColour, meth_wxItemAttr_GetTextColour, METH_VARARGS, doc_wxItemAttr_GetTextColour},
    {sipName_HasBackgroundColour, meth_wxItemAttr_HasBackgroundColour, METH_VARARGS, doc_wxItemAttr_HasBackgroundColour},
    {sipName_HasColours, meth_wxItemAttr_HasColours, METH_VARARGS, doc_wxItemAttr_HasColours},
    {sipName_HasFont, meth_wxItemAttr_HasFont, METH_VARARGS, doc_wxItemAttr_HasFont},
    {sipName_HasTextColour, meth_wxItemAttr_HasTextColour, METH_VARARGS, doc_wxItemAttr_HasTextColour},
    {sipName_IsDefault, meth_wxItemAttr_IsDefault, METH_VARARGS, doc_wxItemAttr_IsDefault},
    {sipName_SetBackgroundColour, SIP_MLMETH_CAST(meth_wxItemAttr_SetBackgroundColour), METH_VARARGS|METH_KEYWORDS, doc_wxItemAttr_SetBackgroundColour},
    {sipName_SetFont, SIP_MLMETH_CAST(meth_wxItemAttr_SetFont), METH_VARARGS|METH_KEYWORDS, doc_wxItemAttr_SetFont},
    {sipName_SetTextColour, SIP_MLMETH_CAST(meth_wxItemAttr_SetTextColour), METH_VARARGS|METH_KEYWORDS, doc_wxItemAttr_SetTextColour}
};

sipVariableDef variables_wxItemAttr[] = {
    {PropertyVariable, sipName_TextColour, &methods_wxItemAttr[2], &methods_wxItemAttr[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Font, &methods_wxItemAttr[1], &methods_wxItemAttr[9], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BackgroundColour, &methods_wxItemAttr[0], &methods_wxItemAttr[8], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxItemAttr, "ItemAttr() -> None\n"
"ItemAttr(colText, colBack, font) -> None\n"
"\n"
"Represents the attributes (colour, font, ...) of an item of a control\n"
"with multiple items such as e.g.");


sipClassTypeDef sipTypeDef__core_wxItemAttr = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxItemAttr,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_ItemAttr,
        {0, 0, 1},
        11, methods_wxItemAttr,
        0, SIP_NULLPTR,
        3, variables_wxItemAttr,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxItemAttr,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxItemAttr,
    init_type_wxItemAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxItemAttr,
    assign_wxItemAttr,
    array_wxItemAttr,
    copy_wxItemAttr,
    release_wxItemAttr,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxItemAttr,
    sizeof (::wxItemAttr),
};
