/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2ObjectType;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Package;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2PackageDepType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2PackageDep
extends DB2Object<DB2Package> {
    private DB2PackageDepType packageDepType;
    private DB2Schema depSchema;
    private String depModuleName;
    private String depModuleId;
    private String tabAuth;
    private String binder;
    private String binderType;
    private String varAuth;
    private String version;

    public DB2PackageDep(DB2Package db2Package, ResultSet resultSet) throws DBException {
        super(db2Package, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BNAME"), true);
        DB2ObjectType db2ObjectType;
        DB2DataSource db2DataSource = db2Package.getDataSource();
        this.tabAuth = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABAUTH");
        this.version = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PKGVERSION");
        String depSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"BSCHEMA");
        String depType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BTYPE");
        this.packageDepType = (DB2PackageDepType)CommonUtils.valueOf(DB2PackageDepType.class, (String)depType);
        if (this.packageDepType == null) {
            this.packageDepType = (DB2PackageDepType)CommonUtils.valueOf(DB2PackageDepType.class, (String)("ZZ_" + depType));
        }
        if (this.packageDepType != null && (db2ObjectType = this.packageDepType.getDb2ObjectType()) != null) {
            this.depSchema = (DB2Schema)this.getDataSource().getSchemaCache().getCachedObject(depSchemaName);
        }
        if (db2DataSource.isAtLeastV9_7()) {
            this.binder = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BINDER");
            this.binderType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BINDERTYPE");
            this.varAuth = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"VARAUTH");
            this.depModuleName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BMODULENAME");
            this.depModuleId = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BMODULEID");
        }
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=2)
    public DB2PackageDepType getPackageDepType() {
        return this.packageDepType;
    }

    @Property(viewable=true, editable=false, order=3)
    public DB2Schema getDepSchema() {
        return this.depSchema;
    }

    @Property(viewable=true, editable=false, order=4)
    public DBSObject getDepObject(DBRProgressMonitor monitor) throws DBException {
        if (this.packageDepType == null || this.packageDepType.getDb2ObjectType() == null) {
            return null;
        }
        Object name = this.getName();
        if (this.depModuleName != null) {
            name = this.depModuleName + "." + (String)name;
        }
        return this.packageDepType.getDb2ObjectType().findObject(monitor, this.depSchema, (String)name);
    }

    @Property(viewable=true, editable=false, order=5)
    public String getVersion() {
        return this.version;
    }

    @Property(viewable=true, editable=false, order=6)
    public String getBinder() {
        return this.binder;
    }

    @Property(viewable=true, editable=false, order=7)
    public String getBinderType() {
        return this.binderType;
    }

    @Property(viewable=false, editable=false)
    public String getDepModuleId() {
        return this.depModuleId;
    }

    @Property(viewable=false, editable=false)
    public String getTabAuth() {
        return this.tabAuth;
    }

    @Property(viewable=false, editable=false)
    public String getVarAuth() {
        return this.varAuth;
    }
}

