package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExportProgress invokes the voicenavigator.DescribeExportProgress API synchronously
func (client *Client) DescribeExportProgress(request *DescribeExportProgressRequest) (response *DescribeExportProgressResponse, err error) {
	response = CreateDescribeExportProgressResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExportProgressWithChan invokes the voicenavigator.DescribeExportProgress API asynchronously
func (client *Client) DescribeExportProgressWithChan(request *DescribeExportProgressRequest) (<-chan *DescribeExportProgressResponse, <-chan error) {
	responseChan := make(chan *DescribeExportProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExportProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExportProgressWithCallback invokes the voicenavigator.DescribeExportProgress API asynchronously
func (client *Client) DescribeExportProgressWithCallback(request *DescribeExportProgressRequest, callback func(response *DescribeExportProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExportProgressResponse
		var err error
		defer close(result)
		response, err = client.DescribeExportProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExportProgressRequest is the request struct for api DescribeExportProgress
type DescribeExportProgressRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	ExportTaskId string `position:"Query" name:"ExportTaskId"`
}

// DescribeExportProgressResponse is the response struct for api DescribeExportProgress
type DescribeExportProgressResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Status      string `json:"Status" xml:"Status"`
	FileHttpUrl string `json:"FileHttpUrl" xml:"FileHttpUrl"`
}

// CreateDescribeExportProgressRequest creates a request to invoke DescribeExportProgress API
func CreateDescribeExportProgressRequest() (request *DescribeExportProgressRequest) {
	request = &DescribeExportProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "DescribeExportProgress", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeExportProgressResponse creates a response to parse from DescribeExportProgress response
func CreateDescribeExportProgressResponse() (response *DescribeExportProgressResponse) {
	response = &DescribeExportProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
