package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEndpointGroup invokes the ga.DescribeEndpointGroup API synchronously
func (client *Client) DescribeEndpointGroup(request *DescribeEndpointGroupRequest) (response *DescribeEndpointGroupResponse, err error) {
	response = CreateDescribeEndpointGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEndpointGroupWithChan invokes the ga.DescribeEndpointGroup API asynchronously
func (client *Client) DescribeEndpointGroupWithChan(request *DescribeEndpointGroupRequest) (<-chan *DescribeEndpointGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeEndpointGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEndpointGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEndpointGroupWithCallback invokes the ga.DescribeEndpointGroup API asynchronously
func (client *Client) DescribeEndpointGroupWithCallback(request *DescribeEndpointGroupRequest, callback func(response *DescribeEndpointGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEndpointGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeEndpointGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEndpointGroupRequest is the request struct for api DescribeEndpointGroup
type DescribeEndpointGroupRequest struct {
	*requests.RpcRequest
	EndpointGroupId string `position:"Query" name:"EndpointGroupId"`
}

// DescribeEndpointGroupResponse is the response struct for api DescribeEndpointGroup
type DescribeEndpointGroupResponse struct {
	*responses.BaseResponse
	HealthCheckIntervalSeconds int                          `json:"HealthCheckIntervalSeconds" xml:"HealthCheckIntervalSeconds"`
	TrafficPercentage          int                          `json:"TrafficPercentage" xml:"TrafficPercentage"`
	Description                string                       `json:"Description" xml:"Description"`
	EndpointGroupId            string                       `json:"EndpointGroupId" xml:"EndpointGroupId"`
	RequestId                  string                       `json:"RequestId" xml:"RequestId"`
	SlsRegion                  string                       `json:"SlsRegion" xml:"SlsRegion"`
	HealthCheckPath            string                       `json:"HealthCheckPath" xml:"HealthCheckPath"`
	ThresholdCount             int                          `json:"ThresholdCount" xml:"ThresholdCount"`
	SlsLogStoreName            string                       `json:"SlsLogStoreName" xml:"SlsLogStoreName"`
	EndpointRequestProtocol    string                       `json:"EndpointRequestProtocol" xml:"EndpointRequestProtocol"`
	Name                       string                       `json:"Name" xml:"Name"`
	EnableAccessLog            bool                         `json:"EnableAccessLog" xml:"EnableAccessLog"`
	TotalCount                 int                          `json:"TotalCount" xml:"TotalCount"`
	EndpointGroupRegion        string                       `json:"EndpointGroupRegion" xml:"EndpointGroupRegion"`
	SlsProjectName             string                       `json:"SlsProjectName" xml:"SlsProjectName"`
	State                      string                       `json:"State" xml:"State"`
	AccessLogSwitch            string                       `json:"AccessLogSwitch" xml:"AccessLogSwitch"`
	HealthCheckProtocol        string                       `json:"HealthCheckProtocol" xml:"HealthCheckProtocol"`
	HealthCheckPort            int                          `json:"HealthCheckPort" xml:"HealthCheckPort"`
	AcceleratorId              string                       `json:"AcceleratorId" xml:"AcceleratorId"`
	EndpointGroupType          string                       `json:"EndpointGroupType" xml:"EndpointGroupType"`
	ListenerId                 string                       `json:"ListenerId" xml:"ListenerId"`
	ForwardingRuleIds          []string                     `json:"ForwardingRuleIds" xml:"ForwardingRuleIds"`
	PortOverrides              []PortOverridesItem          `json:"PortOverrides" xml:"PortOverrides"`
	EndpointConfigurations     []EndpointConfigurationsItem `json:"EndpointConfigurations" xml:"EndpointConfigurations"`
}

// CreateDescribeEndpointGroupRequest creates a request to invoke DescribeEndpointGroup API
func CreateDescribeEndpointGroupRequest() (request *DescribeEndpointGroupRequest) {
	request = &DescribeEndpointGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "DescribeEndpointGroup", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEndpointGroupResponse creates a response to parse from DescribeEndpointGroup response
func CreateDescribeEndpointGroupResponse() (response *DescribeEndpointGroupResponse) {
	response = &DescribeEndpointGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
