package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGWSConnectTicket invokes the ehpc.GetGWSConnectTicket API synchronously
func (client *Client) GetGWSConnectTicket(request *GetGWSConnectTicketRequest) (response *GetGWSConnectTicketResponse, err error) {
	response = CreateGetGWSConnectTicketResponse()
	err = client.DoAction(request, response)
	return
}

// GetGWSConnectTicketWithChan invokes the ehpc.GetGWSConnectTicket API asynchronously
func (client *Client) GetGWSConnectTicketWithChan(request *GetGWSConnectTicketRequest) (<-chan *GetGWSConnectTicketResponse, <-chan error) {
	responseChan := make(chan *GetGWSConnectTicketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGWSConnectTicket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGWSConnectTicketWithCallback invokes the ehpc.GetGWSConnectTicket API asynchronously
func (client *Client) GetGWSConnectTicketWithCallback(request *GetGWSConnectTicketRequest, callback func(response *GetGWSConnectTicketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGWSConnectTicketResponse
		var err error
		defer close(result)
		response, err = client.GetGWSConnectTicket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGWSConnectTicketRequest is the request struct for api GetGWSConnectTicket
type GetGWSConnectTicketRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	AppName    string `position:"Query" name:"AppName"`
}

// GetGWSConnectTicketResponse is the response struct for api GetGWSConnectTicket
type GetGWSConnectTicketResponse struct {
	*responses.BaseResponse
	Ticket    string `json:"Ticket" xml:"Ticket"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetGWSConnectTicketRequest creates a request to invoke GetGWSConnectTicket API
func CreateGetGWSConnectTicketRequest() (request *GetGWSConnectTicketRequest) {
	request = &GetGWSConnectTicketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "GetGWSConnectTicket", "", "")
	request.Method = requests.GET
	return
}

// CreateGetGWSConnectTicketResponse creates a response to parse from GetGWSConnectTicket response
func CreateGetGWSConnectTicketResponse() (response *GetGWSConnectTicketResponse) {
	response = &GetGWSConnectTicketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
