package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTableLevel invokes the dataworks_public.DeleteTableLevel API synchronously
func (client *Client) DeleteTableLevel(request *DeleteTableLevelRequest) (response *DeleteTableLevelResponse, err error) {
	response = CreateDeleteTableLevelResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTableLevelWithChan invokes the dataworks_public.DeleteTableLevel API asynchronously
func (client *Client) DeleteTableLevelWithChan(request *DeleteTableLevelRequest) (<-chan *DeleteTableLevelResponse, <-chan error) {
	responseChan := make(chan *DeleteTableLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTableLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTableLevelWithCallback invokes the dataworks_public.DeleteTableLevel API asynchronously
func (client *Client) DeleteTableLevelWithCallback(request *DeleteTableLevelRequest, callback func(response *DeleteTableLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTableLevelResponse
		var err error
		defer close(result)
		response, err = client.DeleteTableLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTableLevelRequest is the request struct for api DeleteTableLevel
type DeleteTableLevelRequest struct {
	*requests.RpcRequest
	LevelId   requests.Integer `position:"Query" name:"LevelId"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
}

// DeleteTableLevelResponse is the response struct for api DeleteTableLevel
type DeleteTableLevelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DeleteResult bool   `json:"DeleteResult" xml:"DeleteResult"`
}

// CreateDeleteTableLevelRequest creates a request to invoke DeleteTableLevel API
func CreateDeleteTableLevelRequest() (request *DeleteTableLevelRequest) {
	request = &DeleteTableLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteTableLevel", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTableLevelResponse creates a response to parse from DeleteTableLevel response
func CreateDeleteTableLevelResponse() (response *DeleteTableLevelResponse) {
	response = &DeleteTableLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
