package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateKubernetesTrigger invokes the cs.CreateKubernetesTrigger API synchronously
func (client *Client) CreateKubernetesTrigger(request *CreateKubernetesTriggerRequest) (response *CreateKubernetesTriggerResponse, err error) {
	response = CreateCreateKubernetesTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateKubernetesTriggerWithChan invokes the cs.CreateKubernetesTrigger API asynchronously
func (client *Client) CreateKubernetesTriggerWithChan(request *CreateKubernetesTriggerRequest) (<-chan *CreateKubernetesTriggerResponse, <-chan error) {
	responseChan := make(chan *CreateKubernetesTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateKubernetesTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateKubernetesTriggerWithCallback invokes the cs.CreateKubernetesTrigger API asynchronously
func (client *Client) CreateKubernetesTriggerWithCallback(request *CreateKubernetesTriggerRequest, callback func(response *CreateKubernetesTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateKubernetesTriggerResponse
		var err error
		defer close(result)
		response, err = client.CreateKubernetesTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateKubernetesTriggerRequest is the request struct for api CreateKubernetesTrigger
type CreateKubernetesTriggerRequest struct {
	*requests.RoaRequest
}

// CreateKubernetesTriggerResponse is the response struct for api CreateKubernetesTrigger
type CreateKubernetesTriggerResponse struct {
	*responses.BaseResponse
	ClusterId string `json:"cluster_id" xml:"cluster_id"`
	ProjectId string `json:"project_id" xml:"project_id"`
	Action    string `json:"action" xml:"action"`
	Id        string `json:"id" xml:"id"`
	Type      string `json:"type" xml:"type"`
}

// CreateCreateKubernetesTriggerRequest creates a request to invoke CreateKubernetesTrigger API
func CreateCreateKubernetesTriggerRequest() (request *CreateKubernetesTriggerRequest) {
	request = &CreateKubernetesTriggerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "CreateKubernetesTrigger", "/triggers", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateKubernetesTriggerResponse creates a response to parse from CreateKubernetesTrigger response
func CreateCreateKubernetesTriggerResponse() (response *CreateKubernetesTriggerResponse) {
	response = &CreateKubernetesTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
