// @generated
impl serde::Serialize for ActiveSpeakerUpdate {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.speakers.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ActiveSpeakerUpdate", len)?;
        if !self.speakers.is_empty() {
            struct_ser.serialize_field("speakers", &self.speakers)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ActiveSpeakerUpdate {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "speakers",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Speakers,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "speakers" => Ok(GeneratedField::Speakers),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ActiveSpeakerUpdate;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ActiveSpeakerUpdate")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ActiveSpeakerUpdate, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut speakers__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Speakers => {
                            if speakers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("speakers"));
                            }
                            speakers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ActiveSpeakerUpdate {
                    speakers: speakers__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ActiveSpeakerUpdate", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AddTrackRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.cid.is_empty() {
            len += 1;
        }
        if !self.name.is_empty() {
            len += 1;
        }
        if self.r#type != 0 {
            len += 1;
        }
        if self.width != 0 {
            len += 1;
        }
        if self.height != 0 {
            len += 1;
        }
        if self.muted {
            len += 1;
        }
        if self.disable_dtx {
            len += 1;
        }
        if self.source != 0 {
            len += 1;
        }
        if !self.layers.is_empty() {
            len += 1;
        }
        if !self.simulcast_codecs.is_empty() {
            len += 1;
        }
        if !self.sid.is_empty() {
            len += 1;
        }
        if self.stereo {
            len += 1;
        }
        if self.disable_red {
            len += 1;
        }
        if self.encryption != 0 {
            len += 1;
        }
        if !self.stream.is_empty() {
            len += 1;
        }
        if self.backup_codec_policy != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AddTrackRequest", len)?;
        if !self.cid.is_empty() {
            struct_ser.serialize_field("cid", &self.cid)?;
        }
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if self.r#type != 0 {
            let v = TrackType::try_from(self.r#type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.r#type)))?;
            struct_ser.serialize_field("type", &v)?;
        }
        if self.width != 0 {
            struct_ser.serialize_field("width", &self.width)?;
        }
        if self.height != 0 {
            struct_ser.serialize_field("height", &self.height)?;
        }
        if self.muted {
            struct_ser.serialize_field("muted", &self.muted)?;
        }
        if self.disable_dtx {
            struct_ser.serialize_field("disableDtx", &self.disable_dtx)?;
        }
        if self.source != 0 {
            let v = TrackSource::try_from(self.source)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.source)))?;
            struct_ser.serialize_field("source", &v)?;
        }
        if !self.layers.is_empty() {
            struct_ser.serialize_field("layers", &self.layers)?;
        }
        if !self.simulcast_codecs.is_empty() {
            struct_ser.serialize_field("simulcastCodecs", &self.simulcast_codecs)?;
        }
        if !self.sid.is_empty() {
            struct_ser.serialize_field("sid", &self.sid)?;
        }
        if self.stereo {
            struct_ser.serialize_field("stereo", &self.stereo)?;
        }
        if self.disable_red {
            struct_ser.serialize_field("disableRed", &self.disable_red)?;
        }
        if self.encryption != 0 {
            let v = encryption::Type::try_from(self.encryption)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.encryption)))?;
            struct_ser.serialize_field("encryption", &v)?;
        }
        if !self.stream.is_empty() {
            struct_ser.serialize_field("stream", &self.stream)?;
        }
        if self.backup_codec_policy != 0 {
            let v = BackupCodecPolicy::try_from(self.backup_codec_policy)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.backup_codec_policy)))?;
            struct_ser.serialize_field("backupCodecPolicy", &v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AddTrackRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "cid",
            "name",
            "type",
            "width",
            "height",
            "muted",
            "disable_dtx",
            "disableDtx",
            "source",
            "layers",
            "simulcast_codecs",
            "simulcastCodecs",
            "sid",
            "stereo",
            "disable_red",
            "disableRed",
            "encryption",
            "stream",
            "backup_codec_policy",
            "backupCodecPolicy",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Cid,
            Name,
            Type,
            Width,
            Height,
            Muted,
            DisableDtx,
            Source,
            Layers,
            SimulcastCodecs,
            Sid,
            Stereo,
            DisableRed,
            Encryption,
            Stream,
            BackupCodecPolicy,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "cid" => Ok(GeneratedField::Cid),
                            "name" => Ok(GeneratedField::Name),
                            "type" => Ok(GeneratedField::Type),
                            "width" => Ok(GeneratedField::Width),
                            "height" => Ok(GeneratedField::Height),
                            "muted" => Ok(GeneratedField::Muted),
                            "disableDtx" | "disable_dtx" => Ok(GeneratedField::DisableDtx),
                            "source" => Ok(GeneratedField::Source),
                            "layers" => Ok(GeneratedField::Layers),
                            "simulcastCodecs" | "simulcast_codecs" => Ok(GeneratedField::SimulcastCodecs),
                            "sid" => Ok(GeneratedField::Sid),
                            "stereo" => Ok(GeneratedField::Stereo),
                            "disableRed" | "disable_red" => Ok(GeneratedField::DisableRed),
                            "encryption" => Ok(GeneratedField::Encryption),
                            "stream" => Ok(GeneratedField::Stream),
                            "backupCodecPolicy" | "backup_codec_policy" => Ok(GeneratedField::BackupCodecPolicy),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AddTrackRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AddTrackRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AddTrackRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut cid__ = None;
                let mut name__ = None;
                let mut r#type__ = None;
                let mut width__ = None;
                let mut height__ = None;
                let mut muted__ = None;
                let mut disable_dtx__ = None;
                let mut source__ = None;
                let mut layers__ = None;
                let mut simulcast_codecs__ = None;
                let mut sid__ = None;
                let mut stereo__ = None;
                let mut disable_red__ = None;
                let mut encryption__ = None;
                let mut stream__ = None;
                let mut backup_codec_policy__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Cid => {
                            if cid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("cid"));
                            }
                            cid__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Type => {
                            if r#type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("type"));
                            }
                            r#type__ = Some(map_.next_value::<TrackType>()? as i32);
                        }
                        GeneratedField::Width => {
                            if width__.is_some() {
                                return Err(serde::de::Error::duplicate_field("width"));
                            }
                            width__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Height => {
                            if height__.is_some() {
                                return Err(serde::de::Error::duplicate_field("height"));
                            }
                            height__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Muted => {
                            if muted__.is_some() {
                                return Err(serde::de::Error::duplicate_field("muted"));
                            }
                            muted__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DisableDtx => {
                            if disable_dtx__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disableDtx"));
                            }
                            disable_dtx__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Source => {
                            if source__.is_some() {
                                return Err(serde::de::Error::duplicate_field("source"));
                            }
                            source__ = Some(map_.next_value::<TrackSource>()? as i32);
                        }
                        GeneratedField::Layers => {
                            if layers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("layers"));
                            }
                            layers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SimulcastCodecs => {
                            if simulcast_codecs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("simulcastCodecs"));
                            }
                            simulcast_codecs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Sid => {
                            if sid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sid"));
                            }
                            sid__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Stereo => {
                            if stereo__.is_some() {
                                return Err(serde::de::Error::duplicate_field("stereo"));
                            }
                            stereo__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DisableRed => {
                            if disable_red__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disableRed"));
                            }
                            disable_red__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Encryption => {
                            if encryption__.is_some() {
                                return Err(serde::de::Error::duplicate_field("encryption"));
                            }
                            encryption__ = Some(map_.next_value::<encryption::Type>()? as i32);
                        }
                        GeneratedField::Stream => {
                            if stream__.is_some() {
                                return Err(serde::de::Error::duplicate_field("stream"));
                            }
                            stream__ = Some(map_.next_value()?);
                        }
                        GeneratedField::BackupCodecPolicy => {
                            if backup_codec_policy__.is_some() {
                                return Err(serde::de::Error::duplicate_field("backupCodecPolicy"));
                            }
                            backup_codec_policy__ = Some(map_.next_value::<BackupCodecPolicy>()? as i32);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AddTrackRequest {
                    cid: cid__.unwrap_or_default(),
                    name: name__.unwrap_or_default(),
                    r#type: r#type__.unwrap_or_default(),
                    width: width__.unwrap_or_default(),
                    height: height__.unwrap_or_default(),
                    muted: muted__.unwrap_or_default(),
                    disable_dtx: disable_dtx__.unwrap_or_default(),
                    source: source__.unwrap_or_default(),
                    layers: layers__.unwrap_or_default(),
                    simulcast_codecs: simulcast_codecs__.unwrap_or_default(),
                    sid: sid__.unwrap_or_default(),
                    stereo: stereo__.unwrap_or_default(),
                    disable_red: disable_red__.unwrap_or_default(),
                    encryption: encryption__.unwrap_or_default(),
                    stream: stream__.unwrap_or_default(),
                    backup_codec_policy: backup_codec_policy__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.AddTrackRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AgentDispatch {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.id.is_empty() {
            len += 1;
        }
        if !self.agent_name.is_empty() {
            len += 1;
        }
        if !self.room.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        if self.state.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AgentDispatch", len)?;
        if !self.id.is_empty() {
            struct_ser.serialize_field("id", &self.id)?;
        }
        if !self.agent_name.is_empty() {
            struct_ser.serialize_field("agentName", &self.agent_name)?;
        }
        if !self.room.is_empty() {
            struct_ser.serialize_field("room", &self.room)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        if let Some(v) = self.state.as_ref() {
            struct_ser.serialize_field("state", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AgentDispatch {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "id",
            "agent_name",
            "agentName",
            "room",
            "metadata",
            "state",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Id,
            AgentName,
            Room,
            Metadata,
            State,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "id" => Ok(GeneratedField::Id),
                            "agentName" | "agent_name" => Ok(GeneratedField::AgentName),
                            "room" => Ok(GeneratedField::Room),
                            "metadata" => Ok(GeneratedField::Metadata),
                            "state" => Ok(GeneratedField::State),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AgentDispatch;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AgentDispatch")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AgentDispatch, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut id__ = None;
                let mut agent_name__ = None;
                let mut room__ = None;
                let mut metadata__ = None;
                let mut state__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Id => {
                            if id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("id"));
                            }
                            id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AgentName => {
                            if agent_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agentName"));
                            }
                            agent_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::State => {
                            if state__.is_some() {
                                return Err(serde::de::Error::duplicate_field("state"));
                            }
                            state__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AgentDispatch {
                    id: id__.unwrap_or_default(),
                    agent_name: agent_name__.unwrap_or_default(),
                    room: room__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                    state: state__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.AgentDispatch", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AgentDispatchState {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.jobs.is_empty() {
            len += 1;
        }
        if self.created_at != 0 {
            len += 1;
        }
        if self.deleted_at != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AgentDispatchState", len)?;
        if !self.jobs.is_empty() {
            struct_ser.serialize_field("jobs", &self.jobs)?;
        }
        if self.created_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("createdAt", ToString::to_string(&self.created_at).as_str())?;
        }
        if self.deleted_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("deletedAt", ToString::to_string(&self.deleted_at).as_str())?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AgentDispatchState {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "jobs",
            "created_at",
            "createdAt",
            "deleted_at",
            "deletedAt",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Jobs,
            CreatedAt,
            DeletedAt,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "jobs" => Ok(GeneratedField::Jobs),
                            "createdAt" | "created_at" => Ok(GeneratedField::CreatedAt),
                            "deletedAt" | "deleted_at" => Ok(GeneratedField::DeletedAt),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AgentDispatchState;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AgentDispatchState")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AgentDispatchState, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut jobs__ = None;
                let mut created_at__ = None;
                let mut deleted_at__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Jobs => {
                            if jobs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("jobs"));
                            }
                            jobs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::CreatedAt => {
                            if created_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("createdAt"));
                            }
                            created_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DeletedAt => {
                            if deleted_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("deletedAt"));
                            }
                            deleted_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AgentDispatchState {
                    jobs: jobs__.unwrap_or_default(),
                    created_at: created_at__.unwrap_or_default(),
                    deleted_at: deleted_at__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.AgentDispatchState", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AliOssUpload {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.access_key.is_empty() {
            len += 1;
        }
        if !self.secret.is_empty() {
            len += 1;
        }
        if !self.region.is_empty() {
            len += 1;
        }
        if !self.endpoint.is_empty() {
            len += 1;
        }
        if !self.bucket.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AliOSSUpload", len)?;
        if !self.access_key.is_empty() {
            struct_ser.serialize_field("accessKey", &self.access_key)?;
        }
        if !self.secret.is_empty() {
            struct_ser.serialize_field("secret", &self.secret)?;
        }
        if !self.region.is_empty() {
            struct_ser.serialize_field("region", &self.region)?;
        }
        if !self.endpoint.is_empty() {
            struct_ser.serialize_field("endpoint", &self.endpoint)?;
        }
        if !self.bucket.is_empty() {
            struct_ser.serialize_field("bucket", &self.bucket)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AliOssUpload {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "access_key",
            "accessKey",
            "secret",
            "region",
            "endpoint",
            "bucket",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            AccessKey,
            Secret,
            Region,
            Endpoint,
            Bucket,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "accessKey" | "access_key" => Ok(GeneratedField::AccessKey),
                            "secret" => Ok(GeneratedField::Secret),
                            "region" => Ok(GeneratedField::Region),
                            "endpoint" => Ok(GeneratedField::Endpoint),
                            "bucket" => Ok(GeneratedField::Bucket),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AliOssUpload;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AliOSSUpload")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AliOssUpload, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut access_key__ = None;
                let mut secret__ = None;
                let mut region__ = None;
                let mut endpoint__ = None;
                let mut bucket__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::AccessKey => {
                            if access_key__.is_some() {
                                return Err(serde::de::Error::duplicate_field("accessKey"));
                            }
                            access_key__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Secret => {
                            if secret__.is_some() {
                                return Err(serde::de::Error::duplicate_field("secret"));
                            }
                            secret__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Region => {
                            if region__.is_some() {
                                return Err(serde::de::Error::duplicate_field("region"));
                            }
                            region__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Endpoint => {
                            if endpoint__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endpoint"));
                            }
                            endpoint__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Bucket => {
                            if bucket__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bucket"));
                            }
                            bucket__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AliOssUpload {
                    access_key: access_key__.unwrap_or_default(),
                    secret: secret__.unwrap_or_default(),
                    region: region__.unwrap_or_default(),
                    endpoint: endpoint__.unwrap_or_default(),
                    bucket: bucket__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.AliOSSUpload", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AudioCodec {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::DefaultAc => "DEFAULT_AC",
            Self::Opus => "OPUS",
            Self::Aac => "AAC",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for AudioCodec {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "DEFAULT_AC",
            "OPUS",
            "AAC",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AudioCodec;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "DEFAULT_AC" => Ok(AudioCodec::DefaultAc),
                    "OPUS" => Ok(AudioCodec::Opus),
                    "AAC" => Ok(AudioCodec::Aac),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for AudioMixing {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::DefaultMixing => "DEFAULT_MIXING",
            Self::DualChannelAgent => "DUAL_CHANNEL_AGENT",
            Self::DualChannelAlternate => "DUAL_CHANNEL_ALTERNATE",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for AudioMixing {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "DEFAULT_MIXING",
            "DUAL_CHANNEL_AGENT",
            "DUAL_CHANNEL_ALTERNATE",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AudioMixing;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "DEFAULT_MIXING" => Ok(AudioMixing::DefaultMixing),
                    "DUAL_CHANNEL_AGENT" => Ok(AudioMixing::DualChannelAgent),
                    "DUAL_CHANNEL_ALTERNATE" => Ok(AudioMixing::DualChannelAlternate),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for AudioTrackFeature {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::TfStereo => "TF_STEREO",
            Self::TfNoDtx => "TF_NO_DTX",
            Self::TfAutoGainControl => "TF_AUTO_GAIN_CONTROL",
            Self::TfEchoCancellation => "TF_ECHO_CANCELLATION",
            Self::TfNoiseSuppression => "TF_NOISE_SUPPRESSION",
            Self::TfEnhancedNoiseCancellation => "TF_ENHANCED_NOISE_CANCELLATION",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for AudioTrackFeature {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "TF_STEREO",
            "TF_NO_DTX",
            "TF_AUTO_GAIN_CONTROL",
            "TF_ECHO_CANCELLATION",
            "TF_NOISE_SUPPRESSION",
            "TF_ENHANCED_NOISE_CANCELLATION",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AudioTrackFeature;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "TF_STEREO" => Ok(AudioTrackFeature::TfStereo),
                    "TF_NO_DTX" => Ok(AudioTrackFeature::TfNoDtx),
                    "TF_AUTO_GAIN_CONTROL" => Ok(AudioTrackFeature::TfAutoGainControl),
                    "TF_ECHO_CANCELLATION" => Ok(AudioTrackFeature::TfEchoCancellation),
                    "TF_NOISE_SUPPRESSION" => Ok(AudioTrackFeature::TfNoiseSuppression),
                    "TF_ENHANCED_NOISE_CANCELLATION" => Ok(AudioTrackFeature::TfEnhancedNoiseCancellation),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for AutoParticipantEgress {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.file_outputs.is_empty() {
            len += 1;
        }
        if !self.segment_outputs.is_empty() {
            len += 1;
        }
        if self.options.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AutoParticipantEgress", len)?;
        if !self.file_outputs.is_empty() {
            struct_ser.serialize_field("fileOutputs", &self.file_outputs)?;
        }
        if !self.segment_outputs.is_empty() {
            struct_ser.serialize_field("segmentOutputs", &self.segment_outputs)?;
        }
        if let Some(v) = self.options.as_ref() {
            match v {
                auto_participant_egress::Options::Preset(v) => {
                    let v = EncodingOptionsPreset::try_from(*v)
                        .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", *v)))?;
                    struct_ser.serialize_field("preset", &v)?;
                }
                auto_participant_egress::Options::Advanced(v) => {
                    struct_ser.serialize_field("advanced", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AutoParticipantEgress {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "file_outputs",
            "fileOutputs",
            "segment_outputs",
            "segmentOutputs",
            "preset",
            "advanced",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            FileOutputs,
            SegmentOutputs,
            Preset,
            Advanced,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "fileOutputs" | "file_outputs" => Ok(GeneratedField::FileOutputs),
                            "segmentOutputs" | "segment_outputs" => Ok(GeneratedField::SegmentOutputs),
                            "preset" => Ok(GeneratedField::Preset),
                            "advanced" => Ok(GeneratedField::Advanced),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AutoParticipantEgress;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AutoParticipantEgress")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AutoParticipantEgress, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut file_outputs__ = None;
                let mut segment_outputs__ = None;
                let mut options__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::FileOutputs => {
                            if file_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("fileOutputs"));
                            }
                            file_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SegmentOutputs => {
                            if segment_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("segmentOutputs"));
                            }
                            segment_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Preset => {
                            if options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("preset"));
                            }
                            options__ = map_.next_value::<::std::option::Option<EncodingOptionsPreset>>()?.map(|x| auto_participant_egress::Options::Preset(x as i32));
                        }
                        GeneratedField::Advanced => {
                            if options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("advanced"));
                            }
                            options__ = map_.next_value::<::std::option::Option<_>>()?.map(auto_participant_egress::Options::Advanced)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AutoParticipantEgress {
                    file_outputs: file_outputs__.unwrap_or_default(),
                    segment_outputs: segment_outputs__.unwrap_or_default(),
                    options: options__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.AutoParticipantEgress", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AutoTrackEgress {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.filepath.is_empty() {
            len += 1;
        }
        if self.disable_manifest {
            len += 1;
        }
        if self.output.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AutoTrackEgress", len)?;
        if !self.filepath.is_empty() {
            struct_ser.serialize_field("filepath", &self.filepath)?;
        }
        if self.disable_manifest {
            struct_ser.serialize_field("disableManifest", &self.disable_manifest)?;
        }
        if let Some(v) = self.output.as_ref() {
            match v {
                auto_track_egress::Output::S3(v) => {
                    struct_ser.serialize_field("s3", v)?;
                }
                auto_track_egress::Output::Gcp(v) => {
                    struct_ser.serialize_field("gcp", v)?;
                }
                auto_track_egress::Output::Azure(v) => {
                    struct_ser.serialize_field("azure", v)?;
                }
                auto_track_egress::Output::AliOss(v) => {
                    struct_ser.serialize_field("aliOSS", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AutoTrackEgress {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "filepath",
            "disable_manifest",
            "disableManifest",
            "s3",
            "gcp",
            "azure",
            "aliOSS",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Filepath,
            DisableManifest,
            S3,
            Gcp,
            Azure,
            AliOss,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "filepath" => Ok(GeneratedField::Filepath),
                            "disableManifest" | "disable_manifest" => Ok(GeneratedField::DisableManifest),
                            "s3" => Ok(GeneratedField::S3),
                            "gcp" => Ok(GeneratedField::Gcp),
                            "azure" => Ok(GeneratedField::Azure),
                            "aliOSS" => Ok(GeneratedField::AliOss),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AutoTrackEgress;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AutoTrackEgress")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AutoTrackEgress, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut filepath__ = None;
                let mut disable_manifest__ = None;
                let mut output__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Filepath => {
                            if filepath__.is_some() {
                                return Err(serde::de::Error::duplicate_field("filepath"));
                            }
                            filepath__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DisableManifest => {
                            if disable_manifest__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disableManifest"));
                            }
                            disable_manifest__ = Some(map_.next_value()?);
                        }
                        GeneratedField::S3 => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("s3"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(auto_track_egress::Output::S3)
;
                        }
                        GeneratedField::Gcp => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("gcp"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(auto_track_egress::Output::Gcp)
;
                        }
                        GeneratedField::Azure => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("azure"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(auto_track_egress::Output::Azure)
;
                        }
                        GeneratedField::AliOss => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("aliOSS"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(auto_track_egress::Output::AliOss)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AutoTrackEgress {
                    filepath: filepath__.unwrap_or_default(),
                    disable_manifest: disable_manifest__.unwrap_or_default(),
                    output: output__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.AutoTrackEgress", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AvailabilityRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.job.is_some() {
            len += 1;
        }
        if self.resuming {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AvailabilityRequest", len)?;
        if let Some(v) = self.job.as_ref() {
            struct_ser.serialize_field("job", v)?;
        }
        if self.resuming {
            struct_ser.serialize_field("resuming", &self.resuming)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AvailabilityRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "job",
            "resuming",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Job,
            Resuming,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "job" => Ok(GeneratedField::Job),
                            "resuming" => Ok(GeneratedField::Resuming),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AvailabilityRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AvailabilityRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AvailabilityRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut job__ = None;
                let mut resuming__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Job => {
                            if job__.is_some() {
                                return Err(serde::de::Error::duplicate_field("job"));
                            }
                            job__ = map_.next_value()?;
                        }
                        GeneratedField::Resuming => {
                            if resuming__.is_some() {
                                return Err(serde::de::Error::duplicate_field("resuming"));
                            }
                            resuming__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AvailabilityRequest {
                    job: job__,
                    resuming: resuming__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.AvailabilityRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AvailabilityResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.job_id.is_empty() {
            len += 1;
        }
        if self.available {
            len += 1;
        }
        if self.supports_resume {
            len += 1;
        }
        if !self.participant_name.is_empty() {
            len += 1;
        }
        if !self.participant_identity.is_empty() {
            len += 1;
        }
        if !self.participant_metadata.is_empty() {
            len += 1;
        }
        if !self.participant_attributes.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AvailabilityResponse", len)?;
        if !self.job_id.is_empty() {
            struct_ser.serialize_field("jobId", &self.job_id)?;
        }
        if self.available {
            struct_ser.serialize_field("available", &self.available)?;
        }
        if self.supports_resume {
            struct_ser.serialize_field("supportsResume", &self.supports_resume)?;
        }
        if !self.participant_name.is_empty() {
            struct_ser.serialize_field("participantName", &self.participant_name)?;
        }
        if !self.participant_identity.is_empty() {
            struct_ser.serialize_field("participantIdentity", &self.participant_identity)?;
        }
        if !self.participant_metadata.is_empty() {
            struct_ser.serialize_field("participantMetadata", &self.participant_metadata)?;
        }
        if !self.participant_attributes.is_empty() {
            struct_ser.serialize_field("participantAttributes", &self.participant_attributes)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AvailabilityResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "job_id",
            "jobId",
            "available",
            "supports_resume",
            "supportsResume",
            "participant_name",
            "participantName",
            "participant_identity",
            "participantIdentity",
            "participant_metadata",
            "participantMetadata",
            "participant_attributes",
            "participantAttributes",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            JobId,
            Available,
            SupportsResume,
            ParticipantName,
            ParticipantIdentity,
            ParticipantMetadata,
            ParticipantAttributes,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "jobId" | "job_id" => Ok(GeneratedField::JobId),
                            "available" => Ok(GeneratedField::Available),
                            "supportsResume" | "supports_resume" => Ok(GeneratedField::SupportsResume),
                            "participantName" | "participant_name" => Ok(GeneratedField::ParticipantName),
                            "participantIdentity" | "participant_identity" => Ok(GeneratedField::ParticipantIdentity),
                            "participantMetadata" | "participant_metadata" => Ok(GeneratedField::ParticipantMetadata),
                            "participantAttributes" | "participant_attributes" => Ok(GeneratedField::ParticipantAttributes),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AvailabilityResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AvailabilityResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AvailabilityResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut job_id__ = None;
                let mut available__ = None;
                let mut supports_resume__ = None;
                let mut participant_name__ = None;
                let mut participant_identity__ = None;
                let mut participant_metadata__ = None;
                let mut participant_attributes__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::JobId => {
                            if job_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("jobId"));
                            }
                            job_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Available => {
                            if available__.is_some() {
                                return Err(serde::de::Error::duplicate_field("available"));
                            }
                            available__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SupportsResume => {
                            if supports_resume__.is_some() {
                                return Err(serde::de::Error::duplicate_field("supportsResume"));
                            }
                            supports_resume__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantName => {
                            if participant_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantName"));
                            }
                            participant_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantIdentity => {
                            if participant_identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantIdentity"));
                            }
                            participant_identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantMetadata => {
                            if participant_metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantMetadata"));
                            }
                            participant_metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantAttributes => {
                            if participant_attributes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantAttributes"));
                            }
                            participant_attributes__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AvailabilityResponse {
                    job_id: job_id__.unwrap_or_default(),
                    available: available__.unwrap_or_default(),
                    supports_resume: supports_resume__.unwrap_or_default(),
                    participant_name: participant_name__.unwrap_or_default(),
                    participant_identity: participant_identity__.unwrap_or_default(),
                    participant_metadata: participant_metadata__.unwrap_or_default(),
                    participant_attributes: participant_attributes__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.AvailabilityResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for AzureBlobUpload {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.account_name.is_empty() {
            len += 1;
        }
        if !self.account_key.is_empty() {
            len += 1;
        }
        if !self.container_name.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.AzureBlobUpload", len)?;
        if !self.account_name.is_empty() {
            struct_ser.serialize_field("accountName", &self.account_name)?;
        }
        if !self.account_key.is_empty() {
            struct_ser.serialize_field("accountKey", &self.account_key)?;
        }
        if !self.container_name.is_empty() {
            struct_ser.serialize_field("containerName", &self.container_name)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for AzureBlobUpload {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "account_name",
            "accountName",
            "account_key",
            "accountKey",
            "container_name",
            "containerName",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            AccountName,
            AccountKey,
            ContainerName,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "accountName" | "account_name" => Ok(GeneratedField::AccountName),
                            "accountKey" | "account_key" => Ok(GeneratedField::AccountKey),
                            "containerName" | "container_name" => Ok(GeneratedField::ContainerName),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = AzureBlobUpload;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.AzureBlobUpload")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<AzureBlobUpload, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut account_name__ = None;
                let mut account_key__ = None;
                let mut container_name__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::AccountName => {
                            if account_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("accountName"));
                            }
                            account_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AccountKey => {
                            if account_key__.is_some() {
                                return Err(serde::de::Error::duplicate_field("accountKey"));
                            }
                            account_key__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ContainerName => {
                            if container_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("containerName"));
                            }
                            container_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(AzureBlobUpload {
                    account_name: account_name__.unwrap_or_default(),
                    account_key: account_key__.unwrap_or_default(),
                    container_name: container_name__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.AzureBlobUpload", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for BackupCodecPolicy {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Regression => "REGRESSION",
            Self::Simulcast => "SIMULCAST",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for BackupCodecPolicy {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "REGRESSION",
            "SIMULCAST",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = BackupCodecPolicy;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "REGRESSION" => Ok(BackupCodecPolicy::Regression),
                    "SIMULCAST" => Ok(BackupCodecPolicy::Simulcast),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for CandidateProtocol {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Udp => "UDP",
            Self::Tcp => "TCP",
            Self::Tls => "TLS",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for CandidateProtocol {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "UDP",
            "TCP",
            "TLS",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CandidateProtocol;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "UDP" => Ok(CandidateProtocol::Udp),
                    "TCP" => Ok(CandidateProtocol::Tcp),
                    "TLS" => Ok(CandidateProtocol::Tls),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for ChatMessage {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.id.is_empty() {
            len += 1;
        }
        if self.timestamp != 0 {
            len += 1;
        }
        if self.edit_timestamp.is_some() {
            len += 1;
        }
        if !self.message.is_empty() {
            len += 1;
        }
        if self.deleted {
            len += 1;
        }
        if self.generated {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ChatMessage", len)?;
        if !self.id.is_empty() {
            struct_ser.serialize_field("id", &self.id)?;
        }
        if self.timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("timestamp", ToString::to_string(&self.timestamp).as_str())?;
        }
        if let Some(v) = self.edit_timestamp.as_ref() {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("editTimestamp", ToString::to_string(&v).as_str())?;
        }
        if !self.message.is_empty() {
            struct_ser.serialize_field("message", &self.message)?;
        }
        if self.deleted {
            struct_ser.serialize_field("deleted", &self.deleted)?;
        }
        if self.generated {
            struct_ser.serialize_field("generated", &self.generated)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ChatMessage {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "id",
            "timestamp",
            "edit_timestamp",
            "editTimestamp",
            "message",
            "deleted",
            "generated",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Id,
            Timestamp,
            EditTimestamp,
            Message,
            Deleted,
            Generated,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "id" => Ok(GeneratedField::Id),
                            "timestamp" => Ok(GeneratedField::Timestamp),
                            "editTimestamp" | "edit_timestamp" => Ok(GeneratedField::EditTimestamp),
                            "message" => Ok(GeneratedField::Message),
                            "deleted" => Ok(GeneratedField::Deleted),
                            "generated" => Ok(GeneratedField::Generated),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ChatMessage;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ChatMessage")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ChatMessage, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut id__ = None;
                let mut timestamp__ = None;
                let mut edit_timestamp__ = None;
                let mut message__ = None;
                let mut deleted__ = None;
                let mut generated__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Id => {
                            if id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("id"));
                            }
                            id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Timestamp => {
                            if timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("timestamp"));
                            }
                            timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EditTimestamp => {
                            if edit_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("editTimestamp"));
                            }
                            edit_timestamp__ = 
                                map_.next_value::<::std::option::Option<::pbjson::private::NumberDeserialize<_>>>()?.map(|x| x.0)
                            ;
                        }
                        GeneratedField::Message => {
                            if message__.is_some() {
                                return Err(serde::de::Error::duplicate_field("message"));
                            }
                            message__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Deleted => {
                            if deleted__.is_some() {
                                return Err(serde::de::Error::duplicate_field("deleted"));
                            }
                            deleted__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Generated => {
                            if generated__.is_some() {
                                return Err(serde::de::Error::duplicate_field("generated"));
                            }
                            generated__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ChatMessage {
                    id: id__.unwrap_or_default(),
                    timestamp: timestamp__.unwrap_or_default(),
                    edit_timestamp: edit_timestamp__,
                    message: message__.unwrap_or_default(),
                    deleted: deleted__.unwrap_or_default(),
                    generated: generated__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ChatMessage", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ClientConfigSetting {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Unset => "UNSET",
            Self::Disabled => "DISABLED",
            Self::Enabled => "ENABLED",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for ClientConfigSetting {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "UNSET",
            "DISABLED",
            "ENABLED",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ClientConfigSetting;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "UNSET" => Ok(ClientConfigSetting::Unset),
                    "DISABLED" => Ok(ClientConfigSetting::Disabled),
                    "ENABLED" => Ok(ClientConfigSetting::Enabled),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for ClientConfiguration {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.video.is_some() {
            len += 1;
        }
        if self.screen.is_some() {
            len += 1;
        }
        if self.resume_connection != 0 {
            len += 1;
        }
        if self.disabled_codecs.is_some() {
            len += 1;
        }
        if self.force_relay != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ClientConfiguration", len)?;
        if let Some(v) = self.video.as_ref() {
            struct_ser.serialize_field("video", v)?;
        }
        if let Some(v) = self.screen.as_ref() {
            struct_ser.serialize_field("screen", v)?;
        }
        if self.resume_connection != 0 {
            let v = ClientConfigSetting::try_from(self.resume_connection)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.resume_connection)))?;
            struct_ser.serialize_field("resumeConnection", &v)?;
        }
        if let Some(v) = self.disabled_codecs.as_ref() {
            struct_ser.serialize_field("disabledCodecs", v)?;
        }
        if self.force_relay != 0 {
            let v = ClientConfigSetting::try_from(self.force_relay)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.force_relay)))?;
            struct_ser.serialize_field("forceRelay", &v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ClientConfiguration {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "video",
            "screen",
            "resume_connection",
            "resumeConnection",
            "disabled_codecs",
            "disabledCodecs",
            "force_relay",
            "forceRelay",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Video,
            Screen,
            ResumeConnection,
            DisabledCodecs,
            ForceRelay,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "video" => Ok(GeneratedField::Video),
                            "screen" => Ok(GeneratedField::Screen),
                            "resumeConnection" | "resume_connection" => Ok(GeneratedField::ResumeConnection),
                            "disabledCodecs" | "disabled_codecs" => Ok(GeneratedField::DisabledCodecs),
                            "forceRelay" | "force_relay" => Ok(GeneratedField::ForceRelay),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ClientConfiguration;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ClientConfiguration")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ClientConfiguration, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut video__ = None;
                let mut screen__ = None;
                let mut resume_connection__ = None;
                let mut disabled_codecs__ = None;
                let mut force_relay__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Video => {
                            if video__.is_some() {
                                return Err(serde::de::Error::duplicate_field("video"));
                            }
                            video__ = map_.next_value()?;
                        }
                        GeneratedField::Screen => {
                            if screen__.is_some() {
                                return Err(serde::de::Error::duplicate_field("screen"));
                            }
                            screen__ = map_.next_value()?;
                        }
                        GeneratedField::ResumeConnection => {
                            if resume_connection__.is_some() {
                                return Err(serde::de::Error::duplicate_field("resumeConnection"));
                            }
                            resume_connection__ = Some(map_.next_value::<ClientConfigSetting>()? as i32);
                        }
                        GeneratedField::DisabledCodecs => {
                            if disabled_codecs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disabledCodecs"));
                            }
                            disabled_codecs__ = map_.next_value()?;
                        }
                        GeneratedField::ForceRelay => {
                            if force_relay__.is_some() {
                                return Err(serde::de::Error::duplicate_field("forceRelay"));
                            }
                            force_relay__ = Some(map_.next_value::<ClientConfigSetting>()? as i32);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ClientConfiguration {
                    video: video__,
                    screen: screen__,
                    resume_connection: resume_connection__.unwrap_or_default(),
                    disabled_codecs: disabled_codecs__,
                    force_relay: force_relay__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ClientConfiguration", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ClientInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.sdk != 0 {
            len += 1;
        }
        if !self.version.is_empty() {
            len += 1;
        }
        if self.protocol != 0 {
            len += 1;
        }
        if !self.os.is_empty() {
            len += 1;
        }
        if !self.os_version.is_empty() {
            len += 1;
        }
        if !self.device_model.is_empty() {
            len += 1;
        }
        if !self.browser.is_empty() {
            len += 1;
        }
        if !self.browser_version.is_empty() {
            len += 1;
        }
        if !self.address.is_empty() {
            len += 1;
        }
        if !self.network.is_empty() {
            len += 1;
        }
        if !self.other_sdks.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ClientInfo", len)?;
        if self.sdk != 0 {
            let v = client_info::Sdk::try_from(self.sdk)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.sdk)))?;
            struct_ser.serialize_field("sdk", &v)?;
        }
        if !self.version.is_empty() {
            struct_ser.serialize_field("version", &self.version)?;
        }
        if self.protocol != 0 {
            struct_ser.serialize_field("protocol", &self.protocol)?;
        }
        if !self.os.is_empty() {
            struct_ser.serialize_field("os", &self.os)?;
        }
        if !self.os_version.is_empty() {
            struct_ser.serialize_field("osVersion", &self.os_version)?;
        }
        if !self.device_model.is_empty() {
            struct_ser.serialize_field("deviceModel", &self.device_model)?;
        }
        if !self.browser.is_empty() {
            struct_ser.serialize_field("browser", &self.browser)?;
        }
        if !self.browser_version.is_empty() {
            struct_ser.serialize_field("browserVersion", &self.browser_version)?;
        }
        if !self.address.is_empty() {
            struct_ser.serialize_field("address", &self.address)?;
        }
        if !self.network.is_empty() {
            struct_ser.serialize_field("network", &self.network)?;
        }
        if !self.other_sdks.is_empty() {
            struct_ser.serialize_field("otherSdks", &self.other_sdks)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ClientInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sdk",
            "version",
            "protocol",
            "os",
            "os_version",
            "osVersion",
            "device_model",
            "deviceModel",
            "browser",
            "browser_version",
            "browserVersion",
            "address",
            "network",
            "other_sdks",
            "otherSdks",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Sdk,
            Version,
            Protocol,
            Os,
            OsVersion,
            DeviceModel,
            Browser,
            BrowserVersion,
            Address,
            Network,
            OtherSdks,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sdk" => Ok(GeneratedField::Sdk),
                            "version" => Ok(GeneratedField::Version),
                            "protocol" => Ok(GeneratedField::Protocol),
                            "os" => Ok(GeneratedField::Os),
                            "osVersion" | "os_version" => Ok(GeneratedField::OsVersion),
                            "deviceModel" | "device_model" => Ok(GeneratedField::DeviceModel),
                            "browser" => Ok(GeneratedField::Browser),
                            "browserVersion" | "browser_version" => Ok(GeneratedField::BrowserVersion),
                            "address" => Ok(GeneratedField::Address),
                            "network" => Ok(GeneratedField::Network),
                            "otherSdks" | "other_sdks" => Ok(GeneratedField::OtherSdks),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ClientInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ClientInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ClientInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sdk__ = None;
                let mut version__ = None;
                let mut protocol__ = None;
                let mut os__ = None;
                let mut os_version__ = None;
                let mut device_model__ = None;
                let mut browser__ = None;
                let mut browser_version__ = None;
                let mut address__ = None;
                let mut network__ = None;
                let mut other_sdks__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Sdk => {
                            if sdk__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sdk"));
                            }
                            sdk__ = Some(map_.next_value::<client_info::Sdk>()? as i32);
                        }
                        GeneratedField::Version => {
                            if version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("version"));
                            }
                            version__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Protocol => {
                            if protocol__.is_some() {
                                return Err(serde::de::Error::duplicate_field("protocol"));
                            }
                            protocol__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Os => {
                            if os__.is_some() {
                                return Err(serde::de::Error::duplicate_field("os"));
                            }
                            os__ = Some(map_.next_value()?);
                        }
                        GeneratedField::OsVersion => {
                            if os_version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("osVersion"));
                            }
                            os_version__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DeviceModel => {
                            if device_model__.is_some() {
                                return Err(serde::de::Error::duplicate_field("deviceModel"));
                            }
                            device_model__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Browser => {
                            if browser__.is_some() {
                                return Err(serde::de::Error::duplicate_field("browser"));
                            }
                            browser__ = Some(map_.next_value()?);
                        }
                        GeneratedField::BrowserVersion => {
                            if browser_version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("browserVersion"));
                            }
                            browser_version__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Address => {
                            if address__.is_some() {
                                return Err(serde::de::Error::duplicate_field("address"));
                            }
                            address__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Network => {
                            if network__.is_some() {
                                return Err(serde::de::Error::duplicate_field("network"));
                            }
                            network__ = Some(map_.next_value()?);
                        }
                        GeneratedField::OtherSdks => {
                            if other_sdks__.is_some() {
                                return Err(serde::de::Error::duplicate_field("otherSdks"));
                            }
                            other_sdks__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ClientInfo {
                    sdk: sdk__.unwrap_or_default(),
                    version: version__.unwrap_or_default(),
                    protocol: protocol__.unwrap_or_default(),
                    os: os__.unwrap_or_default(),
                    os_version: os_version__.unwrap_or_default(),
                    device_model: device_model__.unwrap_or_default(),
                    browser: browser__.unwrap_or_default(),
                    browser_version: browser_version__.unwrap_or_default(),
                    address: address__.unwrap_or_default(),
                    network: network__.unwrap_or_default(),
                    other_sdks: other_sdks__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ClientInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for client_info::Sdk {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Unknown => "UNKNOWN",
            Self::Js => "JS",
            Self::Swift => "SWIFT",
            Self::Android => "ANDROID",
            Self::Flutter => "FLUTTER",
            Self::Go => "GO",
            Self::Unity => "UNITY",
            Self::ReactNative => "REACT_NATIVE",
            Self::Rust => "RUST",
            Self::Python => "PYTHON",
            Self::Cpp => "CPP",
            Self::UnityWeb => "UNITY_WEB",
            Self::Node => "NODE",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for client_info::Sdk {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "UNKNOWN",
            "JS",
            "SWIFT",
            "ANDROID",
            "FLUTTER",
            "GO",
            "UNITY",
            "REACT_NATIVE",
            "RUST",
            "PYTHON",
            "CPP",
            "UNITY_WEB",
            "NODE",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = client_info::Sdk;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "UNKNOWN" => Ok(client_info::Sdk::Unknown),
                    "JS" => Ok(client_info::Sdk::Js),
                    "SWIFT" => Ok(client_info::Sdk::Swift),
                    "ANDROID" => Ok(client_info::Sdk::Android),
                    "FLUTTER" => Ok(client_info::Sdk::Flutter),
                    "GO" => Ok(client_info::Sdk::Go),
                    "UNITY" => Ok(client_info::Sdk::Unity),
                    "REACT_NATIVE" => Ok(client_info::Sdk::ReactNative),
                    "RUST" => Ok(client_info::Sdk::Rust),
                    "PYTHON" => Ok(client_info::Sdk::Python),
                    "CPP" => Ok(client_info::Sdk::Cpp),
                    "UNITY_WEB" => Ok(client_info::Sdk::UnityWeb),
                    "NODE" => Ok(client_info::Sdk::Node),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for Codec {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.mime.is_empty() {
            len += 1;
        }
        if !self.fmtp_line.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.Codec", len)?;
        if !self.mime.is_empty() {
            struct_ser.serialize_field("mime", &self.mime)?;
        }
        if !self.fmtp_line.is_empty() {
            struct_ser.serialize_field("fmtpLine", &self.fmtp_line)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for Codec {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "mime",
            "fmtp_line",
            "fmtpLine",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Mime,
            FmtpLine,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "mime" => Ok(GeneratedField::Mime),
                            "fmtpLine" | "fmtp_line" => Ok(GeneratedField::FmtpLine),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = Codec;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.Codec")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<Codec, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut mime__ = None;
                let mut fmtp_line__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Mime => {
                            if mime__.is_some() {
                                return Err(serde::de::Error::duplicate_field("mime"));
                            }
                            mime__ = Some(map_.next_value()?);
                        }
                        GeneratedField::FmtpLine => {
                            if fmtp_line__.is_some() {
                                return Err(serde::de::Error::duplicate_field("fmtpLine"));
                            }
                            fmtp_line__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(Codec {
                    mime: mime__.unwrap_or_default(),
                    fmtp_line: fmtp_line__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.Codec", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ConnectionQuality {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Poor => "POOR",
            Self::Good => "GOOD",
            Self::Excellent => "EXCELLENT",
            Self::Lost => "LOST",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for ConnectionQuality {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "POOR",
            "GOOD",
            "EXCELLENT",
            "LOST",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ConnectionQuality;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "POOR" => Ok(ConnectionQuality::Poor),
                    "GOOD" => Ok(ConnectionQuality::Good),
                    "EXCELLENT" => Ok(ConnectionQuality::Excellent),
                    "LOST" => Ok(ConnectionQuality::Lost),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for ConnectionQualityInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.participant_sid.is_empty() {
            len += 1;
        }
        if self.quality != 0 {
            len += 1;
        }
        if self.score != 0. {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ConnectionQualityInfo", len)?;
        if !self.participant_sid.is_empty() {
            struct_ser.serialize_field("participantSid", &self.participant_sid)?;
        }
        if self.quality != 0 {
            let v = ConnectionQuality::try_from(self.quality)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.quality)))?;
            struct_ser.serialize_field("quality", &v)?;
        }
        if self.score != 0. {
            struct_ser.serialize_field("score", &self.score)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ConnectionQualityInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "participant_sid",
            "participantSid",
            "quality",
            "score",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            ParticipantSid,
            Quality,
            Score,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "participantSid" | "participant_sid" => Ok(GeneratedField::ParticipantSid),
                            "quality" => Ok(GeneratedField::Quality),
                            "score" => Ok(GeneratedField::Score),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ConnectionQualityInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ConnectionQualityInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ConnectionQualityInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut participant_sid__ = None;
                let mut quality__ = None;
                let mut score__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::ParticipantSid => {
                            if participant_sid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantSid"));
                            }
                            participant_sid__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Quality => {
                            if quality__.is_some() {
                                return Err(serde::de::Error::duplicate_field("quality"));
                            }
                            quality__ = Some(map_.next_value::<ConnectionQuality>()? as i32);
                        }
                        GeneratedField::Score => {
                            if score__.is_some() {
                                return Err(serde::de::Error::duplicate_field("score"));
                            }
                            score__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ConnectionQualityInfo {
                    participant_sid: participant_sid__.unwrap_or_default(),
                    quality: quality__.unwrap_or_default(),
                    score: score__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ConnectionQualityInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ConnectionQualityUpdate {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.updates.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ConnectionQualityUpdate", len)?;
        if !self.updates.is_empty() {
            struct_ser.serialize_field("updates", &self.updates)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ConnectionQualityUpdate {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "updates",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Updates,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "updates" => Ok(GeneratedField::Updates),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ConnectionQualityUpdate;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ConnectionQualityUpdate")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ConnectionQualityUpdate, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut updates__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Updates => {
                            if updates__.is_some() {
                                return Err(serde::de::Error::duplicate_field("updates"));
                            }
                            updates__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ConnectionQualityUpdate {
                    updates: updates__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ConnectionQualityUpdate", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for CreateAgentDispatchRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.agent_name.is_empty() {
            len += 1;
        }
        if !self.room.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.CreateAgentDispatchRequest", len)?;
        if !self.agent_name.is_empty() {
            struct_ser.serialize_field("agentName", &self.agent_name)?;
        }
        if !self.room.is_empty() {
            struct_ser.serialize_field("room", &self.room)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for CreateAgentDispatchRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "agent_name",
            "agentName",
            "room",
            "metadata",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            AgentName,
            Room,
            Metadata,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "agentName" | "agent_name" => Ok(GeneratedField::AgentName),
                            "room" => Ok(GeneratedField::Room),
                            "metadata" => Ok(GeneratedField::Metadata),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CreateAgentDispatchRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.CreateAgentDispatchRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<CreateAgentDispatchRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut agent_name__ = None;
                let mut room__ = None;
                let mut metadata__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::AgentName => {
                            if agent_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agentName"));
                            }
                            agent_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(CreateAgentDispatchRequest {
                    agent_name: agent_name__.unwrap_or_default(),
                    room: room__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.CreateAgentDispatchRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for CreateIngressRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.input_type != 0 {
            len += 1;
        }
        if !self.url.is_empty() {
            len += 1;
        }
        if !self.name.is_empty() {
            len += 1;
        }
        if !self.room_name.is_empty() {
            len += 1;
        }
        if !self.participant_identity.is_empty() {
            len += 1;
        }
        if !self.participant_name.is_empty() {
            len += 1;
        }
        if !self.participant_metadata.is_empty() {
            len += 1;
        }
        if self.bypass_transcoding {
            len += 1;
        }
        if self.enable_transcoding.is_some() {
            len += 1;
        }
        if self.audio.is_some() {
            len += 1;
        }
        if self.video.is_some() {
            len += 1;
        }
        if self.enabled.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.CreateIngressRequest", len)?;
        if self.input_type != 0 {
            let v = IngressInput::try_from(self.input_type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.input_type)))?;
            struct_ser.serialize_field("inputType", &v)?;
        }
        if !self.url.is_empty() {
            struct_ser.serialize_field("url", &self.url)?;
        }
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if !self.participant_identity.is_empty() {
            struct_ser.serialize_field("participantIdentity", &self.participant_identity)?;
        }
        if !self.participant_name.is_empty() {
            struct_ser.serialize_field("participantName", &self.participant_name)?;
        }
        if !self.participant_metadata.is_empty() {
            struct_ser.serialize_field("participantMetadata", &self.participant_metadata)?;
        }
        if self.bypass_transcoding {
            struct_ser.serialize_field("bypassTranscoding", &self.bypass_transcoding)?;
        }
        if let Some(v) = self.enable_transcoding.as_ref() {
            struct_ser.serialize_field("enableTranscoding", v)?;
        }
        if let Some(v) = self.audio.as_ref() {
            struct_ser.serialize_field("audio", v)?;
        }
        if let Some(v) = self.video.as_ref() {
            struct_ser.serialize_field("video", v)?;
        }
        if let Some(v) = self.enabled.as_ref() {
            struct_ser.serialize_field("enabled", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for CreateIngressRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "input_type",
            "inputType",
            "url",
            "name",
            "room_name",
            "roomName",
            "participant_identity",
            "participantIdentity",
            "participant_name",
            "participantName",
            "participant_metadata",
            "participantMetadata",
            "bypass_transcoding",
            "bypassTranscoding",
            "enable_transcoding",
            "enableTranscoding",
            "audio",
            "video",
            "enabled",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            InputType,
            Url,
            Name,
            RoomName,
            ParticipantIdentity,
            ParticipantName,
            ParticipantMetadata,
            BypassTranscoding,
            EnableTranscoding,
            Audio,
            Video,
            Enabled,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "inputType" | "input_type" => Ok(GeneratedField::InputType),
                            "url" => Ok(GeneratedField::Url),
                            "name" => Ok(GeneratedField::Name),
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "participantIdentity" | "participant_identity" => Ok(GeneratedField::ParticipantIdentity),
                            "participantName" | "participant_name" => Ok(GeneratedField::ParticipantName),
                            "participantMetadata" | "participant_metadata" => Ok(GeneratedField::ParticipantMetadata),
                            "bypassTranscoding" | "bypass_transcoding" => Ok(GeneratedField::BypassTranscoding),
                            "enableTranscoding" | "enable_transcoding" => Ok(GeneratedField::EnableTranscoding),
                            "audio" => Ok(GeneratedField::Audio),
                            "video" => Ok(GeneratedField::Video),
                            "enabled" => Ok(GeneratedField::Enabled),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CreateIngressRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.CreateIngressRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<CreateIngressRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut input_type__ = None;
                let mut url__ = None;
                let mut name__ = None;
                let mut room_name__ = None;
                let mut participant_identity__ = None;
                let mut participant_name__ = None;
                let mut participant_metadata__ = None;
                let mut bypass_transcoding__ = None;
                let mut enable_transcoding__ = None;
                let mut audio__ = None;
                let mut video__ = None;
                let mut enabled__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::InputType => {
                            if input_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("inputType"));
                            }
                            input_type__ = Some(map_.next_value::<IngressInput>()? as i32);
                        }
                        GeneratedField::Url => {
                            if url__.is_some() {
                                return Err(serde::de::Error::duplicate_field("url"));
                            }
                            url__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantIdentity => {
                            if participant_identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantIdentity"));
                            }
                            participant_identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantName => {
                            if participant_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantName"));
                            }
                            participant_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantMetadata => {
                            if participant_metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantMetadata"));
                            }
                            participant_metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::BypassTranscoding => {
                            if bypass_transcoding__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bypassTranscoding"));
                            }
                            bypass_transcoding__ = Some(map_.next_value()?);
                        }
                        GeneratedField::EnableTranscoding => {
                            if enable_transcoding__.is_some() {
                                return Err(serde::de::Error::duplicate_field("enableTranscoding"));
                            }
                            enable_transcoding__ = map_.next_value()?;
                        }
                        GeneratedField::Audio => {
                            if audio__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audio"));
                            }
                            audio__ = map_.next_value()?;
                        }
                        GeneratedField::Video => {
                            if video__.is_some() {
                                return Err(serde::de::Error::duplicate_field("video"));
                            }
                            video__ = map_.next_value()?;
                        }
                        GeneratedField::Enabled => {
                            if enabled__.is_some() {
                                return Err(serde::de::Error::duplicate_field("enabled"));
                            }
                            enabled__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(CreateIngressRequest {
                    input_type: input_type__.unwrap_or_default(),
                    url: url__.unwrap_or_default(),
                    name: name__.unwrap_or_default(),
                    room_name: room_name__.unwrap_or_default(),
                    participant_identity: participant_identity__.unwrap_or_default(),
                    participant_name: participant_name__.unwrap_or_default(),
                    participant_metadata: participant_metadata__.unwrap_or_default(),
                    bypass_transcoding: bypass_transcoding__.unwrap_or_default(),
                    enable_transcoding: enable_transcoding__,
                    audio: audio__,
                    video: video__,
                    enabled: enabled__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.CreateIngressRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for CreateRoomRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.name.is_empty() {
            len += 1;
        }
        if !self.room_preset.is_empty() {
            len += 1;
        }
        if self.empty_timeout != 0 {
            len += 1;
        }
        if self.departure_timeout != 0 {
            len += 1;
        }
        if self.max_participants != 0 {
            len += 1;
        }
        if !self.node_id.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        if self.egress.is_some() {
            len += 1;
        }
        if self.min_playout_delay != 0 {
            len += 1;
        }
        if self.max_playout_delay != 0 {
            len += 1;
        }
        if self.sync_streams {
            len += 1;
        }
        if self.replay_enabled {
            len += 1;
        }
        if !self.agents.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.CreateRoomRequest", len)?;
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if !self.room_preset.is_empty() {
            struct_ser.serialize_field("roomPreset", &self.room_preset)?;
        }
        if self.empty_timeout != 0 {
            struct_ser.serialize_field("emptyTimeout", &self.empty_timeout)?;
        }
        if self.departure_timeout != 0 {
            struct_ser.serialize_field("departureTimeout", &self.departure_timeout)?;
        }
        if self.max_participants != 0 {
            struct_ser.serialize_field("maxParticipants", &self.max_participants)?;
        }
        if !self.node_id.is_empty() {
            struct_ser.serialize_field("nodeId", &self.node_id)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        if let Some(v) = self.egress.as_ref() {
            struct_ser.serialize_field("egress", v)?;
        }
        if self.min_playout_delay != 0 {
            struct_ser.serialize_field("minPlayoutDelay", &self.min_playout_delay)?;
        }
        if self.max_playout_delay != 0 {
            struct_ser.serialize_field("maxPlayoutDelay", &self.max_playout_delay)?;
        }
        if self.sync_streams {
            struct_ser.serialize_field("syncStreams", &self.sync_streams)?;
        }
        if self.replay_enabled {
            struct_ser.serialize_field("replayEnabled", &self.replay_enabled)?;
        }
        if !self.agents.is_empty() {
            struct_ser.serialize_field("agents", &self.agents)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for CreateRoomRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "name",
            "room_preset",
            "roomPreset",
            "empty_timeout",
            "emptyTimeout",
            "departure_timeout",
            "departureTimeout",
            "max_participants",
            "maxParticipants",
            "node_id",
            "nodeId",
            "metadata",
            "egress",
            "min_playout_delay",
            "minPlayoutDelay",
            "max_playout_delay",
            "maxPlayoutDelay",
            "sync_streams",
            "syncStreams",
            "replay_enabled",
            "replayEnabled",
            "agents",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Name,
            RoomPreset,
            EmptyTimeout,
            DepartureTimeout,
            MaxParticipants,
            NodeId,
            Metadata,
            Egress,
            MinPlayoutDelay,
            MaxPlayoutDelay,
            SyncStreams,
            ReplayEnabled,
            Agents,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "name" => Ok(GeneratedField::Name),
                            "roomPreset" | "room_preset" => Ok(GeneratedField::RoomPreset),
                            "emptyTimeout" | "empty_timeout" => Ok(GeneratedField::EmptyTimeout),
                            "departureTimeout" | "departure_timeout" => Ok(GeneratedField::DepartureTimeout),
                            "maxParticipants" | "max_participants" => Ok(GeneratedField::MaxParticipants),
                            "nodeId" | "node_id" => Ok(GeneratedField::NodeId),
                            "metadata" => Ok(GeneratedField::Metadata),
                            "egress" => Ok(GeneratedField::Egress),
                            "minPlayoutDelay" | "min_playout_delay" => Ok(GeneratedField::MinPlayoutDelay),
                            "maxPlayoutDelay" | "max_playout_delay" => Ok(GeneratedField::MaxPlayoutDelay),
                            "syncStreams" | "sync_streams" => Ok(GeneratedField::SyncStreams),
                            "replayEnabled" | "replay_enabled" => Ok(GeneratedField::ReplayEnabled),
                            "agents" => Ok(GeneratedField::Agents),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CreateRoomRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.CreateRoomRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<CreateRoomRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut name__ = None;
                let mut room_preset__ = None;
                let mut empty_timeout__ = None;
                let mut departure_timeout__ = None;
                let mut max_participants__ = None;
                let mut node_id__ = None;
                let mut metadata__ = None;
                let mut egress__ = None;
                let mut min_playout_delay__ = None;
                let mut max_playout_delay__ = None;
                let mut sync_streams__ = None;
                let mut replay_enabled__ = None;
                let mut agents__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomPreset => {
                            if room_preset__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomPreset"));
                            }
                            room_preset__ = Some(map_.next_value()?);
                        }
                        GeneratedField::EmptyTimeout => {
                            if empty_timeout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("emptyTimeout"));
                            }
                            empty_timeout__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DepartureTimeout => {
                            if departure_timeout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("departureTimeout"));
                            }
                            departure_timeout__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::MaxParticipants => {
                            if max_participants__.is_some() {
                                return Err(serde::de::Error::duplicate_field("maxParticipants"));
                            }
                            max_participants__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::NodeId => {
                            if node_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("nodeId"));
                            }
                            node_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Egress => {
                            if egress__.is_some() {
                                return Err(serde::de::Error::duplicate_field("egress"));
                            }
                            egress__ = map_.next_value()?;
                        }
                        GeneratedField::MinPlayoutDelay => {
                            if min_playout_delay__.is_some() {
                                return Err(serde::de::Error::duplicate_field("minPlayoutDelay"));
                            }
                            min_playout_delay__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::MaxPlayoutDelay => {
                            if max_playout_delay__.is_some() {
                                return Err(serde::de::Error::duplicate_field("maxPlayoutDelay"));
                            }
                            max_playout_delay__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::SyncStreams => {
                            if sync_streams__.is_some() {
                                return Err(serde::de::Error::duplicate_field("syncStreams"));
                            }
                            sync_streams__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ReplayEnabled => {
                            if replay_enabled__.is_some() {
                                return Err(serde::de::Error::duplicate_field("replayEnabled"));
                            }
                            replay_enabled__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Agents => {
                            if agents__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agents"));
                            }
                            agents__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(CreateRoomRequest {
                    name: name__.unwrap_or_default(),
                    room_preset: room_preset__.unwrap_or_default(),
                    empty_timeout: empty_timeout__.unwrap_or_default(),
                    departure_timeout: departure_timeout__.unwrap_or_default(),
                    max_participants: max_participants__.unwrap_or_default(),
                    node_id: node_id__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                    egress: egress__,
                    min_playout_delay: min_playout_delay__.unwrap_or_default(),
                    max_playout_delay: max_playout_delay__.unwrap_or_default(),
                    sync_streams: sync_streams__.unwrap_or_default(),
                    replay_enabled: replay_enabled__.unwrap_or_default(),
                    agents: agents__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.CreateRoomRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for CreateSipDispatchRuleRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.rule.is_some() {
            len += 1;
        }
        if !self.trunk_ids.is_empty() {
            len += 1;
        }
        if self.hide_phone_number {
            len += 1;
        }
        if !self.inbound_numbers.is_empty() {
            len += 1;
        }
        if !self.name.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        if !self.attributes.is_empty() {
            len += 1;
        }
        if !self.room_preset.is_empty() {
            len += 1;
        }
        if self.room_config.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.CreateSIPDispatchRuleRequest", len)?;
        if let Some(v) = self.rule.as_ref() {
            struct_ser.serialize_field("rule", v)?;
        }
        if !self.trunk_ids.is_empty() {
            struct_ser.serialize_field("trunkIds", &self.trunk_ids)?;
        }
        if self.hide_phone_number {
            struct_ser.serialize_field("hidePhoneNumber", &self.hide_phone_number)?;
        }
        if !self.inbound_numbers.is_empty() {
            struct_ser.serialize_field("inboundNumbers", &self.inbound_numbers)?;
        }
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        if !self.attributes.is_empty() {
            struct_ser.serialize_field("attributes", &self.attributes)?;
        }
        if !self.room_preset.is_empty() {
            struct_ser.serialize_field("roomPreset", &self.room_preset)?;
        }
        if let Some(v) = self.room_config.as_ref() {
            struct_ser.serialize_field("roomConfig", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for CreateSipDispatchRuleRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "rule",
            "trunk_ids",
            "trunkIds",
            "hide_phone_number",
            "hidePhoneNumber",
            "inbound_numbers",
            "inboundNumbers",
            "name",
            "metadata",
            "attributes",
            "room_preset",
            "roomPreset",
            "room_config",
            "roomConfig",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Rule,
            TrunkIds,
            HidePhoneNumber,
            InboundNumbers,
            Name,
            Metadata,
            Attributes,
            RoomPreset,
            RoomConfig,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "rule" => Ok(GeneratedField::Rule),
                            "trunkIds" | "trunk_ids" => Ok(GeneratedField::TrunkIds),
                            "hidePhoneNumber" | "hide_phone_number" => Ok(GeneratedField::HidePhoneNumber),
                            "inboundNumbers" | "inbound_numbers" => Ok(GeneratedField::InboundNumbers),
                            "name" => Ok(GeneratedField::Name),
                            "metadata" => Ok(GeneratedField::Metadata),
                            "attributes" => Ok(GeneratedField::Attributes),
                            "roomPreset" | "room_preset" => Ok(GeneratedField::RoomPreset),
                            "roomConfig" | "room_config" => Ok(GeneratedField::RoomConfig),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CreateSipDispatchRuleRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.CreateSIPDispatchRuleRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<CreateSipDispatchRuleRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut rule__ = None;
                let mut trunk_ids__ = None;
                let mut hide_phone_number__ = None;
                let mut inbound_numbers__ = None;
                let mut name__ = None;
                let mut metadata__ = None;
                let mut attributes__ = None;
                let mut room_preset__ = None;
                let mut room_config__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Rule => {
                            if rule__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rule"));
                            }
                            rule__ = map_.next_value()?;
                        }
                        GeneratedField::TrunkIds => {
                            if trunk_ids__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunkIds"));
                            }
                            trunk_ids__ = Some(map_.next_value()?);
                        }
                        GeneratedField::HidePhoneNumber => {
                            if hide_phone_number__.is_some() {
                                return Err(serde::de::Error::duplicate_field("hidePhoneNumber"));
                            }
                            hide_phone_number__ = Some(map_.next_value()?);
                        }
                        GeneratedField::InboundNumbers => {
                            if inbound_numbers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("inboundNumbers"));
                            }
                            inbound_numbers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Attributes => {
                            if attributes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("attributes"));
                            }
                            attributes__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::RoomPreset => {
                            if room_preset__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomPreset"));
                            }
                            room_preset__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomConfig => {
                            if room_config__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomConfig"));
                            }
                            room_config__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(CreateSipDispatchRuleRequest {
                    rule: rule__,
                    trunk_ids: trunk_ids__.unwrap_or_default(),
                    hide_phone_number: hide_phone_number__.unwrap_or_default(),
                    inbound_numbers: inbound_numbers__.unwrap_or_default(),
                    name: name__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                    attributes: attributes__.unwrap_or_default(),
                    room_preset: room_preset__.unwrap_or_default(),
                    room_config: room_config__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.CreateSIPDispatchRuleRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for CreateSipInboundTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.trunk.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.CreateSIPInboundTrunkRequest", len)?;
        if let Some(v) = self.trunk.as_ref() {
            struct_ser.serialize_field("trunk", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for CreateSipInboundTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "trunk",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Trunk,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "trunk" => Ok(GeneratedField::Trunk),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CreateSipInboundTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.CreateSIPInboundTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<CreateSipInboundTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut trunk__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Trunk => {
                            if trunk__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunk"));
                            }
                            trunk__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(CreateSipInboundTrunkRequest {
                    trunk: trunk__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.CreateSIPInboundTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for CreateSipOutboundTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.trunk.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.CreateSIPOutboundTrunkRequest", len)?;
        if let Some(v) = self.trunk.as_ref() {
            struct_ser.serialize_field("trunk", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for CreateSipOutboundTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "trunk",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Trunk,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "trunk" => Ok(GeneratedField::Trunk),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CreateSipOutboundTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.CreateSIPOutboundTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<CreateSipOutboundTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut trunk__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Trunk => {
                            if trunk__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunk"));
                            }
                            trunk__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(CreateSipOutboundTrunkRequest {
                    trunk: trunk__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.CreateSIPOutboundTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for CreateSipParticipantRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.sip_trunk_id.is_empty() {
            len += 1;
        }
        if self.trunk.is_some() {
            len += 1;
        }
        if !self.sip_call_to.is_empty() {
            len += 1;
        }
        if !self.sip_number.is_empty() {
            len += 1;
        }
        if !self.room_name.is_empty() {
            len += 1;
        }
        if !self.participant_identity.is_empty() {
            len += 1;
        }
        if !self.participant_name.is_empty() {
            len += 1;
        }
        if !self.participant_metadata.is_empty() {
            len += 1;
        }
        if !self.participant_attributes.is_empty() {
            len += 1;
        }
        if !self.dtmf.is_empty() {
            len += 1;
        }
        if self.play_ringtone {
            len += 1;
        }
        if self.play_dialtone {
            len += 1;
        }
        if self.hide_phone_number {
            len += 1;
        }
        if !self.headers.is_empty() {
            len += 1;
        }
        if self.include_headers != 0 {
            len += 1;
        }
        if self.ringing_timeout.is_some() {
            len += 1;
        }
        if self.max_call_duration.is_some() {
            len += 1;
        }
        if self.krisp_enabled {
            len += 1;
        }
        if self.media_encryption != 0 {
            len += 1;
        }
        if self.wait_until_answered {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.CreateSIPParticipantRequest", len)?;
        if !self.sip_trunk_id.is_empty() {
            struct_ser.serialize_field("sipTrunkId", &self.sip_trunk_id)?;
        }
        if let Some(v) = self.trunk.as_ref() {
            struct_ser.serialize_field("trunk", v)?;
        }
        if !self.sip_call_to.is_empty() {
            struct_ser.serialize_field("sipCallTo", &self.sip_call_to)?;
        }
        if !self.sip_number.is_empty() {
            struct_ser.serialize_field("sipNumber", &self.sip_number)?;
        }
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if !self.participant_identity.is_empty() {
            struct_ser.serialize_field("participantIdentity", &self.participant_identity)?;
        }
        if !self.participant_name.is_empty() {
            struct_ser.serialize_field("participantName", &self.participant_name)?;
        }
        if !self.participant_metadata.is_empty() {
            struct_ser.serialize_field("participantMetadata", &self.participant_metadata)?;
        }
        if !self.participant_attributes.is_empty() {
            struct_ser.serialize_field("participantAttributes", &self.participant_attributes)?;
        }
        if !self.dtmf.is_empty() {
            struct_ser.serialize_field("dtmf", &self.dtmf)?;
        }
        if self.play_ringtone {
            struct_ser.serialize_field("playRingtone", &self.play_ringtone)?;
        }
        if self.play_dialtone {
            struct_ser.serialize_field("playDialtone", &self.play_dialtone)?;
        }
        if self.hide_phone_number {
            struct_ser.serialize_field("hidePhoneNumber", &self.hide_phone_number)?;
        }
        if !self.headers.is_empty() {
            struct_ser.serialize_field("headers", &self.headers)?;
        }
        if self.include_headers != 0 {
            let v = SipHeaderOptions::try_from(self.include_headers)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.include_headers)))?;
            struct_ser.serialize_field("includeHeaders", &v)?;
        }
        if let Some(v) = self.ringing_timeout.as_ref() {
            struct_ser.serialize_field("ringingTimeout", v)?;
        }
        if let Some(v) = self.max_call_duration.as_ref() {
            struct_ser.serialize_field("maxCallDuration", v)?;
        }
        if self.krisp_enabled {
            struct_ser.serialize_field("krispEnabled", &self.krisp_enabled)?;
        }
        if self.media_encryption != 0 {
            let v = SipMediaEncryption::try_from(self.media_encryption)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.media_encryption)))?;
            struct_ser.serialize_field("mediaEncryption", &v)?;
        }
        if self.wait_until_answered {
            struct_ser.serialize_field("waitUntilAnswered", &self.wait_until_answered)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for CreateSipParticipantRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sip_trunk_id",
            "sipTrunkId",
            "trunk",
            "sip_call_to",
            "sipCallTo",
            "sip_number",
            "sipNumber",
            "room_name",
            "roomName",
            "participant_identity",
            "participantIdentity",
            "participant_name",
            "participantName",
            "participant_metadata",
            "participantMetadata",
            "participant_attributes",
            "participantAttributes",
            "dtmf",
            "play_ringtone",
            "playRingtone",
            "play_dialtone",
            "playDialtone",
            "hide_phone_number",
            "hidePhoneNumber",
            "headers",
            "include_headers",
            "includeHeaders",
            "ringing_timeout",
            "ringingTimeout",
            "max_call_duration",
            "maxCallDuration",
            "krisp_enabled",
            "krispEnabled",
            "media_encryption",
            "mediaEncryption",
            "wait_until_answered",
            "waitUntilAnswered",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            SipTrunkId,
            Trunk,
            SipCallTo,
            SipNumber,
            RoomName,
            ParticipantIdentity,
            ParticipantName,
            ParticipantMetadata,
            ParticipantAttributes,
            Dtmf,
            PlayRingtone,
            PlayDialtone,
            HidePhoneNumber,
            Headers,
            IncludeHeaders,
            RingingTimeout,
            MaxCallDuration,
            KrispEnabled,
            MediaEncryption,
            WaitUntilAnswered,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sipTrunkId" | "sip_trunk_id" => Ok(GeneratedField::SipTrunkId),
                            "trunk" => Ok(GeneratedField::Trunk),
                            "sipCallTo" | "sip_call_to" => Ok(GeneratedField::SipCallTo),
                            "sipNumber" | "sip_number" => Ok(GeneratedField::SipNumber),
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "participantIdentity" | "participant_identity" => Ok(GeneratedField::ParticipantIdentity),
                            "participantName" | "participant_name" => Ok(GeneratedField::ParticipantName),
                            "participantMetadata" | "participant_metadata" => Ok(GeneratedField::ParticipantMetadata),
                            "participantAttributes" | "participant_attributes" => Ok(GeneratedField::ParticipantAttributes),
                            "dtmf" => Ok(GeneratedField::Dtmf),
                            "playRingtone" | "play_ringtone" => Ok(GeneratedField::PlayRingtone),
                            "playDialtone" | "play_dialtone" => Ok(GeneratedField::PlayDialtone),
                            "hidePhoneNumber" | "hide_phone_number" => Ok(GeneratedField::HidePhoneNumber),
                            "headers" => Ok(GeneratedField::Headers),
                            "includeHeaders" | "include_headers" => Ok(GeneratedField::IncludeHeaders),
                            "ringingTimeout" | "ringing_timeout" => Ok(GeneratedField::RingingTimeout),
                            "maxCallDuration" | "max_call_duration" => Ok(GeneratedField::MaxCallDuration),
                            "krispEnabled" | "krisp_enabled" => Ok(GeneratedField::KrispEnabled),
                            "mediaEncryption" | "media_encryption" => Ok(GeneratedField::MediaEncryption),
                            "waitUntilAnswered" | "wait_until_answered" => Ok(GeneratedField::WaitUntilAnswered),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CreateSipParticipantRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.CreateSIPParticipantRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<CreateSipParticipantRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sip_trunk_id__ = None;
                let mut trunk__ = None;
                let mut sip_call_to__ = None;
                let mut sip_number__ = None;
                let mut room_name__ = None;
                let mut participant_identity__ = None;
                let mut participant_name__ = None;
                let mut participant_metadata__ = None;
                let mut participant_attributes__ = None;
                let mut dtmf__ = None;
                let mut play_ringtone__ = None;
                let mut play_dialtone__ = None;
                let mut hide_phone_number__ = None;
                let mut headers__ = None;
                let mut include_headers__ = None;
                let mut ringing_timeout__ = None;
                let mut max_call_duration__ = None;
                let mut krisp_enabled__ = None;
                let mut media_encryption__ = None;
                let mut wait_until_answered__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::SipTrunkId => {
                            if sip_trunk_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sipTrunkId"));
                            }
                            sip_trunk_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Trunk => {
                            if trunk__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunk"));
                            }
                            trunk__ = map_.next_value()?;
                        }
                        GeneratedField::SipCallTo => {
                            if sip_call_to__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sipCallTo"));
                            }
                            sip_call_to__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SipNumber => {
                            if sip_number__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sipNumber"));
                            }
                            sip_number__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantIdentity => {
                            if participant_identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantIdentity"));
                            }
                            participant_identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantName => {
                            if participant_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantName"));
                            }
                            participant_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantMetadata => {
                            if participant_metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantMetadata"));
                            }
                            participant_metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantAttributes => {
                            if participant_attributes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantAttributes"));
                            }
                            participant_attributes__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::Dtmf => {
                            if dtmf__.is_some() {
                                return Err(serde::de::Error::duplicate_field("dtmf"));
                            }
                            dtmf__ = Some(map_.next_value()?);
                        }
                        GeneratedField::PlayRingtone => {
                            if play_ringtone__.is_some() {
                                return Err(serde::de::Error::duplicate_field("playRingtone"));
                            }
                            play_ringtone__ = Some(map_.next_value()?);
                        }
                        GeneratedField::PlayDialtone => {
                            if play_dialtone__.is_some() {
                                return Err(serde::de::Error::duplicate_field("playDialtone"));
                            }
                            play_dialtone__ = Some(map_.next_value()?);
                        }
                        GeneratedField::HidePhoneNumber => {
                            if hide_phone_number__.is_some() {
                                return Err(serde::de::Error::duplicate_field("hidePhoneNumber"));
                            }
                            hide_phone_number__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Headers => {
                            if headers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("headers"));
                            }
                            headers__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::IncludeHeaders => {
                            if include_headers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("includeHeaders"));
                            }
                            include_headers__ = Some(map_.next_value::<SipHeaderOptions>()? as i32);
                        }
                        GeneratedField::RingingTimeout => {
                            if ringing_timeout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("ringingTimeout"));
                            }
                            ringing_timeout__ = map_.next_value()?;
                        }
                        GeneratedField::MaxCallDuration => {
                            if max_call_duration__.is_some() {
                                return Err(serde::de::Error::duplicate_field("maxCallDuration"));
                            }
                            max_call_duration__ = map_.next_value()?;
                        }
                        GeneratedField::KrispEnabled => {
                            if krisp_enabled__.is_some() {
                                return Err(serde::de::Error::duplicate_field("krispEnabled"));
                            }
                            krisp_enabled__ = Some(map_.next_value()?);
                        }
                        GeneratedField::MediaEncryption => {
                            if media_encryption__.is_some() {
                                return Err(serde::de::Error::duplicate_field("mediaEncryption"));
                            }
                            media_encryption__ = Some(map_.next_value::<SipMediaEncryption>()? as i32);
                        }
                        GeneratedField::WaitUntilAnswered => {
                            if wait_until_answered__.is_some() {
                                return Err(serde::de::Error::duplicate_field("waitUntilAnswered"));
                            }
                            wait_until_answered__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(CreateSipParticipantRequest {
                    sip_trunk_id: sip_trunk_id__.unwrap_or_default(),
                    trunk: trunk__,
                    sip_call_to: sip_call_to__.unwrap_or_default(),
                    sip_number: sip_number__.unwrap_or_default(),
                    room_name: room_name__.unwrap_or_default(),
                    participant_identity: participant_identity__.unwrap_or_default(),
                    participant_name: participant_name__.unwrap_or_default(),
                    participant_metadata: participant_metadata__.unwrap_or_default(),
                    participant_attributes: participant_attributes__.unwrap_or_default(),
                    dtmf: dtmf__.unwrap_or_default(),
                    play_ringtone: play_ringtone__.unwrap_or_default(),
                    play_dialtone: play_dialtone__.unwrap_or_default(),
                    hide_phone_number: hide_phone_number__.unwrap_or_default(),
                    headers: headers__.unwrap_or_default(),
                    include_headers: include_headers__.unwrap_or_default(),
                    ringing_timeout: ringing_timeout__,
                    max_call_duration: max_call_duration__,
                    krisp_enabled: krisp_enabled__.unwrap_or_default(),
                    media_encryption: media_encryption__.unwrap_or_default(),
                    wait_until_answered: wait_until_answered__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.CreateSIPParticipantRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for CreateSipTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.inbound_addresses.is_empty() {
            len += 1;
        }
        if !self.outbound_address.is_empty() {
            len += 1;
        }
        if !self.outbound_number.is_empty() {
            len += 1;
        }
        if !self.inbound_numbers_regex.is_empty() {
            len += 1;
        }
        if !self.inbound_numbers.is_empty() {
            len += 1;
        }
        if !self.inbound_username.is_empty() {
            len += 1;
        }
        if !self.inbound_password.is_empty() {
            len += 1;
        }
        if !self.outbound_username.is_empty() {
            len += 1;
        }
        if !self.outbound_password.is_empty() {
            len += 1;
        }
        if !self.name.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.CreateSIPTrunkRequest", len)?;
        if !self.inbound_addresses.is_empty() {
            struct_ser.serialize_field("inboundAddresses", &self.inbound_addresses)?;
        }
        if !self.outbound_address.is_empty() {
            struct_ser.serialize_field("outboundAddress", &self.outbound_address)?;
        }
        if !self.outbound_number.is_empty() {
            struct_ser.serialize_field("outboundNumber", &self.outbound_number)?;
        }
        if !self.inbound_numbers_regex.is_empty() {
            struct_ser.serialize_field("inboundNumbersRegex", &self.inbound_numbers_regex)?;
        }
        if !self.inbound_numbers.is_empty() {
            struct_ser.serialize_field("inboundNumbers", &self.inbound_numbers)?;
        }
        if !self.inbound_username.is_empty() {
            struct_ser.serialize_field("inboundUsername", &self.inbound_username)?;
        }
        if !self.inbound_password.is_empty() {
            struct_ser.serialize_field("inboundPassword", &self.inbound_password)?;
        }
        if !self.outbound_username.is_empty() {
            struct_ser.serialize_field("outboundUsername", &self.outbound_username)?;
        }
        if !self.outbound_password.is_empty() {
            struct_ser.serialize_field("outboundPassword", &self.outbound_password)?;
        }
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for CreateSipTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "inbound_addresses",
            "inboundAddresses",
            "outbound_address",
            "outboundAddress",
            "outbound_number",
            "outboundNumber",
            "inbound_numbers_regex",
            "inboundNumbersRegex",
            "inbound_numbers",
            "inboundNumbers",
            "inbound_username",
            "inboundUsername",
            "inbound_password",
            "inboundPassword",
            "outbound_username",
            "outboundUsername",
            "outbound_password",
            "outboundPassword",
            "name",
            "metadata",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            InboundAddresses,
            OutboundAddress,
            OutboundNumber,
            InboundNumbersRegex,
            InboundNumbers,
            InboundUsername,
            InboundPassword,
            OutboundUsername,
            OutboundPassword,
            Name,
            Metadata,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "inboundAddresses" | "inbound_addresses" => Ok(GeneratedField::InboundAddresses),
                            "outboundAddress" | "outbound_address" => Ok(GeneratedField::OutboundAddress),
                            "outboundNumber" | "outbound_number" => Ok(GeneratedField::OutboundNumber),
                            "inboundNumbersRegex" | "inbound_numbers_regex" => Ok(GeneratedField::InboundNumbersRegex),
                            "inboundNumbers" | "inbound_numbers" => Ok(GeneratedField::InboundNumbers),
                            "inboundUsername" | "inbound_username" => Ok(GeneratedField::InboundUsername),
                            "inboundPassword" | "inbound_password" => Ok(GeneratedField::InboundPassword),
                            "outboundUsername" | "outbound_username" => Ok(GeneratedField::OutboundUsername),
                            "outboundPassword" | "outbound_password" => Ok(GeneratedField::OutboundPassword),
                            "name" => Ok(GeneratedField::Name),
                            "metadata" => Ok(GeneratedField::Metadata),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = CreateSipTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.CreateSIPTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<CreateSipTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut inbound_addresses__ = None;
                let mut outbound_address__ = None;
                let mut outbound_number__ = None;
                let mut inbound_numbers_regex__ = None;
                let mut inbound_numbers__ = None;
                let mut inbound_username__ = None;
                let mut inbound_password__ = None;
                let mut outbound_username__ = None;
                let mut outbound_password__ = None;
                let mut name__ = None;
                let mut metadata__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::InboundAddresses => {
                            if inbound_addresses__.is_some() {
                                return Err(serde::de::Error::duplicate_field("inboundAddresses"));
                            }
                            inbound_addresses__ = Some(map_.next_value()?);
                        }
                        GeneratedField::OutboundAddress => {
                            if outbound_address__.is_some() {
                                return Err(serde::de::Error::duplicate_field("outboundAddress"));
                            }
                            outbound_address__ = Some(map_.next_value()?);
                        }
                        GeneratedField::OutboundNumber => {
                            if outbound_number__.is_some() {
                                return Err(serde::de::Error::duplicate_field("outboundNumber"));
                            }
                            outbound_number__ = Some(map_.next_value()?);
                        }
                        GeneratedField::InboundNumbersRegex => {
                            if inbound_numbers_regex__.is_some() {
                                return Err(serde::de::Error::duplicate_field("inboundNumbersRegex"));
                            }
                            inbound_numbers_regex__ = Some(map_.next_value()?);
                        }
                        GeneratedField::InboundNumbers => {
                            if inbound_numbers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("inboundNumbers"));
                            }
                            inbound_numbers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::InboundUsername => {
                            if inbound_username__.is_some() {
                                return Err(serde::de::Error::duplicate_field("inboundUsername"));
                            }
                            inbound_username__ = Some(map_.next_value()?);
                        }
                        GeneratedField::InboundPassword => {
                            if inbound_password__.is_some() {
                                return Err(serde::de::Error::duplicate_field("inboundPassword"));
                            }
                            inbound_password__ = Some(map_.next_value()?);
                        }
                        GeneratedField::OutboundUsername => {
                            if outbound_username__.is_some() {
                                return Err(serde::de::Error::duplicate_field("outboundUsername"));
                            }
                            outbound_username__ = Some(map_.next_value()?);
                        }
                        GeneratedField::OutboundPassword => {
                            if outbound_password__.is_some() {
                                return Err(serde::de::Error::duplicate_field("outboundPassword"));
                            }
                            outbound_password__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(CreateSipTrunkRequest {
                    inbound_addresses: inbound_addresses__.unwrap_or_default(),
                    outbound_address: outbound_address__.unwrap_or_default(),
                    outbound_number: outbound_number__.unwrap_or_default(),
                    inbound_numbers_regex: inbound_numbers_regex__.unwrap_or_default(),
                    inbound_numbers: inbound_numbers__.unwrap_or_default(),
                    inbound_username: inbound_username__.unwrap_or_default(),
                    inbound_password: inbound_password__.unwrap_or_default(),
                    outbound_username: outbound_username__.unwrap_or_default(),
                    outbound_password: outbound_password__.unwrap_or_default(),
                    name: name__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.CreateSIPTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DataChannelInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.label.is_empty() {
            len += 1;
        }
        if self.id != 0 {
            len += 1;
        }
        if self.target != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DataChannelInfo", len)?;
        if !self.label.is_empty() {
            struct_ser.serialize_field("label", &self.label)?;
        }
        if self.id != 0 {
            struct_ser.serialize_field("id", &self.id)?;
        }
        if self.target != 0 {
            let v = SignalTarget::try_from(self.target)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.target)))?;
            struct_ser.serialize_field("target", &v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DataChannelInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "label",
            "id",
            "target",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Label,
            Id,
            Target,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "label" => Ok(GeneratedField::Label),
                            "id" => Ok(GeneratedField::Id),
                            "target" => Ok(GeneratedField::Target),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DataChannelInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DataChannelInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DataChannelInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut label__ = None;
                let mut id__ = None;
                let mut target__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Label => {
                            if label__.is_some() {
                                return Err(serde::de::Error::duplicate_field("label"));
                            }
                            label__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Id => {
                            if id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("id"));
                            }
                            id__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Target => {
                            if target__.is_some() {
                                return Err(serde::de::Error::duplicate_field("target"));
                            }
                            target__ = Some(map_.next_value::<SignalTarget>()? as i32);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DataChannelInfo {
                    label: label__.unwrap_or_default(),
                    id: id__.unwrap_or_default(),
                    target: target__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DataChannelInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DataPacket {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.kind != 0 {
            len += 1;
        }
        if !self.participant_identity.is_empty() {
            len += 1;
        }
        if !self.destination_identities.is_empty() {
            len += 1;
        }
        if self.value.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DataPacket", len)?;
        if self.kind != 0 {
            let v = data_packet::Kind::try_from(self.kind)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.kind)))?;
            struct_ser.serialize_field("kind", &v)?;
        }
        if !self.participant_identity.is_empty() {
            struct_ser.serialize_field("participantIdentity", &self.participant_identity)?;
        }
        if !self.destination_identities.is_empty() {
            struct_ser.serialize_field("destinationIdentities", &self.destination_identities)?;
        }
        if let Some(v) = self.value.as_ref() {
            match v {
                data_packet::Value::User(v) => {
                    struct_ser.serialize_field("user", v)?;
                }
                data_packet::Value::Speaker(v) => {
                    struct_ser.serialize_field("speaker", v)?;
                }
                data_packet::Value::SipDtmf(v) => {
                    struct_ser.serialize_field("sipDtmf", v)?;
                }
                data_packet::Value::Transcription(v) => {
                    struct_ser.serialize_field("transcription", v)?;
                }
                data_packet::Value::Metrics(v) => {
                    struct_ser.serialize_field("metrics", v)?;
                }
                data_packet::Value::ChatMessage(v) => {
                    struct_ser.serialize_field("chatMessage", v)?;
                }
                data_packet::Value::RpcRequest(v) => {
                    struct_ser.serialize_field("rpcRequest", v)?;
                }
                data_packet::Value::RpcAck(v) => {
                    struct_ser.serialize_field("rpcAck", v)?;
                }
                data_packet::Value::RpcResponse(v) => {
                    struct_ser.serialize_field("rpcResponse", v)?;
                }
                data_packet::Value::StreamHeader(v) => {
                    struct_ser.serialize_field("streamHeader", v)?;
                }
                data_packet::Value::StreamChunk(v) => {
                    struct_ser.serialize_field("streamChunk", v)?;
                }
                data_packet::Value::StreamTrailer(v) => {
                    struct_ser.serialize_field("streamTrailer", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DataPacket {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "kind",
            "participant_identity",
            "participantIdentity",
            "destination_identities",
            "destinationIdentities",
            "user",
            "speaker",
            "sip_dtmf",
            "sipDtmf",
            "transcription",
            "metrics",
            "chat_message",
            "chatMessage",
            "rpc_request",
            "rpcRequest",
            "rpc_ack",
            "rpcAck",
            "rpc_response",
            "rpcResponse",
            "stream_header",
            "streamHeader",
            "stream_chunk",
            "streamChunk",
            "stream_trailer",
            "streamTrailer",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Kind,
            ParticipantIdentity,
            DestinationIdentities,
            User,
            Speaker,
            SipDtmf,
            Transcription,
            Metrics,
            ChatMessage,
            RpcRequest,
            RpcAck,
            RpcResponse,
            StreamHeader,
            StreamChunk,
            StreamTrailer,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "kind" => Ok(GeneratedField::Kind),
                            "participantIdentity" | "participant_identity" => Ok(GeneratedField::ParticipantIdentity),
                            "destinationIdentities" | "destination_identities" => Ok(GeneratedField::DestinationIdentities),
                            "user" => Ok(GeneratedField::User),
                            "speaker" => Ok(GeneratedField::Speaker),
                            "sipDtmf" | "sip_dtmf" => Ok(GeneratedField::SipDtmf),
                            "transcription" => Ok(GeneratedField::Transcription),
                            "metrics" => Ok(GeneratedField::Metrics),
                            "chatMessage" | "chat_message" => Ok(GeneratedField::ChatMessage),
                            "rpcRequest" | "rpc_request" => Ok(GeneratedField::RpcRequest),
                            "rpcAck" | "rpc_ack" => Ok(GeneratedField::RpcAck),
                            "rpcResponse" | "rpc_response" => Ok(GeneratedField::RpcResponse),
                            "streamHeader" | "stream_header" => Ok(GeneratedField::StreamHeader),
                            "streamChunk" | "stream_chunk" => Ok(GeneratedField::StreamChunk),
                            "streamTrailer" | "stream_trailer" => Ok(GeneratedField::StreamTrailer),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DataPacket;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DataPacket")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DataPacket, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut kind__ = None;
                let mut participant_identity__ = None;
                let mut destination_identities__ = None;
                let mut value__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Kind => {
                            if kind__.is_some() {
                                return Err(serde::de::Error::duplicate_field("kind"));
                            }
                            kind__ = Some(map_.next_value::<data_packet::Kind>()? as i32);
                        }
                        GeneratedField::ParticipantIdentity => {
                            if participant_identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantIdentity"));
                            }
                            participant_identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DestinationIdentities => {
                            if destination_identities__.is_some() {
                                return Err(serde::de::Error::duplicate_field("destinationIdentities"));
                            }
                            destination_identities__ = Some(map_.next_value()?);
                        }
                        GeneratedField::User => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("user"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::User)
;
                        }
                        GeneratedField::Speaker => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("speaker"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::Speaker)
;
                        }
                        GeneratedField::SipDtmf => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sipDtmf"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::SipDtmf)
;
                        }
                        GeneratedField::Transcription => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("transcription"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::Transcription)
;
                        }
                        GeneratedField::Metrics => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metrics"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::Metrics)
;
                        }
                        GeneratedField::ChatMessage => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("chatMessage"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::ChatMessage)
;
                        }
                        GeneratedField::RpcRequest => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rpcRequest"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::RpcRequest)
;
                        }
                        GeneratedField::RpcAck => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rpcAck"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::RpcAck)
;
                        }
                        GeneratedField::RpcResponse => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rpcResponse"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::RpcResponse)
;
                        }
                        GeneratedField::StreamHeader => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamHeader"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::StreamHeader)
;
                        }
                        GeneratedField::StreamChunk => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamChunk"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::StreamChunk)
;
                        }
                        GeneratedField::StreamTrailer => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamTrailer"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(data_packet::Value::StreamTrailer)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DataPacket {
                    kind: kind__.unwrap_or_default(),
                    participant_identity: participant_identity__.unwrap_or_default(),
                    destination_identities: destination_identities__.unwrap_or_default(),
                    value: value__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.DataPacket", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for data_packet::Kind {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Reliable => "RELIABLE",
            Self::Lossy => "LOSSY",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for data_packet::Kind {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "RELIABLE",
            "LOSSY",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = data_packet::Kind;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "RELIABLE" => Ok(data_packet::Kind::Reliable),
                    "LOSSY" => Ok(data_packet::Kind::Lossy),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for DataStream {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let len = 0;
        let struct_ser = serializer.serialize_struct("livekit.DataStream", len)?;
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DataStream {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                            Ok(GeneratedField::__SkipField__)
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DataStream;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DataStream")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DataStream, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                while map_.next_key::<GeneratedField>()?.is_some() {
                    let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                }
                Ok(DataStream {
                })
            }
        }
        deserializer.deserialize_struct("livekit.DataStream", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for data_stream::ByteHeader {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.name.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DataStream.ByteHeader", len)?;
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for data_stream::ByteHeader {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "name",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Name,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "name" => Ok(GeneratedField::Name),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = data_stream::ByteHeader;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DataStream.ByteHeader")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<data_stream::ByteHeader, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut name__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(data_stream::ByteHeader {
                    name: name__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DataStream.ByteHeader", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for data_stream::Chunk {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.stream_id.is_empty() {
            len += 1;
        }
        if self.chunk_index != 0 {
            len += 1;
        }
        if !self.content.is_empty() {
            len += 1;
        }
        if self.version != 0 {
            len += 1;
        }
        if self.iv.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DataStream.Chunk", len)?;
        if !self.stream_id.is_empty() {
            struct_ser.serialize_field("streamId", &self.stream_id)?;
        }
        if self.chunk_index != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("chunkIndex", ToString::to_string(&self.chunk_index).as_str())?;
        }
        if !self.content.is_empty() {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("content", pbjson::private::base64::encode(&self.content).as_str())?;
        }
        if self.version != 0 {
            struct_ser.serialize_field("version", &self.version)?;
        }
        if let Some(v) = self.iv.as_ref() {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("iv", pbjson::private::base64::encode(&v).as_str())?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for data_stream::Chunk {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "stream_id",
            "streamId",
            "chunk_index",
            "chunkIndex",
            "content",
            "version",
            "iv",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            StreamId,
            ChunkIndex,
            Content,
            Version,
            Iv,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "streamId" | "stream_id" => Ok(GeneratedField::StreamId),
                            "chunkIndex" | "chunk_index" => Ok(GeneratedField::ChunkIndex),
                            "content" => Ok(GeneratedField::Content),
                            "version" => Ok(GeneratedField::Version),
                            "iv" => Ok(GeneratedField::Iv),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = data_stream::Chunk;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DataStream.Chunk")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<data_stream::Chunk, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut stream_id__ = None;
                let mut chunk_index__ = None;
                let mut content__ = None;
                let mut version__ = None;
                let mut iv__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::StreamId => {
                            if stream_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamId"));
                            }
                            stream_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ChunkIndex => {
                            if chunk_index__.is_some() {
                                return Err(serde::de::Error::duplicate_field("chunkIndex"));
                            }
                            chunk_index__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Content => {
                            if content__.is_some() {
                                return Err(serde::de::Error::duplicate_field("content"));
                            }
                            content__ = 
                                Some(map_.next_value::<::pbjson::private::BytesDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Version => {
                            if version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("version"));
                            }
                            version__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Iv => {
                            if iv__.is_some() {
                                return Err(serde::de::Error::duplicate_field("iv"));
                            }
                            iv__ = 
                                map_.next_value::<::std::option::Option<::pbjson::private::BytesDeserialize<_>>>()?.map(|x| x.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(data_stream::Chunk {
                    stream_id: stream_id__.unwrap_or_default(),
                    chunk_index: chunk_index__.unwrap_or_default(),
                    content: content__.unwrap_or_default(),
                    version: version__.unwrap_or_default(),
                    iv: iv__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.DataStream.Chunk", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for data_stream::Header {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.stream_id.is_empty() {
            len += 1;
        }
        if self.timestamp != 0 {
            len += 1;
        }
        if !self.topic.is_empty() {
            len += 1;
        }
        if !self.mime_type.is_empty() {
            len += 1;
        }
        if self.total_length.is_some() {
            len += 1;
        }
        if self.encryption_type != 0 {
            len += 1;
        }
        if !self.attributes.is_empty() {
            len += 1;
        }
        if self.content_header.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DataStream.Header", len)?;
        if !self.stream_id.is_empty() {
            struct_ser.serialize_field("streamId", &self.stream_id)?;
        }
        if self.timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("timestamp", ToString::to_string(&self.timestamp).as_str())?;
        }
        if !self.topic.is_empty() {
            struct_ser.serialize_field("topic", &self.topic)?;
        }
        if !self.mime_type.is_empty() {
            struct_ser.serialize_field("mimeType", &self.mime_type)?;
        }
        if let Some(v) = self.total_length.as_ref() {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("totalLength", ToString::to_string(&v).as_str())?;
        }
        if self.encryption_type != 0 {
            let v = encryption::Type::try_from(self.encryption_type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.encryption_type)))?;
            struct_ser.serialize_field("encryptionType", &v)?;
        }
        if !self.attributes.is_empty() {
            struct_ser.serialize_field("attributes", &self.attributes)?;
        }
        if let Some(v) = self.content_header.as_ref() {
            match v {
                data_stream::header::ContentHeader::TextHeader(v) => {
                    struct_ser.serialize_field("textHeader", v)?;
                }
                data_stream::header::ContentHeader::ByteHeader(v) => {
                    struct_ser.serialize_field("byteHeader", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for data_stream::Header {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "stream_id",
            "streamId",
            "timestamp",
            "topic",
            "mime_type",
            "mimeType",
            "total_length",
            "totalLength",
            "encryption_type",
            "encryptionType",
            "attributes",
            "text_header",
            "textHeader",
            "byte_header",
            "byteHeader",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            StreamId,
            Timestamp,
            Topic,
            MimeType,
            TotalLength,
            EncryptionType,
            Attributes,
            TextHeader,
            ByteHeader,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "streamId" | "stream_id" => Ok(GeneratedField::StreamId),
                            "timestamp" => Ok(GeneratedField::Timestamp),
                            "topic" => Ok(GeneratedField::Topic),
                            "mimeType" | "mime_type" => Ok(GeneratedField::MimeType),
                            "totalLength" | "total_length" => Ok(GeneratedField::TotalLength),
                            "encryptionType" | "encryption_type" => Ok(GeneratedField::EncryptionType),
                            "attributes" => Ok(GeneratedField::Attributes),
                            "textHeader" | "text_header" => Ok(GeneratedField::TextHeader),
                            "byteHeader" | "byte_header" => Ok(GeneratedField::ByteHeader),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = data_stream::Header;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DataStream.Header")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<data_stream::Header, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut stream_id__ = None;
                let mut timestamp__ = None;
                let mut topic__ = None;
                let mut mime_type__ = None;
                let mut total_length__ = None;
                let mut encryption_type__ = None;
                let mut attributes__ = None;
                let mut content_header__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::StreamId => {
                            if stream_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamId"));
                            }
                            stream_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Timestamp => {
                            if timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("timestamp"));
                            }
                            timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Topic => {
                            if topic__.is_some() {
                                return Err(serde::de::Error::duplicate_field("topic"));
                            }
                            topic__ = Some(map_.next_value()?);
                        }
                        GeneratedField::MimeType => {
                            if mime_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("mimeType"));
                            }
                            mime_type__ = Some(map_.next_value()?);
                        }
                        GeneratedField::TotalLength => {
                            if total_length__.is_some() {
                                return Err(serde::de::Error::duplicate_field("totalLength"));
                            }
                            total_length__ = 
                                map_.next_value::<::std::option::Option<::pbjson::private::NumberDeserialize<_>>>()?.map(|x| x.0)
                            ;
                        }
                        GeneratedField::EncryptionType => {
                            if encryption_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("encryptionType"));
                            }
                            encryption_type__ = Some(map_.next_value::<encryption::Type>()? as i32);
                        }
                        GeneratedField::Attributes => {
                            if attributes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("attributes"));
                            }
                            attributes__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::TextHeader => {
                            if content_header__.is_some() {
                                return Err(serde::de::Error::duplicate_field("textHeader"));
                            }
                            content_header__ = map_.next_value::<::std::option::Option<_>>()?.map(data_stream::header::ContentHeader::TextHeader)
;
                        }
                        GeneratedField::ByteHeader => {
                            if content_header__.is_some() {
                                return Err(serde::de::Error::duplicate_field("byteHeader"));
                            }
                            content_header__ = map_.next_value::<::std::option::Option<_>>()?.map(data_stream::header::ContentHeader::ByteHeader)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(data_stream::Header {
                    stream_id: stream_id__.unwrap_or_default(),
                    timestamp: timestamp__.unwrap_or_default(),
                    topic: topic__.unwrap_or_default(),
                    mime_type: mime_type__.unwrap_or_default(),
                    total_length: total_length__,
                    encryption_type: encryption_type__.unwrap_or_default(),
                    attributes: attributes__.unwrap_or_default(),
                    content_header: content_header__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.DataStream.Header", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for data_stream::OperationType {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Create => "CREATE",
            Self::Update => "UPDATE",
            Self::Delete => "DELETE",
            Self::Reaction => "REACTION",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for data_stream::OperationType {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "CREATE",
            "UPDATE",
            "DELETE",
            "REACTION",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = data_stream::OperationType;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "CREATE" => Ok(data_stream::OperationType::Create),
                    "UPDATE" => Ok(data_stream::OperationType::Update),
                    "DELETE" => Ok(data_stream::OperationType::Delete),
                    "REACTION" => Ok(data_stream::OperationType::Reaction),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for data_stream::TextHeader {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.operation_type != 0 {
            len += 1;
        }
        if self.version != 0 {
            len += 1;
        }
        if !self.reply_to_stream_id.is_empty() {
            len += 1;
        }
        if !self.attached_stream_ids.is_empty() {
            len += 1;
        }
        if self.generated {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DataStream.TextHeader", len)?;
        if self.operation_type != 0 {
            let v = data_stream::OperationType::try_from(self.operation_type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.operation_type)))?;
            struct_ser.serialize_field("operationType", &v)?;
        }
        if self.version != 0 {
            struct_ser.serialize_field("version", &self.version)?;
        }
        if !self.reply_to_stream_id.is_empty() {
            struct_ser.serialize_field("replyToStreamId", &self.reply_to_stream_id)?;
        }
        if !self.attached_stream_ids.is_empty() {
            struct_ser.serialize_field("attachedStreamIds", &self.attached_stream_ids)?;
        }
        if self.generated {
            struct_ser.serialize_field("generated", &self.generated)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for data_stream::TextHeader {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "operation_type",
            "operationType",
            "version",
            "reply_to_stream_id",
            "replyToStreamId",
            "attached_stream_ids",
            "attachedStreamIds",
            "generated",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            OperationType,
            Version,
            ReplyToStreamId,
            AttachedStreamIds,
            Generated,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "operationType" | "operation_type" => Ok(GeneratedField::OperationType),
                            "version" => Ok(GeneratedField::Version),
                            "replyToStreamId" | "reply_to_stream_id" => Ok(GeneratedField::ReplyToStreamId),
                            "attachedStreamIds" | "attached_stream_ids" => Ok(GeneratedField::AttachedStreamIds),
                            "generated" => Ok(GeneratedField::Generated),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = data_stream::TextHeader;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DataStream.TextHeader")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<data_stream::TextHeader, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut operation_type__ = None;
                let mut version__ = None;
                let mut reply_to_stream_id__ = None;
                let mut attached_stream_ids__ = None;
                let mut generated__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::OperationType => {
                            if operation_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("operationType"));
                            }
                            operation_type__ = Some(map_.next_value::<data_stream::OperationType>()? as i32);
                        }
                        GeneratedField::Version => {
                            if version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("version"));
                            }
                            version__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ReplyToStreamId => {
                            if reply_to_stream_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("replyToStreamId"));
                            }
                            reply_to_stream_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AttachedStreamIds => {
                            if attached_stream_ids__.is_some() {
                                return Err(serde::de::Error::duplicate_field("attachedStreamIds"));
                            }
                            attached_stream_ids__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Generated => {
                            if generated__.is_some() {
                                return Err(serde::de::Error::duplicate_field("generated"));
                            }
                            generated__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(data_stream::TextHeader {
                    operation_type: operation_type__.unwrap_or_default(),
                    version: version__.unwrap_or_default(),
                    reply_to_stream_id: reply_to_stream_id__.unwrap_or_default(),
                    attached_stream_ids: attached_stream_ids__.unwrap_or_default(),
                    generated: generated__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DataStream.TextHeader", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for data_stream::Trailer {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.stream_id.is_empty() {
            len += 1;
        }
        if !self.reason.is_empty() {
            len += 1;
        }
        if !self.attributes.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DataStream.Trailer", len)?;
        if !self.stream_id.is_empty() {
            struct_ser.serialize_field("streamId", &self.stream_id)?;
        }
        if !self.reason.is_empty() {
            struct_ser.serialize_field("reason", &self.reason)?;
        }
        if !self.attributes.is_empty() {
            struct_ser.serialize_field("attributes", &self.attributes)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for data_stream::Trailer {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "stream_id",
            "streamId",
            "reason",
            "attributes",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            StreamId,
            Reason,
            Attributes,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "streamId" | "stream_id" => Ok(GeneratedField::StreamId),
                            "reason" => Ok(GeneratedField::Reason),
                            "attributes" => Ok(GeneratedField::Attributes),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = data_stream::Trailer;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DataStream.Trailer")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<data_stream::Trailer, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut stream_id__ = None;
                let mut reason__ = None;
                let mut attributes__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::StreamId => {
                            if stream_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamId"));
                            }
                            stream_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Reason => {
                            if reason__.is_some() {
                                return Err(serde::de::Error::duplicate_field("reason"));
                            }
                            reason__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Attributes => {
                            if attributes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("attributes"));
                            }
                            attributes__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(data_stream::Trailer {
                    stream_id: stream_id__.unwrap_or_default(),
                    reason: reason__.unwrap_or_default(),
                    attributes: attributes__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DataStream.Trailer", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DeleteAgentDispatchRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.dispatch_id.is_empty() {
            len += 1;
        }
        if !self.room.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DeleteAgentDispatchRequest", len)?;
        if !self.dispatch_id.is_empty() {
            struct_ser.serialize_field("dispatchId", &self.dispatch_id)?;
        }
        if !self.room.is_empty() {
            struct_ser.serialize_field("room", &self.room)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DeleteAgentDispatchRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "dispatch_id",
            "dispatchId",
            "room",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            DispatchId,
            Room,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "dispatchId" | "dispatch_id" => Ok(GeneratedField::DispatchId),
                            "room" => Ok(GeneratedField::Room),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DeleteAgentDispatchRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DeleteAgentDispatchRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DeleteAgentDispatchRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut dispatch_id__ = None;
                let mut room__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::DispatchId => {
                            if dispatch_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("dispatchId"));
                            }
                            dispatch_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DeleteAgentDispatchRequest {
                    dispatch_id: dispatch_id__.unwrap_or_default(),
                    room: room__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DeleteAgentDispatchRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DeleteIngressRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.ingress_id.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DeleteIngressRequest", len)?;
        if !self.ingress_id.is_empty() {
            struct_ser.serialize_field("ingressId", &self.ingress_id)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DeleteIngressRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "ingress_id",
            "ingressId",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            IngressId,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "ingressId" | "ingress_id" => Ok(GeneratedField::IngressId),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DeleteIngressRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DeleteIngressRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DeleteIngressRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut ingress_id__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::IngressId => {
                            if ingress_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("ingressId"));
                            }
                            ingress_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DeleteIngressRequest {
                    ingress_id: ingress_id__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DeleteIngressRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DeleteRoomRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.room.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DeleteRoomRequest", len)?;
        if !self.room.is_empty() {
            struct_ser.serialize_field("room", &self.room)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DeleteRoomRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Room,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "room" => Ok(GeneratedField::Room),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DeleteRoomRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DeleteRoomRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DeleteRoomRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DeleteRoomRequest {
                    room: room__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DeleteRoomRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DeleteRoomResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let len = 0;
        let struct_ser = serializer.serialize_struct("livekit.DeleteRoomResponse", len)?;
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DeleteRoomResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                            Ok(GeneratedField::__SkipField__)
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DeleteRoomResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DeleteRoomResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DeleteRoomResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                while map_.next_key::<GeneratedField>()?.is_some() {
                    let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                }
                Ok(DeleteRoomResponse {
                })
            }
        }
        deserializer.deserialize_struct("livekit.DeleteRoomResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DeleteSipDispatchRuleRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.sip_dispatch_rule_id.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DeleteSIPDispatchRuleRequest", len)?;
        if !self.sip_dispatch_rule_id.is_empty() {
            struct_ser.serialize_field("sipDispatchRuleId", &self.sip_dispatch_rule_id)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DeleteSipDispatchRuleRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sip_dispatch_rule_id",
            "sipDispatchRuleId",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            SipDispatchRuleId,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sipDispatchRuleId" | "sip_dispatch_rule_id" => Ok(GeneratedField::SipDispatchRuleId),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DeleteSipDispatchRuleRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DeleteSIPDispatchRuleRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DeleteSipDispatchRuleRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sip_dispatch_rule_id__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::SipDispatchRuleId => {
                            if sip_dispatch_rule_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sipDispatchRuleId"));
                            }
                            sip_dispatch_rule_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DeleteSipDispatchRuleRequest {
                    sip_dispatch_rule_id: sip_dispatch_rule_id__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DeleteSIPDispatchRuleRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DeleteSipTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.sip_trunk_id.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DeleteSIPTrunkRequest", len)?;
        if !self.sip_trunk_id.is_empty() {
            struct_ser.serialize_field("sipTrunkId", &self.sip_trunk_id)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DeleteSipTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sip_trunk_id",
            "sipTrunkId",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            SipTrunkId,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sipTrunkId" | "sip_trunk_id" => Ok(GeneratedField::SipTrunkId),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DeleteSipTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DeleteSIPTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DeleteSipTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sip_trunk_id__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::SipTrunkId => {
                            if sip_trunk_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sipTrunkId"));
                            }
                            sip_trunk_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DeleteSipTrunkRequest {
                    sip_trunk_id: sip_trunk_id__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DeleteSIPTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DirectFileOutput {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.filepath.is_empty() {
            len += 1;
        }
        if self.disable_manifest {
            len += 1;
        }
        if self.output.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DirectFileOutput", len)?;
        if !self.filepath.is_empty() {
            struct_ser.serialize_field("filepath", &self.filepath)?;
        }
        if self.disable_manifest {
            struct_ser.serialize_field("disableManifest", &self.disable_manifest)?;
        }
        if let Some(v) = self.output.as_ref() {
            match v {
                direct_file_output::Output::S3(v) => {
                    struct_ser.serialize_field("s3", v)?;
                }
                direct_file_output::Output::Gcp(v) => {
                    struct_ser.serialize_field("gcp", v)?;
                }
                direct_file_output::Output::Azure(v) => {
                    struct_ser.serialize_field("azure", v)?;
                }
                direct_file_output::Output::AliOss(v) => {
                    struct_ser.serialize_field("aliOSS", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DirectFileOutput {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "filepath",
            "disable_manifest",
            "disableManifest",
            "s3",
            "gcp",
            "azure",
            "aliOSS",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Filepath,
            DisableManifest,
            S3,
            Gcp,
            Azure,
            AliOss,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "filepath" => Ok(GeneratedField::Filepath),
                            "disableManifest" | "disable_manifest" => Ok(GeneratedField::DisableManifest),
                            "s3" => Ok(GeneratedField::S3),
                            "gcp" => Ok(GeneratedField::Gcp),
                            "azure" => Ok(GeneratedField::Azure),
                            "aliOSS" => Ok(GeneratedField::AliOss),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DirectFileOutput;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DirectFileOutput")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DirectFileOutput, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut filepath__ = None;
                let mut disable_manifest__ = None;
                let mut output__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Filepath => {
                            if filepath__.is_some() {
                                return Err(serde::de::Error::duplicate_field("filepath"));
                            }
                            filepath__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DisableManifest => {
                            if disable_manifest__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disableManifest"));
                            }
                            disable_manifest__ = Some(map_.next_value()?);
                        }
                        GeneratedField::S3 => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("s3"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(direct_file_output::Output::S3)
;
                        }
                        GeneratedField::Gcp => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("gcp"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(direct_file_output::Output::Gcp)
;
                        }
                        GeneratedField::Azure => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("azure"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(direct_file_output::Output::Azure)
;
                        }
                        GeneratedField::AliOss => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("aliOSS"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(direct_file_output::Output::AliOss)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DirectFileOutput {
                    filepath: filepath__.unwrap_or_default(),
                    disable_manifest: disable_manifest__.unwrap_or_default(),
                    output: output__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.DirectFileOutput", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DisabledCodecs {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.codecs.is_empty() {
            len += 1;
        }
        if !self.publish.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.DisabledCodecs", len)?;
        if !self.codecs.is_empty() {
            struct_ser.serialize_field("codecs", &self.codecs)?;
        }
        if !self.publish.is_empty() {
            struct_ser.serialize_field("publish", &self.publish)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for DisabledCodecs {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "codecs",
            "publish",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Codecs,
            Publish,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "codecs" => Ok(GeneratedField::Codecs),
                            "publish" => Ok(GeneratedField::Publish),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DisabledCodecs;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.DisabledCodecs")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<DisabledCodecs, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut codecs__ = None;
                let mut publish__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Codecs => {
                            if codecs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("codecs"));
                            }
                            codecs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Publish => {
                            if publish__.is_some() {
                                return Err(serde::de::Error::duplicate_field("publish"));
                            }
                            publish__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(DisabledCodecs {
                    codecs: codecs__.unwrap_or_default(),
                    publish: publish__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.DisabledCodecs", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for DisconnectReason {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::UnknownReason => "UNKNOWN_REASON",
            Self::ClientInitiated => "CLIENT_INITIATED",
            Self::DuplicateIdentity => "DUPLICATE_IDENTITY",
            Self::ServerShutdown => "SERVER_SHUTDOWN",
            Self::ParticipantRemoved => "PARTICIPANT_REMOVED",
            Self::RoomDeleted => "ROOM_DELETED",
            Self::StateMismatch => "STATE_MISMATCH",
            Self::JoinFailure => "JOIN_FAILURE",
            Self::Migration => "MIGRATION",
            Self::SignalClose => "SIGNAL_CLOSE",
            Self::RoomClosed => "ROOM_CLOSED",
            Self::UserUnavailable => "USER_UNAVAILABLE",
            Self::UserRejected => "USER_REJECTED",
            Self::SipTrunkFailure => "SIP_TRUNK_FAILURE",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for DisconnectReason {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "UNKNOWN_REASON",
            "CLIENT_INITIATED",
            "DUPLICATE_IDENTITY",
            "SERVER_SHUTDOWN",
            "PARTICIPANT_REMOVED",
            "ROOM_DELETED",
            "STATE_MISMATCH",
            "JOIN_FAILURE",
            "MIGRATION",
            "SIGNAL_CLOSE",
            "ROOM_CLOSED",
            "USER_UNAVAILABLE",
            "USER_REJECTED",
            "SIP_TRUNK_FAILURE",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = DisconnectReason;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "UNKNOWN_REASON" => Ok(DisconnectReason::UnknownReason),
                    "CLIENT_INITIATED" => Ok(DisconnectReason::ClientInitiated),
                    "DUPLICATE_IDENTITY" => Ok(DisconnectReason::DuplicateIdentity),
                    "SERVER_SHUTDOWN" => Ok(DisconnectReason::ServerShutdown),
                    "PARTICIPANT_REMOVED" => Ok(DisconnectReason::ParticipantRemoved),
                    "ROOM_DELETED" => Ok(DisconnectReason::RoomDeleted),
                    "STATE_MISMATCH" => Ok(DisconnectReason::StateMismatch),
                    "JOIN_FAILURE" => Ok(DisconnectReason::JoinFailure),
                    "MIGRATION" => Ok(DisconnectReason::Migration),
                    "SIGNAL_CLOSE" => Ok(DisconnectReason::SignalClose),
                    "ROOM_CLOSED" => Ok(DisconnectReason::RoomClosed),
                    "USER_UNAVAILABLE" => Ok(DisconnectReason::UserUnavailable),
                    "USER_REJECTED" => Ok(DisconnectReason::UserRejected),
                    "SIP_TRUNK_FAILURE" => Ok(DisconnectReason::SipTrunkFailure),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for EgressInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.egress_id.is_empty() {
            len += 1;
        }
        if !self.room_id.is_empty() {
            len += 1;
        }
        if !self.room_name.is_empty() {
            len += 1;
        }
        if self.source_type != 0 {
            len += 1;
        }
        if self.status != 0 {
            len += 1;
        }
        if self.started_at != 0 {
            len += 1;
        }
        if self.ended_at != 0 {
            len += 1;
        }
        if self.updated_at != 0 {
            len += 1;
        }
        if !self.details.is_empty() {
            len += 1;
        }
        if !self.error.is_empty() {
            len += 1;
        }
        if self.error_code != 0 {
            len += 1;
        }
        if !self.stream_results.is_empty() {
            len += 1;
        }
        if !self.file_results.is_empty() {
            len += 1;
        }
        if !self.segment_results.is_empty() {
            len += 1;
        }
        if !self.image_results.is_empty() {
            len += 1;
        }
        if !self.manifest_location.is_empty() {
            len += 1;
        }
        if self.backup_storage_used {
            len += 1;
        }
        if self.request.is_some() {
            len += 1;
        }
        if self.result.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.EgressInfo", len)?;
        if !self.egress_id.is_empty() {
            struct_ser.serialize_field("egressId", &self.egress_id)?;
        }
        if !self.room_id.is_empty() {
            struct_ser.serialize_field("roomId", &self.room_id)?;
        }
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if self.source_type != 0 {
            let v = EgressSourceType::try_from(self.source_type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.source_type)))?;
            struct_ser.serialize_field("sourceType", &v)?;
        }
        if self.status != 0 {
            let v = EgressStatus::try_from(self.status)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.status)))?;
            struct_ser.serialize_field("status", &v)?;
        }
        if self.started_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startedAt", ToString::to_string(&self.started_at).as_str())?;
        }
        if self.ended_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endedAt", ToString::to_string(&self.ended_at).as_str())?;
        }
        if self.updated_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("updatedAt", ToString::to_string(&self.updated_at).as_str())?;
        }
        if !self.details.is_empty() {
            struct_ser.serialize_field("details", &self.details)?;
        }
        if !self.error.is_empty() {
            struct_ser.serialize_field("error", &self.error)?;
        }
        if self.error_code != 0 {
            struct_ser.serialize_field("errorCode", &self.error_code)?;
        }
        if !self.stream_results.is_empty() {
            struct_ser.serialize_field("streamResults", &self.stream_results)?;
        }
        if !self.file_results.is_empty() {
            struct_ser.serialize_field("fileResults", &self.file_results)?;
        }
        if !self.segment_results.is_empty() {
            struct_ser.serialize_field("segmentResults", &self.segment_results)?;
        }
        if !self.image_results.is_empty() {
            struct_ser.serialize_field("imageResults", &self.image_results)?;
        }
        if !self.manifest_location.is_empty() {
            struct_ser.serialize_field("manifestLocation", &self.manifest_location)?;
        }
        if self.backup_storage_used {
            struct_ser.serialize_field("backupStorageUsed", &self.backup_storage_used)?;
        }
        if let Some(v) = self.request.as_ref() {
            match v {
                egress_info::Request::RoomComposite(v) => {
                    struct_ser.serialize_field("roomComposite", v)?;
                }
                egress_info::Request::Web(v) => {
                    struct_ser.serialize_field("web", v)?;
                }
                egress_info::Request::Participant(v) => {
                    struct_ser.serialize_field("participant", v)?;
                }
                egress_info::Request::TrackComposite(v) => {
                    struct_ser.serialize_field("trackComposite", v)?;
                }
                egress_info::Request::Track(v) => {
                    struct_ser.serialize_field("track", v)?;
                }
            }
        }
        if let Some(v) = self.result.as_ref() {
            match v {
                egress_info::Result::Stream(v) => {
                    struct_ser.serialize_field("stream", v)?;
                }
                egress_info::Result::File(v) => {
                    struct_ser.serialize_field("file", v)?;
                }
                egress_info::Result::Segments(v) => {
                    struct_ser.serialize_field("segments", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for EgressInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "egress_id",
            "egressId",
            "room_id",
            "roomId",
            "room_name",
            "roomName",
            "source_type",
            "sourceType",
            "status",
            "started_at",
            "startedAt",
            "ended_at",
            "endedAt",
            "updated_at",
            "updatedAt",
            "details",
            "error",
            "error_code",
            "errorCode",
            "stream_results",
            "streamResults",
            "file_results",
            "fileResults",
            "segment_results",
            "segmentResults",
            "image_results",
            "imageResults",
            "manifest_location",
            "manifestLocation",
            "backup_storage_used",
            "backupStorageUsed",
            "room_composite",
            "roomComposite",
            "web",
            "participant",
            "track_composite",
            "trackComposite",
            "track",
            "stream",
            "file",
            "segments",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            EgressId,
            RoomId,
            RoomName,
            SourceType,
            Status,
            StartedAt,
            EndedAt,
            UpdatedAt,
            Details,
            Error,
            ErrorCode,
            StreamResults,
            FileResults,
            SegmentResults,
            ImageResults,
            ManifestLocation,
            BackupStorageUsed,
            RoomComposite,
            Web,
            Participant,
            TrackComposite,
            Track,
            Stream,
            File,
            Segments,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "egressId" | "egress_id" => Ok(GeneratedField::EgressId),
                            "roomId" | "room_id" => Ok(GeneratedField::RoomId),
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "sourceType" | "source_type" => Ok(GeneratedField::SourceType),
                            "status" => Ok(GeneratedField::Status),
                            "startedAt" | "started_at" => Ok(GeneratedField::StartedAt),
                            "endedAt" | "ended_at" => Ok(GeneratedField::EndedAt),
                            "updatedAt" | "updated_at" => Ok(GeneratedField::UpdatedAt),
                            "details" => Ok(GeneratedField::Details),
                            "error" => Ok(GeneratedField::Error),
                            "errorCode" | "error_code" => Ok(GeneratedField::ErrorCode),
                            "streamResults" | "stream_results" => Ok(GeneratedField::StreamResults),
                            "fileResults" | "file_results" => Ok(GeneratedField::FileResults),
                            "segmentResults" | "segment_results" => Ok(GeneratedField::SegmentResults),
                            "imageResults" | "image_results" => Ok(GeneratedField::ImageResults),
                            "manifestLocation" | "manifest_location" => Ok(GeneratedField::ManifestLocation),
                            "backupStorageUsed" | "backup_storage_used" => Ok(GeneratedField::BackupStorageUsed),
                            "roomComposite" | "room_composite" => Ok(GeneratedField::RoomComposite),
                            "web" => Ok(GeneratedField::Web),
                            "participant" => Ok(GeneratedField::Participant),
                            "trackComposite" | "track_composite" => Ok(GeneratedField::TrackComposite),
                            "track" => Ok(GeneratedField::Track),
                            "stream" => Ok(GeneratedField::Stream),
                            "file" => Ok(GeneratedField::File),
                            "segments" => Ok(GeneratedField::Segments),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = EgressInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.EgressInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<EgressInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut egress_id__ = None;
                let mut room_id__ = None;
                let mut room_name__ = None;
                let mut source_type__ = None;
                let mut status__ = None;
                let mut started_at__ = None;
                let mut ended_at__ = None;
                let mut updated_at__ = None;
                let mut details__ = None;
                let mut error__ = None;
                let mut error_code__ = None;
                let mut stream_results__ = None;
                let mut file_results__ = None;
                let mut segment_results__ = None;
                let mut image_results__ = None;
                let mut manifest_location__ = None;
                let mut backup_storage_used__ = None;
                let mut request__ = None;
                let mut result__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::EgressId => {
                            if egress_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("egressId"));
                            }
                            egress_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomId => {
                            if room_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomId"));
                            }
                            room_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SourceType => {
                            if source_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sourceType"));
                            }
                            source_type__ = Some(map_.next_value::<EgressSourceType>()? as i32);
                        }
                        GeneratedField::Status => {
                            if status__.is_some() {
                                return Err(serde::de::Error::duplicate_field("status"));
                            }
                            status__ = Some(map_.next_value::<EgressStatus>()? as i32);
                        }
                        GeneratedField::StartedAt => {
                            if started_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startedAt"));
                            }
                            started_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndedAt => {
                            if ended_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endedAt"));
                            }
                            ended_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::UpdatedAt => {
                            if updated_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("updatedAt"));
                            }
                            updated_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Details => {
                            if details__.is_some() {
                                return Err(serde::de::Error::duplicate_field("details"));
                            }
                            details__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Error => {
                            if error__.is_some() {
                                return Err(serde::de::Error::duplicate_field("error"));
                            }
                            error__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ErrorCode => {
                            if error_code__.is_some() {
                                return Err(serde::de::Error::duplicate_field("errorCode"));
                            }
                            error_code__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::StreamResults => {
                            if stream_results__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamResults"));
                            }
                            stream_results__ = Some(map_.next_value()?);
                        }
                        GeneratedField::FileResults => {
                            if file_results__.is_some() {
                                return Err(serde::de::Error::duplicate_field("fileResults"));
                            }
                            file_results__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SegmentResults => {
                            if segment_results__.is_some() {
                                return Err(serde::de::Error::duplicate_field("segmentResults"));
                            }
                            segment_results__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ImageResults => {
                            if image_results__.is_some() {
                                return Err(serde::de::Error::duplicate_field("imageResults"));
                            }
                            image_results__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ManifestLocation => {
                            if manifest_location__.is_some() {
                                return Err(serde::de::Error::duplicate_field("manifestLocation"));
                            }
                            manifest_location__ = Some(map_.next_value()?);
                        }
                        GeneratedField::BackupStorageUsed => {
                            if backup_storage_used__.is_some() {
                                return Err(serde::de::Error::duplicate_field("backupStorageUsed"));
                            }
                            backup_storage_used__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomComposite => {
                            if request__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomComposite"));
                            }
                            request__ = map_.next_value::<::std::option::Option<_>>()?.map(egress_info::Request::RoomComposite)
;
                        }
                        GeneratedField::Web => {
                            if request__.is_some() {
                                return Err(serde::de::Error::duplicate_field("web"));
                            }
                            request__ = map_.next_value::<::std::option::Option<_>>()?.map(egress_info::Request::Web)
;
                        }
                        GeneratedField::Participant => {
                            if request__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participant"));
                            }
                            request__ = map_.next_value::<::std::option::Option<_>>()?.map(egress_info::Request::Participant)
;
                        }
                        GeneratedField::TrackComposite => {
                            if request__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trackComposite"));
                            }
                            request__ = map_.next_value::<::std::option::Option<_>>()?.map(egress_info::Request::TrackComposite)
;
                        }
                        GeneratedField::Track => {
                            if request__.is_some() {
                                return Err(serde::de::Error::duplicate_field("track"));
                            }
                            request__ = map_.next_value::<::std::option::Option<_>>()?.map(egress_info::Request::Track)
;
                        }
                        GeneratedField::Stream => {
                            if result__.is_some() {
                                return Err(serde::de::Error::duplicate_field("stream"));
                            }
                            result__ = map_.next_value::<::std::option::Option<_>>()?.map(egress_info::Result::Stream)
;
                        }
                        GeneratedField::File => {
                            if result__.is_some() {
                                return Err(serde::de::Error::duplicate_field("file"));
                            }
                            result__ = map_.next_value::<::std::option::Option<_>>()?.map(egress_info::Result::File)
;
                        }
                        GeneratedField::Segments => {
                            if result__.is_some() {
                                return Err(serde::de::Error::duplicate_field("segments"));
                            }
                            result__ = map_.next_value::<::std::option::Option<_>>()?.map(egress_info::Result::Segments)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(EgressInfo {
                    egress_id: egress_id__.unwrap_or_default(),
                    room_id: room_id__.unwrap_or_default(),
                    room_name: room_name__.unwrap_or_default(),
                    source_type: source_type__.unwrap_or_default(),
                    status: status__.unwrap_or_default(),
                    started_at: started_at__.unwrap_or_default(),
                    ended_at: ended_at__.unwrap_or_default(),
                    updated_at: updated_at__.unwrap_or_default(),
                    details: details__.unwrap_or_default(),
                    error: error__.unwrap_or_default(),
                    error_code: error_code__.unwrap_or_default(),
                    stream_results: stream_results__.unwrap_or_default(),
                    file_results: file_results__.unwrap_or_default(),
                    segment_results: segment_results__.unwrap_or_default(),
                    image_results: image_results__.unwrap_or_default(),
                    manifest_location: manifest_location__.unwrap_or_default(),
                    backup_storage_used: backup_storage_used__.unwrap_or_default(),
                    request: request__,
                    result: result__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.EgressInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for EgressSourceType {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Web => "EGRESS_SOURCE_TYPE_WEB",
            Self::Sdk => "EGRESS_SOURCE_TYPE_SDK",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for EgressSourceType {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "EGRESS_SOURCE_TYPE_WEB",
            "EGRESS_SOURCE_TYPE_SDK",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = EgressSourceType;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "EGRESS_SOURCE_TYPE_WEB" => Ok(EgressSourceType::Web),
                    "EGRESS_SOURCE_TYPE_SDK" => Ok(EgressSourceType::Sdk),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for EgressStatus {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::EgressStarting => "EGRESS_STARTING",
            Self::EgressActive => "EGRESS_ACTIVE",
            Self::EgressEnding => "EGRESS_ENDING",
            Self::EgressComplete => "EGRESS_COMPLETE",
            Self::EgressFailed => "EGRESS_FAILED",
            Self::EgressAborted => "EGRESS_ABORTED",
            Self::EgressLimitReached => "EGRESS_LIMIT_REACHED",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for EgressStatus {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "EGRESS_STARTING",
            "EGRESS_ACTIVE",
            "EGRESS_ENDING",
            "EGRESS_COMPLETE",
            "EGRESS_FAILED",
            "EGRESS_ABORTED",
            "EGRESS_LIMIT_REACHED",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = EgressStatus;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "EGRESS_STARTING" => Ok(EgressStatus::EgressStarting),
                    "EGRESS_ACTIVE" => Ok(EgressStatus::EgressActive),
                    "EGRESS_ENDING" => Ok(EgressStatus::EgressEnding),
                    "EGRESS_COMPLETE" => Ok(EgressStatus::EgressComplete),
                    "EGRESS_FAILED" => Ok(EgressStatus::EgressFailed),
                    "EGRESS_ABORTED" => Ok(EgressStatus::EgressAborted),
                    "EGRESS_LIMIT_REACHED" => Ok(EgressStatus::EgressLimitReached),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for EncodedFileOutput {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.file_type != 0 {
            len += 1;
        }
        if !self.filepath.is_empty() {
            len += 1;
        }
        if self.disable_manifest {
            len += 1;
        }
        if self.output.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.EncodedFileOutput", len)?;
        if self.file_type != 0 {
            let v = EncodedFileType::try_from(self.file_type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.file_type)))?;
            struct_ser.serialize_field("fileType", &v)?;
        }
        if !self.filepath.is_empty() {
            struct_ser.serialize_field("filepath", &self.filepath)?;
        }
        if self.disable_manifest {
            struct_ser.serialize_field("disableManifest", &self.disable_manifest)?;
        }
        if let Some(v) = self.output.as_ref() {
            match v {
                encoded_file_output::Output::S3(v) => {
                    struct_ser.serialize_field("s3", v)?;
                }
                encoded_file_output::Output::Gcp(v) => {
                    struct_ser.serialize_field("gcp", v)?;
                }
                encoded_file_output::Output::Azure(v) => {
                    struct_ser.serialize_field("azure", v)?;
                }
                encoded_file_output::Output::AliOss(v) => {
                    struct_ser.serialize_field("aliOSS", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for EncodedFileOutput {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "file_type",
            "fileType",
            "filepath",
            "disable_manifest",
            "disableManifest",
            "s3",
            "gcp",
            "azure",
            "aliOSS",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            FileType,
            Filepath,
            DisableManifest,
            S3,
            Gcp,
            Azure,
            AliOss,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "fileType" | "file_type" => Ok(GeneratedField::FileType),
                            "filepath" => Ok(GeneratedField::Filepath),
                            "disableManifest" | "disable_manifest" => Ok(GeneratedField::DisableManifest),
                            "s3" => Ok(GeneratedField::S3),
                            "gcp" => Ok(GeneratedField::Gcp),
                            "azure" => Ok(GeneratedField::Azure),
                            "aliOSS" => Ok(GeneratedField::AliOss),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = EncodedFileOutput;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.EncodedFileOutput")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<EncodedFileOutput, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut file_type__ = None;
                let mut filepath__ = None;
                let mut disable_manifest__ = None;
                let mut output__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::FileType => {
                            if file_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("fileType"));
                            }
                            file_type__ = Some(map_.next_value::<EncodedFileType>()? as i32);
                        }
                        GeneratedField::Filepath => {
                            if filepath__.is_some() {
                                return Err(serde::de::Error::duplicate_field("filepath"));
                            }
                            filepath__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DisableManifest => {
                            if disable_manifest__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disableManifest"));
                            }
                            disable_manifest__ = Some(map_.next_value()?);
                        }
                        GeneratedField::S3 => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("s3"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(encoded_file_output::Output::S3)
;
                        }
                        GeneratedField::Gcp => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("gcp"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(encoded_file_output::Output::Gcp)
;
                        }
                        GeneratedField::Azure => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("azure"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(encoded_file_output::Output::Azure)
;
                        }
                        GeneratedField::AliOss => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("aliOSS"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(encoded_file_output::Output::AliOss)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(EncodedFileOutput {
                    file_type: file_type__.unwrap_or_default(),
                    filepath: filepath__.unwrap_or_default(),
                    disable_manifest: disable_manifest__.unwrap_or_default(),
                    output: output__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.EncodedFileOutput", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for EncodedFileType {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::DefaultFiletype => "DEFAULT_FILETYPE",
            Self::Mp4 => "MP4",
            Self::Ogg => "OGG",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for EncodedFileType {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "DEFAULT_FILETYPE",
            "MP4",
            "OGG",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = EncodedFileType;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "DEFAULT_FILETYPE" => Ok(EncodedFileType::DefaultFiletype),
                    "MP4" => Ok(EncodedFileType::Mp4),
                    "OGG" => Ok(EncodedFileType::Ogg),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for EncodingOptions {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.width != 0 {
            len += 1;
        }
        if self.height != 0 {
            len += 1;
        }
        if self.depth != 0 {
            len += 1;
        }
        if self.framerate != 0 {
            len += 1;
        }
        if self.audio_codec != 0 {
            len += 1;
        }
        if self.audio_bitrate != 0 {
            len += 1;
        }
        if self.audio_quality != 0 {
            len += 1;
        }
        if self.audio_frequency != 0 {
            len += 1;
        }
        if self.video_codec != 0 {
            len += 1;
        }
        if self.video_bitrate != 0 {
            len += 1;
        }
        if self.video_quality != 0 {
            len += 1;
        }
        if self.key_frame_interval != 0. {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.EncodingOptions", len)?;
        if self.width != 0 {
            struct_ser.serialize_field("width", &self.width)?;
        }
        if self.height != 0 {
            struct_ser.serialize_field("height", &self.height)?;
        }
        if self.depth != 0 {
            struct_ser.serialize_field("depth", &self.depth)?;
        }
        if self.framerate != 0 {
            struct_ser.serialize_field("framerate", &self.framerate)?;
        }
        if self.audio_codec != 0 {
            let v = AudioCodec::try_from(self.audio_codec)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.audio_codec)))?;
            struct_ser.serialize_field("audioCodec", &v)?;
        }
        if self.audio_bitrate != 0 {
            struct_ser.serialize_field("audioBitrate", &self.audio_bitrate)?;
        }
        if self.audio_quality != 0 {
            struct_ser.serialize_field("audioQuality", &self.audio_quality)?;
        }
        if self.audio_frequency != 0 {
            struct_ser.serialize_field("audioFrequency", &self.audio_frequency)?;
        }
        if self.video_codec != 0 {
            let v = VideoCodec::try_from(self.video_codec)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.video_codec)))?;
            struct_ser.serialize_field("videoCodec", &v)?;
        }
        if self.video_bitrate != 0 {
            struct_ser.serialize_field("videoBitrate", &self.video_bitrate)?;
        }
        if self.video_quality != 0 {
            struct_ser.serialize_field("videoQuality", &self.video_quality)?;
        }
        if self.key_frame_interval != 0. {
            struct_ser.serialize_field("keyFrameInterval", &self.key_frame_interval)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for EncodingOptions {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "width",
            "height",
            "depth",
            "framerate",
            "audio_codec",
            "audioCodec",
            "audio_bitrate",
            "audioBitrate",
            "audio_quality",
            "audioQuality",
            "audio_frequency",
            "audioFrequency",
            "video_codec",
            "videoCodec",
            "video_bitrate",
            "videoBitrate",
            "video_quality",
            "videoQuality",
            "key_frame_interval",
            "keyFrameInterval",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Width,
            Height,
            Depth,
            Framerate,
            AudioCodec,
            AudioBitrate,
            AudioQuality,
            AudioFrequency,
            VideoCodec,
            VideoBitrate,
            VideoQuality,
            KeyFrameInterval,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "width" => Ok(GeneratedField::Width),
                            "height" => Ok(GeneratedField::Height),
                            "depth" => Ok(GeneratedField::Depth),
                            "framerate" => Ok(GeneratedField::Framerate),
                            "audioCodec" | "audio_codec" => Ok(GeneratedField::AudioCodec),
                            "audioBitrate" | "audio_bitrate" => Ok(GeneratedField::AudioBitrate),
                            "audioQuality" | "audio_quality" => Ok(GeneratedField::AudioQuality),
                            "audioFrequency" | "audio_frequency" => Ok(GeneratedField::AudioFrequency),
                            "videoCodec" | "video_codec" => Ok(GeneratedField::VideoCodec),
                            "videoBitrate" | "video_bitrate" => Ok(GeneratedField::VideoBitrate),
                            "videoQuality" | "video_quality" => Ok(GeneratedField::VideoQuality),
                            "keyFrameInterval" | "key_frame_interval" => Ok(GeneratedField::KeyFrameInterval),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = EncodingOptions;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.EncodingOptions")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<EncodingOptions, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut width__ = None;
                let mut height__ = None;
                let mut depth__ = None;
                let mut framerate__ = None;
                let mut audio_codec__ = None;
                let mut audio_bitrate__ = None;
                let mut audio_quality__ = None;
                let mut audio_frequency__ = None;
                let mut video_codec__ = None;
                let mut video_bitrate__ = None;
                let mut video_quality__ = None;
                let mut key_frame_interval__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Width => {
                            if width__.is_some() {
                                return Err(serde::de::Error::duplicate_field("width"));
                            }
                            width__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Height => {
                            if height__.is_some() {
                                return Err(serde::de::Error::duplicate_field("height"));
                            }
                            height__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Depth => {
                            if depth__.is_some() {
                                return Err(serde::de::Error::duplicate_field("depth"));
                            }
                            depth__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Framerate => {
                            if framerate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("framerate"));
                            }
                            framerate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::AudioCodec => {
                            if audio_codec__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audioCodec"));
                            }
                            audio_codec__ = Some(map_.next_value::<AudioCodec>()? as i32);
                        }
                        GeneratedField::AudioBitrate => {
                            if audio_bitrate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audioBitrate"));
                            }
                            audio_bitrate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::AudioQuality => {
                            if audio_quality__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audioQuality"));
                            }
                            audio_quality__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::AudioFrequency => {
                            if audio_frequency__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audioFrequency"));
                            }
                            audio_frequency__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::VideoCodec => {
                            if video_codec__.is_some() {
                                return Err(serde::de::Error::duplicate_field("videoCodec"));
                            }
                            video_codec__ = Some(map_.next_value::<VideoCodec>()? as i32);
                        }
                        GeneratedField::VideoBitrate => {
                            if video_bitrate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("videoBitrate"));
                            }
                            video_bitrate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::VideoQuality => {
                            if video_quality__.is_some() {
                                return Err(serde::de::Error::duplicate_field("videoQuality"));
                            }
                            video_quality__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::KeyFrameInterval => {
                            if key_frame_interval__.is_some() {
                                return Err(serde::de::Error::duplicate_field("keyFrameInterval"));
                            }
                            key_frame_interval__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(EncodingOptions {
                    width: width__.unwrap_or_default(),
                    height: height__.unwrap_or_default(),
                    depth: depth__.unwrap_or_default(),
                    framerate: framerate__.unwrap_or_default(),
                    audio_codec: audio_codec__.unwrap_or_default(),
                    audio_bitrate: audio_bitrate__.unwrap_or_default(),
                    audio_quality: audio_quality__.unwrap_or_default(),
                    audio_frequency: audio_frequency__.unwrap_or_default(),
                    video_codec: video_codec__.unwrap_or_default(),
                    video_bitrate: video_bitrate__.unwrap_or_default(),
                    video_quality: video_quality__.unwrap_or_default(),
                    key_frame_interval: key_frame_interval__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.EncodingOptions", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for EncodingOptionsPreset {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::H264720p30 => "H264_720P_30",
            Self::H264720p60 => "H264_720P_60",
            Self::H2641080p30 => "H264_1080P_30",
            Self::H2641080p60 => "H264_1080P_60",
            Self::PortraitH264720p30 => "PORTRAIT_H264_720P_30",
            Self::PortraitH264720p60 => "PORTRAIT_H264_720P_60",
            Self::PortraitH2641080p30 => "PORTRAIT_H264_1080P_30",
            Self::PortraitH2641080p60 => "PORTRAIT_H264_1080P_60",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for EncodingOptionsPreset {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "H264_720P_30",
            "H264_720P_60",
            "H264_1080P_30",
            "H264_1080P_60",
            "PORTRAIT_H264_720P_30",
            "PORTRAIT_H264_720P_60",
            "PORTRAIT_H264_1080P_30",
            "PORTRAIT_H264_1080P_60",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = EncodingOptionsPreset;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "H264_720P_30" => Ok(EncodingOptionsPreset::H264720p30),
                    "H264_720P_60" => Ok(EncodingOptionsPreset::H264720p60),
                    "H264_1080P_30" => Ok(EncodingOptionsPreset::H2641080p30),
                    "H264_1080P_60" => Ok(EncodingOptionsPreset::H2641080p60),
                    "PORTRAIT_H264_720P_30" => Ok(EncodingOptionsPreset::PortraitH264720p30),
                    "PORTRAIT_H264_720P_60" => Ok(EncodingOptionsPreset::PortraitH264720p60),
                    "PORTRAIT_H264_1080P_30" => Ok(EncodingOptionsPreset::PortraitH2641080p30),
                    "PORTRAIT_H264_1080P_60" => Ok(EncodingOptionsPreset::PortraitH2641080p60),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for Encryption {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let len = 0;
        let struct_ser = serializer.serialize_struct("livekit.Encryption", len)?;
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for Encryption {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                            Ok(GeneratedField::__SkipField__)
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = Encryption;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.Encryption")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<Encryption, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                while map_.next_key::<GeneratedField>()?.is_some() {
                    let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                }
                Ok(Encryption {
                })
            }
        }
        deserializer.deserialize_struct("livekit.Encryption", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for encryption::Type {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::None => "NONE",
            Self::Gcm => "GCM",
            Self::Custom => "CUSTOM",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for encryption::Type {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "NONE",
            "GCM",
            "CUSTOM",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = encryption::Type;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "NONE" => Ok(encryption::Type::None),
                    "GCM" => Ok(encryption::Type::Gcm),
                    "CUSTOM" => Ok(encryption::Type::Custom),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for EventMetric {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.label != 0 {
            len += 1;
        }
        if self.participant_identity != 0 {
            len += 1;
        }
        if self.track_sid != 0 {
            len += 1;
        }
        if self.start_timestamp_ms != 0 {
            len += 1;
        }
        if self.end_timestamp_ms.is_some() {
            len += 1;
        }
        if self.normalized_start_timestamp.is_some() {
            len += 1;
        }
        if self.normalized_end_timestamp.is_some() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        if self.rid != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.EventMetric", len)?;
        if self.label != 0 {
            struct_ser.serialize_field("label", &self.label)?;
        }
        if self.participant_identity != 0 {
            struct_ser.serialize_field("participantIdentity", &self.participant_identity)?;
        }
        if self.track_sid != 0 {
            struct_ser.serialize_field("trackSid", &self.track_sid)?;
        }
        if self.start_timestamp_ms != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startTimestampMs", ToString::to_string(&self.start_timestamp_ms).as_str())?;
        }
        if let Some(v) = self.end_timestamp_ms.as_ref() {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endTimestampMs", ToString::to_string(&v).as_str())?;
        }
        if let Some(v) = self.normalized_start_timestamp.as_ref() {
            struct_ser.serialize_field("normalizedStartTimestamp", v)?;
        }
        if let Some(v) = self.normalized_end_timestamp.as_ref() {
            struct_ser.serialize_field("normalizedEndTimestamp", v)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        if self.rid != 0 {
            struct_ser.serialize_field("rid", &self.rid)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for EventMetric {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "label",
            "participant_identity",
            "participantIdentity",
            "track_sid",
            "trackSid",
            "start_timestamp_ms",
            "startTimestampMs",
            "end_timestamp_ms",
            "endTimestampMs",
            "normalized_start_timestamp",
            "normalizedStartTimestamp",
            "normalized_end_timestamp",
            "normalizedEndTimestamp",
            "metadata",
            "rid",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Label,
            ParticipantIdentity,
            TrackSid,
            StartTimestampMs,
            EndTimestampMs,
            NormalizedStartTimestamp,
            NormalizedEndTimestamp,
            Metadata,
            Rid,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "label" => Ok(GeneratedField::Label),
                            "participantIdentity" | "participant_identity" => Ok(GeneratedField::ParticipantIdentity),
                            "trackSid" | "track_sid" => Ok(GeneratedField::TrackSid),
                            "startTimestampMs" | "start_timestamp_ms" => Ok(GeneratedField::StartTimestampMs),
                            "endTimestampMs" | "end_timestamp_ms" => Ok(GeneratedField::EndTimestampMs),
                            "normalizedStartTimestamp" | "normalized_start_timestamp" => Ok(GeneratedField::NormalizedStartTimestamp),
                            "normalizedEndTimestamp" | "normalized_end_timestamp" => Ok(GeneratedField::NormalizedEndTimestamp),
                            "metadata" => Ok(GeneratedField::Metadata),
                            "rid" => Ok(GeneratedField::Rid),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = EventMetric;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.EventMetric")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<EventMetric, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut label__ = None;
                let mut participant_identity__ = None;
                let mut track_sid__ = None;
                let mut start_timestamp_ms__ = None;
                let mut end_timestamp_ms__ = None;
                let mut normalized_start_timestamp__ = None;
                let mut normalized_end_timestamp__ = None;
                let mut metadata__ = None;
                let mut rid__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Label => {
                            if label__.is_some() {
                                return Err(serde::de::Error::duplicate_field("label"));
                            }
                            label__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ParticipantIdentity => {
                            if participant_identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantIdentity"));
                            }
                            participant_identity__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::TrackSid => {
                            if track_sid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trackSid"));
                            }
                            track_sid__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::StartTimestampMs => {
                            if start_timestamp_ms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startTimestampMs"));
                            }
                            start_timestamp_ms__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndTimestampMs => {
                            if end_timestamp_ms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endTimestampMs"));
                            }
                            end_timestamp_ms__ = 
                                map_.next_value::<::std::option::Option<::pbjson::private::NumberDeserialize<_>>>()?.map(|x| x.0)
                            ;
                        }
                        GeneratedField::NormalizedStartTimestamp => {
                            if normalized_start_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("normalizedStartTimestamp"));
                            }
                            normalized_start_timestamp__ = map_.next_value()?;
                        }
                        GeneratedField::NormalizedEndTimestamp => {
                            if normalized_end_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("normalizedEndTimestamp"));
                            }
                            normalized_end_timestamp__ = map_.next_value()?;
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Rid => {
                            if rid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rid"));
                            }
                            rid__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(EventMetric {
                    label: label__.unwrap_or_default(),
                    participant_identity: participant_identity__.unwrap_or_default(),
                    track_sid: track_sid__.unwrap_or_default(),
                    start_timestamp_ms: start_timestamp_ms__.unwrap_or_default(),
                    end_timestamp_ms: end_timestamp_ms__,
                    normalized_start_timestamp: normalized_start_timestamp__,
                    normalized_end_timestamp: normalized_end_timestamp__,
                    metadata: metadata__.unwrap_or_default(),
                    rid: rid__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.EventMetric", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for FileInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.filename.is_empty() {
            len += 1;
        }
        if self.started_at != 0 {
            len += 1;
        }
        if self.ended_at != 0 {
            len += 1;
        }
        if self.duration != 0 {
            len += 1;
        }
        if self.size != 0 {
            len += 1;
        }
        if !self.location.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.FileInfo", len)?;
        if !self.filename.is_empty() {
            struct_ser.serialize_field("filename", &self.filename)?;
        }
        if self.started_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startedAt", ToString::to_string(&self.started_at).as_str())?;
        }
        if self.ended_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endedAt", ToString::to_string(&self.ended_at).as_str())?;
        }
        if self.duration != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("duration", ToString::to_string(&self.duration).as_str())?;
        }
        if self.size != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("size", ToString::to_string(&self.size).as_str())?;
        }
        if !self.location.is_empty() {
            struct_ser.serialize_field("location", &self.location)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for FileInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "filename",
            "started_at",
            "startedAt",
            "ended_at",
            "endedAt",
            "duration",
            "size",
            "location",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Filename,
            StartedAt,
            EndedAt,
            Duration,
            Size,
            Location,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "filename" => Ok(GeneratedField::Filename),
                            "startedAt" | "started_at" => Ok(GeneratedField::StartedAt),
                            "endedAt" | "ended_at" => Ok(GeneratedField::EndedAt),
                            "duration" => Ok(GeneratedField::Duration),
                            "size" => Ok(GeneratedField::Size),
                            "location" => Ok(GeneratedField::Location),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = FileInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.FileInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<FileInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut filename__ = None;
                let mut started_at__ = None;
                let mut ended_at__ = None;
                let mut duration__ = None;
                let mut size__ = None;
                let mut location__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Filename => {
                            if filename__.is_some() {
                                return Err(serde::de::Error::duplicate_field("filename"));
                            }
                            filename__ = Some(map_.next_value()?);
                        }
                        GeneratedField::StartedAt => {
                            if started_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startedAt"));
                            }
                            started_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndedAt => {
                            if ended_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endedAt"));
                            }
                            ended_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Duration => {
                            if duration__.is_some() {
                                return Err(serde::de::Error::duplicate_field("duration"));
                            }
                            duration__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Size => {
                            if size__.is_some() {
                                return Err(serde::de::Error::duplicate_field("size"));
                            }
                            size__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Location => {
                            if location__.is_some() {
                                return Err(serde::de::Error::duplicate_field("location"));
                            }
                            location__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(FileInfo {
                    filename: filename__.unwrap_or_default(),
                    started_at: started_at__.unwrap_or_default(),
                    ended_at: ended_at__.unwrap_or_default(),
                    duration: duration__.unwrap_or_default(),
                    size: size__.unwrap_or_default(),
                    location: location__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.FileInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for GcpUpload {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.credentials.is_empty() {
            len += 1;
        }
        if !self.bucket.is_empty() {
            len += 1;
        }
        if self.proxy.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.GCPUpload", len)?;
        if !self.credentials.is_empty() {
            struct_ser.serialize_field("credentials", &self.credentials)?;
        }
        if !self.bucket.is_empty() {
            struct_ser.serialize_field("bucket", &self.bucket)?;
        }
        if let Some(v) = self.proxy.as_ref() {
            struct_ser.serialize_field("proxy", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for GcpUpload {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "credentials",
            "bucket",
            "proxy",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Credentials,
            Bucket,
            Proxy,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "credentials" => Ok(GeneratedField::Credentials),
                            "bucket" => Ok(GeneratedField::Bucket),
                            "proxy" => Ok(GeneratedField::Proxy),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = GcpUpload;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.GCPUpload")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<GcpUpload, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut credentials__ = None;
                let mut bucket__ = None;
                let mut proxy__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Credentials => {
                            if credentials__.is_some() {
                                return Err(serde::de::Error::duplicate_field("credentials"));
                            }
                            credentials__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Bucket => {
                            if bucket__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bucket"));
                            }
                            bucket__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Proxy => {
                            if proxy__.is_some() {
                                return Err(serde::de::Error::duplicate_field("proxy"));
                            }
                            proxy__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(GcpUpload {
                    credentials: credentials__.unwrap_or_default(),
                    bucket: bucket__.unwrap_or_default(),
                    proxy: proxy__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.GCPUpload", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for GetSipInboundTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.sip_trunk_id.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.GetSIPInboundTrunkRequest", len)?;
        if !self.sip_trunk_id.is_empty() {
            struct_ser.serialize_field("sipTrunkId", &self.sip_trunk_id)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for GetSipInboundTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sip_trunk_id",
            "sipTrunkId",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            SipTrunkId,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sipTrunkId" | "sip_trunk_id" => Ok(GeneratedField::SipTrunkId),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = GetSipInboundTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.GetSIPInboundTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<GetSipInboundTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sip_trunk_id__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::SipTrunkId => {
                            if sip_trunk_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sipTrunkId"));
                            }
                            sip_trunk_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(GetSipInboundTrunkRequest {
                    sip_trunk_id: sip_trunk_id__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.GetSIPInboundTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for GetSipInboundTrunkResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.trunk.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.GetSIPInboundTrunkResponse", len)?;
        if let Some(v) = self.trunk.as_ref() {
            struct_ser.serialize_field("trunk", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for GetSipInboundTrunkResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "trunk",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Trunk,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "trunk" => Ok(GeneratedField::Trunk),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = GetSipInboundTrunkResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.GetSIPInboundTrunkResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<GetSipInboundTrunkResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut trunk__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Trunk => {
                            if trunk__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunk"));
                            }
                            trunk__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(GetSipInboundTrunkResponse {
                    trunk: trunk__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.GetSIPInboundTrunkResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for GetSipOutboundTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.sip_trunk_id.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.GetSIPOutboundTrunkRequest", len)?;
        if !self.sip_trunk_id.is_empty() {
            struct_ser.serialize_field("sipTrunkId", &self.sip_trunk_id)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for GetSipOutboundTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sip_trunk_id",
            "sipTrunkId",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            SipTrunkId,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sipTrunkId" | "sip_trunk_id" => Ok(GeneratedField::SipTrunkId),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = GetSipOutboundTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.GetSIPOutboundTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<GetSipOutboundTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sip_trunk_id__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::SipTrunkId => {
                            if sip_trunk_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sipTrunkId"));
                            }
                            sip_trunk_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(GetSipOutboundTrunkRequest {
                    sip_trunk_id: sip_trunk_id__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.GetSIPOutboundTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for GetSipOutboundTrunkResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.trunk.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.GetSIPOutboundTrunkResponse", len)?;
        if let Some(v) = self.trunk.as_ref() {
            struct_ser.serialize_field("trunk", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for GetSipOutboundTrunkResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "trunk",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Trunk,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "trunk" => Ok(GeneratedField::Trunk),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = GetSipOutboundTrunkResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.GetSIPOutboundTrunkResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<GetSipOutboundTrunkResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut trunk__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Trunk => {
                            if trunk__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunk"));
                            }
                            trunk__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(GetSipOutboundTrunkResponse {
                    trunk: trunk__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.GetSIPOutboundTrunkResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for IceServer {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.urls.is_empty() {
            len += 1;
        }
        if !self.username.is_empty() {
            len += 1;
        }
        if !self.credential.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ICEServer", len)?;
        if !self.urls.is_empty() {
            struct_ser.serialize_field("urls", &self.urls)?;
        }
        if !self.username.is_empty() {
            struct_ser.serialize_field("username", &self.username)?;
        }
        if !self.credential.is_empty() {
            struct_ser.serialize_field("credential", &self.credential)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for IceServer {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "urls",
            "username",
            "credential",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Urls,
            Username,
            Credential,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "urls" => Ok(GeneratedField::Urls),
                            "username" => Ok(GeneratedField::Username),
                            "credential" => Ok(GeneratedField::Credential),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IceServer;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ICEServer")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<IceServer, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut urls__ = None;
                let mut username__ = None;
                let mut credential__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Urls => {
                            if urls__.is_some() {
                                return Err(serde::de::Error::duplicate_field("urls"));
                            }
                            urls__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Username => {
                            if username__.is_some() {
                                return Err(serde::de::Error::duplicate_field("username"));
                            }
                            username__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Credential => {
                            if credential__.is_some() {
                                return Err(serde::de::Error::duplicate_field("credential"));
                            }
                            credential__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(IceServer {
                    urls: urls__.unwrap_or_default(),
                    username: username__.unwrap_or_default(),
                    credential: credential__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ICEServer", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ImageCodec {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::IcDefault => "IC_DEFAULT",
            Self::IcJpeg => "IC_JPEG",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for ImageCodec {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "IC_DEFAULT",
            "IC_JPEG",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ImageCodec;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "IC_DEFAULT" => Ok(ImageCodec::IcDefault),
                    "IC_JPEG" => Ok(ImageCodec::IcJpeg),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for ImageFileSuffix {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::ImageSuffixIndex => "IMAGE_SUFFIX_INDEX",
            Self::ImageSuffixTimestamp => "IMAGE_SUFFIX_TIMESTAMP",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for ImageFileSuffix {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "IMAGE_SUFFIX_INDEX",
            "IMAGE_SUFFIX_TIMESTAMP",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ImageFileSuffix;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "IMAGE_SUFFIX_INDEX" => Ok(ImageFileSuffix::ImageSuffixIndex),
                    "IMAGE_SUFFIX_TIMESTAMP" => Ok(ImageFileSuffix::ImageSuffixTimestamp),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for ImageOutput {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.capture_interval != 0 {
            len += 1;
        }
        if self.width != 0 {
            len += 1;
        }
        if self.height != 0 {
            len += 1;
        }
        if !self.filename_prefix.is_empty() {
            len += 1;
        }
        if self.filename_suffix != 0 {
            len += 1;
        }
        if self.image_codec != 0 {
            len += 1;
        }
        if self.disable_manifest {
            len += 1;
        }
        if self.output.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ImageOutput", len)?;
        if self.capture_interval != 0 {
            struct_ser.serialize_field("captureInterval", &self.capture_interval)?;
        }
        if self.width != 0 {
            struct_ser.serialize_field("width", &self.width)?;
        }
        if self.height != 0 {
            struct_ser.serialize_field("height", &self.height)?;
        }
        if !self.filename_prefix.is_empty() {
            struct_ser.serialize_field("filenamePrefix", &self.filename_prefix)?;
        }
        if self.filename_suffix != 0 {
            let v = ImageFileSuffix::try_from(self.filename_suffix)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.filename_suffix)))?;
            struct_ser.serialize_field("filenameSuffix", &v)?;
        }
        if self.image_codec != 0 {
            let v = ImageCodec::try_from(self.image_codec)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.image_codec)))?;
            struct_ser.serialize_field("imageCodec", &v)?;
        }
        if self.disable_manifest {
            struct_ser.serialize_field("disableManifest", &self.disable_manifest)?;
        }
        if let Some(v) = self.output.as_ref() {
            match v {
                image_output::Output::S3(v) => {
                    struct_ser.serialize_field("s3", v)?;
                }
                image_output::Output::Gcp(v) => {
                    struct_ser.serialize_field("gcp", v)?;
                }
                image_output::Output::Azure(v) => {
                    struct_ser.serialize_field("azure", v)?;
                }
                image_output::Output::AliOss(v) => {
                    struct_ser.serialize_field("aliOSS", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ImageOutput {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "capture_interval",
            "captureInterval",
            "width",
            "height",
            "filename_prefix",
            "filenamePrefix",
            "filename_suffix",
            "filenameSuffix",
            "image_codec",
            "imageCodec",
            "disable_manifest",
            "disableManifest",
            "s3",
            "gcp",
            "azure",
            "aliOSS",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            CaptureInterval,
            Width,
            Height,
            FilenamePrefix,
            FilenameSuffix,
            ImageCodec,
            DisableManifest,
            S3,
            Gcp,
            Azure,
            AliOss,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "captureInterval" | "capture_interval" => Ok(GeneratedField::CaptureInterval),
                            "width" => Ok(GeneratedField::Width),
                            "height" => Ok(GeneratedField::Height),
                            "filenamePrefix" | "filename_prefix" => Ok(GeneratedField::FilenamePrefix),
                            "filenameSuffix" | "filename_suffix" => Ok(GeneratedField::FilenameSuffix),
                            "imageCodec" | "image_codec" => Ok(GeneratedField::ImageCodec),
                            "disableManifest" | "disable_manifest" => Ok(GeneratedField::DisableManifest),
                            "s3" => Ok(GeneratedField::S3),
                            "gcp" => Ok(GeneratedField::Gcp),
                            "azure" => Ok(GeneratedField::Azure),
                            "aliOSS" => Ok(GeneratedField::AliOss),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ImageOutput;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ImageOutput")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ImageOutput, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut capture_interval__ = None;
                let mut width__ = None;
                let mut height__ = None;
                let mut filename_prefix__ = None;
                let mut filename_suffix__ = None;
                let mut image_codec__ = None;
                let mut disable_manifest__ = None;
                let mut output__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::CaptureInterval => {
                            if capture_interval__.is_some() {
                                return Err(serde::de::Error::duplicate_field("captureInterval"));
                            }
                            capture_interval__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Width => {
                            if width__.is_some() {
                                return Err(serde::de::Error::duplicate_field("width"));
                            }
                            width__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Height => {
                            if height__.is_some() {
                                return Err(serde::de::Error::duplicate_field("height"));
                            }
                            height__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::FilenamePrefix => {
                            if filename_prefix__.is_some() {
                                return Err(serde::de::Error::duplicate_field("filenamePrefix"));
                            }
                            filename_prefix__ = Some(map_.next_value()?);
                        }
                        GeneratedField::FilenameSuffix => {
                            if filename_suffix__.is_some() {
                                return Err(serde::de::Error::duplicate_field("filenameSuffix"));
                            }
                            filename_suffix__ = Some(map_.next_value::<ImageFileSuffix>()? as i32);
                        }
                        GeneratedField::ImageCodec => {
                            if image_codec__.is_some() {
                                return Err(serde::de::Error::duplicate_field("imageCodec"));
                            }
                            image_codec__ = Some(map_.next_value::<ImageCodec>()? as i32);
                        }
                        GeneratedField::DisableManifest => {
                            if disable_manifest__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disableManifest"));
                            }
                            disable_manifest__ = Some(map_.next_value()?);
                        }
                        GeneratedField::S3 => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("s3"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(image_output::Output::S3)
;
                        }
                        GeneratedField::Gcp => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("gcp"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(image_output::Output::Gcp)
;
                        }
                        GeneratedField::Azure => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("azure"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(image_output::Output::Azure)
;
                        }
                        GeneratedField::AliOss => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("aliOSS"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(image_output::Output::AliOss)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ImageOutput {
                    capture_interval: capture_interval__.unwrap_or_default(),
                    width: width__.unwrap_or_default(),
                    height: height__.unwrap_or_default(),
                    filename_prefix: filename_prefix__.unwrap_or_default(),
                    filename_suffix: filename_suffix__.unwrap_or_default(),
                    image_codec: image_codec__.unwrap_or_default(),
                    disable_manifest: disable_manifest__.unwrap_or_default(),
                    output: output__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.ImageOutput", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ImagesInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.filename_prefix.is_empty() {
            len += 1;
        }
        if self.image_count != 0 {
            len += 1;
        }
        if self.started_at != 0 {
            len += 1;
        }
        if self.ended_at != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ImagesInfo", len)?;
        if !self.filename_prefix.is_empty() {
            struct_ser.serialize_field("filenamePrefix", &self.filename_prefix)?;
        }
        if self.image_count != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("imageCount", ToString::to_string(&self.image_count).as_str())?;
        }
        if self.started_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startedAt", ToString::to_string(&self.started_at).as_str())?;
        }
        if self.ended_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endedAt", ToString::to_string(&self.ended_at).as_str())?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ImagesInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "filename_prefix",
            "filenamePrefix",
            "image_count",
            "imageCount",
            "started_at",
            "startedAt",
            "ended_at",
            "endedAt",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            FilenamePrefix,
            ImageCount,
            StartedAt,
            EndedAt,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "filenamePrefix" | "filename_prefix" => Ok(GeneratedField::FilenamePrefix),
                            "imageCount" | "image_count" => Ok(GeneratedField::ImageCount),
                            "startedAt" | "started_at" => Ok(GeneratedField::StartedAt),
                            "endedAt" | "ended_at" => Ok(GeneratedField::EndedAt),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ImagesInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ImagesInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ImagesInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut filename_prefix__ = None;
                let mut image_count__ = None;
                let mut started_at__ = None;
                let mut ended_at__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::FilenamePrefix => {
                            if filename_prefix__.is_some() {
                                return Err(serde::de::Error::duplicate_field("filenamePrefix"));
                            }
                            filename_prefix__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ImageCount => {
                            if image_count__.is_some() {
                                return Err(serde::de::Error::duplicate_field("imageCount"));
                            }
                            image_count__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::StartedAt => {
                            if started_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startedAt"));
                            }
                            started_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndedAt => {
                            if ended_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endedAt"));
                            }
                            ended_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ImagesInfo {
                    filename_prefix: filename_prefix__.unwrap_or_default(),
                    image_count: image_count__.unwrap_or_default(),
                    started_at: started_at__.unwrap_or_default(),
                    ended_at: ended_at__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ImagesInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for IngressAudioEncodingOptions {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.audio_codec != 0 {
            len += 1;
        }
        if self.bitrate != 0 {
            len += 1;
        }
        if self.disable_dtx {
            len += 1;
        }
        if self.channels != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.IngressAudioEncodingOptions", len)?;
        if self.audio_codec != 0 {
            let v = AudioCodec::try_from(self.audio_codec)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.audio_codec)))?;
            struct_ser.serialize_field("audioCodec", &v)?;
        }
        if self.bitrate != 0 {
            struct_ser.serialize_field("bitrate", &self.bitrate)?;
        }
        if self.disable_dtx {
            struct_ser.serialize_field("disableDtx", &self.disable_dtx)?;
        }
        if self.channels != 0 {
            struct_ser.serialize_field("channels", &self.channels)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for IngressAudioEncodingOptions {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "audio_codec",
            "audioCodec",
            "bitrate",
            "disable_dtx",
            "disableDtx",
            "channels",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            AudioCodec,
            Bitrate,
            DisableDtx,
            Channels,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "audioCodec" | "audio_codec" => Ok(GeneratedField::AudioCodec),
                            "bitrate" => Ok(GeneratedField::Bitrate),
                            "disableDtx" | "disable_dtx" => Ok(GeneratedField::DisableDtx),
                            "channels" => Ok(GeneratedField::Channels),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressAudioEncodingOptions;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.IngressAudioEncodingOptions")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<IngressAudioEncodingOptions, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut audio_codec__ = None;
                let mut bitrate__ = None;
                let mut disable_dtx__ = None;
                let mut channels__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::AudioCodec => {
                            if audio_codec__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audioCodec"));
                            }
                            audio_codec__ = Some(map_.next_value::<AudioCodec>()? as i32);
                        }
                        GeneratedField::Bitrate => {
                            if bitrate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bitrate"));
                            }
                            bitrate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DisableDtx => {
                            if disable_dtx__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disableDtx"));
                            }
                            disable_dtx__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Channels => {
                            if channels__.is_some() {
                                return Err(serde::de::Error::duplicate_field("channels"));
                            }
                            channels__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(IngressAudioEncodingOptions {
                    audio_codec: audio_codec__.unwrap_or_default(),
                    bitrate: bitrate__.unwrap_or_default(),
                    disable_dtx: disable_dtx__.unwrap_or_default(),
                    channels: channels__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.IngressAudioEncodingOptions", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for IngressAudioEncodingPreset {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::OpusStereo96kbps => "OPUS_STEREO_96KBPS",
            Self::OpusMono64kbs => "OPUS_MONO_64KBS",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for IngressAudioEncodingPreset {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "OPUS_STEREO_96KBPS",
            "OPUS_MONO_64KBS",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressAudioEncodingPreset;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "OPUS_STEREO_96KBPS" => Ok(IngressAudioEncodingPreset::OpusStereo96kbps),
                    "OPUS_MONO_64KBS" => Ok(IngressAudioEncodingPreset::OpusMono64kbs),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for IngressAudioOptions {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.name.is_empty() {
            len += 1;
        }
        if self.source != 0 {
            len += 1;
        }
        if self.encoding_options.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.IngressAudioOptions", len)?;
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if self.source != 0 {
            let v = TrackSource::try_from(self.source)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.source)))?;
            struct_ser.serialize_field("source", &v)?;
        }
        if let Some(v) = self.encoding_options.as_ref() {
            match v {
                ingress_audio_options::EncodingOptions::Preset(v) => {
                    let v = IngressAudioEncodingPreset::try_from(*v)
                        .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", *v)))?;
                    struct_ser.serialize_field("preset", &v)?;
                }
                ingress_audio_options::EncodingOptions::Options(v) => {
                    struct_ser.serialize_field("options", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for IngressAudioOptions {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "name",
            "source",
            "preset",
            "options",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Name,
            Source,
            Preset,
            Options,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "name" => Ok(GeneratedField::Name),
                            "source" => Ok(GeneratedField::Source),
                            "preset" => Ok(GeneratedField::Preset),
                            "options" => Ok(GeneratedField::Options),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressAudioOptions;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.IngressAudioOptions")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<IngressAudioOptions, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut name__ = None;
                let mut source__ = None;
                let mut encoding_options__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Source => {
                            if source__.is_some() {
                                return Err(serde::de::Error::duplicate_field("source"));
                            }
                            source__ = Some(map_.next_value::<TrackSource>()? as i32);
                        }
                        GeneratedField::Preset => {
                            if encoding_options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("preset"));
                            }
                            encoding_options__ = map_.next_value::<::std::option::Option<IngressAudioEncodingPreset>>()?.map(|x| ingress_audio_options::EncodingOptions::Preset(x as i32));
                        }
                        GeneratedField::Options => {
                            if encoding_options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("options"));
                            }
                            encoding_options__ = map_.next_value::<::std::option::Option<_>>()?.map(ingress_audio_options::EncodingOptions::Options)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(IngressAudioOptions {
                    name: name__.unwrap_or_default(),
                    source: source__.unwrap_or_default(),
                    encoding_options: encoding_options__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.IngressAudioOptions", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for IngressInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.ingress_id.is_empty() {
            len += 1;
        }
        if !self.name.is_empty() {
            len += 1;
        }
        if !self.stream_key.is_empty() {
            len += 1;
        }
        if !self.url.is_empty() {
            len += 1;
        }
        if self.input_type != 0 {
            len += 1;
        }
        if self.bypass_transcoding {
            len += 1;
        }
        if self.enable_transcoding.is_some() {
            len += 1;
        }
        if self.audio.is_some() {
            len += 1;
        }
        if self.video.is_some() {
            len += 1;
        }
        if !self.room_name.is_empty() {
            len += 1;
        }
        if !self.participant_identity.is_empty() {
            len += 1;
        }
        if !self.participant_name.is_empty() {
            len += 1;
        }
        if !self.participant_metadata.is_empty() {
            len += 1;
        }
        if self.reusable {
            len += 1;
        }
        if self.state.is_some() {
            len += 1;
        }
        if self.enabled.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.IngressInfo", len)?;
        if !self.ingress_id.is_empty() {
            struct_ser.serialize_field("ingressId", &self.ingress_id)?;
        }
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if !self.stream_key.is_empty() {
            struct_ser.serialize_field("streamKey", &self.stream_key)?;
        }
        if !self.url.is_empty() {
            struct_ser.serialize_field("url", &self.url)?;
        }
        if self.input_type != 0 {
            let v = IngressInput::try_from(self.input_type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.input_type)))?;
            struct_ser.serialize_field("inputType", &v)?;
        }
        if self.bypass_transcoding {
            struct_ser.serialize_field("bypassTranscoding", &self.bypass_transcoding)?;
        }
        if let Some(v) = self.enable_transcoding.as_ref() {
            struct_ser.serialize_field("enableTranscoding", v)?;
        }
        if let Some(v) = self.audio.as_ref() {
            struct_ser.serialize_field("audio", v)?;
        }
        if let Some(v) = self.video.as_ref() {
            struct_ser.serialize_field("video", v)?;
        }
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if !self.participant_identity.is_empty() {
            struct_ser.serialize_field("participantIdentity", &self.participant_identity)?;
        }
        if !self.participant_name.is_empty() {
            struct_ser.serialize_field("participantName", &self.participant_name)?;
        }
        if !self.participant_metadata.is_empty() {
            struct_ser.serialize_field("participantMetadata", &self.participant_metadata)?;
        }
        if self.reusable {
            struct_ser.serialize_field("reusable", &self.reusable)?;
        }
        if let Some(v) = self.state.as_ref() {
            struct_ser.serialize_field("state", v)?;
        }
        if let Some(v) = self.enabled.as_ref() {
            struct_ser.serialize_field("enabled", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for IngressInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "ingress_id",
            "ingressId",
            "name",
            "stream_key",
            "streamKey",
            "url",
            "input_type",
            "inputType",
            "bypass_transcoding",
            "bypassTranscoding",
            "enable_transcoding",
            "enableTranscoding",
            "audio",
            "video",
            "room_name",
            "roomName",
            "participant_identity",
            "participantIdentity",
            "participant_name",
            "participantName",
            "participant_metadata",
            "participantMetadata",
            "reusable",
            "state",
            "enabled",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            IngressId,
            Name,
            StreamKey,
            Url,
            InputType,
            BypassTranscoding,
            EnableTranscoding,
            Audio,
            Video,
            RoomName,
            ParticipantIdentity,
            ParticipantName,
            ParticipantMetadata,
            Reusable,
            State,
            Enabled,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "ingressId" | "ingress_id" => Ok(GeneratedField::IngressId),
                            "name" => Ok(GeneratedField::Name),
                            "streamKey" | "stream_key" => Ok(GeneratedField::StreamKey),
                            "url" => Ok(GeneratedField::Url),
                            "inputType" | "input_type" => Ok(GeneratedField::InputType),
                            "bypassTranscoding" | "bypass_transcoding" => Ok(GeneratedField::BypassTranscoding),
                            "enableTranscoding" | "enable_transcoding" => Ok(GeneratedField::EnableTranscoding),
                            "audio" => Ok(GeneratedField::Audio),
                            "video" => Ok(GeneratedField::Video),
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "participantIdentity" | "participant_identity" => Ok(GeneratedField::ParticipantIdentity),
                            "participantName" | "participant_name" => Ok(GeneratedField::ParticipantName),
                            "participantMetadata" | "participant_metadata" => Ok(GeneratedField::ParticipantMetadata),
                            "reusable" => Ok(GeneratedField::Reusable),
                            "state" => Ok(GeneratedField::State),
                            "enabled" => Ok(GeneratedField::Enabled),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.IngressInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<IngressInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut ingress_id__ = None;
                let mut name__ = None;
                let mut stream_key__ = None;
                let mut url__ = None;
                let mut input_type__ = None;
                let mut bypass_transcoding__ = None;
                let mut enable_transcoding__ = None;
                let mut audio__ = None;
                let mut video__ = None;
                let mut room_name__ = None;
                let mut participant_identity__ = None;
                let mut participant_name__ = None;
                let mut participant_metadata__ = None;
                let mut reusable__ = None;
                let mut state__ = None;
                let mut enabled__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::IngressId => {
                            if ingress_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("ingressId"));
                            }
                            ingress_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::StreamKey => {
                            if stream_key__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamKey"));
                            }
                            stream_key__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Url => {
                            if url__.is_some() {
                                return Err(serde::de::Error::duplicate_field("url"));
                            }
                            url__ = Some(map_.next_value()?);
                        }
                        GeneratedField::InputType => {
                            if input_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("inputType"));
                            }
                            input_type__ = Some(map_.next_value::<IngressInput>()? as i32);
                        }
                        GeneratedField::BypassTranscoding => {
                            if bypass_transcoding__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bypassTranscoding"));
                            }
                            bypass_transcoding__ = Some(map_.next_value()?);
                        }
                        GeneratedField::EnableTranscoding => {
                            if enable_transcoding__.is_some() {
                                return Err(serde::de::Error::duplicate_field("enableTranscoding"));
                            }
                            enable_transcoding__ = map_.next_value()?;
                        }
                        GeneratedField::Audio => {
                            if audio__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audio"));
                            }
                            audio__ = map_.next_value()?;
                        }
                        GeneratedField::Video => {
                            if video__.is_some() {
                                return Err(serde::de::Error::duplicate_field("video"));
                            }
                            video__ = map_.next_value()?;
                        }
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantIdentity => {
                            if participant_identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantIdentity"));
                            }
                            participant_identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantName => {
                            if participant_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantName"));
                            }
                            participant_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantMetadata => {
                            if participant_metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantMetadata"));
                            }
                            participant_metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Reusable => {
                            if reusable__.is_some() {
                                return Err(serde::de::Error::duplicate_field("reusable"));
                            }
                            reusable__ = Some(map_.next_value()?);
                        }
                        GeneratedField::State => {
                            if state__.is_some() {
                                return Err(serde::de::Error::duplicate_field("state"));
                            }
                            state__ = map_.next_value()?;
                        }
                        GeneratedField::Enabled => {
                            if enabled__.is_some() {
                                return Err(serde::de::Error::duplicate_field("enabled"));
                            }
                            enabled__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(IngressInfo {
                    ingress_id: ingress_id__.unwrap_or_default(),
                    name: name__.unwrap_or_default(),
                    stream_key: stream_key__.unwrap_or_default(),
                    url: url__.unwrap_or_default(),
                    input_type: input_type__.unwrap_or_default(),
                    bypass_transcoding: bypass_transcoding__.unwrap_or_default(),
                    enable_transcoding: enable_transcoding__,
                    audio: audio__,
                    video: video__,
                    room_name: room_name__.unwrap_or_default(),
                    participant_identity: participant_identity__.unwrap_or_default(),
                    participant_name: participant_name__.unwrap_or_default(),
                    participant_metadata: participant_metadata__.unwrap_or_default(),
                    reusable: reusable__.unwrap_or_default(),
                    state: state__,
                    enabled: enabled__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.IngressInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for IngressInput {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::RtmpInput => "RTMP_INPUT",
            Self::WhipInput => "WHIP_INPUT",
            Self::UrlInput => "URL_INPUT",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for IngressInput {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "RTMP_INPUT",
            "WHIP_INPUT",
            "URL_INPUT",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressInput;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "RTMP_INPUT" => Ok(IngressInput::RtmpInput),
                    "WHIP_INPUT" => Ok(IngressInput::WhipInput),
                    "URL_INPUT" => Ok(IngressInput::UrlInput),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for IngressState {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.status != 0 {
            len += 1;
        }
        if !self.error.is_empty() {
            len += 1;
        }
        if self.video.is_some() {
            len += 1;
        }
        if self.audio.is_some() {
            len += 1;
        }
        if !self.room_id.is_empty() {
            len += 1;
        }
        if self.started_at != 0 {
            len += 1;
        }
        if self.ended_at != 0 {
            len += 1;
        }
        if self.updated_at != 0 {
            len += 1;
        }
        if !self.resource_id.is_empty() {
            len += 1;
        }
        if !self.tracks.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.IngressState", len)?;
        if self.status != 0 {
            let v = ingress_state::Status::try_from(self.status)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.status)))?;
            struct_ser.serialize_field("status", &v)?;
        }
        if !self.error.is_empty() {
            struct_ser.serialize_field("error", &self.error)?;
        }
        if let Some(v) = self.video.as_ref() {
            struct_ser.serialize_field("video", v)?;
        }
        if let Some(v) = self.audio.as_ref() {
            struct_ser.serialize_field("audio", v)?;
        }
        if !self.room_id.is_empty() {
            struct_ser.serialize_field("roomId", &self.room_id)?;
        }
        if self.started_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startedAt", ToString::to_string(&self.started_at).as_str())?;
        }
        if self.ended_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endedAt", ToString::to_string(&self.ended_at).as_str())?;
        }
        if self.updated_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("updatedAt", ToString::to_string(&self.updated_at).as_str())?;
        }
        if !self.resource_id.is_empty() {
            struct_ser.serialize_field("resourceId", &self.resource_id)?;
        }
        if !self.tracks.is_empty() {
            struct_ser.serialize_field("tracks", &self.tracks)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for IngressState {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "status",
            "error",
            "video",
            "audio",
            "room_id",
            "roomId",
            "started_at",
            "startedAt",
            "ended_at",
            "endedAt",
            "updated_at",
            "updatedAt",
            "resource_id",
            "resourceId",
            "tracks",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Status,
            Error,
            Video,
            Audio,
            RoomId,
            StartedAt,
            EndedAt,
            UpdatedAt,
            ResourceId,
            Tracks,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "status" => Ok(GeneratedField::Status),
                            "error" => Ok(GeneratedField::Error),
                            "video" => Ok(GeneratedField::Video),
                            "audio" => Ok(GeneratedField::Audio),
                            "roomId" | "room_id" => Ok(GeneratedField::RoomId),
                            "startedAt" | "started_at" => Ok(GeneratedField::StartedAt),
                            "endedAt" | "ended_at" => Ok(GeneratedField::EndedAt),
                            "updatedAt" | "updated_at" => Ok(GeneratedField::UpdatedAt),
                            "resourceId" | "resource_id" => Ok(GeneratedField::ResourceId),
                            "tracks" => Ok(GeneratedField::Tracks),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressState;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.IngressState")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<IngressState, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut status__ = None;
                let mut error__ = None;
                let mut video__ = None;
                let mut audio__ = None;
                let mut room_id__ = None;
                let mut started_at__ = None;
                let mut ended_at__ = None;
                let mut updated_at__ = None;
                let mut resource_id__ = None;
                let mut tracks__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Status => {
                            if status__.is_some() {
                                return Err(serde::de::Error::duplicate_field("status"));
                            }
                            status__ = Some(map_.next_value::<ingress_state::Status>()? as i32);
                        }
                        GeneratedField::Error => {
                            if error__.is_some() {
                                return Err(serde::de::Error::duplicate_field("error"));
                            }
                            error__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Video => {
                            if video__.is_some() {
                                return Err(serde::de::Error::duplicate_field("video"));
                            }
                            video__ = map_.next_value()?;
                        }
                        GeneratedField::Audio => {
                            if audio__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audio"));
                            }
                            audio__ = map_.next_value()?;
                        }
                        GeneratedField::RoomId => {
                            if room_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomId"));
                            }
                            room_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::StartedAt => {
                            if started_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startedAt"));
                            }
                            started_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndedAt => {
                            if ended_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endedAt"));
                            }
                            ended_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::UpdatedAt => {
                            if updated_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("updatedAt"));
                            }
                            updated_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ResourceId => {
                            if resource_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("resourceId"));
                            }
                            resource_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Tracks => {
                            if tracks__.is_some() {
                                return Err(serde::de::Error::duplicate_field("tracks"));
                            }
                            tracks__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(IngressState {
                    status: status__.unwrap_or_default(),
                    error: error__.unwrap_or_default(),
                    video: video__,
                    audio: audio__,
                    room_id: room_id__.unwrap_or_default(),
                    started_at: started_at__.unwrap_or_default(),
                    ended_at: ended_at__.unwrap_or_default(),
                    updated_at: updated_at__.unwrap_or_default(),
                    resource_id: resource_id__.unwrap_or_default(),
                    tracks: tracks__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.IngressState", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ingress_state::Status {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::EndpointInactive => "ENDPOINT_INACTIVE",
            Self::EndpointBuffering => "ENDPOINT_BUFFERING",
            Self::EndpointPublishing => "ENDPOINT_PUBLISHING",
            Self::EndpointError => "ENDPOINT_ERROR",
            Self::EndpointComplete => "ENDPOINT_COMPLETE",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for ingress_state::Status {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "ENDPOINT_INACTIVE",
            "ENDPOINT_BUFFERING",
            "ENDPOINT_PUBLISHING",
            "ENDPOINT_ERROR",
            "ENDPOINT_COMPLETE",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ingress_state::Status;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "ENDPOINT_INACTIVE" => Ok(ingress_state::Status::EndpointInactive),
                    "ENDPOINT_BUFFERING" => Ok(ingress_state::Status::EndpointBuffering),
                    "ENDPOINT_PUBLISHING" => Ok(ingress_state::Status::EndpointPublishing),
                    "ENDPOINT_ERROR" => Ok(ingress_state::Status::EndpointError),
                    "ENDPOINT_COMPLETE" => Ok(ingress_state::Status::EndpointComplete),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for IngressVideoEncodingOptions {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.video_codec != 0 {
            len += 1;
        }
        if self.frame_rate != 0. {
            len += 1;
        }
        if !self.layers.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.IngressVideoEncodingOptions", len)?;
        if self.video_codec != 0 {
            let v = VideoCodec::try_from(self.video_codec)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.video_codec)))?;
            struct_ser.serialize_field("videoCodec", &v)?;
        }
        if self.frame_rate != 0. {
            struct_ser.serialize_field("frameRate", &self.frame_rate)?;
        }
        if !self.layers.is_empty() {
            struct_ser.serialize_field("layers", &self.layers)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for IngressVideoEncodingOptions {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "video_codec",
            "videoCodec",
            "frame_rate",
            "frameRate",
            "layers",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            VideoCodec,
            FrameRate,
            Layers,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "videoCodec" | "video_codec" => Ok(GeneratedField::VideoCodec),
                            "frameRate" | "frame_rate" => Ok(GeneratedField::FrameRate),
                            "layers" => Ok(GeneratedField::Layers),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressVideoEncodingOptions;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.IngressVideoEncodingOptions")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<IngressVideoEncodingOptions, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut video_codec__ = None;
                let mut frame_rate__ = None;
                let mut layers__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::VideoCodec => {
                            if video_codec__.is_some() {
                                return Err(serde::de::Error::duplicate_field("videoCodec"));
                            }
                            video_codec__ = Some(map_.next_value::<VideoCodec>()? as i32);
                        }
                        GeneratedField::FrameRate => {
                            if frame_rate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("frameRate"));
                            }
                            frame_rate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Layers => {
                            if layers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("layers"));
                            }
                            layers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(IngressVideoEncodingOptions {
                    video_codec: video_codec__.unwrap_or_default(),
                    frame_rate: frame_rate__.unwrap_or_default(),
                    layers: layers__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.IngressVideoEncodingOptions", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for IngressVideoEncodingPreset {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::H264720p30fps3Layers => "H264_720P_30FPS_3_LAYERS",
            Self::H2641080p30fps3Layers => "H264_1080P_30FPS_3_LAYERS",
            Self::H264540p25fps2Layers => "H264_540P_25FPS_2_LAYERS",
            Self::H264720p30fps1Layer => "H264_720P_30FPS_1_LAYER",
            Self::H2641080p30fps1Layer => "H264_1080P_30FPS_1_LAYER",
            Self::H264720p30fps3LayersHighMotion => "H264_720P_30FPS_3_LAYERS_HIGH_MOTION",
            Self::H2641080p30fps3LayersHighMotion => "H264_1080P_30FPS_3_LAYERS_HIGH_MOTION",
            Self::H264540p25fps2LayersHighMotion => "H264_540P_25FPS_2_LAYERS_HIGH_MOTION",
            Self::H264720p30fps1LayerHighMotion => "H264_720P_30FPS_1_LAYER_HIGH_MOTION",
            Self::H2641080p30fps1LayerHighMotion => "H264_1080P_30FPS_1_LAYER_HIGH_MOTION",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for IngressVideoEncodingPreset {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "H264_720P_30FPS_3_LAYERS",
            "H264_1080P_30FPS_3_LAYERS",
            "H264_540P_25FPS_2_LAYERS",
            "H264_720P_30FPS_1_LAYER",
            "H264_1080P_30FPS_1_LAYER",
            "H264_720P_30FPS_3_LAYERS_HIGH_MOTION",
            "H264_1080P_30FPS_3_LAYERS_HIGH_MOTION",
            "H264_540P_25FPS_2_LAYERS_HIGH_MOTION",
            "H264_720P_30FPS_1_LAYER_HIGH_MOTION",
            "H264_1080P_30FPS_1_LAYER_HIGH_MOTION",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressVideoEncodingPreset;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "H264_720P_30FPS_3_LAYERS" => Ok(IngressVideoEncodingPreset::H264720p30fps3Layers),
                    "H264_1080P_30FPS_3_LAYERS" => Ok(IngressVideoEncodingPreset::H2641080p30fps3Layers),
                    "H264_540P_25FPS_2_LAYERS" => Ok(IngressVideoEncodingPreset::H264540p25fps2Layers),
                    "H264_720P_30FPS_1_LAYER" => Ok(IngressVideoEncodingPreset::H264720p30fps1Layer),
                    "H264_1080P_30FPS_1_LAYER" => Ok(IngressVideoEncodingPreset::H2641080p30fps1Layer),
                    "H264_720P_30FPS_3_LAYERS_HIGH_MOTION" => Ok(IngressVideoEncodingPreset::H264720p30fps3LayersHighMotion),
                    "H264_1080P_30FPS_3_LAYERS_HIGH_MOTION" => Ok(IngressVideoEncodingPreset::H2641080p30fps3LayersHighMotion),
                    "H264_540P_25FPS_2_LAYERS_HIGH_MOTION" => Ok(IngressVideoEncodingPreset::H264540p25fps2LayersHighMotion),
                    "H264_720P_30FPS_1_LAYER_HIGH_MOTION" => Ok(IngressVideoEncodingPreset::H264720p30fps1LayerHighMotion),
                    "H264_1080P_30FPS_1_LAYER_HIGH_MOTION" => Ok(IngressVideoEncodingPreset::H2641080p30fps1LayerHighMotion),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for IngressVideoOptions {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.name.is_empty() {
            len += 1;
        }
        if self.source != 0 {
            len += 1;
        }
        if self.encoding_options.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.IngressVideoOptions", len)?;
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if self.source != 0 {
            let v = TrackSource::try_from(self.source)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.source)))?;
            struct_ser.serialize_field("source", &v)?;
        }
        if let Some(v) = self.encoding_options.as_ref() {
            match v {
                ingress_video_options::EncodingOptions::Preset(v) => {
                    let v = IngressVideoEncodingPreset::try_from(*v)
                        .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", *v)))?;
                    struct_ser.serialize_field("preset", &v)?;
                }
                ingress_video_options::EncodingOptions::Options(v) => {
                    struct_ser.serialize_field("options", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for IngressVideoOptions {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "name",
            "source",
            "preset",
            "options",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Name,
            Source,
            Preset,
            Options,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "name" => Ok(GeneratedField::Name),
                            "source" => Ok(GeneratedField::Source),
                            "preset" => Ok(GeneratedField::Preset),
                            "options" => Ok(GeneratedField::Options),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = IngressVideoOptions;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.IngressVideoOptions")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<IngressVideoOptions, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut name__ = None;
                let mut source__ = None;
                let mut encoding_options__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Source => {
                            if source__.is_some() {
                                return Err(serde::de::Error::duplicate_field("source"));
                            }
                            source__ = Some(map_.next_value::<TrackSource>()? as i32);
                        }
                        GeneratedField::Preset => {
                            if encoding_options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("preset"));
                            }
                            encoding_options__ = map_.next_value::<::std::option::Option<IngressVideoEncodingPreset>>()?.map(|x| ingress_video_options::EncodingOptions::Preset(x as i32));
                        }
                        GeneratedField::Options => {
                            if encoding_options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("options"));
                            }
                            encoding_options__ = map_.next_value::<::std::option::Option<_>>()?.map(ingress_video_options::EncodingOptions::Options)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(IngressVideoOptions {
                    name: name__.unwrap_or_default(),
                    source: source__.unwrap_or_default(),
                    encoding_options: encoding_options__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.IngressVideoOptions", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for InputAudioState {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.mime_type.is_empty() {
            len += 1;
        }
        if self.average_bitrate != 0 {
            len += 1;
        }
        if self.channels != 0 {
            len += 1;
        }
        if self.sample_rate != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.InputAudioState", len)?;
        if !self.mime_type.is_empty() {
            struct_ser.serialize_field("mimeType", &self.mime_type)?;
        }
        if self.average_bitrate != 0 {
            struct_ser.serialize_field("averageBitrate", &self.average_bitrate)?;
        }
        if self.channels != 0 {
            struct_ser.serialize_field("channels", &self.channels)?;
        }
        if self.sample_rate != 0 {
            struct_ser.serialize_field("sampleRate", &self.sample_rate)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for InputAudioState {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "mime_type",
            "mimeType",
            "average_bitrate",
            "averageBitrate",
            "channels",
            "sample_rate",
            "sampleRate",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            MimeType,
            AverageBitrate,
            Channels,
            SampleRate,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "mimeType" | "mime_type" => Ok(GeneratedField::MimeType),
                            "averageBitrate" | "average_bitrate" => Ok(GeneratedField::AverageBitrate),
                            "channels" => Ok(GeneratedField::Channels),
                            "sampleRate" | "sample_rate" => Ok(GeneratedField::SampleRate),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = InputAudioState;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.InputAudioState")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<InputAudioState, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut mime_type__ = None;
                let mut average_bitrate__ = None;
                let mut channels__ = None;
                let mut sample_rate__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::MimeType => {
                            if mime_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("mimeType"));
                            }
                            mime_type__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AverageBitrate => {
                            if average_bitrate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("averageBitrate"));
                            }
                            average_bitrate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Channels => {
                            if channels__.is_some() {
                                return Err(serde::de::Error::duplicate_field("channels"));
                            }
                            channels__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::SampleRate => {
                            if sample_rate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sampleRate"));
                            }
                            sample_rate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(InputAudioState {
                    mime_type: mime_type__.unwrap_or_default(),
                    average_bitrate: average_bitrate__.unwrap_or_default(),
                    channels: channels__.unwrap_or_default(),
                    sample_rate: sample_rate__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.InputAudioState", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for InputVideoState {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.mime_type.is_empty() {
            len += 1;
        }
        if self.average_bitrate != 0 {
            len += 1;
        }
        if self.width != 0 {
            len += 1;
        }
        if self.height != 0 {
            len += 1;
        }
        if self.framerate != 0. {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.InputVideoState", len)?;
        if !self.mime_type.is_empty() {
            struct_ser.serialize_field("mimeType", &self.mime_type)?;
        }
        if self.average_bitrate != 0 {
            struct_ser.serialize_field("averageBitrate", &self.average_bitrate)?;
        }
        if self.width != 0 {
            struct_ser.serialize_field("width", &self.width)?;
        }
        if self.height != 0 {
            struct_ser.serialize_field("height", &self.height)?;
        }
        if self.framerate != 0. {
            struct_ser.serialize_field("framerate", &self.framerate)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for InputVideoState {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "mime_type",
            "mimeType",
            "average_bitrate",
            "averageBitrate",
            "width",
            "height",
            "framerate",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            MimeType,
            AverageBitrate,
            Width,
            Height,
            Framerate,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "mimeType" | "mime_type" => Ok(GeneratedField::MimeType),
                            "averageBitrate" | "average_bitrate" => Ok(GeneratedField::AverageBitrate),
                            "width" => Ok(GeneratedField::Width),
                            "height" => Ok(GeneratedField::Height),
                            "framerate" => Ok(GeneratedField::Framerate),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = InputVideoState;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.InputVideoState")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<InputVideoState, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut mime_type__ = None;
                let mut average_bitrate__ = None;
                let mut width__ = None;
                let mut height__ = None;
                let mut framerate__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::MimeType => {
                            if mime_type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("mimeType"));
                            }
                            mime_type__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AverageBitrate => {
                            if average_bitrate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("averageBitrate"));
                            }
                            average_bitrate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Width => {
                            if width__.is_some() {
                                return Err(serde::de::Error::duplicate_field("width"));
                            }
                            width__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Height => {
                            if height__.is_some() {
                                return Err(serde::de::Error::duplicate_field("height"));
                            }
                            height__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Framerate => {
                            if framerate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("framerate"));
                            }
                            framerate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(InputVideoState {
                    mime_type: mime_type__.unwrap_or_default(),
                    average_bitrate: average_bitrate__.unwrap_or_default(),
                    width: width__.unwrap_or_default(),
                    height: height__.unwrap_or_default(),
                    framerate: framerate__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.InputVideoState", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for Job {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.id.is_empty() {
            len += 1;
        }
        if !self.dispatch_id.is_empty() {
            len += 1;
        }
        if self.r#type != 0 {
            len += 1;
        }
        if self.room.is_some() {
            len += 1;
        }
        if self.participant.is_some() {
            len += 1;
        }
        if !self.namespace.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        if !self.agent_name.is_empty() {
            len += 1;
        }
        if self.state.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.Job", len)?;
        if !self.id.is_empty() {
            struct_ser.serialize_field("id", &self.id)?;
        }
        if !self.dispatch_id.is_empty() {
            struct_ser.serialize_field("dispatchId", &self.dispatch_id)?;
        }
        if self.r#type != 0 {
            let v = JobType::try_from(self.r#type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.r#type)))?;
            struct_ser.serialize_field("type", &v)?;
        }
        if let Some(v) = self.room.as_ref() {
            struct_ser.serialize_field("room", v)?;
        }
        if let Some(v) = self.participant.as_ref() {
            struct_ser.serialize_field("participant", v)?;
        }
        if !self.namespace.is_empty() {
            struct_ser.serialize_field("namespace", &self.namespace)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        if !self.agent_name.is_empty() {
            struct_ser.serialize_field("agentName", &self.agent_name)?;
        }
        if let Some(v) = self.state.as_ref() {
            struct_ser.serialize_field("state", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for Job {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "id",
            "dispatch_id",
            "dispatchId",
            "type",
            "room",
            "participant",
            "namespace",
            "metadata",
            "agent_name",
            "agentName",
            "state",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Id,
            DispatchId,
            Type,
            Room,
            Participant,
            Namespace,
            Metadata,
            AgentName,
            State,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "id" => Ok(GeneratedField::Id),
                            "dispatchId" | "dispatch_id" => Ok(GeneratedField::DispatchId),
                            "type" => Ok(GeneratedField::Type),
                            "room" => Ok(GeneratedField::Room),
                            "participant" => Ok(GeneratedField::Participant),
                            "namespace" => Ok(GeneratedField::Namespace),
                            "metadata" => Ok(GeneratedField::Metadata),
                            "agentName" | "agent_name" => Ok(GeneratedField::AgentName),
                            "state" => Ok(GeneratedField::State),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = Job;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.Job")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<Job, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut id__ = None;
                let mut dispatch_id__ = None;
                let mut r#type__ = None;
                let mut room__ = None;
                let mut participant__ = None;
                let mut namespace__ = None;
                let mut metadata__ = None;
                let mut agent_name__ = None;
                let mut state__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Id => {
                            if id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("id"));
                            }
                            id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DispatchId => {
                            if dispatch_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("dispatchId"));
                            }
                            dispatch_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Type => {
                            if r#type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("type"));
                            }
                            r#type__ = Some(map_.next_value::<JobType>()? as i32);
                        }
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = map_.next_value()?;
                        }
                        GeneratedField::Participant => {
                            if participant__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participant"));
                            }
                            participant__ = map_.next_value()?;
                        }
                        GeneratedField::Namespace => {
                            if namespace__.is_some() {
                                return Err(serde::de::Error::duplicate_field("namespace"));
                            }
                            namespace__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AgentName => {
                            if agent_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agentName"));
                            }
                            agent_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::State => {
                            if state__.is_some() {
                                return Err(serde::de::Error::duplicate_field("state"));
                            }
                            state__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(Job {
                    id: id__.unwrap_or_default(),
                    dispatch_id: dispatch_id__.unwrap_or_default(),
                    r#type: r#type__.unwrap_or_default(),
                    room: room__,
                    participant: participant__,
                    namespace: namespace__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                    agent_name: agent_name__.unwrap_or_default(),
                    state: state__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.Job", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for JobAssignment {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.job.is_some() {
            len += 1;
        }
        if self.url.is_some() {
            len += 1;
        }
        if !self.token.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.JobAssignment", len)?;
        if let Some(v) = self.job.as_ref() {
            struct_ser.serialize_field("job", v)?;
        }
        if let Some(v) = self.url.as_ref() {
            struct_ser.serialize_field("url", v)?;
        }
        if !self.token.is_empty() {
            struct_ser.serialize_field("token", &self.token)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for JobAssignment {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "job",
            "url",
            "token",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Job,
            Url,
            Token,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "job" => Ok(GeneratedField::Job),
                            "url" => Ok(GeneratedField::Url),
                            "token" => Ok(GeneratedField::Token),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = JobAssignment;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.JobAssignment")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<JobAssignment, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut job__ = None;
                let mut url__ = None;
                let mut token__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Job => {
                            if job__.is_some() {
                                return Err(serde::de::Error::duplicate_field("job"));
                            }
                            job__ = map_.next_value()?;
                        }
                        GeneratedField::Url => {
                            if url__.is_some() {
                                return Err(serde::de::Error::duplicate_field("url"));
                            }
                            url__ = map_.next_value()?;
                        }
                        GeneratedField::Token => {
                            if token__.is_some() {
                                return Err(serde::de::Error::duplicate_field("token"));
                            }
                            token__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(JobAssignment {
                    job: job__,
                    url: url__,
                    token: token__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.JobAssignment", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for JobState {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.status != 0 {
            len += 1;
        }
        if !self.error.is_empty() {
            len += 1;
        }
        if self.started_at != 0 {
            len += 1;
        }
        if self.ended_at != 0 {
            len += 1;
        }
        if self.updated_at != 0 {
            len += 1;
        }
        if !self.participant_identity.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.JobState", len)?;
        if self.status != 0 {
            let v = JobStatus::try_from(self.status)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.status)))?;
            struct_ser.serialize_field("status", &v)?;
        }
        if !self.error.is_empty() {
            struct_ser.serialize_field("error", &self.error)?;
        }
        if self.started_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startedAt", ToString::to_string(&self.started_at).as_str())?;
        }
        if self.ended_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endedAt", ToString::to_string(&self.ended_at).as_str())?;
        }
        if self.updated_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("updatedAt", ToString::to_string(&self.updated_at).as_str())?;
        }
        if !self.participant_identity.is_empty() {
            struct_ser.serialize_field("participantIdentity", &self.participant_identity)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for JobState {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "status",
            "error",
            "started_at",
            "startedAt",
            "ended_at",
            "endedAt",
            "updated_at",
            "updatedAt",
            "participant_identity",
            "participantIdentity",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Status,
            Error,
            StartedAt,
            EndedAt,
            UpdatedAt,
            ParticipantIdentity,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "status" => Ok(GeneratedField::Status),
                            "error" => Ok(GeneratedField::Error),
                            "startedAt" | "started_at" => Ok(GeneratedField::StartedAt),
                            "endedAt" | "ended_at" => Ok(GeneratedField::EndedAt),
                            "updatedAt" | "updated_at" => Ok(GeneratedField::UpdatedAt),
                            "participantIdentity" | "participant_identity" => Ok(GeneratedField::ParticipantIdentity),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = JobState;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.JobState")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<JobState, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut status__ = None;
                let mut error__ = None;
                let mut started_at__ = None;
                let mut ended_at__ = None;
                let mut updated_at__ = None;
                let mut participant_identity__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Status => {
                            if status__.is_some() {
                                return Err(serde::de::Error::duplicate_field("status"));
                            }
                            status__ = Some(map_.next_value::<JobStatus>()? as i32);
                        }
                        GeneratedField::Error => {
                            if error__.is_some() {
                                return Err(serde::de::Error::duplicate_field("error"));
                            }
                            error__ = Some(map_.next_value()?);
                        }
                        GeneratedField::StartedAt => {
                            if started_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startedAt"));
                            }
                            started_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndedAt => {
                            if ended_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endedAt"));
                            }
                            ended_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::UpdatedAt => {
                            if updated_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("updatedAt"));
                            }
                            updated_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ParticipantIdentity => {
                            if participant_identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantIdentity"));
                            }
                            participant_identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(JobState {
                    status: status__.unwrap_or_default(),
                    error: error__.unwrap_or_default(),
                    started_at: started_at__.unwrap_or_default(),
                    ended_at: ended_at__.unwrap_or_default(),
                    updated_at: updated_at__.unwrap_or_default(),
                    participant_identity: participant_identity__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.JobState", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for JobStatus {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::JsPending => "JS_PENDING",
            Self::JsRunning => "JS_RUNNING",
            Self::JsSuccess => "JS_SUCCESS",
            Self::JsFailed => "JS_FAILED",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for JobStatus {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "JS_PENDING",
            "JS_RUNNING",
            "JS_SUCCESS",
            "JS_FAILED",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = JobStatus;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "JS_PENDING" => Ok(JobStatus::JsPending),
                    "JS_RUNNING" => Ok(JobStatus::JsRunning),
                    "JS_SUCCESS" => Ok(JobStatus::JsSuccess),
                    "JS_FAILED" => Ok(JobStatus::JsFailed),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for JobTermination {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.job_id.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.JobTermination", len)?;
        if !self.job_id.is_empty() {
            struct_ser.serialize_field("jobId", &self.job_id)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for JobTermination {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "job_id",
            "jobId",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            JobId,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "jobId" | "job_id" => Ok(GeneratedField::JobId),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = JobTermination;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.JobTermination")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<JobTermination, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut job_id__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::JobId => {
                            if job_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("jobId"));
                            }
                            job_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(JobTermination {
                    job_id: job_id__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.JobTermination", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for JobType {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::JtRoom => "JT_ROOM",
            Self::JtPublisher => "JT_PUBLISHER",
            Self::JtParticipant => "JT_PARTICIPANT",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for JobType {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "JT_ROOM",
            "JT_PUBLISHER",
            "JT_PARTICIPANT",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = JobType;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "JT_ROOM" => Ok(JobType::JtRoom),
                    "JT_PUBLISHER" => Ok(JobType::JtPublisher),
                    "JT_PARTICIPANT" => Ok(JobType::JtParticipant),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for JoinResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.room.is_some() {
            len += 1;
        }
        if self.participant.is_some() {
            len += 1;
        }
        if !self.other_participants.is_empty() {
            len += 1;
        }
        if !self.server_version.is_empty() {
            len += 1;
        }
        if !self.ice_servers.is_empty() {
            len += 1;
        }
        if self.subscriber_primary {
            len += 1;
        }
        if !self.alternative_url.is_empty() {
            len += 1;
        }
        if self.client_configuration.is_some() {
            len += 1;
        }
        if !self.server_region.is_empty() {
            len += 1;
        }
        if self.ping_timeout != 0 {
            len += 1;
        }
        if self.ping_interval != 0 {
            len += 1;
        }
        if self.server_info.is_some() {
            len += 1;
        }
        if !self.sif_trailer.is_empty() {
            len += 1;
        }
        if !self.enabled_publish_codecs.is_empty() {
            len += 1;
        }
        if self.fast_publish {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.JoinResponse", len)?;
        if let Some(v) = self.room.as_ref() {
            struct_ser.serialize_field("room", v)?;
        }
        if let Some(v) = self.participant.as_ref() {
            struct_ser.serialize_field("participant", v)?;
        }
        if !self.other_participants.is_empty() {
            struct_ser.serialize_field("otherParticipants", &self.other_participants)?;
        }
        if !self.server_version.is_empty() {
            struct_ser.serialize_field("serverVersion", &self.server_version)?;
        }
        if !self.ice_servers.is_empty() {
            struct_ser.serialize_field("iceServers", &self.ice_servers)?;
        }
        if self.subscriber_primary {
            struct_ser.serialize_field("subscriberPrimary", &self.subscriber_primary)?;
        }
        if !self.alternative_url.is_empty() {
            struct_ser.serialize_field("alternativeUrl", &self.alternative_url)?;
        }
        if let Some(v) = self.client_configuration.as_ref() {
            struct_ser.serialize_field("clientConfiguration", v)?;
        }
        if !self.server_region.is_empty() {
            struct_ser.serialize_field("serverRegion", &self.server_region)?;
        }
        if self.ping_timeout != 0 {
            struct_ser.serialize_field("pingTimeout", &self.ping_timeout)?;
        }
        if self.ping_interval != 0 {
            struct_ser.serialize_field("pingInterval", &self.ping_interval)?;
        }
        if let Some(v) = self.server_info.as_ref() {
            struct_ser.serialize_field("serverInfo", v)?;
        }
        if !self.sif_trailer.is_empty() {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("sifTrailer", pbjson::private::base64::encode(&self.sif_trailer).as_str())?;
        }
        if !self.enabled_publish_codecs.is_empty() {
            struct_ser.serialize_field("enabledPublishCodecs", &self.enabled_publish_codecs)?;
        }
        if self.fast_publish {
            struct_ser.serialize_field("fastPublish", &self.fast_publish)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for JoinResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room",
            "participant",
            "other_participants",
            "otherParticipants",
            "server_version",
            "serverVersion",
            "ice_servers",
            "iceServers",
            "subscriber_primary",
            "subscriberPrimary",
            "alternative_url",
            "alternativeUrl",
            "client_configuration",
            "clientConfiguration",
            "server_region",
            "serverRegion",
            "ping_timeout",
            "pingTimeout",
            "ping_interval",
            "pingInterval",
            "server_info",
            "serverInfo",
            "sif_trailer",
            "sifTrailer",
            "enabled_publish_codecs",
            "enabledPublishCodecs",
            "fast_publish",
            "fastPublish",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Room,
            Participant,
            OtherParticipants,
            ServerVersion,
            IceServers,
            SubscriberPrimary,
            AlternativeUrl,
            ClientConfiguration,
            ServerRegion,
            PingTimeout,
            PingInterval,
            ServerInfo,
            SifTrailer,
            EnabledPublishCodecs,
            FastPublish,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "room" => Ok(GeneratedField::Room),
                            "participant" => Ok(GeneratedField::Participant),
                            "otherParticipants" | "other_participants" => Ok(GeneratedField::OtherParticipants),
                            "serverVersion" | "server_version" => Ok(GeneratedField::ServerVersion),
                            "iceServers" | "ice_servers" => Ok(GeneratedField::IceServers),
                            "subscriberPrimary" | "subscriber_primary" => Ok(GeneratedField::SubscriberPrimary),
                            "alternativeUrl" | "alternative_url" => Ok(GeneratedField::AlternativeUrl),
                            "clientConfiguration" | "client_configuration" => Ok(GeneratedField::ClientConfiguration),
                            "serverRegion" | "server_region" => Ok(GeneratedField::ServerRegion),
                            "pingTimeout" | "ping_timeout" => Ok(GeneratedField::PingTimeout),
                            "pingInterval" | "ping_interval" => Ok(GeneratedField::PingInterval),
                            "serverInfo" | "server_info" => Ok(GeneratedField::ServerInfo),
                            "sifTrailer" | "sif_trailer" => Ok(GeneratedField::SifTrailer),
                            "enabledPublishCodecs" | "enabled_publish_codecs" => Ok(GeneratedField::EnabledPublishCodecs),
                            "fastPublish" | "fast_publish" => Ok(GeneratedField::FastPublish),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = JoinResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.JoinResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<JoinResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room__ = None;
                let mut participant__ = None;
                let mut other_participants__ = None;
                let mut server_version__ = None;
                let mut ice_servers__ = None;
                let mut subscriber_primary__ = None;
                let mut alternative_url__ = None;
                let mut client_configuration__ = None;
                let mut server_region__ = None;
                let mut ping_timeout__ = None;
                let mut ping_interval__ = None;
                let mut server_info__ = None;
                let mut sif_trailer__ = None;
                let mut enabled_publish_codecs__ = None;
                let mut fast_publish__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = map_.next_value()?;
                        }
                        GeneratedField::Participant => {
                            if participant__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participant"));
                            }
                            participant__ = map_.next_value()?;
                        }
                        GeneratedField::OtherParticipants => {
                            if other_participants__.is_some() {
                                return Err(serde::de::Error::duplicate_field("otherParticipants"));
                            }
                            other_participants__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ServerVersion => {
                            if server_version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("serverVersion"));
                            }
                            server_version__ = Some(map_.next_value()?);
                        }
                        GeneratedField::IceServers => {
                            if ice_servers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("iceServers"));
                            }
                            ice_servers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SubscriberPrimary => {
                            if subscriber_primary__.is_some() {
                                return Err(serde::de::Error::duplicate_field("subscriberPrimary"));
                            }
                            subscriber_primary__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AlternativeUrl => {
                            if alternative_url__.is_some() {
                                return Err(serde::de::Error::duplicate_field("alternativeUrl"));
                            }
                            alternative_url__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ClientConfiguration => {
                            if client_configuration__.is_some() {
                                return Err(serde::de::Error::duplicate_field("clientConfiguration"));
                            }
                            client_configuration__ = map_.next_value()?;
                        }
                        GeneratedField::ServerRegion => {
                            if server_region__.is_some() {
                                return Err(serde::de::Error::duplicate_field("serverRegion"));
                            }
                            server_region__ = Some(map_.next_value()?);
                        }
                        GeneratedField::PingTimeout => {
                            if ping_timeout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("pingTimeout"));
                            }
                            ping_timeout__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PingInterval => {
                            if ping_interval__.is_some() {
                                return Err(serde::de::Error::duplicate_field("pingInterval"));
                            }
                            ping_interval__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ServerInfo => {
                            if server_info__.is_some() {
                                return Err(serde::de::Error::duplicate_field("serverInfo"));
                            }
                            server_info__ = map_.next_value()?;
                        }
                        GeneratedField::SifTrailer => {
                            if sif_trailer__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sifTrailer"));
                            }
                            sif_trailer__ = 
                                Some(map_.next_value::<::pbjson::private::BytesDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EnabledPublishCodecs => {
                            if enabled_publish_codecs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("enabledPublishCodecs"));
                            }
                            enabled_publish_codecs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::FastPublish => {
                            if fast_publish__.is_some() {
                                return Err(serde::de::Error::duplicate_field("fastPublish"));
                            }
                            fast_publish__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(JoinResponse {
                    room: room__,
                    participant: participant__,
                    other_participants: other_participants__.unwrap_or_default(),
                    server_version: server_version__.unwrap_or_default(),
                    ice_servers: ice_servers__.unwrap_or_default(),
                    subscriber_primary: subscriber_primary__.unwrap_or_default(),
                    alternative_url: alternative_url__.unwrap_or_default(),
                    client_configuration: client_configuration__,
                    server_region: server_region__.unwrap_or_default(),
                    ping_timeout: ping_timeout__.unwrap_or_default(),
                    ping_interval: ping_interval__.unwrap_or_default(),
                    server_info: server_info__,
                    sif_trailer: sif_trailer__.unwrap_or_default(),
                    enabled_publish_codecs: enabled_publish_codecs__.unwrap_or_default(),
                    fast_publish: fast_publish__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.JoinResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for LeaveRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.can_reconnect {
            len += 1;
        }
        if self.reason != 0 {
            len += 1;
        }
        if self.action != 0 {
            len += 1;
        }
        if self.regions.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.LeaveRequest", len)?;
        if self.can_reconnect {
            struct_ser.serialize_field("canReconnect", &self.can_reconnect)?;
        }
        if self.reason != 0 {
            let v = DisconnectReason::try_from(self.reason)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.reason)))?;
            struct_ser.serialize_field("reason", &v)?;
        }
        if self.action != 0 {
            let v = leave_request::Action::try_from(self.action)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.action)))?;
            struct_ser.serialize_field("action", &v)?;
        }
        if let Some(v) = self.regions.as_ref() {
            struct_ser.serialize_field("regions", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for LeaveRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "can_reconnect",
            "canReconnect",
            "reason",
            "action",
            "regions",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            CanReconnect,
            Reason,
            Action,
            Regions,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "canReconnect" | "can_reconnect" => Ok(GeneratedField::CanReconnect),
                            "reason" => Ok(GeneratedField::Reason),
                            "action" => Ok(GeneratedField::Action),
                            "regions" => Ok(GeneratedField::Regions),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = LeaveRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.LeaveRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<LeaveRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut can_reconnect__ = None;
                let mut reason__ = None;
                let mut action__ = None;
                let mut regions__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::CanReconnect => {
                            if can_reconnect__.is_some() {
                                return Err(serde::de::Error::duplicate_field("canReconnect"));
                            }
                            can_reconnect__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Reason => {
                            if reason__.is_some() {
                                return Err(serde::de::Error::duplicate_field("reason"));
                            }
                            reason__ = Some(map_.next_value::<DisconnectReason>()? as i32);
                        }
                        GeneratedField::Action => {
                            if action__.is_some() {
                                return Err(serde::de::Error::duplicate_field("action"));
                            }
                            action__ = Some(map_.next_value::<leave_request::Action>()? as i32);
                        }
                        GeneratedField::Regions => {
                            if regions__.is_some() {
                                return Err(serde::de::Error::duplicate_field("regions"));
                            }
                            regions__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(LeaveRequest {
                    can_reconnect: can_reconnect__.unwrap_or_default(),
                    reason: reason__.unwrap_or_default(),
                    action: action__.unwrap_or_default(),
                    regions: regions__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.LeaveRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for leave_request::Action {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Disconnect => "DISCONNECT",
            Self::Resume => "RESUME",
            Self::Reconnect => "RECONNECT",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for leave_request::Action {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "DISCONNECT",
            "RESUME",
            "RECONNECT",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = leave_request::Action;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "DISCONNECT" => Ok(leave_request::Action::Disconnect),
                    "RESUME" => Ok(leave_request::Action::Resume),
                    "RECONNECT" => Ok(leave_request::Action::Reconnect),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for ListAgentDispatchRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.dispatch_id.is_empty() {
            len += 1;
        }
        if !self.room.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListAgentDispatchRequest", len)?;
        if !self.dispatch_id.is_empty() {
            struct_ser.serialize_field("dispatchId", &self.dispatch_id)?;
        }
        if !self.room.is_empty() {
            struct_ser.serialize_field("room", &self.room)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListAgentDispatchRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "dispatch_id",
            "dispatchId",
            "room",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            DispatchId,
            Room,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "dispatchId" | "dispatch_id" => Ok(GeneratedField::DispatchId),
                            "room" => Ok(GeneratedField::Room),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListAgentDispatchRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListAgentDispatchRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListAgentDispatchRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut dispatch_id__ = None;
                let mut room__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::DispatchId => {
                            if dispatch_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("dispatchId"));
                            }
                            dispatch_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListAgentDispatchRequest {
                    dispatch_id: dispatch_id__.unwrap_or_default(),
                    room: room__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListAgentDispatchRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListAgentDispatchResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.agent_dispatches.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListAgentDispatchResponse", len)?;
        if !self.agent_dispatches.is_empty() {
            struct_ser.serialize_field("agentDispatches", &self.agent_dispatches)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListAgentDispatchResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "agent_dispatches",
            "agentDispatches",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            AgentDispatches,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "agentDispatches" | "agent_dispatches" => Ok(GeneratedField::AgentDispatches),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListAgentDispatchResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListAgentDispatchResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListAgentDispatchResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut agent_dispatches__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::AgentDispatches => {
                            if agent_dispatches__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agentDispatches"));
                            }
                            agent_dispatches__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListAgentDispatchResponse {
                    agent_dispatches: agent_dispatches__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListAgentDispatchResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListEgressRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.room_name.is_empty() {
            len += 1;
        }
        if !self.egress_id.is_empty() {
            len += 1;
        }
        if self.active {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListEgressRequest", len)?;
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if !self.egress_id.is_empty() {
            struct_ser.serialize_field("egressId", &self.egress_id)?;
        }
        if self.active {
            struct_ser.serialize_field("active", &self.active)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListEgressRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room_name",
            "roomName",
            "egress_id",
            "egressId",
            "active",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            RoomName,
            EgressId,
            Active,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "egressId" | "egress_id" => Ok(GeneratedField::EgressId),
                            "active" => Ok(GeneratedField::Active),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListEgressRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListEgressRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListEgressRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room_name__ = None;
                let mut egress_id__ = None;
                let mut active__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::EgressId => {
                            if egress_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("egressId"));
                            }
                            egress_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Active => {
                            if active__.is_some() {
                                return Err(serde::de::Error::duplicate_field("active"));
                            }
                            active__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListEgressRequest {
                    room_name: room_name__.unwrap_or_default(),
                    egress_id: egress_id__.unwrap_or_default(),
                    active: active__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListEgressRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListEgressResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.items.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListEgressResponse", len)?;
        if !self.items.is_empty() {
            struct_ser.serialize_field("items", &self.items)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListEgressResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "items",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Items,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "items" => Ok(GeneratedField::Items),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListEgressResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListEgressResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListEgressResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut items__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Items => {
                            if items__.is_some() {
                                return Err(serde::de::Error::duplicate_field("items"));
                            }
                            items__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListEgressResponse {
                    items: items__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListEgressResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListIngressRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.room_name.is_empty() {
            len += 1;
        }
        if !self.ingress_id.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListIngressRequest", len)?;
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if !self.ingress_id.is_empty() {
            struct_ser.serialize_field("ingressId", &self.ingress_id)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListIngressRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room_name",
            "roomName",
            "ingress_id",
            "ingressId",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            RoomName,
            IngressId,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "ingressId" | "ingress_id" => Ok(GeneratedField::IngressId),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListIngressRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListIngressRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListIngressRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room_name__ = None;
                let mut ingress_id__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::IngressId => {
                            if ingress_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("ingressId"));
                            }
                            ingress_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListIngressRequest {
                    room_name: room_name__.unwrap_or_default(),
                    ingress_id: ingress_id__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListIngressRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListIngressResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.items.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListIngressResponse", len)?;
        if !self.items.is_empty() {
            struct_ser.serialize_field("items", &self.items)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListIngressResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "items",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Items,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "items" => Ok(GeneratedField::Items),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListIngressResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListIngressResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListIngressResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut items__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Items => {
                            if items__.is_some() {
                                return Err(serde::de::Error::duplicate_field("items"));
                            }
                            items__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListIngressResponse {
                    items: items__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListIngressResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListParticipantsRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.room.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListParticipantsRequest", len)?;
        if !self.room.is_empty() {
            struct_ser.serialize_field("room", &self.room)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListParticipantsRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Room,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "room" => Ok(GeneratedField::Room),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListParticipantsRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListParticipantsRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListParticipantsRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListParticipantsRequest {
                    room: room__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListParticipantsRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListParticipantsResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.participants.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListParticipantsResponse", len)?;
        if !self.participants.is_empty() {
            struct_ser.serialize_field("participants", &self.participants)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListParticipantsResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "participants",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Participants,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "participants" => Ok(GeneratedField::Participants),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListParticipantsResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListParticipantsResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListParticipantsResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut participants__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Participants => {
                            if participants__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participants"));
                            }
                            participants__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListParticipantsResponse {
                    participants: participants__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListParticipantsResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListRoomsRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.names.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListRoomsRequest", len)?;
        if !self.names.is_empty() {
            struct_ser.serialize_field("names", &self.names)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListRoomsRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "names",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Names,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "names" => Ok(GeneratedField::Names),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListRoomsRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListRoomsRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListRoomsRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut names__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Names => {
                            if names__.is_some() {
                                return Err(serde::de::Error::duplicate_field("names"));
                            }
                            names__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListRoomsRequest {
                    names: names__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListRoomsRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListRoomsResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.rooms.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListRoomsResponse", len)?;
        if !self.rooms.is_empty() {
            struct_ser.serialize_field("rooms", &self.rooms)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListRoomsResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "rooms",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Rooms,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "rooms" => Ok(GeneratedField::Rooms),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListRoomsResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListRoomsResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListRoomsResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut rooms__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Rooms => {
                            if rooms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rooms"));
                            }
                            rooms__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListRoomsResponse {
                    rooms: rooms__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListRoomsResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListSipDispatchRuleRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.page.is_some() {
            len += 1;
        }
        if !self.dispatch_rule_ids.is_empty() {
            len += 1;
        }
        if !self.trunk_ids.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListSIPDispatchRuleRequest", len)?;
        if let Some(v) = self.page.as_ref() {
            struct_ser.serialize_field("page", v)?;
        }
        if !self.dispatch_rule_ids.is_empty() {
            struct_ser.serialize_field("dispatchRuleIds", &self.dispatch_rule_ids)?;
        }
        if !self.trunk_ids.is_empty() {
            struct_ser.serialize_field("trunkIds", &self.trunk_ids)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListSipDispatchRuleRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "page",
            "dispatch_rule_ids",
            "dispatchRuleIds",
            "trunk_ids",
            "trunkIds",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Page,
            DispatchRuleIds,
            TrunkIds,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "page" => Ok(GeneratedField::Page),
                            "dispatchRuleIds" | "dispatch_rule_ids" => Ok(GeneratedField::DispatchRuleIds),
                            "trunkIds" | "trunk_ids" => Ok(GeneratedField::TrunkIds),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListSipDispatchRuleRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListSIPDispatchRuleRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListSipDispatchRuleRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut page__ = None;
                let mut dispatch_rule_ids__ = None;
                let mut trunk_ids__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Page => {
                            if page__.is_some() {
                                return Err(serde::de::Error::duplicate_field("page"));
                            }
                            page__ = map_.next_value()?;
                        }
                        GeneratedField::DispatchRuleIds => {
                            if dispatch_rule_ids__.is_some() {
                                return Err(serde::de::Error::duplicate_field("dispatchRuleIds"));
                            }
                            dispatch_rule_ids__ = Some(map_.next_value()?);
                        }
                        GeneratedField::TrunkIds => {
                            if trunk_ids__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunkIds"));
                            }
                            trunk_ids__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListSipDispatchRuleRequest {
                    page: page__,
                    dispatch_rule_ids: dispatch_rule_ids__.unwrap_or_default(),
                    trunk_ids: trunk_ids__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListSIPDispatchRuleRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListSipDispatchRuleResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.items.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListSIPDispatchRuleResponse", len)?;
        if !self.items.is_empty() {
            struct_ser.serialize_field("items", &self.items)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListSipDispatchRuleResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "items",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Items,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "items" => Ok(GeneratedField::Items),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListSipDispatchRuleResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListSIPDispatchRuleResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListSipDispatchRuleResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut items__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Items => {
                            if items__.is_some() {
                                return Err(serde::de::Error::duplicate_field("items"));
                            }
                            items__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListSipDispatchRuleResponse {
                    items: items__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListSIPDispatchRuleResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListSipInboundTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.page.is_some() {
            len += 1;
        }
        if !self.trunk_ids.is_empty() {
            len += 1;
        }
        if !self.numbers.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListSIPInboundTrunkRequest", len)?;
        if let Some(v) = self.page.as_ref() {
            struct_ser.serialize_field("page", v)?;
        }
        if !self.trunk_ids.is_empty() {
            struct_ser.serialize_field("trunkIds", &self.trunk_ids)?;
        }
        if !self.numbers.is_empty() {
            struct_ser.serialize_field("numbers", &self.numbers)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListSipInboundTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "page",
            "trunk_ids",
            "trunkIds",
            "numbers",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Page,
            TrunkIds,
            Numbers,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "page" => Ok(GeneratedField::Page),
                            "trunkIds" | "trunk_ids" => Ok(GeneratedField::TrunkIds),
                            "numbers" => Ok(GeneratedField::Numbers),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListSipInboundTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListSIPInboundTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListSipInboundTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut page__ = None;
                let mut trunk_ids__ = None;
                let mut numbers__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Page => {
                            if page__.is_some() {
                                return Err(serde::de::Error::duplicate_field("page"));
                            }
                            page__ = map_.next_value()?;
                        }
                        GeneratedField::TrunkIds => {
                            if trunk_ids__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunkIds"));
                            }
                            trunk_ids__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Numbers => {
                            if numbers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("numbers"));
                            }
                            numbers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListSipInboundTrunkRequest {
                    page: page__,
                    trunk_ids: trunk_ids__.unwrap_or_default(),
                    numbers: numbers__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListSIPInboundTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListSipInboundTrunkResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.items.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListSIPInboundTrunkResponse", len)?;
        if !self.items.is_empty() {
            struct_ser.serialize_field("items", &self.items)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListSipInboundTrunkResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "items",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Items,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "items" => Ok(GeneratedField::Items),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListSipInboundTrunkResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListSIPInboundTrunkResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListSipInboundTrunkResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut items__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Items => {
                            if items__.is_some() {
                                return Err(serde::de::Error::duplicate_field("items"));
                            }
                            items__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListSipInboundTrunkResponse {
                    items: items__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListSIPInboundTrunkResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListSipOutboundTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.page.is_some() {
            len += 1;
        }
        if !self.trunk_ids.is_empty() {
            len += 1;
        }
        if !self.numbers.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListSIPOutboundTrunkRequest", len)?;
        if let Some(v) = self.page.as_ref() {
            struct_ser.serialize_field("page", v)?;
        }
        if !self.trunk_ids.is_empty() {
            struct_ser.serialize_field("trunkIds", &self.trunk_ids)?;
        }
        if !self.numbers.is_empty() {
            struct_ser.serialize_field("numbers", &self.numbers)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListSipOutboundTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "page",
            "trunk_ids",
            "trunkIds",
            "numbers",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Page,
            TrunkIds,
            Numbers,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "page" => Ok(GeneratedField::Page),
                            "trunkIds" | "trunk_ids" => Ok(GeneratedField::TrunkIds),
                            "numbers" => Ok(GeneratedField::Numbers),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListSipOutboundTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListSIPOutboundTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListSipOutboundTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut page__ = None;
                let mut trunk_ids__ = None;
                let mut numbers__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Page => {
                            if page__.is_some() {
                                return Err(serde::de::Error::duplicate_field("page"));
                            }
                            page__ = map_.next_value()?;
                        }
                        GeneratedField::TrunkIds => {
                            if trunk_ids__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunkIds"));
                            }
                            trunk_ids__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Numbers => {
                            if numbers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("numbers"));
                            }
                            numbers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListSipOutboundTrunkRequest {
                    page: page__,
                    trunk_ids: trunk_ids__.unwrap_or_default(),
                    numbers: numbers__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListSIPOutboundTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListSipOutboundTrunkResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.items.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListSIPOutboundTrunkResponse", len)?;
        if !self.items.is_empty() {
            struct_ser.serialize_field("items", &self.items)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListSipOutboundTrunkResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "items",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Items,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "items" => Ok(GeneratedField::Items),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListSipOutboundTrunkResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListSIPOutboundTrunkResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListSipOutboundTrunkResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut items__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Items => {
                            if items__.is_some() {
                                return Err(serde::de::Error::duplicate_field("items"));
                            }
                            items__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListSipOutboundTrunkResponse {
                    items: items__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListSIPOutboundTrunkResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListSipTrunkRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.page.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListSIPTrunkRequest", len)?;
        if let Some(v) = self.page.as_ref() {
            struct_ser.serialize_field("page", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListSipTrunkRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "page",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Page,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "page" => Ok(GeneratedField::Page),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListSipTrunkRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListSIPTrunkRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListSipTrunkRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut page__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Page => {
                            if page__.is_some() {
                                return Err(serde::de::Error::duplicate_field("page"));
                            }
                            page__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListSipTrunkRequest {
                    page: page__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListSIPTrunkRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ListSipTrunkResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.items.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ListSIPTrunkResponse", len)?;
        if !self.items.is_empty() {
            struct_ser.serialize_field("items", &self.items)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ListSipTrunkResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "items",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Items,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "items" => Ok(GeneratedField::Items),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ListSipTrunkResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ListSIPTrunkResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ListSipTrunkResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut items__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Items => {
                            if items__.is_some() {
                                return Err(serde::de::Error::duplicate_field("items"));
                            }
                            items__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ListSipTrunkResponse {
                    items: items__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ListSIPTrunkResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for MetricLabel {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::AgentsLlmTtft => "AGENTS_LLM_TTFT",
            Self::AgentsSttTtft => "AGENTS_STT_TTFT",
            Self::AgentsTtsTtfb => "AGENTS_TTS_TTFB",
            Self::ClientVideoSubscriberFreezeCount => "CLIENT_VIDEO_SUBSCRIBER_FREEZE_COUNT",
            Self::ClientVideoSubscriberTotalFreezeDuration => "CLIENT_VIDEO_SUBSCRIBER_TOTAL_FREEZE_DURATION",
            Self::ClientVideoSubscriberPauseCount => "CLIENT_VIDEO_SUBSCRIBER_PAUSE_COUNT",
            Self::ClientVideoSubscriberTotalPausesDuration => "CLIENT_VIDEO_SUBSCRIBER_TOTAL_PAUSES_DURATION",
            Self::ClientAudioSubscriberConcealedSamples => "CLIENT_AUDIO_SUBSCRIBER_CONCEALED_SAMPLES",
            Self::ClientAudioSubscriberSilentConcealedSamples => "CLIENT_AUDIO_SUBSCRIBER_SILENT_CONCEALED_SAMPLES",
            Self::ClientAudioSubscriberConcealmentEvents => "CLIENT_AUDIO_SUBSCRIBER_CONCEALMENT_EVENTS",
            Self::ClientAudioSubscriberInterruptionCount => "CLIENT_AUDIO_SUBSCRIBER_INTERRUPTION_COUNT",
            Self::ClientAudioSubscriberTotalInterruptionDuration => "CLIENT_AUDIO_SUBSCRIBER_TOTAL_INTERRUPTION_DURATION",
            Self::ClientSubscriberJitterBufferDelay => "CLIENT_SUBSCRIBER_JITTER_BUFFER_DELAY",
            Self::ClientSubscriberJitterBufferEmittedCount => "CLIENT_SUBSCRIBER_JITTER_BUFFER_EMITTED_COUNT",
            Self::ClientVideoPublisherQualityLimitationDurationBandwidth => "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_BANDWIDTH",
            Self::ClientVideoPublisherQualityLimitationDurationCpu => "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_CPU",
            Self::ClientVideoPublisherQualityLimitationDurationOther => "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_OTHER",
            Self::PublisherRtt => "PUBLISHER_RTT",
            Self::ServerMeshRtt => "SERVER_MESH_RTT",
            Self::SubscriberRtt => "SUBSCRIBER_RTT",
            Self::PredefinedMaxValue => "METRIC_LABEL_PREDEFINED_MAX_VALUE",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for MetricLabel {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "AGENTS_LLM_TTFT",
            "AGENTS_STT_TTFT",
            "AGENTS_TTS_TTFB",
            "CLIENT_VIDEO_SUBSCRIBER_FREEZE_COUNT",
            "CLIENT_VIDEO_SUBSCRIBER_TOTAL_FREEZE_DURATION",
            "CLIENT_VIDEO_SUBSCRIBER_PAUSE_COUNT",
            "CLIENT_VIDEO_SUBSCRIBER_TOTAL_PAUSES_DURATION",
            "CLIENT_AUDIO_SUBSCRIBER_CONCEALED_SAMPLES",
            "CLIENT_AUDIO_SUBSCRIBER_SILENT_CONCEALED_SAMPLES",
            "CLIENT_AUDIO_SUBSCRIBER_CONCEALMENT_EVENTS",
            "CLIENT_AUDIO_SUBSCRIBER_INTERRUPTION_COUNT",
            "CLIENT_AUDIO_SUBSCRIBER_TOTAL_INTERRUPTION_DURATION",
            "CLIENT_SUBSCRIBER_JITTER_BUFFER_DELAY",
            "CLIENT_SUBSCRIBER_JITTER_BUFFER_EMITTED_COUNT",
            "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_BANDWIDTH",
            "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_CPU",
            "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_OTHER",
            "PUBLISHER_RTT",
            "SERVER_MESH_RTT",
            "SUBSCRIBER_RTT",
            "METRIC_LABEL_PREDEFINED_MAX_VALUE",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = MetricLabel;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "AGENTS_LLM_TTFT" => Ok(MetricLabel::AgentsLlmTtft),
                    "AGENTS_STT_TTFT" => Ok(MetricLabel::AgentsSttTtft),
                    "AGENTS_TTS_TTFB" => Ok(MetricLabel::AgentsTtsTtfb),
                    "CLIENT_VIDEO_SUBSCRIBER_FREEZE_COUNT" => Ok(MetricLabel::ClientVideoSubscriberFreezeCount),
                    "CLIENT_VIDEO_SUBSCRIBER_TOTAL_FREEZE_DURATION" => Ok(MetricLabel::ClientVideoSubscriberTotalFreezeDuration),
                    "CLIENT_VIDEO_SUBSCRIBER_PAUSE_COUNT" => Ok(MetricLabel::ClientVideoSubscriberPauseCount),
                    "CLIENT_VIDEO_SUBSCRIBER_TOTAL_PAUSES_DURATION" => Ok(MetricLabel::ClientVideoSubscriberTotalPausesDuration),
                    "CLIENT_AUDIO_SUBSCRIBER_CONCEALED_SAMPLES" => Ok(MetricLabel::ClientAudioSubscriberConcealedSamples),
                    "CLIENT_AUDIO_SUBSCRIBER_SILENT_CONCEALED_SAMPLES" => Ok(MetricLabel::ClientAudioSubscriberSilentConcealedSamples),
                    "CLIENT_AUDIO_SUBSCRIBER_CONCEALMENT_EVENTS" => Ok(MetricLabel::ClientAudioSubscriberConcealmentEvents),
                    "CLIENT_AUDIO_SUBSCRIBER_INTERRUPTION_COUNT" => Ok(MetricLabel::ClientAudioSubscriberInterruptionCount),
                    "CLIENT_AUDIO_SUBSCRIBER_TOTAL_INTERRUPTION_DURATION" => Ok(MetricLabel::ClientAudioSubscriberTotalInterruptionDuration),
                    "CLIENT_SUBSCRIBER_JITTER_BUFFER_DELAY" => Ok(MetricLabel::ClientSubscriberJitterBufferDelay),
                    "CLIENT_SUBSCRIBER_JITTER_BUFFER_EMITTED_COUNT" => Ok(MetricLabel::ClientSubscriberJitterBufferEmittedCount),
                    "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_BANDWIDTH" => Ok(MetricLabel::ClientVideoPublisherQualityLimitationDurationBandwidth),
                    "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_CPU" => Ok(MetricLabel::ClientVideoPublisherQualityLimitationDurationCpu),
                    "CLIENT_VIDEO_PUBLISHER_QUALITY_LIMITATION_DURATION_OTHER" => Ok(MetricLabel::ClientVideoPublisherQualityLimitationDurationOther),
                    "PUBLISHER_RTT" => Ok(MetricLabel::PublisherRtt),
                    "SERVER_MESH_RTT" => Ok(MetricLabel::ServerMeshRtt),
                    "SUBSCRIBER_RTT" => Ok(MetricLabel::SubscriberRtt),
                    "METRIC_LABEL_PREDEFINED_MAX_VALUE" => Ok(MetricLabel::PredefinedMaxValue),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for MetricSample {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.timestamp_ms != 0 {
            len += 1;
        }
        if self.normalized_timestamp.is_some() {
            len += 1;
        }
        if self.value != 0. {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.MetricSample", len)?;
        if self.timestamp_ms != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("timestampMs", ToString::to_string(&self.timestamp_ms).as_str())?;
        }
        if let Some(v) = self.normalized_timestamp.as_ref() {
            struct_ser.serialize_field("normalizedTimestamp", v)?;
        }
        if self.value != 0. {
            struct_ser.serialize_field("value", &self.value)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for MetricSample {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "timestamp_ms",
            "timestampMs",
            "normalized_timestamp",
            "normalizedTimestamp",
            "value",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            TimestampMs,
            NormalizedTimestamp,
            Value,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "timestampMs" | "timestamp_ms" => Ok(GeneratedField::TimestampMs),
                            "normalizedTimestamp" | "normalized_timestamp" => Ok(GeneratedField::NormalizedTimestamp),
                            "value" => Ok(GeneratedField::Value),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = MetricSample;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.MetricSample")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<MetricSample, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut timestamp_ms__ = None;
                let mut normalized_timestamp__ = None;
                let mut value__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::TimestampMs => {
                            if timestamp_ms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("timestampMs"));
                            }
                            timestamp_ms__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::NormalizedTimestamp => {
                            if normalized_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("normalizedTimestamp"));
                            }
                            normalized_timestamp__ = map_.next_value()?;
                        }
                        GeneratedField::Value => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("value"));
                            }
                            value__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(MetricSample {
                    timestamp_ms: timestamp_ms__.unwrap_or_default(),
                    normalized_timestamp: normalized_timestamp__,
                    value: value__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.MetricSample", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for MetricsBatch {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.timestamp_ms != 0 {
            len += 1;
        }
        if self.normalized_timestamp.is_some() {
            len += 1;
        }
        if !self.str_data.is_empty() {
            len += 1;
        }
        if !self.time_series.is_empty() {
            len += 1;
        }
        if !self.events.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.MetricsBatch", len)?;
        if self.timestamp_ms != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("timestampMs", ToString::to_string(&self.timestamp_ms).as_str())?;
        }
        if let Some(v) = self.normalized_timestamp.as_ref() {
            struct_ser.serialize_field("normalizedTimestamp", v)?;
        }
        if !self.str_data.is_empty() {
            struct_ser.serialize_field("strData", &self.str_data)?;
        }
        if !self.time_series.is_empty() {
            struct_ser.serialize_field("timeSeries", &self.time_series)?;
        }
        if !self.events.is_empty() {
            struct_ser.serialize_field("events", &self.events)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for MetricsBatch {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "timestamp_ms",
            "timestampMs",
            "normalized_timestamp",
            "normalizedTimestamp",
            "str_data",
            "strData",
            "time_series",
            "timeSeries",
            "events",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            TimestampMs,
            NormalizedTimestamp,
            StrData,
            TimeSeries,
            Events,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "timestampMs" | "timestamp_ms" => Ok(GeneratedField::TimestampMs),
                            "normalizedTimestamp" | "normalized_timestamp" => Ok(GeneratedField::NormalizedTimestamp),
                            "strData" | "str_data" => Ok(GeneratedField::StrData),
                            "timeSeries" | "time_series" => Ok(GeneratedField::TimeSeries),
                            "events" => Ok(GeneratedField::Events),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = MetricsBatch;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.MetricsBatch")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<MetricsBatch, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut timestamp_ms__ = None;
                let mut normalized_timestamp__ = None;
                let mut str_data__ = None;
                let mut time_series__ = None;
                let mut events__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::TimestampMs => {
                            if timestamp_ms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("timestampMs"));
                            }
                            timestamp_ms__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::NormalizedTimestamp => {
                            if normalized_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("normalizedTimestamp"));
                            }
                            normalized_timestamp__ = map_.next_value()?;
                        }
                        GeneratedField::StrData => {
                            if str_data__.is_some() {
                                return Err(serde::de::Error::duplicate_field("strData"));
                            }
                            str_data__ = Some(map_.next_value()?);
                        }
                        GeneratedField::TimeSeries => {
                            if time_series__.is_some() {
                                return Err(serde::de::Error::duplicate_field("timeSeries"));
                            }
                            time_series__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Events => {
                            if events__.is_some() {
                                return Err(serde::de::Error::duplicate_field("events"));
                            }
                            events__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(MetricsBatch {
                    timestamp_ms: timestamp_ms__.unwrap_or_default(),
                    normalized_timestamp: normalized_timestamp__,
                    str_data: str_data__.unwrap_or_default(),
                    time_series: time_series__.unwrap_or_default(),
                    events: events__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.MetricsBatch", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for MigrateJobRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.job_ids.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.MigrateJobRequest", len)?;
        if !self.job_ids.is_empty() {
            struct_ser.serialize_field("jobIds", &self.job_ids)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for MigrateJobRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "job_ids",
            "jobIds",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            JobIds,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "jobIds" | "job_ids" => Ok(GeneratedField::JobIds),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = MigrateJobRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.MigrateJobRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<MigrateJobRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut job_ids__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::JobIds => {
                            if job_ids__.is_some() {
                                return Err(serde::de::Error::duplicate_field("jobIds"));
                            }
                            job_ids__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(MigrateJobRequest {
                    job_ids: job_ids__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.MigrateJobRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for MuteRoomTrackRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.room.is_empty() {
            len += 1;
        }
        if !self.identity.is_empty() {
            len += 1;
        }
        if !self.track_sid.is_empty() {
            len += 1;
        }
        if self.muted {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.MuteRoomTrackRequest", len)?;
        if !self.room.is_empty() {
            struct_ser.serialize_field("room", &self.room)?;
        }
        if !self.identity.is_empty() {
            struct_ser.serialize_field("identity", &self.identity)?;
        }
        if !self.track_sid.is_empty() {
            struct_ser.serialize_field("trackSid", &self.track_sid)?;
        }
        if self.muted {
            struct_ser.serialize_field("muted", &self.muted)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for MuteRoomTrackRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room",
            "identity",
            "track_sid",
            "trackSid",
            "muted",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Room,
            Identity,
            TrackSid,
            Muted,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "room" => Ok(GeneratedField::Room),
                            "identity" => Ok(GeneratedField::Identity),
                            "trackSid" | "track_sid" => Ok(GeneratedField::TrackSid),
                            "muted" => Ok(GeneratedField::Muted),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = MuteRoomTrackRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.MuteRoomTrackRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<MuteRoomTrackRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room__ = None;
                let mut identity__ = None;
                let mut track_sid__ = None;
                let mut muted__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Identity => {
                            if identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("identity"));
                            }
                            identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::TrackSid => {
                            if track_sid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trackSid"));
                            }
                            track_sid__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Muted => {
                            if muted__.is_some() {
                                return Err(serde::de::Error::duplicate_field("muted"));
                            }
                            muted__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(MuteRoomTrackRequest {
                    room: room__.unwrap_or_default(),
                    identity: identity__.unwrap_or_default(),
                    track_sid: track_sid__.unwrap_or_default(),
                    muted: muted__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.MuteRoomTrackRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for MuteRoomTrackResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.track.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.MuteRoomTrackResponse", len)?;
        if let Some(v) = self.track.as_ref() {
            struct_ser.serialize_field("track", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for MuteRoomTrackResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "track",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Track,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "track" => Ok(GeneratedField::Track),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = MuteRoomTrackResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.MuteRoomTrackResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<MuteRoomTrackResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut track__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Track => {
                            if track__.is_some() {
                                return Err(serde::de::Error::duplicate_field("track"));
                            }
                            track__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(MuteRoomTrackResponse {
                    track: track__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.MuteRoomTrackResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for MuteTrackRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.sid.is_empty() {
            len += 1;
        }
        if self.muted {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.MuteTrackRequest", len)?;
        if !self.sid.is_empty() {
            struct_ser.serialize_field("sid", &self.sid)?;
        }
        if self.muted {
            struct_ser.serialize_field("muted", &self.muted)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for MuteTrackRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sid",
            "muted",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Sid,
            Muted,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sid" => Ok(GeneratedField::Sid),
                            "muted" => Ok(GeneratedField::Muted),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = MuteTrackRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.MuteTrackRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<MuteTrackRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sid__ = None;
                let mut muted__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Sid => {
                            if sid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sid"));
                            }
                            sid__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Muted => {
                            if muted__.is_some() {
                                return Err(serde::de::Error::duplicate_field("muted"));
                            }
                            muted__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(MuteTrackRequest {
                    sid: sid__.unwrap_or_default(),
                    muted: muted__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.MuteTrackRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for Pagination {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.after_id.is_empty() {
            len += 1;
        }
        if self.limit != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.Pagination", len)?;
        if !self.after_id.is_empty() {
            struct_ser.serialize_field("afterId", &self.after_id)?;
        }
        if self.limit != 0 {
            struct_ser.serialize_field("limit", &self.limit)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for Pagination {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "after_id",
            "afterId",
            "limit",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            AfterId,
            Limit,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "afterId" | "after_id" => Ok(GeneratedField::AfterId),
                            "limit" => Ok(GeneratedField::Limit),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = Pagination;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.Pagination")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<Pagination, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut after_id__ = None;
                let mut limit__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::AfterId => {
                            if after_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("afterId"));
                            }
                            after_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Limit => {
                            if limit__.is_some() {
                                return Err(serde::de::Error::duplicate_field("limit"));
                            }
                            limit__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(Pagination {
                    after_id: after_id__.unwrap_or_default(),
                    limit: limit__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.Pagination", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ParticipantEgressRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.room_name.is_empty() {
            len += 1;
        }
        if !self.identity.is_empty() {
            len += 1;
        }
        if self.screen_share {
            len += 1;
        }
        if !self.file_outputs.is_empty() {
            len += 1;
        }
        if !self.stream_outputs.is_empty() {
            len += 1;
        }
        if !self.segment_outputs.is_empty() {
            len += 1;
        }
        if !self.image_outputs.is_empty() {
            len += 1;
        }
        if self.options.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ParticipantEgressRequest", len)?;
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if !self.identity.is_empty() {
            struct_ser.serialize_field("identity", &self.identity)?;
        }
        if self.screen_share {
            struct_ser.serialize_field("screenShare", &self.screen_share)?;
        }
        if !self.file_outputs.is_empty() {
            struct_ser.serialize_field("fileOutputs", &self.file_outputs)?;
        }
        if !self.stream_outputs.is_empty() {
            struct_ser.serialize_field("streamOutputs", &self.stream_outputs)?;
        }
        if !self.segment_outputs.is_empty() {
            struct_ser.serialize_field("segmentOutputs", &self.segment_outputs)?;
        }
        if !self.image_outputs.is_empty() {
            struct_ser.serialize_field("imageOutputs", &self.image_outputs)?;
        }
        if let Some(v) = self.options.as_ref() {
            match v {
                participant_egress_request::Options::Preset(v) => {
                    let v = EncodingOptionsPreset::try_from(*v)
                        .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", *v)))?;
                    struct_ser.serialize_field("preset", &v)?;
                }
                participant_egress_request::Options::Advanced(v) => {
                    struct_ser.serialize_field("advanced", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ParticipantEgressRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room_name",
            "roomName",
            "identity",
            "screen_share",
            "screenShare",
            "file_outputs",
            "fileOutputs",
            "stream_outputs",
            "streamOutputs",
            "segment_outputs",
            "segmentOutputs",
            "image_outputs",
            "imageOutputs",
            "preset",
            "advanced",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            RoomName,
            Identity,
            ScreenShare,
            FileOutputs,
            StreamOutputs,
            SegmentOutputs,
            ImageOutputs,
            Preset,
            Advanced,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "identity" => Ok(GeneratedField::Identity),
                            "screenShare" | "screen_share" => Ok(GeneratedField::ScreenShare),
                            "fileOutputs" | "file_outputs" => Ok(GeneratedField::FileOutputs),
                            "streamOutputs" | "stream_outputs" => Ok(GeneratedField::StreamOutputs),
                            "segmentOutputs" | "segment_outputs" => Ok(GeneratedField::SegmentOutputs),
                            "imageOutputs" | "image_outputs" => Ok(GeneratedField::ImageOutputs),
                            "preset" => Ok(GeneratedField::Preset),
                            "advanced" => Ok(GeneratedField::Advanced),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ParticipantEgressRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ParticipantEgressRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ParticipantEgressRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room_name__ = None;
                let mut identity__ = None;
                let mut screen_share__ = None;
                let mut file_outputs__ = None;
                let mut stream_outputs__ = None;
                let mut segment_outputs__ = None;
                let mut image_outputs__ = None;
                let mut options__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Identity => {
                            if identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("identity"));
                            }
                            identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ScreenShare => {
                            if screen_share__.is_some() {
                                return Err(serde::de::Error::duplicate_field("screenShare"));
                            }
                            screen_share__ = Some(map_.next_value()?);
                        }
                        GeneratedField::FileOutputs => {
                            if file_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("fileOutputs"));
                            }
                            file_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::StreamOutputs => {
                            if stream_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamOutputs"));
                            }
                            stream_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SegmentOutputs => {
                            if segment_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("segmentOutputs"));
                            }
                            segment_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ImageOutputs => {
                            if image_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("imageOutputs"));
                            }
                            image_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Preset => {
                            if options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("preset"));
                            }
                            options__ = map_.next_value::<::std::option::Option<EncodingOptionsPreset>>()?.map(|x| participant_egress_request::Options::Preset(x as i32));
                        }
                        GeneratedField::Advanced => {
                            if options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("advanced"));
                            }
                            options__ = map_.next_value::<::std::option::Option<_>>()?.map(participant_egress_request::Options::Advanced)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ParticipantEgressRequest {
                    room_name: room_name__.unwrap_or_default(),
                    identity: identity__.unwrap_or_default(),
                    screen_share: screen_share__.unwrap_or_default(),
                    file_outputs: file_outputs__.unwrap_or_default(),
                    stream_outputs: stream_outputs__.unwrap_or_default(),
                    segment_outputs: segment_outputs__.unwrap_or_default(),
                    image_outputs: image_outputs__.unwrap_or_default(),
                    options: options__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.ParticipantEgressRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ParticipantInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.sid.is_empty() {
            len += 1;
        }
        if !self.identity.is_empty() {
            len += 1;
        }
        if self.state != 0 {
            len += 1;
        }
        if !self.tracks.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        if self.joined_at != 0 {
            len += 1;
        }
        if self.joined_at_ms != 0 {
            len += 1;
        }
        if !self.name.is_empty() {
            len += 1;
        }
        if self.version != 0 {
            len += 1;
        }
        if self.permission.is_some() {
            len += 1;
        }
        if !self.region.is_empty() {
            len += 1;
        }
        if self.is_publisher {
            len += 1;
        }
        if self.kind != 0 {
            len += 1;
        }
        if !self.attributes.is_empty() {
            len += 1;
        }
        if self.disconnect_reason != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ParticipantInfo", len)?;
        if !self.sid.is_empty() {
            struct_ser.serialize_field("sid", &self.sid)?;
        }
        if !self.identity.is_empty() {
            struct_ser.serialize_field("identity", &self.identity)?;
        }
        if self.state != 0 {
            let v = participant_info::State::try_from(self.state)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.state)))?;
            struct_ser.serialize_field("state", &v)?;
        }
        if !self.tracks.is_empty() {
            struct_ser.serialize_field("tracks", &self.tracks)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        if self.joined_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("joinedAt", ToString::to_string(&self.joined_at).as_str())?;
        }
        if self.joined_at_ms != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("joinedAtMs", ToString::to_string(&self.joined_at_ms).as_str())?;
        }
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if self.version != 0 {
            struct_ser.serialize_field("version", &self.version)?;
        }
        if let Some(v) = self.permission.as_ref() {
            struct_ser.serialize_field("permission", v)?;
        }
        if !self.region.is_empty() {
            struct_ser.serialize_field("region", &self.region)?;
        }
        if self.is_publisher {
            struct_ser.serialize_field("isPublisher", &self.is_publisher)?;
        }
        if self.kind != 0 {
            let v = participant_info::Kind::try_from(self.kind)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.kind)))?;
            struct_ser.serialize_field("kind", &v)?;
        }
        if !self.attributes.is_empty() {
            struct_ser.serialize_field("attributes", &self.attributes)?;
        }
        if self.disconnect_reason != 0 {
            let v = DisconnectReason::try_from(self.disconnect_reason)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.disconnect_reason)))?;
            struct_ser.serialize_field("disconnectReason", &v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ParticipantInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sid",
            "identity",
            "state",
            "tracks",
            "metadata",
            "joined_at",
            "joinedAt",
            "joined_at_ms",
            "joinedAtMs",
            "name",
            "version",
            "permission",
            "region",
            "is_publisher",
            "isPublisher",
            "kind",
            "attributes",
            "disconnect_reason",
            "disconnectReason",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Sid,
            Identity,
            State,
            Tracks,
            Metadata,
            JoinedAt,
            JoinedAtMs,
            Name,
            Version,
            Permission,
            Region,
            IsPublisher,
            Kind,
            Attributes,
            DisconnectReason,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sid" => Ok(GeneratedField::Sid),
                            "identity" => Ok(GeneratedField::Identity),
                            "state" => Ok(GeneratedField::State),
                            "tracks" => Ok(GeneratedField::Tracks),
                            "metadata" => Ok(GeneratedField::Metadata),
                            "joinedAt" | "joined_at" => Ok(GeneratedField::JoinedAt),
                            "joinedAtMs" | "joined_at_ms" => Ok(GeneratedField::JoinedAtMs),
                            "name" => Ok(GeneratedField::Name),
                            "version" => Ok(GeneratedField::Version),
                            "permission" => Ok(GeneratedField::Permission),
                            "region" => Ok(GeneratedField::Region),
                            "isPublisher" | "is_publisher" => Ok(GeneratedField::IsPublisher),
                            "kind" => Ok(GeneratedField::Kind),
                            "attributes" => Ok(GeneratedField::Attributes),
                            "disconnectReason" | "disconnect_reason" => Ok(GeneratedField::DisconnectReason),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ParticipantInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ParticipantInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ParticipantInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sid__ = None;
                let mut identity__ = None;
                let mut state__ = None;
                let mut tracks__ = None;
                let mut metadata__ = None;
                let mut joined_at__ = None;
                let mut joined_at_ms__ = None;
                let mut name__ = None;
                let mut version__ = None;
                let mut permission__ = None;
                let mut region__ = None;
                let mut is_publisher__ = None;
                let mut kind__ = None;
                let mut attributes__ = None;
                let mut disconnect_reason__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Sid => {
                            if sid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sid"));
                            }
                            sid__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Identity => {
                            if identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("identity"));
                            }
                            identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::State => {
                            if state__.is_some() {
                                return Err(serde::de::Error::duplicate_field("state"));
                            }
                            state__ = Some(map_.next_value::<participant_info::State>()? as i32);
                        }
                        GeneratedField::Tracks => {
                            if tracks__.is_some() {
                                return Err(serde::de::Error::duplicate_field("tracks"));
                            }
                            tracks__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::JoinedAt => {
                            if joined_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("joinedAt"));
                            }
                            joined_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::JoinedAtMs => {
                            if joined_at_ms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("joinedAtMs"));
                            }
                            joined_at_ms__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Version => {
                            if version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("version"));
                            }
                            version__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Permission => {
                            if permission__.is_some() {
                                return Err(serde::de::Error::duplicate_field("permission"));
                            }
                            permission__ = map_.next_value()?;
                        }
                        GeneratedField::Region => {
                            if region__.is_some() {
                                return Err(serde::de::Error::duplicate_field("region"));
                            }
                            region__ = Some(map_.next_value()?);
                        }
                        GeneratedField::IsPublisher => {
                            if is_publisher__.is_some() {
                                return Err(serde::de::Error::duplicate_field("isPublisher"));
                            }
                            is_publisher__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Kind => {
                            if kind__.is_some() {
                                return Err(serde::de::Error::duplicate_field("kind"));
                            }
                            kind__ = Some(map_.next_value::<participant_info::Kind>()? as i32);
                        }
                        GeneratedField::Attributes => {
                            if attributes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("attributes"));
                            }
                            attributes__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::DisconnectReason => {
                            if disconnect_reason__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disconnectReason"));
                            }
                            disconnect_reason__ = Some(map_.next_value::<DisconnectReason>()? as i32);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ParticipantInfo {
                    sid: sid__.unwrap_or_default(),
                    identity: identity__.unwrap_or_default(),
                    state: state__.unwrap_or_default(),
                    tracks: tracks__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                    joined_at: joined_at__.unwrap_or_default(),
                    joined_at_ms: joined_at_ms__.unwrap_or_default(),
                    name: name__.unwrap_or_default(),
                    version: version__.unwrap_or_default(),
                    permission: permission__,
                    region: region__.unwrap_or_default(),
                    is_publisher: is_publisher__.unwrap_or_default(),
                    kind: kind__.unwrap_or_default(),
                    attributes: attributes__.unwrap_or_default(),
                    disconnect_reason: disconnect_reason__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ParticipantInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for participant_info::Kind {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Standard => "STANDARD",
            Self::Ingress => "INGRESS",
            Self::Egress => "EGRESS",
            Self::Sip => "SIP",
            Self::Agent => "AGENT",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for participant_info::Kind {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "STANDARD",
            "INGRESS",
            "EGRESS",
            "SIP",
            "AGENT",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = participant_info::Kind;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "STANDARD" => Ok(participant_info::Kind::Standard),
                    "INGRESS" => Ok(participant_info::Kind::Ingress),
                    "EGRESS" => Ok(participant_info::Kind::Egress),
                    "SIP" => Ok(participant_info::Kind::Sip),
                    "AGENT" => Ok(participant_info::Kind::Agent),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for participant_info::State {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Joining => "JOINING",
            Self::Joined => "JOINED",
            Self::Active => "ACTIVE",
            Self::Disconnected => "DISCONNECTED",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for participant_info::State {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "JOINING",
            "JOINED",
            "ACTIVE",
            "DISCONNECTED",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = participant_info::State;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "JOINING" => Ok(participant_info::State::Joining),
                    "JOINED" => Ok(participant_info::State::Joined),
                    "ACTIVE" => Ok(participant_info::State::Active),
                    "DISCONNECTED" => Ok(participant_info::State::Disconnected),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for ParticipantPermission {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.can_subscribe {
            len += 1;
        }
        if self.can_publish {
            len += 1;
        }
        if self.can_publish_data {
            len += 1;
        }
        if !self.can_publish_sources.is_empty() {
            len += 1;
        }
        if self.hidden {
            len += 1;
        }
        if self.recorder {
            len += 1;
        }
        if self.can_update_metadata {
            len += 1;
        }
        if self.agent {
            len += 1;
        }
        if self.can_subscribe_metrics {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ParticipantPermission", len)?;
        if self.can_subscribe {
            struct_ser.serialize_field("canSubscribe", &self.can_subscribe)?;
        }
        if self.can_publish {
            struct_ser.serialize_field("canPublish", &self.can_publish)?;
        }
        if self.can_publish_data {
            struct_ser.serialize_field("canPublishData", &self.can_publish_data)?;
        }
        if !self.can_publish_sources.is_empty() {
            let v = self.can_publish_sources.iter().cloned().map(|v| {
                TrackSource::try_from(v)
                    .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", v)))
                }).collect::<std::result::Result<Vec<_>, _>>()?;
            struct_ser.serialize_field("canPublishSources", &v)?;
        }
        if self.hidden {
            struct_ser.serialize_field("hidden", &self.hidden)?;
        }
        if self.recorder {
            struct_ser.serialize_field("recorder", &self.recorder)?;
        }
        if self.can_update_metadata {
            struct_ser.serialize_field("canUpdateMetadata", &self.can_update_metadata)?;
        }
        if self.agent {
            struct_ser.serialize_field("agent", &self.agent)?;
        }
        if self.can_subscribe_metrics {
            struct_ser.serialize_field("canSubscribeMetrics", &self.can_subscribe_metrics)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ParticipantPermission {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "can_subscribe",
            "canSubscribe",
            "can_publish",
            "canPublish",
            "can_publish_data",
            "canPublishData",
            "can_publish_sources",
            "canPublishSources",
            "hidden",
            "recorder",
            "can_update_metadata",
            "canUpdateMetadata",
            "agent",
            "can_subscribe_metrics",
            "canSubscribeMetrics",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            CanSubscribe,
            CanPublish,
            CanPublishData,
            CanPublishSources,
            Hidden,
            Recorder,
            CanUpdateMetadata,
            Agent,
            CanSubscribeMetrics,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "canSubscribe" | "can_subscribe" => Ok(GeneratedField::CanSubscribe),
                            "canPublish" | "can_publish" => Ok(GeneratedField::CanPublish),
                            "canPublishData" | "can_publish_data" => Ok(GeneratedField::CanPublishData),
                            "canPublishSources" | "can_publish_sources" => Ok(GeneratedField::CanPublishSources),
                            "hidden" => Ok(GeneratedField::Hidden),
                            "recorder" => Ok(GeneratedField::Recorder),
                            "canUpdateMetadata" | "can_update_metadata" => Ok(GeneratedField::CanUpdateMetadata),
                            "agent" => Ok(GeneratedField::Agent),
                            "canSubscribeMetrics" | "can_subscribe_metrics" => Ok(GeneratedField::CanSubscribeMetrics),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ParticipantPermission;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ParticipantPermission")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ParticipantPermission, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut can_subscribe__ = None;
                let mut can_publish__ = None;
                let mut can_publish_data__ = None;
                let mut can_publish_sources__ = None;
                let mut hidden__ = None;
                let mut recorder__ = None;
                let mut can_update_metadata__ = None;
                let mut agent__ = None;
                let mut can_subscribe_metrics__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::CanSubscribe => {
                            if can_subscribe__.is_some() {
                                return Err(serde::de::Error::duplicate_field("canSubscribe"));
                            }
                            can_subscribe__ = Some(map_.next_value()?);
                        }
                        GeneratedField::CanPublish => {
                            if can_publish__.is_some() {
                                return Err(serde::de::Error::duplicate_field("canPublish"));
                            }
                            can_publish__ = Some(map_.next_value()?);
                        }
                        GeneratedField::CanPublishData => {
                            if can_publish_data__.is_some() {
                                return Err(serde::de::Error::duplicate_field("canPublishData"));
                            }
                            can_publish_data__ = Some(map_.next_value()?);
                        }
                        GeneratedField::CanPublishSources => {
                            if can_publish_sources__.is_some() {
                                return Err(serde::de::Error::duplicate_field("canPublishSources"));
                            }
                            can_publish_sources__ = Some(map_.next_value::<Vec<TrackSource>>()?.into_iter().map(|x| x as i32).collect());
                        }
                        GeneratedField::Hidden => {
                            if hidden__.is_some() {
                                return Err(serde::de::Error::duplicate_field("hidden"));
                            }
                            hidden__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Recorder => {
                            if recorder__.is_some() {
                                return Err(serde::de::Error::duplicate_field("recorder"));
                            }
                            recorder__ = Some(map_.next_value()?);
                        }
                        GeneratedField::CanUpdateMetadata => {
                            if can_update_metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("canUpdateMetadata"));
                            }
                            can_update_metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Agent => {
                            if agent__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agent"));
                            }
                            agent__ = Some(map_.next_value()?);
                        }
                        GeneratedField::CanSubscribeMetrics => {
                            if can_subscribe_metrics__.is_some() {
                                return Err(serde::de::Error::duplicate_field("canSubscribeMetrics"));
                            }
                            can_subscribe_metrics__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ParticipantPermission {
                    can_subscribe: can_subscribe__.unwrap_or_default(),
                    can_publish: can_publish__.unwrap_or_default(),
                    can_publish_data: can_publish_data__.unwrap_or_default(),
                    can_publish_sources: can_publish_sources__.unwrap_or_default(),
                    hidden: hidden__.unwrap_or_default(),
                    recorder: recorder__.unwrap_or_default(),
                    can_update_metadata: can_update_metadata__.unwrap_or_default(),
                    agent: agent__.unwrap_or_default(),
                    can_subscribe_metrics: can_subscribe_metrics__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ParticipantPermission", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ParticipantTracks {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.participant_sid.is_empty() {
            len += 1;
        }
        if !self.track_sids.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ParticipantTracks", len)?;
        if !self.participant_sid.is_empty() {
            struct_ser.serialize_field("participantSid", &self.participant_sid)?;
        }
        if !self.track_sids.is_empty() {
            struct_ser.serialize_field("trackSids", &self.track_sids)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ParticipantTracks {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "participant_sid",
            "participantSid",
            "track_sids",
            "trackSids",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            ParticipantSid,
            TrackSids,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "participantSid" | "participant_sid" => Ok(GeneratedField::ParticipantSid),
                            "trackSids" | "track_sids" => Ok(GeneratedField::TrackSids),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ParticipantTracks;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ParticipantTracks")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ParticipantTracks, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut participant_sid__ = None;
                let mut track_sids__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::ParticipantSid => {
                            if participant_sid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantSid"));
                            }
                            participant_sid__ = Some(map_.next_value()?);
                        }
                        GeneratedField::TrackSids => {
                            if track_sids__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trackSids"));
                            }
                            track_sids__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ParticipantTracks {
                    participant_sid: participant_sid__.unwrap_or_default(),
                    track_sids: track_sids__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ParticipantTracks", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ParticipantUpdate {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.participants.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ParticipantUpdate", len)?;
        if !self.participants.is_empty() {
            struct_ser.serialize_field("participants", &self.participants)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ParticipantUpdate {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "participants",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Participants,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "participants" => Ok(GeneratedField::Participants),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ParticipantUpdate;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ParticipantUpdate")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ParticipantUpdate, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut participants__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Participants => {
                            if participants__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participants"));
                            }
                            participants__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ParticipantUpdate {
                    participants: participants__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ParticipantUpdate", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for Ping {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.timestamp != 0 {
            len += 1;
        }
        if self.rtt != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.Ping", len)?;
        if self.timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("timestamp", ToString::to_string(&self.timestamp).as_str())?;
        }
        if self.rtt != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("rtt", ToString::to_string(&self.rtt).as_str())?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for Ping {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "timestamp",
            "rtt",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Timestamp,
            Rtt,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "timestamp" => Ok(GeneratedField::Timestamp),
                            "rtt" => Ok(GeneratedField::Rtt),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = Ping;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.Ping")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<Ping, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut timestamp__ = None;
                let mut rtt__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Timestamp => {
                            if timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("timestamp"));
                            }
                            timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Rtt => {
                            if rtt__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rtt"));
                            }
                            rtt__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(Ping {
                    timestamp: timestamp__.unwrap_or_default(),
                    rtt: rtt__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.Ping", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for PlayoutDelay {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.enabled {
            len += 1;
        }
        if self.min != 0 {
            len += 1;
        }
        if self.max != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.PlayoutDelay", len)?;
        if self.enabled {
            struct_ser.serialize_field("enabled", &self.enabled)?;
        }
        if self.min != 0 {
            struct_ser.serialize_field("min", &self.min)?;
        }
        if self.max != 0 {
            struct_ser.serialize_field("max", &self.max)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for PlayoutDelay {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "enabled",
            "min",
            "max",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Enabled,
            Min,
            Max,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "enabled" => Ok(GeneratedField::Enabled),
                            "min" => Ok(GeneratedField::Min),
                            "max" => Ok(GeneratedField::Max),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = PlayoutDelay;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.PlayoutDelay")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<PlayoutDelay, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut enabled__ = None;
                let mut min__ = None;
                let mut max__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Enabled => {
                            if enabled__.is_some() {
                                return Err(serde::de::Error::duplicate_field("enabled"));
                            }
                            enabled__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Min => {
                            if min__.is_some() {
                                return Err(serde::de::Error::duplicate_field("min"));
                            }
                            min__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Max => {
                            if max__.is_some() {
                                return Err(serde::de::Error::duplicate_field("max"));
                            }
                            max__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(PlayoutDelay {
                    enabled: enabled__.unwrap_or_default(),
                    min: min__.unwrap_or_default(),
                    max: max__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.PlayoutDelay", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for Pong {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.last_ping_timestamp != 0 {
            len += 1;
        }
        if self.timestamp != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.Pong", len)?;
        if self.last_ping_timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("lastPingTimestamp", ToString::to_string(&self.last_ping_timestamp).as_str())?;
        }
        if self.timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("timestamp", ToString::to_string(&self.timestamp).as_str())?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for Pong {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "last_ping_timestamp",
            "lastPingTimestamp",
            "timestamp",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            LastPingTimestamp,
            Timestamp,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "lastPingTimestamp" | "last_ping_timestamp" => Ok(GeneratedField::LastPingTimestamp),
                            "timestamp" => Ok(GeneratedField::Timestamp),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = Pong;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.Pong")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<Pong, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut last_ping_timestamp__ = None;
                let mut timestamp__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::LastPingTimestamp => {
                            if last_ping_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("lastPingTimestamp"));
                            }
                            last_ping_timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Timestamp => {
                            if timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("timestamp"));
                            }
                            timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(Pong {
                    last_ping_timestamp: last_ping_timestamp__.unwrap_or_default(),
                    timestamp: timestamp__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.Pong", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ProxyConfig {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.url.is_empty() {
            len += 1;
        }
        if !self.username.is_empty() {
            len += 1;
        }
        if !self.password.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ProxyConfig", len)?;
        if !self.url.is_empty() {
            struct_ser.serialize_field("url", &self.url)?;
        }
        if !self.username.is_empty() {
            struct_ser.serialize_field("username", &self.username)?;
        }
        if !self.password.is_empty() {
            struct_ser.serialize_field("password", &self.password)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ProxyConfig {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "url",
            "username",
            "password",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Url,
            Username,
            Password,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "url" => Ok(GeneratedField::Url),
                            "username" => Ok(GeneratedField::Username),
                            "password" => Ok(GeneratedField::Password),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ProxyConfig;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ProxyConfig")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ProxyConfig, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut url__ = None;
                let mut username__ = None;
                let mut password__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Url => {
                            if url__.is_some() {
                                return Err(serde::de::Error::duplicate_field("url"));
                            }
                            url__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Username => {
                            if username__.is_some() {
                                return Err(serde::de::Error::duplicate_field("username"));
                            }
                            username__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Password => {
                            if password__.is_some() {
                                return Err(serde::de::Error::duplicate_field("password"));
                            }
                            password__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ProxyConfig {
                    url: url__.unwrap_or_default(),
                    username: username__.unwrap_or_default(),
                    password: password__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.ProxyConfig", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RtcpSenderReportState {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.rtp_timestamp != 0 {
            len += 1;
        }
        if self.rtp_timestamp_ext != 0 {
            len += 1;
        }
        if self.ntp_timestamp != 0 {
            len += 1;
        }
        if self.at != 0 {
            len += 1;
        }
        if self.at_adjusted != 0 {
            len += 1;
        }
        if self.packets != 0 {
            len += 1;
        }
        if self.octets != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RTCPSenderReportState", len)?;
        if self.rtp_timestamp != 0 {
            struct_ser.serialize_field("rtpTimestamp", &self.rtp_timestamp)?;
        }
        if self.rtp_timestamp_ext != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("rtpTimestampExt", ToString::to_string(&self.rtp_timestamp_ext).as_str())?;
        }
        if self.ntp_timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("ntpTimestamp", ToString::to_string(&self.ntp_timestamp).as_str())?;
        }
        if self.at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("at", ToString::to_string(&self.at).as_str())?;
        }
        if self.at_adjusted != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("atAdjusted", ToString::to_string(&self.at_adjusted).as_str())?;
        }
        if self.packets != 0 {
            struct_ser.serialize_field("packets", &self.packets)?;
        }
        if self.octets != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("octets", ToString::to_string(&self.octets).as_str())?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RtcpSenderReportState {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "rtp_timestamp",
            "rtpTimestamp",
            "rtp_timestamp_ext",
            "rtpTimestampExt",
            "ntp_timestamp",
            "ntpTimestamp",
            "at",
            "at_adjusted",
            "atAdjusted",
            "packets",
            "octets",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            RtpTimestamp,
            RtpTimestampExt,
            NtpTimestamp,
            At,
            AtAdjusted,
            Packets,
            Octets,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "rtpTimestamp" | "rtp_timestamp" => Ok(GeneratedField::RtpTimestamp),
                            "rtpTimestampExt" | "rtp_timestamp_ext" => Ok(GeneratedField::RtpTimestampExt),
                            "ntpTimestamp" | "ntp_timestamp" => Ok(GeneratedField::NtpTimestamp),
                            "at" => Ok(GeneratedField::At),
                            "atAdjusted" | "at_adjusted" => Ok(GeneratedField::AtAdjusted),
                            "packets" => Ok(GeneratedField::Packets),
                            "octets" => Ok(GeneratedField::Octets),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RtcpSenderReportState;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RTCPSenderReportState")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RtcpSenderReportState, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut rtp_timestamp__ = None;
                let mut rtp_timestamp_ext__ = None;
                let mut ntp_timestamp__ = None;
                let mut at__ = None;
                let mut at_adjusted__ = None;
                let mut packets__ = None;
                let mut octets__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::RtpTimestamp => {
                            if rtp_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rtpTimestamp"));
                            }
                            rtp_timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::RtpTimestampExt => {
                            if rtp_timestamp_ext__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rtpTimestampExt"));
                            }
                            rtp_timestamp_ext__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::NtpTimestamp => {
                            if ntp_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("ntpTimestamp"));
                            }
                            ntp_timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::At => {
                            if at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("at"));
                            }
                            at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::AtAdjusted => {
                            if at_adjusted__.is_some() {
                                return Err(serde::de::Error::duplicate_field("atAdjusted"));
                            }
                            at_adjusted__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Packets => {
                            if packets__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packets"));
                            }
                            packets__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Octets => {
                            if octets__.is_some() {
                                return Err(serde::de::Error::duplicate_field("octets"));
                            }
                            octets__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RtcpSenderReportState {
                    rtp_timestamp: rtp_timestamp__.unwrap_or_default(),
                    rtp_timestamp_ext: rtp_timestamp_ext__.unwrap_or_default(),
                    ntp_timestamp: ntp_timestamp__.unwrap_or_default(),
                    at: at__.unwrap_or_default(),
                    at_adjusted: at_adjusted__.unwrap_or_default(),
                    packets: packets__.unwrap_or_default(),
                    octets: octets__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RTCPSenderReportState", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RtpDrift {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.start_time.is_some() {
            len += 1;
        }
        if self.end_time.is_some() {
            len += 1;
        }
        if self.duration != 0. {
            len += 1;
        }
        if self.start_timestamp != 0 {
            len += 1;
        }
        if self.end_timestamp != 0 {
            len += 1;
        }
        if self.rtp_clock_ticks != 0 {
            len += 1;
        }
        if self.drift_samples != 0 {
            len += 1;
        }
        if self.drift_ms != 0. {
            len += 1;
        }
        if self.clock_rate != 0. {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RTPDrift", len)?;
        if let Some(v) = self.start_time.as_ref() {
            struct_ser.serialize_field("startTime", v)?;
        }
        if let Some(v) = self.end_time.as_ref() {
            struct_ser.serialize_field("endTime", v)?;
        }
        if self.duration != 0. {
            struct_ser.serialize_field("duration", &self.duration)?;
        }
        if self.start_timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startTimestamp", ToString::to_string(&self.start_timestamp).as_str())?;
        }
        if self.end_timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endTimestamp", ToString::to_string(&self.end_timestamp).as_str())?;
        }
        if self.rtp_clock_ticks != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("rtpClockTicks", ToString::to_string(&self.rtp_clock_ticks).as_str())?;
        }
        if self.drift_samples != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("driftSamples", ToString::to_string(&self.drift_samples).as_str())?;
        }
        if self.drift_ms != 0. {
            struct_ser.serialize_field("driftMs", &self.drift_ms)?;
        }
        if self.clock_rate != 0. {
            struct_ser.serialize_field("clockRate", &self.clock_rate)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RtpDrift {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "start_time",
            "startTime",
            "end_time",
            "endTime",
            "duration",
            "start_timestamp",
            "startTimestamp",
            "end_timestamp",
            "endTimestamp",
            "rtp_clock_ticks",
            "rtpClockTicks",
            "drift_samples",
            "driftSamples",
            "drift_ms",
            "driftMs",
            "clock_rate",
            "clockRate",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            StartTime,
            EndTime,
            Duration,
            StartTimestamp,
            EndTimestamp,
            RtpClockTicks,
            DriftSamples,
            DriftMs,
            ClockRate,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "startTime" | "start_time" => Ok(GeneratedField::StartTime),
                            "endTime" | "end_time" => Ok(GeneratedField::EndTime),
                            "duration" => Ok(GeneratedField::Duration),
                            "startTimestamp" | "start_timestamp" => Ok(GeneratedField::StartTimestamp),
                            "endTimestamp" | "end_timestamp" => Ok(GeneratedField::EndTimestamp),
                            "rtpClockTicks" | "rtp_clock_ticks" => Ok(GeneratedField::RtpClockTicks),
                            "driftSamples" | "drift_samples" => Ok(GeneratedField::DriftSamples),
                            "driftMs" | "drift_ms" => Ok(GeneratedField::DriftMs),
                            "clockRate" | "clock_rate" => Ok(GeneratedField::ClockRate),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RtpDrift;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RTPDrift")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RtpDrift, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut start_time__ = None;
                let mut end_time__ = None;
                let mut duration__ = None;
                let mut start_timestamp__ = None;
                let mut end_timestamp__ = None;
                let mut rtp_clock_ticks__ = None;
                let mut drift_samples__ = None;
                let mut drift_ms__ = None;
                let mut clock_rate__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::StartTime => {
                            if start_time__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startTime"));
                            }
                            start_time__ = map_.next_value()?;
                        }
                        GeneratedField::EndTime => {
                            if end_time__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endTime"));
                            }
                            end_time__ = map_.next_value()?;
                        }
                        GeneratedField::Duration => {
                            if duration__.is_some() {
                                return Err(serde::de::Error::duplicate_field("duration"));
                            }
                            duration__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::StartTimestamp => {
                            if start_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startTimestamp"));
                            }
                            start_timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndTimestamp => {
                            if end_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endTimestamp"));
                            }
                            end_timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::RtpClockTicks => {
                            if rtp_clock_ticks__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rtpClockTicks"));
                            }
                            rtp_clock_ticks__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DriftSamples => {
                            if drift_samples__.is_some() {
                                return Err(serde::de::Error::duplicate_field("driftSamples"));
                            }
                            drift_samples__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DriftMs => {
                            if drift_ms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("driftMs"));
                            }
                            drift_ms__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ClockRate => {
                            if clock_rate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("clockRate"));
                            }
                            clock_rate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RtpDrift {
                    start_time: start_time__,
                    end_time: end_time__,
                    duration: duration__.unwrap_or_default(),
                    start_timestamp: start_timestamp__.unwrap_or_default(),
                    end_timestamp: end_timestamp__.unwrap_or_default(),
                    rtp_clock_ticks: rtp_clock_ticks__.unwrap_or_default(),
                    drift_samples: drift_samples__.unwrap_or_default(),
                    drift_ms: drift_ms__.unwrap_or_default(),
                    clock_rate: clock_rate__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RTPDrift", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RtpForwarderState {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.started {
            len += 1;
        }
        if self.reference_layer_spatial != 0 {
            len += 1;
        }
        if self.pre_start_time != 0 {
            len += 1;
        }
        if self.ext_first_timestamp != 0 {
            len += 1;
        }
        if self.dummy_start_timestamp_offset != 0 {
            len += 1;
        }
        if self.rtp_munger.is_some() {
            len += 1;
        }
        if !self.sender_report_state.is_empty() {
            len += 1;
        }
        if self.codec_munger.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RTPForwarderState", len)?;
        if self.started {
            struct_ser.serialize_field("started", &self.started)?;
        }
        if self.reference_layer_spatial != 0 {
            struct_ser.serialize_field("referenceLayerSpatial", &self.reference_layer_spatial)?;
        }
        if self.pre_start_time != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("preStartTime", ToString::to_string(&self.pre_start_time).as_str())?;
        }
        if self.ext_first_timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("extFirstTimestamp", ToString::to_string(&self.ext_first_timestamp).as_str())?;
        }
        if self.dummy_start_timestamp_offset != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("dummyStartTimestampOffset", ToString::to_string(&self.dummy_start_timestamp_offset).as_str())?;
        }
        if let Some(v) = self.rtp_munger.as_ref() {
            struct_ser.serialize_field("rtpMunger", v)?;
        }
        if !self.sender_report_state.is_empty() {
            struct_ser.serialize_field("senderReportState", &self.sender_report_state)?;
        }
        if let Some(v) = self.codec_munger.as_ref() {
            match v {
                rtp_forwarder_state::CodecMunger::Vp8Munger(v) => {
                    struct_ser.serialize_field("vp8Munger", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RtpForwarderState {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "started",
            "reference_layer_spatial",
            "referenceLayerSpatial",
            "pre_start_time",
            "preStartTime",
            "ext_first_timestamp",
            "extFirstTimestamp",
            "dummy_start_timestamp_offset",
            "dummyStartTimestampOffset",
            "rtp_munger",
            "rtpMunger",
            "sender_report_state",
            "senderReportState",
            "vp8_munger",
            "vp8Munger",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Started,
            ReferenceLayerSpatial,
            PreStartTime,
            ExtFirstTimestamp,
            DummyStartTimestampOffset,
            RtpMunger,
            SenderReportState,
            Vp8Munger,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "started" => Ok(GeneratedField::Started),
                            "referenceLayerSpatial" | "reference_layer_spatial" => Ok(GeneratedField::ReferenceLayerSpatial),
                            "preStartTime" | "pre_start_time" => Ok(GeneratedField::PreStartTime),
                            "extFirstTimestamp" | "ext_first_timestamp" => Ok(GeneratedField::ExtFirstTimestamp),
                            "dummyStartTimestampOffset" | "dummy_start_timestamp_offset" => Ok(GeneratedField::DummyStartTimestampOffset),
                            "rtpMunger" | "rtp_munger" => Ok(GeneratedField::RtpMunger),
                            "senderReportState" | "sender_report_state" => Ok(GeneratedField::SenderReportState),
                            "vp8Munger" | "vp8_munger" => Ok(GeneratedField::Vp8Munger),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RtpForwarderState;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RTPForwarderState")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RtpForwarderState, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut started__ = None;
                let mut reference_layer_spatial__ = None;
                let mut pre_start_time__ = None;
                let mut ext_first_timestamp__ = None;
                let mut dummy_start_timestamp_offset__ = None;
                let mut rtp_munger__ = None;
                let mut sender_report_state__ = None;
                let mut codec_munger__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Started => {
                            if started__.is_some() {
                                return Err(serde::de::Error::duplicate_field("started"));
                            }
                            started__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ReferenceLayerSpatial => {
                            if reference_layer_spatial__.is_some() {
                                return Err(serde::de::Error::duplicate_field("referenceLayerSpatial"));
                            }
                            reference_layer_spatial__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PreStartTime => {
                            if pre_start_time__.is_some() {
                                return Err(serde::de::Error::duplicate_field("preStartTime"));
                            }
                            pre_start_time__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ExtFirstTimestamp => {
                            if ext_first_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("extFirstTimestamp"));
                            }
                            ext_first_timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DummyStartTimestampOffset => {
                            if dummy_start_timestamp_offset__.is_some() {
                                return Err(serde::de::Error::duplicate_field("dummyStartTimestampOffset"));
                            }
                            dummy_start_timestamp_offset__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::RtpMunger => {
                            if rtp_munger__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rtpMunger"));
                            }
                            rtp_munger__ = map_.next_value()?;
                        }
                        GeneratedField::SenderReportState => {
                            if sender_report_state__.is_some() {
                                return Err(serde::de::Error::duplicate_field("senderReportState"));
                            }
                            sender_report_state__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Vp8Munger => {
                            if codec_munger__.is_some() {
                                return Err(serde::de::Error::duplicate_field("vp8Munger"));
                            }
                            codec_munger__ = map_.next_value::<::std::option::Option<_>>()?.map(rtp_forwarder_state::CodecMunger::Vp8Munger)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RtpForwarderState {
                    started: started__.unwrap_or_default(),
                    reference_layer_spatial: reference_layer_spatial__.unwrap_or_default(),
                    pre_start_time: pre_start_time__.unwrap_or_default(),
                    ext_first_timestamp: ext_first_timestamp__.unwrap_or_default(),
                    dummy_start_timestamp_offset: dummy_start_timestamp_offset__.unwrap_or_default(),
                    rtp_munger: rtp_munger__,
                    sender_report_state: sender_report_state__.unwrap_or_default(),
                    codec_munger: codec_munger__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.RTPForwarderState", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RtpMungerState {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.ext_last_sequence_number != 0 {
            len += 1;
        }
        if self.ext_second_last_sequence_number != 0 {
            len += 1;
        }
        if self.ext_last_timestamp != 0 {
            len += 1;
        }
        if self.ext_second_last_timestamp != 0 {
            len += 1;
        }
        if self.last_marker {
            len += 1;
        }
        if self.second_last_marker {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RTPMungerState", len)?;
        if self.ext_last_sequence_number != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("extLastSequenceNumber", ToString::to_string(&self.ext_last_sequence_number).as_str())?;
        }
        if self.ext_second_last_sequence_number != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("extSecondLastSequenceNumber", ToString::to_string(&self.ext_second_last_sequence_number).as_str())?;
        }
        if self.ext_last_timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("extLastTimestamp", ToString::to_string(&self.ext_last_timestamp).as_str())?;
        }
        if self.ext_second_last_timestamp != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("extSecondLastTimestamp", ToString::to_string(&self.ext_second_last_timestamp).as_str())?;
        }
        if self.last_marker {
            struct_ser.serialize_field("lastMarker", &self.last_marker)?;
        }
        if self.second_last_marker {
            struct_ser.serialize_field("secondLastMarker", &self.second_last_marker)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RtpMungerState {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "ext_last_sequence_number",
            "extLastSequenceNumber",
            "ext_second_last_sequence_number",
            "extSecondLastSequenceNumber",
            "ext_last_timestamp",
            "extLastTimestamp",
            "ext_second_last_timestamp",
            "extSecondLastTimestamp",
            "last_marker",
            "lastMarker",
            "second_last_marker",
            "secondLastMarker",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            ExtLastSequenceNumber,
            ExtSecondLastSequenceNumber,
            ExtLastTimestamp,
            ExtSecondLastTimestamp,
            LastMarker,
            SecondLastMarker,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "extLastSequenceNumber" | "ext_last_sequence_number" => Ok(GeneratedField::ExtLastSequenceNumber),
                            "extSecondLastSequenceNumber" | "ext_second_last_sequence_number" => Ok(GeneratedField::ExtSecondLastSequenceNumber),
                            "extLastTimestamp" | "ext_last_timestamp" => Ok(GeneratedField::ExtLastTimestamp),
                            "extSecondLastTimestamp" | "ext_second_last_timestamp" => Ok(GeneratedField::ExtSecondLastTimestamp),
                            "lastMarker" | "last_marker" => Ok(GeneratedField::LastMarker),
                            "secondLastMarker" | "second_last_marker" => Ok(GeneratedField::SecondLastMarker),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RtpMungerState;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RTPMungerState")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RtpMungerState, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut ext_last_sequence_number__ = None;
                let mut ext_second_last_sequence_number__ = None;
                let mut ext_last_timestamp__ = None;
                let mut ext_second_last_timestamp__ = None;
                let mut last_marker__ = None;
                let mut second_last_marker__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::ExtLastSequenceNumber => {
                            if ext_last_sequence_number__.is_some() {
                                return Err(serde::de::Error::duplicate_field("extLastSequenceNumber"));
                            }
                            ext_last_sequence_number__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ExtSecondLastSequenceNumber => {
                            if ext_second_last_sequence_number__.is_some() {
                                return Err(serde::de::Error::duplicate_field("extSecondLastSequenceNumber"));
                            }
                            ext_second_last_sequence_number__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ExtLastTimestamp => {
                            if ext_last_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("extLastTimestamp"));
                            }
                            ext_last_timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ExtSecondLastTimestamp => {
                            if ext_second_last_timestamp__.is_some() {
                                return Err(serde::de::Error::duplicate_field("extSecondLastTimestamp"));
                            }
                            ext_second_last_timestamp__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::LastMarker => {
                            if last_marker__.is_some() {
                                return Err(serde::de::Error::duplicate_field("lastMarker"));
                            }
                            last_marker__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SecondLastMarker => {
                            if second_last_marker__.is_some() {
                                return Err(serde::de::Error::duplicate_field("secondLastMarker"));
                            }
                            second_last_marker__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RtpMungerState {
                    ext_last_sequence_number: ext_last_sequence_number__.unwrap_or_default(),
                    ext_second_last_sequence_number: ext_second_last_sequence_number__.unwrap_or_default(),
                    ext_last_timestamp: ext_last_timestamp__.unwrap_or_default(),
                    ext_second_last_timestamp: ext_second_last_timestamp__.unwrap_or_default(),
                    last_marker: last_marker__.unwrap_or_default(),
                    second_last_marker: second_last_marker__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RTPMungerState", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RtpStats {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.start_time.is_some() {
            len += 1;
        }
        if self.end_time.is_some() {
            len += 1;
        }
        if self.duration != 0. {
            len += 1;
        }
        if self.packets != 0 {
            len += 1;
        }
        if self.packet_rate != 0. {
            len += 1;
        }
        if self.bytes != 0 {
            len += 1;
        }
        if self.header_bytes != 0 {
            len += 1;
        }
        if self.bitrate != 0. {
            len += 1;
        }
        if self.packets_lost != 0 {
            len += 1;
        }
        if self.packet_loss_rate != 0. {
            len += 1;
        }
        if self.packet_loss_percentage != 0. {
            len += 1;
        }
        if self.packets_duplicate != 0 {
            len += 1;
        }
        if self.packet_duplicate_rate != 0. {
            len += 1;
        }
        if self.bytes_duplicate != 0 {
            len += 1;
        }
        if self.header_bytes_duplicate != 0 {
            len += 1;
        }
        if self.bitrate_duplicate != 0. {
            len += 1;
        }
        if self.packets_padding != 0 {
            len += 1;
        }
        if self.packet_padding_rate != 0. {
            len += 1;
        }
        if self.bytes_padding != 0 {
            len += 1;
        }
        if self.header_bytes_padding != 0 {
            len += 1;
        }
        if self.bitrate_padding != 0. {
            len += 1;
        }
        if self.packets_out_of_order != 0 {
            len += 1;
        }
        if self.frames != 0 {
            len += 1;
        }
        if self.frame_rate != 0. {
            len += 1;
        }
        if self.jitter_current != 0. {
            len += 1;
        }
        if self.jitter_max != 0. {
            len += 1;
        }
        if !self.gap_histogram.is_empty() {
            len += 1;
        }
        if self.nacks != 0 {
            len += 1;
        }
        if self.nack_acks != 0 {
            len += 1;
        }
        if self.nack_misses != 0 {
            len += 1;
        }
        if self.nack_repeated != 0 {
            len += 1;
        }
        if self.plis != 0 {
            len += 1;
        }
        if self.last_pli.is_some() {
            len += 1;
        }
        if self.firs != 0 {
            len += 1;
        }
        if self.last_fir.is_some() {
            len += 1;
        }
        if self.rtt_current != 0 {
            len += 1;
        }
        if self.rtt_max != 0 {
            len += 1;
        }
        if self.key_frames != 0 {
            len += 1;
        }
        if self.last_key_frame.is_some() {
            len += 1;
        }
        if self.layer_lock_plis != 0 {
            len += 1;
        }
        if self.last_layer_lock_pli.is_some() {
            len += 1;
        }
        if self.packet_drift.is_some() {
            len += 1;
        }
        if self.ntp_report_drift.is_some() {
            len += 1;
        }
        if self.rebased_report_drift.is_some() {
            len += 1;
        }
        if self.received_report_drift.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RTPStats", len)?;
        if let Some(v) = self.start_time.as_ref() {
            struct_ser.serialize_field("startTime", v)?;
        }
        if let Some(v) = self.end_time.as_ref() {
            struct_ser.serialize_field("endTime", v)?;
        }
        if self.duration != 0. {
            struct_ser.serialize_field("duration", &self.duration)?;
        }
        if self.packets != 0 {
            struct_ser.serialize_field("packets", &self.packets)?;
        }
        if self.packet_rate != 0. {
            struct_ser.serialize_field("packetRate", &self.packet_rate)?;
        }
        if self.bytes != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("bytes", ToString::to_string(&self.bytes).as_str())?;
        }
        if self.header_bytes != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("headerBytes", ToString::to_string(&self.header_bytes).as_str())?;
        }
        if self.bitrate != 0. {
            struct_ser.serialize_field("bitrate", &self.bitrate)?;
        }
        if self.packets_lost != 0 {
            struct_ser.serialize_field("packetsLost", &self.packets_lost)?;
        }
        if self.packet_loss_rate != 0. {
            struct_ser.serialize_field("packetLossRate", &self.packet_loss_rate)?;
        }
        if self.packet_loss_percentage != 0. {
            struct_ser.serialize_field("packetLossPercentage", &self.packet_loss_percentage)?;
        }
        if self.packets_duplicate != 0 {
            struct_ser.serialize_field("packetsDuplicate", &self.packets_duplicate)?;
        }
        if self.packet_duplicate_rate != 0. {
            struct_ser.serialize_field("packetDuplicateRate", &self.packet_duplicate_rate)?;
        }
        if self.bytes_duplicate != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("bytesDuplicate", ToString::to_string(&self.bytes_duplicate).as_str())?;
        }
        if self.header_bytes_duplicate != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("headerBytesDuplicate", ToString::to_string(&self.header_bytes_duplicate).as_str())?;
        }
        if self.bitrate_duplicate != 0. {
            struct_ser.serialize_field("bitrateDuplicate", &self.bitrate_duplicate)?;
        }
        if self.packets_padding != 0 {
            struct_ser.serialize_field("packetsPadding", &self.packets_padding)?;
        }
        if self.packet_padding_rate != 0. {
            struct_ser.serialize_field("packetPaddingRate", &self.packet_padding_rate)?;
        }
        if self.bytes_padding != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("bytesPadding", ToString::to_string(&self.bytes_padding).as_str())?;
        }
        if self.header_bytes_padding != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("headerBytesPadding", ToString::to_string(&self.header_bytes_padding).as_str())?;
        }
        if self.bitrate_padding != 0. {
            struct_ser.serialize_field("bitratePadding", &self.bitrate_padding)?;
        }
        if self.packets_out_of_order != 0 {
            struct_ser.serialize_field("packetsOutOfOrder", &self.packets_out_of_order)?;
        }
        if self.frames != 0 {
            struct_ser.serialize_field("frames", &self.frames)?;
        }
        if self.frame_rate != 0. {
            struct_ser.serialize_field("frameRate", &self.frame_rate)?;
        }
        if self.jitter_current != 0. {
            struct_ser.serialize_field("jitterCurrent", &self.jitter_current)?;
        }
        if self.jitter_max != 0. {
            struct_ser.serialize_field("jitterMax", &self.jitter_max)?;
        }
        if !self.gap_histogram.is_empty() {
            struct_ser.serialize_field("gapHistogram", &self.gap_histogram)?;
        }
        if self.nacks != 0 {
            struct_ser.serialize_field("nacks", &self.nacks)?;
        }
        if self.nack_acks != 0 {
            struct_ser.serialize_field("nackAcks", &self.nack_acks)?;
        }
        if self.nack_misses != 0 {
            struct_ser.serialize_field("nackMisses", &self.nack_misses)?;
        }
        if self.nack_repeated != 0 {
            struct_ser.serialize_field("nackRepeated", &self.nack_repeated)?;
        }
        if self.plis != 0 {
            struct_ser.serialize_field("plis", &self.plis)?;
        }
        if let Some(v) = self.last_pli.as_ref() {
            struct_ser.serialize_field("lastPli", v)?;
        }
        if self.firs != 0 {
            struct_ser.serialize_field("firs", &self.firs)?;
        }
        if let Some(v) = self.last_fir.as_ref() {
            struct_ser.serialize_field("lastFir", v)?;
        }
        if self.rtt_current != 0 {
            struct_ser.serialize_field("rttCurrent", &self.rtt_current)?;
        }
        if self.rtt_max != 0 {
            struct_ser.serialize_field("rttMax", &self.rtt_max)?;
        }
        if self.key_frames != 0 {
            struct_ser.serialize_field("keyFrames", &self.key_frames)?;
        }
        if let Some(v) = self.last_key_frame.as_ref() {
            struct_ser.serialize_field("lastKeyFrame", v)?;
        }
        if self.layer_lock_plis != 0 {
            struct_ser.serialize_field("layerLockPlis", &self.layer_lock_plis)?;
        }
        if let Some(v) = self.last_layer_lock_pli.as_ref() {
            struct_ser.serialize_field("lastLayerLockPli", v)?;
        }
        if let Some(v) = self.packet_drift.as_ref() {
            struct_ser.serialize_field("packetDrift", v)?;
        }
        if let Some(v) = self.ntp_report_drift.as_ref() {
            struct_ser.serialize_field("ntpReportDrift", v)?;
        }
        if let Some(v) = self.rebased_report_drift.as_ref() {
            struct_ser.serialize_field("rebasedReportDrift", v)?;
        }
        if let Some(v) = self.received_report_drift.as_ref() {
            struct_ser.serialize_field("receivedReportDrift", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RtpStats {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "start_time",
            "startTime",
            "end_time",
            "endTime",
            "duration",
            "packets",
            "packet_rate",
            "packetRate",
            "bytes",
            "header_bytes",
            "headerBytes",
            "bitrate",
            "packets_lost",
            "packetsLost",
            "packet_loss_rate",
            "packetLossRate",
            "packet_loss_percentage",
            "packetLossPercentage",
            "packets_duplicate",
            "packetsDuplicate",
            "packet_duplicate_rate",
            "packetDuplicateRate",
            "bytes_duplicate",
            "bytesDuplicate",
            "header_bytes_duplicate",
            "headerBytesDuplicate",
            "bitrate_duplicate",
            "bitrateDuplicate",
            "packets_padding",
            "packetsPadding",
            "packet_padding_rate",
            "packetPaddingRate",
            "bytes_padding",
            "bytesPadding",
            "header_bytes_padding",
            "headerBytesPadding",
            "bitrate_padding",
            "bitratePadding",
            "packets_out_of_order",
            "packetsOutOfOrder",
            "frames",
            "frame_rate",
            "frameRate",
            "jitter_current",
            "jitterCurrent",
            "jitter_max",
            "jitterMax",
            "gap_histogram",
            "gapHistogram",
            "nacks",
            "nack_acks",
            "nackAcks",
            "nack_misses",
            "nackMisses",
            "nack_repeated",
            "nackRepeated",
            "plis",
            "last_pli",
            "lastPli",
            "firs",
            "last_fir",
            "lastFir",
            "rtt_current",
            "rttCurrent",
            "rtt_max",
            "rttMax",
            "key_frames",
            "keyFrames",
            "last_key_frame",
            "lastKeyFrame",
            "layer_lock_plis",
            "layerLockPlis",
            "last_layer_lock_pli",
            "lastLayerLockPli",
            "packet_drift",
            "packetDrift",
            "ntp_report_drift",
            "ntpReportDrift",
            "rebased_report_drift",
            "rebasedReportDrift",
            "received_report_drift",
            "receivedReportDrift",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            StartTime,
            EndTime,
            Duration,
            Packets,
            PacketRate,
            Bytes,
            HeaderBytes,
            Bitrate,
            PacketsLost,
            PacketLossRate,
            PacketLossPercentage,
            PacketsDuplicate,
            PacketDuplicateRate,
            BytesDuplicate,
            HeaderBytesDuplicate,
            BitrateDuplicate,
            PacketsPadding,
            PacketPaddingRate,
            BytesPadding,
            HeaderBytesPadding,
            BitratePadding,
            PacketsOutOfOrder,
            Frames,
            FrameRate,
            JitterCurrent,
            JitterMax,
            GapHistogram,
            Nacks,
            NackAcks,
            NackMisses,
            NackRepeated,
            Plis,
            LastPli,
            Firs,
            LastFir,
            RttCurrent,
            RttMax,
            KeyFrames,
            LastKeyFrame,
            LayerLockPlis,
            LastLayerLockPli,
            PacketDrift,
            NtpReportDrift,
            RebasedReportDrift,
            ReceivedReportDrift,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "startTime" | "start_time" => Ok(GeneratedField::StartTime),
                            "endTime" | "end_time" => Ok(GeneratedField::EndTime),
                            "duration" => Ok(GeneratedField::Duration),
                            "packets" => Ok(GeneratedField::Packets),
                            "packetRate" | "packet_rate" => Ok(GeneratedField::PacketRate),
                            "bytes" => Ok(GeneratedField::Bytes),
                            "headerBytes" | "header_bytes" => Ok(GeneratedField::HeaderBytes),
                            "bitrate" => Ok(GeneratedField::Bitrate),
                            "packetsLost" | "packets_lost" => Ok(GeneratedField::PacketsLost),
                            "packetLossRate" | "packet_loss_rate" => Ok(GeneratedField::PacketLossRate),
                            "packetLossPercentage" | "packet_loss_percentage" => Ok(GeneratedField::PacketLossPercentage),
                            "packetsDuplicate" | "packets_duplicate" => Ok(GeneratedField::PacketsDuplicate),
                            "packetDuplicateRate" | "packet_duplicate_rate" => Ok(GeneratedField::PacketDuplicateRate),
                            "bytesDuplicate" | "bytes_duplicate" => Ok(GeneratedField::BytesDuplicate),
                            "headerBytesDuplicate" | "header_bytes_duplicate" => Ok(GeneratedField::HeaderBytesDuplicate),
                            "bitrateDuplicate" | "bitrate_duplicate" => Ok(GeneratedField::BitrateDuplicate),
                            "packetsPadding" | "packets_padding" => Ok(GeneratedField::PacketsPadding),
                            "packetPaddingRate" | "packet_padding_rate" => Ok(GeneratedField::PacketPaddingRate),
                            "bytesPadding" | "bytes_padding" => Ok(GeneratedField::BytesPadding),
                            "headerBytesPadding" | "header_bytes_padding" => Ok(GeneratedField::HeaderBytesPadding),
                            "bitratePadding" | "bitrate_padding" => Ok(GeneratedField::BitratePadding),
                            "packetsOutOfOrder" | "packets_out_of_order" => Ok(GeneratedField::PacketsOutOfOrder),
                            "frames" => Ok(GeneratedField::Frames),
                            "frameRate" | "frame_rate" => Ok(GeneratedField::FrameRate),
                            "jitterCurrent" | "jitter_current" => Ok(GeneratedField::JitterCurrent),
                            "jitterMax" | "jitter_max" => Ok(GeneratedField::JitterMax),
                            "gapHistogram" | "gap_histogram" => Ok(GeneratedField::GapHistogram),
                            "nacks" => Ok(GeneratedField::Nacks),
                            "nackAcks" | "nack_acks" => Ok(GeneratedField::NackAcks),
                            "nackMisses" | "nack_misses" => Ok(GeneratedField::NackMisses),
                            "nackRepeated" | "nack_repeated" => Ok(GeneratedField::NackRepeated),
                            "plis" => Ok(GeneratedField::Plis),
                            "lastPli" | "last_pli" => Ok(GeneratedField::LastPli),
                            "firs" => Ok(GeneratedField::Firs),
                            "lastFir" | "last_fir" => Ok(GeneratedField::LastFir),
                            "rttCurrent" | "rtt_current" => Ok(GeneratedField::RttCurrent),
                            "rttMax" | "rtt_max" => Ok(GeneratedField::RttMax),
                            "keyFrames" | "key_frames" => Ok(GeneratedField::KeyFrames),
                            "lastKeyFrame" | "last_key_frame" => Ok(GeneratedField::LastKeyFrame),
                            "layerLockPlis" | "layer_lock_plis" => Ok(GeneratedField::LayerLockPlis),
                            "lastLayerLockPli" | "last_layer_lock_pli" => Ok(GeneratedField::LastLayerLockPli),
                            "packetDrift" | "packet_drift" => Ok(GeneratedField::PacketDrift),
                            "ntpReportDrift" | "ntp_report_drift" => Ok(GeneratedField::NtpReportDrift),
                            "rebasedReportDrift" | "rebased_report_drift" => Ok(GeneratedField::RebasedReportDrift),
                            "receivedReportDrift" | "received_report_drift" => Ok(GeneratedField::ReceivedReportDrift),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RtpStats;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RTPStats")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RtpStats, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut start_time__ = None;
                let mut end_time__ = None;
                let mut duration__ = None;
                let mut packets__ = None;
                let mut packet_rate__ = None;
                let mut bytes__ = None;
                let mut header_bytes__ = None;
                let mut bitrate__ = None;
                let mut packets_lost__ = None;
                let mut packet_loss_rate__ = None;
                let mut packet_loss_percentage__ = None;
                let mut packets_duplicate__ = None;
                let mut packet_duplicate_rate__ = None;
                let mut bytes_duplicate__ = None;
                let mut header_bytes_duplicate__ = None;
                let mut bitrate_duplicate__ = None;
                let mut packets_padding__ = None;
                let mut packet_padding_rate__ = None;
                let mut bytes_padding__ = None;
                let mut header_bytes_padding__ = None;
                let mut bitrate_padding__ = None;
                let mut packets_out_of_order__ = None;
                let mut frames__ = None;
                let mut frame_rate__ = None;
                let mut jitter_current__ = None;
                let mut jitter_max__ = None;
                let mut gap_histogram__ = None;
                let mut nacks__ = None;
                let mut nack_acks__ = None;
                let mut nack_misses__ = None;
                let mut nack_repeated__ = None;
                let mut plis__ = None;
                let mut last_pli__ = None;
                let mut firs__ = None;
                let mut last_fir__ = None;
                let mut rtt_current__ = None;
                let mut rtt_max__ = None;
                let mut key_frames__ = None;
                let mut last_key_frame__ = None;
                let mut layer_lock_plis__ = None;
                let mut last_layer_lock_pli__ = None;
                let mut packet_drift__ = None;
                let mut ntp_report_drift__ = None;
                let mut rebased_report_drift__ = None;
                let mut received_report_drift__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::StartTime => {
                            if start_time__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startTime"));
                            }
                            start_time__ = map_.next_value()?;
                        }
                        GeneratedField::EndTime => {
                            if end_time__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endTime"));
                            }
                            end_time__ = map_.next_value()?;
                        }
                        GeneratedField::Duration => {
                            if duration__.is_some() {
                                return Err(serde::de::Error::duplicate_field("duration"));
                            }
                            duration__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Packets => {
                            if packets__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packets"));
                            }
                            packets__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketRate => {
                            if packet_rate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetRate"));
                            }
                            packet_rate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Bytes => {
                            if bytes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bytes"));
                            }
                            bytes__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::HeaderBytes => {
                            if header_bytes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("headerBytes"));
                            }
                            header_bytes__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Bitrate => {
                            if bitrate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bitrate"));
                            }
                            bitrate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketsLost => {
                            if packets_lost__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetsLost"));
                            }
                            packets_lost__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketLossRate => {
                            if packet_loss_rate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetLossRate"));
                            }
                            packet_loss_rate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketLossPercentage => {
                            if packet_loss_percentage__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetLossPercentage"));
                            }
                            packet_loss_percentage__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketsDuplicate => {
                            if packets_duplicate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetsDuplicate"));
                            }
                            packets_duplicate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketDuplicateRate => {
                            if packet_duplicate_rate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetDuplicateRate"));
                            }
                            packet_duplicate_rate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::BytesDuplicate => {
                            if bytes_duplicate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bytesDuplicate"));
                            }
                            bytes_duplicate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::HeaderBytesDuplicate => {
                            if header_bytes_duplicate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("headerBytesDuplicate"));
                            }
                            header_bytes_duplicate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::BitrateDuplicate => {
                            if bitrate_duplicate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bitrateDuplicate"));
                            }
                            bitrate_duplicate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketsPadding => {
                            if packets_padding__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetsPadding"));
                            }
                            packets_padding__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketPaddingRate => {
                            if packet_padding_rate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetPaddingRate"));
                            }
                            packet_padding_rate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::BytesPadding => {
                            if bytes_padding__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bytesPadding"));
                            }
                            bytes_padding__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::HeaderBytesPadding => {
                            if header_bytes_padding__.is_some() {
                                return Err(serde::de::Error::duplicate_field("headerBytesPadding"));
                            }
                            header_bytes_padding__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::BitratePadding => {
                            if bitrate_padding__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bitratePadding"));
                            }
                            bitrate_padding__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::PacketsOutOfOrder => {
                            if packets_out_of_order__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetsOutOfOrder"));
                            }
                            packets_out_of_order__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Frames => {
                            if frames__.is_some() {
                                return Err(serde::de::Error::duplicate_field("frames"));
                            }
                            frames__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::FrameRate => {
                            if frame_rate__.is_some() {
                                return Err(serde::de::Error::duplicate_field("frameRate"));
                            }
                            frame_rate__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::JitterCurrent => {
                            if jitter_current__.is_some() {
                                return Err(serde::de::Error::duplicate_field("jitterCurrent"));
                            }
                            jitter_current__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::JitterMax => {
                            if jitter_max__.is_some() {
                                return Err(serde::de::Error::duplicate_field("jitterMax"));
                            }
                            jitter_max__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::GapHistogram => {
                            if gap_histogram__.is_some() {
                                return Err(serde::de::Error::duplicate_field("gapHistogram"));
                            }
                            gap_histogram__ = Some(
                                map_.next_value::<std::collections::HashMap<::pbjson::private::NumberDeserialize<i32>, ::pbjson::private::NumberDeserialize<u32>>>()?
                                    .into_iter().map(|(k,v)| (k.0, v.0)).collect()
                            );
                        }
                        GeneratedField::Nacks => {
                            if nacks__.is_some() {
                                return Err(serde::de::Error::duplicate_field("nacks"));
                            }
                            nacks__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::NackAcks => {
                            if nack_acks__.is_some() {
                                return Err(serde::de::Error::duplicate_field("nackAcks"));
                            }
                            nack_acks__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::NackMisses => {
                            if nack_misses__.is_some() {
                                return Err(serde::de::Error::duplicate_field("nackMisses"));
                            }
                            nack_misses__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::NackRepeated => {
                            if nack_repeated__.is_some() {
                                return Err(serde::de::Error::duplicate_field("nackRepeated"));
                            }
                            nack_repeated__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Plis => {
                            if plis__.is_some() {
                                return Err(serde::de::Error::duplicate_field("plis"));
                            }
                            plis__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::LastPli => {
                            if last_pli__.is_some() {
                                return Err(serde::de::Error::duplicate_field("lastPli"));
                            }
                            last_pli__ = map_.next_value()?;
                        }
                        GeneratedField::Firs => {
                            if firs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("firs"));
                            }
                            firs__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::LastFir => {
                            if last_fir__.is_some() {
                                return Err(serde::de::Error::duplicate_field("lastFir"));
                            }
                            last_fir__ = map_.next_value()?;
                        }
                        GeneratedField::RttCurrent => {
                            if rtt_current__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rttCurrent"));
                            }
                            rtt_current__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::RttMax => {
                            if rtt_max__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rttMax"));
                            }
                            rtt_max__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::KeyFrames => {
                            if key_frames__.is_some() {
                                return Err(serde::de::Error::duplicate_field("keyFrames"));
                            }
                            key_frames__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::LastKeyFrame => {
                            if last_key_frame__.is_some() {
                                return Err(serde::de::Error::duplicate_field("lastKeyFrame"));
                            }
                            last_key_frame__ = map_.next_value()?;
                        }
                        GeneratedField::LayerLockPlis => {
                            if layer_lock_plis__.is_some() {
                                return Err(serde::de::Error::duplicate_field("layerLockPlis"));
                            }
                            layer_lock_plis__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::LastLayerLockPli => {
                            if last_layer_lock_pli__.is_some() {
                                return Err(serde::de::Error::duplicate_field("lastLayerLockPli"));
                            }
                            last_layer_lock_pli__ = map_.next_value()?;
                        }
                        GeneratedField::PacketDrift => {
                            if packet_drift__.is_some() {
                                return Err(serde::de::Error::duplicate_field("packetDrift"));
                            }
                            packet_drift__ = map_.next_value()?;
                        }
                        GeneratedField::NtpReportDrift => {
                            if ntp_report_drift__.is_some() {
                                return Err(serde::de::Error::duplicate_field("ntpReportDrift"));
                            }
                            ntp_report_drift__ = map_.next_value()?;
                        }
                        GeneratedField::RebasedReportDrift => {
                            if rebased_report_drift__.is_some() {
                                return Err(serde::de::Error::duplicate_field("rebasedReportDrift"));
                            }
                            rebased_report_drift__ = map_.next_value()?;
                        }
                        GeneratedField::ReceivedReportDrift => {
                            if received_report_drift__.is_some() {
                                return Err(serde::de::Error::duplicate_field("receivedReportDrift"));
                            }
                            received_report_drift__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RtpStats {
                    start_time: start_time__,
                    end_time: end_time__,
                    duration: duration__.unwrap_or_default(),
                    packets: packets__.unwrap_or_default(),
                    packet_rate: packet_rate__.unwrap_or_default(),
                    bytes: bytes__.unwrap_or_default(),
                    header_bytes: header_bytes__.unwrap_or_default(),
                    bitrate: bitrate__.unwrap_or_default(),
                    packets_lost: packets_lost__.unwrap_or_default(),
                    packet_loss_rate: packet_loss_rate__.unwrap_or_default(),
                    packet_loss_percentage: packet_loss_percentage__.unwrap_or_default(),
                    packets_duplicate: packets_duplicate__.unwrap_or_default(),
                    packet_duplicate_rate: packet_duplicate_rate__.unwrap_or_default(),
                    bytes_duplicate: bytes_duplicate__.unwrap_or_default(),
                    header_bytes_duplicate: header_bytes_duplicate__.unwrap_or_default(),
                    bitrate_duplicate: bitrate_duplicate__.unwrap_or_default(),
                    packets_padding: packets_padding__.unwrap_or_default(),
                    packet_padding_rate: packet_padding_rate__.unwrap_or_default(),
                    bytes_padding: bytes_padding__.unwrap_or_default(),
                    header_bytes_padding: header_bytes_padding__.unwrap_or_default(),
                    bitrate_padding: bitrate_padding__.unwrap_or_default(),
                    packets_out_of_order: packets_out_of_order__.unwrap_or_default(),
                    frames: frames__.unwrap_or_default(),
                    frame_rate: frame_rate__.unwrap_or_default(),
                    jitter_current: jitter_current__.unwrap_or_default(),
                    jitter_max: jitter_max__.unwrap_or_default(),
                    gap_histogram: gap_histogram__.unwrap_or_default(),
                    nacks: nacks__.unwrap_or_default(),
                    nack_acks: nack_acks__.unwrap_or_default(),
                    nack_misses: nack_misses__.unwrap_or_default(),
                    nack_repeated: nack_repeated__.unwrap_or_default(),
                    plis: plis__.unwrap_or_default(),
                    last_pli: last_pli__,
                    firs: firs__.unwrap_or_default(),
                    last_fir: last_fir__,
                    rtt_current: rtt_current__.unwrap_or_default(),
                    rtt_max: rtt_max__.unwrap_or_default(),
                    key_frames: key_frames__.unwrap_or_default(),
                    last_key_frame: last_key_frame__,
                    layer_lock_plis: layer_lock_plis__.unwrap_or_default(),
                    last_layer_lock_pli: last_layer_lock_pli__,
                    packet_drift: packet_drift__,
                    ntp_report_drift: ntp_report_drift__,
                    rebased_report_drift: rebased_report_drift__,
                    received_report_drift: received_report_drift__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.RTPStats", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for ReconnectReason {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::RrUnknown => "RR_UNKNOWN",
            Self::RrSignalDisconnected => "RR_SIGNAL_DISCONNECTED",
            Self::RrPublisherFailed => "RR_PUBLISHER_FAILED",
            Self::RrSubscriberFailed => "RR_SUBSCRIBER_FAILED",
            Self::RrSwitchCandidate => "RR_SWITCH_CANDIDATE",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for ReconnectReason {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "RR_UNKNOWN",
            "RR_SIGNAL_DISCONNECTED",
            "RR_PUBLISHER_FAILED",
            "RR_SUBSCRIBER_FAILED",
            "RR_SWITCH_CANDIDATE",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ReconnectReason;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "RR_UNKNOWN" => Ok(ReconnectReason::RrUnknown),
                    "RR_SIGNAL_DISCONNECTED" => Ok(ReconnectReason::RrSignalDisconnected),
                    "RR_PUBLISHER_FAILED" => Ok(ReconnectReason::RrPublisherFailed),
                    "RR_SUBSCRIBER_FAILED" => Ok(ReconnectReason::RrSubscriberFailed),
                    "RR_SWITCH_CANDIDATE" => Ok(ReconnectReason::RrSwitchCandidate),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for ReconnectResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.ice_servers.is_empty() {
            len += 1;
        }
        if self.client_configuration.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.ReconnectResponse", len)?;
        if !self.ice_servers.is_empty() {
            struct_ser.serialize_field("iceServers", &self.ice_servers)?;
        }
        if let Some(v) = self.client_configuration.as_ref() {
            struct_ser.serialize_field("clientConfiguration", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for ReconnectResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "ice_servers",
            "iceServers",
            "client_configuration",
            "clientConfiguration",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            IceServers,
            ClientConfiguration,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "iceServers" | "ice_servers" => Ok(GeneratedField::IceServers),
                            "clientConfiguration" | "client_configuration" => Ok(GeneratedField::ClientConfiguration),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = ReconnectResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.ReconnectResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<ReconnectResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut ice_servers__ = None;
                let mut client_configuration__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::IceServers => {
                            if ice_servers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("iceServers"));
                            }
                            ice_servers__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ClientConfiguration => {
                            if client_configuration__.is_some() {
                                return Err(serde::de::Error::duplicate_field("clientConfiguration"));
                            }
                            client_configuration__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(ReconnectResponse {
                    ice_servers: ice_servers__.unwrap_or_default(),
                    client_configuration: client_configuration__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.ReconnectResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RegionInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.region.is_empty() {
            len += 1;
        }
        if !self.url.is_empty() {
            len += 1;
        }
        if self.distance != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RegionInfo", len)?;
        if !self.region.is_empty() {
            struct_ser.serialize_field("region", &self.region)?;
        }
        if !self.url.is_empty() {
            struct_ser.serialize_field("url", &self.url)?;
        }
        if self.distance != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("distance", ToString::to_string(&self.distance).as_str())?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RegionInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "region",
            "url",
            "distance",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Region,
            Url,
            Distance,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "region" => Ok(GeneratedField::Region),
                            "url" => Ok(GeneratedField::Url),
                            "distance" => Ok(GeneratedField::Distance),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RegionInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RegionInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RegionInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut region__ = None;
                let mut url__ = None;
                let mut distance__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Region => {
                            if region__.is_some() {
                                return Err(serde::de::Error::duplicate_field("region"));
                            }
                            region__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Url => {
                            if url__.is_some() {
                                return Err(serde::de::Error::duplicate_field("url"));
                            }
                            url__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Distance => {
                            if distance__.is_some() {
                                return Err(serde::de::Error::duplicate_field("distance"));
                            }
                            distance__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RegionInfo {
                    region: region__.unwrap_or_default(),
                    url: url__.unwrap_or_default(),
                    distance: distance__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RegionInfo", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RegionSettings {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.regions.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RegionSettings", len)?;
        if !self.regions.is_empty() {
            struct_ser.serialize_field("regions", &self.regions)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RegionSettings {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "regions",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Regions,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "regions" => Ok(GeneratedField::Regions),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RegionSettings;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RegionSettings")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RegionSettings, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut regions__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Regions => {
                            if regions__.is_some() {
                                return Err(serde::de::Error::duplicate_field("regions"));
                            }
                            regions__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RegionSettings {
                    regions: regions__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RegionSettings", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RegisterWorkerRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.r#type != 0 {
            len += 1;
        }
        if !self.agent_name.is_empty() {
            len += 1;
        }
        if !self.version.is_empty() {
            len += 1;
        }
        if self.ping_interval != 0 {
            len += 1;
        }
        if self.namespace.is_some() {
            len += 1;
        }
        if self.allowed_permissions.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RegisterWorkerRequest", len)?;
        if self.r#type != 0 {
            let v = JobType::try_from(self.r#type)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.r#type)))?;
            struct_ser.serialize_field("type", &v)?;
        }
        if !self.agent_name.is_empty() {
            struct_ser.serialize_field("agentName", &self.agent_name)?;
        }
        if !self.version.is_empty() {
            struct_ser.serialize_field("version", &self.version)?;
        }
        if self.ping_interval != 0 {
            struct_ser.serialize_field("pingInterval", &self.ping_interval)?;
        }
        if let Some(v) = self.namespace.as_ref() {
            struct_ser.serialize_field("namespace", v)?;
        }
        if let Some(v) = self.allowed_permissions.as_ref() {
            struct_ser.serialize_field("allowedPermissions", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RegisterWorkerRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "type",
            "agent_name",
            "agentName",
            "version",
            "ping_interval",
            "pingInterval",
            "namespace",
            "allowed_permissions",
            "allowedPermissions",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Type,
            AgentName,
            Version,
            PingInterval,
            Namespace,
            AllowedPermissions,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "type" => Ok(GeneratedField::Type),
                            "agentName" | "agent_name" => Ok(GeneratedField::AgentName),
                            "version" => Ok(GeneratedField::Version),
                            "pingInterval" | "ping_interval" => Ok(GeneratedField::PingInterval),
                            "namespace" => Ok(GeneratedField::Namespace),
                            "allowedPermissions" | "allowed_permissions" => Ok(GeneratedField::AllowedPermissions),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RegisterWorkerRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RegisterWorkerRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RegisterWorkerRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut r#type__ = None;
                let mut agent_name__ = None;
                let mut version__ = None;
                let mut ping_interval__ = None;
                let mut namespace__ = None;
                let mut allowed_permissions__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Type => {
                            if r#type__.is_some() {
                                return Err(serde::de::Error::duplicate_field("type"));
                            }
                            r#type__ = Some(map_.next_value::<JobType>()? as i32);
                        }
                        GeneratedField::AgentName => {
                            if agent_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agentName"));
                            }
                            agent_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Version => {
                            if version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("version"));
                            }
                            version__ = Some(map_.next_value()?);
                        }
                        GeneratedField::PingInterval => {
                            if ping_interval__.is_some() {
                                return Err(serde::de::Error::duplicate_field("pingInterval"));
                            }
                            ping_interval__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Namespace => {
                            if namespace__.is_some() {
                                return Err(serde::de::Error::duplicate_field("namespace"));
                            }
                            namespace__ = map_.next_value()?;
                        }
                        GeneratedField::AllowedPermissions => {
                            if allowed_permissions__.is_some() {
                                return Err(serde::de::Error::duplicate_field("allowedPermissions"));
                            }
                            allowed_permissions__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RegisterWorkerRequest {
                    r#type: r#type__.unwrap_or_default(),
                    agent_name: agent_name__.unwrap_or_default(),
                    version: version__.unwrap_or_default(),
                    ping_interval: ping_interval__.unwrap_or_default(),
                    namespace: namespace__,
                    allowed_permissions: allowed_permissions__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.RegisterWorkerRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RegisterWorkerResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.worker_id.is_empty() {
            len += 1;
        }
        if self.server_info.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RegisterWorkerResponse", len)?;
        if !self.worker_id.is_empty() {
            struct_ser.serialize_field("workerId", &self.worker_id)?;
        }
        if let Some(v) = self.server_info.as_ref() {
            struct_ser.serialize_field("serverInfo", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RegisterWorkerResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "worker_id",
            "workerId",
            "server_info",
            "serverInfo",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            WorkerId,
            ServerInfo,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "workerId" | "worker_id" => Ok(GeneratedField::WorkerId),
                            "serverInfo" | "server_info" => Ok(GeneratedField::ServerInfo),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RegisterWorkerResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RegisterWorkerResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RegisterWorkerResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut worker_id__ = None;
                let mut server_info__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::WorkerId => {
                            if worker_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("workerId"));
                            }
                            worker_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ServerInfo => {
                            if server_info__.is_some() {
                                return Err(serde::de::Error::duplicate_field("serverInfo"));
                            }
                            server_info__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RegisterWorkerResponse {
                    worker_id: worker_id__.unwrap_or_default(),
                    server_info: server_info__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.RegisterWorkerResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RemoveParticipantResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let len = 0;
        let struct_ser = serializer.serialize_struct("livekit.RemoveParticipantResponse", len)?;
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RemoveParticipantResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                            Ok(GeneratedField::__SkipField__)
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RemoveParticipantResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RemoveParticipantResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RemoveParticipantResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                while map_.next_key::<GeneratedField>()?.is_some() {
                    let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                }
                Ok(RemoveParticipantResponse {
                })
            }
        }
        deserializer.deserialize_struct("livekit.RemoveParticipantResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RequestResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.request_id != 0 {
            len += 1;
        }
        if self.reason != 0 {
            len += 1;
        }
        if !self.message.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RequestResponse", len)?;
        if self.request_id != 0 {
            struct_ser.serialize_field("requestId", &self.request_id)?;
        }
        if self.reason != 0 {
            let v = request_response::Reason::try_from(self.reason)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.reason)))?;
            struct_ser.serialize_field("reason", &v)?;
        }
        if !self.message.is_empty() {
            struct_ser.serialize_field("message", &self.message)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RequestResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "request_id",
            "requestId",
            "reason",
            "message",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            RequestId,
            Reason,
            Message,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "requestId" | "request_id" => Ok(GeneratedField::RequestId),
                            "reason" => Ok(GeneratedField::Reason),
                            "message" => Ok(GeneratedField::Message),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RequestResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RequestResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RequestResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut request_id__ = None;
                let mut reason__ = None;
                let mut message__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::RequestId => {
                            if request_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("requestId"));
                            }
                            request_id__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Reason => {
                            if reason__.is_some() {
                                return Err(serde::de::Error::duplicate_field("reason"));
                            }
                            reason__ = Some(map_.next_value::<request_response::Reason>()? as i32);
                        }
                        GeneratedField::Message => {
                            if message__.is_some() {
                                return Err(serde::de::Error::duplicate_field("message"));
                            }
                            message__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RequestResponse {
                    request_id: request_id__.unwrap_or_default(),
                    reason: reason__.unwrap_or_default(),
                    message: message__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RequestResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for request_response::Reason {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::Ok => "OK",
            Self::NotFound => "NOT_FOUND",
            Self::NotAllowed => "NOT_ALLOWED",
            Self::LimitExceeded => "LIMIT_EXCEEDED",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for request_response::Reason {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "OK",
            "NOT_FOUND",
            "NOT_ALLOWED",
            "LIMIT_EXCEEDED",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = request_response::Reason;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "OK" => Ok(request_response::Reason::Ok),
                    "NOT_FOUND" => Ok(request_response::Reason::NotFound),
                    "NOT_ALLOWED" => Ok(request_response::Reason::NotAllowed),
                    "LIMIT_EXCEEDED" => Ok(request_response::Reason::LimitExceeded),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for Room {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.sid.is_empty() {
            len += 1;
        }
        if !self.name.is_empty() {
            len += 1;
        }
        if self.empty_timeout != 0 {
            len += 1;
        }
        if self.departure_timeout != 0 {
            len += 1;
        }
        if self.max_participants != 0 {
            len += 1;
        }
        if self.creation_time != 0 {
            len += 1;
        }
        if self.creation_time_ms != 0 {
            len += 1;
        }
        if !self.turn_password.is_empty() {
            len += 1;
        }
        if !self.enabled_codecs.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        if self.num_participants != 0 {
            len += 1;
        }
        if self.num_publishers != 0 {
            len += 1;
        }
        if self.active_recording {
            len += 1;
        }
        if self.version.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.Room", len)?;
        if !self.sid.is_empty() {
            struct_ser.serialize_field("sid", &self.sid)?;
        }
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if self.empty_timeout != 0 {
            struct_ser.serialize_field("emptyTimeout", &self.empty_timeout)?;
        }
        if self.departure_timeout != 0 {
            struct_ser.serialize_field("departureTimeout", &self.departure_timeout)?;
        }
        if self.max_participants != 0 {
            struct_ser.serialize_field("maxParticipants", &self.max_participants)?;
        }
        if self.creation_time != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("creationTime", ToString::to_string(&self.creation_time).as_str())?;
        }
        if self.creation_time_ms != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("creationTimeMs", ToString::to_string(&self.creation_time_ms).as_str())?;
        }
        if !self.turn_password.is_empty() {
            struct_ser.serialize_field("turnPassword", &self.turn_password)?;
        }
        if !self.enabled_codecs.is_empty() {
            struct_ser.serialize_field("enabledCodecs", &self.enabled_codecs)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        if self.num_participants != 0 {
            struct_ser.serialize_field("numParticipants", &self.num_participants)?;
        }
        if self.num_publishers != 0 {
            struct_ser.serialize_field("numPublishers", &self.num_publishers)?;
        }
        if self.active_recording {
            struct_ser.serialize_field("activeRecording", &self.active_recording)?;
        }
        if let Some(v) = self.version.as_ref() {
            struct_ser.serialize_field("version", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for Room {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "sid",
            "name",
            "empty_timeout",
            "emptyTimeout",
            "departure_timeout",
            "departureTimeout",
            "max_participants",
            "maxParticipants",
            "creation_time",
            "creationTime",
            "creation_time_ms",
            "creationTimeMs",
            "turn_password",
            "turnPassword",
            "enabled_codecs",
            "enabledCodecs",
            "metadata",
            "num_participants",
            "numParticipants",
            "num_publishers",
            "numPublishers",
            "active_recording",
            "activeRecording",
            "version",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Sid,
            Name,
            EmptyTimeout,
            DepartureTimeout,
            MaxParticipants,
            CreationTime,
            CreationTimeMs,
            TurnPassword,
            EnabledCodecs,
            Metadata,
            NumParticipants,
            NumPublishers,
            ActiveRecording,
            Version,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "sid" => Ok(GeneratedField::Sid),
                            "name" => Ok(GeneratedField::Name),
                            "emptyTimeout" | "empty_timeout" => Ok(GeneratedField::EmptyTimeout),
                            "departureTimeout" | "departure_timeout" => Ok(GeneratedField::DepartureTimeout),
                            "maxParticipants" | "max_participants" => Ok(GeneratedField::MaxParticipants),
                            "creationTime" | "creation_time" => Ok(GeneratedField::CreationTime),
                            "creationTimeMs" | "creation_time_ms" => Ok(GeneratedField::CreationTimeMs),
                            "turnPassword" | "turn_password" => Ok(GeneratedField::TurnPassword),
                            "enabledCodecs" | "enabled_codecs" => Ok(GeneratedField::EnabledCodecs),
                            "metadata" => Ok(GeneratedField::Metadata),
                            "numParticipants" | "num_participants" => Ok(GeneratedField::NumParticipants),
                            "numPublishers" | "num_publishers" => Ok(GeneratedField::NumPublishers),
                            "activeRecording" | "active_recording" => Ok(GeneratedField::ActiveRecording),
                            "version" => Ok(GeneratedField::Version),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = Room;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.Room")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<Room, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut sid__ = None;
                let mut name__ = None;
                let mut empty_timeout__ = None;
                let mut departure_timeout__ = None;
                let mut max_participants__ = None;
                let mut creation_time__ = None;
                let mut creation_time_ms__ = None;
                let mut turn_password__ = None;
                let mut enabled_codecs__ = None;
                let mut metadata__ = None;
                let mut num_participants__ = None;
                let mut num_publishers__ = None;
                let mut active_recording__ = None;
                let mut version__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Sid => {
                            if sid__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sid"));
                            }
                            sid__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::EmptyTimeout => {
                            if empty_timeout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("emptyTimeout"));
                            }
                            empty_timeout__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DepartureTimeout => {
                            if departure_timeout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("departureTimeout"));
                            }
                            departure_timeout__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::MaxParticipants => {
                            if max_participants__.is_some() {
                                return Err(serde::de::Error::duplicate_field("maxParticipants"));
                            }
                            max_participants__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::CreationTime => {
                            if creation_time__.is_some() {
                                return Err(serde::de::Error::duplicate_field("creationTime"));
                            }
                            creation_time__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::CreationTimeMs => {
                            if creation_time_ms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("creationTimeMs"));
                            }
                            creation_time_ms__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::TurnPassword => {
                            if turn_password__.is_some() {
                                return Err(serde::de::Error::duplicate_field("turnPassword"));
                            }
                            turn_password__ = Some(map_.next_value()?);
                        }
                        GeneratedField::EnabledCodecs => {
                            if enabled_codecs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("enabledCodecs"));
                            }
                            enabled_codecs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::NumParticipants => {
                            if num_participants__.is_some() {
                                return Err(serde::de::Error::duplicate_field("numParticipants"));
                            }
                            num_participants__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::NumPublishers => {
                            if num_publishers__.is_some() {
                                return Err(serde::de::Error::duplicate_field("numPublishers"));
                            }
                            num_publishers__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::ActiveRecording => {
                            if active_recording__.is_some() {
                                return Err(serde::de::Error::duplicate_field("activeRecording"));
                            }
                            active_recording__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Version => {
                            if version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("version"));
                            }
                            version__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(Room {
                    sid: sid__.unwrap_or_default(),
                    name: name__.unwrap_or_default(),
                    empty_timeout: empty_timeout__.unwrap_or_default(),
                    departure_timeout: departure_timeout__.unwrap_or_default(),
                    max_participants: max_participants__.unwrap_or_default(),
                    creation_time: creation_time__.unwrap_or_default(),
                    creation_time_ms: creation_time_ms__.unwrap_or_default(),
                    turn_password: turn_password__.unwrap_or_default(),
                    enabled_codecs: enabled_codecs__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                    num_participants: num_participants__.unwrap_or_default(),
                    num_publishers: num_publishers__.unwrap_or_default(),
                    active_recording: active_recording__.unwrap_or_default(),
                    version: version__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.Room", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RoomAgent {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.dispatches.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RoomAgent", len)?;
        if !self.dispatches.is_empty() {
            struct_ser.serialize_field("dispatches", &self.dispatches)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RoomAgent {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "dispatches",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Dispatches,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "dispatches" => Ok(GeneratedField::Dispatches),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RoomAgent;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RoomAgent")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RoomAgent, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut dispatches__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Dispatches => {
                            if dispatches__.is_some() {
                                return Err(serde::de::Error::duplicate_field("dispatches"));
                            }
                            dispatches__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RoomAgent {
                    dispatches: dispatches__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RoomAgent", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RoomAgentDispatch {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.agent_name.is_empty() {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RoomAgentDispatch", len)?;
        if !self.agent_name.is_empty() {
            struct_ser.serialize_field("agentName", &self.agent_name)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RoomAgentDispatch {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "agent_name",
            "agentName",
            "metadata",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            AgentName,
            Metadata,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "agentName" | "agent_name" => Ok(GeneratedField::AgentName),
                            "metadata" => Ok(GeneratedField::Metadata),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RoomAgentDispatch;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RoomAgentDispatch")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RoomAgentDispatch, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut agent_name__ = None;
                let mut metadata__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::AgentName => {
                            if agent_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agentName"));
                            }
                            agent_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RoomAgentDispatch {
                    agent_name: agent_name__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RoomAgentDispatch", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RoomCompositeEgressRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.room_name.is_empty() {
            len += 1;
        }
        if !self.layout.is_empty() {
            len += 1;
        }
        if self.audio_only {
            len += 1;
        }
        if self.audio_mixing != 0 {
            len += 1;
        }
        if self.video_only {
            len += 1;
        }
        if !self.custom_base_url.is_empty() {
            len += 1;
        }
        if !self.file_outputs.is_empty() {
            len += 1;
        }
        if !self.stream_outputs.is_empty() {
            len += 1;
        }
        if !self.segment_outputs.is_empty() {
            len += 1;
        }
        if !self.image_outputs.is_empty() {
            len += 1;
        }
        if self.output.is_some() {
            len += 1;
        }
        if self.options.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RoomCompositeEgressRequest", len)?;
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if !self.layout.is_empty() {
            struct_ser.serialize_field("layout", &self.layout)?;
        }
        if self.audio_only {
            struct_ser.serialize_field("audioOnly", &self.audio_only)?;
        }
        if self.audio_mixing != 0 {
            let v = AudioMixing::try_from(self.audio_mixing)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.audio_mixing)))?;
            struct_ser.serialize_field("audioMixing", &v)?;
        }
        if self.video_only {
            struct_ser.serialize_field("videoOnly", &self.video_only)?;
        }
        if !self.custom_base_url.is_empty() {
            struct_ser.serialize_field("customBaseUrl", &self.custom_base_url)?;
        }
        if !self.file_outputs.is_empty() {
            struct_ser.serialize_field("fileOutputs", &self.file_outputs)?;
        }
        if !self.stream_outputs.is_empty() {
            struct_ser.serialize_field("streamOutputs", &self.stream_outputs)?;
        }
        if !self.segment_outputs.is_empty() {
            struct_ser.serialize_field("segmentOutputs", &self.segment_outputs)?;
        }
        if !self.image_outputs.is_empty() {
            struct_ser.serialize_field("imageOutputs", &self.image_outputs)?;
        }
        if let Some(v) = self.output.as_ref() {
            match v {
                room_composite_egress_request::Output::File(v) => {
                    struct_ser.serialize_field("file", v)?;
                }
                room_composite_egress_request::Output::Stream(v) => {
                    struct_ser.serialize_field("stream", v)?;
                }
                room_composite_egress_request::Output::Segments(v) => {
                    struct_ser.serialize_field("segments", v)?;
                }
            }
        }
        if let Some(v) = self.options.as_ref() {
            match v {
                room_composite_egress_request::Options::Preset(v) => {
                    let v = EncodingOptionsPreset::try_from(*v)
                        .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", *v)))?;
                    struct_ser.serialize_field("preset", &v)?;
                }
                room_composite_egress_request::Options::Advanced(v) => {
                    struct_ser.serialize_field("advanced", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RoomCompositeEgressRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room_name",
            "roomName",
            "layout",
            "audio_only",
            "audioOnly",
            "audio_mixing",
            "audioMixing",
            "video_only",
            "videoOnly",
            "custom_base_url",
            "customBaseUrl",
            "file_outputs",
            "fileOutputs",
            "stream_outputs",
            "streamOutputs",
            "segment_outputs",
            "segmentOutputs",
            "image_outputs",
            "imageOutputs",
            "file",
            "stream",
            "segments",
            "preset",
            "advanced",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            RoomName,
            Layout,
            AudioOnly,
            AudioMixing,
            VideoOnly,
            CustomBaseUrl,
            FileOutputs,
            StreamOutputs,
            SegmentOutputs,
            ImageOutputs,
            File,
            Stream,
            Segments,
            Preset,
            Advanced,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "layout" => Ok(GeneratedField::Layout),
                            "audioOnly" | "audio_only" => Ok(GeneratedField::AudioOnly),
                            "audioMixing" | "audio_mixing" => Ok(GeneratedField::AudioMixing),
                            "videoOnly" | "video_only" => Ok(GeneratedField::VideoOnly),
                            "customBaseUrl" | "custom_base_url" => Ok(GeneratedField::CustomBaseUrl),
                            "fileOutputs" | "file_outputs" => Ok(GeneratedField::FileOutputs),
                            "streamOutputs" | "stream_outputs" => Ok(GeneratedField::StreamOutputs),
                            "segmentOutputs" | "segment_outputs" => Ok(GeneratedField::SegmentOutputs),
                            "imageOutputs" | "image_outputs" => Ok(GeneratedField::ImageOutputs),
                            "file" => Ok(GeneratedField::File),
                            "stream" => Ok(GeneratedField::Stream),
                            "segments" => Ok(GeneratedField::Segments),
                            "preset" => Ok(GeneratedField::Preset),
                            "advanced" => Ok(GeneratedField::Advanced),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RoomCompositeEgressRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RoomCompositeEgressRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RoomCompositeEgressRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room_name__ = None;
                let mut layout__ = None;
                let mut audio_only__ = None;
                let mut audio_mixing__ = None;
                let mut video_only__ = None;
                let mut custom_base_url__ = None;
                let mut file_outputs__ = None;
                let mut stream_outputs__ = None;
                let mut segment_outputs__ = None;
                let mut image_outputs__ = None;
                let mut output__ = None;
                let mut options__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Layout => {
                            if layout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("layout"));
                            }
                            layout__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AudioOnly => {
                            if audio_only__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audioOnly"));
                            }
                            audio_only__ = Some(map_.next_value()?);
                        }
                        GeneratedField::AudioMixing => {
                            if audio_mixing__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audioMixing"));
                            }
                            audio_mixing__ = Some(map_.next_value::<AudioMixing>()? as i32);
                        }
                        GeneratedField::VideoOnly => {
                            if video_only__.is_some() {
                                return Err(serde::de::Error::duplicate_field("videoOnly"));
                            }
                            video_only__ = Some(map_.next_value()?);
                        }
                        GeneratedField::CustomBaseUrl => {
                            if custom_base_url__.is_some() {
                                return Err(serde::de::Error::duplicate_field("customBaseUrl"));
                            }
                            custom_base_url__ = Some(map_.next_value()?);
                        }
                        GeneratedField::FileOutputs => {
                            if file_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("fileOutputs"));
                            }
                            file_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::StreamOutputs => {
                            if stream_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("streamOutputs"));
                            }
                            stream_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SegmentOutputs => {
                            if segment_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("segmentOutputs"));
                            }
                            segment_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ImageOutputs => {
                            if image_outputs__.is_some() {
                                return Err(serde::de::Error::duplicate_field("imageOutputs"));
                            }
                            image_outputs__ = Some(map_.next_value()?);
                        }
                        GeneratedField::File => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("file"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(room_composite_egress_request::Output::File)
;
                        }
                        GeneratedField::Stream => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("stream"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(room_composite_egress_request::Output::Stream)
;
                        }
                        GeneratedField::Segments => {
                            if output__.is_some() {
                                return Err(serde::de::Error::duplicate_field("segments"));
                            }
                            output__ = map_.next_value::<::std::option::Option<_>>()?.map(room_composite_egress_request::Output::Segments)
;
                        }
                        GeneratedField::Preset => {
                            if options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("preset"));
                            }
                            options__ = map_.next_value::<::std::option::Option<EncodingOptionsPreset>>()?.map(|x| room_composite_egress_request::Options::Preset(x as i32));
                        }
                        GeneratedField::Advanced => {
                            if options__.is_some() {
                                return Err(serde::de::Error::duplicate_field("advanced"));
                            }
                            options__ = map_.next_value::<::std::option::Option<_>>()?.map(room_composite_egress_request::Options::Advanced)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RoomCompositeEgressRequest {
                    room_name: room_name__.unwrap_or_default(),
                    layout: layout__.unwrap_or_default(),
                    audio_only: audio_only__.unwrap_or_default(),
                    audio_mixing: audio_mixing__.unwrap_or_default(),
                    video_only: video_only__.unwrap_or_default(),
                    custom_base_url: custom_base_url__.unwrap_or_default(),
                    file_outputs: file_outputs__.unwrap_or_default(),
                    stream_outputs: stream_outputs__.unwrap_or_default(),
                    segment_outputs: segment_outputs__.unwrap_or_default(),
                    image_outputs: image_outputs__.unwrap_or_default(),
                    output: output__,
                    options: options__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.RoomCompositeEgressRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RoomConfiguration {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.name.is_empty() {
            len += 1;
        }
        if self.empty_timeout != 0 {
            len += 1;
        }
        if self.departure_timeout != 0 {
            len += 1;
        }
        if self.max_participants != 0 {
            len += 1;
        }
        if self.egress.is_some() {
            len += 1;
        }
        if self.min_playout_delay != 0 {
            len += 1;
        }
        if self.max_playout_delay != 0 {
            len += 1;
        }
        if self.sync_streams {
            len += 1;
        }
        if !self.agents.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RoomConfiguration", len)?;
        if !self.name.is_empty() {
            struct_ser.serialize_field("name", &self.name)?;
        }
        if self.empty_timeout != 0 {
            struct_ser.serialize_field("emptyTimeout", &self.empty_timeout)?;
        }
        if self.departure_timeout != 0 {
            struct_ser.serialize_field("departureTimeout", &self.departure_timeout)?;
        }
        if self.max_participants != 0 {
            struct_ser.serialize_field("maxParticipants", &self.max_participants)?;
        }
        if let Some(v) = self.egress.as_ref() {
            struct_ser.serialize_field("egress", v)?;
        }
        if self.min_playout_delay != 0 {
            struct_ser.serialize_field("minPlayoutDelay", &self.min_playout_delay)?;
        }
        if self.max_playout_delay != 0 {
            struct_ser.serialize_field("maxPlayoutDelay", &self.max_playout_delay)?;
        }
        if self.sync_streams {
            struct_ser.serialize_field("syncStreams", &self.sync_streams)?;
        }
        if !self.agents.is_empty() {
            struct_ser.serialize_field("agents", &self.agents)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RoomConfiguration {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "name",
            "empty_timeout",
            "emptyTimeout",
            "departure_timeout",
            "departureTimeout",
            "max_participants",
            "maxParticipants",
            "egress",
            "min_playout_delay",
            "minPlayoutDelay",
            "max_playout_delay",
            "maxPlayoutDelay",
            "sync_streams",
            "syncStreams",
            "agents",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Name,
            EmptyTimeout,
            DepartureTimeout,
            MaxParticipants,
            Egress,
            MinPlayoutDelay,
            MaxPlayoutDelay,
            SyncStreams,
            Agents,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "name" => Ok(GeneratedField::Name),
                            "emptyTimeout" | "empty_timeout" => Ok(GeneratedField::EmptyTimeout),
                            "departureTimeout" | "departure_timeout" => Ok(GeneratedField::DepartureTimeout),
                            "maxParticipants" | "max_participants" => Ok(GeneratedField::MaxParticipants),
                            "egress" => Ok(GeneratedField::Egress),
                            "minPlayoutDelay" | "min_playout_delay" => Ok(GeneratedField::MinPlayoutDelay),
                            "maxPlayoutDelay" | "max_playout_delay" => Ok(GeneratedField::MaxPlayoutDelay),
                            "syncStreams" | "sync_streams" => Ok(GeneratedField::SyncStreams),
                            "agents" => Ok(GeneratedField::Agents),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RoomConfiguration;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RoomConfiguration")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RoomConfiguration, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut name__ = None;
                let mut empty_timeout__ = None;
                let mut departure_timeout__ = None;
                let mut max_participants__ = None;
                let mut egress__ = None;
                let mut min_playout_delay__ = None;
                let mut max_playout_delay__ = None;
                let mut sync_streams__ = None;
                let mut agents__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Name => {
                            if name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("name"));
                            }
                            name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::EmptyTimeout => {
                            if empty_timeout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("emptyTimeout"));
                            }
                            empty_timeout__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DepartureTimeout => {
                            if departure_timeout__.is_some() {
                                return Err(serde::de::Error::duplicate_field("departureTimeout"));
                            }
                            departure_timeout__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::MaxParticipants => {
                            if max_participants__.is_some() {
                                return Err(serde::de::Error::duplicate_field("maxParticipants"));
                            }
                            max_participants__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Egress => {
                            if egress__.is_some() {
                                return Err(serde::de::Error::duplicate_field("egress"));
                            }
                            egress__ = map_.next_value()?;
                        }
                        GeneratedField::MinPlayoutDelay => {
                            if min_playout_delay__.is_some() {
                                return Err(serde::de::Error::duplicate_field("minPlayoutDelay"));
                            }
                            min_playout_delay__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::MaxPlayoutDelay => {
                            if max_playout_delay__.is_some() {
                                return Err(serde::de::Error::duplicate_field("maxPlayoutDelay"));
                            }
                            max_playout_delay__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::SyncStreams => {
                            if sync_streams__.is_some() {
                                return Err(serde::de::Error::duplicate_field("syncStreams"));
                            }
                            sync_streams__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Agents => {
                            if agents__.is_some() {
                                return Err(serde::de::Error::duplicate_field("agents"));
                            }
                            agents__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RoomConfiguration {
                    name: name__.unwrap_or_default(),
                    empty_timeout: empty_timeout__.unwrap_or_default(),
                    departure_timeout: departure_timeout__.unwrap_or_default(),
                    max_participants: max_participants__.unwrap_or_default(),
                    egress: egress__,
                    min_playout_delay: min_playout_delay__.unwrap_or_default(),
                    max_playout_delay: max_playout_delay__.unwrap_or_default(),
                    sync_streams: sync_streams__.unwrap_or_default(),
                    agents: agents__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RoomConfiguration", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RoomEgress {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.room.is_some() {
            len += 1;
        }
        if self.participant.is_some() {
            len += 1;
        }
        if self.tracks.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RoomEgress", len)?;
        if let Some(v) = self.room.as_ref() {
            struct_ser.serialize_field("room", v)?;
        }
        if let Some(v) = self.participant.as_ref() {
            struct_ser.serialize_field("participant", v)?;
        }
        if let Some(v) = self.tracks.as_ref() {
            struct_ser.serialize_field("tracks", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RoomEgress {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room",
            "participant",
            "tracks",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Room,
            Participant,
            Tracks,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "room" => Ok(GeneratedField::Room),
                            "participant" => Ok(GeneratedField::Participant),
                            "tracks" => Ok(GeneratedField::Tracks),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RoomEgress;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RoomEgress")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RoomEgress, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room__ = None;
                let mut participant__ = None;
                let mut tracks__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = map_.next_value()?;
                        }
                        GeneratedField::Participant => {
                            if participant__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participant"));
                            }
                            participant__ = map_.next_value()?;
                        }
                        GeneratedField::Tracks => {
                            if tracks__.is_some() {
                                return Err(serde::de::Error::duplicate_field("tracks"));
                            }
                            tracks__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RoomEgress {
                    room: room__,
                    participant: participant__,
                    tracks: tracks__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.RoomEgress", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RoomParticipantIdentity {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.room.is_empty() {
            len += 1;
        }
        if !self.identity.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RoomParticipantIdentity", len)?;
        if !self.room.is_empty() {
            struct_ser.serialize_field("room", &self.room)?;
        }
        if !self.identity.is_empty() {
            struct_ser.serialize_field("identity", &self.identity)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RoomParticipantIdentity {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room",
            "identity",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Room,
            Identity,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "room" => Ok(GeneratedField::Room),
                            "identity" => Ok(GeneratedField::Identity),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RoomParticipantIdentity;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RoomParticipantIdentity")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RoomParticipantIdentity, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room__ = None;
                let mut identity__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Identity => {
                            if identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("identity"));
                            }
                            identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RoomParticipantIdentity {
                    room: room__.unwrap_or_default(),
                    identity: identity__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RoomParticipantIdentity", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RoomUpdate {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.room.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RoomUpdate", len)?;
        if let Some(v) = self.room.as_ref() {
            struct_ser.serialize_field("room", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RoomUpdate {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "room",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Room,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "room" => Ok(GeneratedField::Room),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RoomUpdate;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RoomUpdate")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RoomUpdate, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut room__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Room => {
                            if room__.is_some() {
                                return Err(serde::de::Error::duplicate_field("room"));
                            }
                            room__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RoomUpdate {
                    room: room__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.RoomUpdate", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RpcAck {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.request_id.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RpcAck", len)?;
        if !self.request_id.is_empty() {
            struct_ser.serialize_field("requestId", &self.request_id)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RpcAck {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "request_id",
            "requestId",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            RequestId,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "requestId" | "request_id" => Ok(GeneratedField::RequestId),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RpcAck;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RpcAck")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RpcAck, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut request_id__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::RequestId => {
                            if request_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("requestId"));
                            }
                            request_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RpcAck {
                    request_id: request_id__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RpcAck", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RpcError {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if self.code != 0 {
            len += 1;
        }
        if !self.message.is_empty() {
            len += 1;
        }
        if !self.data.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RpcError", len)?;
        if self.code != 0 {
            struct_ser.serialize_field("code", &self.code)?;
        }
        if !self.message.is_empty() {
            struct_ser.serialize_field("message", &self.message)?;
        }
        if !self.data.is_empty() {
            struct_ser.serialize_field("data", &self.data)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RpcError {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "code",
            "message",
            "data",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Code,
            Message,
            Data,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "code" => Ok(GeneratedField::Code),
                            "message" => Ok(GeneratedField::Message),
                            "data" => Ok(GeneratedField::Data),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RpcError;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RpcError")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RpcError, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut code__ = None;
                let mut message__ = None;
                let mut data__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Code => {
                            if code__.is_some() {
                                return Err(serde::de::Error::duplicate_field("code"));
                            }
                            code__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Message => {
                            if message__.is_some() {
                                return Err(serde::de::Error::duplicate_field("message"));
                            }
                            message__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Data => {
                            if data__.is_some() {
                                return Err(serde::de::Error::duplicate_field("data"));
                            }
                            data__ = Some(map_.next_value()?);
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RpcError {
                    code: code__.unwrap_or_default(),
                    message: message__.unwrap_or_default(),
                    data: data__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RpcError", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RpcRequest {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.id.is_empty() {
            len += 1;
        }
        if !self.method.is_empty() {
            len += 1;
        }
        if !self.payload.is_empty() {
            len += 1;
        }
        if self.response_timeout_ms != 0 {
            len += 1;
        }
        if self.version != 0 {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RpcRequest", len)?;
        if !self.id.is_empty() {
            struct_ser.serialize_field("id", &self.id)?;
        }
        if !self.method.is_empty() {
            struct_ser.serialize_field("method", &self.method)?;
        }
        if !self.payload.is_empty() {
            struct_ser.serialize_field("payload", &self.payload)?;
        }
        if self.response_timeout_ms != 0 {
            struct_ser.serialize_field("responseTimeoutMs", &self.response_timeout_ms)?;
        }
        if self.version != 0 {
            struct_ser.serialize_field("version", &self.version)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RpcRequest {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "id",
            "method",
            "payload",
            "response_timeout_ms",
            "responseTimeoutMs",
            "version",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            Id,
            Method,
            Payload,
            ResponseTimeoutMs,
            Version,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "id" => Ok(GeneratedField::Id),
                            "method" => Ok(GeneratedField::Method),
                            "payload" => Ok(GeneratedField::Payload),
                            "responseTimeoutMs" | "response_timeout_ms" => Ok(GeneratedField::ResponseTimeoutMs),
                            "version" => Ok(GeneratedField::Version),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RpcRequest;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RpcRequest")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RpcRequest, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut id__ = None;
                let mut method__ = None;
                let mut payload__ = None;
                let mut response_timeout_ms__ = None;
                let mut version__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::Id => {
                            if id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("id"));
                            }
                            id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Method => {
                            if method__.is_some() {
                                return Err(serde::de::Error::duplicate_field("method"));
                            }
                            method__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Payload => {
                            if payload__.is_some() {
                                return Err(serde::de::Error::duplicate_field("payload"));
                            }
                            payload__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ResponseTimeoutMs => {
                            if response_timeout_ms__.is_some() {
                                return Err(serde::de::Error::duplicate_field("responseTimeoutMs"));
                            }
                            response_timeout_ms__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::Version => {
                            if version__.is_some() {
                                return Err(serde::de::Error::duplicate_field("version"));
                            }
                            version__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RpcRequest {
                    id: id__.unwrap_or_default(),
                    method: method__.unwrap_or_default(),
                    payload: payload__.unwrap_or_default(),
                    response_timeout_ms: response_timeout_ms__.unwrap_or_default(),
                    version: version__.unwrap_or_default(),
                })
            }
        }
        deserializer.deserialize_struct("livekit.RpcRequest", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for RpcResponse {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.request_id.is_empty() {
            len += 1;
        }
        if self.value.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.RpcResponse", len)?;
        if !self.request_id.is_empty() {
            struct_ser.serialize_field("requestId", &self.request_id)?;
        }
        if let Some(v) = self.value.as_ref() {
            match v {
                rpc_response::Value::Payload(v) => {
                    struct_ser.serialize_field("payload", v)?;
                }
                rpc_response::Value::Error(v) => {
                    struct_ser.serialize_field("error", v)?;
                }
            }
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for RpcResponse {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "request_id",
            "requestId",
            "payload",
            "error",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            RequestId,
            Payload,
            Error,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "requestId" | "request_id" => Ok(GeneratedField::RequestId),
                            "payload" => Ok(GeneratedField::Payload),
                            "error" => Ok(GeneratedField::Error),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = RpcResponse;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.RpcResponse")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<RpcResponse, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut request_id__ = None;
                let mut value__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::RequestId => {
                            if request_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("requestId"));
                            }
                            request_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Payload => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("payload"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(rpc_response::Value::Payload);
                        }
                        GeneratedField::Error => {
                            if value__.is_some() {
                                return Err(serde::de::Error::duplicate_field("error"));
                            }
                            value__ = map_.next_value::<::std::option::Option<_>>()?.map(rpc_response::Value::Error)
;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(RpcResponse {
                    request_id: request_id__.unwrap_or_default(),
                    value: value__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.RpcResponse", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for S3Upload {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.access_key.is_empty() {
            len += 1;
        }
        if !self.secret.is_empty() {
            len += 1;
        }
        if !self.session_token.is_empty() {
            len += 1;
        }
        if !self.region.is_empty() {
            len += 1;
        }
        if !self.endpoint.is_empty() {
            len += 1;
        }
        if !self.bucket.is_empty() {
            len += 1;
        }
        if self.force_path_style {
            len += 1;
        }
        if !self.metadata.is_empty() {
            len += 1;
        }
        if !self.tagging.is_empty() {
            len += 1;
        }
        if !self.content_disposition.is_empty() {
            len += 1;
        }
        if self.proxy.is_some() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.S3Upload", len)?;
        if !self.access_key.is_empty() {
            struct_ser.serialize_field("accessKey", &self.access_key)?;
        }
        if !self.secret.is_empty() {
            struct_ser.serialize_field("secret", &self.secret)?;
        }
        if !self.session_token.is_empty() {
            struct_ser.serialize_field("sessionToken", &self.session_token)?;
        }
        if !self.region.is_empty() {
            struct_ser.serialize_field("region", &self.region)?;
        }
        if !self.endpoint.is_empty() {
            struct_ser.serialize_field("endpoint", &self.endpoint)?;
        }
        if !self.bucket.is_empty() {
            struct_ser.serialize_field("bucket", &self.bucket)?;
        }
        if self.force_path_style {
            struct_ser.serialize_field("forcePathStyle", &self.force_path_style)?;
        }
        if !self.metadata.is_empty() {
            struct_ser.serialize_field("metadata", &self.metadata)?;
        }
        if !self.tagging.is_empty() {
            struct_ser.serialize_field("tagging", &self.tagging)?;
        }
        if !self.content_disposition.is_empty() {
            struct_ser.serialize_field("contentDisposition", &self.content_disposition)?;
        }
        if let Some(v) = self.proxy.as_ref() {
            struct_ser.serialize_field("proxy", v)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for S3Upload {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "access_key",
            "accessKey",
            "secret",
            "session_token",
            "sessionToken",
            "region",
            "endpoint",
            "bucket",
            "force_path_style",
            "forcePathStyle",
            "metadata",
            "tagging",
            "content_disposition",
            "contentDisposition",
            "proxy",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            AccessKey,
            Secret,
            SessionToken,
            Region,
            Endpoint,
            Bucket,
            ForcePathStyle,
            Metadata,
            Tagging,
            ContentDisposition,
            Proxy,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "accessKey" | "access_key" => Ok(GeneratedField::AccessKey),
                            "secret" => Ok(GeneratedField::Secret),
                            "sessionToken" | "session_token" => Ok(GeneratedField::SessionToken),
                            "region" => Ok(GeneratedField::Region),
                            "endpoint" => Ok(GeneratedField::Endpoint),
                            "bucket" => Ok(GeneratedField::Bucket),
                            "forcePathStyle" | "force_path_style" => Ok(GeneratedField::ForcePathStyle),
                            "metadata" => Ok(GeneratedField::Metadata),
                            "tagging" => Ok(GeneratedField::Tagging),
                            "contentDisposition" | "content_disposition" => Ok(GeneratedField::ContentDisposition),
                            "proxy" => Ok(GeneratedField::Proxy),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = S3Upload;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.S3Upload")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<S3Upload, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut access_key__ = None;
                let mut secret__ = None;
                let mut session_token__ = None;
                let mut region__ = None;
                let mut endpoint__ = None;
                let mut bucket__ = None;
                let mut force_path_style__ = None;
                let mut metadata__ = None;
                let mut tagging__ = None;
                let mut content_disposition__ = None;
                let mut proxy__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::AccessKey => {
                            if access_key__.is_some() {
                                return Err(serde::de::Error::duplicate_field("accessKey"));
                            }
                            access_key__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Secret => {
                            if secret__.is_some() {
                                return Err(serde::de::Error::duplicate_field("secret"));
                            }
                            secret__ = Some(map_.next_value()?);
                        }
                        GeneratedField::SessionToken => {
                            if session_token__.is_some() {
                                return Err(serde::de::Error::duplicate_field("sessionToken"));
                            }
                            session_token__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Region => {
                            if region__.is_some() {
                                return Err(serde::de::Error::duplicate_field("region"));
                            }
                            region__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Endpoint => {
                            if endpoint__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endpoint"));
                            }
                            endpoint__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Bucket => {
                            if bucket__.is_some() {
                                return Err(serde::de::Error::duplicate_field("bucket"));
                            }
                            bucket__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ForcePathStyle => {
                            if force_path_style__.is_some() {
                                return Err(serde::de::Error::duplicate_field("forcePathStyle"));
                            }
                            force_path_style__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Metadata => {
                            if metadata__.is_some() {
                                return Err(serde::de::Error::duplicate_field("metadata"));
                            }
                            metadata__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::Tagging => {
                            if tagging__.is_some() {
                                return Err(serde::de::Error::duplicate_field("tagging"));
                            }
                            tagging__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ContentDisposition => {
                            if content_disposition__.is_some() {
                                return Err(serde::de::Error::duplicate_field("contentDisposition"));
                            }
                            content_disposition__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Proxy => {
                            if proxy__.is_some() {
                                return Err(serde::de::Error::duplicate_field("proxy"));
                            }
                            proxy__ = map_.next_value()?;
                        }
                        GeneratedField::__SkipField__ => {
                            let _ = map_.next_value::<serde::de::IgnoredAny>()?;
                        }
                    }
                }
                Ok(S3Upload {
                    access_key: access_key__.unwrap_or_default(),
                    secret: secret__.unwrap_or_default(),
                    session_token: session_token__.unwrap_or_default(),
                    region: region__.unwrap_or_default(),
                    endpoint: endpoint__.unwrap_or_default(),
                    bucket: bucket__.unwrap_or_default(),
                    force_path_style: force_path_style__.unwrap_or_default(),
                    metadata: metadata__.unwrap_or_default(),
                    tagging: tagging__.unwrap_or_default(),
                    content_disposition: content_disposition__.unwrap_or_default(),
                    proxy: proxy__,
                })
            }
        }
        deserializer.deserialize_struct("livekit.S3Upload", FIELDS, GeneratedVisitor)
    }
}
impl serde::Serialize for SipCallDirection {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        let variant = match self {
            Self::ScdUnknown => "SCD_UNKNOWN",
            Self::ScdInbound => "SCD_INBOUND",
            Self::ScdOutbound => "SCD_OUTBOUND",
        };
        serializer.serialize_str(variant)
    }
}
impl<'de> serde::Deserialize<'de> for SipCallDirection {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "SCD_UNKNOWN",
            "SCD_INBOUND",
            "SCD_OUTBOUND",
        ];

        struct GeneratedVisitor;

        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = SipCallDirection;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                write!(formatter, "expected one of: {:?}", &FIELDS)
            }

            fn visit_i64<E>(self, v: i64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Signed(v), &self)
                    })
            }

            fn visit_u64<E>(self, v: u64) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                i32::try_from(v)
                    .ok()
                    .and_then(|x| x.try_into().ok())
                    .ok_or_else(|| {
                        serde::de::Error::invalid_value(serde::de::Unexpected::Unsigned(v), &self)
                    })
            }

            fn visit_str<E>(self, value: &str) -> std::result::Result<Self::Value, E>
            where
                E: serde::de::Error,
            {
                match value {
                    "SCD_UNKNOWN" => Ok(SipCallDirection::ScdUnknown),
                    "SCD_INBOUND" => Ok(SipCallDirection::ScdInbound),
                    "SCD_OUTBOUND" => Ok(SipCallDirection::ScdOutbound),
                    _ => Err(serde::de::Error::unknown_variant(value, FIELDS)),
                }
            }
        }
        deserializer.deserialize_any(GeneratedVisitor)
    }
}
impl serde::Serialize for SipCallInfo {
    #[allow(deprecated)]
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        use serde::ser::SerializeStruct;
        let mut len = 0;
        if !self.call_id.is_empty() {
            len += 1;
        }
        if !self.trunk_id.is_empty() {
            len += 1;
        }
        if !self.dispatch_rule_id.is_empty() {
            len += 1;
        }
        if !self.region.is_empty() {
            len += 1;
        }
        if !self.room_name.is_empty() {
            len += 1;
        }
        if !self.room_id.is_empty() {
            len += 1;
        }
        if !self.participant_identity.is_empty() {
            len += 1;
        }
        if !self.participant_attributes.is_empty() {
            len += 1;
        }
        if self.from_uri.is_some() {
            len += 1;
        }
        if self.to_uri.is_some() {
            len += 1;
        }
        if self.created_at != 0 {
            len += 1;
        }
        if self.started_at != 0 {
            len += 1;
        }
        if self.ended_at != 0 {
            len += 1;
        }
        if !self.enabled_features.is_empty() {
            len += 1;
        }
        if self.call_direction != 0 {
            len += 1;
        }
        if self.call_status != 0 {
            len += 1;
        }
        if self.created_at_ns != 0 {
            len += 1;
        }
        if self.started_at_ns != 0 {
            len += 1;
        }
        if self.ended_at_ns != 0 {
            len += 1;
        }
        if self.disconnect_reason != 0 {
            len += 1;
        }
        if !self.error.is_empty() {
            len += 1;
        }
        if self.call_status_code.is_some() {
            len += 1;
        }
        if !self.audio_codec.is_empty() {
            len += 1;
        }
        if !self.media_encryption.is_empty() {
            len += 1;
        }
        let mut struct_ser = serializer.serialize_struct("livekit.SIPCallInfo", len)?;
        if !self.call_id.is_empty() {
            struct_ser.serialize_field("callId", &self.call_id)?;
        }
        if !self.trunk_id.is_empty() {
            struct_ser.serialize_field("trunkId", &self.trunk_id)?;
        }
        if !self.dispatch_rule_id.is_empty() {
            struct_ser.serialize_field("dispatchRuleId", &self.dispatch_rule_id)?;
        }
        if !self.region.is_empty() {
            struct_ser.serialize_field("region", &self.region)?;
        }
        if !self.room_name.is_empty() {
            struct_ser.serialize_field("roomName", &self.room_name)?;
        }
        if !self.room_id.is_empty() {
            struct_ser.serialize_field("roomId", &self.room_id)?;
        }
        if !self.participant_identity.is_empty() {
            struct_ser.serialize_field("participantIdentity", &self.participant_identity)?;
        }
        if !self.participant_attributes.is_empty() {
            struct_ser.serialize_field("participantAttributes", &self.participant_attributes)?;
        }
        if let Some(v) = self.from_uri.as_ref() {
            struct_ser.serialize_field("fromUri", v)?;
        }
        if let Some(v) = self.to_uri.as_ref() {
            struct_ser.serialize_field("toUri", v)?;
        }
        if self.created_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("createdAt", ToString::to_string(&self.created_at).as_str())?;
        }
        if self.started_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startedAt", ToString::to_string(&self.started_at).as_str())?;
        }
        if self.ended_at != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endedAt", ToString::to_string(&self.ended_at).as_str())?;
        }
        if !self.enabled_features.is_empty() {
            let v = self.enabled_features.iter().cloned().map(|v| {
                SipFeature::try_from(v)
                    .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", v)))
                }).collect::<std::result::Result<Vec<_>, _>>()?;
            struct_ser.serialize_field("enabledFeatures", &v)?;
        }
        if self.call_direction != 0 {
            let v = SipCallDirection::try_from(self.call_direction)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.call_direction)))?;
            struct_ser.serialize_field("callDirection", &v)?;
        }
        if self.call_status != 0 {
            let v = SipCallStatus::try_from(self.call_status)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.call_status)))?;
            struct_ser.serialize_field("callStatus", &v)?;
        }
        if self.created_at_ns != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("createdAtNs", ToString::to_string(&self.created_at_ns).as_str())?;
        }
        if self.started_at_ns != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("startedAtNs", ToString::to_string(&self.started_at_ns).as_str())?;
        }
        if self.ended_at_ns != 0 {
            #[allow(clippy::needless_borrow)]
            #[allow(clippy::needless_borrows_for_generic_args)]
            struct_ser.serialize_field("endedAtNs", ToString::to_string(&self.ended_at_ns).as_str())?;
        }
        if self.disconnect_reason != 0 {
            let v = DisconnectReason::try_from(self.disconnect_reason)
                .map_err(|_| serde::ser::Error::custom(format!("Invalid variant {}", self.disconnect_reason)))?;
            struct_ser.serialize_field("disconnectReason", &v)?;
        }
        if !self.error.is_empty() {
            struct_ser.serialize_field("error", &self.error)?;
        }
        if let Some(v) = self.call_status_code.as_ref() {
            struct_ser.serialize_field("callStatusCode", v)?;
        }
        if !self.audio_codec.is_empty() {
            struct_ser.serialize_field("audioCodec", &self.audio_codec)?;
        }
        if !self.media_encryption.is_empty() {
            struct_ser.serialize_field("mediaEncryption", &self.media_encryption)?;
        }
        struct_ser.end()
    }
}
impl<'de> serde::Deserialize<'de> for SipCallInfo {
    #[allow(deprecated)]
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        const FIELDS: &[&str] = &[
            "call_id",
            "callId",
            "trunk_id",
            "trunkId",
            "dispatch_rule_id",
            "dispatchRuleId",
            "region",
            "room_name",
            "roomName",
            "room_id",
            "roomId",
            "participant_identity",
            "participantIdentity",
            "participant_attributes",
            "participantAttributes",
            "from_uri",
            "fromUri",
            "to_uri",
            "toUri",
            "created_at",
            "createdAt",
            "started_at",
            "startedAt",
            "ended_at",
            "endedAt",
            "enabled_features",
            "enabledFeatures",
            "call_direction",
            "callDirection",
            "call_status",
            "callStatus",
            "created_at_ns",
            "createdAtNs",
            "started_at_ns",
            "startedAtNs",
            "ended_at_ns",
            "endedAtNs",
            "disconnect_reason",
            "disconnectReason",
            "error",
            "call_status_code",
            "callStatusCode",
            "audio_codec",
            "audioCodec",
            "media_encryption",
            "mediaEncryption",
        ];

        #[allow(clippy::enum_variant_names)]
        enum GeneratedField {
            CallId,
            TrunkId,
            DispatchRuleId,
            Region,
            RoomName,
            RoomId,
            ParticipantIdentity,
            ParticipantAttributes,
            FromUri,
            ToUri,
            CreatedAt,
            StartedAt,
            EndedAt,
            EnabledFeatures,
            CallDirection,
            CallStatus,
            CreatedAtNs,
            StartedAtNs,
            EndedAtNs,
            DisconnectReason,
            Error,
            CallStatusCode,
            AudioCodec,
            MediaEncryption,
            __SkipField__,
        }
        impl<'de> serde::Deserialize<'de> for GeneratedField {
            fn deserialize<D>(deserializer: D) -> std::result::Result<GeneratedField, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                struct GeneratedVisitor;

                impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
                    type Value = GeneratedField;

                    fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                        write!(formatter, "expected one of: {:?}", &FIELDS)
                    }

                    #[allow(unused_variables)]
                    fn visit_str<E>(self, value: &str) -> std::result::Result<GeneratedField, E>
                    where
                        E: serde::de::Error,
                    {
                        match value {
                            "callId" | "call_id" => Ok(GeneratedField::CallId),
                            "trunkId" | "trunk_id" => Ok(GeneratedField::TrunkId),
                            "dispatchRuleId" | "dispatch_rule_id" => Ok(GeneratedField::DispatchRuleId),
                            "region" => Ok(GeneratedField::Region),
                            "roomName" | "room_name" => Ok(GeneratedField::RoomName),
                            "roomId" | "room_id" => Ok(GeneratedField::RoomId),
                            "participantIdentity" | "participant_identity" => Ok(GeneratedField::ParticipantIdentity),
                            "participantAttributes" | "participant_attributes" => Ok(GeneratedField::ParticipantAttributes),
                            "fromUri" | "from_uri" => Ok(GeneratedField::FromUri),
                            "toUri" | "to_uri" => Ok(GeneratedField::ToUri),
                            "createdAt" | "created_at" => Ok(GeneratedField::CreatedAt),
                            "startedAt" | "started_at" => Ok(GeneratedField::StartedAt),
                            "endedAt" | "ended_at" => Ok(GeneratedField::EndedAt),
                            "enabledFeatures" | "enabled_features" => Ok(GeneratedField::EnabledFeatures),
                            "callDirection" | "call_direction" => Ok(GeneratedField::CallDirection),
                            "callStatus" | "call_status" => Ok(GeneratedField::CallStatus),
                            "createdAtNs" | "created_at_ns" => Ok(GeneratedField::CreatedAtNs),
                            "startedAtNs" | "started_at_ns" => Ok(GeneratedField::StartedAtNs),
                            "endedAtNs" | "ended_at_ns" => Ok(GeneratedField::EndedAtNs),
                            "disconnectReason" | "disconnect_reason" => Ok(GeneratedField::DisconnectReason),
                            "error" => Ok(GeneratedField::Error),
                            "callStatusCode" | "call_status_code" => Ok(GeneratedField::CallStatusCode),
                            "audioCodec" | "audio_codec" => Ok(GeneratedField::AudioCodec),
                            "mediaEncryption" | "media_encryption" => Ok(GeneratedField::MediaEncryption),
                            _ => Ok(GeneratedField::__SkipField__),
                        }
                    }
                }
                deserializer.deserialize_identifier(GeneratedVisitor)
            }
        }
        struct GeneratedVisitor;
        impl<'de> serde::de::Visitor<'de> for GeneratedVisitor {
            type Value = SipCallInfo;

            fn expecting(&self, formatter: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
                formatter.write_str("struct livekit.SIPCallInfo")
            }

            fn visit_map<V>(self, mut map_: V) -> std::result::Result<SipCallInfo, V::Error>
                where
                    V: serde::de::MapAccess<'de>,
            {
                let mut call_id__ = None;
                let mut trunk_id__ = None;
                let mut dispatch_rule_id__ = None;
                let mut region__ = None;
                let mut room_name__ = None;
                let mut room_id__ = None;
                let mut participant_identity__ = None;
                let mut participant_attributes__ = None;
                let mut from_uri__ = None;
                let mut to_uri__ = None;
                let mut created_at__ = None;
                let mut started_at__ = None;
                let mut ended_at__ = None;
                let mut enabled_features__ = None;
                let mut call_direction__ = None;
                let mut call_status__ = None;
                let mut created_at_ns__ = None;
                let mut started_at_ns__ = None;
                let mut ended_at_ns__ = None;
                let mut disconnect_reason__ = None;
                let mut error__ = None;
                let mut call_status_code__ = None;
                let mut audio_codec__ = None;
                let mut media_encryption__ = None;
                while let Some(k) = map_.next_key()? {
                    match k {
                        GeneratedField::CallId => {
                            if call_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("callId"));
                            }
                            call_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::TrunkId => {
                            if trunk_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("trunkId"));
                            }
                            trunk_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::DispatchRuleId => {
                            if dispatch_rule_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("dispatchRuleId"));
                            }
                            dispatch_rule_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::Region => {
                            if region__.is_some() {
                                return Err(serde::de::Error::duplicate_field("region"));
                            }
                            region__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomName => {
                            if room_name__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomName"));
                            }
                            room_name__ = Some(map_.next_value()?);
                        }
                        GeneratedField::RoomId => {
                            if room_id__.is_some() {
                                return Err(serde::de::Error::duplicate_field("roomId"));
                            }
                            room_id__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantIdentity => {
                            if participant_identity__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantIdentity"));
                            }
                            participant_identity__ = Some(map_.next_value()?);
                        }
                        GeneratedField::ParticipantAttributes => {
                            if participant_attributes__.is_some() {
                                return Err(serde::de::Error::duplicate_field("participantAttributes"));
                            }
                            participant_attributes__ = Some(
                                map_.next_value::<std::collections::HashMap<_, _>>()?
                            );
                        }
                        GeneratedField::FromUri => {
                            if from_uri__.is_some() {
                                return Err(serde::de::Error::duplicate_field("fromUri"));
                            }
                            from_uri__ = map_.next_value()?;
                        }
                        GeneratedField::ToUri => {
                            if to_uri__.is_some() {
                                return Err(serde::de::Error::duplicate_field("toUri"));
                            }
                            to_uri__ = map_.next_value()?;
                        }
                        GeneratedField::CreatedAt => {
                            if created_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("createdAt"));
                            }
                            created_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::StartedAt => {
                            if started_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startedAt"));
                            }
                            started_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndedAt => {
                            if ended_at__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endedAt"));
                            }
                            ended_at__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EnabledFeatures => {
                            if enabled_features__.is_some() {
                                return Err(serde::de::Error::duplicate_field("enabledFeatures"));
                            }
                            enabled_features__ = Some(map_.next_value::<Vec<SipFeature>>()?.into_iter().map(|x| x as i32).collect());
                        }
                        GeneratedField::CallDirection => {
                            if call_direction__.is_some() {
                                return Err(serde::de::Error::duplicate_field("callDirection"));
                            }
                            call_direction__ = Some(map_.next_value::<SipCallDirection>()? as i32);
                        }
                        GeneratedField::CallStatus => {
                            if call_status__.is_some() {
                                return Err(serde::de::Error::duplicate_field("callStatus"));
                            }
                            call_status__ = Some(map_.next_value::<SipCallStatus>()? as i32);
                        }
                        GeneratedField::CreatedAtNs => {
                            if created_at_ns__.is_some() {
                                return Err(serde::de::Error::duplicate_field("createdAtNs"));
                            }
                            created_at_ns__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::StartedAtNs => {
                            if started_at_ns__.is_some() {
                                return Err(serde::de::Error::duplicate_field("startedAtNs"));
                            }
                            started_at_ns__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::EndedAtNs => {
                            if ended_at_ns__.is_some() {
                                return Err(serde::de::Error::duplicate_field("endedAtNs"));
                            }
                            ended_at_ns__ = 
                                Some(map_.next_value::<::pbjson::private::NumberDeserialize<_>>()?.0)
                            ;
                        }
                        GeneratedField::DisconnectReason => {
                            if disconnect_reason__.is_some() {
                                return Err(serde::de::Error::duplicate_field("disconnectReason"));
                            }
                            disconnect_reason__ = Some(map_.next_value::<DisconnectReason>()? as i32);
                        }
                        GeneratedField::Error => {
                            if error__.is_some() {
                                return Err(serde::de::Error::duplicate_field("error"));
                            }
                            error__ = Some(map_.next_value()?);
                        }
                        GeneratedField::CallStatusCode => {
                            if call_status_code__.is_some() {
                                return Err(serde::de::Error::duplicate_field("callStatusCode"));
                            }
                            call_status_code__ = map_.next_value()?;
                        }
                        GeneratedField::AudioCodec => {
                            if audio_codec__.is_some() {
                                return Err(serde::de::Error::duplicate_field("audioCodec"));
                            }
                            audio_codec__ = Some(map_.next_value()?);
                        }
                        GeneratedField::MediaEncryption => {
                            if media_en