/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import java.util.Collection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.ui.IProgressControlProvider;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.itemlist.ItemListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.NodeListControl;
import org.jkiss.utils.CommonUtils;

class TabbedFolderPageNode
extends TabbedFolderPage
implements ISearchContextProvider,
IRefreshablePart,
INavigatorModelView,
DBPAdaptable {
    private final IDatabaseEditor mainEditor;
    private final DBNNode node;
    private final DBXTreeNode metaNode;
    private ItemListControl itemControl;
    private boolean activated;

    TabbedFolderPageNode(IDatabaseEditor mainEditor, DBNNode node, DBXTreeNode metaNode) {
        this.mainEditor = mainEditor;
        this.node = node;
        this.metaNode = metaNode;
    }

    public void setFocus() {
        if (this.itemControl != null) {
            this.itemControl.setFocus();
        }
    }

    public void createControl(Composite parent) {
        this.itemControl = new ItemListControl(parent, 0x10000000, (IWorkbenchSite)this.mainEditor.getSite(), this.node, this.metaNode);
        ProgressPageControl progressControl = null;
        if (this.mainEditor instanceof IProgressControlProvider) {
            progressControl = ((IProgressControlProvider)this.mainEditor).getProgressControl();
        }
        if (progressControl != null) {
            this.itemControl.substituteProgressPanel(progressControl);
        } else {
            this.itemControl.createProgressPanel();
        }
        parent.layout();
        Control nodeItemsViewer = this.itemControl.getItemsViewer().getControl();
        nodeItemsViewer.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MultiPageEditorPart multiPageEditor;
                NodeListControl.NodeSelectionProvider selectionProvider = TabbedFolderPageNode.this.itemControl.getSelectionProvider();
                if (TabbedFolderPageNode.this.mainEditor.getSite().getSelectionProvider() != selectionProvider) {
                    TabbedFolderPageNode.this.mainEditor.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
                    selectionProvider.setSelection(selectionProvider.getSelection());
                }
                TabbedFolderPageNode.this.itemControl.activate(true);
                if (TabbedFolderPageNode.this.mainEditor.getSite() instanceof MultiPageEditorSite && (multiPageEditor = ((MultiPageEditorSite)TabbedFolderPageNode.this.mainEditor.getSite()).getMultiPageEditor()).getSelectedPage() != TabbedFolderPageNode.this.mainEditor) {
                    multiPageEditor.setActiveEditor((IEditorPart)TabbedFolderPageNode.this.mainEditor);
                }
            }

            public void focusLost(FocusEvent e) {
                TabbedFolderPageNode.this.itemControl.activate(false);
            }
        });
        Accessible accessible = nodeItemsViewer.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new FolderAccessibleAdapter());
    }

    public void aboutToBeShown() {
        if (!this.activated) {
            this.activated = true;
            boolean isLazy = !(this.node instanceof DBNDatabaseNode) || ((DBNDatabaseNode)this.node).needsInitialization();
            this.itemControl.loadData(isLazy);
        }
    }

    public void aboutToBeHidden() {
    }

    public IEditorInput getEditorInput() {
        return this.mainEditor.getEditorInput();
    }

    public boolean isSearchPossible() {
        return this.itemControl.isSearchPossible();
    }

    public boolean isSearchEnabled() {
        return this.itemControl.isSearchEnabled();
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        return this.itemControl.performSearch(searchType);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        if (!this.activated || this.itemControl == null || this.itemControl.isDisposed()) {
            return IRefreshablePart.RefreshResult.IGNORED;
        }
        boolean loadNewData = true;
        if (!force && source instanceof DBNEvent) {
            DBNEvent event = (DBNEvent)source;
            DBNEvent.NodeChange nodeChange = event.getNodeChange();
            if (event.getAction() == DBNEvent.Action.UPDATE && nodeChange == DBNEvent.NodeChange.REFRESH) {
                loadNewData = this.isRefreshingEvent(event);
            } else if (nodeChange == DBNEvent.NodeChange.UNLOAD) {
                loadNewData = false;
            }
        }
        if (loadNewData) {
            this.itemControl.loadData(false);
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    private boolean isRefreshingEvent(DBNEvent event) {
        if (event.getSource() == DBNEvent.UPDATE_ON_SAVE) {
            return true;
        }
        if (!(event.getSource() instanceof DBPEvent)) {
            return false;
        }
        DBPEvent dbEvent = (DBPEvent)event.getSource();
        if (dbEvent.getData() == DBPEvent.REORDER) {
            DBNNode rootNode = this.getRootNode();
            return rootNode instanceof DBNDatabaseNode && dbEvent.getObject() == ((DBNDatabaseNode)rootNode).getValueObject();
        }
        Object itemsInput = this.itemControl.getItemsViewer().getInput();
        return itemsInput instanceof Collection && ((Collection)itemsInput).contains(dbEvent.getObject());
    }

    @Override
    public DBNNode getRootNode() {
        return this.itemControl.getRootNode();
    }

    @Override
    public Viewer getNavigatorViewer() {
        return this.itemControl.getNavigatorViewer();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.itemControl == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.itemControl.getClass())) {
            return adapter.cast(this.itemControl);
        }
        return null;
    }

    private class FolderAccessibleAdapter
    extends AccessibleControlAdapter
    implements AccessibleListener {
        private FolderAccessibleAdapter() {
        }

        public void getName(AccessibleEvent e) {
            if (e.childID == -1) {
                e.result = (String)CommonUtils.notNull((Object)TabbedFolderPageNode.this.node.getNodeDescription(), (Object)TabbedFolderPageNode.this.node.getName());
            }
        }

        public void getDescription(AccessibleEvent e) {
            if (e.childID == -1) {
                e.result = TabbedFolderPageNode.this.node.getNodeDescription();
            }
        }

        public void getHelp(AccessibleEvent e) {
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
        }

        public void getDefaultAction(AccessibleControlEvent e) {
        }

        public void getFocus(AccessibleControlEvent e) {
            e.childID = -1;
        }

        public void getRole(AccessibleControlEvent e) {
            int childID = e.childID;
            int role = childID == -1 ? 60 : 37;
            e.detail = role;
        }

        public void getState(AccessibleControlEvent e) {
            int state = 0;
            int childID = e.childID;
            if (childID == -1) {
                state = 0;
            } else {
                state = 0x200000;
                if (TabbedFolderPageNode.this.itemControl.getItemsViewer().getControl().isFocusControl()) {
                    state |= 0x100000;
                }
                if (!TabbedFolderPageNode.this.itemControl.getItemsViewer().getSelection().isEmpty() && ((state |= 2) & 0x100000) != 0) {
                    state |= 4;
                }
            }
            e.detail = state;
        }
    }

    private class FolderSimpleAccessibleAdapter
    extends AccessibleAdapter {
        private FolderSimpleAccessibleAdapter() {
        }

        public void getName(AccessibleEvent e) {
            if (e.childID == -1) {
                e.result = (String)CommonUtils.notNull((Object)TabbedFolderPageNode.this.node.getNodeDescription(), (Object)TabbedFolderPageNode.this.node.getName());
            }
        }
    }
}

