/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.cockroach;

import java.sql.ResultSet;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CockroachSequence
extends PostgreSequence {
    private static final Log log = Log.getLog(CockroachSequence.class);

    public CockroachSequence(PostgreSchema schema, JDBCResultSet dbResult) {
        super(schema, dbResult);
    }

    public CockroachSequence(PostgreSchema catalog) {
        super(catalog);
    }

    @Override
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    public void loadAdditionalInfo(DBRProgressMonitor monitor) {
        JDBCResultSet seqResults;
        Object var10_22;
        Throwable throwable;
        JDBCPreparedStatement dbSeqStat;
        Object var7_15;
        Throwable throwable2;
        JDBCSession session;
        Object var4_8;
        PostgreSequence.AdditionalInfo additionalInfo = this.getAdditionalInfo();
        try {
            Throwable throwable3 = null;
            var4_8 = null;
            try {
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load sequence additional info");
                try {
                    throwable2 = null;
                    var7_15 = null;
                    try {
                        dbSeqStat = session.prepareStatement("SELECT * from information_schema.\"sequences\" WHERE sequence_schema=? AND sequence_name=?");
                        try {
                            dbSeqStat.setString(1, this.getSchema().getName());
                            dbSeqStat.setString(2, this.getName());
                            throwable = null;
                            var10_22 = null;
                            try {
                                seqResults = dbSeqStat.executeQuery();
                                try {
                                    if (seqResults.next()) {
                                        additionalInfo.setStartValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"start_value"));
                                        additionalInfo.setMinValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"minimum_value"));
                                        additionalInfo.setMaxValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"maximum_value"));
                                        additionalInfo.setIncrementBy(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"increment"));
                                    }
                                }
                                finally {
                                    if (seqResults != null) {
                                        seqResults.close();
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            if (dbSeqStat != null) {
                                dbSeqStat.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable3 == null) {
                    throwable3 = throwable6;
                } else if (throwable3 != throwable6) {
                    throwable3.addSuppressed(throwable6);
                }
                throw throwable3;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error reading sequence values", (Throwable)e);
        }
        try {
            Throwable e = null;
            var4_8 = null;
            try {
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load sequence last value");
                try {
                    throwable2 = null;
                    var7_15 = null;
                    try {
                        dbSeqStat = session.prepareStatement("SELECT * from " + this.getFullyQualifiedName(DBPEvaluationContext.DML));
                        try {
                            throwable = null;
                            var10_22 = null;
                            try {
                                seqResults = dbSeqStat.executeQuery();
                                try {
                                    if (seqResults.next()) {
                                        additionalInfo.setLastValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"last_value"));
                                    }
                                }
                                finally {
                                    if (seqResults != null) {
                                        seqResults.close();
                                    }
                                }
                            }
                            catch (Throwable throwable7) {
                                if (throwable == null) {
                                    throwable = throwable7;
                                } else if (throwable != throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            if (dbSeqStat != null) {
                                dbSeqStat.close();
                            }
                        }
                    }
                    catch (Throwable throwable8) {
                        if (throwable2 == null) {
                            throwable2 = throwable8;
                        } else if (throwable2 != throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                        throw throwable2;
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable throwable9) {
                if (e == null) {
                    e = throwable9;
                } else if (e != throwable9) {
                    e.addSuppressed(throwable9);
                }
                throw e;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error reading sequence las value", (Throwable)e);
        }
        additionalInfo.setLoaded(true);
    }

    @Override
    public boolean supportsCacheAndCycle() {
        return false;
    }
}

