/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.messagebackup;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.messagebackup.MessageBackup;
import org.signal.libsignal.messagebackup.ValidationError;

public class OnlineBackupValidator
extends NativeHandleGuard.SimpleOwner
implements AutoCloseable {
    public OnlineBackupValidator(byte[] backupInfo, MessageBackup.Purpose purpose) throws ValidationError {
        super(FilterExceptions.filterExceptions(ValidationError.class, () -> Native.OnlineBackupValidator_New(backupInfo, purpose.ordinal())));
    }

    @Override
    protected void release(long nativeHandle) {
        Native.OnlineBackupValidator_Destroy(nativeHandle);
    }

    public void addFrame(byte[] frame) throws ValidationError {
        FilterExceptions.filterExceptions(ValidationError.class, () -> this.guardedRunChecked(h -> Native.OnlineBackupValidator_AddFrame(h, frame)));
    }

    @Override
    public void close() throws ValidationError {
        FilterExceptions.filterExceptions(ValidationError.class, () -> this.guardedRunChecked(h -> Native.OnlineBackupValidator_Finalize(h)));
    }
}

