/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.messagebackup;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.messagebackup.BackupForwardSecrecyToken;
import org.signal.libsignal.messagebackup.BackupKey;
import org.signal.libsignal.protocol.ServiceId;

public class MessageBackupKey
extends NativeHandleGuard.SimpleOwner {
    private MessageBackupKey(long nativeHandle) {
        super(nativeHandle);
    }

    public MessageBackupKey(String accountEntropy, ServiceId.Aci aci) {
        this(accountEntropy, aci, null);
    }

    public MessageBackupKey(String accountEntropy, ServiceId.Aci aci, BackupForwardSecrecyToken token) {
        super(Native.MessageBackupKey_FromAccountEntropyPool(accountEntropy, aci.toServiceIdFixedWidthBinary(), token == null ? null : token.getInternalContentsForJNI()));
    }

    public MessageBackupKey(BackupKey backupKey, byte[] backupId) {
        this(backupKey, backupId, null);
    }

    public MessageBackupKey(BackupKey backupKey, byte[] backupId, BackupForwardSecrecyToken token) {
        super(Native.MessageBackupKey_FromBackupKeyAndBackupId(backupKey.getInternalContentsForJNI(), backupId, token == null ? null : token.getInternalContentsForJNI()));
    }

    public static MessageBackupKey fromParts(byte[] hmacKey, byte[] aesKey) {
        return new MessageBackupKey(Native.MessageBackupKey_FromParts(hmacKey, aesKey));
    }

    @Override
    protected void release(long nativeHandle) {
        Native.MessageBackupKey_Destroy(nativeHandle);
    }

    public byte[] getHmacKey() {
        return this.guardedMap(Native::MessageBackupKey_GetHmacKey);
    }

    public byte[] getAesKey() {
        return this.guardedMap(Native::MessageBackupKey_GetAesKey);
    }
}

