/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.recipients;

import java.util.Objects;
import org.asamk.signal.manager.storage.recipients.RecipientStore;

public final class RecipientId {
    private long id;
    private final RecipientStore recipientStore;

    RecipientId(long id, RecipientStore recipientStore) {
        this.id = id;
        this.recipientStore = recipientStore;
    }

    public long id() {
        long actualRecipientId;
        if (this.recipientStore != null && (actualRecipientId = this.recipientStore.getActualRecipientId(this.id)) != this.id) {
            this.id = actualRecipientId;
        }
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RecipientId that = (RecipientId)obj;
        return this.id() == that.id();
    }

    public int hashCode() {
        return Objects.hash(this.id());
    }

    public String toString() {
        return "RecipientId[id=" + this.id() + "]";
    }
}

