/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.protocol;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class LegacyJsonPreKeyStore {
    private final Map<Integer, byte[]> preKeys;

    private LegacyJsonPreKeyStore(Map<Integer, byte[]> preKeys) {
        this.preKeys = preKeys;
    }

    public Map<Integer, byte[]> getPreKeys() {
        return this.preKeys;
    }

    public static class JsonPreKeyStoreDeserializer
    extends JsonDeserializer<LegacyJsonPreKeyStore> {
        public LegacyJsonPreKeyStore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            HashMap<Integer, byte[]> preKeyMap = new HashMap<Integer, byte[]>();
            if (node.isArray()) {
                for (JsonNode preKey : node) {
                    int preKeyId = preKey.get("id").asInt();
                    byte[] preKeyRecord = Base64.getDecoder().decode(preKey.get("record").asText());
                    preKeyMap.put(preKeyId, preKeyRecord);
                }
            }
            return new LegacyJsonPreKeyStore(preKeyMap);
        }
    }
}

