// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Base inference parameters to pass to a model in a call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
/// <p>If you need to pass additional parameters that the model supports, use the <code>additionalModelRequestFields</code> request field in the call to <code>Converse</code> or <code>ConverseStream</code>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model parameters</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct InferenceConfiguration {
    /// <p>The maximum number of tokens to allow in the generated response. The default value is the maximum allowed value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub max_tokens: ::std::option::Option<i32>,
    /// <p>The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub temperature: ::std::option::Option<f32>,
    /// <p>The percentage of most-likely candidates that the model considers for the next token. For example, if you choose a value of 0.8 for <code>topP</code>, the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub top_p: ::std::option::Option<f32>,
    /// <p>A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.</p>
    pub stop_sequences: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
}
impl InferenceConfiguration {
    /// <p>The maximum number of tokens to allow in the generated response. The default value is the maximum allowed value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn max_tokens(&self) -> ::std::option::Option<i32> {
        self.max_tokens
    }
    /// <p>The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn temperature(&self) -> ::std::option::Option<f32> {
        self.temperature
    }
    /// <p>The percentage of most-likely candidates that the model considers for the next token. For example, if you choose a value of 0.8 for <code>topP</code>, the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn top_p(&self) -> ::std::option::Option<f32> {
        self.top_p
    }
    /// <p>A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.stop_sequences.is_none()`.
    pub fn stop_sequences(&self) -> &[::std::string::String] {
        self.stop_sequences.as_deref().unwrap_or_default()
    }
}
impl InferenceConfiguration {
    /// Creates a new builder-style object to manufacture [`InferenceConfiguration`](crate::types::InferenceConfiguration).
    pub fn builder() -> crate::types::builders::InferenceConfigurationBuilder {
        crate::types::builders::InferenceConfigurationBuilder::default()
    }
}

/// A builder for [`InferenceConfiguration`](crate::types::InferenceConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct InferenceConfigurationBuilder {
    pub(crate) max_tokens: ::std::option::Option<i32>,
    pub(crate) temperature: ::std::option::Option<f32>,
    pub(crate) top_p: ::std::option::Option<f32>,
    pub(crate) stop_sequences: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
}
impl InferenceConfigurationBuilder {
    /// <p>The maximum number of tokens to allow in the generated response. The default value is the maximum allowed value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn max_tokens(mut self, input: i32) -> Self {
        self.max_tokens = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum number of tokens to allow in the generated response. The default value is the maximum allowed value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn set_max_tokens(mut self, input: ::std::option::Option<i32>) -> Self {
        self.max_tokens = input;
        self
    }
    /// <p>The maximum number of tokens to allow in the generated response. The default value is the maximum allowed value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn get_max_tokens(&self) -> &::std::option::Option<i32> {
        &self.max_tokens
    }
    /// <p>The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn temperature(mut self, input: f32) -> Self {
        self.temperature = ::std::option::Option::Some(input);
        self
    }
    /// <p>The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn set_temperature(mut self, input: ::std::option::Option<f32>) -> Self {
        self.temperature = input;
        self
    }
    /// <p>The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn get_temperature(&self) -> &::std::option::Option<f32> {
        &self.temperature
    }
    /// <p>The percentage of most-likely candidates that the model considers for the next token. For example, if you choose a value of 0.8 for <code>topP</code>, the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn top_p(mut self, input: f32) -> Self {
        self.top_p = ::std::option::Option::Some(input);
        self
    }
    /// <p>The percentage of most-likely candidates that the model considers for the next token. For example, if you choose a value of 0.8 for <code>topP</code>, the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn set_top_p(mut self, input: ::std::option::Option<f32>) -> Self {
        self.top_p = input;
        self
    }
    /// <p>The percentage of most-likely candidates that the model considers for the next token. For example, if you choose a value of 0.8 for <code>topP</code>, the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.</p>
    /// <p>The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>
    pub fn get_top_p(&self) -> &::std::option::Option<f32> {
        &self.top_p
    }
    /// Appends an item to `stop_sequences`.
    ///
    /// To override the contents of this collection use [`set_stop_sequences`](Self::set_stop_sequences).
    ///
    /// <p>A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.</p>
    pub fn stop_sequences(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.stop_sequences.unwrap_or_default();
        v.push(input.into());
        self.stop_sequences = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.</p>
    pub fn set_stop_sequences(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.stop_sequences = input;
        self
    }
    /// <p>A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.</p>
    pub fn get_stop_sequences(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.stop_sequences
    }
    /// Consumes the builder and constructs a [`InferenceConfiguration`](crate::types::InferenceConfiguration).
    pub fn build(self) -> crate::types::InferenceConfiguration {
        crate::types::InferenceConfiguration {
            max_tokens: self.max_tokens,
            temperature: self.temperature,
            top_p: self.top_p,
            stop_sequences: self.stop_sequences,
        }
    }
}
