#!/usr/bin/env python
# coding=utf-8

##    Qemulator - a qemu gui written in python and GTK/Glade.
##    Copyright (C) 2006  rainer haage
##
##    This program is free software; you can redistribute it and/or
##    modify it under the terms of the GNU General Public License
##    as published by the Free Software Foundation; either version 2
##    of the License, or (at your option) any later version.
##    
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##    
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
from os import path
import os
import sys
import string
import pickle
from copy import copy
import time
import gobject
import qemulator
import qml_tools
from qml_imagecreation import CreateImage

try:
    import pygtk
    pygtk.require("2.0")
    
except:
      print "pygtk 2.0 is not installed"
try:
    import gtk
    import gtk.glade
    
except:
    print "gtk and/or glade is not installed - exiting..."
    sys.exit(1)
    
try:
    import gettext
    import locale
except:
    print "locale and/or gettext for language support not installed"
    sys.exit(1)        
    
current_path = os.path.realpath(__file__)
basedir = os.path.dirname(os.path.realpath(__file__))
if not os.path.exists(os.path.join(basedir, "main.py")):
    if os.path.exists(os.path.join(os.getcwd(), "main.py")):
        basedir = os.getcwd()
sys.path.insert(0, basedir)   

basedir = basedir.replace ( '/bin', '' ) 
basedir = basedir.replace ( '/lib/qemulator', '' )
pixmapdir = basedir + "/share/pixmaps/qemulator"

APP = 'Qemulator'
#DIR = 'locale'
DIR = basedir + '/share/locale'
#print "DIR: " + DIR
locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain(APP, DIR)
gettext.textdomain(APP)
_ = gettext.gettext

gtk.glade.bindtextdomain(APP, DIR)
gtk.glade.textdomain(APP)
tooltips = gtk.Tooltips() 

homedir = os.path.expanduser('~/.qemulator')
configdir = homedir + "/config"
libdir = basedir + "/lib/qemulator"    
   
class Machinesetup:
    def __init__(self, qemulator_instance, init_image=None, callback_func=None):
        self.basedir = basedir 
        self.sharedir = self.basedir + "/share/qemulator"
        self.homedir = os.path.expanduser('~/.qemulator')
        self.icondirs = [self.sharedir + "/icons",self.homedir + "/icons"]
        self.default_machine_icon = self.icondirs[0] + "/default.png"
        self.pixmapdir = pixmapdir
        self.qemulator_instance = qemulator_instance
        self.imagespath = qemulator_instance.imagespath
        self.callback_func = callback_func
        #self.newimagetarget = None
        self.gladefile = libdir + "/qemulator.glade"
        self.sighandlers = {}
        self.traypop = None
        #self.traypop.alive = False
        self.advancedmode = False
        #self.installname = None
        #self.currentimage = None
        self.bootimage = None
        self.installsystem = None
        self.bookmarkname = None
        self.hdcmode = 'hdc'
        self.bootvolume = 'hda'
        self.qemubin = None
        self.image_hdchandle = None
        self.statushints = {}
        #self.currimage_settings = qemulator.QemuConfig() 
        self.init_image = init_image        
        if self.init_image != None:
             #self.bootimage = self.init_image
             self.currimage_settings = copy(self.qemulator_instance.currimage_settings)
        else:
            self.currimage_settings = qemulator.QemuConfig() 
                         


        
        self.init_gui()        

    def init_gui(self):
        #GoOn = False
        #mode = "add"
#        if self.init_image != None:
#             self.bootimage = self.init_image
                     
        self.wTree = gtk.glade.XML(self.gladefile, "dialog_bookmarks", APP)
        self.dialog_bookmarks_widget = self.wTree.get_widget("dialog_bookmarks")
        self.dialog_bookmarks_widget.set_keep_above(True) 
        
        self.labelStatusmessage = self.wTree.get_widget("labelStatusmessage")
        self.labelStatusName = self.wTree.get_widget("labelStatusName")
        self.labelStatusMachine = self.wTree.get_widget("labelStatusMachine")
        self.labelStatusBootmedium = self.wTree.get_widget("labelStatusBootmedium")
        
        self.entry_bookmark_name = self.wTree.get_widget("entry_bookmark_name")
        self.notebook_bookmarks = self.wTree.get_widget("notebook_bookmarks")
        self.entry_bookmark_path = self.wTree.get_widget("entry_bookmark_path")               
        self.filechooserbutton_machine_icon = self.wTree.get_widget("filechooserbutton_machine_icon")
        self.image_iconpreview = self.wTree.get_widget("image_iconpreview")
        
        self.frame_imageboot = self.wTree.get_widget("frame_imageboot")
        self.frameDlinuxboot = self.wTree.get_widget("frameDlinuxboot")
        
        self.comboboxEmusystem = self.wTree.get_widget("comboboxEmusystem")
        self.comboboxEmusystemQuick = self.wTree.get_widget("comboboxEmusystemQuick")
        
        self.comboboxMachinetype = self.wTree.get_widget("comboboxMachinetype")
        self.spinbuttonMemory = self.wTree.get_widget("spinbuttonMemory")
        
        
        self.spinbuttonMemoryQuick = self.wTree.get_widget("spinbuttonMemoryQuick")
        
        self.iconHDC = self.wTree.get_widget("iconHDC")
        
        self.filechooserbuttonHDA = self.wTree.get_widget("filechooserbuttonHDA")
        self.filechooserbuttonHDB = self.wTree.get_widget("filechooserbuttonHDB")
        self.filechooserbuttonHDC = self.wTree.get_widget("filechooserbuttonHDC")
        self.filechooserbuttonHDD = self.wTree.get_widget("filechooserbuttonHDD")
        self.filechooserbuttonFDA = self.wTree.get_widget("filechooserbuttonFDA")
        self.filechooserbuttonFDB = self.wTree.get_widget("filechooserbuttonFDB")
                
        self.filechooserbuttonHDA.set_current_folder(self.qemulator_instance.settings["imagespath"])
        self.filechooserbuttonHDB.set_current_folder(self.qemulator_instance.settings["imagespath"])
        self.filechooserbuttonHDC.set_current_folder(self.qemulator_instance.settings["imagespath"])
        self.filechooserbuttonHDD.set_current_folder(self.qemulator_instance.settings["imagespath"])
        self.filechooserbuttonFDA.set_current_folder(self.qemulator_instance.settings["imagespath"])
        self.filechooserbuttonFDB.set_current_folder(self.qemulator_instance.settings["imagespath"])
        
        self.button_create_HDA = self.wTree.get_widget("button_create_HDA")        
        self.button_create_HDB = self.wTree.get_widget("button_create_HDB")
        self.button_create_HDC = self.wTree.get_widget("button_create_HDC")
        self.button_create_HDD = self.wTree.get_widget("button_create_HDD")
        self.button_create_FDA = self.wTree.get_widget("button_create_FDA")
        self.button_create_FDB = self.wTree.get_widget("button_create_FDB")
        
        self.sighandlers['self.button_create_HDA'] = self.button_create_HDA.connect("button_press_event",  self.init_bookmark_image, self.return_created_HDA_image)
        self.sighandlers['self.button_create_HDB'] = self.button_create_HDB.connect("button_press_event",  self.init_bookmark_image, self.return_created_HDB_image)
        self.sighandlers['self.button_create_HDC'] = self.button_create_HDC.connect("button_press_event",  self.init_bookmark_image, self.return_created_HDC_image)
        self.sighandlers['self.button_create_HDD'] = self.button_create_HDD.connect("button_press_event",  self.init_bookmark_image, self.return_created_HDD_image)
        self.sighandlers['self.button_create_FDA'] = self.button_create_FDA.connect("button_press_event",  self.init_bookmark_image, self.return_created_FDA_image)
        self.sighandlers['self.button_create_FDB'] = self.button_create_FDB.connect("button_press_event",  self.init_bookmark_image, self.return_created_FDB_image)        
        
        self.button_eject_hda = self.wTree.get_widget("button_eject_hda")
        self.button_eject_hdb = self.wTree.get_widget("button_eject_hdb")
        self.button_eject_hdc = self.wTree.get_widget("button_eject_hdc")
        self.button_eject_hdd = self.wTree.get_widget("button_eject_hdd")
        self.button_eject_fda = self.wTree.get_widget("button_eject_fda")
        self.button_eject_fdb = self.wTree.get_widget("button_eject_fdb")
        
        self.radiobuttonBootHDA = self.wTree.get_widget("radiobuttonBootHDA")
        self.radiobuttonBootHDC = self.wTree.get_widget("radiobuttonBootHDC")
        self.comboboxMediatypeHDC = self.wTree.get_widget("comboboxMediatypeHDC")
        self.comboboxMediatypeHDC.set_active(0)
        self.radiobuttonBootFDA = self.wTree.get_widget("radiobuttonBootFDA")
        self.radiobuttonBootDlinux = self.wTree.get_widget("radiobuttonBootDlinux")
        
        self.expanderCDrom = self.wTree.get_widget("expanderCDrom")
        self.comboboxCDromdrive = self.wTree.get_widget("comboboxCDromdrive")
        self.comboboxCDromdriveQuick = self.wTree.get_widget("comboboxCDromdriveQuick")
        self.set_model_comboboxCDromdrive()
        
        self.comboboxImagedevice = self.wTree.get_widget("comboboxImagedevice")
        self.checkbuttonCDromdriveQuick = self.wTree.get_widget("checkbuttonCDromdriveQuick")
        self.filechooserbuttonKernelimage = self.wTree.get_widget("filechooserbuttonKernelimage")
        self.filechooserbuttonInitrd = self.wTree.get_widget("filechooserbuttonInitrd")
        self.entryKernelcmd = self.wTree.get_widget("entryKernelcmd")
        self.okbutton = self.wTree.get_widget("okbutton")
        
        Name = self.entry_bookmark_name.get_text()
        Path = self.entry_bookmark_path.get_text()
        response = self.add_bookmark_response        
        dic = {"on_dialog_bookmarks_response" : response
               , "on_notebook_bookmarks_switch_page" : self.on_notebook_bookmarks_switch_page
               , "on_entry_bookmark_name_changed" : self.on_entry_bookmark_name_changed
               #"on_buttonSelectNewbootimage_clicked" : self.init_create_image,
               ,"on_buttonNewmachineBootimage_clicked" : self.fileChooser_bootimage
               ,"on_filechooserbutton_machine_icon_selection_changed" : self.update_bm_iconprev
               
               , "on_entry_bookmark_path_changed" : self.on_entry_bookmark_path_changed
               , "on_comboboxEmusystem_changed" : self.comboboxEmusystem_changed
               , "on_comboboxEmusystemQuick_changed" : self.on_comboboxEmusystemQuick_changed
               , "on_comboboxMachinetype_changed" : self.on_comboboxMachinetype_changed
               , "on_spinbuttonMemory_changed" : self.on_spinbuttonMemory_changed
               , "on_spinbuttonMemoryQuick_changed" : self.on_spinbuttonMemoryQuick_changed
               
               
               , "on_button_eject_hda_clicked" : self.clear_filechooser
               , "on_button_eject_hdb_clicked" : self.clear_filechooser
               , "on_button_eject_hdc_clicked" : self.clear_filechooser
               , "on_button_eject_hdd_clicked" : self.clear_filechooser
               , "on_button_eject_fda_clicked" : self.clear_filechooser
               , "on_button_eject_fdb_clicked" : self.clear_filechooser
               , "on_comboboxMediatypeHDC_changed" : self.on_comboboxMediatypeHDC_changed  
               , "on_expanderCDrom_activate" : self.on_expanderCDrom_activate  
               , "on_comboboxImagedevice_changed" : self.on_comboboxImagedevice_changed
               , "on_radiobuttonBootHDA_toggled" : self.on_radiobuttonBootHDA_toggled
               , "on_radiobuttonBootHDC_toggled" : self.on_radiobuttonBootHDC_toggled
               , "on_radiobuttonBootFDA_toggled" : self.on_radiobuttonBootFDA_toggled
               , "on_radiobuttonBootDlinux_toggled" : self.on_radiobuttonBootDlinux_toggled
               
               , "on_filechooserbuttonHDA_selection_changed" : self.on_filechooserbuttonHDA_selection_changed
               , "on_filechooserbuttonHDB_selection_changed" : self.on_filechooserbuttonHDB_selection_changed
               , "on_filechooserbuttonHDC_selection_changed" : self.on_filechooserbuttonHDC_selection_changed
               , "on_filechooserbuttonHDD_selection_changed" : self.on_filechooserbuttonHDD_selection_changed
               , "on_filechooserbuttonFDA_selection_changed" : self.on_filechooserbuttonFDA_selection_changed
               , "on_filechooserbuttonFDB_selection_changed" : self.on_filechooserbuttonFDB_selection_changed
               , "on_comboboxCDromdrive_changed" : self.on_comboboxCDromdrive_changed
               , "on_comboboxCDromdriveQuick_changed" : self.on_comboboxCDromdriveQuick_changed
               , "on_checkbuttonCDromdriveQuick_toggled" : self.on_checkbuttonCDromdriveQuick_toggled
               , "on_filechooserbuttonKernelimage_selection_changed" : self.on_filechooserbuttonKernelimage_selection_changed
               , "on_filechooserbuttonInitrd_selection_changed" : self.on_filechooserbuttonInitrd_selection_changed
               , "on_entryKernelcmd_changed" : self.on_entryKernelcmd_changed
               
        }
        self.wTree.signal_autoconnect(dic)
        

        #eventbox.connect("button_press_event", self.on_tray_button_press_event)
 
        
        
        iconpath = path.abspath(self.default_machine_icon)
        self.filechooserbutton_machine_icon.set_filename(iconpath)
        self.set_model_comboboxEmusystem()
        #self.comboboxImagedevice.set_active(0)
        if self.init_image != None:
             #self.bootimage = self.init_image
             #self.currimage_settings = self.qemulator_instance.currimage_settings
             self.entry_bookmark_path.set_text(str(self.init_image))
             self.notebook_bookmarks.set_current_page(1)
#             self.set_initial_system()
             #self.set_bookmark_boottype(self.bootimage)

        self.dialog_bookmarks_widget.show()
        
    def set_initial_system(self):
        ## setup emusystem
        self.notebook_bookmarks.set_current_page(1)
        self.currimage_settings = self.qemulator_instance.currimage_settings
        #self.get_final_machine()
        if self.currimage_settings.emusystem == "":    
            self.currimage_settings.emusystem = str(self.comboboxEmusystem.get_active())           
        self.qemubin = self.qemulator_instance.emusystem_path_by_name(self.currimage_settings.emusystem)
        find_emusystem = self.qemulator_instance.search_combolist(self.comboboxEmusystem, self.currimage_settings.emusystem)
        if find_emusystem != None:
            self.comboboxEmusystem.set_active(find_emusystem)    
        else:
            self.comboboxEmusystem.set_active(0)
            self.comboboxEmusystem_changed(self.comboboxEmusystem)
            
        self.machinecommand = self.qemulator_instance.machine_path_by_name(self.currimage_settings.machine) 
        find_machine = self.qemulator_instance.search_combolist(self.comboboxMachinetype, self.currimage_settings.machine)
        if find_machine != None:
            self.comboboxMachinetype.set_active(find_machine)
        else:
            self.get_machine()
            self.comboboxMachinetype.set_active(0)
            self.on_comboboxMachinetype_changed(self.comboboxMachinetype)
            
        if self.currimage_settings.hda_image != None and path.isfile(self.currimage_settings.hda_image): 
            #gtk.gdk.threads_enter()
            self.filechooserbuttonHDA.set_filename(str(self.currimage_settings.hda_image))
            #print "hda_image: " + str(self.currimage_settings.hda_image)  
            #gtk.gdk.threads_leave()
        elif self.currimage_settings.bootmedium == 'hda' and path.isfile(self.currimage_settings.main_image):
            #print 'main_image: ' + str(self.currimage_settings.main_image)
            self.currimage_settings.hda_image = self.currimage_settings.main_image
            self.filechooserbuttonHDA.set_filename(path.abspath(self.currimage_settings.hda_image))
        else:
            self.filechooserbuttonHDA.set_current_folder(self.qemulator_instance.settings["imagespath"])          
        if self.currimage_settings.hdb_image != None and path.isfile(self.currimage_settings.hdb_image):
            self.filechooserbuttonHDB.set_filename(path.abspath(self.currimage_settings.hdb_image))
        else:
            self.filechooserbuttonHDB.set_current_folder(self.qemulator_instance.settings["imagespath"])
        if self.currimage_settings.hdc_image != None and path.isfile(self.currimage_settings.hdc_image):
            self.currimage_settings.cdrimage = None
            self.currimage_settings.cdrmedium = None
            #print 'hdc_image: ' + str(self.currimage_settings.hdc_image)
            self.filechooserbuttonHDC.set_filename(path.abspath(self.currimage_settings.hdc_image))
            self.comboboxMediatypeHDC.set_active(0)
            self.hdcmode = 'hdc'
            self.expanderCDrom.hide()
        elif self.currimage_settings.cdrmedium != None:
            self.currimage_settings.hdc_image = None
            self.currimage_settings.cdrimage = None 
            self.currimage_settings.cdrmode = 'mount'
            print 'cdrmedium: ' + str(self.currimage_settings.cdrmedium)
            self.hdcmode = 'cdrom'
            self.expanderCDrom.show()
            find_cdrmedium = self.qemulator_instance.search_combolist(self.comboboxCDromdrive, self.currimage_settings.cdrmedium)
            self.expanderCDrom.set_expanded(True)
            self.comboboxCDromdrive.set_active(find_cdrmedium)
            #self.filechooserbuttonHDC.set_filename(path.abspath(self.currimage_settings.cdrimage))
            self.comboboxMediatypeHDC.set_active(1)            
        elif self.currimage_settings.cdrimage != None and path.isfile(self.currimage_settings.cdrimage):
            self.currimage_settings.hdc_image = None
            self.currimage_settings.cdrmedium = None 
            self.currimage_settings.cdrmode = 'image'
            #print 'cdrimage: ' + str(self.currimage_settings.cdrimage)
            self.hdcmode = 'cdrom'
            self.expanderCDrom.show()
            self.expanderCDrom.set_expanded(False)
            self.filechooserbuttonHDC.set_filename(path.abspath(self.currimage_settings.cdrimage))
            self.comboboxMediatypeHDC.set_active(1)
        elif self.currimage_settings.bootmedium == 'cdrom' and path.isfile(self.currimage_settings.main_image):
            #print 'main_image: ' + str(self.currimage_settings.main_image)
            self.currimage_settings.cdrimage = self.currimage_settings.main_image
            self.currimage_settings.hdc_image = None
            self.currimage_settings.cdrmedium = None  
            self.currimage_settings.cdrmode = 'image'    
            self.comboboxMediatypeHDC.set_active(1)    
            self.hdcmode = 'cdrom'                            
            self.filechooserbuttonHDC.set_filename(path.abspath(self.currimage_settings.cdrimage))
            self.expanderCDrom.show()
            self.expanderCDrom.set_expanded(False)
        else:
            #print 'no hdc_image: ' + str(self.currimage_settings.hdc_image)
            #print 'no cdrimage: ' + str(self.currimage_settings.cdrimage)
            self.comboboxMediatypeHDC.set_active(0)
            self.hdcmode = 'hdc'
            self.expanderCDrom.hide()
            self.expanderCDrom.set_expanded(False)
            self.filechooserbuttonHDC.set_current_folder(self.qemulator_instance.settings["imagespath"]) 
        if self.currimage_settings.cdrmedium != None:
            find_cdrmedium = self.qemulator_instance.search_combolist(self.comboboxCDromdrive, self.currimage_settings.cdrmedium)
            if find_cdrmedium != None:
                self.hdcmode = 'cdrom'
                self.expanderCDrom.show()            
                self.expanderCDrom.set_expanded(True)
                self.comboboxCDromdrive.set_active(find_cdrmedium)
                self.currimage_settings.hdc_image = None
                self.currimage_settings.cdrimage = None
                self.currimage_settings.cdrmode = 'mount'          
            else:
                self.comboboxCDromdrive.set_active(0)
                self.expanderCDrom.set_expanded(False)
            #print "find_cdrmedium: " + str(find_cdrmedium)          
        try:  
            self.switch_hdcicon()
        except:
#            print 'hdcicon not switched!'
            pass
        #print 'switch_hdcicon done'
        if self.currimage_settings.hdd_image != None and path.isfile(self.currimage_settings.hdd_image):
            self.filechooserbuttonHDD.set_filename(path.abspath(self.currimage_settings.hdd_image))
        else:
            self.filechooserbuttonHDD.set_current_folder(self.qemulator_instance.settings["imagespath"])    
        if self.currimage_settings.fda_image != None and path.isfile(self.currimage_settings.fda_image):
            self.filechooserbuttonFDA.set_filename(path.abspath(self.currimage_settings.fda_image))
        elif self.currimage_settings.bootmedium == 'fda' and path.isfile(self.currimage_settings.main_image):
            #print 'main_image: ' + str(self.currimage_settings.main_image)
            self.currimage_settings.fda_image = self.currimage_settings.main_image
            self.filechooserbuttonFDA.set_filename(path.abspath(self.currimage_settings.fda_image))
        else:
            self.filechooserbuttonFDA.set_current_folder(self.qemulator_instance.settings["imagespath"])
        if self.currimage_settings.fdb_image != None and path.isfile(self.currimage_settings.fdb_image):
            self.filechooserbuttonFDB.set_filename(path.abspath(self.currimage_settings.hdb_image))
        else:
            self.filechooserbuttonFDB.set_current_folder(self.qemulator_instance.settings["imagespath"])                        

#        if self.currimage_settings.dlinuxboot == True:
#            self.expander_dlinuxboot.show()
#        else:
#            self.expander_dlinuxboot.hide()

        if self.currimage_settings.kernelimage != None and path.isfile(self.currimage_settings.kernelimage): 
            self.filechooserbuttonKernelimage.set_filename(path.abspath(self.currimage_settings.kernelimage))    
        else:
            self.filechooserbuttonKernelimage.unselect_all()
        if self.currimage_settings.initrd != None and path.isfile(self.currimage_settings.initrd): 
            self.filechooserbuttonInitrd.set_filename(path.abspath(self.currimage_settings.initrd))       
        else:
            self.filechooserbuttonInitrd.unselect_all()
        self.entryKernelcmd.set_text(self.currimage_settings.kernelcmd)     

        self.spinbuttonMemory.set_value(self.currimage_settings.memory)             
        
    def on_entry_bookmark_name_changed(self, *widget):
        fname = self.entry_bookmark_name.get_text()
        if fname != "":
            self.bookmarkname = fname
            if self.notebook_bookmarks.get_property('sensitive') != True:
                self.notebook_bookmarks.set_sensitive(True)                
                if self.init_image != None:
#                    self.entry_bookmark_path.set_text(str(self.init_image)) 
                    self.bootimage = self.entry_bookmark_path.get_text()
                    #self.set_bookmark_boottype(self.bootimage)
                    self.set_initial_system()    
                    #self.get_final_machine()
                #self.okbutton.set_sensitive(True)
        else:
            self.bookmarkname = None
            self.notebook_bookmarks.set_sensitive(False)
        self.check_status()

    def on_notebook_bookmarks_switch_page(self, notebook, page, *page_num):
        currentpage = notebook.get_current_page()
        #print 'switched to page: ' + str(currentpage)
        #print 'switched to page_num: ' + str(page_num)
        if currentpage == 1:
            #print 'switched advanced mode off'            
            self.advancedmode = False
            self.dialog_bookmarks_widget.resize_children()
        else:
            #print 'switched advanced mode on'
            self.advancedmode = True            
        
    def set_model_comboboxCDromdrive(self):
        cdmodel = self.comboboxCDromdrive.get_model()
        cdmodel.clear()

        cdmodel.append(row=(None,))
        for dev in self.qemulator_instance.settings["cdromdrives"]:
            name = dev[0]
            device = dev[1]
            cdmodel.append(row=(name,))
            self.comboboxCDromdrive.set_model(cdmodel)
            self.comboboxCDromdriveQuick.set_model(cdmodel)

    def set_model_comboboxEmusystem(self):            
        sysmodel = self.comboboxEmusystem.get_model()
        try:
            sysmodel.clear()
        except:
            #print "nothing to clear"
            pass
        for commands in self.qemulator_instance.settings["qemuapps"]:
            name = commands[0]
            path = commands[1]
            #print "path: " + name + " - " + path
            
            sysmodel.append(row=(name,))
        self.comboboxEmusystem.set_model(sysmodel)  
         
        self.comboboxEmusystemQuick.set_model(sysmodel)
        self.comboboxEmusystem.set_active(0);  
        self.comboboxEmusystemQuick.set_active(0); 
        self.currimage_settings.emusystem = self.qemulator_instance.settings["qemuapps"][0][0]            
                

        
    def toggle_dlinuxboot(self, state=False):
        labelKernelimage = self.wTree.get_widget("labelKernelimage")
        labelInitrd = self.wTree.get_widget("labelInitrd")
        labelKernelcmd = self.wTree.get_widget("labelKernelcmd")
        
        self.filechooserbuttonKernelimage.set_sensitive(state)
        self.filechooserbuttonInitrd.set_sensitive(state)
        self.entryKernelcmd.set_sensitive(state)
        labelKernelimage.set_sensitive(state)
        labelInitrd.set_sensitive(state)
        labelKernelcmd.set_sensitive(state)
        
    def switch_hdcicon(self):
        if self.hdcmode == 'cdrom':
            self.switch_stockicon(self.iconHDC, gtk.STOCK_CDROM, gtk.ICON_SIZE_BUTTON)
        else:
            self.switch_stockicon(self.iconHDC, gtk.STOCK_HARDDISK, gtk.ICON_SIZE_BUTTON)
    
    def switch_stockicon(self, imageobject, stocktype, gtksize=gtk.ICON_SIZE_BUTTON):
        image = gtk.Image()
        setimage = imageobject.set_from_stock(stocktype, gtksize)
        #setimage = imageobject.set_image(image)
        return setimage

    def check_status(self):
        name_set = False
        system_set = False
        boot_set = False
        all_set = False
        
        text_notset = "<span foreground=\"red\">" + _("Not set") + "</span>"
        text_bootstat = text_notset
        ## check name
        if self.bookmarkname != None and self.bookmarkname != '':
            name_set = True
            text_name = "<span foreground=\"#189100\">" + str(self.bookmarkname) + "</span>"
            text_namehint = ""
            try:
                del self.statushints['hint_name']
            except:
                pass
            
        else:
            text_name = text_notset
            text_namehint = "<b>" + _("Please set a name for the machine") + "</b>"
            self.statushints['hint_name'] = text_namehint
            
        
        # check bootset
        if self.check_bootstatus() == True:
            boot_set = True
            text_boothint = ""
            text_bootstat = "<span foreground=\"#189100\">" + str(self.bootimage) + "</span>"
            try:
                del self.statushints['hint_boot']
            except:
                pass            
        else:
            #text_bootstat = ""
            text_bootstat = text_notset
            if self.bootvolume != None:
                text_boothint = "<b>" + _("Please select an image or medium to boot the system from.") + "</b>"
                self.statushints['hint_boot'] = text_boothint
        
        ## check system arch.        
        if self.currimage_settings.emusystem != None and self.currimage_settings.emusystem != '':
            system_set = True
            text_machine = "<span foreground=\"#189100\">" + self.currimage_settings.emusystem + "</span>"
        else:
            text_machine = text_notset            
            
        self.labelStatusName.set_markup(text_name)
        self.labelStatusMachine.set_markup(text_machine)
        self.labelStatusBootmedium.set_markup(text_bootstat)
        if name_set == True and boot_set == True and system_set == True:
            all_set = True        
        if self.advancedmode == False:
            if all_set == True:
                text_boothint = "<b><span foreground=\"#189100\">" + _("All required settings are done. The machine is ready to be stored.") + "</span></b>"
                self.statushints['hint_boot'] = text_boothint
            ### print out statusmessage
            statusmessage = ''
            
            if self.statushints.has_key('hint_name'):
                statusmessage = statusmessage + self.statushints['hint_name'] + '\n\n'
            if self.statushints.has_key('hint_bootimage'):
                statusmessage = statusmessage + self.statushints['hint_bootimage'] + '\n\n'
            if self.statushints.has_key('hint_boot'):
                statusmessage = statusmessage + self.statushints['hint_boot'] + '\n'
                
            if statusmessage != "":
                traypopalive = False
                try:
                    if self.traypop.alive == True:
                        traypopalive = True
                        #print 'gettext: ' + str(self.traypop.labelPopuptext.get_label())
                        #print 'statusmessage: ' + str(statusmessage)
                        if self.traypop.labelPopuptext.get_label() != statusmessage:
                            #print 'popup new text!'
                            self.traypop.close_balloon()
                            traypopalive = False
                except:
                    traypopalive = False
                if traypopalive == False:
                    self.traypop = qml_tools.PopupInfo(statusmessage, 12)        

        self.statushints = {}
        if all_set == True:
            self.okbutton.set_sensitive(True)
        else:
            self.okbutton.set_sensitive(False)
    
    def check_bootstatus(self):
        isset = False
        if self.bootvolume == 'cdrom':
            print 'cdrmedium: \"' + str(self.currimage_settings.cdrmedium) + '\"'
            if self.currimage_settings.cdrmedium != None and self.currimage_settings.cdrmedium != '' and self.currimage_settings.cdrmedium != 'None':
                isset = True
            elif self.currimage_settings.cdrimage != None and self.currimage_settings.cdrimage != '' and self.currimage_settings.cdrimage != 'None':
                isset = True
        elif self.bootvolume == 'hda':
            if self.currimage_settings.hda_image != None and self.currimage_settings.hda_image != '' and self.currimage_settings.hda_image != 'None':
                isset = True
        elif self.bootvolume == 'fda':
            if self.currimage_settings.fda_image != None and self.currimage_settings.fda_image != '' and self.currimage_settings.fda_image != 'None':
                isset = True
        elif self.bootvolume == 'dlinux':
            if self.currimage_settings.kernelimage != None and self.currimage_settings.kernelimage != '' and self.currimage_settings.kernelimage != 'None':
                isset = True                
        else:
            isset = False
        return isset   


    def get_final_machine(self):
        #self.currimage_settings['hda']
        #for data in self.currimage_settings:
            #var = str(key)
            #val = str(self.currimage_settings[key])
        print dir(self.currimage_settings)
        for var in dir(self.currimage_settings):
            print 'var: ' + str(var)
            val = getattr(self.currimage_settings, str(var))
            print 'val: ' + str(val)
            print '----------------------------------------------'
            
    def init_bookmark_image(self, widget, event, returnfunc):
        #self.qemulator_instance.init_create_image(widget, returnfunc)
        create_image = qemulator.CreateImage(self.imagespath, returnfunc)
        
    def return_created_bookmark_image(self, newimage):
        self.entry_bookmark_path.set_text(str(newimage))
        return newimage  
    
    def on_comboboxEmusystemQuick_changed(self, widget):
        active = widget.get_active()
        if self.advancedmode == False:
            self.comboboxEmusystem.set_active(active)
    
    def comboboxEmusystem_changed(self, widget):
        active = widget.get_active()
        model = widget.get_model()
        row = model[active]
        item = row[0]
        self.currimage_settings.emusystem = item 
        self.qemubin = self.qemulator_instance.emusystem_path_by_name(self.currimage_settings.emusystem)
        #self.get_soundhw()
        #self.refresh_soundhw()
        if self.advancedmode == True:
            self.comboboxEmusystemQuick.set_active(active)    
        self.get_machines()
        self.refresh_machineslist()
        self.check_status() 
     
        
    def on_comboboxMachinetype_changed(self, widget):
        active = widget.get_active()
        model = widget.get_model()
        row = model[active]
        item = row[0]
        self.currimage_settings.machine = item
        self.machinecommand = self.qemulator_instance.machine_path_by_name(self.currimage_settings.machine) 
        #self.get_soundhw()
            
    def get_machines(self, *event):
        #print "get machine"  
        #print "qemu system: " + str(self.qemubin)
        prog = os.popen(str(self.qemubin) + " -M ?")
        output = prog.readlines()
        output2 = []
        self.machineslist = []
        fc = 0
        if len(output) != 0:
            for f in output:
                #print "count machines: " + str(fc)
                f = string.strip(f)
                #print "f: " + str(f)
                if f != "":
                    output2.append(f)
                    fc = fc+1
        if len(output2) != 0:
            for f in output2:
                if f != output2[0]:
                    devdata = f.split(" ", 1)
                    devdata = filter(None, devdata)
                    devdata[0] = string.strip(devdata[0])
                    devdata[1] = string.strip(devdata[1])
                    self.machineslist.append(devdata)   
            
    def refresh_machineslist(self, *event):
        machinemodel = self.comboboxMachinetype.get_model()
        machinemodel.clear()
        if len(self.machineslist) != 0:
            for dev in self.machineslist:
                device = str(dev[0])
                name = str(dev[1])
                #print "dev: " + name + " - " + device
                #print str(dev[0]) + " - " + str(dev[1])
                machinemodel.append(row=(name,))
                self.comboboxMachinetype.set_model(machinemodel)  
        self.comboboxMachinetype.set_active(0)    
        
    def on_spinbuttonMemory_changed(self, widget, *data):
        value = self.spinbuttonMemory.get_text()
        c = 0
        while value == "" and c < 100:
            c = c + 1
            return False
        valint = int(value)
        if self.advancedmode == True:
            self.currimage_settings.memory = valint
            self.spinbuttonMemoryQuick.set_value(self.currimage_settings.memory) 
        
    def on_spinbuttonMemoryQuick_changed(self, widget, *data):
        value = self.spinbuttonMemoryQuick.get_text()
        c = 0
        while value == "" and c < 100:
            c = c + 1
            return False
        valint = int(value)
        if self.advancedmode == False:
            self.currimage_settings.memory = valint
            self.spinbuttonMemory.set_value(self.currimage_settings.memory)      
                             
    def on_radiobuttonBootHDA_toggled(self, widget):
        print 'toggled widget: ' + str(widget.get_name())
        state = widget.get_active()
        print 'to state: ' + str(state)
        if state == True:
            self.bootvolume = 'hda'
            self.bootimage = self.currimage_settings.hda_image
            print 'bootimage for hda: ' + str(self.bootimage)
            if self.advancedmode == True:
                self.fullset_bootimage()
                
    def on_radiobuttonBootHDC_toggled(self, widget):
        print 'toggled widget: ' + str(widget.get_name())
        state = widget.get_active()
        print 'to state: ' + str(state)
        if state == True:
            self.bootvolume = 'cdrom'
            if self.advancedmode == True:
                self.set_hdc_bootimage()
                self.fullset_bootimage()
    
        
    
    def set_hdchandle(self):
        print 'cdrmedium: ' + str(self.currimage_settings.cdrmedium)
        print 'cdrimage: ' + str(self.currimage_settings.cdrimage)
        print 'hdc_image: ' + str(self.currimage_settings.hdc_image)
        print 'cdrmode: ' + str(self.currimage_settings.cdrmode)
        if self.currimage_settings.cdrmode == 'mount':
            self.image_hdchandle = self.currimage_settings.cdrmedium
            #self.bootimage = self.currimage_settings.cdrmedium
            #self.currimage_settings.main_image = self.qemulator_instance.cdrom_path_by_name(self.currimage_settings.cdrmedium)
        else:
            self.image_hdchandle = self.currimage_settings.cdrimage
            #self.bootimage = self.currimage_settings.cdrimage
            #self.currimage_settings.main_image = self.bootimage
        print 'image_hdchandle: ' + str(self.image_hdchandle)        
                
    def set_hdc_bootimage(self):
        print 'cdrmedium: ' + str(self.currimage_settings.cdrmedium)
        print 'cdrimage: ' + str(self.currimage_settings.cdrimage)
        print 'hdc_image: ' + str(self.currimage_settings.hdc_image)
        print 'cdrmode: ' + str(self.currimage_settings.cdrmode)
        
        if self.currimage_settings.cdrmode == 'mount':
        #if self.hdcmode == 'cdrom':
            #self.bootimage = self.currimage_settings.cdrmedium
            self.currimage_settings.main_image = self.qemulator_instance.cdrom_path_by_name(self.currimage_settings.cdrmedium)
            self.bootimage = self.currimage_settings.main_image
            self.currimage_settings.cdrimage = None
            self.currimage_settings.hdc_image = None
        else:
            self.bootimage = self.currimage_settings.cdrimage
            self.currimage_settings.main_image = self.bootimage
            self.currimage_settings.cdrimage = self.bootimage
        print 'bootimage for hdc: ' + str(self.bootimage)
            
    def on_radiobuttonBootFDA_toggled(self, widget):
        print 'toggled widget: ' + str(widget.get_name())
        state = widget.get_active()
        print 'to state: ' + str(state)
        if state == True:
            self.bootvolume = 'fda'
            self.bootimage = self.currimage_settings.fda_image
            print 'bootimage for fda: ' + str(self.bootimage)
            if self.advancedmode == True:
                self.fullset_bootimage()
            
    def on_radiobuttonBootDlinux_toggled(self, widget):
        print 'toggled widget: ' + str(widget.get_name())
        state = widget.get_active()
        print 'to state: ' + str(state)
        if state == True:
            self.bootvolume = 'dlinux'
            self.bootimage = self.currimage_settings.hda_image
            self.currimage_settings.dlinuxboot = True
            #self.currimage_settings.kernelimage
            self.fullset_bootimage()
        else:
            self.currimage_settings.dlinuxboot = False
                
    def on_filechooserbuttonHDA_selection_changed(self, *widget):
        self.currimage_settings.hda_image = str(self.filechooserbuttonHDA.get_filename())
        print 'hda: ' + str(self.currimage_settings.hda_image)
        if self.advancedmode == True and self.currimage_settings.hda_image != str(None):
            self.fullset_bootimage()
            
    def on_filechooserbuttonHDB_selection_changed(self, *widget):
        self.currimage_settings.hdb_image = self.filechooserbuttonHDB.get_filename()
        print 'hdb: ' + str(self.currimage_settings.hdb_image)
        #self.fullset_bootimage()
        
    def on_filechooserbuttonHDC_selection_changed(self, *widget):
        #self.currimage_settings.hdc_image = self.filechooserbuttonHDC.get_filename()
        print 'hdc: ' + str(self.currimage_settings.hdc_image)
        self.currimage_settings.cdrmode = 'image'
        if self.advancedmode == True:
            self.set_hdc_type(self.currimage_settings.hdc_image)
        if self.bootvolume == 'cdrom':
            
            self.currimage_settings.cdrimage = self.filechooserbuttonHDC.get_filename()
            self.currimage_settings.hdc_image = None            
            print 'cdrom: ' + str(self.currimage_settings.cdrimage)
                       
            #self.comboboxMediatypeHDC.set_active(1)
            if self.advancedmode == True and self.currimage_settings.cdrimage != None:
                self.set_hdc_type(self.currimage_settings.cdrimage) 
                self.fullset_bootimage()            
        else:          
            self.currimage_settings.hdc_image = self.filechooserbuttonHDC.get_filename()
            self.currimage_settings.cdrimage = None
            print 'hdc: ' + str(self.currimage_settings.hdc_image)
                          
            if self.advancedmode == True and self.currimage_settings.hdc_image != None:
                self.set_hdc_type(self.currimage_settings.hdc_image)
                self.fullset_bootimage()
                
    def on_filechooserbuttonHDD_selection_changed(self, *widget):
        self.currimage_settings.hdd_image = self.filechooserbuttonHDD.get_filename()
        #self.fullset_bootimage()
    def on_filechooserbuttonFDA_selection_changed(self, *widget):
        self.currimage_settings.fda_image = self.filechooserbuttonFDA.get_filename()
        print 'fda: ' + str(self.currimage_settings.fda_image)
        if self.advancedmode == True and self.currimage_settings.fda_image != None:        
            self.fullset_bootimage()
    def on_filechooserbuttonFDB_selection_changed(self, *widget):
        self.currimage_settings.fdb_image = self.filechooserbuttonFDB.get_filename()
        #self.fullset_bootimage() 
                                              
    def on_comboboxCDromdrive_changed(self, widget):
        active = widget.get_active()
        model = widget.get_model()
        row = model[active]
        item = row[0]          
        self.currimage_settings.cdrmedium = item
        self.currimage_settings.hdc_image = None
        self.currimage_settings.cdrimage = None
        print 'on_comboboxCDromdrive_changed bootvolume: ' + str(self.bootvolume)
        print 'on_comboboxCDromdrive_changed cdrimage: ' + str(self.currimage_settings.cdrimage)
        if self.bootvolume == 'cdrom':
            if self.advancedmode == True:
                self.set_hdc_bootimage()
                self.comboboxCDromdriveQuick.set_active(active)
                self.fullset_bootimage()                    

    def on_comboboxCDromdriveQuick_changed(self, widget):
        active = widget.get_active()
        model = widget.get_model()
        row = model[active]
        item = row[0]          
        if self.advancedmode == False:
            self.set_hdc_bootimage()
            self.comboboxCDromdrive.set_active(active)
            self.quickset_cdromboot()
            #self.quickset_bootimage(self.bootvolume)
                
    def on_checkbuttonCDromdriveQuick_toggled(self, widget):
        print 'toggled widget: ' + str(widget.get_name())
        state = widget.get_active() 
        unstate = False     
        if state == True:
            unstate = False
            if self.advancedmode == False:
                self.currimage_settings.cdrmode = 'mount'
                #self.comboboxMediatypeHDC.set_active(1)
                #self.radiobuttonBootHDC.set_active(1)
                self.comboboxImagedevice.set_active(1)
                #self.set_hdc_bootimage()
                self.currimage_settings.bootmedium = 'cdrom'
                self.currimage_settings.hdc_image = None
                self.currimage_settings.cdrimage = None
                self.expanderCDrom.set_expanded(True)            
            self.bootvolume = 'cdrom'
            self.frame_imageboot.set_sensitive(False)
            self.comboboxCDromdriveQuick.set_active(1)    
        else:
            unstate = True
            self.currimage_settings.cdrmode = 'image'
            #self.comboboxMediatypeHDC.set_active(0)
            self.frame_imageboot.set_sensitive(True)
            #self.comboboxCDromdriveQuick.set_active(0)
            if self.advancedmode == False:
                #self.radiobuttonBootHDA.set_active(1)
                self.expanderCDrom.set_expanded(False)
                self.bootimage = self.entry_bookmark_path.get_text()
                self.set_bookmark_boottype(self.bootimage)
                #self.comboboxImagedevice.set_active(1)
                
                #self.currimage_settings.cdrimage = self.filechooserbuttonHDC.get_filename()
                #self.currimage_settings.cdrimage = None
                #self.currimage_settings.cdrimage = self.entry_bookmark_path.get_text()
                #self.bootimage = self.currimage_settings.cdrimage
                #self.currimage_settings.hdc_image = None
                #self.bootimage = self.currimage_settings.cdrimage
#                self.bootimage = None
                #self.comboboxCDromdriveQuick.set_active(0)
            self.check_status()
                
        self.comboboxImagedevice.set_sensitive(unstate)        
        if self.advancedmode == False:
            self.filechooserbuttonHDC.set_sensitive(unstate)
            self.button_create_HDC.set_sensitive(unstate)
            self.button_eject_hdc.set_sensitive(unstate)                  
                
    def on_filechooserbuttonKernelimage_selection_changed(self, widget): 
        print 'on_filechooserbuttonKernelimage_selection_changed'
        item = ''
        item = widget.get_filename() 
        print 'item ' + str(item)
        self.currimage_settings.kernelimage = str(item)
        self.currimage_settings.main_image = self.currimage_settings.kernelimage
        self.bootimage = self.currimage_settings.kernelimage
        self.check_status()

    def on_filechooserbuttonInitrd_selection_changed(self, widget): 
        item = widget.get_filename() 
        self.currimage_settings.initrd = str(item)

    def on_entryKernelcmd_changed(self, widget): 
        item = widget.get_text() 
        self.currimage_settings.kernelcmd = item    
    
    def return_created_HDA_image(self, newimage):
        print 'new hda image: ' + str(newimage)
        if newimage != None:
            storeimage = os.path.abspath(newimage)
            self.currimage_settings.hda_image = str(newimage)
            if os.path.exists(storeimage):
                print str(storeimage) + ' found!'
                self.filechooserbuttonHDA.unselect_all()
                setpath = self.filechooserbuttonHDA.set_filename(path.abspath(storeimage))
                print 'filechooserbuttonHDA set to: ' + str(newimage) + ' ' + str(setpath)                
            else:
                print self.currimage_settings.hda_image + ' file not found!'

        return newimage 
    def return_created_HDB_image(self, newimage):
        if newimage != None:
            storeimage = os.path.abspath(newimage)
            self.filechooserbuttonHDB.set_filename(path.abspath(storeimage))
        return newimage 
    def return_created_HDC_image(self, newimage):
        print 'new hdc image: ' + str(newimage)
        if newimage != None:
            storeimage = os.path.abspath(newimage)
            self.filechooserbuttonHDC.set_filename(path.abspath(storeimage))
        return newimage 
    def return_created_HDD_image(self, newimage):
        if newimage != None:
            storeimage = os.path.abspath(newimage)
            self.filechooserbuttonHDD.set_filename(path.abspath(storeimage))
        return newimage 
    def return_created_FDA_image(self, newimage):
        if newimage != None:
            storeimage = os.path.abspath(newimage)
            self.filechooserbuttonFDA.set_filename(path.abspath(storeimage))
        return newimage 
    def return_created_FDB_image(self, newimage):
        if newimage != None:
            storeimage = os.path.abspath(newimage)
            self.filechooserbuttonFDB.set_filename(path.abspath(storeimage))
        return newimage                         
    
 
    
    def return_created_image(self, *widget):
        newimage = None
        newimage = self.createimage.return_newimage()
        self.last_created_image = newimage
        return newimage            
    
    def update_bm_iconprev(self, widget):
        #filechooserbutton_machine_icon = self.wTree.get_widget("filechooserbutton_machine_icon")
        image_iconpreview = self.wTree.get_widget("image_iconpreview")
        entry_icon = str(self.filechooserbutton_machine_icon.get_filename())
        if entry_icon != 'None':
            preview_icon = gtk.gdk.pixbuf_new_from_file(entry_icon)
            preview_icon2 = preview_icon.scale_simple(32, 32, 3)
            image_iconpreview.set_from_pixbuf(preview_icon2)       

    def fileChooser_bootimage(self, widget):
        
        dic = {"on_filechooserdialogUniversal_response" : self.fileChooser_bootimage_response
        }
        
        wTree = gtk.glade.XML(self.gladefile, "filechooserdialogUniversal", APP)
        self.filechooserdialog_openimage = wTree.get_widget("filechooserdialogUniversal")
        self.filechooserdialog_openimage.set_current_folder(self.qemulator_instance.settings["imagespath"])
        #self.filechooserdialog_openimage = gtk.glade.XML(self.gladefile, "filechooserdialog_openimage", APP)
        self.filechooserdialog_openimage.add_filter(qemulator.filter_shall())
        self.filechooserdialog_openimage.add_filter(qemulator.filter_devs(self.qemulator_instance.settings))
        self.filechooserdialog_openimage.set_filter(qemulator.filter_shall())
        try:        
            self.filechooserdialog_openimage.add_shortcut_folder(self.qemulator_instance.settings["imagespath"])
        except:
            pass 
        try:        
            self.filechooserdialog_openimage.add_shortcut_folder("/dev/")         
        except:
            pass         
        wTree.signal_autoconnect(dic)
        self.filechooserdialog_openimage.set_keep_above(True)
        self.filechooserdialog_openimage.show() 
        
    def fileChooser_bootimage_response(self, widget, response, *entry):
        print 'widget: ' + str(widget)
        print 'response: ' + str(response)
        entrytext = widget.get_filename()
        print 'entry: ' + entrytext
        if response == gtk.RESPONSE_OK:
            file = widget.get_filename()
            

            print 'File selected: ' + file 
            #entry_bookmark_path = self.wTree.get_widget("entry_bookmark_path")      
            self.entry_bookmark_path.set_text(str(file))
            
            widget.destroy ()            
            return file      
        elif response == gtk.RESPONSE_CANCEL:
            widget.destroy ()   
            return None               
        return None
    
    def on_entry_bookmark_path_changed(self, *widget):
        if self.advancedmode == False:
            file = self.entry_bookmark_path.get_text()
            self.bootimage = str(file)
            self.set_bookmark_boottype(file)
            
        
        
    
    def on_comboboxMediatypeHDC_changed(self, widget):
        active = widget.get_active()
        model = widget.get_model()
        row = model[active]
        item = row[0]
        self.hdcmode = str(item)
        self.switch_hdcicon()
        self.filechooserbuttonHDC.set_sensitive(True)
        print 'on_comboboxMediatypeHDC_changed hdcmode: ' + str(self.hdcmode)
        if self.hdcmode == 'cdrom':
            ######## Thats the delinquent !!!!!!!!! ##########
            ##self.currimage_settings.cdrmode = 'image'
            ##################################################
            self.expanderCDrom.show()
            self.currimage_settings.cdrimage = self.filechooserbuttonHDC.get_filename()
            self.currimage_settings.hdc_image = None
        else:
            #self.currimage_settings.cdrmode = 'nocd'
            self.currimage_settings.hdc_image = self.filechooserbuttonHDC.get_filename()
            self.currimage_settings.cdrimage = None
            self.expanderCDrom.set_expanded(False)
            self.expanderCDrom.hide()
            #self.filechooserbuttonHDC.set_sensitive(True)
    
    def on_expanderCDrom_activate(self, *widget):
        
        if self.advancedmode == False:
            gtk.gdk.threads_enter()
        expstat = self.expanderCDrom.get_expanded()
        self.filechooserbuttonHDC.set_sensitive(expstat)
        self.button_create_HDC.set_sensitive(expstat)
        self.button_eject_hdc.set_sensitive(expstat)
        if self.advancedmode == False:
            gtk.gdk.threads_leave()        
        if expstat == False:
            print 'aufgeklappt'
            
            if self.advancedmode == True:
                self.currimage_settings.cdrmode = 'mount'
                self.comboboxCDromdrive.set_active(1)
                #self.currimage_settings.cdrmedium = item
                self.checkbuttonCDromdriveQuick.set_active(True)
                self.currimage_settings.hdc_image = None
                self.currimage_settings.cdrimage = None
                
        else:
            print 'zugeklappt'
            self.currimage_settings.cdrmode = 'image'
            if self.advancedmode == True: 
                self.comboboxCDromdrive.set_active(0)           
                self.checkbuttonCDromdriveQuick.set_active(False)
                self.currimage_settings.cdrimage = self.filechooserbuttonHDC.get_filename()
        print 'cdrmode expander: ' + str(self.currimage_settings.cdrmode)
           
        
    def on_comboboxImagedevice_changed(self, *widget):
        if self.advancedmode == False:
            #self.bootvolume = str(self.comboboxImagedevice.get_active())
            #self.currimage_settings.cdrmode
            active = self.comboboxImagedevice.get_active()
            model = self.comboboxImagedevice.get_model()
            row = model[active]
            bootvolume = str(row[0])
            self.bootvolume = bootvolume
            print 'catched bootvolume: ' + str(bootvolume)
            #self.quicktoggle_boot(bootvolume)
#            self.bootvolume = str(row[0])
#            self.bootimage = self.entry_bookmark_path.get_text()
            print 'changed bootvolume: ' + self.bootvolume
            self.quickset_bootimage(self.bootvolume)
            
    def quicktoggle_boot(self, bootvolume):
        print 'qtoggle bootvolume: \"' + str(bootvolume) + '\"'
        if bootvolume == 'hda':
            self.quickset_hdaboot()
        elif bootvolume == 'cdrom':
            self.quickset_cdromboot()
        elif bootvolume == 'fda':
            self.quickset_fdaboot()
        else:
            print 'bootvolume: ' + str(bootvolume) + ' fits nothing'
        print 'qtoggled bootvolume: ' + self.bootvolume
        
    def quickset_bootimage(self, *bootvolume):
        if self.bootimage != '' and self.bootimage != None:
            print 'quick changed for bootimage: ' + str(self.bootimage)
            if self.bootvolume == 'hda':
                self.quickset_hdaboot()
            elif self.bootvolume == 'cdrom':
                self.quickset_cdromboot()

            elif self.bootvolume == 'fda':
                self.quickset_fdaboot()
                
            #self.switch_hdcicon()
        #self.check_status()
         
    def quickset_cdromboot(self):
        self.comboboxMediatypeHDC.set_active(1)
        #time.sleep(0.1)
        #self.currimage_settings.cdrmode
        self.comboboxMediatypeHDC.set_sensitive(False)
        print 'quickset_cdromboot cdrmode: ' + str(self.currimage_settings.cdrmode)
        self.currimage_settings.cdrimage = self.bootimage
        print 'quickset_cdromboot bootimage: ' + str(self.bootimage)
        #self.set_hdc_type(self.bootimage)
        self.set_hdc_bootimage()
        # if self.currimage_settings.cdrmode == 'image':
        if self.currimage_settings.cdrmode == 'image':
            self.filechooserbuttonHDC.set_filename(path.abspath(self.bootimage))
        self.radiobuttonBootHDC.set_active(True)
        
        self.currimage_settings.main_image = self.bootimage
        self.currimage_settings.bootmedium = self.bootvolume
        self.currimage_settings.boot_driveletter = 'd'
        self.currimage_settings.hdc_image = None                
        self.currimage_settings.hda_image = None
        self.currimage_settings.fda_image = None
        if self.filechooserbuttonHDA.get_filename() == self.bootimage:
            self.filechooserbuttonHDA.unselect_all()
        if self.filechooserbuttonFDA.get_filename() == self.bootimage:                    
            self.filechooserbuttonFDA.unselect_all()                
        self.frameDlinuxboot.hide()
        self.check_status()   
        
    def quickset_hdaboot(self):
        self.currimage_settings.hda_image = self.bootimage
        try:
            self.filechooserbuttonHDA.set_filename(path.abspath(self.bootimage))
        except:
            pass
        self.radiobuttonBootHDA.set_active(True)
        
        self.currimage_settings.main_image = self.bootimage
        self.currimage_settings.bootmedium = self.bootvolume
        self.currimage_settings.boot_driveletter = 'c'
        self.currimage_settings.hdc_image = None
        self.currimage_settings.cdrimage = None
        self.currimage_settings.fda_image = None
        self.checkbuttonCDromdriveQuick.set_active(False)
        if self.filechooserbuttonHDC.get_filename() == self.bootimage:               
            self.filechooserbuttonHDC.unselect_all()
        if self.filechooserbuttonFDA.get_filename() == self.bootimage:                    
            self.filechooserbuttonFDA.unselect_all()
        
        self.comboboxMediatypeHDC.set_active(0)
        self.comboboxMediatypeHDC.set_sensitive(True)       
        self.frameDlinuxboot.hide()
        self.check_status()
        
    def quickset_fdaboot(self):
        self.currimage_settings.fda_image = self.bootimage
        try:
            self.filechooserbuttonFDA.set_filename(path.abspath(self.bootimage))
        except:
            pass
        self.radiobuttonBootFDA.set_active(True)
        
        self.currimage_settings.main_image = self.bootimage
        self.currimage_settings.bootmedium = self.bootvolume
        self.currimage_settings.boot_driveletter = 'a'
        self.currimage_settings.hda_image = None
        self.currimage_settings.hdc_image = None
        self.currimage_settings.cdrimage = None
        self.checkbuttonCDromdriveQuick.set_active(False)
        if self.filechooserbuttonHDA.get_filename() == self.bootimage:             
            self.filechooserbuttonHDA.unselect_all()
        if self.filechooserbuttonHDC.get_filename() == self.bootimage:
            self.filechooserbuttonHDC.unselect_all()
           
        self.comboboxMediatypeHDC.set_active(0)
        self.frameDlinuxboot.hide()
        self.comboboxMediatypeHDC.set_sensitive(True)                                       
        self.check_status()        
        
    def set_bookmark_boottype(self, imagefile):
        #comboboxImagedevice = self.wTree.get_widget("comboboxImagedevice")
        #label_suggestions = self.wTree.get_widget("label_suggestions")  
        fileparser = qml_tools.ImageInfo()
        #print 'file: ' + str(imagefile)
        #qemuinfo = fileparser.get_qemuimg_info(str(imagefile))
        #print 'qemu info: ' + str(qemuinfo)
        print 'image file: ' + str(imagefile)
        fileinfo = fileparser.get_file_info(str(imagefile))
        print 'file info: ' + str(fileinfo)
        if fileinfo['medium'] == 'hda':
            self.comboboxImagedevice.set_active(0)
            #self.bootvolume = fileinfo['medium']
            #self.quickset_bootimage(fileinfo['medium'])
        if fileinfo['medium'] == 'cdrom':
            self.comboboxImagedevice.set_active(1) 
            #self.bootvolume = fileinfo['medium']
            #self.quickset_bootimage(fileinfo['medium']) 
        if fileinfo['medium'] == 'fda':
            self.comboboxImagedevice.set_active(2)
            #self.bootvolume = fileinfo['medium']
            #self.quickset_bootimage(fileinfo['medium'])
        if fileinfo.has_key('suggestion'):
            self.statushints['hint_bootimage'] = fileinfo['suggestion']
        self.quickset_bootimage()
        
    def set_hdc_type(self, imagefile):
        #comboboxImagedevice = self.wTree.get_widget("comboboxImagedevice")
        #label_suggestions = self.wTree.get_widget("label_suggestions")  
        fileparser = qml_tools.ImageInfo()
        #print 'file: ' + str(imagefile)
        #qemuinfo = fileparser.get_qemuimg_info(str(imagefile))
        #print 'qemu info: ' + str(qemuinfo)
        fileinfo = fileparser.get_file_info(str(imagefile))
        print 'file info set_hdc_type: ' + str(fileinfo)
        if fileinfo['medium'] == 'hda' or fileinfo['medium'] == 'fda' or fileinfo['medium'] == None:
            self.comboboxMediatypeHDC.set_active(0)
            #self.bootvolume = fileinfo['medium']
            #self.quickset_bootimage(fileinfo['medium'])
        elif fileinfo['medium'] == 'cdrom':
            self.comboboxMediatypeHDC.set_active(1)
        else:
            self.comboboxMediatypeHDC.set_active(0)
              
   
                
    def fullset_bootimage(self, *widget):
        #if self.bootimage != '' and self.bootimage != None:
        print 'changed for bootimage: ' + str(self.bootimage)
        self.currimage_settings.dlinuxboot = False
        if self.bootvolume == 'hda':
            try:
                self.currimage_settings.hda_image = self.filechooserbuttonHDA.get_filename()
            except:
                self.currimage_settings.hda_image = None
            self.bootimage = self.currimage_settings.hda_image
            self.currimage_settings.main_image = self.bootimage
            self.currimage_settings.bootmedium = self.bootvolume
            self.currimage_settings.boot_driveletter = 'c'
            self.currimage_settings.dlinuxboot = False
            self.checkbuttonCDromdriveQuick.set_active(False)
            self.frameDlinuxboot.hide()
            if self.bootimage != None:
                self.entry_bookmark_path.set_text(self.bootimage)
            self.comboboxImagedevice.set_active(0)
            self.comboboxMediatypeHDC.set_sensitive(True)
            #self.currimage_settings.hda_image = self.bootimage
        elif self.bootvolume == 'cdrom':
            if self.currimage_settings.cdrmode == 'image':
                try:
                    self.currimage_settings.cdrimage = self.filechooserbuttonHDC.get_filename()
                except:
                    self.currimage_settings.cdrimage = None            
#            if self.currimage_settings.cdrmode == 'mount':
#                try:
#                    self.currimage_settings.cdrmedium = self.filechooserbuttonFDA.get_filename()
#                except:
#                    self.currimage_settings.cdrmedium = None   
                           
            self.comboboxMediatypeHDC.set_active(1)
            self.comboboxMediatypeHDC.set_sensitive(False)
            self.comboboxImagedevice.set_active(1)
            self.set_hdc_bootimage()
            if self.currimage_settings.cdrmode == 'mount':
                self.currimage_settings.main_image = self.qemulator_instance.cdrom_path_by_name(self.currimage_settings.cdrmedium)
                self.bootimage = self.currimage_settings.main_image                
                #self.bootimage = self.currimage_settings.cdrmedium
                #self.currimage_settings.main_image = self.qemulator_instance.cdrom_path_by_name(self.currimage_settings.cdrmedium)
            else:
                self.bootimage = self.currimage_settings.cdrimage
                #self.currimage_settings.main_image = self.bootimage
                
            self.currimage_settings.bootmedium = self.bootvolume
            self.currimage_settings.boot_driveletter = 'd'
            self.currimage_settings.dlinuxboot = False
            self.frameDlinuxboot.hide()
            if self.bootimage != None:
                self.entry_bookmark_path.set_text(self.bootimage)

            #self.currimage_settings.hdc_image = self.bootimage
        elif self.bootvolume == 'fda':
            try:
                self.currimage_settings.fda_image = self.filechooserbuttonFDA.get_filename()
            except:
                self.currimage_settings.fda_image = None            
            self.bootimage = self.currimage_settings.fda_image
            self.currimage_settings.bootmedium = self.bootvolume
            self.currimage_settings.boot_driveletter = 'a'
            self.currimage_settings.dlinuxboot = False
            self.currimage_settings.main_image = self.bootimage
            self.checkbuttonCDromdriveQuick.set_active(False)
            self.frameDlinuxboot.hide()
            if self.bootimage != None:
                self.entry_bookmark_path.set_text(self.bootimage)
            #self.currimage_settings.fda_image = self.bootimage
            self.comboboxImagedevice.set_active(2)
            self.comboboxMediatypeHDC.set_sensitive(True)
        elif self.bootvolume == 'dlinux':
            self.bootimage = self.currimage_settings.hda_image
            self.currimage_settings.bootmedium = 'hda'
            self.currimage_settings.boot_driveletter = 'c'
            self.currimage_settings.dlinuxboot = True
            self.currimage_settings.main_image = self.bootimage
            self.frameDlinuxboot.show()
            if self.bootimage != None:
                self.entry_bookmark_path.set_text(self.bootimage)
            #self.currimage_settings.fda_image = self.bootimage
            self.comboboxImagedevice.set_active(0)
            self.comboboxMediatypeHDC.set_sensitive(True)
        else:
            self.bootimage = ''
            self.comboboxImagedevice.set_active(0)
            self.comboboxMediatypeHDC.set_sensitive(True)
        if self.bootimage != None:
            self.entry_bookmark_path.set_text(self.bootimage) 
        else:
            self.entry_bookmark_path.set_text('')
        #self.switch_hdcicon()
        print 'bootvolume: ' + str(self.bootvolume)
        self.check_status()   
        
#        if self.bootvolume == 'hda':
#            self.currimage_settings.bootmedium = self.bootvolume
  
    
    def clear_filechooser(self, widget):
        print "name: " + str(widget.name)
        #fcb = None
        wname = None
        if widget == self.button_eject_hda:
            wname = self.filechooserbuttonHDA
            self.currimage_settings.hda_image = None
#            fcb = self.wTree[wname]
        elif widget == self.button_eject_hdb:
            wname = self.filechooserbuttonHDB
            self.currimage_settings.hdb_image = None
            #fcb = self.filechooserbuttonHDB
        elif widget == self.button_eject_hdc:
            wname = self.filechooserbuttonHDC
            self.currimage_settings.hdc_image = None
            self.comboboxMediatypeHDC.set_sensitive(True)
            #fcb = self.filechooserbuttonHDC 
        elif widget == self.button_eject_hdd:
            wname = self.filechooserbuttonHDD
            self.currimage_settings.hdd_image = None
            #fcb = self.filechooserbuttonHDD 
        elif widget == self.button_eject_fda:
            wname = self.filechooserbuttonFDA
            fcb = self.filechooserbuttonFDA
            self.currimage_settings.fda_image = None
        elif widget == self.button_eject_fdb:
            wname = self.filechooserbuttonFDB
            self.currimage_settings.fdb_image = None
            #fcb = self.filechooserbuttonFDB            
        elif widget == self.button_eject_imagecdrom:
            wname = self.filechooserbuttonImagecdrom
            self.currimage_settings.cdrimage = None
            #fcb = self.filechooserbuttonImagecdrom
        else:
            #fcb = None
            wname = None
        if wname != None: 
            #fcb = self.wTree.get_widget(wname)
#            fcb = wname
#            try:
#                _hid = self.sighandlers[wname]
#                fcb.handler_block(_hid)
#            except:
#                pass       
        
               
            try:
                print 'changed to: ' + str(self.qemulator_instance.settings["imagespath"])
                wname.set_current_folder(self.qemulator_instance.settings["imagespath"])
            except:
                print 'cleared'
                wname.unselect_all()  
        self.check_status()
                
    def add_bookmark_response(self, widget, response, *entry):
        entryname = self.entry_bookmark_name
        entrypath = self.entry_bookmark_path
        #filechooserbutton_machine_icon = self.wTree.get_widget("filechooserbutton_machine_icon")

        entry_icon = str(self.filechooserbutton_machine_icon.get_filename())
        entry_icon_pixbuf = gtk.gdk.pixbuf_new_from_file(entry_icon)
        
        entry_name = str(entryname.get_text())
        #entry_path = str(entrypath.get_text())
        entry_path = self.currimage_settings.main_image
        #haveconfig = str(self.check_haveconfig(entry_path))
        #if haveconfig == True:
        #    config_icon = gtk.gdk.pixbuf_new_from_file(self.pixmapdir + '/gtk-yes.png')
        #else:
        #    config_icon = gtk.gdk.pixbuf_new_from_file(self.pixmapdir + '/gtk-no.png')
        #print 'entryname: ' + entry_name
        #print 'entrypath: ' + entry_path
        if response == gtk.RESPONSE_OK:  
            checkdouble = self.qemulator_instance.checkexist_bookmark(entry_name)
            #print 'doublecheck: ' + str(checkdouble)
            if checkdouble == True:
                dialogtext = "<b>" + _("A Machine with this name allready exists, please choose another one") + "</b>"
                delrequest = qml_tools.Dialog("error", dialogtext, "Name exists")
            else:  
                #self.get_final_machine()             
                newbookmark = qemulator.Bookmark()
                newbookmark.icon = entry_icon
                newbookmark.name = entry_name
                newbookmark.path = entry_path
                newbookmark.haveconfig = True
                try:
                    self.qemulator_instance.bookmarks.append(newbookmark)
                except:
                    self.qemulator_instance.bookmarks = [(newbookmark)]
                self.qemulator_instance.storetofile(self.qemulator_instance.bookmarks, "bookmarks")
                time.sleep(0.2)
                self.store_emu_settings()
                self.qemulator_instance.refresh_bookmarks()
                self.qemulator_instance.notebook_mainlists.set_current_page(0)
                self.qemulator_instance.show_settings()
                self.qemulator_instance.select_bookmark(entry_name)
                
                
                finalmessage = _("The machine has been stored successfully. Now you can 'finetune' it's configuration in the configuration panel that should open up until showing this message, \
although it should run 'out of the box' with the default settings.")
                self.traypop = qml_tools.PopupInfo(finalmessage, None, 12, self.traypop)
                widget.destroy()
                return entry_name                  
                
        elif response == gtk.RESPONSE_CANCEL:
            widget.destroy()   
            return None               
        return None                   
                
    def store_emu_settings(self):
        self.image_settings = self.qemulator_instance.image_settings
#        if self.currimage_settings.kqemu_param == "":
#            store_kqemu_param = "NULL"
#        else:
#            store_kqemu_param = self.currimage_settings.kqemu_param
#        ##### HAVE TO BE SET IN WIZZARD!!!! ###############
#        if self.currimage_settings.emusystem == "":    
#            self.currimage_settings.emusystem = str(self.comboboxEmusystem.get_active())
#        ###################################################
        #print 'storing currimage_settings: ' + str(self.currimage_settings)
        newvals = vars(self.currimage_settings)
        for key in newvals.keys():
            var = key
            val = newvals[key]
            #print 'key: ' + str(key) + ' val: ' + str(val)
            
        #if self.selected_bookmark != None:
            #print 'storing bookmark settings: '
            #self.currentimage = self.currimage_settings.main_image
        self.image_settings[self.bookmarkname] = self.currimage_settings
        #else:
        #    #print 'storing path based settings: '
        #    self.image_settings[self.currentimage] = self.currimage_settings
        
        #self.cleanup_emu_settings()
        
        storedata = self.image_settings
        filename = "image_settings"
        self.qemulator_instance.storetofile(storedata, filename)

                  



