/* $Id$ */

/* ---------------------------------------------------------------- */

%apply (PetscInt, PetscObject INPUT[])  
       { (PetscInt n, const Vec vecs[]) };
%typemap(check) (PetscInt n, const Vec vecs[]) {
  int        i;
  PetscTruth valid;
  for (i=0; i<$1; i++) {
    VecValid($2[i],&valid);
    if (!valid)
      PETSC_seterr(PETSC_ERR_ARG_WRONG,
		   "object in `vecs` is not a valid vector");
  }
}

PetscErrorCode
MatNullSpaceCreate(MPI_Comm,  PetscTruth, 
		   PetscInt n, const Vec vecs[],
		   MatNullSpace* CREATE);

%clear (PetscInt n, const Vec vecs[]);


PetscErrorCode MatNullSpaceDestroy(MatNullSpace);

//PetscErrorCode MatNullSpaceSetFunction(MatNullSpace,PetscErrorCode (*)(Vec,void*),void*);

/* ---------------------------------------------------------------- */

%apply Vec OPTIONAL { Vec out };

PETSC_OVERRIDE(
PetscErrorCode,
MatNullSpaceRemove,
(MatNullSpace nullsp, Vec vec, Vec out), {
  PetscErrorCode ierr;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(nullsp,MAT_NULLSPACE_COOKIE,1);
  PetscValidHeaderSpecific(vec,VEC_COOKIE,2);
  if (out) {
    Vec v;
    PetscValidHeaderSpecific(out,VEC_COOKIE,3);
    ierr = MatNullSpaceRemove(nullsp,vec,&v); CHKERRQ(ierr);
    ierr = VecCopy(v,out); CHKERRQ(ierr);
  } else {
    ierr = MatNullSpaceRemove(nullsp,vec,PETSC_NULL); CHKERRQ(ierr);
  }
  PetscFunctionReturn(0);
})

%clear Vec out;

/* ---------------------------------------------------------------- */
%wrapper %{

#undef __FUNCT__  
#define __FUNCT__ "MatNullSpaceFunctionPython"
static 
PetscErrorCode
MatNullSpaceFunctionPython(Vec vec, void* ctx)
{
  PyObject*      function = NULL;
  PyObject*      ret      = NULL;
  PetscFunctionBegin;
  
  function = PyCtx_Get((PyObject*)ctx);
  if (function == NULL) goto fail;
  ret = PyCtx_CALL_FUNC(function, "O&",
			PyVec_Ref, vec);
  if (ret == NULL) goto fail;
  Py_DECREF(ret);
  PetscFunctionReturn(0);
  
 fail:
  Py_XDECREF(ret);
  PetscFunctionReturn(1);
}
%}

PETSC_OVERRIDE(
PetscErrorCode,
MatNullSpaceSetFunction,
(MatNullSpace nsp, PyObject *function), {
  PyObject* ctx = NULL;
  PetscErrorCode ierr;
  PetscFunctionBegin;
  if (function == NULL || function == Py_None) {
    ierr = PetscObjectCompose((PetscObject)nsp,"__function__",PETSC_NULL); CHKERRQ(ierr);
    ierr = MatNullSpaceSetFunction(nsp,PETSC_NULL,PETSC_NULL); CHKERRQ(ierr);
  } else {
    if (!PyCallable_Check(function)) SETERRQ(1,"NullSpace Function is not callable");
    ctx = PyCtx_New(function); if (ctx == NULL) SETERRQ(1,"invalid NullSpace Function object");
    ierr = PetscObjectComposePyCtx((PetscObject)nsp,"__function__",ctx); CHKERRQ(ierr);
    ierr = MatNullSpaceSetFunction(nsp,MatNullSpaceFunctionPython,(void*)ctx); CHKERRQ(ierr);
  }
  PetscFunctionReturn(0);
})


/* ---------------------------------------------------------------- */

PetscErrorCode MatNullSpaceTest(MatNullSpace,Mat);
PetscErrorCode MatNullSpaceAttach(Mat,MatNullSpace);

/* ---------------------------------------------------------------- */

/*
 * Local Variables:
 * mode: C
 * End:
 */
