#!/bin/sh

PERL=$(which perl)
MAKE=$(which make)
PERL5LIB="$DESTDIR/usr/share/perl5/"
PERL="$PERL -I$PERL5LIB"

echo "=========================================================================="
echo "Make $1"
echo "PERL5LIB = $PERL5LIB"
echo "DESTDIR = $DESTDIR"
echo "=========================================================================="

#--- unpacking tar.gz in proper folders
if [ "$1" = "unpack" ]; then
    test -d build-area || mkdir build-area
    
    cd tarballs
    for dir in *
    do
    	if [ -d $dir ]; then
    		cd $dir
			for file in *.tar.gz
			do 
				test -d ../../build-area/$dir || mkdir ../../build-area/$dir
				tar -C ../../build-area/$dir -xzf $file
			done
			cd ..
		fi
    done
    cd ..
fi

if [ "$1" = "build" ]; then

	cd build-area
	for dir in *
	do
		if [ -d $dir ]; then
    		cd $dir
			for module in *
			do 
				cd $module
        		if [ -r Build.PL ];
		        then
					$PERL Build.PL installdirs=vendor
					$PERL Build
					$PERL Build test
					$PERL Build install destdir=$DESTDIR
	        	else
					PERL5LIB=$PERL5LIB $PERL Makefile.PL INSTALLDIRS=vendor
					PERL5LIB=$PERL5LIB $MAKE
					PERL5LIB=$PERL5LIB $MAKE test
					$MAKE install DESTDIR=$DESTDIR
	    	    fi
				cd ..
			done
			cd ..
		fi
	done
cd ..
fi
