/*
 *
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation;
 * 		Look at the file LICENSE for details
 *
*/
#define IN_CAS 1
#include "readconf.h"
#include "illum.h"

char rcfname[RCLINELEN] = RCFNAME,
line_str[RCLINELEN]   = "/dev/ttyS0",
speed_str[RCLINELEN]  = "9600",
passwd_str[RCLINELEN] = "",
parity_str[RCLINELEN] = "none",
dbase_str[RCLINELEN]  = DEFAULTDB,
line_str_[RCLINELEN]  = "/dev/ttyb",
dbase_bak[RCLINELEN]  = "~/.casiodb.bak";

int bytelen=8,
tflag = 0,
debugmode = 0, 
Port = 0,
firstAck=0, /* if writting(5x80),  we havent received the first Ack yet */
firstheader = 1;
byte ackbyte = IACK;


const   CONFIG  casio_config[] = {
/* kind         tag             refecence       size       delim flags */
  {CF_INT,      "bytelen",      &bytelen,       0,         NULL, 0, NULL},
  {CF_INT,      "debug",        &debugmode,     0,         NULL, 0, NULL},
  {CF_STRING,   "line",         line_str,       RCLINELEN, NULL, 0, NULL},
  {CF_STRING,   "speed",        speed_str,      RCLINELEN, NULL, 0, NULL},
  {CF_STRING,   "passwd",       passwd_str,     RCLINELEN, NULL, 0, NULL},
  {CF_STRING,   "parity",       parity_str,     RCLINELEN, NULL, 0, NULL},
  {CF_STRING,   "dbase",        dbase_str,      RCLINELEN, NULL, 0, NULL},

};


/*
 * global variables:
 */
char *version = "2.2";
char *hello = "\nCASIO interface program Solaris 2.x , Sunos4.x, and Linux v. %s\n\n";

char *info = "\
This program is a backup and restore utility for a CASIO digital diary.\n\
\n\
The syntax is:\n\
\n\
CASIO <-r|-w> [-l <commport>]  [-o <file>] [-t]\n\
\n\
    -r|-w:      The direction of the data transfer. -r is used for reading\n\
                data from the CASIO to the PC. -w for the opposite direction.\n\
\n\
    commport:   The PC's serial port that has to be used. Specify as COM1,\n\
                COM2,COM3 or COM4 or simply as 1,2,3 or 4. For Solaris and \n\
                specify TTYA or TTYB or simply as A or B.\n\
\n\
    baudrate:   Either 2400, 4800 or 9600 must be specified. Note that not\n\
                all communication speeds are supported by all CASIO's.\n\
                fixed at 9600 for the Illuminator models\n\
                can not be edited. \n\
\n\
    parity:     none, odd, even. The Illuminator understands none only\n\
                can not be edited. \n\
\n\
    bytelength: The number of bits transfered for one Byte,
                7 or 8 are valid values. \n\
                The value is fixed for the Illuminator to 8 bits \n\
                can not be edited. \n\
\n\
    file:       The name of the file where the backup data are to be written\n\
                to or read from.\n\
\n\
The other communication parameters on the CASIO have to be set to 8N1 \n\
\n\
\n\
The layout of the used file is not directly in a readable format since\n\
all data records as needed for the CASIO are not really processed into\n\
a convenient format. The file data are used for backup/restore purposes\n\
only and should not be edited.\n\
\n\
CAUTION: Do not interface the CASIO directly to the PC's serial port, since\n\
         this may cause permanent damage to the CASIO. Always use the\n\
         circuit as described in circuit*.gif. It contains level converters\n\
         for converting the +12/-12 Volts levels on the PC side to the\n\
         +5/0 Volts levels that the CASIO uses.\n\
\n\
         Also keep in mind that the Secret Area of the CASIO has to be\n\
         backuped/restored separately.\n\
\n";
int Port;
unsigned int Record;
int blkflg;

byte DataBuffer[512],  Direction = READ;

byte nbytes;

byte Stopped;

/*
 * Default values for communication parameters -- illuminator
 */
tcflag_t speed  = B9600,
         bytel  = CS8;
static struct termios term;
static struct termios save_stdin;
static struct termios oldterm;

int err;



main (int argc, char *argv[])
{

int j;
  /*
   * Expand ~ in rc filename to home path
   */
  if (strcpy(rcfname, tilde_expand_filename(rcfname, getuid())) == NULL)
    {
      perror("tilde_expand_filename()");
      exit(-1);
    }
  /*
   * Read rc file in home dir
   */
  if (read_config_file(argv[0], casio_config, NELEM(casio_config), rcfname) < 0)
    {
       perror(rcfname);
       exit(-1);
    }
  /*
   * Pars arguments
   */
  while ((ch = getopt(argc, argv, "d:hl:o:rvwt")) != EOF)
    {
      switch(ch)
        {
          case 'd':
            debugmode = atoi(optarg);
            break;
          case 'l':
            strcpy(line_str, optarg);
            break;
          case 'o':
            strcpy(dbase_str, optarg);
            break;
          case 'r':
            Direction = READ;
            break;
          case 't':
            tflag++;
            break;
          case 'v':
            debugmode++;
            break;
          case 'w':
            Direction = WRITE;
            break;
          case 'h':
          default:
            fprintf (stderr, hello, version);
            fprintf (stderr, "%s", info);
            return (-1);
        }
    }
  dispose_config(argv[0], casio_config, NELEM(casio_config));
 /*
   * Expand ~ in database filename to home path
   */
  if (strcpy(dbase_str, tilde_expand_filename(dbase_str, getuid())) == NULL)
    {
      perror("tilde_expand_filename()");
      exit(-1);
    }

  if (debugmode > 0)
    {
      printf ("Settings:\n");
      printf ("=========\n\n");
      printf ("line=%s\n", line_str);
      printf("speed=%s\n", speed_str);
      printf("parity=%s\n", parity_str);
      printf("bytelen=%d\n", bytelen);
      printf ("dbase=%s\n", dbase_str);
      printf ("debug=%d\n", debugmode);
      printf("direction=%s\n", Direction?"Read From Casio":"Write to Casio");
      printf("database file =%s\n", dbase_str);


     
    }

  if (debugmode == 6)
 {
 printf("\n Debug Level 6 is used only for printing setup info; change to something else\n\n");
   exit(0);
}

  time (&now);
  tmstruct = localtime (&now);
  strftime (tbuff, 10, ".%y%d%m", tmstruct);
  if (debugmode > 0)
    {
      strcpy (deb, "debug");
      strcat (deb, tbuff);
      dbg = fopen (deb, "w");
    }
  if (tflag)
    {
      printf ("Opening data file\n");
      strcpy (dat, "data");
      strcat (dat, tbuff);
      data = fopen (dat, "w");
    }


  if (debugmode > 1)
    fprintf (dbg, "\nopening port %s...\n", line_str);
  printf ("\nopening port %s ...\n", line_str);
  if ((Port = open (line_str, O_RDWR)) < 0)
    {
      fprintf (stderr, "Unknown COM port %s\n", line_str);
      terminate ();
    }

#if !defined(Solaris2)
  if ((signal (SIGINT, sig_catch)) == SIG_ERR)  /* catch signals */
    fprintf (stderr, "signal(SIGINT) error %d", err);
#endif /* !defined(Solaris2) */

  if ((signal (SIGQUIT, sig_catch)) == SIG_ERR)
    fprintf (stderr, "signal(SIGINT) error ");
  if ((signal (SIGTERM, sig_catch)) == SIG_ERR)
    fprintf (stderr, "signal(SIGINT) error ");

  /* even more error checking! */
  /* should be terminal device - exit if not */
  if (isatty (Port) == 0)
    {
      fprintf (stderr, "\nNot terminal device...\n");
      terminate ();
    }

  /* get port attributes, store in oldterm */
  if (tcgetattr (Port, &oldterm) < 0)
    {
      fprintf (stderr, "\ntcgetattr error...");
      terminate ();
    }
  /* copy old into new; restore the old sometime when done */
  term = oldterm;


/* 5x** only understands 9600 8N1 */
  term.c_cflag &= ~PARENB;
  term.c_cflag &= ~CSIZE;
  term.c_cflag |= speed | CREAD | bytel | CLOCAL;

  cfsetispeed (&term, speed);
  cfsetospeed (&term, speed);

  /* set non-canonical mode */
  term.c_lflag = 0;
  /*
   * Ignore bytes with parity errors and make terminal raw and dumb.
   */
  term.c_iflag = 0;
  term.c_iflag |= IGNBRK;
  term.c_iflag |= IGNPAR;

  term.c_oflag &= ~OPOST;
  /* blocking read until 1 char arrives */
  term.c_cc[VMIN] = 1;
  term.c_cc[VTIME] = 0;

  /*
   * Open the required file
   */
  if (Direction == READ)
    {
      term.c_iflag |= IXOFF;
      term.c_cc[VSTART] = XON;
      term.c_cc[VSTOP] = XOFF;
      /*
       * Backup existing database file
       */
      if ((casiofile = fopen (dbase_str, "rb")) != (FILE *) 0)
	{
	  strcpy (dbase_bak, dbase_str);
	  strcat (dbase_bak, ".bak");
	  if (debugmode > 1)
	    fprintf (dbg, "Creating backup file %s...", dbase_bak);
	  fclose (casiofile);
	  if (rename (dbase_str, dbase_bak) != 0)
	    {
	      fprintf (stderr, "Cannot rename file %s to %s\n", dbase_str, dbase_bak);
	      terminate ();
	    }
	  if (debugmode > 1)
	    fprintf (dbg, " done\n");
	}
      if ((casiofile = fopen (dbase_str, "wb")) == (FILE *) 0)
	{
	  fprintf (stderr, "Cannot create output file %s\n", dbase_str);
	  terminate ();
	}
    }
  else
    {
      if ((casiofile = fopen (dbase_str, "rb")) == (FILE *) 0)
	{
	  fprintf (stderr, "Cannot open input file %s\n", dbase_str);
	  terminate ();
	}
    }
  /* now clean the serial line and activate the settings for casio */
  tcflush (Port, TCIOFLUSH);

  if (tcsetattr (Port, TCSAFLUSH, &term) < 0)
    {
      fprintf (stderr, "\n failed to set port attr ... exiting \n");
      terminate ();
    }

  Stopped = 0;
  WriteStatus = 0;
  fprintf (stdout, hello, version);
  /* set the stdin to cbreak mode */
  tty_cbreak (STDIN_FILENO);

  while (1)
    {
      if (Direction == READ)
	{
	  fprintf (stderr, "\nRead data from CASIO to file %s\n", dbase_str);
	  if (debugmode > 1)
	    fprintf (dbg, "\nRead data to file %s\n", dbase_str);

	  while (!Stopped)
	    {
	      if (debugmode > 1)
		fprintf (dbg, "\n++++++++++++++++++++++++++++++++++++++++++++\n");
	      ReadLine ();
/*
 */

	      if (debugmode > 2)
		fprintf (dbg, "\nwriting data to casiofile: \n");
	      fwrite (&ourheader, sizeof (byte), 1, casiofile);
	      fwrite (&ourdata.type, sizeof (byte), 1, casiofile);
	      fwrite (&ourdata.length, sizeof (byte), 1, casiofile);
	      fwrite (&ourdata.data, ourdata.length, 1, casiofile);
	      fwrite (&ourdata.cksum, sizeof (byte), 1, casiofile);
/*
   usleep(100);
 */
	      if ((j = write (Port, &ackbyte, 1)) != 1)
		{
		  fprintf (stderr, "\n %d ERROR %d: couldnt write the ack(0xBD) to serial port \nterminating ..\n", j, errno);
		  perror ("oops write");
		  fprintf (stderr, "\n%d %d %d %d %d %d %d\n", EBADF, EINVAL, EFAULT, EPIPE, EAGAIN, EINTR, ENOSPC);
		  terminate ();
		}
	      if (debugmode > 2)
		fprintf (dbg, "\nAcked record \n");

	    }
	  if (debugmode > 2)
	    fprintf (dbg, "\n =========> stopped =1? real=%d\n", Stopped);
	}
      else
	{
	  fprintf (stderr, "\n\nWrite data from file %s to CASIO\n\n", dbase_str);
	  fprintf (stderr, "Hit ESC to terminate at any time \n");


	  blkflg &= ~O_NONBLOCK;
	  if (fcntl (Port, F_SETFL, blkflg) < 0)
	    {
	      fprintf (stderr, "\nexiting ..\n");
	      terminate ();
	    }
	  if (!Stopped)
	    {
	      fprintf (stderr, "Casio is ready to receive\n");
	      if (debugmode > 1)
		fprintf (dbg, "Casio is ready to receive\n");
	    }

	  while (!Stopped)
	    {
	      WriteLine (casiofile);
	      DisplayStatus ();
	    }
/*
	  Stopped = 1;
*/
	break;
	}
    }

  terminate ();
}


/*
 * R e a d H e a d e r
 *
 *      Read a record header from the CASIO
 *	The illuminator version
 */
void
ReadHeader (void)
{
  int retval, readval, len = 0;
  if (debugmode > 2)
    fprintf (dbg, "\nReadheader waiting for a char");

  if (firstheader)
    {
/* for the first header wait up to 10 minutes */
      if (debugmode > 2)
	fprintf (dbg, "waiting for the first header\n");
      readval = ReadByte (300, 0, 0);
      firstheader = 0;
    }

/* make sure we grab the syncronization byte hex 8a */
  while ((readval & 0xff) != 0x8A)
    {
      readval = ReadByte (30, 0, 1);
      if (debugmode > 3)
	fprintf (dbg, "\nread:>%2X<  >%c< ", readval & 0xff, readval & 0xff);

    }
/* grab the type byte */
  readval = ReadByte (5, 0, 0);
  ourdata.type = (byte) readval & 0xff;
}



void 
ReadSchData ()
{
  int readval, i = 0, len = 0;
/*
 */
  for (i = 0; i < 3; i++)
    {
      /* ReadBytea char and store in i */
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      len++;
    }
  switch (ourdata.type)
    {
    case 0x0c:
      {
	for (i = 0; i < 5; i++)
	  {
	    /* ReadBytea char and store in i */
	    readval = ReadByte (5, 0, 1);
	    ourdata.data[len] = (byte) readval & 0xff;
	    len++;
	  }

	break;
      }
    case 0x0d:
      {
	for (i = 0; i < 3; i++)
	  {
	    /* ReadBytea char and store in i */
	    readval = ReadByte (5, 0, 1);
	    ourdata.data[len] = (byte) readval & 0xff;
	    len++;
	  }
	break;
      }
    case 0x0e:
      {
	for (i = 0; i < 9; i++)
	  {
	    /* ReadBytea char and store in i */
	    readval = ReadByte (5, 0, 1);
	    ourdata.data[len] = (byte) readval & 0xff;
	    len++;
	  }
	break;
      }
    default:
      {
	printf ("\nUnknown schedule type");
	break;
      }

    }
/* now we are at par; ReadBytethe remainder of the data */
/* keep reading until we see an FF */
  do
    {
      /* ReadBytea char and store in i */
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      len++;
    }
  while ((readval & 0xff) != 0xFF);

/* grab the checksum */
  ourdata.length = (byte) len - 1;
  readval = ReadByte (5, 0, 1);
  ourdata.cksum = (byte) readval & 0xff;
  printf ("\nchecksum: %2X %c ", readval & 0xff, readval & 0xff);

}

/********************/
void 
ReadRemData ()
{
  int readval = 0xff, i = 0, len = 0;
  for (i = 0; i < 12; i++)
    {
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      len++;
    }
  do
    {
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      len++;
    }
  while ((readval & 0xff) != 0xFF);

  while ((readval & 0xff) == 0xFF)
    {
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      printf ("\nreading FFs:>%2X<  >%c< ", readval & 0xff, readval & 0xff);
      len++;
    }

/*
 */
  ourdata.length = (byte) len - 1;
  ourdata.cksum = (byte) readval & 0xff;
  printf ("\nchecksum: %2X %c ", readval & 0xff, readval & 0xff);
}

/********************/
void 
ReadExpData ()
{
  int readval = 0xff, i = 0, len = 0;
  for (i = 0; i < 12; i++)
    {
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      len++;
    }
  do
    {
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      len++;
    }
  while ((readval & 0xff) != 0xFF);

  while ((readval & 0xff) == 0xFF)
    {
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      printf ("\nreading FFs:>%2X<  >%c< ", readval & 0xff, readval & 0xff);
      len++;
    }

/*
 */
  ourdata.length = (byte) len - 1;
  ourdata.cksum = (byte) readval & 0xff;
  printf ("\nchecksum: %2X %c ", readval & 0xff, readval & 0xff);

}

/********************
In this scenario we dont know what the record type is
so we just ReadByteevrything and timeout if there is nothing
to be ReadByteafter 5 secs; this gives us leeway so that
if we can send an ack before the 30 secs timer expires;
The assumption here is that the illuminator will not
timeout.
*************************/
void 
ReadUnknown ()
{
  int readval, readval2, len = 0;
  do
    {
/*
   fprintf (stderr, "\nReadheader waiting for a char from %d\n",5);
 */
      /* ReadBytea char and store in i */
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      len++;
    }
  while ((readval2 = waitforchar (5, 5, 0)));
  ourdata.cksum = (byte) readval & 0xff;
  len--;
  ourdata.length = (byte) len;
}
/********************
*************************/
void 
ReadGenData ()
{
  int readval, len = 0;
/* keep reading until we see an FF */
  do
    {
      /* ReadBytea char and store in i */
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
      len++;
    }
  while ((readval & 0xff) != 0xFF);
/* keep going until we hit a checksum */
  while ((readval & 0xff) == 0xFF)
    {
/*
   fprintf (stderr, "\nReadheader2 waiting for a char from %d\n",5);
 */
      /* ReadBytea char and store in i */
      readval = ReadByte (5, 0, 1);
      ourdata.data[len] = (byte) readval & 0xff;
/*
   printf("\nreading FFs:>%2X<  >%c< ",readval&0xff,readval&0xff);
 */
      len++;
    }

/* jamal -- until we fix it the last byte is a checkusm; offset it */
  ourdata.length = (byte) len - 1;
/* grab the checksum */
  ourdata.cksum = (byte) readval & 0xff;
/*
   printf("\nchecksum: %2X %c ",readval&0xff,readval&0xff);
 */

}

/*
 * R e a d L i n e
 *
 *      Read one complete record from the CASIO
 *	The illuminator version
 */
void
ReadLine ()
{
  int i, tot = 0;
  /*
   * Read the CASIO record header
   */
  if (debugmode > 2)
    fprintf (dbg, "calling readheader\n");

/* grab the header */
  ReadHeader ();
  DisplayStatus ();
/* based on the type read the rest of the data */
  switch (ourdata.type)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      ReadGenData ();
      break;
    case 9:
    case 10:
    case 11:
      ReadExpData ();
      break;
    case 12:
    case 13:
    case 14:
      ReadSchData ();
      break;
    case 15:
      ReadRemData ();
      break;
    default:
      ReadUnknown ();
      break;
    }
  if (debugmode > 2)
    fprintf (dbg, "\nDone ReadHeader\n");
  if (tflag)
    {
      fprintf (data, "\n++********************************************++*\n");
/* based on the type read the rest of the data */
      switch (ourdata.type)
	{
	case 0:
	case 1:
	case 2:
	  disptel1 (&ourdata);
	  break;
	case 3:
	case 4:
	case 5:
	  dispmemo (&ourdata);
	  break;
	case 6:
	case 7:
	case 8:
	  disptodo (&ourdata);
	  break;
	case 9:
	case 10:
	case 11:
	  dispexp (&ourdata);
	  break;
	case 12:
	case 13:
	case 14:
	  dispsched (&ourdata);
	  break;
	case 15:
	  disprem (&ourdata);
	  break;
	default:
	  printf ("\n dont know how to format-print");
	  dispUnknown (&ourdata);
	  break;
	}
      fprintf (data, "\n++********************************************++*\n");
    }
}

/*
 * W r i t e L i n e
 *
 *      Write one complete record from
 *      the file to the CASIO
 */
int WriteLine (FILE * infile)
{
  int i,theEnd=0;

  if (fread (&MHeader, sizeof (MHeader), 1, casiofile) != 1)
    {
      Stopped=1;
      theEnd=1;
      printf("\n The end \n");
    }
  if (!Stopped&& (debugmode > 2))
  {
    fprintf (dbg, "\nfileread: Mheader.type=%d length=%d\n",MHeader.type,MHeader.nbytes);
  }
if (!Stopped&&(MHeader.ourhead == 0x8a))
{
ourdata.type=MHeader.type;
ourdata.length=MHeader.nbytes;
} else {
if (!theEnd)
printf("\n 1: input file appears corrupt. 
        If you are sure there is nothing wrong contact the 
	author\n");
  if (debugmode > 2)
    fprintf (dbg, "\nfileread: 1\n");
      Stopped=1;
}
/* read the data next */
  if (!Stopped&&fread (&ourdata.data, ourdata.length, 1, casiofile) != 1)
    {
	printf("\n 2:input file appears corrupt. 
        If you are sure there is nothing wrong contact the 
	author\n");
  if (debugmode > 2)
    fprintf (dbg, "\nfileread: 2\n");
      Stopped=1;
    }
/* read the checksum next */
  if (!Stopped&&fread (&ourdata.cksum, sizeof (byte), 1, casiofile) != 1)
    {
	printf("\n 3: input file appears corrupt. 
        If you are sure there is nothing wrong contact the 
	author\n");
  if (debugmode > 2)
    fprintf (dbg, "\nfileread: 3\n");
      Stopped=1;
    }
/*
* send the record to the Casio
*/
  WriteBuffer (&ourdata);

  /*
   * Wait for reply
printf("\nWaiting for ACK\n");
   */
      i = ReadByte (28, 0, 0);
/* the only thing we expect back from the illuminator is
an IACK; but hey who knows? */
	  switch (i)
	    {
	    case NACK:
	      fprintf (stderr, "\nTransmission error, stopped\n");
	      Stopped = 1;
	      WriteByte (STOP);
	      break;

	    case ACK:
	    case IACK:
	      fprintf (dbg, "\nAck received\n");
	      return;

	    case STOP:
	    case XON:
	    case XOFF:
	      return;

	    default:
	      fprintf (stderr, "0x%02x\n", i);
	      return;
	}


}

/*
 * W r i t e B u f f e r
 *
 *      Write the data in the CASIO Write Buffer
 *      to the CASIO
 */
void
WriteBuffer (casiorec *ourdata)
{
int i;
int j=200;
byte d;

if (!firstAck)
{
getFirstAck(ourdata);
}
/* send the header */
d=0x8a;
fprintf(dbg,"\nsending header\n");
/*
fprintf(stderr,"\nsending header\n");
*/
WriteByte (d);
/* write the type */
fprintf(dbg,"\nsending type\n");
/*
fprintf(stderr,"\nsending type\n");
*/
WriteByte (ourdata->type);
fprintf(dbg,"\nsending data\n");
/*
fprintf(stderr,"\nsending data\n");
*/
/* write the data */
 for (i = 0; i < ourdata->length ; i++)
 {
 WriteByte ( ourdata->data[i]);
 }
fprintf(dbg,"\nsending checksum\n");
/*
fprintf(stderr,"\nsending checksum\n");
*/
/* write the checksum */
WriteByte (ourdata->cksum);

}

getFirstAck (casiorec *ourdata)
{
int i;
int j=200;
byte d;
int Acked=0;

while(!Acked)
{
/* send the header */
d=0x8a;
fprintf(dbg,"\nsending header\n");
/*
fprintf(stderr,"\nsending header\n");
*/
WriteByte (d);
/* write the type */
fprintf(dbg,"\nsending type\n");
/*
fprintf(stderr,"\nsending type\n");
*/
WriteByte (ourdata->type);
fprintf(dbg,"\nsending data\n");
/*
fprintf(stderr,"\nsending data\n");
*/
/* write the data + 0xFF */
 for (i = 0; i < ourdata->length ; i++)
 {
 WriteByte ( ourdata->data[i]);
 }
fprintf(dbg,"\nsending checksum\n");
/* write the checksum */
WriteByte (ourdata->cksum);
/* now lets wait for that first Ack */
d=ReadByte (1, 0, 0);
if (debugmode > 3)
fprintf (dbg, "\n%d: received %x from serial port \n",j, d);
if (d == IACK)
{
firstAck=1;
Acked=1;
sleep(2);
}
fprintf(dbg,"\n******** Resending The data *************\n");
}
fprintf(dbg,"\n******** got the first Ack *************\n");

}

/*
 * U p p e r C a s e
 *
 *  Turn a string into all uppercase characters
 */
void
UpperCase (char *s)
{
  while (*s)
    {
      if (*s >= 'a' && *s <= 'z')
	{
	  *s = *s - 'a' + 'A';
	}

      s++;
    }
}

/*
 * R e a d B y t e
 *
 * Read a byte from the COM port
 */
byte
ReadByte (int secs, int usecs, int mode)
{
/*
* mode =0 ==> return for errors and timeouts
* mode=1 ==>  terminate for errors and timeouts
*/
  int retval, j;
  byte i;
 char bufin[32];

#ifdef jamal
  /*
   * Check if the user pressed ESC to stop communication
   */
  if (kbhit ())
    {
      if (getchar () == 0x1b)
	{
	  fprintf (stderr, "\n\nESC pressed, stop communication\n");
	  Stopped = 1;
	  return (-1);
	}
    }
 #endif

/* wait for up to secs,usecs for a char to arrive; otherwise timeout */
  retval = waitforchar (Port, secs, usecs);
  if (retval == 0)
    {
      if (mode == 1)
	{
	  fprintf (stderr, "\n terminating due to timeout ....\n");
	  terminate ();
	}
      else
	{
	  return -1;
	}
    }
  if (retval == -1)
    {
      if (mode == 1)
	{
	  fprintf (stderr, "\n terminating due to read error ....\n");
	  terminate ();
	}
      else
	{
	  return -1;
	}
    }
  /* read a char and store in i */
  j = read (Port, &i, 1);

#ifndef __i386__
  NTOHL (i);
#endif
  if (debugmode > 2)
    fprintf (dbg, "\n read\n ");
  if (j == 0)
    {
      if (mode == 1)
	{
	  if (debugmode > 2)
	    fprintf (dbg, "\nEOF encountered\n");
	  terminate ();
	}
      else
	{
	  return -1;
	}
    }
  if (j > 0)
    {
      if (debugmode > 2)
	fprintf (dbg, "\nsuccesful READ\n");
    }
  if (j == -1)
    {
      if (mode == 1)
	{
	  if (debugmode > 2)
	    fprintf (dbg, "\nUnsuccessfull READ\n");
	  terminate ();
	}
      else
	{
	  return -1;
	}
    }
  sprintf (bufin, "received %x\n", i & 0xff);
  if (debugmode > 1)
    fprintf (dbg, "%s\n", bufin);

  return (i);
}


/*
 * W r i t e B y t e
 *
 *  Write a byte to the COM port
 */
void
WriteByte (byte d)
{
  int i;
  long TimeOut;

  TimeOut = 0;
  if (debugmode > 1)
    fprintf (dbg, "\n sending %x to serial port \n", d);

/*
    fprintf (stdout, "\n sending %x to serial port \n", d);
*/
#ifndef __i386__
  HTONL (i);
#endif
  /* write the character to the serial port */
  if (write (Port, &d, 1) != 1)
    {
      fprintf (stderr, "\nERROR WriteByte: couldnt write the char %c to serial port \n", d);
      terminate ();
    }
#ifdef jamal
  if (Direction == WRITE)
    {
      usleep (4000);
    }
 #endif
}


/*
 * a t o h
 *
 *      Convert an ASCII number to a hexadecimal value
 */
byte
atoh (char c)
{
  if (c >= '0' && c <= '9')
    {
      return (c - '0');
    }

  if (c >= 'a' && c <= 'f')
    {
      return (c - 'a' + 10);
    }

  if (c >= 'A' && c <= 'F')
    {
      return (c - 'A' + 10);
    }

  return (0);
}

/*
 * h t o a
 *
 *      Convert a hexadecimal value to an ASCII number
 */

char
htoa (byte c)
{
  c &= 0xf;

  if (c <= 9)
    {
      return (c + '0');
    }

  return (c - 10 + 'A');
}

/*
 * D i s p l a y S t a t u s
 */
void
DisplayStatus ()
{
  if (ourdata.type > MAXTYPE - 1)
    {
      fprintf (stderr, "\n>>>>>>Unknown type: %d <<<<<<< ", ourdata.type);
      fprintf (data, "\n>>>>>>Unknown type: %d <<<<<<<\n", ourdata.type);

    }
  else
    {
      if (!displayed[ourdata.type])
	{
	  fprintf (data, "\n>>>>>>%s<<<<<<<\n", rectypes[ourdata.type]);
	  fprintf (stderr, "\n>>>>>>%s<<<<<<< \b\b\b%3d", rectypes[ourdata.type], ++displayed[ourdata.type]);
	}
      else
	{
	  fprintf (stderr, " \b\b\b%3d", ++displayed[ourdata.type]);
	  fprintf (data, "\n>>>>>>%s<<<<<<<\n", rectypes[ourdata.type]);

	}
    }

}

/* poll the keyboard for a character */
/* idea borrowed from The Linux Journal article of Sept 95 issue 17 */
int
kbhit (void)
{

  struct timeval tv;
  fd_set read_fd;

/*do not wait at all, not even a microsecond */
  tv.tv_sec = 0;
  tv.tv_usec = 0;

/* must be done first to initilize read_fd */
  FD_ZERO (&read_fd);

/* makes select() ask if input is ready :
 * 0 is the file descriptor stdin  */
  FD_SET (0, &read_fd);

/* the first parameter is the number of the 
   * largest file descriptor to check + 1.  */

  if (select (1, &read_fd,
	      NULL,		/* NO writes */
	      NULL,		/* NO exceptions */
	      &tv)
      == -1)
    return 0;			/* An error occured */
/* read_fd now holds a bitmap of files that are
 * readable. We test the entry for the standard
 * input (file 0).
 */

  if (FD_ISSET (0, &read_fd))	/* character pending on stdin */
    return 1;

/* no charcaters were pending */

  return 0;
}

static void
sig_catch (int signo)
{
  fprintf (stderr, "\nsignal caught %d\n", signo);
  fprintf (dbg, "\nsignal caught %d\n", signo);
  /*inform */
  fprintf (stderr, "\nstopping contact with casio \n\n");
  /* should also reset the serial port being used by
     casio and close all files */
  terminate ();
}

int
tty_reset (int fd)		/* restore terminal's mode */
{
  if (fd == Port)
    {
      if (tcsetattr (fd, TCSAFLUSH, &oldterm) < 0)
	fprintf (stderr, "\nFailed to reset serial port\n");
      return (-1);
    }
  else if (fd == STDIN_FILENO)
    {
      if (tcsetattr (fd, TCSAFLUSH, &save_stdin) < 0)
	fprintf (stderr, "\nFailed to reset stdin\n");
      return (-1);
    }
  return (0);
}

/* the terminator */
void
terminate ()
{
  blkflg |= O_NONBLOCK;
  if (fcntl (Port, F_SETFL, blkflg) < 0)
    {
      fprintf (stderr, "\nexiting ..\n");
      exit (-1);
    }
  if (debugmode > 1)
    fprintf (dbg, "\nterminate: writting stop to port\n");
  Stopped = 1;
printf("\n\n*** Data transfer over: Please press ESC on the Casio\n");
sleep(30);

  /* reset terminals */
  if (debugmode > 1)
    fprintf (dbg, "\n reseting stdin\n");
  tty_reset (STDIN_FILENO);
  if (debugmode > 1)
    fprintf (dbg, "\n reseting port\n");
  tty_reset (Port);

  /* close all open files */
  if (debugmode > 1)
    fprintf (dbg, "\n closing casiofile\n");
  fclose (casiofile);
  if (debugmode > 1)
    fprintf (dbg, "\n closing Port\n");
  close (Port);
  if (debugmode > 1)
    fprintf (dbg, "\n closing data file\n");
  fclose (data);
  if (debugmode > 1)
    fprintf (dbg, "\n closing debug file\n");
  fclose (dbg);
  exit (0);
}

/* borrowed from W. Richard Stevens book
   Advanced Programming in the Unix Environment */

int
tty_cbreak (int fd)		/* put terminal into a cbreak mode */
{
  struct termios buf;

  if (fd == STDIN_FILENO)
    {
      if (tcgetattr (fd, &save_stdin) < 0)
	return (-1);
    }
  buf = save_stdin;		/* structure copy */

  buf.c_lflag &= ~(ECHO | ICANON);
  /* echo off, canonical mode off */

  buf.c_cc[VMIN] = 1;		/* Case B: 1 byte at a time, no timer */
  buf.c_cc[VTIME] = 0;

  if (tcsetattr (fd, TCSAFLUSH, &buf) < 0)
    return (-1);
  return (0);
}
