#include <stdio.h>

/*
 * OBMRES.C -- A little program to generate the resource list for the object
 * manager (Xt/Athena widgets).
 *
 * This file is not part of the runtime Object Manager code.
 */

/* Widget class codes.  These must match the values given in ObmP.h.
 */
#define Core			00000000000, 00000000001
#define Object			00000000000, 00000000002
#define Simple			00000000000, 00000000004
#define Shell			00000000000, 00000000010

#define AsciiSink		00000000000, 00000000020
#define AsciiSrc		00000000000, 00000000040
#define AsciiText		00000000000, 00000000100
#define Box			00000000000, 00000000200
#define Command			00000000000, 00000000400
#define Dialog			00000000000, 00000001000
#define Form			00000000000, 00000002000
#define Grip			00000000000, 00000004000
#define Label			00000000000, 00000010000
#define List			00000000000, 00000020000
#define MenuButton		00000000000, 00000040000
#define Paned			00000000000, 00000100000
#define Panner			00000000000, 00000200000
#define Porthole		00000000000, 00000400000
#define Repeater		00000000000, 00001000000
#define Scrollbar		00000000000, 00002000000
#define SimpleMenu		00000000000, 00004000000
#define Sme			00000000000, 00010000000
#define SmeBSB			00000000000, 00020000000
#define SmeLine			00000000000, 00040000000
#define StripChart		00000000000, 00100000000
#define Toggle			00000000000, 00200000000
#define Tree			00000000000, 00400000000
#define Viewport		00000000000, 01000000000

#define Gterm			00000000001, 00000000000
#define Layout			00000000002, 00000000000
#define HTML			00000000004, 00000000000
#define	Arrow			00000000010, 00000000000
#define Board			00000000020, 00000000000
#define	Scrollbar2		00000000040, 00000000000
#define	Slider2d		00000000100, 00000000000
#define Frame			00000000200, 00000000000
#define Group			00000000400, 00000000000
#define Icon			00000001000, 00000000000
#define MultiList		00000002000, 00000000000
#define RadioGroup		00000004000, 00000000000
#define RowCol			00000010000, 00000000000
#define TextBox			00000020000, 00000000000
#define TextButton		00000040000, 00000000000
#define TextToggle		00000100000, 00000000000
#define XfwfCommon		00000200000, 00000000000
#define XfwfMenuBar		00000400000, 00000000000

#define ApplicationShell	Shell
#define OverrideShell		Shell
#define TopLevelShell		Shell
#define TransientShell		Shell
#define WMShell			Shell


/* The following should list in sort order all the resources to be indexed,
 * giving for each the resource type and the widget class in which it is used.
 *
 * NOTES.  The asciiText widget recognizes the asciiSrc and asciiSink resources
 * hence these should be listed as asciiText resources too.  Listres lists
 * resources for some widgets which have no public XtN definition; these should
 * be omitted.
 */
struct resource_list {
	char *resource;			/* resource name */
	char *type;			/* resource type */
	unsigned long class1, class2;	/* widget using resource */
} resources[] = {
	{ "abs_height", "Position", Arrow },
	{ "abs_height", "Position", Board },
	{ "abs_height", "Position", Group },
	{ "abs_height", "Position", Icon },
	{ "abs_height", "Position", RadioGroup },
	{ "abs_height", "Position", RowCol },
	{ "abs_height", "Position", Scrollbar2 },
	{ "abs_height", "Position", Slider2d },
	{ "abs_height", "Position", TextBox },
	{ "abs_height", "Position", TextButton },
	{ "abs_height", "Position", TextToggle },
	{ "abs_height", "Position", XfwfMenuBar },
	{ "abs_width", "Position", Arrow },
	{ "abs_width", "Position", Board },
	{ "abs_width", "Position", Group },
	{ "abs_width", "Position", Icon },
	{ "abs_width", "Position", RadioGroup },
	{ "abs_width", "Position", RowCol },
	{ "abs_width", "Position", Scrollbar2 },
	{ "abs_width", "Position", Slider2d },
	{ "abs_width", "Position", TextBox },
	{ "abs_width", "Position", TextButton },
	{ "abs_width", "Position", TextToggle },
	{ "abs_width", "Position", XfwfMenuBar },
	{ "abs_x", "Position", Arrow },
	{ "abs_x", "Position", Board },
	{ "abs_x", "Position", Group },
	{ "abs_x", "Position", Icon },
	{ "abs_x", "Position", RadioGroup },
	{ "abs_x", "Position", RowCol },
	{ "abs_x", "Position", Scrollbar2 },
	{ "abs_x", "Position", Slider2d },
	{ "abs_x", "Position", TextBox },
	{ "abs_x", "Position", TextButton },
	{ "abs_x", "Position", TextToggle },
	{ "abs_x", "Position", XfwfMenuBar },
	{ "abs_y", "Position", Arrow },
	{ "abs_y", "Position", Board },
	{ "abs_y", "Position", Group },
	{ "abs_y", "Position", Icon },
	{ "abs_y", "Position", RadioGroup },
	{ "abs_y", "Position", RowCol },
	{ "abs_y", "Position", Scrollbar2 },
	{ "abs_y", "Position", Slider2d },
	{ "abs_y", "Position", TextBox },
	{ "abs_y", "Position", TextButton },
	{ "abs_y", "Position", TextToggle },
	{ "abs_y", "Position", XfwfMenuBar },
	{ "accelerators", "AcceleratorTable", ApplicationShell },
	{ "accelerators", "AcceleratorTable", Arrow },
	{ "accelerators", "AcceleratorTable", AsciiText },
	{ "accelerators", "AcceleratorTable", Board },
	{ "accelerators", "AcceleratorTable", Box },
	{ "accelerators", "AcceleratorTable", Command },
	{ "accelerators", "AcceleratorTable", Core },
	{ "accelerators", "AcceleratorTable", Dialog },
	{ "accelerators", "AcceleratorTable", Form },
	{ "accelerators", "AcceleratorTable", Frame },
	{ "accelerators", "AcceleratorTable", Grip },
	{ "accelerators", "AcceleratorTable", Group },
	{ "accelerators", "AcceleratorTable", Gterm },
	{ "accelerators", "AcceleratorTable", HTML },
	{ "accelerators", "AcceleratorTable", Icon },
	{ "accelerators", "AcceleratorTable", Label },
	{ "accelerators", "AcceleratorTable", Layout },
	{ "accelerators", "AcceleratorTable", List },
	{ "accelerators", "AcceleratorTable", MenuButton },
	{ "accelerators", "AcceleratorTable", MultiList },
	{ "accelerators", "AcceleratorTable", OverrideShell },
	{ "accelerators", "AcceleratorTable", Paned },
	{ "accelerators", "AcceleratorTable", Panner },
	{ "accelerators", "AcceleratorTable", Porthole },
	{ "accelerators", "AcceleratorTable", RadioGroup },
	{ "accelerators", "AcceleratorTable", Repeater },
	{ "accelerators", "AcceleratorTable", RowCol },
	{ "accelerators", "AcceleratorTable", Scrollbar },
	{ "accelerators", "AcceleratorTable", Scrollbar2 },
	{ "accelerators", "AcceleratorTable", Shell },
	{ "accelerators", "AcceleratorTable", Simple },
	{ "accelerators", "AcceleratorTable", SimpleMenu },
	{ "accelerators", "AcceleratorTable", Slider2d },
	{ "accelerators", "AcceleratorTable", StripChart },
	{ "accelerators", "AcceleratorTable", TextBox },
	{ "accelerators", "AcceleratorTable", TextButton },
	{ "accelerators", "AcceleratorTable", TextToggle },
	{ "accelerators", "AcceleratorTable", Toggle },
	{ "accelerators", "AcceleratorTable", TopLevelShell },
	{ "accelerators", "AcceleratorTable", TransientShell },
	{ "accelerators", "AcceleratorTable", Tree },
	{ "accelerators", "AcceleratorTable", Viewport },
	{ "accelerators", "AcceleratorTable", WMShell },
	{ "accelerators", "AcceleratorTable", XfwfCommon },
	{ "accelerators", "AcceleratorTable", XfwfMenuBar },
	{ "activate", "Callback", Group },
	{ "activate", "Callback", Icon },
	{ "activate", "Callback", RadioGroup },
	{ "activate", "Callback", TextButton },
	{ "activate", "Callback", TextToggle },
	{ "activeAnchorBG", "Pixel", HTML },
	{ "activeAnchorFG", "Pixel", HTML },
	{ "addressFont", "FontStruct", HTML },
	{ "alignment", "Alignment", Group },
	{ "alignment", "Alignment", RadioGroup },
	{ "alignment", "Alignment", RowCol },
	{ "alignment", "Alignment", Slider2d },
	{ "alignment", "Alignment", TextBox },
	{ "alignment", "Alignment", TextButton },
	{ "alignment", "Alignment", TextToggle },
	{ "alignment", "Alignment", XfwfMenuBar },
	{ "allowHoriz", "Boolean", Viewport },
	{ "allowOff", "Boolean", Panner },
	{ "allowResize", "Boolean", Paned },
	{ "allowShellResize", "Boolean", ApplicationShell },
	{ "allowShellResize", "Boolean", OverrideShell },
	{ "allowShellResize", "Boolean", Shell },
	{ "allowShellResize", "Boolean", SimpleMenu },
	{ "allowShellResize", "Boolean", TopLevelShell },
	{ "allowShellResize", "Boolean", TransientShell },
	{ "allowShellResize", "Boolean", WMShell },
	{ "allowVert", "Boolean", Viewport },
	{ "alphaFont1", "FontStruct", Gterm },
	{ "alphaFont2", "FontStruct", Gterm },
	{ "alphaFont3", "FontStruct", Gterm },
	{ "alphaFont4", "FontStruct", Gterm },
	{ "alphaFont5", "FontStruct", Gterm },
	{ "alphaFont6", "FontStruct", Gterm },
	{ "alphaFont7", "FontStruct", Gterm },
	{ "alphaFont8", "FontStruct", Gterm },
	{ "ancestorSensitive", "Boolean", ApplicationShell },
	{ "ancestorSensitive", "Boolean", Arrow },
	{ "ancestorSensitive", "Boolean", AsciiText },
	{ "ancestorSensitive", "Boolean", Board },
	{ "ancestorSensitive", "Boolean", Box },
	{ "ancestorSensitive", "Boolean", Command },
	{ "ancestorSensitive", "Boolean", Core },
	{ "ancestorSensitive", "Boolean", Dialog },
	{ "ancestorSensitive", "Boolean", Form },
	{ "ancestorSensitive", "Boolean", Frame },
	{ "ancestorSensitive", "Boolean", Grip },
	{ "ancestorSensitive", "Boolean", Group },
	{ "ancestorSensitive", "Boolean", Gterm },
	{ "ancestorSensitive", "Boolean", HTML },
	{ "ancestorSensitive", "Boolean", Icon },
	{ "ancestorSensitive", "Boolean", Label },
	{ "ancestorSensitive", "Boolean", Layout },
	{ "ancestorSensitive", "Boolean", List },
	{ "ancestorSensitive", "Boolean", MenuButton },
	{ "ancestorSensitive", "Boolean", MultiList },
	{ "ancestorSensitive", "Boolean", OverrideShell },
	{ "ancestorSensitive", "Boolean", Paned },
	{ "ancestorSensitive", "Boolean", Panner },
	{ "ancestorSensitive", "Boolean", Porthole },
	{ "ancestorSensitive", "Boolean", RadioGroup },
	{ "ancestorSensitive", "Boolean", Repeater },
	{ "ancestorSensitive", "Boolean", RowCol },
	{ "ancestorSensitive", "Boolean", Scrollbar },
	{ "ancestorSensitive", "Boolean", Scrollbar2 },
	{ "ancestorSensitive", "Boolean", Shell },
	{ "ancestorSensitive", "Boolean", Simple },
	{ "ancestorSensitive", "Boolean", SimpleMenu },
	{ "ancestorSensitive", "Boolean", Slider2d },
	{ "ancestorSensitive", "Boolean", Sme },
	{ "ancestorSensitive", "Boolean", SmeBSB },
	{ "ancestorSensitive", "Boolean", SmeLine },
	{ "ancestorSensitive", "Boolean", StripChart },
	{ "ancestorSensitive", "Boolean", TextBox },
	{ "ancestorSensitive", "Boolean", TextButton },
	{ "ancestorSensitive", "Boolean", TextToggle },
	{ "ancestorSensitive", "Boolean", Toggle },
	{ "ancestorSensitive", "Boolean", TopLevelShell },
	{ "ancestorSensitive", "Boolean", TransientShell },
	{ "ancestorSensitive", "Boolean", Tree },
	{ "ancestorSensitive", "Boolean", Viewport },
	{ "ancestorSensitive", "Boolean", WMShell },
	{ "ancestorSensitive", "Boolean", XfwfCommon },
	{ "ancestorSensitive", "Boolean", XfwfMenuBar },
	{ "anchorCallback", "Callback", HTML },
	{ "anchorColor", "Pixel", HTML },
	{ "anchorUnderlines", "Int", HTML },
	{ "argc", "Int", ApplicationShell },
	{ "argv", "StringArray", ApplicationShell },
	{ "arrowShadow", "Dimension", Arrow },
	{ "autoFill", "Boolean", AsciiText },
	{ "autoReconfigure", "Boolean", Tree },
	{ "background", "Pixel", ApplicationShell },
	{ "background", "Pixel", Arrow },
	{ "background", "Pixel", AsciiSink },
	{ "background", "Pixel", AsciiText },
	{ "background", "Pixel", Board },
	{ "background", "Pixel", Box },
	{ "background", "Pixel", Command },
	{ "background", "Pixel", Core },
	{ "background", "Pixel", Dialog },
	{ "background", "Pixel", Form },
	{ "background", "Pixel", Frame },
	{ "background", "Pixel", Group },
	{ "background", "Pixel", Gterm },
	{ "background", "Pixel", HTML },
	{ "background", "Pixel", Icon },
	{ "background", "Pixel", Label },
	{ "background", "Pixel", Layout },
	{ "background", "Pixel", List },
	{ "background", "Pixel", MenuButton },
	{ "background", "Pixel", MultiList },
	{ "background", "Pixel", OverrideShell },
	{ "background", "Pixel", Paned },
	{ "background", "Pixel", Panner },
	{ "background", "Pixel", Porthole },
	{ "background", "Pixel", RadioGroup },
	{ "background", "Pixel", Repeater },
	{ "background", "Pixel", RowCol },
	{ "background", "Pixel", Scrollbar },
	{ "background", "Pixel", Scrollbar2 },
	{ "background", "Pixel", Shell },
	{ "background", "Pixel", Simple },
	{ "background", "Pixel", SimpleMenu },
	{ "background", "Pixel", Slider2d },
	{ "background", "Pixel", StripChart },
	{ "background", "Pixel", TextBox },
	{ "background", "Pixel", TextButton },
	{ "background", "Pixel", TextToggle },
	{ "background", "Pixel", Toggle },
	{ "background", "Pixel", TopLevelShell },
	{ "background", "Pixel", TransientShell },
	{ "background", "Pixel", Tree },
	{ "background", "Pixel", Viewport },
	{ "background", "Pixel", WMShell },
	{ "background", "Pixel", XfwfCommon },
	{ "background", "Pixel", XfwfMenuBar },
	{ "backgroundPixmap", "Pixmap", ApplicationShell },
	{ "backgroundPixmap", "Pixmap", Arrow },
	{ "backgroundPixmap", "Pixmap", AsciiText },
	{ "backgroundPixmap", "Pixmap", Board },
	{ "backgroundPixmap", "Pixmap", Box },
	{ "backgroundPixmap", "Pixmap", Command },
	{ "backgroundPixmap", "Pixmap", Core },
	{ "backgroundPixmap", "Pixmap", Dialog },
	{ "backgroundPixmap", "Pixmap", Form },
	{ "backgroundPixmap", "Pixmap", Frame },
	{ "backgroundPixmap", "Pixmap", Grip },
	{ "backgroundPixmap", "Pixmap", Group },
	{ "backgroundPixmap", "Pixmap", Gterm },
	{ "backgroundPixmap", "Pixmap", HTML },
	{ "backgroundPixmap", "Pixmap", Icon },
	{ "backgroundPixmap", "Pixmap", Label },
	{ "backgroundPixmap", "Pixmap", Layout },
	{ "backgroundPixmap", "Pixmap", List },
	{ "backgroundPixmap", "Pixmap", MenuButton },
	{ "backgroundPixmap", "Pixmap", MultiList },
	{ "backgroundPixmap", "Pixmap", OverrideShell },
	{ "backgroundPixmap", "Pixmap", Paned },
	{ "backgroundPixmap", "Pixmap", Panner },
	{ "backgroundPixmap", "Pixmap", Porthole },
	{ "backgroundPixmap", "Pixmap", RadioGroup },
	{ "backgroundPixmap", "Pixmap", Repeater },
	{ "backgroundPixmap", "Pixmap", RowCol },
	{ "backgroundPixmap", "Pixmap", Scrollbar },
	{ "backgroundPixmap", "Pixmap", Scrollbar2 },
	{ "backgroundPixmap", "Pixmap", Shell },
	{ "backgroundPixmap", "Pixmap", Simple },
	{ "backgroundPixmap", "Pixmap", SimpleMenu },
	{ "backgroundPixmap", "Pixmap", Slider2d },
	{ "backgroundPixmap", "Pixmap", StripChart },
	{ "backgroundPixmap", "Pixmap", TextBox },
	{ "backgroundPixmap", "Pixmap", TextButton },
	{ "backgroundPixmap", "Pixmap", TextToggle },
	{ "backgroundPixmap", "Pixmap", Toggle },
	{ "backgroundPixmap", "Pixmap", TopLevelShell },
	{ "backgroundPixmap", "Pixmap", TransientShell },
	{ "backgroundPixmap", "Pixmap", Tree },
	{ "backgroundPixmap", "Pixmap", Viewport },
	{ "backgroundPixmap", "Pixmap", WMShell },
	{ "backgroundPixmap", "Pixmap", XfwfCommon },
	{ "backgroundPixmap", "Pixmap", XfwfMenuBar },
	{ "backgroundStipple", "String", Panner },
	{ "backingStore", "BackingStore", SimpleMenu },
	{ "baseHeight", "Int", ApplicationShell },
	{ "baseHeight", "Int", TopLevelShell },
	{ "baseHeight", "Int", TransientShell },
	{ "baseHeight", "Int", WMShell },
	{ "basePixel", "Int", Gterm },
	{ "baseWidth", "Int", ApplicationShell },
	{ "baseWidth", "Int", TopLevelShell },
	{ "baseWidth", "Int", TransientShell },
	{ "baseWidth", "Int", WMShell },
	{ "betweenCursor", "Cursor", Paned },
	{ "bitmap", "Bitmap", Command },
	{ "bitmap", "Bitmap", Label },
	{ "bitmap", "Bitmap", MenuButton },
	{ "bitmap", "Bitmap", Repeater },
	{ "bitmap", "Bitmap", Toggle },
	{ "boldFont", "FontStruct", HTML },
	{ "borderColor", "Pixel", ApplicationShell },
	{ "borderColor", "Pixel", Arrow },
	{ "borderColor", "Pixel", AsciiText },
	{ "borderColor", "Pixel", Board },
	{ "borderColor", "Pixel", Box },
	{ "borderColor", "Pixel", Command },
	{ "borderColor", "Pixel", Core },
	{ "borderColor", "Pixel", Dialog },
	{ "borderColor", "Pixel", Form },
	{ "borderColor", "Pixel", Frame },
	{ "borderColor", "Pixel", Grip },
	{ "borderColor", "Pixel", Group },
	{ "borderColor", "Pixel", Gterm },
	{ "borderColor", "Pixel", HTML },
	{ "borderColor", "Pixel", Icon },
	{ "borderColor", "Pixel", Label },
	{ "borderColor", "Pixel", Layout },
	{ "borderColor", "Pixel", List },
	{ "borderColor", "Pixel", MenuButton },
	{ "borderColor", "Pixel", MultiList },
	{ "borderColor", "Pixel", OverrideShell },
	{ "borderColor", "Pixel", Paned },
	{ "borderColor", "Pixel", Panner },
	{ "borderColor", "Pixel", Porthole },
	{ "borderColor", "Pixel", RadioGroup },
	{ "borderColor", "Pixel", Repeater },
	{ "borderColor", "Pixel", RowCol },
	{ "borderColor", "Pixel", Scrollbar },
	{ "borderColor", "Pixel", Scrollbar2 },
	{ "borderColor", "Pixel", Shell },
	{ "borderColor", "Pixel", Simple },
	{ "borderColor", "Pixel", SimpleMenu },
	{ "borderColor", "Pixel", Slider2d },
	{ "borderColor", "Pixel", StripChart },
	{ "borderColor", "Pixel", TextBox },
	{ "borderColor", "Pixel", TextButton },
	{ "borderColor", "Pixel", TextToggle },
	{ "borderColor", "Pixel", Toggle },
	{ "borderColor", "Pixel", TopLevelShell },
	{ "borderColor", "Pixel", TransientShell },
	{ "borderColor", "Pixel", Tree },
	{ "borderColor", "Pixel", Viewport },
	{ "borderColor", "Pixel", WMShell },
	{ "borderColor", "Pixel", XfwfCommon },
	{ "borderColor", "Pixel", XfwfMenuBar },
	{ "borderPixmap", "Pixmap", ApplicationShell },
	{ "borderPixmap", "Pixmap", Arrow },
	{ "borderPixmap", "Pixmap", AsciiText },
	{ "borderPixmap", "Pixmap", Board },
	{ "borderPixmap", "Pixmap", Box },
	{ "borderPixmap", "Pixmap", Command },
	{ "borderPixmap", "Pixmap", Core },
	{ "borderPixmap", "Pixmap", Dialog },
	{ "borderPixmap", "Pixmap", Form },
	{ "borderPixmap", "Pixmap", Frame },
	{ "borderPixmap", "Pixmap", Grip },
	{ "borderPixmap", "Pixmap", Group },
	{ "borderPixmap", "Pixmap", Gterm },
	{ "borderPixmap", "Pixmap", HTML },
	{ "borderPixmap", "Pixmap", Icon },
	{ "borderPixmap", "Pixmap", Label },
	{ "borderPixmap", "Pixmap", Layout },
	{ "borderPixmap", "Pixmap", List },
	{ "borderPixmap", "Pixmap", MenuButton },
	{ "borderPixmap", "Pixmap", MultiList },
	{ "borderPixmap", "Pixmap", OverrideShell },
	{ "borderPixmap", "Pixmap", Paned },
	{ "borderPixmap", "Pixmap", Panner },
	{ "borderPixmap", "Pixmap", Porthole },
	{ "borderPixmap", "Pixmap", RadioGroup },
	{ "borderPixmap", "Pixmap", Repeater },
	{ "borderPixmap", "Pixmap", RowCol },
	{ "borderPixmap", "Pixmap", Scrollbar },
	{ "borderPixmap", "Pixmap", Scrollbar2 },
	{ "borderPixmap", "Pixmap", Shell },
	{ "borderPixmap", "Pixmap", Simple },
	{ "borderPixmap", "Pixmap", SimpleMenu },
	{ "borderPixmap", "Pixmap", Slider2d },
	{ "borderPixmap", "Pixmap", StripChart },
	{ "borderPixmap", "Pixmap", TextBox },
	{ "borderPixmap", "Pixmap", TextButton },
	{ "borderPixmap", "Pixmap", TextToggle },
	{ "borderPixmap", "Pixmap", Toggle },
	{ "borderPixmap", "Pixmap", TopLevelShell },
	{ "borderPixmap", "Pixmap", TransientShell },
	{ "borderPixmap", "Pixmap", Tree },
	{ "borderPixmap", "Pixmap", Viewport },
	{ "borderPixmap", "Pixmap", WMShell },
	{ "borderPixmap", "Pixmap", XfwfCommon },
	{ "borderPixmap", "Pixmap", XfwfMenuBar },
	{ "borderWidth", "Dimension", ApplicationShell },
	{ "borderWidth", "Dimension", Arrow },
	{ "borderWidth", "Dimension", AsciiText },
	{ "borderWidth", "Dimension", Board },
	{ "borderWidth", "Dimension", Box },
	{ "borderWidth", "Dimension", Command },
	{ "borderWidth", "Dimension", Core },
	{ "borderWidth", "Dimension", Dialog },
	{ "borderWidth", "Dimension", Form },
	{ "borderWidth", "Dimension", Frame },
	{ "borderWidth", "Dimension", Grip },
	{ "borderWidth", "Dimension", Group },
	{ "borderWidth", "Dimension", Gterm },
	{ "borderWidth", "Dimension", HTML },
	{ "borderWidth", "Dimension", Icon },
	{ "borderWidth", "Dimension", Label },
	{ "borderWidth", "Dimension", Layout },
	{ "borderWidth", "Dimension", List },
	{ "borderWidth", "Dimension", MenuButton },
	{ "borderWidth", "Dimension", MultiList },
	{ "borderWidth", "Dimension", OverrideShell },
	{ "borderWidth", "Dimension", Paned },
	{ "borderWidth", "Dimension", Panner },
	{ "borderWidth", "Dimension", Porthole },
	{ "borderWidth", "Dimension", RadioGroup },
	{ "borderWidth", "Dimension", Repeater },
	{ "borderWidth", "Dimension", RowCol },
	{ "borderWidth", "Dimension", Scrollbar },
	{ "borderWidth", "Dimension", Scrollbar2 },
	{ "borderWidth", "Dimension", Shell },
	{ "borderWidth", "Dimension", Simple },
	{ "borderWidth", "Dimension", SimpleMenu },
	{ "borderWidth", "Dimension", Slider2d },
	{ "borderWidth", "Dimension", Sme },
	{ "borderWidth", "Dimension", SmeBSB },
	{ "borderWidth", "Dimension", SmeLine },
	{ "borderWidth", "Dimension", StripChart },
	{ "borderWidth", "Dimension", TextBox },
	{ "borderWidth", "Dimension", TextButton },
	{ "borderWidth", "Dimension", TextToggle },
	{ "borderWidth", "Dimension", Toggle },
	{ "borderWidth", "Dimension", TopLevelShell },
	{ "borderWidth", "Dimension", TransientShell },
	{ "borderWidth", "Dimension", Tree },
	{ "borderWidth", "Dimension", Viewport },
	{ "borderWidth", "Dimension", WMShell },
	{ "borderWidth", "Dimension", XfwfCommon },
	{ "borderWidth", "Dimension", XfwfMenuBar },
	{ "bottom", "EdgeType", Dialog },
	{ "bottom", "EdgeType", Form },
	{ "bottom", "EdgeType", Viewport },
	{ "bottomMargin", "Dimension", SimpleMenu },
	{ "bottomMargin", "Dimension", Slider2d },
	{ "bottomMargin", "Dimension", TextBox },
	{ "bottomMargin", "Dimension", TextButton },
	{ "bottomMargin", "Dimension", TextToggle },
	{ "bottomMargin", "Position", AsciiText },
	{ "bottomShadowColor", "Pixel", Arrow },
	{ "bottomShadowColor", "Pixel", Board },
	{ "bottomShadowColor", "Pixel", Frame },
	{ "bottomShadowColor", "Pixel", Group },
	{ "bottomShadowColor", "Pixel", Icon },
	{ "bottomShadowColor", "Pixel", RadioGroup },
	{ "bottomShadowColor", "Pixel", RowCol },
	{ "bottomShadowColor", "Pixel", Scrollbar2 },
	{ "bottomShadowColor", "Pixel", Slider2d },
	{ "bottomShadowColor", "Pixel", TextBox },
	{ "bottomShadowColor", "Pixel", TextButton },
	{ "bottomShadowColor", "Pixel", TextToggle },
	{ "bottomShadowColor", "Pixel", XfwfMenuBar },
	{ "bottomShadowStipple", "Bitmap", Arrow },
	{ "bottomShadowStipple", "Bitmap", Board },
	{ "bottomShadowStipple", "Bitmap", Frame },
	{ "bottomShadowStipple", "Bitmap", Group },
	{ "bottomShadowStipple", "Bitmap", Icon },
	{ "bottomShadowStipple", "Bitmap", RadioGroup },
	{ "bottomShadowStipple", "Bitmap", RowCol },
	{ "bottomShadowStipple", "Bitmap", Scrollbar2 },
	{ "bottomShadowStipple", "Bitmap", Slider2d },
	{ "bottomShadowStipple", "Bitmap", TextBox },
	{ "bottomShadowStipple", "Bitmap", TextButton },
	{ "bottomShadowStipple", "Bitmap", TextToggle },
	{ "bottomShadowStipple", "Bitmap", XfwfMenuBar },
	{ "busyCursor", "String", Gterm },
	{ "busyCursorBgColor", "Pixel", Gterm },
	{ "busyCursorFgColor", "Pixel", Gterm },
	{ "cacheRasters", "String", Gterm },
	{ "callback", "Callback", Arrow },
	{ "callback", "Callback", AsciiSrc },
	{ "callback", "Callback", AsciiText },
	{ "callback", "Callback", Command },
	{ "callback", "Callback", Grip },
	{ "callback", "Callback", List },
	{ "callback", "Callback", MenuButton },
	{ "callback", "Callback", MultiList },
	{ "callback", "Callback", Repeater },
	{ "callback", "Callback", Sme },
	{ "callback", "Callback", SmeBSB },
	{ "callback", "Callback", SmeLine },
	{ "callback", "Callback", Toggle },
	{ "canvasHeight", "Dimension", Panner },
	{ "canvasWidth", "Dimension", Panner },
	{ "children", "WidgetList", ApplicationShell },
	{ "children", "WidgetList", Arrow },
	{ "children", "WidgetList", Board },
	{ "children", "WidgetList", Box },
	{ "children", "WidgetList", Dialog },
	{ "children", "WidgetList", Form },
	{ "children", "WidgetList", Frame },
	{ "children", "WidgetList", Group },
	{ "children", "WidgetList", HTML },
	{ "children", "WidgetList", Icon },
	{ "children", "WidgetList", Layout },
	{ "children", "WidgetList", OverrideShell },
	{ "children", "WidgetList", Paned },
	{ "children", "WidgetList", Porthole },
	{ "children", "WidgetList", RadioGroup },
	{ "children", "WidgetList", RowCol },
	{ "children", "WidgetList", Scrollbar2 },
	{ "children", "WidgetList", Shell },
	{ "children", "WidgetList", SimpleMenu },
	{ "children", "WidgetList", Slider2d },
	{ "children", "WidgetList", TextBox },
	{ "children", "WidgetList", TextButton },
	{ "children", "WidgetList", TextToggle },
	{ "children", "WidgetList", TopLevelShell },
	{ "children", "WidgetList", TransientShell },
	{ "children", "WidgetList", Tree },
	{ "children", "WidgetList", Viewport },
	{ "children", "WidgetList", WMShell },
	{ "children", "WidgetList", XfwfCommon },
	{ "children", "WidgetList", XfwfMenuBar },
	{ "cmapInterpolate", "Boolean", Gterm },
	{ "cmapName", "String", Gterm },
	{ "cmapShadow", "Int", Gterm },
	{ "cmapUpdate", "Int", Gterm },
	{ "color0", "Pixel", Gterm },
	{ "color1", "Pixel", Gterm },
	{ "color2", "Pixel", Gterm },
	{ "color3", "Pixel", Gterm },
	{ "color4", "Pixel", Gterm },
	{ "color5", "Pixel", Gterm },
	{ "color6", "Pixel", Gterm },
	{ "color7", "Pixel", Gterm },
	{ "color8", "Pixel", Gterm },
	{ "color9", "Pixel", Gterm },
	{ "colormap", "Colormap", ApplicationShell },
	{ "colormap", "Colormap", Arrow },
	{ "colormap", "Colormap", AsciiText },
	{ "colormap", "Colormap", Board },
	{ "colormap", "Colormap", Box },
	{ "colormap", "Colormap", Command },
	{ "colormap", "Colormap", Core },
	{ "colormap", "Colormap", Dialog },
	{ "colormap", "Colormap", Form },
	{ "colormap", "Colormap", Frame },
	{ "colormap", "Colormap", Grip },
	{ "colormap", "Colormap", Group },
	{ "colormap", "Colormap", Gterm },
	{ "colormap", "Colormap", HTML },
	{ "colormap", "Colormap", Icon },
	{ "colormap", "Colormap", Label },
	{ "colormap", "Colormap", Layout },
	{ "colormap", "Colormap", List },
	{ "colormap", "Colormap", MenuButton },
	{ "colormap", "Colormap", MultiList },
	{ "colormap", "Colormap", OverrideShell },
	{ "colormap", "Colormap", Paned },
	{ "colormap", "Colormap", Panner },
	{ "colormap", "Colormap", Porthole },
	{ "colormap", "Colormap", RadioGroup },
	{ "colormap", "Colormap", Repeater },
	{ "colormap", "Colormap", RowCol },
	{ "colormap", "Colormap", Scrollbar },
	{ "colormap", "Colormap", Scrollbar2 },
	{ "colormap", "Colormap", Shell },
	{ "colormap", "Colormap", Simple },
	{ "colormap", "Colormap", SimpleMenu },
	{ "colormap", "Colormap", Slider2d },
	{ "colormap", "Colormap", StripChart },
	{ "colormap", "Colormap", TextBox },
	{ "colormap", "Colormap", TextButton },
	{ "colormap", "Colormap", TextToggle },
	{ "colormap", "Colormap", Toggle },
	{ "colormap", "Colormap", TopLevelShell },
	{ "colormap", "Colormap", TransientShell },
	{ "colormap", "Colormap", Tree },
	{ "colormap", "Colormap", Viewport },
	{ "colormap", "Colormap", WMShell },
	{ "colormap", "Colormap", XfwfCommon },
	{ "colormap", "Colormap", XfwfMenuBar },
	{ "columnSpacing", "Dimension", List },
	{ "columnSpacing", "Dimension", MultiList },
	{ "columnWidth", "Dimension", MultiList },
	{ "columns", "Int", Group },
	{ "columns", "Int", RadioGroup },
	{ "columns", "Int", RowCol },
	{ "columns", "Int", XfwfMenuBar },
	{ "copyOnResize", "Boolean", Gterm },
	{ "cornerRoundPercent", "Dimension", Command },
	{ "cornerRoundPercent", "Dimension", MenuButton },
	{ "cornerRoundPercent", "Dimension", Repeater },
	{ "cornerRoundPercent", "Dimension", Toggle },
	{ "createPopupChildProc", "Function", ApplicationShell },
	{ "createPopupChildProc", "Function", OverrideShell },
	{ "createPopupChildProc", "Function", Shell },
	{ "createPopupChildProc", "Function", SimpleMenu },
	{ "createPopupChildProc", "Function", TopLevelShell },
	{ "createPopupChildProc", "Function", TransientShell },
	{ "createPopupChildProc", "Function", WMShell },
	{ "crosshairCursorColor", "Pixel", Gterm },
	{ "cursor", "Cursor", Arrow },
	{ "cursor", "Cursor", AsciiText },
	{ "cursor", "Cursor", Board },
	{ "cursor", "Cursor", Command },
	{ "cursor", "Cursor", Frame },
	{ "cursor", "Cursor", Grip },
	{ "cursor", "Cursor", Group },
	{ "cursor", "Cursor", Icon },
	{ "cursor", "Cursor", Label },
	{ "cursor", "Cursor", List },
	{ "cursor", "Cursor", MenuButton },
	{ "cursor", "Cursor", MultiList },
	{ "cursor", "Cursor", Paned },
	{ "cursor", "Cursor", Panner },
	{ "cursor", "Cursor", RadioGroup },
	{ "cursor", "Cursor", Repeater },
	{ "cursor", "Cursor", RowCol },
	{ "cursor", "Cursor", Scrollbar },
	{ "cursor", "Cursor", Scrollbar2 },
	{ "cursor", "Cursor", Simple },
	{ "cursor", "Cursor", SimpleMenu },
	{ "cursor", "Cursor", Slider2d },
	{ "cursor", "Cursor", StripChart },
	{ "cursor", "Cursor", TextBox },
	{ "cursor", "Cursor", TextButton },
	{ "cursor", "Cursor", TextToggle },
	{ "cursor", "Cursor", Toggle },
	{ "cursor", "Cursor", XfwfMenuBar },
	{ "cursorName", "String", AsciiText },
	{ "cursorName", "String", Command },
	{ "cursorName", "String", Grip },
	{ "cursorName", "String", Label },
	{ "cursorName", "String", List },
	{ "cursorName", "String", MenuButton },
	{ "cursorName", "String", MultiList },
	{ "cursorName", "String", Panner },
	{ "cursorName", "String", Repeater },
	{ "cursorName", "String", Scrollbar },
	{ "cursorName", "String", Simple },
	{ "cursorName", "String", StripChart },
	{ "cursorName", "String", Toggle },
	{ "dashedAnchorUnderlines", "Boolean", HTML },
	{ "dashedVisitedAnchorUnderlines", "Boolean", HTML },
	{ "dataCompression", "Boolean", AsciiSrc },
	{ "dataCompression", "Boolean", AsciiText },
	{ "debug", "Boolean", Layout },
	{ "decay", "Int", Repeater },
	{ "defaultColumns", "Int", List },
	{ "defaultColumns", "Int", MultiList },
	{ "defaultDistance", "Int", Dialog },
	{ "defaultDistance", "Int", Form },
	{ "defaultDistance", "Int", Viewport },
	{ "defaultMarker", "String", Gterm },
	{ "defaultScale", "Dimension", Panner },
	{ "deiconifyWindow", "Boolean", Gterm },
	{ "delayImageLoads", "Boolean", HTML },
	{ "depth", "Int", ApplicationShell },
	{ "depth", "Int", Arrow },
	{ "depth", "Int", AsciiText },
	{ "depth", "Int", Board },
	{ "depth", "Int", Box },
	{ "depth", "Int", Command },
	{ "depth", "Int", Core },
	{ "depth", "Int", Dialog },
	{ "depth", "Int", Form },
	{ "depth", "Int", Frame },
	{ "depth", "Int", Grip },
	{ "depth", "Int", Group },
	{ "depth", "Int", Gterm },
	{ "depth", "Int", HTML },
	{ "depth", "Int", Icon },
	{ "depth", "Int", Label },
	{ "depth", "Int", Layout },
	{ "depth", "Int", List },
	{ "depth", "Int", MenuButton },
	{ "depth", "Int", MultiList },
	{ "depth", "Int", OverrideShell },
	{ "depth", "Int", Paned },
	{ "depth", "Int", Panner },
	{ "depth", "Int", Porthole },
	{ "depth", "Int", RadioGroup },
	{ "depth", "Int", Repeater },
	{ "depth", "Int", RowCol },
	{ "depth", "Int", Scrollbar },
	{ "depth", "Int", Scrollbar2 },
	{ "depth", "Int", Shell },
	{ "depth", "Int", Simple },
	{ "depth", "Int", SimpleMenu },
	{ "depth", "Int", Slider2d },
	{ "depth", "Int", StripChart },
	{ "depth", "Int", TextBox },
	{ "depth", "Int", TextButton },
	{ "depth", "Int", TextToggle },
	{ "depth", "Int", Toggle },
	{ "depth", "Int", TopLevelShell },
	{ "depth", "Int", TransientShell },
	{ "depth", "Int", Tree },
	{ "depth", "Int", Viewport },
	{ "depth", "Int", WMShell },
	{ "depth", "Int", XfwfCommon },
	{ "depth", "Int", XfwfMenuBar },
	{ "destroyCallback", "Callback", ApplicationShell },
	{ "destroyCallback", "Callback", Arrow },
	{ "destroyCallback", "Callback", AsciiSink },
	{ "destroyCallback", "Callback", AsciiSrc },
	{ "destroyCallback", "Callback", AsciiText },
	{ "destroyCallback", "Callback", Board },
	{ "destroyCallback", "Callback", Box },
	{ "destroyCallback", "Callback", Command },
	{ "destroyCallback", "Callback", Core },
	{ "destroyCallback", "Callback", Dialog },
	{ "destroyCallback", "Callback", Form },
	{ "destroyCallback", "Callback", Frame },
	{ "destroyCallback", "Callback", Grip },
	{ "destroyCallback", "Callback", Group },
	{ "destroyCallback", "Callback", Gterm },
	{ "destroyCallback", "Callback", HTML },
	{ "destroyCallback", "Callback", Icon },
	{ "destroyCallback", "Callback", Label },
	{ "destroyCallback", "Callback", Layout },
	{ "destroyCallback", "Callback", List },
	{ "destroyCallback", "Callback", MenuButton },
	{ "destroyCallback", "Callback", MultiList },
	{ "destroyCallback", "Callback", Object },
	{ "destroyCallback", "Callback", OverrideShell },
	{ "destroyCallback", "Callback", Paned },
	{ "destroyCallback", "Callback", Panner },
	{ "destroyCallback", "Callback", Porthole },
	{ "destroyCallback", "Callback", RadioGroup },
	{ "destroyCallback", "Callback", Repeater },
	{ "destroyCallback", "Callback", RowCol },
	{ "destroyCallback", "Callback", Scrollbar },
	{ "destroyCallback", "Callback", Scrollbar2 },
	{ "destroyCallback", "Callback", Shell },
	{ "destroyCallback", "Callback", Simple },
	{ "destroyCallback", "Callback", SimpleMenu },
	{ "destroyCallback", "Callback", Slider2d },
	{ "destroyCallback", "Callback", Sme },
	{ "destroyCallback", "Callback", SmeBSB },
	{ "destroyCallback", "Callback", SmeLine },
	{ "destroyCallback", "Callback", StripChart },
	{ "destroyCallback", "Callback", TextBox },
	{ "destroyCallback", "Callback", TextButton },
	{ "destroyCallback", "Callback", TextToggle },
	{ "destroyCallback", "Callback", Toggle },
	{ "destroyCallback", "Callback", TopLevelShell },
	{ "destroyCallback", "Callback", TransientShell },
	{ "destroyCallback", "Callback", Tree },
	{ "destroyCallback", "Callback", Viewport },
	{ "destroyCallback", "Callback", WMShell },
	{ "destroyCallback", "Callback", XfwfCommon },
	{ "destroyCallback", "Callback", XfwfMenuBar },
	{ "dialogBgColor", "Pixel", Gterm },
	{ "dialogFgColor", "Pixel", Gterm },
	{ "dialogFont1", "FontStruct", Gterm },
	{ "dialogFont2", "FontStruct", Gterm },
	{ "dialogFont3", "FontStruct", Gterm },
	{ "dialogFont4", "FontStruct", Gterm },
	{ "dialogFont5", "FontStruct", Gterm },
	{ "dialogFont6", "FontStruct", Gterm },
	{ "dialogFont7", "FontStruct", Gterm },
	{ "dialogFont8", "FontStruct", Gterm },
	{ "direction", "Alignment", Arrow },
	{ "displayCaret", "Boolean", AsciiText },
	{ "displayNonprinting", "Boolean", AsciiSink },
	{ "displayNonprinting", "Boolean", AsciiText },
	{ "displayPosition", "Int", AsciiText },
	{ "echo", "Boolean", AsciiSink },
	{ "echo", "Boolean", AsciiText },
	{ "editType", "EditMode", AsciiSrc },
	{ "editType", "EditMode", AsciiText },
	{ "encoding", "UnsignedChar", Command },
	{ "encoding", "UnsignedChar", Label },
	{ "encoding", "UnsignedChar", MenuButton },
	{ "encoding", "UnsignedChar", Repeater },
	{ "encoding", "UnsignedChar", Toggle },
	{ "fancySelections", "Boolean", HTML },
	{ "fixedFont", "FontStruct", HTML },
	{ "fixedboldFont", "FontStruct", HTML },
	{ "fixeditalicFont", "FontStruct", HTML },
	{ "flash", "Boolean", Repeater },
	{ "font", "FontStruct", AsciiSink },
	{ "font", "FontStruct", AsciiText },
	{ "font", "FontStruct", Command },
	{ "font", "FontStruct", Group },
	{ "font", "FontStruct", HTML },
	{ "font", "FontStruct", Label },
	{ "font", "FontStruct", List },
	{ "font", "FontStruct", MenuButton },
	{ "font", "FontStruct", MultiList },
	{ "font", "FontStruct", RadioGroup },
	{ "font", "FontStruct", Repeater },
	{ "font", "FontStruct", Slider2d },
	{ "font", "FontStruct", SmeBSB },
	{ "font", "FontStruct", TextBox },
	{ "font", "FontStruct", TextButton },
	{ "font", "FontStruct", TextToggle },
	{ "font", "FontStruct", Toggle },
	{ "footerText", "String", HTML },
	{ "forceBars", "Boolean", Viewport },
	{ "forceColumns", "Boolean", List },
	{ "forceColumns", "Boolean", MultiList },
	{ "foreground", "Pixel", Arrow },
	{ "foreground", "Pixel", AsciiSink },
	{ "foreground", "Pixel", AsciiText },
	{ "foreground", "Pixel", Command },
	{ "foreground", "Pixel", Grip },
	{ "foreground", "Pixel", Group },
	{ "foreground", "Pixel", HTML },
	{ "foreground", "Pixel", Label },
	{ "foreground", "Pixel", List },
	{ "foreground", "Pixel", MenuButton },
	{ "foreground", "Pixel", MultiList },
	{ "foreground", "Pixel", Panner },
	{ "foreground", "Pixel", RadioGroup },
	{ "foreground", "Pixel", Repeater },
	{ "foreground", "Pixel", Scrollbar },
	{ "foreground", "Pixel", Slider2d },
	{ "foreground", "Pixel", SmeBSB },
	{ "foreground", "Pixel", SmeLine },
	{ "foreground", "Pixel", StripChart },
	{ "foreground", "Pixel", TextBox },
	{ "foreground", "Pixel", TextButton },
	{ "foreground", "Pixel", TextToggle },
	{ "foreground", "Pixel", Toggle },
	{ "foreground", "Pixel", Tree },
	{ "frameType", "FrameType", Arrow },
	{ "frameType", "FrameType", Board },
	{ "frameType", "FrameType", Frame },
	{ "frameType", "FrameType", Group },
	{ "frameType", "FrameType", Icon },
	{ "frameType", "FrameType", RadioGroup },
	{ "frameType", "FrameType", RowCol },
	{ "frameType", "FrameType", Scrollbar2 },
	{ "frameType", "FrameType", Slider2d },
	{ "frameType", "FrameType", TextBox },
	{ "frameType", "FrameType", TextButton },
	{ "frameType", "FrameType", TextToggle },
	{ "frameType", "FrameType", XfwfMenuBar },
	{ "frameWidth", "Dimension", Arrow },
	{ "frameWidth", "Dimension", Board },
	{ "frameWidth", "Dimension", Frame },
	{ "frameWidth", "Dimension", Group },
	{ "frameWidth", "Dimension", Icon },
	{ "frameWidth", "Dimension", RadioGroup },
	{ "frameWidth", "Dimension", RowCol },
	{ "frameWidth", "Dimension", Scrollbar2 },
	{ "frameWidth", "Dimension", Slider2d },
	{ "frameWidth", "Dimension", TextBox },
	{ "frameWidth", "Dimension", TextButton },
	{ "frameWidth", "Dimension", TextToggle },
	{ "frameWidth", "Dimension", XfwfMenuBar },
	{ "fromHoriz", "Widget", Dialog },
	{ "fromHoriz", "Widget", Form },
	{ "fromHoriz", "Widget", Viewport },
	{ "fromVert", "Widget", Dialog },
	{ "fromVert", "Widget", Form },
	{ "fromVert", "Widget", Viewport },
	{ "geometry", "String", ApplicationShell },
	{ "geometry", "String", OverrideShell },
	{ "geometry", "String", Shell },
	{ "geometry", "String", SimpleMenu },
	{ "geometry", "String", TopLevelShell },
	{ "geometry", "String", TransientShell },
	{ "geometry", "String", WMShell },
	{ "getValue", "Callback", StripChart },
	{ "ginmodeBlinkInterval", "Int", Gterm },
	{ "ginmodeCursor", "String", Gterm },
	{ "ginmodeCursorBgColor", "Pixel", Gterm },
	{ "ginmodeCursorFgColor", "Pixel", Gterm },
	{ "gravity", "Gravity", Tree },
	{ "gripCursor", "Cursor", Paned },
	{ "gripIndent", "Position", Paned },
	{ "gripTranslations", "TranslationTable", Paned },
	{ "hSpace", "Dimension", Box },
	{ "hSpace", "Dimension", Tree },
	{ "header1Font1Font", "FontStruct", HTML },
	{ "header2Font2Font", "FontStruct", HTML },
	{ "header3Font3Font", "FontStruct", HTML },
	{ "header4Font4Font", "FontStruct", HTML },
	{ "header5Font5Font", "FontStruct", HTML },
	{ "header6Font6Font", "FontStruct", HTML },
	{ "headerText", "String", HTML },
	{ "height", "Dimension", ApplicationShell },
	{ "height", "Dimension", Arrow },
	{ "height", "Dimension", AsciiText },
	{ "height", "Dimension", Board },
	{ "height", "Dimension", Box },
	{ "height", "Dimension", Command },
	{ "height", "Dimension", Core },
	{ "height", "Dimension", Dialog },
	{ "height", "Dimension", Form },
	{ "height", "Dimension", Frame },
	{ "height", "Dimension", Grip },
	{ "height", "Dimension", Group },
	{ "height", "Dimension", Gterm },
	{ "height", "Dimension", HTML },
	{ "height", "Dimension", Icon },
	{ "height", "Dimension", Label },
	{ "height", "Dimension", Layout },
	{ "height", "Dimension", List },
	{ "height", "Dimension", MenuButton },
	{ "height", "Dimension", MultiList },
	{ "height", "Dimension", OverrideShell },
	{ "height", "Dimension", Paned },
	{ "height", "Dimension", Panner },
	{ "height", "Dimension", Porthole },
	{ "height", "Dimension", RadioGroup },
	{ "height", "Dimension", Repeater },
	{ "height", "Dimension", RowCol },
	{ "height", "Dimension", Scrollbar },
	{ "height", "Dimension", Scrollbar2 },
	{ "height", "Dimension", Shell },
	{ "height", "Dimension", Simple },
	{ "height", "Dimension", SimpleMenu },
	{ "height", "Dimension", Slider2d },
	{ "height", "Dimension", Sme },
	{ "height", "Dimension", SmeBSB },
	{ "height", "Dimension", SmeLine },
	{ "height", "Dimension", StripChart },
	{ "height", "Dimension", TextBox },
	{ "height", "Dimension", TextButton },
	{ "height", "Dimension", TextToggle },
	{ "height", "Dimension", Toggle },
	{ "height", "Dimension", TopLevelShell },
	{ "height", "Dimension", TransientShell },
	{ "height", "Dimension", Tree },
	{ "height", "Dimension", Viewport },
	{ "height", "Dimension", WMShell },
	{ "height", "Dimension", XfwfCommon },
	{ "height", "Dimension", XfwfMenuBar },
	{ "heightInc", "Int", ApplicationShell },
	{ "heightInc", "Int", TopLevelShell },
	{ "heightInc", "Int", TransientShell },
	{ "heightInc", "Int", WMShell },
	{ "highlight", "Pixel", StripChart },
	{ "highlightBackground", "Pixel", MultiList },
	{ "highlightColor", "Pixel", Arrow },
	{ "highlightColor", "Pixel", Board },
	{ "highlightColor", "Pixel", Frame },
	{ "highlightColor", "Pixel", Group },
	{ "highlightColor", "Pixel", Icon },
	{ "highlightColor", "Pixel", RadioGroup },
	{ "highlightColor", "Pixel", RowCol },
	{ "highlightColor", "Pixel", Scrollbar2 },
	{ "highlightColor", "Pixel", Slider2d },
	{ "highlightColor", "Pixel", TextBox },
	{ "highlightColor", "Pixel", TextButton },
	{ "highlightColor", "Pixel", TextToggle },
	{ "highlightColor", "Pixel", XfwfCommon },
	{ "highlightColor", "Pixel", XfwfMenuBar },
	{ "highlightForeground", "Pixel", MultiList },
	{ "highlightPixmap", "Pixmap", Arrow },
	{ "highlightPixmap", "Pixmap", Board },
	{ "highlightPixmap", "Pixmap", Frame },
	{ "highlightPixmap", "Pixmap", Group },
	{ "highlightPixmap", "Pixmap", Icon },
	{ "highlightPixmap", "Pixmap", RadioGroup },
	{ "highlightPixmap", "Pixmap", RowCol },
	{ "highlightPixmap", "Pixmap", Scrollbar2 },
	{ "highlightPixmap", "Pixmap", Slider2d },
	{ "highlightPixmap", "Pixmap", TextBox },
	{ "highlightPixmap", "Pixmap", TextButton },
	{ "highlightPixmap", "Pixmap", TextToggle },
	{ "highlightPixmap", "Pixmap", XfwfCommon },
	{ "highlightPixmap", "Pixmap", XfwfMenuBar },
	{ "highlightThickness", "Dimension", Arrow },
	{ "highlightThickness", "Dimension", Board },
	{ "highlightThickness", "Dimension", Command },
	{ "highlightThickness", "Dimension", Frame },
	{ "highlightThickness", "Dimension", Group },
	{ "highlightThickness", "Dimension", Icon },
	{ "highlightThickness", "Dimension", MenuButton },
	{ "highlightThickness", "Dimension", RadioGroup },
	{ "highlightThickness", "Dimension", Repeater },
	{ "highlightThickness", "Dimension", RowCol },
	{ "highlightThickness", "Dimension", Scrollbar2 },
	{ "highlightThickness", "Dimension", Slider2d },
	{ "highlightThickness", "Dimension", TextBox },
	{ "highlightThickness", "Dimension", TextButton },
	{ "highlightThickness", "Dimension", TextToggle },
	{ "highlightThickness", "Dimension", Toggle },
	{ "highlightThickness", "Dimension", XfwfCommon },
	{ "highlightThickness", "Dimension", XfwfMenuBar },
	{ "horizDistance", "Int", Dialog },
	{ "horizDistance", "Int", Form },
	{ "horizDistance", "Int", Viewport },
	{ "horizontalBetweenCursor", "Cursor", Paned },
	{ "horizontalGripCursor", "Cursor", Paned },
	{ "horizontalScrollBar", "Widget", HTML },
	{ "horizontalScrollOnTop", "Boolean", HTML },
	{ "hunit", "Float", Arrow },
	{ "hunit", "Float", Board },
	{ "hunit", "Float", Group },
	{ "hunit", "Float", Icon },
	{ "hunit", "Float", RadioGroup },
	{ "hunit", "Float", RowCol },
	{ "hunit", "Float", Scrollbar2 },
	{ "hunit", "Float", Slider2d },
	{ "hunit", "Float", TextBox },
	{ "hunit", "Float", TextButton },
	{ "hunit", "Float", TextToggle },
	{ "hunit", "Float", XfwfMenuBar },
	{ "icon", "Bitmap", Dialog },
	{ "iconMask", "Bitmap", ApplicationShell },
	{ "iconMask", "Bitmap", TopLevelShell },
	{ "iconMask", "Bitmap", TransientShell },
	{ "iconMask", "Bitmap", WMShell },
	{ "iconName", "String", ApplicationShell },
	{ "iconName", "String", TopLevelShell },
	{ "iconNameEncoding", "Atom", ApplicationShell },
	{ "iconNameEncoding", "Atom", TopLevelShell },
	{ "iconPixmap", "Bitmap", ApplicationShell },
	{ "iconPixmap", "Bitmap", TopLevelShell },
	{ "iconPixmap", "Bitmap", TransientShell },
	{ "iconPixmap", "Bitmap", WMShell },
	{ "iconWindow", "Window", ApplicationShell },
	{ "iconWindow", "Window", TopLevelShell },
	{ "iconWindow", "Window", TransientShell },
	{ "iconWindow", "Window", WMShell },
	{ "iconX", "Int", ApplicationShell },
	{ "iconX", "Int", TopLevelShell },
	{ "iconX", "Int", TransientShell },
	{ "iconX", "Int", WMShell },
	{ "iconY", "Int", ApplicationShell },
	{ "iconY", "Int", TopLevelShell },
	{ "iconY", "Int", TransientShell },
	{ "iconY", "Int", WMShell },
	{ "iconic", "Boolean", ApplicationShell },
	{ "iconic", "Boolean", TopLevelShell },
	{ "idleCursor", "String", Gterm },
	{ "idleCursorBgColor", "Pixel", Gterm },
	{ "idleCursorFgColor", "Pixel", Gterm },
	{ "image", "Icon", Icon },
	{ "imageBorders", "Boolean", HTML },
	{ "increment", "Float", Scrollbar2 },
	{ "initialDelay", "Cardinal", Arrow },
	{ "initialDelay", "Cardinal", Scrollbar2 },
	{ "initialDelay", "Int", Repeater },
	{ "initialState", "InitialState", ApplicationShell },
	{ "initialState", "InitialState", TopLevelShell },
	{ "initialState", "InitialState", TransientShell },
	{ "initialState", "InitialState", WMShell },
	{ "innerOffset", "Dimension", Arrow },
	{ "innerOffset", "Dimension", Board },
	{ "innerOffset", "Dimension", Frame },
	{ "innerOffset", "Dimension", Group },
	{ "innerOffset", "Dimension", Icon },
	{ "innerOffset", "Dimension", RadioGroup },
	{ "innerOffset", "Dimension", RowCol },
	{ "innerOffset", "Dimension", Scrollbar2 },
	{ "innerOffset", "Dimension", Slider2d },
	{ "innerOffset", "Dimension", TextBox },
	{ "innerOffset", "Dimension", TextButton },
	{ "innerOffset", "Dimension", TextToggle },
	{ "innerOffset", "Dimension", XfwfMenuBar },
	{ "input", "Bool", ApplicationShell },
	{ "input", "Bool", TopLevelShell },
	{ "input", "Bool", TransientShell },
	{ "input", "Bool", WMShell },
	{ "insensitiveBorder", "Pixmap", AsciiText },
	{ "insensitiveBorder", "Pixmap", Command },
	{ "insensitiveBorder", "Pixmap", Grip },
	{ "insensitiveBorder", "Pixmap", Label },
	{ "insensitiveBorder", "Pixmap", List },
	{ "insensitiveBorder", "Pixmap", MenuButton },
	{ "insensitiveBorder", "Pixmap", MultiList },
	{ "insensitiveBorder", "Pixmap", Panner },
	{ "insensitiveBorder", "Pixmap", Repeater },
	{ "insensitiveBorder", "Pixmap", Scrollbar },
	{ "insensitiveBorder", "Pixmap", Simple },
	{ "insensitiveBorder", "Pixmap", StripChart },
	{ "insensitiveBorder", "Pixmap", Toggle },
	{ "insertPosition", "Function", ApplicationShell },
	{ "insertPosition", "Function", Arrow },
	{ "insertPosition", "Function", Board },
	{ "insertPosition", "Function", Box },
	{ "insertPosition", "Function", Dialog },
	{ "insertPosition", "Function", Form },
	{ "insertPosition", "Function", Frame },
	{ "insertPosition", "Function", Group },
	{ "insertPosition", "Function", HTML },
	{ "insertPosition", "Function", Icon },
	{ "insertPosition", "Function", Layout },
	{ "insertPosition", "Function", OverrideShell },
	{ "insertPosition", "Function", Paned },
	{ "insertPosition", "Function", Porthole },
	{ "insertPosition", "Function", RadioGroup },
	{ "insertPosition", "Function", RowCol },
	{ "insertPosition", "Function", Scrollbar2 },
	{ "insertPosition", "Function", Shell },
	{ "insertPosition", "Function", SimpleMenu },
	{ "insertPosition", "Function", Slider2d },
	{ "insertPosition", "Function", TextBox },
	{ "insertPosition", "Function", TextButton },
	{ "insertPosition", "Function", TextToggle },
	{ "insertPosition", "Function", TopLevelShell },
	{ "insertPosition", "Function", TransientShell },
	{ "insertPosition", "Function", Tree },
	{ "insertPosition", "Function", Viewport },
	{ "insertPosition", "Function", WMShell },
	{ "insertPosition", "Function", XfwfCommon },
	{ "insertPosition", "Function", XfwfMenuBar },
	{ "insertPosition", "Int", AsciiText },
	{ "internalBorderColor", "Pixel", Paned },
	{ "internalBorderWidth", "Dimension", Paned },
	{ "internalHeight", "Dimension", Command },
	{ "internalHeight", "Dimension", Label },
	{ "internalHeight", "Dimension", List },
	{ "internalHeight", "Dimension", MenuButton },
	{ "internalHeight", "Dimension", Repeater },
	{ "internalHeight", "Dimension", Toggle },
	{ "internalSpace", "Dimension", Panner },
	{ "internalWidth", "Dimension", Command },
	{ "internalWidth", "Dimension", Label },
	{ "internalWidth", "Dimension", List },
	{ "internalWidth", "Dimension", MenuButton },
	{ "internalWidth", "Dimension", Repeater },
	{ "internalWidth", "Dimension", Toggle },
	{ "isIndex", "Boolean", HTML },
	{ "italicFont", "FontStruct", HTML },
	{ "jumpProc", "Callback", Scrollbar },
	{ "jumpScroll", "Int", StripChart },
	{ "justify", "Justify", Command },
	{ "justify", "Justify", Label },
	{ "justify", "Justify", MenuButton },
	{ "justify", "Justify", Repeater },
	{ "justify", "Justify", SmeBSB },
	{ "justify", "Justify", Toggle },
	{ "label", "String", Command },
	{ "label", "String", Dialog },
	{ "label", "String", Group },
	{ "label", "String", Label },
	{ "label", "String", MenuButton },
	{ "label", "String", RadioGroup },
	{ "label", "String", Repeater },
	{ "label", "String", SimpleMenu },
	{ "label", "String", Slider2d },
	{ "label", "String", SmeBSB },
	{ "label", "String", TextBox },
	{ "label", "String", TextButton },
	{ "label", "String", TextToggle },
	{ "label", "String", Toggle },
	{ "labelClass", "Pointer", SimpleMenu },
	{ "labels", "StringArray", RadioGroup },
	{ "layout", "Layout", Layout },
	{ "left", "EdgeType", Dialog },
	{ "left", "EdgeType", Form },
	{ "left", "EdgeType", Viewport },
	{ "leftBitmap", "Bitmap", Command },
	{ "leftBitmap", "Bitmap", Label },
	{ "leftBitmap", "Bitmap", MenuButton },
	{ "leftBitmap", "Bitmap", Repeater },
	{ "leftBitmap", "Bitmap", SmeBSB },
	{ "leftBitmap", "Bitmap", Toggle },
	{ "leftCursor", "Cursor", Paned },
	{ "leftMargin", "Dimension", Slider2d },
	{ "leftMargin", "Dimension", SmeBSB },
	{ "leftMargin", "Dimension", TextBox },
	{ "leftMargin", "Dimension", TextButton },
	{ "leftMargin", "Dimension", TextToggle },
	{ "leftMargin", "Position", AsciiText },
	{ "length", "Dimension", Scrollbar },
	{ "length", "Int", AsciiSrc },
	{ "length", "Int", AsciiText },
	{ "lineWidth", "Dimension", Panner },
	{ "lineWidth", "Dimension", SmeLine },
	{ "lineWidth", "Dimension", Tree },
	{ "linkCallback", "Callback", HTML },
	{ "list", "Pointer", List },
	{ "list", "Pointer", MultiList },
	{ "listingFont", "FontStruct", HTML },
	{ "location", "String", Arrow },
	{ "location", "String", Board },
	{ "location", "String", Group },
	{ "location", "String", Icon },
	{ "location", "String", RadioGroup },
	{ "location", "String", RowCol },
	{ "location", "String", Scrollbar2 },
	{ "location", "String", Slider2d },
	{ "location", "String", TextBox },
	{ "location", "String", TextButton },
	{ "location", "String", TextToggle },
	{ "location", "String", XfwfMenuBar },
	{ "longest", "Int", List },
	{ "longest", "Int", MultiList },
	{ "lowerCursor", "Cursor", Paned },
	{ "mappedWhenManaged", "Boolean", ApplicationShell },
	{ "mappedWhenManaged", "Boolean", Arrow },
	{ "mappedWhenManaged", "Boolean", AsciiText },
	{ "mappedWhenManaged", "Boolean", Board },
	{ "mappedWhenManaged", "Boolean", Box },
	{ "mappedWhenManaged", "Boolean", Command },
	{ "mappedWhenManaged", "Boolean", Core },
	{ "mappedWhenManaged", "Boolean", Dialog },
	{ "mappedWhenManaged", "Boolean", Form },
	{ "mappedWhenManaged", "Boolean", Frame },
	{ "mappedWhenManaged", "Boolean", Grip },
	{ "mappedWhenManaged", "Boolean", Group },
	{ "mappedWhenManaged", "Boolean", Gterm },
	{ "mappedWhenManaged", "Boolean", HTML },
	{ "mappedWhenManaged", "Boolean", Icon },
	{ "mappedWhenManaged", "Boolean", Label },
	{ "mappedWhenManaged", "Boolean", Layout },
	{ "mappedWhenManaged", "Boolean", List },
	{ "mappedWhenManaged", "Boolean", MenuButton },
	{ "mappedWhenManaged", "Boolean", MultiList },
	{ "mappedWhenManaged", "Boolean", OverrideShell },
	{ "mappedWhenManaged", "Boolean", Paned },
	{ "mappedWhenManaged", "Boolean", Panner },
	{ "mappedWhenManaged", "Boolean", Porthole },
	{ "mappedWhenManaged", "Boolean", RadioGroup },
	{ "mappedWhenManaged", "Boolean", Repeater },
	{ "mappedWhenManaged", "Boolean", RowCol },
	{ "mappedWhenManaged", "Boolean", Scrollbar },
	{ "mappedWhenManaged", "Boolean", Scrollbar2 },
	{ "mappedWhenManaged", "Boolean", Shell },
	{ "mappedWhenManaged", "Boolean", Simple },
	{ "mappedWhenManaged", "Boolean", SimpleMenu },
	{ "mappedWhenManaged", "Boolean", Slider2d },
	{ "mappedWhenManaged", "Boolean", StripChart },
	{ "mappedWhenManaged", "Boolean", TextBox },
	{ "mappedWhenManaged", "Boolean", TextButton },
	{ "mappedWhenManaged", "Boolean", TextToggle },
	{ "mappedWhenManaged", "Boolean", Toggle },
	{ "mappedWhenManaged", "Boolean", TopLevelShell },
	{ "mappedWhenManaged", "Boolean", TransientShell },
	{ "mappedWhenManaged", "Boolean", Tree },
	{ "mappedWhenManaged", "Boolean", Viewport },
	{ "mappedWhenManaged", "Boolean", WMShell },
	{ "mappedWhenManaged", "Boolean", XfwfCommon },
	{ "mappedWhenManaged", "Boolean", XfwfMenuBar },
	{ "marginHeight", "Dimension", HTML },
	{ "marginWidth", "Dimension", HTML },
	{ "markerBoxKnotColor", "Pixel", Gterm },
	{ "markerBoxKnotSize", "Int", Gterm },
	{ "markerBoxLineColor", "Pixel", Gterm },
	{ "markerCircleKnotColor", "Pixel", Gterm },
	{ "markerCircleKnotSize", "Int", Gterm },
	{ "markerCircleLineColor", "Pixel", Gterm },
	{ "markerCursorBgColor", "Pixel", Gterm },
	{ "markerCursorFgColor", "Pixel", Gterm },
	{ "markerEllipseKnotColor", "Pixel", Gterm },
	{ "markerEllipseKnotSize", "Int", Gterm },
	{ "markerEllipseLineColor", "Pixel", Gterm },
	{ "markerFill", "Boolean", Gterm },
	{ "markerFillBgColor", "Pixel", Gterm },
	{ "markerFillColor", "Pixel", Gterm },
	{ "markerFillStyle", "Int", Gterm },
	{ "markerHighlightColor", "Pixel", Gterm },
	{ "markerHighlightWidth", "Int", Gterm },
	{ "markerLineKnotColor", "Pixel", Gterm },
	{ "markerLineKnotSize", "Int", Gterm },
	{ "markerLineLineColor", "Pixel", Gterm },
	{ "markerLineStyle", "Int", Gterm },
	{ "markerLineWidth", "Int", Gterm },
	{ "markerPgonKnotColor", "Pixel", Gterm },
	{ "markerPgonKnotSize", "Int", Gterm },
	{ "markerPgonLineColor", "Pixel", Gterm },
	{ "markerRectKnotColor", "Pixel", Gterm },
	{ "markerRectKnotSize", "Int", Gterm },
	{ "markerRectLineColor", "Pixel", Gterm },
	{ "markerTextBgColor", "Pixel", Gterm },
	{ "markerTextBorder", "Int", Gterm },
	{ "markerTextColor", "Pixel", Gterm },
	{ "markerTextFont", "FontStruct", Gterm },
	{ "markerTextLineColor", "Pixel", Gterm },
	{ "markerTextString", "String", Gterm },
	{ "markerTranslations", "String", Gterm },
	{ "max", "Dimension", Paned },
	{ "maxAspectX", "Int", ApplicationShell },
	{ "maxAspectX", "Int", TopLevelShell },
	{ "maxAspectX", "Int", TransientShell },
	{ "maxAspectX", "Int", WMShell },
	{ "maxAspectY", "Int", ApplicationShell },
	{ "maxAspectY", "Int", TopLevelShell },
	{ "maxAspectY", "Int", TransientShell },
	{ "maxAspectY", "Int", WMShell },
	{ "maxHeight", "Int", ApplicationShell },
	{ "maxHeight", "Int", TopLevelShell },
	{ "maxHeight", "Int", TransientShell },
	{ "maxHeight", "Int", WMShell },
	{ "maxMappings", "Int", Gterm },
	{ "maxRasters", "Int", Gterm },
	{ "maxSelectable", "Int", MultiList },
	{ "maxWidth", "Int", ApplicationShell },
	{ "maxWidth", "Int", TopLevelShell },
	{ "maxWidth", "Int", TransientShell },
	{ "maxWidth", "Int", WMShell },
	{ "menuName", "String", MenuButton },
	{ "menuOnScreen", "Boolean", SimpleMenu },
	{ "min", "Dimension", Paned },
	{ "minAspectX", "Int", ApplicationShell },
	{ "minAspectX", "Int", TopLevelShell },
	{ "minAspectX", "Int", TransientShell },
	{ "minAspectX", "Int", WMShell },
	{ "minAspectY", "Int", ApplicationShell },
	{ "minAspectY", "Int", TopLevelShell },
	{ "minAspectY", "Int", TransientShell },
	{ "minAspectY", "Int", WMShell },
	{ "minHeight", "Int", ApplicationShell },
	{ "minHeight", "Int", TopLevelShell },
	{ "minHeight", "Int", TransientShell },
	{ "minHeight", "Int", WMShell },
	{ "minScale", "Int", StripChart },
	{ "minWidth", "Int", ApplicationShell },
	{ "minWidth", "Int", TopLevelShell },
	{ "minWidth", "Int", TransientShell },
	{ "minWidth", "Int", WMShell },
	{ "minimumDelay", "Int", Repeater },
	{ "minimumThumb", "Dimension", Scrollbar },
	{ "minsize", "Dimension", Scrollbar2 },
	{ "minsize", "Dimension", Slider2d },
	{ "nearEdge", "Int", Gterm },
	{ "nearVertex", "Int", Gterm },
	{ "nextTop", "Callback", Arrow },
	{ "nextTop", "Callback", Board },
	{ "nextTop", "Callback", Frame },
	{ "nextTop", "Callback", Group },
	{ "nextTop", "Callback", Icon },
	{ "nextTop", "Callback", RadioGroup },
	{ "nextTop", "Callback", RowCol },
	{ "nextTop", "Callback", Scrollbar2 },
	{ "nextTop", "Callback", Slider2d },
	{ "nextTop", "Callback", TextBox },
	{ "nextTop", "Callback", TextButton },
	{ "nextTop", "Callback", TextToggle },
	{ "nextTop", "Callback", XfwfCommon },
	{ "nextTop", "Callback", XfwfMenuBar },
	{ "numChildren", "Cardinal", ApplicationShell },
	{ "numChildren", "Cardinal", Arrow },
	{ "numChildren", "Cardinal", Board },
	{ "numChildren", "Cardinal", Box },
	{ "numChildren", "Cardinal", Dialog },
	{ "numChildren", "Cardinal", Form },
	{ "numChildren", "Cardinal", Frame },
	{ "numChildren", "Cardinal", Group },
	{ "numChildren", "Cardinal", HTML },
	{ "numChildren", "Cardinal", Icon },
	{ "numChildren", "Cardinal", Layout },
	{ "numChildren", "Cardinal", OverrideShell },
	{ "numChildren", "Cardinal", Paned },
	{ "numChildren", "Cardinal", Porthole },
	{ "numChildren", "Cardinal", RadioGroup },
	{ "numChildren", "Cardinal", RowCol },
	{ "numChildren", "Cardinal", Scrollbar2 },
	{ "numChildren", "Cardinal", Shell },
	{ "numChildren", "Cardinal", SimpleMenu },
	{ "numChildren", "Cardinal", Slider2d },
	{ "numChildren", "Cardinal", TextBox },
	{ "numChildren", "Cardinal", TextButton },
	{ "numChildren", "Cardinal", TextToggle },
	{ "numChildren", "Cardinal", TopLevelShell },
	{ "numChildren", "Cardinal", TransientShell },
	{ "numChildren", "Cardinal", Tree },
	{ "numChildren", "Cardinal", Viewport },
	{ "numChildren", "Cardinal", WMShell },
	{ "numChildren", "Cardinal", XfwfCommon },
	{ "numChildren", "Cardinal", XfwfMenuBar },
	{ "numberStrings", "Int", List },
	{ "numberStrings", "Int", MultiList },
	{ "offCallback", "Callback", TextToggle },
	{ "offIcon", "Icon", TextToggle },
	{ "on", "Boolean", TextToggle },
	{ "onCallback", "Callback", TextToggle },
	{ "onIcon", "Icon", TextToggle },
	{ "orientation", "Orientation", Box },
	{ "orientation", "Orientation", Paned },
	{ "orientation", "Orientation", Scrollbar },
	{ "outerOffset", "Dimension", Arrow },
	{ "outerOffset", "Dimension", Board },
	{ "outerOffset", "Dimension", Frame },
	{ "outerOffset", "Dimension", Group },
	{ "outerOffset", "Dimension", Icon },
	{ "outerOffset", "Dimension", RadioGroup },
	{ "outerOffset", "Dimension", RowCol },
	{ "outerOffset", "Dimension", Scrollbar2 },
	{ "outerOffset", "Dimension", Slider2d },
	{ "outerOffset", "Dimension", TextBox },
	{ "outerOffset", "Dimension", TextButton },
	{ "outerOffset", "Dimension", TextToggle },
	{ "outerOffset", "Dimension", XfwfMenuBar },
	{ "overrideRedirect", "Boolean", ApplicationShell },
	{ "overrideRedirect", "Boolean", OverrideShell },
	{ "overrideRedirect", "Boolean", Shell },
	{ "overrideRedirect", "Boolean", SimpleMenu },
	{ "overrideRedirect", "Boolean", TopLevelShell },
	{ "overrideRedirect", "Boolean", TransientShell },
	{ "overrideRedirect", "Boolean", WMShell },
	{ "pasteBuffer", "Boolean", List },
	{ "pasteBuffer", "Boolean", MultiList },
	{ "percentVerticalSpace", "Int", HTML },
	{ "pieceSize", "Int", AsciiSrc },
	{ "pieceSize", "Int", AsciiText },
	{ "plainFont", "FontStruct", HTML },
	{ "plainboldFont", "FontStruct", HTML },
	{ "plainitalicFont", "FontStruct", HTML },
	{ "pointerColor", "Pixel", AsciiText },
	{ "pointerColor", "Pixel", Command },
	{ "pointerColor", "Pixel", Grip },
	{ "pointerColor", "Pixel", Label },
	{ "pointerColor", "Pixel", List },
	{ "pointerColor", "Pixel", MenuButton },
	{ "pointerColor", "Pixel", MultiList },
	{ "pointerColor", "Pixel", Panner },
	{ "pointerColor", "Pixel", Repeater },
	{ "pointerColor", "Pixel", Scrollbar },
	{ "pointerColor", "Pixel", Simple },
	{ "pointerColor", "Pixel", StripChart },
	{ "pointerColor", "Pixel", Toggle },
	{ "pointerColorBackground", "Pixel", AsciiText },
	{ "pointerColorBackground", "Pixel", Command },
	{ "pointerColorBackground", "Pixel", Grip },
	{ "pointerColorBackground", "Pixel", Label },
	{ "pointerColorBackground", "Pixel", List },
	{ "pointerColorBackground", "Pixel", MenuButton },
	{ "pointerColorBackground", "Pixel", MultiList },
	{ "pointerColorBackground", "Pixel", Panner },
	{ "pointerColorBackground", "Pixel", Repeater },
	{ "pointerColorBackground", "Pixel", Scrollbar },
	{ "pointerColorBackground", "Pixel", Simple },
	{ "pointerColorBackground", "Pixel", StripChart },
	{ "pointerColorBackground", "Pixel", Toggle },
	{ "pointerMotionCallback", "Pointer", HTML },
	{ "popdownCallback", "Callback", ApplicationShell },
	{ "popdownCallback", "Callback", OverrideShell },
	{ "popdownCallback", "Callback", Shell },
	{ "popdownCallback", "Callback", SimpleMenu },
	{ "popdownCallback", "Callback", TopLevelShell },
	{ "popdownCallback", "Callback", TransientShell },
	{ "popdownCallback", "Callback", WMShell },
	{ "popupCallback", "Callback", ApplicationShell },
	{ "popupCallback", "Callback", OverrideShell },
	{ "popupCallback", "Callback", Shell },
	{ "popupCallback", "Callback", SimpleMenu },
	{ "popupCallback", "Callback", TopLevelShell },
	{ "popupCallback", "Callback", TransientShell },
	{ "popupCallback", "Callback", WMShell },
	{ "popupOnEntry", "Widget", SimpleMenu },
	{ "position", "Int", Paned },
	{ "preferredPaneSize", "Dimension", Paned },
	{ "previouslyVisitedTestFunction", "Pointer", HTML },
	{ "radioData", "Pointer", Toggle },
	{ "radioGroup", "Widget", Toggle },
	{ "raiseWindow", "Boolean", Gterm },
	{ "refigureMode", "Boolean", Paned },
	{ "rel_height", "Float", Arrow },
	{ "rel_height", "Float", Board },
	{ "rel_height", "Float", Group },
	{ "rel_height", "Float", Icon },
	{ "rel_height", "Float", RadioGroup },
	{ "rel_height", "Float", RowCol },
	{ "rel_height", "Float", Scrollbar2 },
	{ "rel_height", "Float", Slider2d },
	{ "rel_height", "Float", TextBox },
	{ "rel_height", "Float", TextButton },
	{ "rel_height", "Float", TextToggle },
	{ "rel_height", "Float", XfwfMenuBar },
	{ "rel_width", "Float", Arrow },
	{ "rel_width", "Float", Board },
	{ "rel_width", "Float", Group },
	{ "rel_width", "Float", Icon },
	{ "rel_width", "Float", RadioGroup },
	{ "rel_width", "Float", RowCol },
	{ "rel_width", "Float", Scrollbar2 },
	{ "rel_width", "Float", Slider2d },
	{ "rel_width", "Float", TextBox },
	{ "rel_width", "Float", TextButton },
	{ "rel_width", "Float", TextToggle },
	{ "rel_width", "Float", XfwfMenuBar },
	{ "rel_x", "Float", Arrow },
	{ "rel_x", "Float", Board },
	{ "rel_x", "Float", Group },
	{ "rel_x", "Float", Icon },
	{ "rel_x", "Float", RadioGroup },
	{ "rel_x", "Float", RowCol },
	{ "rel_x", "Float", Scrollbar2 },
	{ "rel_x", "Float", Slider2d },
	{ "rel_x", "Float", TextBox },
	{ "rel_x", "Float", TextButton },
	{ "rel_x", "Float", TextToggle },
	{ "rel_x", "Float", XfwfMenuBar },
	{ "rel_y", "Float", Arrow },
	{ "rel_y", "Float", Board },
	{ "rel_y", "Float", Group },
	{ "rel_y", "Float", Icon },
	{ "rel_y", "Float", RadioGroup },
	{ "rel_y", "Float", RowCol },
	{ "rel_y", "Float", Scrollbar2 },
	{ "rel_y", "Float", Slider2d },
	{ "rel_y", "Float", TextBox },
	{ "rel_y", "Float", TextButton },
	{ "rel_y", "Float", TextToggle },
	{ "rel_y", "Float", XfwfMenuBar },
	{ "repeatDelay", "Cardinal", Arrow },
	{ "repeatDelay", "Cardinal", Scrollbar2 },
	{ "repeatDelay", "Int", Repeater },
	{ "reportCallback", "Callback", Panner },
	{ "reportCallback", "Callback", Porthole },
	{ "reportCallback", "Callback", Viewport },
	{ "resizable", "Boolean", Dialog },
	{ "resizable", "Boolean", Form },
	{ "resizable", "Boolean", Viewport },
	{ "resize", "Boolean", Command },
	{ "resize", "Boolean", Label },
	{ "resize", "Boolean", MenuButton },
	{ "resize", "Boolean", Panner },
	{ "resize", "Boolean", Repeater },
	{ "resize", "Boolean", Toggle },
	{ "resize", "ResizeMode", AsciiText },
	{ "resizeToPreferred", "Boolean", Paned },
	{ "resolveDelayedImage", "Pointer", HTML },
	{ "resolveImageFunction", "Pointer", HTML },
	{ "right", "EdgeType", Dialog },
	{ "right", "EdgeType", Form },
	{ "right", "EdgeType", Viewport },
	{ "rightBitmap", "Bitmap", SmeBSB },
	{ "rightCursor", "Cursor", Paned },
	{ "rightMargin", "Dimension", Slider2d },
	{ "rightMargin", "Dimension", SmeBSB },
	{ "rightMargin", "Dimension", TextBox },
	{ "rightMargin", "Dimension", TextButton },
	{ "rightMargin", "Dimension", TextToggle },
	{ "rightMargin", "Position", AsciiText },
	{ "rowHeight", "Dimension", MultiList },
	{ "rowHeight", "Dimension", SimpleMenu },
	{ "rowSpacing", "Dimension", List },
	{ "rowSpacing", "Dimension", MultiList },
	{ "rows", "Int", Group },
	{ "rows", "Int", RadioGroup },
	{ "rows", "Int", RowCol },
	{ "rows", "Int", XfwfMenuBar },
	{ "rubberBand", "Boolean", Panner },
	{ "rvLength", "Int", Slider2d },
	{ "rvLength", "Int", TextBox },
	{ "rvLength", "Int", TextButton },
	{ "rvLength", "Int", TextToggle },
	{ "rvStart", "Int", Slider2d },
	{ "rvStart", "Int", TextBox },
	{ "rvStart", "Int", TextButton },
	{ "rvStart", "Int", TextToggle },
	{ "saveUnder", "Boolean", ApplicationShell },
	{ "saveUnder", "Boolean", OverrideShell },
	{ "saveUnder", "Boolean", Shell },
	{ "saveUnder", "Boolean", SimpleMenu },
	{ "saveUnder", "Boolean", TopLevelShell },
	{ "saveUnder", "Boolean", TransientShell },
	{ "saveUnder", "Boolean", WMShell },
	{ "screen", "Screen", ApplicationShell },
	{ "screen", "Screen", Arrow },
	{ "screen", "Screen", AsciiText },
	{ "screen", "Screen", Board },
	{ "screen", "Screen", Box },
	{ "screen", "Screen", Command },
	{ "screen", "Screen", Core },
	{ "screen", "Screen", Dialog },
	{ "screen", "Screen", Form },
	{ "screen", "Screen", Frame },
	{ "screen", "Screen", Grip },
	{ "screen", "Screen", Group },
	{ "screen", "Screen", Gterm },
	{ "screen", "Screen", HTML },
	{ "screen", "Screen", Icon },
	{ "screen", "Screen", Label },
	{ "screen", "Screen", Layout },
	{ "screen", "Screen", List },
	{ "screen", "Screen", MenuButton },
	{ "screen", "Screen", MultiList },
	{ "screen", "Screen", OverrideShell },
	{ "screen", "Screen", Paned },
	{ "screen", "Screen", Panner },
	{ "screen", "Screen", Porthole },
	{ "screen", "Screen", RadioGroup },
	{ "screen", "Screen", Repeater },
	{ "screen", "Screen", RowCol },
	{ "screen", "Screen", Scrollbar },
	{ "screen", "Screen", Scrollbar2 },
	{ "screen", "Screen", Shell },
	{ "screen", "Screen", Simple },
	{ "screen", "Screen", SimpleMenu },
	{ "screen", "Screen", Slider2d },
	{ "screen", "Screen", StripChart },
	{ "screen", "Screen", TextBox },
	{ "screen", "Screen", TextButton },
	{ "screen", "Screen", TextToggle },
	{ "screen", "Screen", Toggle },
	{ "screen", "Screen", TopLevelShell },
	{ "screen", "Screen", TransientShell },
	{ "screen", "Screen", Tree },
	{ "screen", "Screen", Viewport },
	{ "screen", "Screen", WMShell },
	{ "screen", "Screen", XfwfCommon },
	{ "screen", "Screen", XfwfMenuBar },
	{ "scrollCallback", "Callback", Scrollbar2 },
	{ "scrollCallback", "Callback", Slider2d },
	{ "scrollDCursor", "Cursor", Scrollbar },
	{ "scrollHCursor", "Cursor", Scrollbar },
	{ "scrollHorizontal", "ScrollMode", AsciiText },
	{ "scrollLCursor", "Cursor", Scrollbar },
	{ "scrollProc", "Callback", Scrollbar },
	{ "scrollRCursor", "Cursor", Scrollbar },
	{ "scrollResponse", "XTCallbackProc", Scrollbar2 },
	{ "scrollResponse", "XTCallbackProc", Slider2d },
	{ "scrollUCursor", "Cursor", Scrollbar },
	{ "scrollVCursor", "Cursor", Scrollbar },
	{ "scrollVertical", "ScrollMode", AsciiText },
	{ "scrollbarForeground", "Pixel", Scrollbar2 },
	{ "selectTypes", "Pointer", AsciiText },
	{ "selection", "Long", Group },
	{ "selection", "Long", RadioGroup },
	{ "selectionStyle", "SelectionType", Group },
	{ "selectionStyle", "SelectionType", RadioGroup },
	{ "sensitive", "Boolean", ApplicationShell },
	{ "sensitive", "Boolean", Arrow },
	{ "sensitive", "Boolean", AsciiText },
	{ "sensitive", "Boolean", Board },
	{ "sensitive", "Boolean", Box },
	{ "sensitive", "Boolean", Command },
	{ "sensitive", "Boolean", Core },
	{ "sensitive", "Boolean", Dialog },
	{ "sensitive", "Boolean", Form },
	{ "sensitive", "Boolean", Frame },
	{ "sensitive", "Boolean", Grip },
	{ "sensitive", "Boolean", Group },
	{ "sensitive", "Boolean", Gterm },
	{ "sensitive", "Boolean", HTML },
	{ "sensitive", "Boolean", Icon },
	{ "sensitive", "Boolean", Label },
	{ "sensitive", "Boolean", Layout },
	{ "sensitive", "Boolean", List },
	{ "sensitive", "Boolean", MenuButton },
	{ "sensitive", "Boolean", MultiList },
	{ "sensitive", "Boolean", OverrideShell },
	{ "sensitive", "Boolean", Paned },
	{ "sensitive", "Boolean", Panner },
	{ "sensitive", "Boolean", Porthole },
	{ "sensitive", "Boolean", RadioGroup },
	{ "sensitive", "Boolean", Repeater },
	{ "sensitive", "Boolean", RowCol },
	{ "sensitive", "Boolean", Scrollbar },
	{ "sensitive", "Boolean", Scrollbar2 },
	{ "sensitive", "Boolean", Shell },
	{ "sensitive", "Boolean", Simple },
	{ "sensitive", "Boolean", SimpleMenu },
	{ "sensitive", "Boolean", Slider2d },
	{ "sensitive", "Boolean", Sme },
	{ "sensitive", "Boolean", SmeBSB },
	{ "sensitive", "Boolean", SmeLine },
	{ "sensitive", "Boolean", StripChart },
	{ "sensitive", "Boolean", TextBox },
	{ "sensitive", "Boolean", TextButton },
	{ "sensitive", "Boolean", TextToggle },
	{ "sensitive", "Boolean", Toggle },
	{ "sensitive", "Boolean", TopLevelShell },
	{ "sensitive", "Boolean", TransientShell },
	{ "sensitive", "Boolean", Tree },
	{ "sensitive", "Boolean", Viewport },
	{ "sensitive", "Boolean", WMShell },
	{ "sensitive", "Boolean", XfwfCommon },
	{ "sensitive", "Boolean", XfwfMenuBar },
	{ "sensitiveArray", "Pointer", MultiList },
	{ "shadeSurplus", "Boolean", MultiList },
	{ "shadow", "Dimension", Scrollbar2 },
	{ "shadowColor", "Pixel", Panner },
	{ "shadowScheme", "ShadowScheme", Arrow },
	{ "shadowScheme", "ShadowScheme", Board },
	{ "shadowScheme", "ShadowScheme", Frame },
	{ "shadowScheme", "ShadowScheme", Group },
	{ "shadowScheme", "ShadowScheme", Icon },
	{ "shadowScheme", "ShadowScheme", RadioGroup },
	{ "shadowScheme", "ShadowScheme", RowCol },
	{ "shadowScheme", "ShadowScheme", Scrollbar2 },
	{ "shadowScheme", "ShadowScheme", Slider2d },
	{ "shadowScheme", "ShadowScheme", TextBox },
	{ "shadowScheme", "ShadowScheme", TextButton },
	{ "shadowScheme", "ShadowScheme", TextToggle },
	{ "shadowScheme", "ShadowScheme", XfwfMenuBar },
	{ "shadowThickness", "Dimension", Panner },
	{ "shapeStyle", "ShapeStyle", Command },
	{ "shapeStyle", "ShapeStyle", MenuButton },
	{ "shapeStyle", "ShapeStyle", Repeater },
	{ "shapeStyle", "ShapeStyle", Toggle },
	{ "showGrip", "Boolean", Paned },
	{ "shown", "Float", Scrollbar },
	{ "shrinkToFit", "Boolean", Group },
	{ "shrinkToFit", "Boolean", RadioGroup },
	{ "shrinkToFit", "Boolean", RowCol },
	{ "shrinkToFit", "Boolean", Slider2d },
	{ "shrinkToFit", "Boolean", TextBox },
	{ "shrinkToFit", "Boolean", TextButton },
	{ "shrinkToFit", "Boolean", TextToggle },
	{ "shrinkToFit", "Boolean", XfwfMenuBar },
	{ "skipAdjust", "Boolean", Paned },
	{ "sliderHeight", "Dimension", Panner },
	{ "sliderWidth", "Dimension", Panner },
	{ "sliderX", "Position", Panner },
	{ "sliderY", "Position", Panner },
	{ "startCallback", "Callback", Repeater },
	{ "state", "Boolean", Toggle },
	{ "stipple", "Bitmap", SmeLine },
	{ "stopCallback", "Callback", Repeater },
	{ "storeByRow", "Boolean", Group },
	{ "storeByRow", "Boolean", RadioGroup },
	{ "storeByRow", "Boolean", RowCol },
	{ "storeByRow", "Boolean", XfwfMenuBar },
	{ "string", "String", AsciiSrc },
	{ "string", "String", AsciiText },
	{ "submitFormCallback", "Callback", HTML },
	{ "tablist", "String", MultiList },
	{ "tablist", "String", Slider2d },
	{ "tablist", "String", TextBox },
	{ "tablist", "String", TextButton },
	{ "tablist", "String", TextToggle },
	{ "text", "String", HTML },
	{ "textSink", "Widget", AsciiText },
	{ "textSource", "Widget", AsciiText },
	{ "thickness", "Dimension", Scrollbar },
	{ "thumb", "Bitmap", Scrollbar },
	{ "thumbColor", "Pixel", Slider2d },
	{ "thumbFrameType", "FrameType", Slider2d },
	{ "thumbFrameWidth", "Dimension", Slider2d },
	{ "thumbPixmap", "Pixmap", Slider2d },
	{ "thumbProc", "Callback", Scrollbar },
	{ "title", "String", ApplicationShell },
	{ "title", "String", TopLevelShell },
	{ "title", "String", TransientShell },
	{ "title", "String", WMShell },
	{ "titleEncoding", "Atom", ApplicationShell },
	{ "titleEncoding", "Atom", TopLevelShell },
	{ "titleEncoding", "Atom", TransientShell },
	{ "titleEncoding", "Atom", WMShell },
	{ "titleText", "String", HTML },
	{ "top", "EdgeType", Dialog },
	{ "top", "EdgeType", Form },
	{ "top", "EdgeType", Viewport },
	{ "topMargin", "Dimension", SimpleMenu },
	{ "topMargin", "Dimension", Slider2d },
	{ "topMargin", "Dimension", TextBox },
	{ "topMargin", "Dimension", TextButton },
	{ "topMargin", "Dimension", TextToggle },
	{ "topMargin", "Position", AsciiText },
	{ "topOfThumb", "Float", Scrollbar },
	{ "topShadowColor", "Pixel", Arrow },
	{ "topShadowColor", "Pixel", Board },
	{ "topShadowColor", "Pixel", Frame },
	{ "topShadowColor", "Pixel", Group },
	{ "topShadowColor", "Pixel", Icon },
	{ "topShadowColor", "Pixel", RadioGroup },
	{ "topShadowColor", "Pixel", RowCol },
	{ "topShadowColor", "Pixel", Scrollbar2 },
	{ "topShadowColor", "Pixel", Slider2d },
	{ "topShadowColor", "Pixel", TextBox },
	{ "topShadowColor", "Pixel", TextButton },
	{ "topShadowColor", "Pixel", TextToggle },
	{ "topShadowColor", "Pixel", XfwfMenuBar },
	{ "topShadowStipple", "Bitmap", Arrow },
	{ "topShadowStipple", "Bitmap", Board },
	{ "topShadowStipple", "Bitmap", Frame },
	{ "topShadowStipple", "Bitmap", Group },
	{ "topShadowStipple", "Bitmap", Icon },
	{ "topShadowStipple", "Bitmap", RadioGroup },
	{ "topShadowStipple", "Bitmap", RowCol },
	{ "topShadowStipple", "Bitmap", Scrollbar2 },
	{ "topShadowStipple", "Bitmap", Slider2d },
	{ "topShadowStipple", "Bitmap", TextBox },
	{ "topShadowStipple", "Bitmap", TextButton },
	{ "topShadowStipple", "Bitmap", TextToggle },
	{ "topShadowStipple", "Bitmap", XfwfMenuBar },
	{ "transient", "Boolean", ApplicationShell },
	{ "transient", "Boolean", TopLevelShell },
	{ "transient", "Boolean", TransientShell },
	{ "transient", "Boolean", WMShell },
	{ "transientFor", "Widget", TransientShell },
	{ "translations", "TranslationTable", ApplicationShell },
	{ "translations", "TranslationTable", Arrow },
	{ "translations", "TranslationTable", AsciiText },
	{ "translations", "TranslationTable", Board },
	{ "translations", "TranslationTable", Box },
	{ "translations", "TranslationTable", Command },
	{ "translations", "TranslationTable", Core },
	{ "translations", "TranslationTable", Dialog },
	{ "translations", "TranslationTable", Form },
	{ "translations", "TranslationTable", Frame },
	{ "translations", "TranslationTable", Grip },
	{ "translations", "TranslationTable", Group },
	{ "translations", "TranslationTable", Gterm },
	{ "translations", "TranslationTable", HTML },
	{ "translations", "TranslationTable", Icon },
	{ "translations", "TranslationTable", Label },
	{ "translations", "TranslationTable", Layout },
	{ "translations", "TranslationTable", List },
	{ "translations", "TranslationTable", MenuButton },
	{ "translations", "TranslationTable", MultiList },
	{ "translations", "TranslationTable", OverrideShell },
	{ "translations", "TranslationTable", Paned },
	{ "translations", "TranslationTable", Panner },
	{ "translations", "TranslationTable", Porthole },
	{ "translations", "TranslationTable", RadioGroup },
	{ "translations", "TranslationTable", Repeater },
	{ "translations", "TranslationTable", RowCol },
	{ "translations", "TranslationTable", Scrollbar },
	{ "translations", "TranslationTable", Scrollbar2 },
	{ "translations", "TranslationTable", Shell },
	{ "translations", "TranslationTable", Simple },
	{ "translations", "TranslationTable", SimpleMenu },
	{ "translations", "TranslationTable", Slider2d },
	{ "translations", "TranslationTable", StripChart },
	{ "translations", "TranslationTable", TextBox },
	{ "translations", "TranslationTable", TextButton },
	{ "translations", "TranslationTable", TextToggle },
	{ "translations", "TranslationTable", Toggle },
	{ "translations", "TranslationTable", TopLevelShell },
	{ "translations", "TranslationTable", TransientShell },
	{ "translations", "TranslationTable", Tree },
	{ "translations", "TranslationTable", Viewport },
	{ "translations", "TranslationTable", WMShell },
	{ "translations", "TranslationTable", XfwfCommon },
	{ "translations", "TranslationTable", XfwfMenuBar },
	{ "traversalOn", "Boolean", Arrow },
	{ "traversalOn", "Boolean", Board },
	{ "traversalOn", "Boolean", Frame },
	{ "traversalOn", "Boolean", Group },
	{ "traversalOn", "Boolean", Icon },
	{ "traversalOn", "Boolean", RadioGroup },
	{ "traversalOn", "Boolean", RowCol },
	{ "traversalOn", "Boolean", Scrollbar2 },
	{ "traversalOn", "Boolean", Slider2d },
	{ "traversalOn", "Boolean", TextBox },
	{ "traversalOn", "Boolean", TextButton },
	{ "traversalOn", "Boolean", TextToggle },
	{ "traversalOn", "Boolean", XfwfCommon },
	{ "traversalOn", "Boolean", XfwfMenuBar },
	{ "treeGC", "GC", Tree },
	{ "treeParent", "Widget", Tree },
	{ "type", "AsciiType", AsciiSrc },
	{ "type", "AsciiType", AsciiText },
	{ "unrealizeCallback", "Callback", AsciiText },
	{ "update", "Int", StripChart },
	{ "upperCursor", "Cursor", Paned },
	{ "useBottom", "Boolean", Viewport },
	{ "useRight", "Boolean", Viewport },
	{ "useStringInPlace", "Boolean", AsciiSrc },
	{ "useStringInPlace", "Boolean", AsciiText },
	{ "useTimers", "Boolean", Gterm },
	{ "userData", "Pointer", Arrow },
	{ "userData", "Pointer", Board },
	{ "userData", "Pointer", Frame },
	{ "userData", "Pointer", Group },
	{ "userData", "Pointer", Icon },
	{ "userData", "Pointer", RadioGroup },
	{ "userData", "Pointer", Repeater },
	{ "userData", "Pointer", RowCol },
	{ "userData", "Pointer", Scrollbar2 },
	{ "userData", "Pointer", Slider2d },
	{ "userData", "Pointer", TextBox },
	{ "userData", "Pointer", TextButton },
	{ "userData", "Pointer", TextToggle },
	{ "userData", "Pointer", XfwfCommon },
	{ "userData", "Pointer", XfwfMenuBar },
	{ "vSpace", "Dimension", Box },
	{ "vSpace", "Dimension", Tree },
	{ "value", "String", Dialog },
	{ "vertDistance", "Int", Dialog },
	{ "vertDistance", "Int", Form },
	{ "vertDistance", "Int", Viewport },
	{ "vertSpace", "Int", SmeBSB },
	{ "vertical", "Boolean", Scrollbar2 },
	{ "verticalBetweenCursor", "Cursor", Paned },
	{ "verticalGripCursor", "Cursor", Paned },
	{ "verticalList", "Boolean", List },
	{ "verticalList", "Boolean", MultiList },
	{ "verticalScrollBar", "Widget", HTML },
	{ "verticalScrollOnRight", "Boolean", HTML },
	{ "view", "Widget", HTML },
	{ "visitedAnchorColor", "Pixel", HTML },
	{ "visitedAnchorUnderlines", "Int", HTML },
	{ "visual", "Visual", ApplicationShell },
	{ "visual", "Visual", OverrideShell },
	{ "visual", "Visual", Shell },
	{ "visual", "Visual", SimpleMenu },
	{ "visual", "Visual", TopLevelShell },
	{ "visual", "Visual", TransientShell },
	{ "visual", "Visual", WMShell },
	{ "vunit", "Float", Arrow },
	{ "vunit", "Float", Board },
	{ "vunit", "Float", Group },
	{ "vunit", "Float", Icon },
	{ "vunit", "Float", RadioGroup },
	{ "vunit", "Float", RowCol },
	{ "vunit", "Float", Scrollbar2 },
	{ "vunit", "Float", Slider2d },
	{ "vunit", "Float", TextBox },
	{ "vunit", "Float", TextButton },
	{ "vunit", "Float", TextToggle },
	{ "vunit", "Float", XfwfMenuBar },
	{ "waitforwm", "Boolean", ApplicationShell },
	{ "waitforwm", "Boolean", TopLevelShell },
	{ "waitforwm", "Boolean", TransientShell },
	{ "waitforwm", "Boolean", WMShell },
	{ "warpCursor", "Boolean", Gterm },
	{ "width", "Dimension", ApplicationShell },
	{ "width", "Dimension", Arrow },
	{ "width", "Dimension", AsciiText },
	{ "width", "Dimension", Board },
	{ "width", "Dimension", Box },
	{ "width", "Dimension", Command },
	{ "width", "Dimension", Core },
	{ "width", "Dimension", Dialog },
	{ "width", "Dimension", Form },
	{ "width", "Dimension", Frame },
	{ "width", "Dimension", Grip },
	{ "width", "Dimension", Group },
	{ "width", "Dimension", Gterm },
	{ "width", "Dimension", HTML },
	{ "width", "Dimension", Icon },
	{ "width", "Dimension", Label },
	{ "width", "Dimension", Layout },
	{ "width", "Dimension", List },
	{ "width", "Dimension", MenuButton },
	{ "width", "Dimension", MultiList },
	{ "width", "Dimension", OverrideShell },
	{ "width", "Dimension", Paned },
	{ "width", "Dimension", Panner },
	{ "width", "Dimension", Porthole },
	{ "width", "Dimension", RadioGroup },
	{ "width", "Dimension", Repeater },
	{ "width", "Dimension", RowCol },
	{ "width", "Dimension", Scrollbar },
	{ "width", "Dimension", Scrollbar2 },
	{ "width", "Dimension", Shell },
	{ "width", "Dimension", Simple },
	{ "width", "Dimension", SimpleMenu },
	{ "width", "Dimension", Slider2d },
	{ "width", "Dimension", Sme },
	{ "width", "Dimension", SmeBSB },
	{ "width", "Dimension", SmeLine },
	{ "width", "Dimension", StripChart },
	{ "width", "Dimension", TextBox },
	{ "width", "Dimension", TextButton },
	{ "width", "Dimension", TextToggle },
	{ "width", "Dimension", Toggle },
	{ "width", "Dimension", TopLevelShell },
	{ "width", "Dimension", TransientShell },
	{ "width", "Dimension", Tree },
	{ "width", "Dimension", Viewport },
	{ "width", "Dimension", WMShell },
	{ "width", "Dimension", XfwfCommon },
	{ "width", "Dimension", XfwfMenuBar },
	{ "widthInc", "Int", ApplicationShell },
	{ "widthInc", "Int", TopLevelShell },
	{ "widthInc", "Int", TransientShell },
	{ "widthInc", "Int", WMShell },
	{ "winGravity", "Int", ApplicationShell },
	{ "winGravity", "Int", TopLevelShell },
	{ "winGravity", "Int", TransientShell },
	{ "winGravity", "Int", WMShell },
	{ "windowGroup", "Window", ApplicationShell },
	{ "windowGroup", "Window", TopLevelShell },
	{ "windowGroup", "Window", TransientShell },
	{ "windowGroup", "Window", WMShell },
	{ "wmTimeout", "Int", ApplicationShell },
	{ "wmTimeout", "Int", TopLevelShell },
	{ "wmTimeout", "Int", TransientShell },
	{ "wmTimeout", "Int", WMShell },
	{ "wrap", "WrapMode", AsciiText },
	{ "x", "Position", ApplicationShell },
	{ "x", "Position", Arrow },
	{ "x", "Position", AsciiText },
	{ "x", "Position", Board },
	{ "x", "Position", Box },
	{ "x", "Position", Command },
	{ "x", "Position", Core },
	{ "x", "Position", Dialog },
	{ "x", "Position", Form },
	{ "x", "Position", Frame },
	{ "x", "Position", Grip },
	{ "x", "Position", Group },
	{ "x", "Position", Gterm },
	{ "x", "Position", HTML },
	{ "x", "Position", Icon },
	{ "x", "Position", Label },
	{ "x", "Position", Layout },
	{ "x", "Position", List },
	{ "x", "Position", MenuButton },
	{ "x", "Position", MultiList },
	{ "x", "Position", OverrideShell },
	{ "x", "Position", Paned },
	{ "x", "Position", Panner },
	{ "x", "Position", Porthole },
	{ "x", "Position", RadioGroup },
	{ "x", "Position", Repeater },
	{ "x", "Position", RowCol },
	{ "x", "Position", Scrollbar },
	{ "x", "Position", Scrollbar2 },
	{ "x", "Position", Shell },
	{ "x", "Position", Simple },
	{ "x", "Position", SimpleMenu },
	{ "x", "Position", Slider2d },
	{ "x", "Position", Sme },
	{ "x", "Position", SmeBSB },
	{ "x", "Position", SmeLine },
	{ "x", "Position", StripChart },
	{ "x", "Position", TextBox },
	{ "x", "Position", TextButton },
	{ "x", "Position", TextToggle },
	{ "x", "Position", Toggle },
	{ "x", "Position", TopLevelShell },
	{ "x", "Position", TransientShell },
	{ "x", "Position", Tree },
	{ "x", "Position", Viewport },
	{ "x", "Position", WMShell },
	{ "x", "Position", XfwfCommon },
	{ "x", "Position", XfwfMenuBar },
	{ "xorFill", "Boolean", Gterm },
	{ "xorFillBgColor", "Int", Gterm },
	{ "xorFillColor", "Int", Gterm },
	{ "y", "Position", ApplicationShell },
	{ "y", "Position", Arrow },
	{ "y", "Position", AsciiText },
	{ "y", "Position", Board },
	{ "y", "Position", Box },
	{ "y", "Position", Command },
	{ "y", "Position", Core },
	{ "y", "Position", Dialog },
	{ "y", "Position", Form },
	{ "y", "Position", Frame },
	{ "y", "Position", Grip },
	{ "y", "Position", Group },
	{ "y", "Position", Gterm },
	{ "y", "Position", HTML },
	{ "y", "Position", Icon },
	{ "y", "Position", Label },
	{ "y", "Position", Layout },
	{ "y", "Position", List },
	{ "y", "Position", MenuButton },
	{ "y", "Position", MultiList },
	{ "y", "Position", OverrideShell },
	{ "y", "Position", Paned },
	{ "y", "Position", Panner },
	{ "y", "Position", Porthole },
	{ "y", "Position", RadioGroup },
	{ "y", "Position", Repeater },
	{ "y", "Position", RowCol },
	{ "y", "Position", Scrollbar },
	{ "y", "Position", Scrollbar2 },
	{ "y", "Position", Shell },
	{ "y", "Position", Simple },
	{ "y", "Position", SimpleMenu },
	{ "y", "Position", Slider2d },
	{ "y", "Position", Sme },
	{ "y", "Position", SmeBSB },
	{ "y", "Position", SmeLine },
	{ "y", "Position", StripChart },
	{ "y", "Position", TextBox },
	{ "y", "Position", TextButton },
	{ "y", "Position", TextToggle },
	{ "y", "Position", Toggle },
	{ "y", "Position", TopLevelShell },
	{ "y", "Position", TransientShell },
	{ "y", "Position", Tree },
	{ "y", "Position", Viewport },
	{ "y", "Position", WMShell },
	{ "y", "Position", XfwfCommon },
	{ "y", "Position", XfwfMenuBar },
	{ NULL, NULL, NULL },
};

/* Prints a table listing the unique resource name/type pairs, with a bitmask
 * indicating the widget classes using each resource/type pair.
 */
main (argc, argv)
int	argc;
char	*argv[];
{
	register struct resource_list *rp, *np;
	register unsigned long flags1, flags2;
	int decorate = 0;

	if (argc >= 2 && !strcmp(argv[1],"-decorate"))
	    decorate++;

	for (rp=resources;  rp && rp->resource;  rp=np) {
	    for (np=rp, flags1=flags2=0;  np && np->type &&
		(!strcmp(rp->resource,np->resource) &&
		 !strcmp(rp->type,np->type));  ) {

		flags1 |= np->class1;
		flags2 |= np->class2;
		np++;
	    }

	    if (decorate) {
		printf ("{ \"%s\", XtR%s, %011o, %011o, NULL },\n",
		    rp->resource, rp->type, flags1, flags2);
	    } else {
		printf ("%s %s %011o %011o\n",
		    rp->resource, rp->type, flags1, flags2);
	    }
	}
}
