// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _XDEFINITIONS_H
#define _XDEFINITIONS_H

#include "lyxfont.h"
#include "definitions.h"
#include "forms.h"

/* table for all the fonts
 * family        series          shape       size - zoom  (zoom from 1 to 4)
 * 0 roman       0 medium        0 upshape   0 small
 * 1 modern      1 bold          1 italic    1 normal
 * 2 typewriter                    /slanted  2 large
 *                                           3 Huge 
 */


typedef struct _WidgetRec *Widget;

GC LyXGetGC(LyXFont font);
GC LyXGetMathGC();
GC LyXGetMathFrameGC();
GC LyXGetClearGC();
GC LyXGetFillGC();
GC LyXGetFootGC();
GC LyXGetGC();
GC LyXGetLatexGC();
GC LyXGetCopyGC();
GC LyXGetOnOffLineGC();
GC LyXGetThinOnOffLineGC();
GC LyXGetThickLineGC();
GC LyXGetLightedGC();
GC LyXGetInsetGC();

GC LyXGetSelectGC();
int LyXMaxAscent(LyXFont font);
int LyXMaxDescent(LyXFont font);
int LyXWidth(LyXFont font, char c);
int LyXAscent(LyXFont font, char c);
int LyXDescent(LyXFont font, char c);

int LyXTextWidth(LyXFont font, char*s, int n);
int LyXStringWidth(LyXFont font, char *s);

void LyXDrawString(LyXFont font, char* s, Pixmap pm, int baseline, int x);
void LyXDrawText(LyXFont font, char* s, int n, Pixmap pm, int baseline, int x);

// inlined functions
inline
void LyXBell() {
	// if (audio()) ON/OFF switch yet to be implemented
		XBell(fl_display, 20);
}

#endif
