-- 
-- Zabbix
-- Copyright (C) 2000,2001,2002,2003,2004 Alexei Vladishev
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--

--
-- Dumping data for table `config`
--

INSERT INTO config VALUES (365,365,600,'1-5,00:00-24:00');

--
-- Dumping data for table `media_type`
--

INSERT INTO media_type VALUES (1,0,'Email','localhost','localhost','zabbix@localhost','','');

--
-- Dumping data for table `users`
--

INSERT INTO users VALUES (1,'Admin','Zabbix','Administrator','d41d8cd98f00b204e9800998ecf8427e',' ',900,'en_gb',30);
INSERT INTO users VALUES (2,'guest','Default','User','d41d8cd98f00b204e9800998ecf8427e',' ',900,'en_gb',30);

--
-- Dumping data for table `usrgrp`
--

INSERT INTO usrgrp VALUES (1,'UNIX administrators');
INSERT INTO usrgrp VALUES (2,'Database administrators');
INSERT INTO usrgrp VALUES (3,'Network administrators');
INSERT INTO usrgrp VALUES (4,'Security specialists');
INSERT INTO usrgrp VALUES (5,'WEB administrators');
INSERT INTO usrgrp VALUES (6,'Head of IT department');
INSERT INTO usrgrp VALUES (7,'Zabbix administrators');

--
-- Dumping data for table `rights`
--

INSERT INTO rights VALUES (1,1,'Default permission','U',0);
INSERT INTO rights VALUES (2,1,'Default permission','A',0);
INSERT INTO rights VALUES (3,2,'Default permission','R',0);

--
-- Dumping data for table `hosts`
--

INSERT INTO hosts VALUES (10001,'Unix_t',0,'',10000,3,0,'',0,0,0);
INSERT INTO hosts VALUES (10002,'Windows_t',0,'',10000,3,0,'',0,0,0);
INSERT INTO hosts VALUES (10004,'Standalone_t',0,'',10000,3,0,'',0,0,0);
INSERT INTO hosts VALUES (10003,'MySQL_t',0,'',10000,3,0,'',0,0,0);
INSERT INTO hosts VALUES (10007,'SNMP_t',0,'',161,3,0,'',0,0,0);

--
-- Dumping data for table `groups`
--

INSERT INTO groups VALUES (1,'Templates');

--
-- Dumping data for table `hosts_groups`
--

INSERT INTO hosts_groups VALUES (10001,1);
INSERT INTO hosts_groups VALUES (10002,1);
INSERT INTO hosts_groups VALUES (10003,1);
INSERT INTO hosts_groups VALUES (10004,1);
INSERT INTO hosts_groups VALUES (10007,1);

--
-- Dumping data for table `help_items`
--


insert into help_items values (3,'icmpping','Checks if server accessible by ICMP ping	0 - ICMP ping fails 1 - ICMP ping successful	One of zabbix_server processes performs ICMP pings once per PingerFrequency seconds.');
insert into help_items values (3,'icmppingsec','Return ICMP ping response time	Number of seconds Example: 0.02');
insert into help_items values (3,'ftp&lt;,port&gt;','Checks if FTP server is running and accepting connections	0 - FTP server is down 1 - FTP server is running');
insert into help_items values (3,'http&lt;,port&gt;','Checks if HTTP (WEB) server is running and accepting connections	0 - HTTP server is down 1 - HTTP server is running');
insert into help_items values (3,'imap&lt;,port&gt;','Checks if IMAP server is running and accepting connections	0 - IMAP server is down 1 - IMAP server is running');
insert into help_items values (3,'nntp&lt;,port&gt;','Checks if NNTP server is running and accepting connections	0 - NNTP server is down 1 - NNTP server is running');
insert into help_items values (3,'pop&lt;,port&gt;','Checks if POP server is running and accepting connections	0 - POP server is down 1 - POP server is running');
insert into help_items values (3,'smtp&lt;,port&gt;','Checks if SMTP server is running and accepting connections	0 - SMTP server is down 1 - SMTP server is running');
insert into help_items values (3,'ssh&lt;,port&gt;','Checks if SSH server is running and accepting connections	0 - SSH server is down 1 - SSH server is running');
insert into help_items values (3,'tcp,port','Checks if TCP service is running and accepting connections on port	0 - the serivce on the por t is down 1 - the service is running');
insert into help_items values (3,'ftp_perf&lt;,port&gt;','Checks if FTP server is running and accepting connections	0 - FTP server is down Otherwise, number of milliseconds spent connecting to FTP server');
insert into help_items values (3,'http_perf&lt;,port&gt;','Checks if HTTP (WEB) server is running and accepting connections	0 - HTTP server is down Otherwise, number of milliseconds spent connecting to HTTP server');
insert into help_items values (3,'imap_perf&lt;,port&gt;','Checks if IMAP server is running and accepting connections	0 - IMAP server is down Otherwise, number of milliseconds spent connecting to IMAP server');
insert into help_items values (3,'nntp_perf&lt;,port&gt;','Checks if NNTP server is running and accepting connections	0 - NNTP server is down Otherwise, number of milliseconds spent connecting to NNTP server');
insert into help_items values (3,'pop_perf&lt;,port&gt;','Checks if POP server is running and accepting connections	0 - POP server is down Otherwise, number of milliseconds spent connecting to POP server');
insert into help_items values (3,'smtp_perf&lt;,port&gt;','Checks if SMTP server is running and accepting connections	0 - SMTP server is down Otherwise, number of milliseconds spent connecting to SMTP server');
insert into help_items values (3,'ssh_perf&lt;,port&gt;','Checks if SSH server is running and accepting connections	0 - SSH server is down Otherwise, number of milliseconds spent connecting to SSH server');

insert into help_items values (5,'zabbix[history]','Number of values stored in table HISTORY');
insert into help_items values (5,'zabbix[history_str]','Number of values stored in table HISTORY_STR');
insert into help_items values (5,'zabbix[items]','Number of items in ZABBIX database');
insert into help_items values (5,'zabbix[items_unsupported]','Number of unsupported items in ZABBIX database');
insert into help_items values (5,'zabbix[log]','Stores warning and error messages generated by ZABBIX server.');
insert into help_items values (5,'zabbix[queue]','Number of items in the queue');
insert into help_items values (5,'zabbix[trends]','Number of values stored in table TRENDS');
insert into help_items values (5,'zabbix[triggers]','Number of triggers in ZABBIX database');

insert into help_items values (8,'grpfunc(&lt;Group&gt;,&lt;Key&gt;,&lt;func&gt;,&lt;param&gt;)','Aggregate checks does not require any agent running on a host being monitored. ZABBIX server collects aggregate information by doing direct database queries. See ZABBIX Manual.');

insert into help_items values(0,'agent.ping','Check the agent usability. Always return 1. Can be used as a TCP ping.');
insert into help_items values(0,'agent.version','Version of zabbix_agent(d) running on monitored host. String value. Example of returned value: 1.1');
insert into help_items values(0,'kernel.maxfiles','Maximum number of opened file supported by OS.');
insert into help_items values(0,'kernel.maxproc','Maximum number of processes supported by OS.');
insert into help_items values(0,'net.if.collisions[if]','Out-of-window collision. Collisions count.');
insert into help_items values(0,'net.if.in[if &lt;,mode&gt;]','Network interfice input statistic. Integer value. If mode is missing bytes is used.');
insert into help_items values(0,'net.if.out[if &lt;,mode&gt;]','Network interfice output statistic. Integer value. If mode is missing bytes is used.');
insert into help_items values(0,'net.tcp.dns[ip, zone]','Checks if DNS service is up. 0 - DNS is down, 1 - DNS is up.');
insert into help_items values(0,'net.tcp.listen[port]','Checks if this port is in LISTEN state. 0 - it is not, 1 - it is in LISTEN state.');
insert into help_items values(0,'net.tcp.port[&lt;ip&gt;, port]','Check, if it is possible to make TCP connection to the port number. 0 - cannot connect, 1 - can connect. IP address is optional. If ip is missing, 127.0.0.1 is used. Example: net.tcp.port[,80]');
insert into help_items values(0,'net.tcp.service[service &lt;,ip&gt; &lt;,port&gt;]','Check if service server is running and accepting connections. 0 - service is down, 1 - service is running. If ip is missing 127.0.0.1 is used. If port number is missing, default service port is used. Example: net.tcp.service[ftp,,45].');
insert into help_items values(0,'net.tcp.service.perf[service &lt;,ip&gt; &lt;,port&gt;]','Check performance of service server. 0 - service server is down, sec - number of seconds spent on connection to the service server. If ip is missing 127.0.0.1 is used.  If port number is missing, default service port is used.');
insert into help_items values(0,'proc.mem[&lt;name&gt; &lt;,user&gt; &lt;,mode&gt;]','Memory used of process with name name running under user user. Memory used by processes. Process name, user and mode is optional. If name or user is missing all processes will be calculated. If mode is missing sum is used.  Examples: proc.mem[,root]');
insert into help_items values(0,'proc.num[&lt;name&gt; &lt;,user&gt; &lt;,state&gt;]','Number of processes with name name running under user user having state state. Process name, user and state are optional. Example: proc.num[,root]');
insert into help_items values(0,'system.cpu.intr','Device interrupts.');
insert into help_items values(0,'system.cpu.load[&lt;cpu&gt; &lt;,mode&gt;]','CPU(s) load. Processor load. The cpu and mode are optional. If cpu is missing all is used. If mode is missing avg1 is used. Note that this is not percentage.');
insert into help_items values(0,'system.cpu.switches','Context switches.');
insert into help_items values(0,'system.cpu.util[&lt;cpu&gt; &lt;,type&gt; &lt;,mode&gt;]','CPU(s) utilisation. Processor load in percents. The cpu, type and mode are optional. If cpu is missing all is used.  If type is missing user is used. If mode is missing avg1 is used.');
insert into help_items values(0,'system.hostname','Return host name. String value. Example of returned value: www.zabbix.com');
insert into help_items values(0,'system.localtime','System local time. Time in seconds.');
insert into help_items values(0,'system.swap.in[&lt;swap&gt; &lt;,type&gt;]','Swap in. If type is count - swapins is returned. If type is pages - pages swapped in is returned.	If swap is missing all is used.');
insert into help_items values(0,'system.swap.out[&lt;swap&gt; &lt;,type&gt;]','Swap out. If type is count - swapouts is returned. If type is pages - pages swapped in is returned.  If swap is missing all is used.');
insert into help_items values(0,'system.swap.size[&lt;swap&gt; &lt;,mode&gt;]','Swap space. Number of bytes. If swap is missing all is used. If mode is missing free is used.');
insert into help_items values(0,'system.uname','Returns detailed host information. String value');
insert into help_items values(0,'system.uptime','System uptime. Set units s or uptime.');
insert into help_items values(0,'system.users.num','Number of users connected. Command who is used on agent side.');
insert into help_items values(0,'vfs.dev.read[device &lt;,type&gt; &lt;,mode&gt;]','Device read statistics.');
insert into help_items values(0,'vfs.dev.write[device &lt;,type&gt; &lt;,mode&gt;]','Device write statistics.');
insert into help_items values(0,'vfs.file.cksum[file]','Calculate check sum of a given file. Check sum of the file calculate by standard algorithm used by UNIX utility cksum.	Example: vfs.file.cksum[/etc/passwd]');
insert into help_items values(0,'vfs.file.exists[file]','Check file existance. 0 - file does not exists, 1 - file exists');
insert into help_items values(0,'vfs.file.md5sum[file]','Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/etc/zabbix/zabbix_agentd.conf]');
insert into help_items values(0,'vfs.file.regexp[file, user]','');
insert into help_items values(0,'vfs.file.regmatch[file, user]','');
insert into help_items values(0,'vfs.file.size[file]','Size of a given file. Size in bytes. File must have read permissions for user zabbix. Example: vfs.file.size[/var/log/syslog]');
insert into help_items values(0,'vfs.file.time[file&lt;, mode&gt;]','File time information. Number of seconds.	The mode is optional. If mode is missing modify is used.');
insert into help_items values(0,'vfs.fs.inode[fs &lt;,mode&gt;]','Number of inodes for a given volume. If mode is missing total is used.');
insert into help_items values(0,'vfs.fs.size[fs &lt;,mode&gt;]','Calculate disk space for a given volume. Disk space in KB. If mode is missing total is used.  In case of mounted volume, unused disk space for local file system is returned. Example: vfs.fs.size[/tmp,free].');
insert into help_items values(0,'vm.memory.size[&lt;mode&gt;]','Amount of memory size in bytes. If mode is missing total is used.');

--
-- Dumping data for table items
--

INSERT INTO items VALUES (10001,0,'','',161,10001,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10002,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10003,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10004,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10005,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10006,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10007,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10008,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10009,0,'','',161,10001,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10010,0,'','',161,10001,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10011,0,'','',161,10001,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10012,0,'','',161,10001,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10013,0,'','',161,10001,'Number of running processes','system[procrunning]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10014,0,'','',161,10001,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10015,0,'','',161,10001,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10016,0,'','',161,10001,'Number of users connected','system.users.num',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10017,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10018,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10019,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10020,0,'','',161,10001,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10021,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10022,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10023,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10024,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10025,0,'','',161,10001,'Host uptime','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10026,0,'','',161,10001,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10027,0,'','',161,10001,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10028,0,'','',161,10001,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10029,0,'','',161,10001,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10030,0,'','',161,10001,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10031,0,'','',161,10001,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10032,0,'','',161,10001,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10033,0,'','',161,10001,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10034,0,'','',161,10001,'Telnet server is running','net.tcp.listen[23]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10035,0,'','',161,10001,'WEB server is running','net.tcp.listen[80]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10036,0,'','',161,10001,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10037,0,'','',161,10001,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10038,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10039,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10040,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10041,0,'','',161,10001,'Number of disks read/write operations','io[disk_io]',30,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10042,0,'','',161,10001,'Number of disks read operations','io[disk_rio]',30,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10043,0,'','',161,10001,'Number of disks write operations','io[disk_wio]',30,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10044,0,'','',161,10001,'Number of block read from disks','io[disk_rblk]',30,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10045,0,'','',161,10001,'Number of block written to disks','io[disk_wblk]',30,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10046,0,'','',161,10001,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10047,0,'','',161,10001,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10048,0,'','',161,10001,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10049,0,'','',161,10001,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10050,0,'','',161,10001,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10051,0,'','',161,10001,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10052,0,'','',161,10001,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10053,0,'','',161,10001,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10055,0,'','',161,10001,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10056,0,'','',161,10001,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10057,0,'','',161,10001,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10058,0,'','',161,10001,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10059,0,'','',161,10001,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10060,0,'','',161,10001,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10061,0,'','',161,10001,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10062,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10063,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10064,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10065,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10066,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10067,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10068,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10069,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10070,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10071,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10072,0,'','',161,10001,'Input statistic on interface lo','net.if.in[lo]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10075,0,'','',161,10001,'Input statistic on interface eth0','net.if.in[eth0]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10078,0,'','',161,10001,'Input statistic on interface eth1','net.if.in[eth1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10081,0,'','',161,10001,'Output statistic on interface lo','net.if.out[lo]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10084,0,'','',161,10001,'Output statistic on interface eth0','net.if.out[eth0]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10087,0,'','',161,10001,'Output statistic on interface eth1','net.if.out[eth1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10400,0,'','',161,10001,'Number of read bytes on disk hda (1min)','vfs.dev.read[hda,,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10401,0,'','',161,10001,'Number of read bytes on disk hda (5min)','vfs.dev.read[hda,,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10402,0,'','',161,10001,'Number of read bytes on disk hda (15min)','vfs.dev.read[hda,,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10403,0,'','',161,10001,'Number of write bytes on disk hda (1min)','vfs.dev.write[hda,,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10404,0,'','',161,10001,'Number of write bytes on disk hda (5min)','vfs.dev.write[hda,,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10405,0,'','',161,10001,'Number of write bytes on disk hda (15min)','vfs.dev.write[hda,,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10406,0,'','',161,10001,'Number of read bytes on disk hdb (1min)','vfs.dev.read[hdb,,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10407,0,'','',161,10001,'Number of read bytes on disk hdb (5min)','vfs.dev.read[hdb,,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10408,0,'','',161,10001,'Number of read bytes on disk hdb (15min)','vfs.dev.read[hdb,,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10409,0,'','',161,10001,'Number of write bytes on disk hdb (1min)','vfs.dev.write[hdb,,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10410,0,'','',161,10001,'Number of write bytes on disk hdb (5min)','vfs.dev.write[hdb,,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10411,0,'','',161,10001,'Number of write bytes on disk hdb (15min)','vfs.dev.write[hdb,,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10412,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10413,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10414,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10415,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10416,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10417,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0);
INSERT INTO items VALUES (10418,0,'','',161,10001,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10419,0,'','',161,10001,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10420,0,'','',161,10001,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10090,0,'','',161,10002,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10091,0,'','',161,10002,'Free disk space on $1','vfs.fs.size[c:,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','1','',0,'',0,0);
INSERT INTO items VALUES (10098,0,'','',161,10002,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10099,0,'','',161,10002,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10100,0,'','',161,10002,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10101,0,'','',161,10002,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10102,0,'','',161,10002,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10103,0,'','',161,10002,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10104,0,'','',161,10002,'Size of $1','vfs.file.size[c:\\msdos.sys]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10106,0,'','',161,10002,'Checksum of $1','vfs.file.cksum[c:\\autoexec.bat]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10109,0,'','',161,10002,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10114,0,'','',161,10002,'Host uptime','system.uptime',300,7,365,0,NULL,NULL,NULL,0,0,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10115,0,'','',161,10002,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10119,0,'','',161,10002,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10137,0,'','',161,10002,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10147,0,'','',161,10002,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10148,0,'','',161,10002,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10150,0,'','',161,10002,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10156,0,'','',161,10002,'Total disk space on $1','vfs.fs.size[c:,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10359,0,'','',161,10002,'Total disk space on $1','vfs.fs.size[d:,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10357,0,'','',161,10002,'Checksum of $1','vfs.file.cksum[c:\\config.sys]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10358,0,'','',161,10002,'Free disk space on $1','vfs.fs.size[d:,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','1','',0,'',0,0);
INSERT INTO items VALUES (10200,0,'','',161,10003,'MySQL is alive','mysql[ping]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10201,0,'','',161,10003,'MySQL uptime','mysql[uptime]',60,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10202,0,'','',161,10003,'MySQL number of threads','mysql[threads]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10203,0,'','',161,10003,'MySQL queries per second','mysql[qps]',60,7,365,0,NULL,NULL,NULL,0,0,'','qps',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10204,0,'','',161,10003,'MySQL number of slow queries','mysql[slowqueries]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10205,0,'','',161,10003,'MySQL version','version[mysql]',600,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10298,3,'','',161,10004,'Email (SMTP) server is running','smtp',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10299,3,'','',161,10004,'FTP server is running','ftp',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10300,3,'','',161,10004,'SSH server is running','ssh',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10303,3,'','',161,10004,'POP3 server is running','pop',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10304,3,'','',161,10004,'IMAP server is running','imap',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10313,3,'','',161,10004,'News (NNTP) server is running','nntp',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (10327,3,'','',161,10004,'WEB (HTTP) server is running','http',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17001,4,'public','1.3.6.1.2.1.1.5.0',161,10007,'sysName','sysName',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17002,4,'public','1.3.6.1.4.1.9.2.1.112.0',161,10007,'lenvSerialNumber','lenvSerialNumber',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17003,4,'public','1.3.6.1.4.1.9.2.1.47.0',161,10007,'lmemBufferNoMem','lmemBufferNoMem',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17004,4,'public','1.3.6.1.4.1.9.2.1.56.0',161,10007,'lcpuPercentBusy','lcpuPercentBusy',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17005,4,'public','1.3.6.1.4.1.9.2.1.108.0',161,10007,'lenvFirmVersion','lenvFirmVersion',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17006,4,'public','1.3.6.1.4.1.9.2.1.46.0',161,10007,'lmemBufferFail','lmemBufferFail',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17007,4,'public','1.3.6.1.4.1.9.2.1.8.0',161,10007,'lmemFreeMem','lmemFreeMem',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17008,4,'public','1.3.6.1.4.1.9.2.1.1.0',161,10007,'lmemRomID','lmemRomID',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17009,4,'public','1.3.6.1.2.1.2.2.1.2.1',161,10007,'ifDescr1','ifDescr1',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17010,4,'public','1.3.6.1.2.1.2.2.1.2.2',161,10007,'ifDescr2','ifDescr2',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17011,4,'public','1.3.6.1.2.1.2.2.1.2.3',161,10007,'ifDescr3','ifDescr3',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17012,4,'public','1.3.6.1.2.1.2.2.1.2.4',161,10007,'ifDescr4','ifDescr4',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17013,4,'public','1.3.6.1.2.1.2.2.1.2.5',161,10007,'ifDescr5','ifDescr5',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17014,4,'public','1.3.6.1.2.1.2.2.1.2.6',161,10007,'ifDescr6','ifDescr6',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17015,4,'public','1.3.6.1.2.1.2.2.1.2.7',161,10007,'ifDescr7','ifDescr7',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17016,4,'public','1.3.6.1.2.1.2.2.1.2.8',161,10007,'ifDescr8','ifDescr8',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17017,4,'public','1.3.6.1.2.1.2.2.1.2.9',161,10007,'ifDescr9','ifDescr9',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17018,4,'public','1.3.6.1.2.1.2.2.1.2.10',161,10007,'ifDescr10','ifDescr10',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17019,4,'public','1.3.6.1.2.1.2.2.1.2.11',161,10007,'ifDescr11','ifDescr11',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17020,4,'public','1.3.6.1.2.1.2.2.1.2.12',161,10007,'ifDescr12','ifDescr12',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17021,4,'public','1.3.6.1.2.1.2.2.1.2.13',161,10007,'ifDescr13','ifDescr13',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17022,4,'public','1.3.6.1.2.1.2.2.1.2.14',161,10007,'ifDescr14','ifDescr14',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17023,4,'public','1.3.6.1.2.1.2.2.1.2.15',161,10007,'ifDescr15','ifDescr15',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17024,4,'public','1.3.6.1.2.1.2.2.1.2.16',161,10007,'ifDescr16','ifDescr16',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17025,4,'public','1.3.6.1.2.1.2.2.1.2.17',161,10007,'ifDescr17','ifDescr17',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17026,4,'public','1.3.6.1.2.1.2.2.1.2.18',161,10007,'ifDescr18','ifDescr18',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17027,4,'public','1.3.6.1.2.1.2.2.1.2.19',161,10007,'ifDescr19','ifDescr19',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17028,4,'public','1.3.6.1.2.1.2.2.1.2.20',161,10007,'ifDescr20','ifDescr20',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17029,4,'public','1.3.6.1.2.1.2.2.1.2.21',161,10007,'ifDescr21','ifDescr21',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17030,4,'public','1.3.6.1.2.1.2.2.1.2.22',161,10007,'ifDescr22','ifDescr22',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17031,4,'public','1.3.6.1.2.1.2.2.1.2.23',161,10007,'ifDescr23','ifDescr23',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17032,4,'public','1.3.6.1.2.1.2.2.1.2.24',161,10007,'ifDescr24','ifDescr24',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17033,4,'public','1.3.6.1.2.1.2.2.1.2.25',161,10007,'ifDescr25','ifDescr25',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17034,4,'public','1.3.6.1.2.1.2.2.1.2.26',161,10007,'ifDescr26','ifDescr26',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17035,4,'public','1.3.6.1.2.1.2.2.1.2.27',161,10007,'ifDescr27','ifDescr27',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17036,4,'public','1.3.6.1.2.1.2.2.1.2.28',161,10007,'ifDescr28','ifDescr28',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17037,4,'public','1.3.6.1.2.1.2.2.1.2.29',161,10007,'ifDescr29','ifDescr29',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17038,4,'public','1.3.6.1.2.1.2.2.1.2.30',161,10007,'ifDescr30','ifDescr30',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17039,4,'public','1.3.6.1.2.1.2.2.1.2.31',161,10007,'ifDescr31','ifDescr31',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17040,4,'public','1.3.6.1.2.1.2.2.1.2.32',161,10007,'ifDescr32','ifDescr32',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17041,4,'public','1.3.6.1.2.1.2.2.1.2.33',161,10007,'ifDescr33','ifDescr33',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17042,4,'public','1.3.6.1.2.1.2.2.1.2.34',161,10007,'ifDescr34','ifDescr34',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17043,4,'public','1.3.6.1.2.1.2.2.1.2.35',161,10007,'ifDescr35','ifDescr35',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17044,4,'public','1.3.6.1.2.1.2.2.1.2.36',161,10007,'ifDescr36','ifDescr36',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17045,4,'public','1.3.6.1.2.1.2.2.1.2.37',161,10007,'ifDescr37','ifDescr37',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17046,4,'public','1.3.6.1.2.1.2.2.1.2.38',161,10007,'ifDescr38','ifDescr38',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17047,4,'public','1.3.6.1.2.1.2.2.1.2.39',161,10007,'ifDescr39','ifDescr39',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17048,4,'public','1.3.6.1.2.1.2.2.1.2.40',161,10007,'ifDescr40','ifDescr40',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17049,4,'public','1.3.6.1.2.1.2.2.1.2.41',161,10007,'ifDescr41','ifDescr41',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17050,4,'public','1.3.6.1.2.1.2.2.1.2.42',161,10007,'ifDescr42','ifDescr42',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17051,4,'public','1.3.6.1.2.1.2.2.1.2.43',161,10007,'ifDescr43','ifDescr43',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17052,4,'public','1.3.6.1.2.1.2.2.1.2.44',161,10007,'ifDescr44','ifDescr44',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17053,4,'public','1.3.6.1.2.1.2.2.1.2.45',161,10007,'ifDescr45','ifDescr45',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17054,4,'public','1.3.6.1.2.1.2.2.1.2.46',161,10007,'ifDescr46','ifDescr46',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17055,4,'public','1.3.6.1.2.1.2.2.1.2.47',161,10007,'ifDescr47','ifDescr47',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17056,4,'public','1.3.6.1.2.1.2.2.1.2.48',161,10007,'ifDescr48','ifDescr48',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17057,4,'public','1.3.6.1.2.1.2.2.1.2.49',161,10007,'ifDescr49','ifDescr49',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17058,4,'public','1.3.6.1.2.1.2.2.1.2.50',161,10007,'ifDescr50','ifDescr50',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17059,4,'public','1.3.6.1.2.1.2.2.1.2.51',161,10007,'ifDescr51','ifDescr51',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17060,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10007,'ifInOctets1','ifInOctets1',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17061,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10007,'ifInOctets2','ifInOctets2',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17062,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10007,'ifInOctets3','ifInOctets3',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17063,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10007,'ifInOctets4','ifInOctets4',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17064,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10007,'ifInOctets5','ifInOctets5',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17065,4,'public','1.3.6.1.2.1.2.2.1.10.6',161,10007,'ifInOctets6','ifInOctets6',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17066,4,'public','1.3.6.1.2.1.2.2.1.10.7',161,10007,'ifInOctets7','ifInOctets7',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17067,4,'public','1.3.6.1.2.1.2.2.1.10.8',161,10007,'ifInOctets8','ifInOctets8',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17068,4,'public','1.3.6.1.2.1.2.2.1.10.9',161,10007,'ifInOctets9','ifInOctets9',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17069,4,'public','1.3.6.1.2.1.2.2.1.10.10',161,10007,'ifInOctets10','ifInOctets10',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17070,4,'public','1.3.6.1.2.1.2.2.1.10.11',161,10007,'ifInOctets11','ifInOctets11',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17071,4,'public','1.3.6.1.2.1.2.2.1.10.12',161,10007,'ifInOctets12','ifInOctets12',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17072,4,'public','1.3.6.1.2.1.2.2.1.10.13',161,10007,'ifInOctets13','ifInOctets13',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17073,4,'public','1.3.6.1.2.1.2.2.1.10.14',161,10007,'ifInOctets14','ifInOctets14',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17074,4,'public','1.3.6.1.2.1.2.2.1.10.15',161,10007,'ifInOctets15','ifInOctets15',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17075,4,'public','1.3.6.1.2.1.2.2.1.10.16',161,10007,'ifInOctets16','ifInOctets16',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17076,4,'public','1.3.6.1.2.1.2.2.1.10.17',161,10007,'ifInOctets17','ifInOctets17',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17077,4,'public','1.3.6.1.2.1.2.2.1.10.18',161,10007,'ifInOctets18','ifInOctets18',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17078,4,'public','1.3.6.1.2.1.2.2.1.10.19',161,10007,'ifInOctets19','ifInOctets19',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17079,4,'public','1.3.6.1.2.1.2.2.1.10.20',161,10007,'ifInOctets20','ifInOctets20',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17080,4,'public','1.3.6.1.2.1.2.2.1.10.21',161,10007,'ifInOctets21','ifInOctets21',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17081,4,'public','1.3.6.1.2.1.2.2.1.10.22',161,10007,'ifInOctets22','ifInOctets22',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17082,4,'public','1.3.6.1.2.1.2.2.1.10.23',161,10007,'ifInOctets23','ifInOctets23',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17083,4,'public','1.3.6.1.2.1.2.2.1.10.24',161,10007,'ifInOctets24','ifInOctets24',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17084,4,'public','1.3.6.1.2.1.2.2.1.10.25',161,10007,'ifInOctets25','ifInOctets25',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17085,4,'public','1.3.6.1.2.1.2.2.1.10.26',161,10007,'ifInOctets26','ifInOctets26',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17086,4,'public','1.3.6.1.2.1.2.2.1.10.27',161,10007,'ifInOctets27','ifInOctets27',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17087,4,'public','1.3.6.1.2.1.2.2.1.10.28',161,10007,'ifInOctets28','ifInOctets28',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17088,4,'public','1.3.6.1.2.1.2.2.1.10.29',161,10007,'ifInOctets29','ifInOctets29',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17089,4,'public','1.3.6.1.2.1.2.2.1.10.30',161,10007,'ifInOctets30','ifInOctets30',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17090,4,'public','1.3.6.1.2.1.2.2.1.10.31',161,10007,'ifInOctets31','ifInOctets31',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17091,4,'public','1.3.6.1.2.1.2.2.1.10.32',161,10007,'ifInOctets32','ifInOctets32',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17092,4,'public','1.3.6.1.2.1.2.2.1.10.33',161,10007,'ifInOctets33','ifInOctets33',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17093,4,'public','1.3.6.1.2.1.2.2.1.10.34',161,10007,'ifInOctets34','ifInOctets34',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17094,4,'public','1.3.6.1.2.1.2.2.1.10.35',161,10007,'ifInOctets35','ifInOctets35',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17095,4,'public','1.3.6.1.2.1.2.2.1.10.36',161,10007,'ifInOctets36','ifInOctets36',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17096,4,'public','1.3.6.1.2.1.2.2.1.10.37',161,10007,'ifInOctets37','ifInOctets37',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17097,4,'public','1.3.6.1.2.1.2.2.1.10.38',161,10007,'ifInOctets38','ifInOctets38',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17098,4,'public','1.3.6.1.2.1.2.2.1.10.39',161,10007,'ifInOctets39','ifInOctets39',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17099,4,'public','1.3.6.1.2.1.2.2.1.10.40',161,10007,'ifInOctets40','ifInOctets40',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17100,4,'public','1.3.6.1.2.1.2.2.1.10.41',161,10007,'ifInOctets41','ifInOctets41',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17101,4,'public','1.3.6.1.2.1.2.2.1.10.42',161,10007,'ifInOctets42','ifInOctets42',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17102,4,'public','1.3.6.1.2.1.2.2.1.10.43',161,10007,'ifInOctets43','ifInOctets43',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17103,4,'public','1.3.6.1.2.1.2.2.1.10.44',161,10007,'ifInOctets44','ifInOctets44',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17104,4,'public','1.3.6.1.2.1.2.2.1.10.45',161,10007,'ifInOctets45','ifInOctets45',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17105,4,'public','1.3.6.1.2.1.2.2.1.10.46',161,10007,'ifInOctets46','ifInOctets46',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17106,4,'public','1.3.6.1.2.1.2.2.1.10.47',161,10007,'ifInOctets47','ifInOctets47',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17107,4,'public','1.3.6.1.2.1.2.2.1.10.48',161,10007,'ifInOctets48','ifInOctets48',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17108,4,'public','1.3.6.1.2.1.2.2.1.10.49',161,10007,'ifInOctets49','ifInOctets49',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17109,4,'public','1.3.6.1.2.1.2.2.1.10.50',161,10007,'ifInOctets50','ifInOctets50',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17110,4,'public','1.3.6.1.2.1.2.2.1.10.51',161,10007,'ifInOctets51','ifInOctets51',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17111,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10007,'ifOutOctets1','ifOutOctets1',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17112,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10007,'ifOutOctets2','ifOutOctets2',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17113,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10007,'ifOutOctets3','ifOutOctets3',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17114,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10007,'ifOutOctets4','ifOutOctets4',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17115,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10007,'ifOutOctets5','ifOutOctets5',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17116,4,'public','1.3.6.1.2.1.2.2.1.16.6',161,10007,'ifOutOctets6','ifOutOctets6',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17117,4,'public','1.3.6.1.2.1.2.2.1.16.7',161,10007,'ifOutOctets7','ifOutOctets7',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17118,4,'public','1.3.6.1.2.1.2.2.1.16.8',161,10007,'ifOutOctets8','ifOutOctets8',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17119,4,'public','1.3.6.1.2.1.2.2.1.16.9',161,10007,'ifOutOctets9','ifOutOctets9',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17120,4,'public','1.3.6.1.2.1.2.2.1.16.10',161,10007,'ifOutOctets10','ifOutOctets10',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17121,4,'public','1.3.6.1.2.1.2.2.1.16.11',161,10007,'ifOutOctets11','ifOutOctets11',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17122,4,'public','1.3.6.1.2.1.2.2.1.16.12',161,10007,'ifOutOctets12','ifOutOctets12',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17123,4,'public','1.3.6.1.2.1.2.2.1.16.13',161,10007,'ifOutOctets13','ifOutOctets13',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17124,4,'public','1.3.6.1.2.1.2.2.1.16.14',161,10007,'ifOutOctets14','ifOutOctets14',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17125,4,'public','1.3.6.1.2.1.2.2.1.16.15',161,10007,'ifOutOctets15','ifOutOctets15',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17126,4,'public','1.3.6.1.2.1.2.2.1.16.16',161,10007,'ifOutOctets16','ifOutOctets16',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17127,4,'public','1.3.6.1.2.1.2.2.1.16.17',161,10007,'ifOutOctets17','ifOutOctets17',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17128,4,'public','1.3.6.1.2.1.2.2.1.16.18',161,10007,'ifOutOctets18','ifOutOctets18',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17129,4,'public','1.3.6.1.2.1.2.2.1.16.19',161,10007,'ifOutOctets19','ifOutOctets19',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17130,4,'public','1.3.6.1.2.1.2.2.1.16.20',161,10007,'ifOutOctets20','ifOutOctets20',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17131,4,'public','1.3.6.1.2.1.2.2.1.16.21',161,10007,'ifOutOctets21','ifOutOctets21',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17132,4,'public','1.3.6.1.2.1.2.2.1.16.22',161,10007,'ifOutOctets22','ifOutOctets22',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17133,4,'public','1.3.6.1.2.1.2.2.1.16.23',161,10007,'ifOutOctets23','ifOutOctets23',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17134,4,'public','1.3.6.1.2.1.2.2.1.16.24',161,10007,'ifOutOctets24','ifOutOctets24',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17135,4,'public','1.3.6.1.2.1.2.2.1.16.25',161,10007,'ifOutOctets25','ifOutOctets25',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17136,4,'public','1.3.6.1.2.1.2.2.1.16.26',161,10007,'ifOutOctets26','ifOutOctets26',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17137,4,'public','1.3.6.1.2.1.2.2.1.16.27',161,10007,'ifOutOctets27','ifOutOctets27',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17138,4,'public','1.3.6.1.2.1.2.2.1.16.28',161,10007,'ifOutOctets28','ifOutOctets28',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17139,4,'public','1.3.6.1.2.1.2.2.1.16.29',161,10007,'ifOutOctets29','ifOutOctets29',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17140,4,'public','1.3.6.1.2.1.2.2.1.16.30',161,10007,'ifOutOctets30','ifOutOctets30',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17141,4,'public','1.3.6.1.2.1.2.2.1.16.31',161,10007,'ifOutOctets31','ifOutOctets31',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17142,4,'public','1.3.6.1.2.1.2.2.1.16.32',161,10007,'ifOutOctets32','ifOutOctets32',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17143,4,'public','1.3.6.1.2.1.2.2.1.16.33',161,10007,'ifOutOctets33','ifOutOctets33',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17144,4,'public','1.3.6.1.2.1.2.2.1.16.34',161,10007,'ifOutOctets34','ifOutOctets34',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17145,4,'public','1.3.6.1.2.1.2.2.1.16.35',161,10007,'ifOutOctets35','ifOutOctets35',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17146,4,'public','1.3.6.1.2.1.2.2.1.16.36',161,10007,'ifOutOctets36','ifOutOctets36',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17147,4,'public','1.3.6.1.2.1.2.2.1.16.37',161,10007,'ifOutOctets37','ifOutOctets37',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17148,4,'public','1.3.6.1.2.1.2.2.1.16.38',161,10007,'ifOutOctets38','ifOutOctets38',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17149,4,'public','1.3.6.1.2.1.2.2.1.16.39',161,10007,'ifOutOctets39','ifOutOctets39',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17150,4,'public','1.3.6.1.2.1.2.2.1.16.40',161,10007,'ifOutOctets40','ifOutOctets40',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17151,4,'public','1.3.6.1.2.1.2.2.1.16.41',161,10007,'ifOutOctets41','ifOutOctets41',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17152,4,'public','1.3.6.1.2.1.2.2.1.16.42',161,10007,'ifOutOctets42','ifOutOctets42',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17153,4,'public','1.3.6.1.2.1.2.2.1.16.43',161,10007,'ifOutOctets43','ifOutOctets43',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17154,4,'public','1.3.6.1.2.1.2.2.1.16.44',161,10007,'ifOutOctets44','ifOutOctets44',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17155,4,'public','1.3.6.1.2.1.2.2.1.16.45',161,10007,'ifOutOctets45','ifOutOctets45',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17156,4,'public','1.3.6.1.2.1.2.2.1.16.46',161,10007,'ifOutOctets46','ifOutOctets46',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17157,4,'public','1.3.6.1.2.1.2.2.1.16.47',161,10007,'ifOutOctets47','ifOutOctets47',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17158,4,'public','1.3.6.1.2.1.2.2.1.16.48',161,10007,'ifOutOctets48','ifOutOctets48',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17159,4,'public','1.3.6.1.2.1.2.2.1.16.49',161,10007,'ifOutOctets49','ifOutOctets49',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17160,4,'public','1.3.6.1.2.1.2.2.1.16.50',161,10007,'ifOutOctets50','ifOutOctets50',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17161,4,'public','1.3.6.1.2.1.2.2.1.16.51',161,10007,'ifOutOctets51','ifOutOctets51',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17162,4,'public','1.3.6.1.2.1.4.1.0',161,10007,'ipForwarding','ipForwarding',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17163,4,'public','1.3.6.1.2.1.4.2.0',161,10007,'ipDefaultTTL','ipDefaultTTL',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17164,4,'public','1.3.6.1.2.1.4.3.0',161,10007,'ipInReceives','ipInReceives',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17165,4,'public','1.3.6.1.2.1.4.4.0',161,10007,'ipInHdrErrors','ipInHdrErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17166,4,'public','1.3.6.1.2.1.4.5.0',161,10007,'ipInAddrErrors','ipInAddrErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17167,4,'public','1.3.6.1.2.1.4.6.0',161,10007,'ipInForwDatagrams','ipInForwDatagrams',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17168,4,'public','1.3.6.1.2.1.4.7.0',161,10007,'ipInUnknownProtos','ipInUnknownProtos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17169,4,'public','1.3.6.1.2.1.4.8.0',161,10007,'ipInDiscards','ipInDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17170,4,'public','1.3.6.1.2.1.4.9.0',161,10007,'ipInDelivers','ipInDelivers',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17171,4,'public','1.3.6.1.2.1.4.10.0',161,10007,'ipOutRequests','ipOutRequests',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17172,4,'public','1.3.6.1.2.1.4.11.0',161,10007,'ipOutDiscards','ipOutDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17173,4,'public','1.3.6.1.2.1.4.12.0',161,10007,'ipOutNoRoutes','ipOutNoRoutes',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17174,4,'public','1.3.6.1.2.1.4.13.0',161,10007,'ipReasmTimeout','ipReasmTimeout',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17175,4,'public','1.3.6.1.2.1.4.14.0',161,10007,'ipReasmReqds','ipReasmReqds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17176,4,'public','1.3.6.1.2.1.4.15.0',161,10007,'ipReasmOKs','ipReasmOKs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17177,4,'public','1.3.6.1.2.1.4.16.0',161,10007,'ipReasmFails','ipReasmFails',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17178,4,'public','1.3.6.1.2.1.4.17.0',161,10007,'ipFragOKs','ipFragOKs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17179,4,'public','1.3.6.1.2.1.4.18.0',161,10007,'ipFragFails','ipFragFails',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17180,4,'public','1.3.6.1.2.1.4.19.0',161,10007,'ipFragCreates','ipFragCreates',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17181,4,'public','1.3.6.1.2.1.4.23.0',161,10007,'ipRoutingDiscards','ipRoutingDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17182,4,'public','1.3.6.1.2.1.5.1.0',161,10007,'icmpInMsgs','icmpInMsgs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17183,4,'public','1.3.6.1.2.1.5.2.0',161,10007,'icmpInErrors','icmpInErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17184,4,'public','1.3.6.1.2.1.5.3.0',161,10007,'icmpInDestUnreachs','icmpInDestUnreachs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17185,4,'public','1.3.6.1.2.1.5.4.0',161,10007,'icmpInTimeExcds','icmpInTimeExcds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17186,4,'public','1.3.6.1.2.1.5.5.0',161,10007,'icmpInParmProbs','icmpInParmProbs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17187,4,'public','1.3.6.1.2.1.5.6.0',161,10007,'icmpInSrcQuenchs','icmpInSrcQuenchs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17188,4,'public','1.3.6.1.2.1.5.7.0',161,10007,'icmpInRedirects','icmpInRedirects',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17189,4,'public','1.3.6.1.2.1.5.8.0',161,10007,'icmpInEchos','icmpInEchos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17190,4,'public','1.3.6.1.2.1.5.9.0',161,10007,'icmpInEchoReps','icmpInEchoReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17191,4,'public','1.3.6.1.2.1.5.10.0',161,10007,'icmpInTimestamps','icmpInTimestamps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17192,4,'public','1.3.6.1.2.1.5.11.0',161,10007,'icmpInTimestampReps','icmpInTimestampReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17193,4,'public','1.3.6.1.2.1.5.12.0',161,10007,'icmpInAddrMasks','icmpInAddrMasks',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17194,4,'public','1.3.6.1.2.1.5.13.0',161,10007,'icmpInAddrMaskReps','icmpInAddrMaskReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17195,4,'public','1.3.6.1.2.1.5.14.0',161,10007,'icmpOutMsgs','icmpOutMsgs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17196,4,'public','1.3.6.1.2.1.5.15.0',161,10007,'icmpOutErrors','icmpOutErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17197,4,'public','1.3.6.1.2.1.5.16.0',161,10007,'icmpOutDesUnreachs','icmpOutDesUnreachs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17198,4,'public','1.3.6.1.2.1.5.17.0',161,10007,'icmpOutTimeExcds','icmpOutTimeExcds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17199,4,'public','1.3.6.1.2.1.5.18.0',161,10007,'icmpOutParmProbs','icmpOutParmProbs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17200,4,'public','1.3.6.1.2.1.5.19.0',161,10007,'icmpOutSrcQuenchs','icmpOutSrcQuenchs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17208,4,'public','1.3.6.1.2.1.5.20.0',161,10007,'icmpOutRedirects','icmpOutRedirects',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17202,4,'public','1.3.6.1.2.1.5.21.0',161,10007,'icmpOutEchos','icmpOutEchos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17203,4,'public','1.3.6.1.2.1.5.22.0',161,10007,'icmpOutEchoReps','icmpOutEchoReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17204,4,'public','1.3.6.1.2.1.5.23.0',161,10007,'icmpOutTimestamps','icmpOutTimestamps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17205,4,'public','1.3.6.1.2.1.5.24.0',161,10007,'icmpOutTimestampReps','icmpOutTimestampReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17206,4,'public','1.3.6.1.2.1.5.25.0',161,10007,'icmpOutAddrMasks','icmpOutAddrMasks',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);
INSERT INTO items VALUES (17207,4,'public','1.3.6.1.2.1.5.26.0',161,10007,'icmpOutAddrMaskReps','icmpOutAddrMaskReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0);

--
-- Dumping data for table `triggers`
--

INSERT INTO triggers VALUES (10001,'{10211}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10002,'{10213}<10000','Low free disk space on {HOSTNAME}\'s volume /','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10189,'{10219}<10000','Low free disk space on {HOSTNAME}\\\'s volume /tmp','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10004,'{10217}<10000','Low free disk space on {HOSTNAME}\'s volume /usr','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10005,'{10221}<10000','Low number of free inodes on {HOSTNAME}\'s volume /','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10006,'{10223}<10000','Low number of free inodes on {HOSTNAME}\'s volume /opt','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10007,'{10222}<10000','Low number of free inodes on {HOSTNAME}\'s volume /tmp','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10008,'{10224}<10000','Low number of free inodes on {HOSTNAME}\'s volume /usr','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10190,'{10233}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10010,'{10010}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10011,'{10234}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10012,'{10212}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10013,'{10013}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10014,'{10197}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','',0);
INSERT INTO triggers VALUES (10015,'{10201}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','',0);
INSERT INTO triggers VALUES (10016,'{10199}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10017,'{10214}<10000','Low free disk space on {HOSTNAME}\'s volume /home','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10018,'{10220}<10000','Low number of free inodes on {HOSTNAME}\' volume /home','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10019,'{10218}<10000','Low free disk space on {HOSTNAME}\'s volume /var','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10020,'{10215}<10000','Low free disk space on {HOSTNAME}\'s volume /opt','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10021,'{10196}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10022,'{10205}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10023,'{10206}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10024,'{10229}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10025,'{10232}=0','Telnet server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10026,'{10026}=0','WEB server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10027,'{10227}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10028,'{10209}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10029,'{10200}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10030,'{10030}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10031,'{10198}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10032,'{10226}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10033,'{10210}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10034,'{10202}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10035,'{10225}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10036,'{10231}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10037,'{10230}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10038,'{10237}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10039,'{10238}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
--INSERT INTO triggers VALUES (10040,'{10239}<1','Zabbix_trapperd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10041,'{10204}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10042,'{10203}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10043,'{10208}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10044,'{10207}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10045,'{10235}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10046,'{10236}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10047,'{10228}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10048,'{10048}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10049,'{10241}<10000','Low free disk space on {HOSTNAME}\'s volume c:','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10056,'{10056}>300','Too many processes on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10057,'{10057}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10058,'{10058}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10059,'{10059}<100000','Lack of free swap space on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10061,'{10240}>0','c:\\autoexec.bat has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10068,'{10068}<600','{HOSTNAME} has just been restarted','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10081,'{10081}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10091,'{10091}>0','Host information was changed on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10092,'{10243}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10094,'{10094}=2','Server {HOSTNAME} is unreachable','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10191,'{10242}<10000','Low free disk space on {HOSTNAME}\\\'s volume d:','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10163,'{10189}<1','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10164,'{10190}<1','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10165,'{10194}<1','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10168,'{10193}<1','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10169,'{10191}<1','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10173,'{10192}<1','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10187,'{10195}<1','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (12001,'{11001}=1','sysName on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12002,'{11002}=1','lenvSerialNumber on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12003,'{11003}>0','lmemBufferNoMem on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12004,'{11004}>75','lcpuPercentBusy on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12005,'{11005}=1','lenvFirmVersion on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12006,'{11006}>0','lmemBufferFail on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12007,'{11007}<10240','lmemFreeMem on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12008,'{11008}=1','lmemRomID on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12009,'{11009}=1','ifDescr1 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12010,'{11010}=1','ifDescr2 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12011,'{11011}=1','ifDescr3 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12012,'{11012}=1','ifDescr4 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12013,'{11013}=1','ifDescr5 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12014,'{11014}=1','ifDescr6 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12015,'{11015}=1','ifDescr7 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12016,'{11016}=1','ifDescr8 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12017,'{11017}=1','ifDescr9 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12018,'{11018}=1','ifDescr10 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12019,'{11019}=1','ifDescr11 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12020,'{11020}=1','ifDescr12 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12021,'{11021}=1','ifDescr13 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12022,'{11022}=1','ifDescr14 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12023,'{11023}=1','ifDescr15 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12024,'{11024}=1','ifDescr16 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12025,'{11025}=1','ifDescr17 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12026,'{11026}=1','ifDescr18 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12027,'{11027}=1','ifDescr19 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12028,'{11028}=1','ifDescr20 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12029,'{11029}=1','ifDescr21 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12030,'{11030}=1','ifDescr22 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12031,'{11031}=1','ifDescr23 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12032,'{11032}=1','ifDescr24 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12033,'{11033}=1','ifDescr25 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12034,'{11034}=1','ifDescr26 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12035,'{11035}=1','ifDescr27 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12036,'{11036}=1','ifDescr28 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12037,'{11037}=1','ifDescr29 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12038,'{11038}=1','ifDescr30 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12039,'{11039}=1','ifDescr31 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12040,'{11040}=1','ifDescr32 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12041,'{11041}=1','ifDescr33 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12042,'{11042}=1','ifDescr34 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12043,'{11043}=1','ifDescr35 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12044,'{11044}=1','ifDescr36 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12045,'{11045}=1','ifDescr37 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12046,'{11046}=1','ifDescr38 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12047,'{11047}=1','ifDescr39 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12048,'{11048}=1','ifDescr40 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12049,'{11049}=1','ifDescr41 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12050,'{11050}=1','ifDescr42 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12051,'{11051}=1','ifDescr43 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12052,'{11052}=1','ifDescr44 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12053,'{11053}=1','ifDescr45 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12054,'{11054}=1','ifDescr46 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12055,'{11055}=1','ifDescr47 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12056,'{11056}=1','ifDescr48 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12057,'{11057}=1','ifDescr49 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12058,'{11058}=1','ifDescr50 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12059,'{11059}=1','ifDescr51 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12060,'{11060}>150000','ifInOctets1 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12061,'{11061}>150000','ifInOctets2 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12062,'{11062}>150000','ifInOctets3 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12063,'{11063}>150000','ifInOctets4 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12064,'{11064}>150000','ifInOctets5 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12065,'{11065}>150000','ifInOctets6 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12066,'{11066}>150000','ifInOctets7 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12067,'{11067}>150000','ifInOctets8 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12068,'{11068}>150000','ifInOctets9 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12069,'{11069}>150000','ifInOctets10 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12070,'{11070}>150000','ifInOctets11 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12071,'{11071}>150000','ifInOctets12 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12072,'{11072}>150000','ifInOctets13 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12073,'{11073}>150000','ifInOctets14 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12074,'{11074}>150000','ifInOctets15 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12075,'{11075}>150000','ifInOctets16 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12076,'{11076}>150000','ifInOctets17 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12077,'{11077}>150000','ifInOctets18 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12078,'{11078}>150000','ifInOctets19 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12079,'{11079}>150000','ifInOctets20 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12080,'{11080}>150000','ifInOctets21 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12081,'{11081}>150000','ifInOctets22 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12082,'{11082}>150000','ifInOctets23 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12083,'{11083}>150000','ifInOctets24 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12084,'{11084}>150000','ifInOctets25 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12085,'{11085}>150000','ifInOctets26 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12086,'{11086}>150000','ifInOctets27 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12087,'{11087}>150000','ifInOctets28 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12088,'{11088}>150000','ifInOctets29 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12089,'{11089}>150000','ifInOctets30 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12090,'{11090}>150000','ifInOctets31 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12091,'{11091}>150000','ifInOctets32 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12092,'{11092}>150000','ifInOctets33 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12093,'{11093}>150000','ifInOctets34 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12094,'{11094}>150000','ifInOctets35 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12095,'{11095}>150000','ifInOctets36 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12096,'{11096}>150000','ifInOctets37 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12097,'{11097}>150000','ifInOctets38 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12098,'{11098}>150000','ifInOctets39 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12099,'{11099}>150000','ifInOctets40 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12100,'{11100}>150000','ifInOctets41 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12101,'{11101}>150000','ifInOctets42 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12102,'{11102}>150000','ifInOctets43 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12103,'{11103}>150000','ifInOctets44 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12104,'{11104}>150000','ifInOctets45 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12105,'{11105}>150000','ifInOctets46 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12106,'{11106}>150000','ifInOctets47 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12107,'{11107}>150000','ifInOctets48 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12108,'{11108}>150000','ifInOctets49 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12109,'{11109}>150000','ifInOctets50 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12110,'{11110}>150000','ifInOctets51 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12111,'{11111}>150000','ifOutOctets1 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12112,'{11112}>150000','ifOutOctets2 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12113,'{11113}>150000','ifOutOctets3 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12114,'{11114}>150000','ifOutOctets4 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12115,'{11115}>150000','ifOutOctets5 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12116,'{11116}>150000','ifOutOctets6 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12117,'{11117}>150000','ifOutOctets7 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12118,'{11118}>150000','ifOutOctets8 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12119,'{11119}>150000','ifOutOctets9 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12120,'{11120}>150000','ifOutOctets10 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12121,'{11121}>150000','ifOutOctets11 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12122,'{11122}>150000','ifOutOctets12 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12123,'{11123}>150000','ifOutOctets13 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12124,'{11124}>150000','ifOutOctets14 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12125,'{11125}>150000','ifOutOctets15 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12126,'{11126}>150000','ifOutOctets16 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12127,'{11127}>150000','ifOutOctets17 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12128,'{11128}>150000','ifOutOctets18 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12129,'{11129}>150000','ifOutOctets19 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12130,'{11130}>150000','ifOutOctets20 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12131,'{11131}>150000','ifOutOctets21 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12132,'{11132}>150000','ifOutOctets22 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12133,'{11133}>150000','ifOutOctets23 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12134,'{11134}>150000','ifOutOctets24 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12135,'{11135}>150000','ifOutOctets25 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12136,'{11136}>150000','ifOutOctets26 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12137,'{11137}>150000','ifOutOctets27 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12138,'{11138}>150000','ifOutOctets28 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12139,'{11139}>150000','ifOutOctets29 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12140,'{11140}>150000','ifOutOctets30 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12141,'{11141}>150000','ifOutOctets31 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12142,'{11142}>150000','ifOutOctets32 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12143,'{11143}>150000','ifOutOctets33 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12144,'{11144}>150000','ifOutOctets34 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12145,'{11145}>150000','ifOutOctets35 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12146,'{11146}>150000','ifOutOctets36 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12147,'{11147}>150000','ifOutOctets37 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12148,'{11148}>150000','ifOutOctets38 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12149,'{11149}>150000','ifOutOctets39 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12150,'{11150}>150000','ifOutOctets40 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12151,'{11151}>150000','ifOutOctets41 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12152,'{11152}>150000','ifOutOctets42 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12153,'{11153}>150000','ifOutOctets43 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12154,'{11154}>150000','ifOutOctets44 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12155,'{11155}>150000','ifOutOctets45 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12156,'{11156}>150000','ifOutOctets46 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12157,'{11157}>150000','ifOutOctets47 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12158,'{11158}>150000','ifOutOctets48 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12159,'{11159}>150000','ifOutOctets49 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12160,'{11160}>150000','ifOutOctets50 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12161,'{11161}>150000','ifOutOctets51 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12162,'{11162}=0','ipForwarding on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12163,'{11163}>255','ipDefaultTTL on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12164,'{11164}>150000','ipInReceives on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12165,'{11165}>0','ipInHdrErrors on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12166,'{11166}>0','ipInAddrErrors on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12167,'{11167}>150000','ipInForwDatagrams on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12168,'{11168}>0','ipInUnknownProtos on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12169,'{11169}>0','ipInDiscards on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12170,'{11170}>150000','ipInDelivers on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12171,'{11171}>150000','ipOutRequests on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12172,'{11172}>0','ipOutDiscards on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12173,'{11173}>0','ipOutNoRoutes on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12174,'{11174}>0','ipReasmTimeout on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12175,'{11175}>150000','ipReasmReqds on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12176,'{11176}>150000','ipReasmOKs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12177,'{11177}>0','ipReasmFails on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12178,'{11178}>150000','ipFragOKs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12179,'{11179}>0','ipFragFails on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12180,'{11180}>150000','ipFragCreates on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12181,'{11181}>0','ipRoutingDiscards on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12182,'{11182}>150000','icmpInMsgs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12183,'{11183}>0','icmpInErrors on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12184,'{11184}>0','icmpInDestUnreachs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12185,'{11185}>1000','icmpInTimeExcds on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12186,'{11186}>0','icmpInParmProbs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12187,'{11187}>0','icmpInSrcQuenchs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12188,'{11188}>150000','icmpInRedirects on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12189,'{11189}>100','icmpInEchos on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12190,'{11190}>100','icmpInEchoReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12191,'{11191}>100','icmpInTimestamps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12192,'{11192}>100','icmpInTimestampReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12193,'{11193}>100','icmpInAddrMasks on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12194,'{11194}>100','icmpInAddrMaskReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12195,'{11195}>150000','icmpOutMsgs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12196,'{11196}>0','icmpOutErrors on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12197,'{11197}>0','icmpOutDesUnreachs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12198,'{11198}>1000','icmpOutTimeExcds on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12199,'{11199}>0','icmpOutParmProbs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12200,'{11200}>0','icmpOutSrcQuenchs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12201,'{11201}>150000','icmpOutRedirects on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12202,'{11202}>100','icmpOutEchos on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12203,'{11203}>100','icmpOutEchoReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12204,'{11204}>100','icmpOutTimestamps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12205,'{11205}>100','icmpOutTimestampReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12206,'{11206}>100','icmpOutAddrMasks on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12207,'{11207}>100','icmpOutAddrMaskReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12208,'{11208}>1000','icmpOutRedirects on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);

--
-- Dumping data for table `functions`
--

INSERT INTO functions VALUES (10211,10001,10001,NULL,'last','0');
INSERT INTO functions VALUES (10213,10002,10002,NULL,'last','0');
INSERT INTO functions VALUES (10219,10003,10189,NULL,'last','0');
INSERT INTO functions VALUES (10217,10004,10004,NULL,'last','0');
INSERT INTO functions VALUES (10221,10005,10005,NULL,'last','0');
INSERT INTO functions VALUES (10223,10006,10006,NULL,'last','0');
INSERT INTO functions VALUES (10222,10007,10007,NULL,'last','0');
INSERT INTO functions VALUES (10224,10008,10008,NULL,'last','0');
INSERT INTO functions VALUES (10233,10009,10190,NULL,'last','0');
INSERT INTO functions VALUES (10010,10010,10010,NULL,'last','0');
INSERT INTO functions VALUES (10234,10013,10011,NULL,'last','0');
INSERT INTO functions VALUES (10212,10014,10012,NULL,'last','0');
INSERT INTO functions VALUES (10013,10016,10013,NULL,'last','0');
INSERT INTO functions VALUES (10197,10017,10014,NULL,'diff','0');
INSERT INTO functions VALUES (10201,10018,10015,NULL,'diff','0');
INSERT INTO functions VALUES (10199,10019,10016,NULL,'diff','0');
INSERT INTO functions VALUES (10214,10021,10017,NULL,'last','0');
INSERT INTO functions VALUES (10220,10022,10018,NULL,'last','0');
INSERT INTO functions VALUES (10218,10023,10019,NULL,'last','0');
INSERT INTO functions VALUES (10215,10024,10020,NULL,'last','0');
INSERT INTO functions VALUES (10196,10025,10021,NULL,'last','0');
INSERT INTO functions VALUES (10205,10031,10022,NULL,'last','0');
INSERT INTO functions VALUES (10206,10032,10023,NULL,'last','0');
INSERT INTO functions VALUES (10229,10033,10024,NULL,'last','0');
INSERT INTO functions VALUES (10232,10034,10025,NULL,'last','0');
INSERT INTO functions VALUES (10026,10035,10026,NULL,'last','0');
INSERT INTO functions VALUES (10227,10036,10027,NULL,'last','0');
INSERT INTO functions VALUES (10209,10037,10028,NULL,'last','0');
INSERT INTO functions VALUES (10200,10038,10029,NULL,'diff','0');
INSERT INTO functions VALUES (10030,10039,10030,NULL,'diff','0');
INSERT INTO functions VALUES (10198,10040,10031,NULL,'diff','0');
INSERT INTO functions VALUES (10226,10046,10032,NULL,'last','0');
INSERT INTO functions VALUES (10210,10047,10033,NULL,'last','0');
INSERT INTO functions VALUES (10202,10048,10034,NULL,'last','0');
INSERT INTO functions VALUES (10225,10049,10035,NULL,'last','0');
INSERT INTO functions VALUES (10231,10050,10036,NULL,'last','0');
INSERT INTO functions VALUES (10230,10051,10037,NULL,'last','0');
INSERT INTO functions VALUES (10237,10052,10038,NULL,'last','0');
INSERT INTO functions VALUES (10238,10053,10039,NULL,'last','0');
--INSERT INTO functions VALUES (10239,10054,10040,NULL,'last','0');
INSERT INTO functions VALUES (10204,10055,10041,NULL,'last','0');
INSERT INTO functions VALUES (10203,10056,10042,NULL,'last','0');
INSERT INTO functions VALUES (10208,10057,10043,NULL,'diff','0');
INSERT INTO functions VALUES (10207,10058,10044,NULL,'diff','0');
INSERT INTO functions VALUES (10235,10059,10045,NULL,'diff','0');
INSERT INTO functions VALUES (10236,10060,10046,NULL,'last','0');
INSERT INTO functions VALUES (10228,10061,10047,NULL,'last','0');
INSERT INTO functions VALUES (10048,10090,10048,NULL,'last','0');
INSERT INTO functions VALUES (10241,10091,10049,NULL,'last','0');
INSERT INTO functions VALUES (10056,10098,10056,NULL,'last','0');
INSERT INTO functions VALUES (10057,10099,10057,NULL,'last','0');
INSERT INTO functions VALUES (10058,10102,10058,NULL,'last','0');
INSERT INTO functions VALUES (10059,10103,10059,NULL,'last','0');
INSERT INTO functions VALUES (10240,10106,10061,NULL,'diff','0');
INSERT INTO functions VALUES (10242,10358,10191,NULL,'last','0');
INSERT INTO functions VALUES (10068,10114,10068,NULL,'last','0');
INSERT INTO functions VALUES (10081,10137,10081,NULL,'last','0');
INSERT INTO functions VALUES (10091,10147,10091,NULL,'diff','0');
INSERT INTO functions VALUES (10243,10148,10092,NULL,'diff','0');
INSERT INTO functions VALUES (10094,10150,10094,NULL,'last','0');
INSERT INTO functions VALUES (10189,10298,10163,NULL,'last','0');
INSERT INTO functions VALUES (10190,10299,10164,NULL,'last','0');
INSERT INTO functions VALUES (10194,10300,10165,NULL,'last','0');
INSERT INTO functions VALUES (10193,10303,10168,NULL,'last','0');
INSERT INTO functions VALUES (10191,10304,10169,NULL,'last','0');
INSERT INTO functions VALUES (10192,10313,10173,NULL,'last','0');
INSERT INTO functions VALUES (10195,10327,10187,NULL,'last','0');
INSERT INTO functions VALUES (11001,17001,12001,NULL,'diff','0');
INSERT INTO functions VALUES (11002,17002,12002,NULL,'diff','0');
INSERT INTO functions VALUES (11003,17003,12003,NULL,'delta','0');
INSERT INTO functions VALUES (11004,17004,12004,NULL,'delta','0');
INSERT INTO functions VALUES (11005,17005,12005,NULL,'diff','0');
INSERT INTO functions VALUES (11006,17006,12006,NULL,'delta','0');
INSERT INTO functions VALUES (11007,17007,12007,NULL,'delta','0');
INSERT INTO functions VALUES (11008,17008,12008,NULL,'diff','0');
INSERT INTO functions VALUES (11009,17009,12009,NULL,'diff','0');
INSERT INTO functions VALUES (11010,17010,12010,NULL,'diff','0');
INSERT INTO functions VALUES (11011,17011,12011,NULL,'diff','0');
INSERT INTO functions VALUES (11012,17012,12012,NULL,'diff','0');
INSERT INTO functions VALUES (11013,17013,12013,NULL,'diff','0');
INSERT INTO functions VALUES (11014,17014,12014,NULL,'diff','0');
INSERT INTO functions VALUES (11015,17015,12015,NULL,'diff','0');
INSERT INTO functions VALUES (11016,17016,12016,NULL,'diff','0');
INSERT INTO functions VALUES (11017,17017,12017,NULL,'diff','0');
INSERT INTO functions VALUES (11018,17018,12018,NULL,'diff','0');
INSERT INTO functions VALUES (11019,17019,12019,NULL,'diff','0');
INSERT INTO functions VALUES (11020,17020,12020,NULL,'diff','0');
INSERT INTO functions VALUES (11021,17021,12021,NULL,'diff','0');
INSERT INTO functions VALUES (11022,17022,12022,NULL,'diff','0');
INSERT INTO functions VALUES (11023,17023,12023,NULL,'diff','0');
INSERT INTO functions VALUES (11024,17024,12024,NULL,'diff','0');
INSERT INTO functions VALUES (11025,17025,12025,NULL,'diff','0');
INSERT INTO functions VALUES (11026,17026,12026,NULL,'diff','0');
INSERT INTO functions VALUES (11027,17027,12027,NULL,'diff','0');
INSERT INTO functions VALUES (11028,17028,12028,NULL,'diff','0');
INSERT INTO functions VALUES (11029,17029,12029,NULL,'diff','0');
INSERT INTO functions VALUES (11030,17030,12030,NULL,'diff','0');
INSERT INTO functions VALUES (11031,17031,12031,NULL,'diff','0');
INSERT INTO functions VALUES (11032,17032,12032,NULL,'diff','0');
INSERT INTO functions VALUES (11033,17033,12033,NULL,'diff','0');
INSERT INTO functions VALUES (11034,17034,12034,NULL,'diff','0');
INSERT INTO functions VALUES (11035,17035,12035,NULL,'diff','0');
INSERT INTO functions VALUES (11036,17036,12036,NULL,'diff','0');
INSERT INTO functions VALUES (11037,17037,12037,NULL,'diff','0');
INSERT INTO functions VALUES (11038,17038,12038,NULL,'diff','0');
INSERT INTO functions VALUES (11039,17039,12039,NULL,'diff','0');
INSERT INTO functions VALUES (11040,17040,12040,NULL,'diff','0');
INSERT INTO functions VALUES (11041,17041,12041,NULL,'diff','0');
INSERT INTO functions VALUES (11042,17042,12042,NULL,'diff','0');
INSERT INTO functions VALUES (11043,17043,12043,NULL,'diff','0');
INSERT INTO functions VALUES (11044,17044,12044,NULL,'diff','0');
INSERT INTO functions VALUES (11045,17045,12045,NULL,'diff','0');
INSERT INTO functions VALUES (11046,17046,12046,NULL,'diff','0');
INSERT INTO functions VALUES (11047,17047,12047,NULL,'diff','0');
INSERT INTO functions VALUES (11048,17048,12048,NULL,'diff','0');
INSERT INTO functions VALUES (11049,17049,12049,NULL,'diff','0');
INSERT INTO functions VALUES (11050,17050,12050,NULL,'diff','0');
INSERT INTO functions VALUES (11051,17051,12051,NULL,'diff','0');
INSERT INTO functions VALUES (11052,17052,12052,NULL,'diff','0');
INSERT INTO functions VALUES (11053,17053,12053,NULL,'diff','0');
INSERT INTO functions VALUES (11054,17054,12054,NULL,'diff','0');
INSERT INTO functions VALUES (11055,17055,12055,NULL,'diff','0');
INSERT INTO functions VALUES (11056,17056,12056,NULL,'diff','0');
INSERT INTO functions VALUES (11057,17057,12057,NULL,'diff','0');
INSERT INTO functions VALUES (11058,17058,12058,NULL,'diff','0');
INSERT INTO functions VALUES (11059,17059,12059,NULL,'diff','0');
INSERT INTO functions VALUES (11060,17060,12060,NULL,'delta','0');
INSERT INTO functions VALUES (11061,17061,12061,NULL,'delta','0');
INSERT INTO functions VALUES (11062,17062,12062,NULL,'delta','0');
INSERT INTO functions VALUES (11063,17063,12063,NULL,'delta','0');
INSERT INTO functions VALUES (11064,17064,12064,NULL,'delta','0');
INSERT INTO functions VALUES (11065,17065,12065,NULL,'delta','0');
INSERT INTO functions VALUES (11066,17066,12066,NULL,'delta','0');
INSERT INTO functions VALUES (11067,17067,12067,NULL,'delta','0');
INSERT INTO functions VALUES (11068,17068,12068,NULL,'delta','0');
INSERT INTO functions VALUES (11069,17069,12069,NULL,'delta','0');
INSERT INTO functions VALUES (11070,17070,12070,NULL,'delta','0');
INSERT INTO functions VALUES (11071,17071,12071,NULL,'delta','0');
INSERT INTO functions VALUES (11072,17072,12072,NULL,'delta','0');
INSERT INTO functions VALUES (11073,17073,12073,NULL,'delta','0');
INSERT INTO functions VALUES (11074,17074,12074,NULL,'delta','0');
INSERT INTO functions VALUES (11075,17075,12075,NULL,'delta','0');
INSERT INTO functions VALUES (11076,17076,12076,NULL,'delta','0');
INSERT INTO functions VALUES (11077,17077,12077,NULL,'delta','0');
INSERT INTO functions VALUES (11078,17078,12078,NULL,'delta','0');
INSERT INTO functions VALUES (11079,17079,12079,NULL,'delta','0');
INSERT INTO functions VALUES (11080,17080,12080,NULL,'delta','0');
INSERT INTO functions VALUES (11081,17081,12081,NULL,'delta','0');
INSERT INTO functions VALUES (11082,17082,12082,NULL,'delta','0');
INSERT INTO functions VALUES (11083,17083,12083,NULL,'delta','0');
INSERT INTO functions VALUES (11084,17084,12084,NULL,'delta','0');
INSERT INTO functions VALUES (11085,17085,12085,NULL,'delta','0');
INSERT INTO functions VALUES (11086,17086,12086,NULL,'delta','0');
INSERT INTO functions VALUES (11087,17087,12087,NULL,'delta','0');
INSERT INTO functions VALUES (11088,17088,12088,NULL,'delta','0');
INSERT INTO functions VALUES (11089,17089,12089,NULL,'delta','0');
INSERT INTO functions VALUES (11090,17090,12090,NULL,'delta','0');
INSERT INTO functions VALUES (11091,17091,12091,NULL,'delta','0');
INSERT INTO functions VALUES (11092,17092,12092,NULL,'delta','0');
INSERT INTO functions VALUES (11093,17093,12093,NULL,'delta','0');
INSERT INTO functions VALUES (11094,17094,12094,NULL,'delta','0');
INSERT INTO functions VALUES (11095,17095,12095,NULL,'delta','0');
INSERT INTO functions VALUES (11096,17096,12096,NULL,'delta','0');
INSERT INTO functions VALUES (11097,17097,12097,NULL,'delta','0');
INSERT INTO functions VALUES (11098,17098,12098,NULL,'delta','0');
INSERT INTO functions VALUES (11099,17099,12099,NULL,'delta','0');
INSERT INTO functions VALUES (11100,17100,12100,NULL,'delta','0');
INSERT INTO functions VALUES (11101,17101,12101,NULL,'delta','0');
INSERT INTO functions VALUES (11102,17102,12102,NULL,'delta','0');
INSERT INTO functions VALUES (11103,17103,12103,NULL,'delta','0');
INSERT INTO functions VALUES (11104,17104,12104,NULL,'delta','0');
INSERT INTO functions VALUES (11105,17105,12105,NULL,'delta','0');
INSERT INTO functions VALUES (11106,17106,12106,NULL,'delta','0');
INSERT INTO functions VALUES (11107,17107,12107,NULL,'delta','0');
INSERT INTO functions VALUES (11108,17108,12108,NULL,'delta','0');
INSERT INTO functions VALUES (11109,17109,12109,NULL,'delta','0');
INSERT INTO functions VALUES (11110,17110,12110,NULL,'delta','0');
INSERT INTO functions VALUES (11111,17111,12111,NULL,'delta','0');
INSERT INTO functions VALUES (11112,17112,12112,NULL,'delta','0');
INSERT INTO functions VALUES (11113,17113,12113,NULL,'delta','0');
INSERT INTO functions VALUES (11114,17114,12114,NULL,'delta','0');
INSERT INTO functions VALUES (11115,17115,12115,NULL,'delta','0');
INSERT INTO functions VALUES (11116,17116,12116,NULL,'delta','0');
INSERT INTO functions VALUES (11117,17117,12117,NULL,'delta','0');
INSERT INTO functions VALUES (11118,17118,12118,NULL,'delta','0');
INSERT INTO functions VALUES (11119,17119,12119,NULL,'delta','0');
INSERT INTO functions VALUES (11120,17120,12120,NULL,'delta','0');
INSERT INTO functions VALUES (11121,17121,12121,NULL,'delta','0');
INSERT INTO functions VALUES (11122,17122,12122,NULL,'delta','0');
INSERT INTO functions VALUES (11123,17123,12123,NULL,'delta','0');
INSERT INTO functions VALUES (11124,17124,12124,NULL,'delta','0');
INSERT INTO functions VALUES (11125,17125,12125,NULL,'delta','0');
INSERT INTO functions VALUES (11126,17126,12126,NULL,'delta','0');
INSERT INTO functions VALUES (11127,17127,12127,NULL,'delta','0');
INSERT INTO functions VALUES (11128,17128,12128,NULL,'delta','0');
INSERT INTO functions VALUES (11129,17129,12129,NULL,'delta','0');
INSERT INTO functions VALUES (11130,17130,12130,NULL,'delta','0');
INSERT INTO functions VALUES (11131,17131,12131,NULL,'delta','0');
INSERT INTO functions VALUES (11132,17132,12132,NULL,'delta','0');
INSERT INTO functions VALUES (11133,17133,12133,NULL,'delta','0');
INSERT INTO functions VALUES (11134,17134,12134,NULL,'delta','0');
INSERT INTO functions VALUES (11135,17135,12135,NULL,'delta','0');
INSERT INTO functions VALUES (11136,17136,12136,NULL,'delta','0');
INSERT INTO functions VALUES (11137,17137,12137,NULL,'delta','0');
INSERT INTO functions VALUES (11138,17138,12138,NULL,'delta','0');
INSERT INTO functions VALUES (11139,17139,12139,NULL,'delta','0');
INSERT INTO functions VALUES (11140,17140,12140,NULL,'delta','0');
INSERT INTO functions VALUES (11141,17141,12141,NULL,'delta','0');
INSERT INTO functions VALUES (11142,17142,12142,NULL,'delta','0');
INSERT INTO functions VALUES (11143,17143,12143,NULL,'delta','0');
INSERT INTO functions VALUES (11144,17144,12144,NULL,'delta','0');
INSERT INTO functions VALUES (11145,17145,12145,NULL,'delta','0');
INSERT INTO functions VALUES (11146,17146,12146,NULL,'delta','0');
INSERT INTO functions VALUES (11147,17147,12147,NULL,'delta','0');
INSERT INTO functions VALUES (11148,17148,12148,NULL,'delta','0');
INSERT INTO functions VALUES (11149,17149,12149,NULL,'delta','0');
INSERT INTO functions VALUES (11150,17150,12150,NULL,'delta','0');
INSERT INTO functions VALUES (11151,17151,12151,NULL,'delta','0');
INSERT INTO functions VALUES (11152,17152,12152,NULL,'delta','0');
INSERT INTO functions VALUES (11153,17153,12153,NULL,'delta','0');
INSERT INTO functions VALUES (11154,17154,12154,NULL,'delta','0');
INSERT INTO functions VALUES (11155,17155,12155,NULL,'delta','0');
INSERT INTO functions VALUES (11156,17156,12156,NULL,'delta','0');
INSERT INTO functions VALUES (11157,17157,12157,NULL,'delta','0');
INSERT INTO functions VALUES (11158,17158,12158,NULL,'delta','0');
INSERT INTO functions VALUES (11159,17159,12159,NULL,'delta','0');
INSERT INTO functions VALUES (11160,17160,12160,NULL,'delta','0');
INSERT INTO functions VALUES (11161,17161,12161,NULL,'delta','0');
INSERT INTO functions VALUES (11162,17162,12162,NULL,'last','0');
INSERT INTO functions VALUES (11163,17163,12163,NULL,'last','0');
INSERT INTO functions VALUES (11164,17164,12164,NULL,'delta','0');
INSERT INTO functions VALUES (11165,17165,12165,NULL,'delta','0');
INSERT INTO functions VALUES (11166,17166,12166,NULL,'delta','0');
INSERT INTO functions VALUES (11167,17167,12167,NULL,'delta','0');
INSERT INTO functions VALUES (11168,17168,12168,NULL,'delta','0');
INSERT INTO functions VALUES (11169,17169,12169,NULL,'delta','0');
INSERT INTO functions VALUES (11170,17170,12170,NULL,'delta','0');
INSERT INTO functions VALUES (11171,17171,12171,NULL,'delta','0');
INSERT INTO functions VALUES (11172,17172,12172,NULL,'delta','0');
INSERT INTO functions VALUES (11173,17173,12173,NULL,'delta','0');
INSERT INTO functions VALUES (11174,17174,12174,NULL,'delta','0');
INSERT INTO functions VALUES (11175,17175,12175,NULL,'delta','0');
INSERT INTO functions VALUES (11176,17176,12176,NULL,'delta','0');
INSERT INTO functions VALUES (11177,17177,12177,NULL,'delta','0');
INSERT INTO functions VALUES (11178,17178,12178,NULL,'delta','0');
INSERT INTO functions VALUES (11179,17179,12179,NULL,'delta','0');
INSERT INTO functions VALUES (11180,17180,12180,NULL,'delta','0');
INSERT INTO functions VALUES (11181,17181,12181,NULL,'delta','0');
INSERT INTO functions VALUES (11182,17182,12182,NULL,'delta','0');
INSERT INTO functions VALUES (11183,17183,12183,NULL,'delta','0');
INSERT INTO functions VALUES (11184,17184,12184,NULL,'delta','0');
INSERT INTO functions VALUES (11185,17185,12185,NULL,'delta','0');
INSERT INTO functions VALUES (11186,17186,12186,NULL,'delta','0');
INSERT INTO functions VALUES (11187,17187,12187,NULL,'delta','0');
INSERT INTO functions VALUES (11188,17188,12188,NULL,'delta','0');
INSERT INTO functions VALUES (11189,17189,12189,NULL,'delta','0');
INSERT INTO functions VALUES (11190,17190,12190,NULL,'delta','0');
INSERT INTO functions VALUES (11191,17191,12191,NULL,'delta','0');
INSERT INTO functions VALUES (11192,17192,12192,NULL,'delta','0');
INSERT INTO functions VALUES (11193,17193,12193,NULL,'delta','0');
INSERT INTO functions VALUES (11194,17194,12194,NULL,'delta','0');
INSERT INTO functions VALUES (11195,17195,12195,NULL,'delta','0');
INSERT INTO functions VALUES (11196,17196,12196,NULL,'delta','0');
INSERT INTO functions VALUES (11197,17197,12197,NULL,'delta','0');
INSERT INTO functions VALUES (11198,17198,12198,NULL,'delta','0');
INSERT INTO functions VALUES (11199,17199,12199,NULL,'delta','0');
INSERT INTO functions VALUES (11200,17200,12200,NULL,'delta','0');
INSERT INTO functions VALUES (11201,17201,12201,NULL,'delta','0');
INSERT INTO functions VALUES (11202,17202,12202,NULL,'delta','0');
INSERT INTO functions VALUES (11203,17203,12203,NULL,'delta','0');
INSERT INTO functions VALUES (11204,17204,12204,NULL,'delta','0');
INSERT INTO functions VALUES (11205,17205,12205,NULL,'delta','0');
INSERT INTO functions VALUES (11206,17206,12206,NULL,'delta','0');
INSERT INTO functions VALUES (11207,17207,12207,NULL,'delta','0');
INSERT INTO functions VALUES (11208,17208,12208,NULL,'delta','0');
