#!/usr/local/bin/perl
#
# postfix-module by Guillaume Cottenceau <gc@mandrakesoft.com>,
# for webmin by Jamie Cameron
#
# Copyright (c) 2000 by Mandrakesoft
#
# Permission to use, copy, modify, and distribute this software and its
# documentation under the terms of the GNU General Public License is hereby 
# granted. No representations are made about the suitability of this software 
# for any purpose. It is provided "as is" without express or implied warranty.
# See the GNU General Public License for more details.
#
# 
# Manages aliases for Postfix
#
# << Here are all options seen in Postfix sample-aliases.cf >>


require './postfix-lib.pl';

$access{'aliases'} || &error($text{'aliases_ecannot'});
&header($text{'aliases_title'}, "", "aliases");

print "<hr>\n";


# alias general options

print "<form action=save_opts_aliases.cgi>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'aliasopts_title'}</b></td></tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr>\n";
&option_freefield("alias_maps", 60);
print "</tr>\n";

print "<tr>\n";
&option_freefield("alias_database", 60);
print "</tr>\n";

print "</table></td></tr></table><p>\n";
print "$text{'aliases_warning'}<p><br>\n";
print "<input type=submit value=\"$text{'opts_save'}\"></form>\n";
print "<hr>\n";
print "<br>\n";




# double-table displaying all aliases

my $aliases = &get_aliases();

print $text{'aliases_click'}, "\n<br>\n";
print "<table width=100%> <tr><td width=50% valign=top>\n";

print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'aliases_name'}</b></td> ",
      "<td><b>$text{'aliases_value'}</b></td> </tr>\n";

my $split_index = int(($#{$aliases})/2);
my $i = -1;

foreach $alias (@{$aliases})
{
    print "<tr $cb>\n";
    print "<td><a href=\"edit_alias.cgi?num=$alias->{'number'}\">$alias->{'name'}</a></td>\n";
    print "<td>$alias->{'value'}</td>\n</tr>\n";
    $i++;
    if ($i == $split_index)
    {
	print "</table></td><td width=50% valign=top>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'aliases_name'}</b></td> ",
	"<td><b>$text{'aliases_value'}</b></td> </tr>\n";
    }
}

print "</tr></td></table>\n";
print "</table>\n";


# new alias form

print "<table cellpadding=5 width=100%><tr><td>\n";
print "<form action=edit_alias.cgi>\n";
print "<input type=submit value=\"$text{'new_alias'}\">\n";
print "</td> <td width=\"99%\">$text{'new_aliasmsg'}\n";
print "</td></tr></table></form>\n";


print "<hr>\n";
&footer("", $text{'index_return'});
