/* $Id: w3mimgsize.c,v 1.1.4.5 2002/03/31 13:36:20 suto Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <Imlib.h>

void
print_imgsize(ImlibData *id, char *fn)
{
  ImlibImage *im;

  if ((im = Imlib_load_image(id, fn)))
    printf("%d %d\n", im->rgb_width, im->rgb_height);
  else
    putchar('\n');

  fflush(stdout);
  Imlib_kill_image(id, im);
}

#ifndef PATH_MAX
#define PATH_MAX (256)
#endif

int
main(int argc, char **argv)
{
  Display *display;
  ImlibData *id;

  if (!(display = XOpenDisplay(NULL))) {
    fprintf(stderr, "XOpenDisplay(NULL): %s\n", strerror(errno));
    exit(1);
  }

  if (!(id = Imlib_init(display)))
    exit(1);

  if (argc < 2) {
    char *path;
    int path_size, len;

    if (!(path = malloc(PATH_MAX)))
      exit(1);

    path_size = PATH_MAX;
    len = 0;

    while (fgets(&path[len], path_size - len, stdin)) {
      len += strlen(&path[len]);

      if (len && path[len - 1] == '\n') {
	path[len - 1] = '\0';
	print_imgsize(id, path);
	len = 0;
      }
      else if (path_size - len < sizeof("\n")) {
	path_size = (path_size / 2 + 1) * 3;

	if (!(path = realloc(path, path_size))) {
	  fprintf(stderr, "realloc(path, %d): %s\n", path_size, strerror(errno));
	  exit(1);
	}
      }
    }

    if (len)
      print_imgsize(id, path);

    exit(ferror(stdin));
  }

  print_imgsize(id, argv[1]);
  exit(0);
}
