/* 
 * w3m menu.h
 */

#ifndef MENU_H
#define MENU_H

#define MENU_END    0
#define MENU_NOP    1
#define MENU_VALUE  2
#define MENU_FUNC   4
#define MENU_POPUP  8
#define MENU_MFUNC 16

#define MENU_NOTHING -1
#define MENU_CANCEL  -2
#define MENU_CLOSE   -3

typedef struct _MenuItem {
    int type;
    char *label;
    int *variable;
    int value;
    void (*func)(void);
    struct _Menu *popup;
    char *keys;
    char *data;
} MenuItem;

typedef struct _Menu {
    struct _Menu *parent;
    short cursorX;
    short cursorY;
    short x;
    short y;
    short width;
    short height;
    int nitem;
    MenuItem *item;
    int initial;
    int select;
    int offset;
    int active;
    struct _KeyTabList *keymap, *keyselect;
} Menu;

typedef struct _MenuList {
    char *id;
    Menu *menu;
    MenuItem *item;
} MenuList;

#ifdef KANJI_SYMBOLS
#ifdef HAVE_MOE
extern int FRAME_WIDTH;
#else
#define FRAME_WIDTH 2
#endif
#else				/* not KANJI_SYMBOLS */
#define FRAME_WIDTH 1
#endif				/* not KANJI_SYMBOLS */

#endif				/* not MENU_H */
