#!/usr/local/bin/perl
# save_comp.cgi
# Create, modify or delete a composite folder

require './mailbox-lib.pl';
&ReadParse();
@folders = &list_folders();
$folder = $folders[$in{'idx'}] if (!$in{'new'});
&error_setup($text{'save_err'});

if ($in{'delete'}) {
	# Just delete this folder file
	unlink("$user_module_config_directory/$folder->{'id'}.comp");
	}
else {
	# Validate inputs
	$in{'name'} =~ /\S/ || &error($text{'save_ename'});
	for($i=0; defined($n = $in{"comp_$i"}); $i++) {
		push(@names, $n) if ($n);
		}
	$in{'perpage_def'} || $in{'perpage'} =~ /^\d+$/ ||
		&error($text{'save_eperpage'});
	$in{'fromaddr_def'} || $in{'fromaddr'} =~ /\S/ ||
		&error($text{'save_efromaddr'});

	# Save the folder
	$comp{'id'} = $folder->{'id'} || time();
	$comp{'name'} = $in{'name'};
	$comp{'subfoldernames'} = join("\t", @names);
	$comp{'perpage'} = $in{'perpage_def'} ? undef : $in{'perpage'};
	$comp{'fromaddr'} = $in{'fromaddr_def'} ? undef : $in{'fromaddr'};
	$comp{'sent'} = $in{'sent'};
	&write_file("$user_module_config_directory/$comp{'id'}.comp", \%comp);
	chmod(0700, "$user_module_config_directory/$comp{'id'}.comp");
	}
&redirect("list_folders.cgi");

