#
# zh/00default.rb: Traditional-Chinese resources of 00default.rb.
#

#
# header
#
def title_tag
	r = "<title>#{CGI::escapeHTML( @html_title )}"
	case @mode
	when 'day', 'comment'
		r << "(#{@date.strftime( '%Y-%m-%d' )})" if @date
	when 'month'
		r << "(#{@date.strftime( '%Y-%m' )})" if @date
	when 'form'
		r << '(Append)'
	when 'edit'
		r << '(Edit)'
	when 'preview'
		r << '(Preview)'
	when 'showcomment'
		r << '(TSUKKOMI Status Change Completed)'
	when 'conf'
		r << '(Preferences)'
	when 'saveconf'
		r << '(Preferences Changed)'
	when 'nyear'
		years = @diaries.keys.map {|ymd| ymd.sub(/^\d{4}/, "")}
		r << "(#{years[0].sub( /^(\d\d)/, '\1-')}[#{nyear_diary_label @date, years}])" if @date
	end
	r << '</title>'
end


#
# labels
#
def no_diary; "#{@date.strftime( @conf.date_format )} oѨSox"; end
def comment_today; "jT"; end
def comment_total( total ); "(`@: #{total} h)"; end
def comment_new; 'ojT'; end
def comment_description; 'woz糧媺jTAzg email }uxDHiHݨC'; end
def comment_description_short; 'ojT!!'; end
def comment_name_label; 'mW'; end
def comment_name_label_short; 'mW'; end
def comment_mail_label; 'qll'; end
def comment_mail_label_short; 'l'; end
def comment_body_label; 'jT'; end
def comment_body_label_short; 'jT'; end
def comment_submit_label; 'o'; end
def comment_submit_label_short; 'o'; end
def comment_date( time ); time.strftime( "(#{@date_format} %H:%M)" ); end
def referer_today; "嵲"; end
def trackback_today; "ޥ"; end
def trackback_total( total ); "(`@: #{total} h)"; end

def navi_index; ''; end
def navi_latest; '̷sx'; end
def navi_oldest; '¤x'; end
def navi_update; "sW"; end
def navi_edit; "s"; end
def navi_preference; "ﶵ]w"; end
def navi_prev_diary(date); "e@hx (#{date.strftime(@date_format)})"; end
def navi_next_diary(date); "U@hx (#{date.strftime(@date_format)})"; end
def navi_prev_nyear(date); "h~x (#{date.strftime('%m-%d')})"; end
def navi_next_nyear(date); "~x (#{date.strftime('%m-%d')})"; end

def submit_label
	if @mode == 'form' or @cgi.valid?( 'appendpreview' ) then
		'sW' #'Append'
	else
		'' #'Replace'
	end
end
def preview_label; 'w'; end #'Preview'

def label_no_referer; "oOѥCX嵲C"; end
def label_referer_table; "Today's Link Conversion Rule"; end

def nyear_diary_label(date, years); "鱡h"; end
def nyear_diary_title(date, years); "Lhɦ"; end


#
# labels (for mobile)
#
def mobile_navi_latest; 'Latest'; end
def mobile_navi_update; 'Update'; end
def mobile_navi_preference; 'Prefs'; end
def mobile_navi_prev_diary; 'Prev'; end
def mobile_navi_next_diary; 'Next'; end
def mobile_label_hidden_diary; 'This day is HIDDEN.'; end

#
# category
#
def category_anchor(c); "[#{c}]"; end

#
# preferences
#

# basic (default)
add_conf_proc( 'default', '򥻳]w' ) do
	saveconf_default
	<<-HTML
	<h3 class="subtitle">@</h3>
	#{"<p>WzjWaI쪺ȱN|Φb HTML Y(header)̡C</p>" unless @conf.mobile_agent?}
	<p><input name="author_name" value="#{CGI::escapeHTML @conf.author_name}" size="40"></p>
	<h3 class="subtitle">qll</h3>
	#{"<p>Jzqll}A쪺ȱNΦb HTML Y(header)̡C</p>" unless @conf.mobile_agent?}
	<p><input name="author_mail" value="#{@conf.author_mail}" size="40"></p>
	<h3 class="subtitle">z޺() URL</h3>
	#{"<p>Yzۤv}AiHbUC</p>" unless @conf.mobile_agent?}
	<p><input name="index_page" value="#{@conf.index_page}" size="50"></p>
	<h3 class="subtitle">ɶtվ</h3>
	#{"<p>YOzsFxAziHzL(쬰p)Ӱ۰ʽվɶtCҦpAzYQnwbMIҵoxQOQѪxAzNiHbo̶J -2CtDiary |ѦҦƭȨӧPwogxoC </p>" unless @conf.mobile_agent?}
	<p><input name="hour_offset" value="#{@conf.hour_offset}" size="5"></p>
	HTML
end

# header/footer (header)
add_conf_proc( 'header', 'ܻP}' ) do
	saveconf_header

	<<-HTML
	<h3 class="subtitle">jD</h3>
	#{"<p>oOzxjDAzJȷ|Φb HTML  &lt;title&gt; طCSO`NAФŨϥ HTML (tags)C </p>" unless @conf.mobile_agent?}
	<p><input name="html_title" value="#{ CGI::escapeHTML @conf.html_title }" size="50"></p>
	<h3 class="subtitle"></h3>
	#{"<p>oqrN|\mbCӭݡAziHϥ HTML ykCOФŲ \"&lt;%=navi%&gt;\"ҡA]N]t\"s\"(Update)\\sbuCvA \"&lt;%=calendar%&gt;\" ҥNCBz]iHۥѷft䥦 pluginC </p>" unless @conf.mobile_agent?}
	<p><textarea name="header" cols="70" rows="10">#{ CGI::escapeHTML @conf.header }</textarea></p>
	<h3 class="subtitle">}</h3>
	#{"<p>oqrFmOm󩳺ݥH~AlpPܡC </p>" unless @conf.mobile_agent?}
	<p><textarea name="footer" cols="70" rows="10">#{ CGI::escapeHTML @conf.footer }</textarea></p>
	HTML
end

# diaplay
add_conf_proc( 'display', '' ) do
	saveconf_display

	<<-HTML
	<h3 class="subtitle">qI(anchor)NO</h3>
	#{"<p>\"I\" Nqb䥦iHPzx۳sCqI|QmCӬq}YBAziHw \"&lt;span class=\"sanchor\"&gt;_&lt;/span&gt;\"AӹϧΤILA|ѧGDD]pӨMwC </p>" unless @conf.mobile_agent?}
	<p><input name="section_anchor" value="#{ CGI::escapeHTML @conf.section_anchor }" size="40"></p>
	<h3 class="subtitle">jTI(anchor)NO</h3>
	#{"<p>jTI|mChjT}YBAziHw \"&lt;span class=\"canchor\"&gt;_&lt;/span&gt;\"C</p>" unless @conf.mobile_agent?}
	<p><input name="comment_anchor" value="#{ CGI::escapeHTML @conf.comment_anchor }" size="40"></p>
	<h3 class="subtitle">榡</h3>
	#{"<p>榡A@zwUCo % ŸftrAզXNiN榡Ap \"%Y\"(~), \"%m\"()\"%b\"(²uܪk), \"%B\"(ܪk), \"%d\"(), \"%a\"(P²uܪk), \"%A\"(Pܪk)C</p>" unless @conf.mobile_agent?}
	<p><input name="date_format" value="#{ CGI::escapeHTML @conf.date_format }" size="30"></p>
	<h3 class="subtitle">u̷sxv̦hnqXXѥH</h3>
	#{"<p>bu̷sxvAznܦh֤ѥxH </p>" unless @conf.mobile_agent?}
	<p><input name="latest_limit" value="#{@conf.latest_limit}" size="2"> ѥ</p>
	<h3 class="subtitle">鱡h</h4>
	#{"<p>O_nqX \"鱡h\" (PP骺Lhx)H</p>" unless @conf.mobile_agent?}
	<p><select name="show_nyear">
		<option value="true"#{if @conf.show_nyear then " selected" end}>qI</option>
        <option value="false"#{if not @conf.show_nyear then " selected" end}></option>
	</select></p>
	HTML
end

# themes
@theme_location_comment = "<p>ziHb <a href=\"http://www.tdiary.org/20021001.html\">Theme Gallery</a>(饻y) ohGDDI</p>"

add_conf_proc( 'theme', 'GDD' ) do
	saveconf_theme

	 r = <<-HTML
	<h3 class="subtitle">GDD</h3>
	#{"<p>ܱzxQnGDDμ˦(CSS)ApGzܤF \"CSS specify\"AЦbk(U)̿J CSS Ҧb}C </p>" unless @conf.mobile_agent?}
	<p>
	<select name="theme">
		<option value="">CSS Specify-&gt;</option>
	HTML
	@conf_theme_list.each do |theme|
		r << %Q|<option value="#{theme[0]}"#{if theme[0] == @conf.theme then " selected" end}>#{theme[1]}</option>|
	end
	r << <<-HTML
	</select>
	<input name="css" size="50" value="#{ @conf.css }">
	</p>
	#{@theme_location_comment unless @conf.mobile_agent?}
	HTML
end

# comments
add_conf_proc( 'comment', 'jT' ) do
	saveconf_comment

	<<-HTML
	<h3 class="subtitle">O_nqXjTH</h3>
	#{"<p>nnqXṶ̵̄zjTH </p>" unless @conf.mobile_agent?}
	<p><select name="show_comment">
		<option value="true"#{if @conf.show_comment then " selected" end}>n</option>
		<option value="false"#{if not @conf.show_comment then " selected" end}>n</option>
	</select></p>
	<h3 class="subtitle">nqXXgjTH</h3>
	#{"<p>bu̷sxvΡuYxvҥܤUAzQnqXhֽgijTH ۹ӻAbugvҥܤUAҦjT|qXӡC </p>" unless @conf.mobile_agent?}
	<p>qX <input name="comment_limit" value="#{ @conf.comment_limit }" size="3"> gjT</p>
	HTML
end

# referer
add_conf_proc( 'referer', "嵲" ) do
	saveconf_referer

	<<-HTML
	<h3 class="subtitle">O_qX嵲</h3>
	#{"<p>ziHܬO_nqXu嵲vC </p>" unless @conf.mobile_agent?}
	<p><select name="show_referer">
		<option value="true"#{if @conf.show_referer then " selected" end}>n</option>
		<option value="false"#{if not @conf.show_referer then " selected" end}>n</option>
	</select></p>
	<h3 class="subtitle">nqXh嵲</h3>
	#{"<p>bu̷sxvΡuYxvҥܤUAzQnqXh֭ӥi嵲H ۹ӻAbugvҥܤUAҦ嵲jT|qXӡC </p>" unless @conf.mobile_agent?}
	<p>qX <input name="referer_limit" value="#{@conf.referer_limit}" size="3"> 嵲</p>
	<h3 class="subtitle">嵲OsҦ</h3>
	#{"<p>ܦbgҥܤ嵲OsҦAoӿﶵγBb֡uLΪѷӡvC </p>" unless @conf.mobile_agent?}
	<p><select name="referer_day_only">
		<option value="true"#{if @conf.referer_day_only then " selected" end}>uNgҥܤ嵲s_</option>
		<option value="false"#{if not @conf.referer_day_only then " selected" end}>NҦi嵲s_</option>
	</select></p>
	<h3 class="subtitle">uCJ嵲vC</h3>
	#{"<p>bu嵲v̤nO_Ӫ嵲CХH regular expression Φ@@wCӤQO}C </p>" unless @conf.mobile_agent?}
	<p>Ь<a href="#{@conf.update}?referer=no" target="referer">w]]w</a>C</p>
	<p><textarea name="no_referer" cols="70" rows="10">#{@conf.no_referer2.join( "\n" )}</textarea></p>
	<h3 class="subtitle">}rഫWh</h3>
	#{"<p>Nu嵲vSw}ഫNqrAХH regular expression Φ@@wCӭnrഫ}C <p>" unless @conf.mobile_agent?}
	<p>Ь<a href="#{@conf.update}?referer=table" target="referer">w]]w</a>.</p>
	<p><textarea name="referer_table" cols="70" rows="10">#{@conf.referer_table2.collect{|a|a.join( " " )}.join( "\n" )}</textarea></p>
	HTML
end

# comment mail
def comment_mail_mime( str )
	[str.dup]
end

def comment_mail_conf_label; 'HHqzjT'; end

def comment_mail_basic_html
	@conf['comment_mail.header'] = '' unless @conf['comment_mail.header']
	@conf['comment_mail.receivers'] = '' unless @conf['comment_mail.receivers']

	<<-HTML
	<h3 class="subtitle">O_QΫHqjTH</h3>
	#{"<p>пܦbsjTɭnnHqllqzCаOoo\\ݭnzb tdiary.conf ]w SMTP AC</p>" unless @conf.mobile_agent?}
	<p><select name="comment_mail.enable">
		<option value="true"#{if @conf['comment_mail.enable'] then " selected" end}>Хζlq</option>
        <option value="false"#{if not @conf['comment_mail.enable'] then " selected" end}>ΤF</option>
	</select></p>
	<h3 class="subtitle">}</h3>
	#{"<p>ЫwnjTqqll}A@g@Ӧ}CpGǫSt~wAhqHN|Hzqll}C</p>" unless @conf.mobile_agent?}
	<p><textarea name="comment_mail.receivers" cols="40" rows="3">#{CGI::escapeHTML( @conf['comment_mail.receivers'].gsub( /[, ]+/, "\n") )}</textarea></p>
	<h3 class="subtitle">HD</h3>
	#{"<p>w@ӷ|\bqHuHDv}YBrCHD|O \"zwr:DATE-SERIAL NAME\" ˦C \"date\" OzxoAOpGztwF˦ADh|ܬ \"zwr-SERIAL NAME\" (ex: \"hoge:%Y-%m-%d\")</p>" unless @conf.mobile_agent?}
	<p><input name="comment_mail.header" value="#{CGI::escapeHTML( @conf['comment_mail.header'])}"></p>
	HTML
end

#
# link to HOWTO write diary
#
def style_howto
	%Q|/<a href="http://docs.tdiary.org/en/?#{@conf.style}Style">g</a>|
end
