#ifndef	_PPXP_FRAME_H
#define	_PPXP_FRAME_H

#include <osdep.h>

typedef	int8_t	priority_t;

extern char *TostrProto();
extern void FrameDump();
extern int FrameRead(u_char *, int, u_int16_t);
extern int FrameEnqueue(u_char *, int, u_int16_t, priority_t);
extern int FrameEnable(u_int16_t, int);
extern void RebuildQueue(u_int16_t);
extern int SysIfWrite();
extern int FrameReject(u_int16_t, int);
extern void FrameResetReject();

#ifdef	_LIB_XCIO_H
static inline int
IfWrite(u_char *buf, int len, long hbo_proto)
{
    pppInfo.r.nsize += len;
    return(SysIfWrite(buf, len, hbo_proto));
}
#endif

#define	PRI_KICK	127
#define	PRI_CP		126
#define	PRI_AUTH	126
#define	PRI_LQR		125
#define	PRI_NPMAX	120	/* Max priority of network protocol */

/*
   0***-3***	Network Layer
   8***-b***	NCP
   4***-7***	
   c***-f***	Link Layer CP
*/

#define	PROTO_IP	0x0021
#define	PROTO_VJC	0x002d
#define	PROTO_VJUC	0x002f
#define	PROTO_COMP	0x00fd
#define	PROTO_IPCP	0x8021
#define	PROTO_IPXCP	0x802b
#define	PROTO_NBCP	0x803f
#define	PROTO_CCP	0x80fd
#define	PROTO_LCP	0xc021
#define	PROTO_PAP	0xc023
#define	PROTO_LQR	0xc025
#define	PROTO_CBCP	0xc029
#define	PROTO_CHAP	0xc223
#define	PROTO_EAP	0xc227
#define	PROTO_MASK	0xc000	/* non-network protocol mask */
#define	PROTO_NLPMASK	0x0000
#define	PROTO_NCPMASK	0x8000
#define	PROTO_LLPMASK	0xc000

#if BYTE_ORDER == LITTLE_ENDIAN
#define	NBO_PROTO_IP		0x2100
#define	NBO_PROTO_VJC		0x2d00
#define	NBO_PROTO_VJUC		0x2f00
#define	NBO_PROTO_COMP		0xfd00
#define	NBO_PROTO_IPCP		0x2180
#define	NBO_PROTO_IPXCP		0x2b80
#define	NBO_PROTO_NBCP		0x3f80
#define	NBO_PROTO_CCP		0xfd80
#define	NBO_PROTO_LCP		0x21c0
#define	NBO_PROTO_PAP		0x23c0
#define	NBO_PROTO_LQR		0x25c0
#define	NBO_PROTO_CBCP		0x29c0
#define	NBO_PROTO_CHAP		0x23c2
#define	NBO_PROTO_EAP		0x27c2
#define	NBO_PROTO_MASK		0x00c0
#define	NBO_PROTO_NLPMASK	0x0000
#define	NBO_PROTO_NCPMASK	0x0080
#define	NBO_PROTO_LLPMASK	0x00c0
#elif BYTE_ORDER == BIG_ENDIAN
#define	NBO_PROTO_IP		PROTO_IP
#define	NBO_PROTO_VJC		PROTO_VJC
#define	NBO_PROTO_VJUC		PROTO_VJUC
#define	NBO_PROTO_COMP		PROTO_COMP
#define	NBO_PROTO_IPCP		PROTO_IPCP
#define	NBO_PROTO_IPXCP		PROTO_IPXCP
#define	NBO_PROTO_NBCP		PROTO_NBCP
#define	NBO_PROTO_CCP		PROTO_CCP
#define	NBO_PROTO_LCP		PROTO_LCP
#define	NBO_PROTO_PAP		PROTO_PAP
#define	NBO_PROTO_LQR		PROTO_LQR
#define	NBO_PROTO_CBCP		PROTO_CBCP
#define	NBO_PROTO_CHAP		PROTO_CHAP
#define	NBO_PROTO_EAP		PROTO_EAP
#define	NBO_PROTO_MASK		PROTO_MASK
#define	NBO_PROTO_NLPMASK	PROTO_NLPMASK
#define	NBO_PROTO_NCPMASK	PROTO_NCPMASK
#define	NBO_PROTO_LLPMASK	PROTO_LLPMASK
#else
#error	"Please specify byteorder"
#endif

/*
0001            Padding Protocol
0003 to 001f    reserved (transparency inefficient)
0021            Internet Protocol
0023            OSI Network Layer
0025            Xerox NS IDP
0027            DECnet Phase IV
0029            Appletalk
002b            Novell IPX
002d            Van Jacobson Compressed TCP/IP
002f            Van Jacobson Uncompressed TCP/IP
0031            Bridging PDU
0033            Stream Protocol (ST-II)
0035            Banyan Vines
0037            reserved (until 1993)
0039            AppleTalk EDDP
003b            AppleTalk SmartBuffered
003d            Multi-Link
003f            NETBIOS Framing
0041            Cisco Systems
0043            Ascom Timeplex
0045            Fujitsu Link Backup and Load Balancing (LBLB)
0047            DCA Remote Lan
0049            Serial Data Transport Protocol (PPP-SDTP)
004b            SNA over 802.2
004d            SNA
004f            IP6 Header Compression
0061            IP Compression Protocol               [RFC2509]
006f            Stampede Bridging
007d            reserved (Control Escape)             [RFC1661]
007f            reserved (compression inefficient)    [RFC1662]
00cf            reserved (PPP NLPID)
00fb            compression on single link in multilink group
00fd            1st choice compression
00ff            reserved (compression inefficient)

0201            802.1d Hello Packets
0203            IBM Source Routing BPDU
0205            DEC LANBridge100 Spanning Tree
0231            Luxcom
0233            Sigma Network Systems

8001-801f       Not Used - reserved                   [RFC1661]
8021            Internet Protocol Control Protocol
8023            OSI Network Layer Control Protocol
8025            Xerox NS IDP Control Protocol
8027            DECnet Phase IV Control Protocol
8029            Appletalk Control Protocol
802b            Novell IPX Control Protocol
802d            reserved
802f            reserved
8031            Bridging NCP
8033            Stream Protocol Control Protocol
8035            Banyan Vines Control Protocol
8037            reserved till 1993
8039            reserved
803b            reserved
803d            Multi-Link Control Protocol
803f            NETBIOS Framing Control Protocol
807d            Not Used - reserved                   [RFC1661]
8041            Cisco Systems Control Protocol
8043            Ascom Timeplex
8045            Fujitsu LBLB Control Protocol
8047            DCA Remote Lan Network Control Protocol (RLNCP)
8049            Serial Data Control Protocol (PPP-SDCP)
804b            SNA over 802.2 Control Protocol
804d            SNA Control Protocol
804f            IP6 Header Compression Control Protocol
006f            Stampede Bridging Control Protocol
80cf            Not Used - reserved                   [RFC1661]
80fb            compression on single link in multilink group control
80fd            Compression Control Protocol
80ff            Not Used - reserved                   [RFC1661]

c021            Link Control Protocol
c023            Password Authentication Protocol
c025            Link Quality Report
c027            Shiva Password Authentication Protocol
c029            CallBack Control Protocol (CBCP)
c081            Container Control Protocol                  [KEN]
c223            Challenge Handshake Authentication Protocol
c227            Extensible Authentication Protocol    [RFC2284]
c281            Proprietary Authentication Protocol         [KEN]
c26f            Stampede Bridging Authorization Protocol
c481            Proprietary Node ID Authentication Protocol [KEN]
*/

#endif	/* _PPXP_FRAME_H */
