#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <termios.h>
#include <sys/file.h>
#include <sys/types.h>

#include <config.h>
#include <support.h>

#include <option.h>
#include <log.h>
#include "device.h"

static struct termios oldTio;

static void
DirectClose(int fd)
{
    if (fd < 0) return;
    if (isatty(fd)) tcsetattr(fd, TCSAFLUSH, &oldTio);
    AllExit();
}

static void
DirectSignal(int sig)
{
    DirectClose(0);
}

void
DirectSetup()
{
    signal(SIGINT, DirectSignal);
    signal(SIGHUP, DirectSignal);
    signal(SIGTERM, DirectSignal);
    DevClose = DirectClose;
    DevRead = AsyncRead;
    DevWrite = AsyncWrite;
    if (isatty(0)) {
	struct termios newtio;

	tcgetattr(0, &oldTio);
	newtio = oldTio;
	newtio.c_lflag &= ~(ECHO|ISIG|ICANON);
/*	newtio.c_cflag |= CS8;*/
	newtio.c_iflag = 0;
	newtio.c_oflag &= ~OPOST;
	newtio.c_cc[VMIN] = 1;
	newtio.c_cc[VTIME] = 0;
#ifdef	HAVE_C_LINE
	newtio.c_line = 0;
#endif
	tcsetattr(0, TCSAFLUSH, &newtio);
    }
}
