#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <errno.h>

#include <config.h>
#include <support.h>
#include <xcio.h>

#include <log.h>
#include <chat.h>
#include <phase.h>
#include <option.h>
#include <fcs.h>
#include <console.h>
#include <mbuf.h>
#include <frame.h>
#include <lcp.h>
#include <ccp.h>
#include "device.h"
#include "serial.h"

int (*DevOpen)();
int (*DevWrite)(int, u_char *, int, u_int16_t);
int (*DevRead)();
int (*DevCheck)();
void (*DevClose)();

/*struct device_s *devOp;*/

int devFd=-1;
extern struct lcpreg_s lcprReg, lcplReg;
extern u_int32_t hbo_remoteAccm;
static b256_t escMap;

#define	FRAME_FLAG	0x7E
#define	FRAME_ESCAPE	0x7D
#define	FRAME_ADDRESS	0xFF
#define	FRAME_CONTROL	0x03
#define	FRAME_XOR	0x20

#define	MAX_FRAMEHEAD	10

#define	DEVBUFSIZ	4096
static u_char devBuf[DEVBUFSIZ];

enum {
    FCS_IGNORE,
    FCS_ADD,
    FCS_CHECK
};

typedef enum {
    FST_FLAG,		/* waitinf for a FRAME_FLAG */
    FST_ADDRESS,	/*               FRAME_ADDRESS */
    FST_CONTROL,	/*               FRAME_CONTROL */
    FST_PROTOCOL0,	/*               protocol first byte */
    FST_PROTOCOL1,	/*               protocol second byte */
    FST_DATA,		/*               data */
} framestate_t;

static struct framereg_s {
    framestate_t state;
    int slen, rlen;
    u_char sbuf[MAX_FRAMESIZ];
    u_char rbuf[MAX_FRAMESIZ];
    u_char *sbp, *rbp;
    union {
	u_int8_t byte[2];
	u_int16_t nbo;
    } proto;
    u_int16_t fcs;
} frameReg={
    FST_FLAG,
    0, 0,
    {0}, {0},
    &frameReg.sbuf[MAX_HEADERGAP], &frameReg.rbuf[MAX_HEADERGAP],
    {0},
    INITIAL_FCS
};

int
SyncGetc(u_char c)
{
    switch(frameReg.state) {
    case FST_DATA:
	frameReg.rbp[frameReg.rlen] = c;
	frameReg.rlen ++;
	break;
    case FST_CONTROL:
	if (c == FRAME_CONTROL) {
	    frameReg.state = FST_PROTOCOL0;
	} else {
	    frameReg.state = FST_FLAG;
	    return(1);
	}
	break;
    case FST_ADDRESS:
	if (c == FRAME_ADDRESS) {
	    frameReg.state = FST_CONTROL;
	    break;
	} else if (!lcplReg.acfc || !(pppInfo.l_stat & LSTAT_PPP)) {
	    frameReg.state =
		(c == FRAME_FLAG) ? FST_ADDRESS: FST_FLAG;
	    return(1);
	}
    case FST_PROTOCOL0:
	frameReg.proto.byte[0] = c;
	frameReg.state = FST_PROTOCOL1;
	break;
    case FST_PROTOCOL1:
	if (lcplReg.pfc && (frameReg.proto.byte[0] & 1)) {
	    frameReg.proto.byte[1] = frameReg.proto.byte[0];
	    frameReg.proto.byte[0] = 0;
	    frameReg.rbp[frameReg.rlen] = c;
	    frameReg.rlen ++;
	} else {
	    frameReg.proto.byte[1] = c;
	}
	frameReg.state = FST_DATA;
	if (!(pppInfo.l_stat & LSTAT_PPP)) pppInfo.l_stat = LSTAT_PPP;
	break;
    case FST_FLAG:
/*
	ConsoleOutf("%c", c);
*/
	return(1);
	break;
    }
    return(0);
}

int
AsyncRead(int fd)
{
    static int escaped=0;
    int i, n;
    u_char c, *buf;

    n = read(fd, devBuf, DEVBUFSIZ);
    pppInfo.r.lsize += n;
    if (ISLOG(LOG_DUMP))
	FrameDump("AsyncRead", devBuf, n);
    buf = devBuf;
    for (i = 0; i < n; i ++, buf ++) {
	c = *buf;
	if (!(pppInfo.l_stat & LSTAT_PPP)) {
	    if (pppInfo.l_stat & LSTAT_CHAT) {
		switch(ChatIn(c)) {
		case CHAT_DONE:
		    pppInfo.l_stat = (pppOpt.mode == RUN_ACTIVE)
			? LSTAT_PPP: LSTAT_TTY;
		    PhaseUp();
		    break;
		case CHAT_RETRY:
		    pppInfo.l_stat = LSTAT_PROMPT;
/*		    RetryInterval();*/
		    break;
		case CHAT_ABORT:
		    pppInfo.l_stat = LSTAT_PROMPT;
		    break;
		}
	    }
	    if (pppInfo.l_stat & LSTAT_TTY) ConsoleOutf("%c", c);
	}
	if (escaped) {
	    escaped = 0;
	    c ^= FRAME_XOR;
	} else if (c == FRAME_ESCAPE && frameReg.state != FST_FLAG) {
	    escaped = 1;
	    continue;
	} else if (c == FRAME_FLAG) {
	    frameReg.state = FST_ADDRESS;
	    if (frameReg.rlen > 0) {
		if (ISLOG(LOG_DUMP)) {
		    char str[32];

		    sprintf(str, "FrameRead@%s/%s",
			    TostrProto(&frameReg.proto.nbo),
			    (frameReg.fcs == GOOD_FCS) ? "ok": "ng");
		    FrameDump(str, frameReg.rbp, frameReg.rlen - 2);
		}
		if (frameReg.fcs == GOOD_FCS) {
		    FrameRead(frameReg.rbp, frameReg.rlen - 2,
			      frameReg.proto.nbo);
		} else {
		    Logf(LOG_ERROR, "frame(%s): bad FCS(%#x)\n",
			 TostrProto(&frameReg.proto.nbo), frameReg.fcs);
		    pppInfo.r.error ++;
		}
		frameReg.fcs = INITIAL_FCS;
		frameReg.rlen = 0;
	    }
	    continue;
	}
	if (!SyncGetc(c))
	    frameReg.fcs = AddToFcs(frameReg.fcs, c);
    }
    return(n);
}

inline static int
AsyncEncode(u_char *buf, u_char c, u_int16_t nbo_proto)
{
    int ret=1;

    if (((c < 0x20
	  && (nbo_proto == NBO_PROTO_LCP || (hbo_remoteAccm & (1<<c))))
	 || c == FRAME_ESCAPE || c == FRAME_FLAG)
	|| ((escMap.b[0] & 1) && B256_ISSET(&escMap, c))) {
	*buf ++ = FRAME_ESCAPE;
	c ^= FRAME_XOR;
	ret = 2;
    }
    *buf = c;
    return(ret);
}

int
AsyncWrite(int fd, u_char *buf, int n, u_int16_t nbo_proto)
{
    int i, hlen;
    u_char *p;
    u_char header[5]={
	FRAME_ADDRESS,
	FRAME_CONTROL,
    };
    u_int16_t fcs;

/*    if (frameReg.state == FST_FLAG) {*/
/*    if (!(pppInfo.line & LINE_PPP)) {*/
    if (!nbo_proto) {
	write(fd, buf, n);
	return(n);
    }
/*    nbo_proto = htons(hbo_proto);*/

    if (compC && ((nbo_proto & NBO_PROTO_MASK) == NBO_PROTO_NLPMASK)
	&& (nbo_proto != NBO_PROTO_COMP)) {
#if 0
	if (ISLOG(LOG_DUMP)) Logf(LOG_DUMP, "C");
#endif
	compC(buf, &n, nbo_proto);
	return(0);
    }
    /* Address and Control Field Compression */
    hlen = (nbo_proto != NBO_PROTO_LCP && lcprReg.acfc) ? 0: 2;
    /* Protocol Field Compression */
    if (lcprReg.pfc && !*(p = (char *)&nbo_proto)) {
	header[hlen] = *(p + 1);
	hlen ++;
    } else {
	memcpy(&header[hlen], &nbo_proto, sizeof(nbo_proto));
	hlen += sizeof(nbo_proto);
    }
    p = frameReg.sbp;
    *p ++ = FRAME_FLAG;
    fcs = INITIAL_FCS;
    for (i = 0; i < hlen; i ++) {
	fcs = AddToFcs(fcs, header[i]);
	p += AsyncEncode(p, header[i], nbo_proto);
    }
    for (i = 0; i < n; i ++) {
	fcs = AddToFcs(fcs, buf[i]);
	p += AsyncEncode(p, buf[i], nbo_proto);
    }
    fcs = ~fcs;
    p += AsyncEncode(p, fcs & 0xFF, nbo_proto);
    p += AsyncEncode(p, fcs >> 8, nbo_proto);
/*
    *p ++ = fcs & 0xFF;
    *p ++ = fcs >> 8;
*/
    *p ++ = FRAME_FLAG;
    if (ISLOG(LOG_DUMP))
	FrameDump("AsyncWrite", frameReg.sbp, p - frameReg.sbp);
    pppInfo.s.count ++;
    pppInfo.s.lsize += write(fd, frameReg.sbp, p - frameReg.sbp);
    return(0);
}

static struct device_s *devHead;

void
RegisterDevice(struct device_s *dev)
{
    dev->next = devHead;
    devHead = dev;
}

int
SetDevice(char **name)
{
    struct device_s *dev;

    dev = devHead;
    if (DevClose) DevClose(-1);	/* for sio */
    while (dev) {
	if (dev->probe(name[0])) {
	    DevOpen = dev->open;
	    DevWrite = dev->write;
	    DevRead = dev->read;
	    DevClose = dev->close;
	    DevCheck = dev->check;
	    return(0);
	}
	dev = dev->next;
    }
    return(-1);
}

void
Close(int fd)
{
    if (ISLOG(LOG_OS)) Logf(LOG_OS, "close(%d)\n", fd);
    close(fd);
}

void
DevExit()
{
    if (DevClose) DevClose(devFd);
    AllExit();
}

bool_t
EnvEscMap(int argc, char *argv[], char *outs)
{
    int i, a;

    if (!argc) {
	char *p=outs;

	for (i = 0x20; i < 0x100; i ++) {
	    if (B256_ISSET(&escMap, i))
		p += SprintF(p, "0x%02x ", i);
	}
	return FALSE;
    }
    B256_ZERO(&escMap);
    for (a = 1; a < argc; a ++) {
	i = 0;
	if (sscanf(argv[a], "%x", &i) == 1 && i != 0 && i < 256) {
	    B256_SET(&escMap, 0);
	    B256_SET(&escMap, i);
	}
    }
    return TRUE;
}
