#
#
#
#

package require PPxP

proc ppxp:set_var {elem val} {
    global PPxPVar

    if {![info exists PPxPVar($elem)] || $PPxPVar($elem) != $val} {
	set PPxPVar($elem) $val
    }
}

proc ppxp:set_info {elem val} {
    global PPxPInfo

    if {![info exists PPxPInfo($elem)] || $PPxPInfo($elem) != $val} {
	set PPxPInfo($elem) $val
    }
}

set ppxp_prev_send_nsize 0
set ppxp_prev_recv_nsize 0
set PPxPInfo(send.nrate) 0
set PPxPInfo(recv.nrate) 0

proc ppxp:set_rate {} {
    global PPxPInfo ppxp_prev_send_nsize ppxp_prev_recv_nsize

    ppxp:set_info send.nrate \
	[expr $PPxPInfo(send.nsize) - $ppxp_prev_send_nsize]
    ppxp:set_info recv.nrate \
	[expr $PPxPInfo(recv.nsize) - $ppxp_prev_recv_nsize]

    set ppxp_prev_send_nsize $PPxPInfo(send.nsize)
    set ppxp_prev_recv_nsize $PPxPInfo(recv.nsize)
}

proc ppxp:recv_handler {} {
    global PPxP
    global ppxp_update_event

    if [catch {set xcio [$PPxP read result]}] {
	puts "PPxP abort."
	exit 1
    }
    switch [XcioType $xcio] {
	XCIO_S_OUT {
	    global PPxPMessage
	    set PPxPMessage $result
	}
	XCIO_ENV_SET {
	    ppxp:set_var [lindex $result 0] [lindex $result 1]
	}
	XCIO_UP_ENVS {
	    ppxp:set_var [lindex $result 0] [lindex $result 1]
	}
	XCIO_LISTUP {
	    if {![regexp {^CMD} $result]} {
		$PPxP env [lindex $result 1]
	    }
	}
	XCIO_UP_INFO {
	    foreach i $result {
		ppxp:set_info [lindex $i 0] [lindex $i 1]
	    }
	    ppxp:set_rate
	    ppxp:update_status
	    set ppxp_update_event 1
	}
    }
}

set ppxp_status_list {
    dead dial chat auth network term
}
set PPxPStatus -1
set ppxp_status_string ""
set ppxp_prev_status ""

proc ppxp:update_status {} {
    global PPxPInfo
    global PPxPStatus ppxp_prev_status ppxp_status_string ppxp_status_list

    set phase $PPxPInfo(phase)
    set line $PPxPInfo(linestat)

    if {$phase == "dead" && $line == ""} {
	set status 0
    } elseif {$phase == "dead" && [regexp {dial} $line]} {
	set status 1
    } elseif {$phase == "dead" && [regexp {tty} $line]} {
	set status 2
    } elseif {$phase == "authenticate"} {
	set status 3
    } elseif {$phase == "network" && [regexp {nlink} $line]} {
	set status 4
    } elseif {$phase == "terminate"} {
	set status 5
    } else {
	set status -1
    }
    if {$status >= 0 && $status != $PPxPStatus} {
	set ppxp_prev_status $PPxPStatus
	set ppxp_status_string [lindex $ppxp_status_list $status]
	set PPxPStatus $status
    }
}

proc PPxP:Dead {} {
    global PPxPStatus
    expr $PPxPStatus >= 0 ? 1 : 0
}

proc PPxP:OnLine {} {
    global PPxPStatus
    expr $PPxPStatus == 4 ? 1 : 0
}

proc PPxP:Dialing {} {
    global PPxPStatus
    expr $PPxPStatus == 1 ? 1 : 0
}

proc PPxP:RegisterUpdateVar {var cmd} {
    set_trace PPxPVar($var) w $cmd
}

proc PPxP:RegisterUpdateInfo {var cmd} {
    if {$var == "all"} {
	set_trace ppxp_update_event w $cmd
    } else {
	set_trace PPxPInfo($var) w $cmd
    }
}

proc PPxP:RegisterUpdateStatus {cmd} {
    set_trace PPxPStatus w $cmd
}

proc PPxP:RegisterMessage {cmd} {
    set_trace PPxPMessage w $cmd
}

proc PPxP:UnregisterUpdate {id} {
    del_trace $id
}

proc PPxP:UpdateVarWidget {widget var cmd} {
    Widget:SetTrace $widget PPxPVar($var) w $cmd
}

proc PPxP:UpdateInfoWidget {widget var cmd} {
    Widget:SetTrace $widget PPxPInfo($var) w $cmd
}

proc PPxP:UpdateStatusWidget {widget cmd} {
    Widget:SetTrace $widget PPxPStatus w $cmd
}

proc PPxP:MessageWidget {widget cmd} {
    Widget:SetTrace $widget PPxPMessage w $cmd
}

proc PPxP:ConnectTime {} {
    global PPxPInfo

    set t $PPxPInfo(connect)
    set h [expr $t/3600]
    set m [expr ($t%3600)/60]
    set s [expr $t%60]
    format "%02d:%02d:%02d" $h $m $s
}

proc PPxP:IdleTime {} {
    global PPxPInfo

    set t $PPxPInfo(idle)
    set h [expr $t/3600]
    set m [expr ($t%3600)/60]
    set s [expr $t%60]
    format "%02d:%02d" $m $s
}

proc ppxp:get_all_vars {} {
    global PPxP PPxPVar

    set id [$PPxP listup]
    set vars {}

    while {1} {
	if {[catch {set t [$PPxP read s $id]}]} {
	    break
	}
	if {[XcioType $t] == "XCIO_LISTUP"} {
	    if {![regexp {^CMD} $s]} {
		lappend vars [lindex $s 1]
	    }
	}
	if [XcioLast $t] {
	    break
	}
    }
    foreach v $vars {
	ppxp:set_var $v {}
	$PPxP env $v
    }
}

proc PPxP:Start {av} {
    global PPxP
    set PPxP [eval PPxPSetup $av]

    global DEBUG
    if $DEBUG {
	$PPxP debug
    }
    ppxp:get_all_vars
    $PPxP update
    $PPxP update
    $PPxP autoupdate

    fileevent [$PPxP filehandle] readable ppxp:recv_handler

    return 1
}
