<?php
/**
 * Displays the menu block.
 *
 * @module menu
 * @modulegroup core
 * @package phpWebSite
 */


// Check $menu and see what level we are on.  

if($extend_menu)
{
  full_menu($menu);
}
else
{
  if ($menu < 100) menu1($menu);
  else if ($menu < 10000 ) menu2($menu);
  else if($menu < 1000000) menu3($menu);
}

/**
 * Display Menu - First Level Menu
 *
 * @param int Menu ID
 */


Function menu1($menu)
{
  include("config.php");
  global $phpgw;

  $db2 = $phpgw->db;
  
  $phpgw->db->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 1 and menu_active = 1 order by menu_order");
  
  while($phpgw->db->next_record()){
    $menu_id=$phpgw->db->f("menu_id");
    $menu_text=$phpgw->db->f("menu_text");
    $menu_url=$phpgw->db->f("menu_url");
    $menu_order=$phpgw->db->f("menu_order");
    $page_id=$phpgw->db->f("page_id");
    if ($page_id) {
	 echo $menu_bullet . "<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
    } 
    else {
      if(eregi("//?",$menu_url))
	echo $menu_bullet . "<a href=\"$menu_url\">$menu_text</a><br />";
      else
	echo $menu_bullet . "<a href=\"$menu_url?menu=$menu_id\">$menu_text</a><br />";
    }
    

    if ($menu == $menu_id){
      
      $low_sub = $menu * 100;
      $high_sub = $low_sub + 99;
      
       $db2->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 2 and menu_active = 1 and menu_id >=  $low_sub and menu_id <=  $high_sub order by menu_order");
       
       while($db2->next_record()){
	 $menu_id=$db2->f("menu_id");
	 $menu_text=$db2->f("menu_text");
	 $menu_url=$db2->f("menu_url");
	 $menu_order=$db2->f("menu_order");
	 $page_id=$db2->f("page_id");
	 if ($page_id)
	   echo"&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
	 
	else {
	  if(eregi("//?",$menu_url))
	    echo "&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url\">$menu_text</a><br />";
	  else
	    echo"&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id\">$menu_text</a><br />";
	}
       }
       
    }
    
  }
  
}


/**
 * Display Menu - Second Level Menu
 *
 * @param int Menu ID
 */

function menu2($menu)
{
  include("config.php");
  global $phpgw;

  $db2 = $phpgw->db;
  $db3 = $phpgw->db;
  $phpgw->db->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 1 and menu_active = 1 order by menu_order");
  
  while($phpgw->db->next_record()){
    $menu_id=$phpgw->db->f("menu_id");
    $menu_text=$phpgw->db->f("menu_text");
    $menu_url=$phpgw->db->f("menu_url");
    $menu_order=$phpgw->db->f("menu_order");
    $page_id=$phpgw->db->f("page_id");
    if ($page_id){
     echo $menu_bullet . "<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
    }
    else {
      if(eregi("//?",$menu_url))
	echo $menu_bullet . "<a href=\"$menu_url\">$menu_text</a><br />";
      else
	echo $menu_bullet . "<a href=\"$menu_url?menu=$menu_id\">$menu_text</a><br />";
    }
    
    
     if ((floor($menu / 100)) == $menu_id){
       
       $low_sub = ((floor($menu / 100)) * 100);
       $high_sub = ($low_sub + 99);
       
       $db2->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 2 and menu_active = 1 and menu_id >=  $low_sub and menu_id <= $high_sub order by menu_order");
       
       while($db2->next_record()){
	 $menu_id=$db2->f("menu_id");
	 $menu_text=$db2->f("menu_text");
	 $menu_url=$db2->f("menu_url");
	 $menu_order=$db2->f("menu_order");
	 $page_id=$db2->f("page_id");
	 if ($page_id){
	   echo"&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
	 }
	 else {
	   if(eregi("//?",$menu_url))
	     echo "&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url\">$menu_text</a><br />";
	   else
	     echo"&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id\">$menu_text</a><br />";
	 }
	 
	 
	 if ($menu == $menu_id){
	   
	   $low_sub = ($menu * 100);
	   $high_sub = ($low_sub + 99);
	   
	   $db3->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 3 and menu_active = 1 and menu_id >=  $low_sub and menu_id <= $high_sub order by menu_order");
	   
	   while($db3->next_record()){
	     $menu_id=$db3->f("menu_id");
	     $menu_text=$db3->f("menu_text");
	     $menu_url=$db3->f("menu_url");
	     $menu_order=$db3->f("menu_order");
	     $page_id=$db3->f("page_id");
	     if ($page_id){
	       echo"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
	     }
	     else {
	       if(eregi("//?",$menu_url))
		 echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url\">$menu_text</a><br />";
	       else
		 echo"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id\">$menu_text</a><br />";
	     }
	     
	   }
	   
	 }
       }
     }
  }
}

/**
 * Display Menu - Third Level Menu
 *
 * @param int Menu ID
 */

function menu3($menu)
{
  include("config.php");
  global $phpgw;

  $db2 = $phpgw->db;
  $db3 = $phpgw->db;
  $phpgw->db->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 1 and menu_active = 1 order by menu_order");
  
  while($phpgw->db->next_record()){
     $menu_id=$phpgw->db->f("menu_id");
     $menu_text=$phpgw->db->f("menu_text");
     $menu_url=$phpgw->db->f("menu_url");
     $menu_order=$phpgw->db->f("menu_order");
     $page_id=$phpgw->db->f("page_id");
    if ($page_id){
      echo $menu_bullet . "<a href=\"$menu_url?menu=$menu_id&page_id=$page_id\">$menu_text</a><br />";
    }
    else {
      if(eregi("//?",$menu_url))
	echo $menu_bullet . "<a href=\"$menu_url\">$menu_text</a><br />";
      else
	echo $menu_bullet . "<a href=\"$menu_url?menu=$menu_id\">$menu_text</a><br />";
    }
    
    
    if ((floor($menu / 10000)) == $menu_id){
      
      $low_sub = ((floor($menu / 10000)) * 100);
      $high_sub = ($low_sub + 99);
      
      $db2->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 2 and menu_active = 1 and menu_id >=  $low_sub and menu_id <= $high_sub order by menu_order");
      
      while($db2->next_record()){
     	$menu_id=$db2->f("menu_id");
     	$menu_text=$db2->f("menu_text");
     	$menu_url=$db2->f("menu_url");
     	$menu_order=$db2->f("menu_order");
     	$page_id=$db2->f("page_id");
	if ($page_id){
	  echo"&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
	}
	else {
	  if(eregi("//?",$menu_url))
	    echo "&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url\">$menu_text</a><br />";
	  else
	    echo"&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id\">$menu_text</a><br />";
	}
	
	
	if ((floor($menu / 100)) == $menu_id) {
	  
	  $low_sub = (floor($menu /100) * 100);
	  $high_sub = ($low_sub + 99);
	  
	  $db3->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 3 and menu_active = 1 and menu_id >=  $low_sub and menu_id <= $high_sub order by menu_order");
	  
	  while($db3->next_record()){
     		$menu_id=$db3->f("menu_id");
     		$menu_text=$db3->f("menu_text");
     		$menu_url=$db3->f("menu_url");
     		$menu_order=$db3->f("menu_order");
     		$page_id=$db3->f("page_id");
	    if ($page_id){
	      echo"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
	    }
	    else {
	      if(eregi("//?",$menu_url))
echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url\">$menu_text</a><br />";
	      else
		echo"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
	    }
	    
	    
	  }
	}
      }
    }
  }
}

function full_menu()
{
  include("config.php");
  global $phpgw;
  global $menu_bullet;
  
  $db2 = $phpgw->db;
  $db3 = $phpgw->db;
  $phpgw->db->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 1 && menu_active = 1 order by menu_order");
  
  while($phpgw->db->next_record())
    {
     	$menu_id=$phpgw->db->f("menu_id");
     	$menu_text=$phpgw->db->f("menu_text");
     	$menu_url=$phpgw->db->f("menu_url");
     	$menu_order=$phpgw->db->f("menu_order");
     	$page_id=$phpgw->db->f("page_id");
      if($page_id) echo "$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
      else echo "$menu_bullet<a href=\"$menu_url\">$menu_text</a><br />";
      
      $low_sub = $menu_id * 100;
      $high_sub = $low_sub + 99;
      
      $db2->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 2 && menu_active = 1 && menu_id >=  $low_sub && menu_id <=  $high_sub order by menu_order");
      
      while($db2->next_record())
	{
     		$menu_id=$db2->f("menu_id");
     		$menu_text=$db2->f("menu_text");
     		$menu_url=$db2->f("menu_url");
     		$menu_order=$db2->f("menu_order");
     		$page_id=$db2->f("page_id");
	  if($page_id) echo "&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
	  else echo "&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url\">$menu_text</a><br />";
	  
	  $low_sub = $menu_id * 100;
	  $high_sub = $low_sub + 99;
	  
	  $db3->query("select menu_id, menu_text, menu_url, menu_order, page_id from wcm_menu where menu_level = 3 && menu_active = 1 && menu_id >=  $low_sub && menu_id <=  $high_sub order by menu_order");
	  
	  while($db3->next_record())
	    {
     		$menu_id=$db3->f("menu_id");
     		$menu_text=$db3->f("menu_text");
     		$menu_url=$db3->f("menu_url");
     		$menu_order=$db3->f("menu_order");
     		$page_id=$db3->f("page_id");
	      if ($page_id) echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url?menu=$menu_id&amp;page_id=$page_id\">$menu_text</a><br />";
	      else echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$menu_bullet<a href=\"$menu_url\">$menu_text</a><br />";
	    }
	}
    }
}
?>
