<?php

  /**************************************************************************\
  * phpGroupWare - SyncML Synchronization                                    *
  * http://www.phpgroupware.org                                              *
  * Written by Jens P. Elsner <jpelsner@gmx.net>                             *
  *            Mark Wormgoor <mark@wormgoor.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	class syncml_phpgw extends syncml
	{

		/********************************************************************\
		* SyncML Protocol Management                                         *
		\********************************************************************/

		function cb_start_message($sync_hdr) {
			global $debug;
	
			if ( $debug['level'] > 0 ) {
				error_log ( $debug['prefix'] . 
					'SyncML message start. SyncHDR Data: \n' .
					'Version: ' . $sync_hdr->version . '\n' .
					'Protocol: ' . $sync_hdr->proto . '\n' .
					'Session ID: ' . $sync_hdr->sessionID . '\n' .
					'Message ID: ' . $sync_hdr->msgID . '\n' .
					'Flags: ' . $sync_hdr->flags . '\n' .
					'Creds Meta: ' . $sync_hdr->creds->meta . '\n' .
					'Creds Data: ' . $sync_hrd->creds->data . '\n' .
					'Target URI: ' .$sync_hdr->target->locURI . '\n' .
					'Target Name: ' . $sync_hdr->target->locName . '\n' .
					'Source URI: ' . $sync_hdr->source->locURI . '\n' .
					'Source Name: ' . $sync_hdr->source->locName ,
					$debug['type'], $debug['destination'] );
			}

			$hdr = new sml_sync_hdr();
			$hdr->version = $sync_hdr->version;
			$hdr->proto = $sync_hdr->proto;
			$hdr->sessionID = $sync_hdr->sessionID ;
			// $hdr->msgID = ($sync_hdr->msg ID) + 1;
			$hdr->flags = 0x0100;
			$hdr->target->locURI = $sync_hdr->source->locURI;
			$hdr->target->locName = $sync_hdr->source->locName;
			$hdr->source->locURI = $sync_hdr->target->locURI;
			$hdr->source->locName = $sync_hdr->target->locName;
			$test->start_message($hdr);
		}

	        function cb_end_message($final) {
			global $debug;

			if ( $debug['level'] > 0 ) {
				error_log ( $debug['prefix'] . 
					'SyncML End of Message received',
					$debug['type'], $debug['destination'] );
			}
	        }

	        function cb_start_sync($sync) {
			global $debug;

			if ( $debug['level'] > 0 ) {
				error_log ( $debug['prefix'] . 
					'SyncML sync start. Startsync Data: \n' .
					'cmdID: ' . $sync->cmdID . '\n' .
					'Flags: ' . $sync->flags . '\n' .
					'Cred Meta: ' . $sync->cred->meta . '\n' .
					'Cred Data: ' . $sync->cred->data . '\n' .
					'Target URI: ' . $sync->target->locURI . '\n' .
					'Target Name: ' . $sync->target->locName . '\n' .
					'Source URI: ' . $sync->source->locURI . '\n' .
					'Source Name: ' . $sync->source->locName .'\n' .
					'Meta: ' . $sync->meta , 
					$debug['type'], $debug['destination'] );
			}
       		}

		function cb_end_sync() {
			global $debug;

			if ( $debug['level'] > 0 ) {
				error_log ( $debug['prefix'] . 
					'SyncML End of Sync received',
					$debug['type'], $debug['destination'] );
			}
	        }

        	function cb_start_atomic($atomic_seq) {
                	echo "SyncML class: Callback cb_start_atomic not implemented. \n";
	        }
	        function cb_end_atomic() {
        	        echo "SyncML class: Callback cb_end_atomic not implemented. \n";
	        }
        	function cb_start_sequence($atomic_seq) {
                	echo "SyncML class: Callback cb_start_sequence not implemented. \n";
	        }
        	function cb_end_sequence() {
                	echo "SyncML class: Callback cb_end_sequence not implemented. \n";
	        }

		/********************************************************************\
		* SyncML Sync Commands                                               *
		\********************************************************************/

	        function cb_add_cmd($generic) {
        	        echo "SyncML class: Callback cb_add_cmd not implemented. \n";
	        }
        	function cb_alert_cmd() {
                	echo "SyncML class: Callback cb_alert_cmd not implemented. \n";
	        }
        	function cb_delete_cmd() {
                	echo "SyncML class: Callback cb_delete_cmd not implemented. \n";
	        }
        	function cb_get_cmd() {
                	echo "SyncML class: Callback cb_get_cmd not implemented. \n";
	        }
        	function cb_put_cmd() {
                	echo "SyncML class: Callback cb_put_cmd not implemented. \n";
	        }
        	function cb_map_cmd() {
                	echo "SyncML class: Callback cb_map_cmd not implemented. \n";
	        }
        	function cb_results_cmd() {
                	echo "SyncML class: Callback cb_results_cmd not implemented. \n";
	        }
        	function cb_status_cmd() {
                	echo "SyncML class: Callback cb_status_cmd not implemented. \n";
	        }
        	function cb_replace_cmd() {
                	echo "SyncML class: Callback cb_replace_cmd not implemented. \n";
	        }
        	function cb_copy_cmd() {
                	echo "SyncML class: Callback cb_copy_cmd not implemented. \n";
	        }
        	function cb_exec_cmd() {
                	echo "SyncML class: Callback cb_exec_cmd not implemented. \n";
	        }
        	function cb_search_cmd() {
                	echo "SyncML class: Callback cb_search_cmd not implemented. \n";
	        }

		/* other callbacks */
	        function cb_handle_error() {
        	        echo "'SyncML class: Callback cb_handle_error not implemented. \n";
	        }
        	function cb_transmit_chunk() {
                	echo "SyncML class: Callback cb_transmit_chunk not implemented. \n";
		}
	}
?>
