<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.uinetsaint.inc.php,v 1.21 2001/09/06 22:56:15 bettina Exp $ */

	class uinetsaint
	{
		var $action;
		var $grants;
		var $cat_id;
		var $start;
		var $order;
		var $sort;
		var $filter;

		var $public_functions = array
		(
			'prefs_service'	=> True,
			'add_service'	=> True,
			'edit_service'	=> True,
			'delete_item'	=> True,
			'view_service'	=> True,
			'admin_comand'	=> True,
			'add_comand'	=> True,
			'edit_comand'	=> True,
			'view_comand'	=> True,
			'prefs_escal'	=> True,
			'add_escal'		=> True,
			'edit_escal'	=> True,
			'view_escal'	=> True	
		);

		function uinetsaint()
		{
			global $phpgw, $phpgw_info, $action;

			$this->account					= $phpgw_info['user']['account_id'];
			$this->t						= $phpgw->template;
			$this->cats						= CreateObject('phpgwapi.categories');
			$this->nextmatchs				= CreateObject('phpgwapi.nextmatchs');
			$this->grants					= $phpgw->acl->get_grants('netsaint');
			$this->grants[$this->account]	= PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;
			$this->bonscontact				= CreateObject('netsaint.bonscontact');
			$this->botimeperiod				= CreateObject('netsaint.botimeperiod');
			$this->bonetsaint				= CreateObject('netsaint.bonetsaint', True, $action);
			$this->bonshost					= CreateObject('netsaint.bonshost');

			$this->start					= $this->bonetsaint->start;
			$this->query					= $this->bonetsaint->query;
			$this->filter					= $this->bonetsaint->filter;
			$this->sort						= $this->bonetsaint->sort;
			$this->order					= $this->bonetsaint->order;
			$this->cat_id					= $this->bonetsaint->cat_id;
		}

		function save_sessiondata($action)
		{
			$data = array
			(
				'start'		=> $this->start,
				'query'		=> $this->query,
				'filter'	=> $this->filter,
				'sort'		=> $this->sort,
				'order'		=> $this->order,
				'cat_id'	=> $this->cat_id
			);
			$this->bonetsaint->save_sessiondata($data, $action);
		}

		function set_app_langs()
		{
			global $phpgw, $phpgw_info;

			$this->t->set_var('bg_color',$phpgw_info['theme']['th_bg']);
			$this->t->set_var('row_on',$phpgw_info['theme']['row_on']);
			$this->t->set_var('row_off',$phpgw_info['theme']['row_off']);
			$this->t->set_var('lang_netsaint',lang('Netsaint'));
			$this->t->set_var('lang_prefs',lang('Preferences'));
			$this->t->set_var('lang_admin',lang('Administration'));
			$this->t->set_var('lang_timeperiods',lang('Time Periods'));
			$this->t->set_var('lang_hosts',lang('Hosts'));
			$this->t->set_var('lang_host_groups',lang('Host groups'));
			$this->t->set_var('lang_contacts',lang('Contacts'));
			$this->t->set_var('lang_contact_groups',lang('Contact groups'));
			$this->t->set_var('lang_services',lang('Services'));
			$this->t->set_var('lang_s_escalation',lang('Service escalation'));
			$this->t->set_var('lang_hg_escalation',lang('Host group escalation'));
			$this->t->set_var('lang_escalations',lang('Escalations'));

			$this->t->set_var('lang_notifications',lang('Notifications'));
			$this->t->set_var('lang_comands',lang('Commands'));
			$this->t->set_var('lang_comand',lang('Command'));

			$this->t->set_var('lang_done',lang('Done'));
			$this->t->set_var('lang_view',lang('View'));
			$this->t->set_var('lang_edit',lang('Edit'));
			$this->t->set_var('lang_save',lang('Save'));
			$this->t->set_var('lang_delete',lang('Delete'));
			$this->t->set_var('lang_min',lang('Minutes'));
			$this->t->set_var('lang_enabled',lang('Enabled'));

			$this->t->set_var('lang_cat',lang('Category'));
			$this->t->set_var('lang_private',lang('Private'));
			$this->t->set_var('lang_access',lang('Access'));

			$this->t->set_var('lang_first',lang('First notification'));
			$this->t->set_var('lang_last',lang('Last notification'));
			$this->t->set_var('lang_event',lang('Event'));
			$this->t->set_var('lang_scheck_comand',lang('Service check command'));
			$this->t->set_var('lang_name',lang('Short name'));
			$this->t->set_var('lang_line',lang('Command line'));

			$this->t->set_var('lang_host',lang('Host'));
			$this->t->set_var('lang_descr',lang('Description'));
			$this->t->set_var('lang_vol',lang('Is this service volatile ?'));
			$this->t->set_var('lang_max',lang('Maximal retries of service check before warn'));
			$this->t->set_var('lang_s_period',lang('Time period of service check'));
			$this->t->set_var('lang_c_period',lang('Time period of contact notification'));
			$this->t->set_var('lang_c_intval',lang('Pause between regular checks'));
			$this->t->set_var('lang_r_intval',lang('Pause between service retry'));
			$this->t->set_var('lang_cg',lang('Contact group'));

			$this->t->set_var('lang_not_intval',lang('Pause between renotify contact'));
			$this->t->set_var('lang_rec',lang('Notify contacts when service recovers ?'));
			$this->t->set_var('lang_crit',lang('Notify contacts when service is at a critical level ?'));
			$this->t->set_var('lang_warn',lang('Notify contacts when service is at a warning level ?'));

			$this->t->set_var('lang_created',lang('Created by'));
			$this->t->set_var('lang_modified',lang('last modified'));
			$this->t->set_var('lang_none',lang('None'));
			$this->t->set_var('lang_all',lang('All'));
		}

		function display_prefs_header()
		{
			global $phpgw, $phpgw_info, $Update;

			$this->t->set_file(array('prefs' => 'prefs_header.tpl'));
            $this->t->set_block('prefs','header');

			if ($Update)
			{
				$msg = $this->bonetsaint->check_config();

				if (is_array($msg))
				{
					$this->t->set_var('message',$phpgw->common->error_list($msg));
				}
				else
				{
					$this->bonetsaint->create_config();
					$this->t->set_var('message',lang('Netsaint configuration files have been created successfully !'));
					$this->bonetsaint->set_config_status('off');
				}
			}

			$this->set_app_langs();

			$this->t->set_var('link_time',$phpgw->link('/index.php','menuaction=netsaint.uitimeperiod.prefs_time'));
			$this->t->set_var('link_host',$phpgw->link('/index.php','menuaction=netsaint.uinshost.prefs_host&action=host'));
			$this->t->set_var('link_host_group',$phpgw->link('/index.php','menuaction=netsaint.uinshost.prefs_hg&action=hg'));
			$this->t->set_var('link_contact',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.prefs_contact&action=contact'));
			$this->t->set_var('link_contact_group',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.prefs_cg&action=cg'));
			$this->t->set_var('link_service',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.prefs_service&action=service'));
			$this->t->set_var('link_escalation',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.prefs_escal&action=host'));

			$update_config = $this->bonetsaint->check_config_status();

			if ($update_config == True)
			{
				$this->t->set_var('update','<form method="POST"><input type="submit" name="Update" value="' . lang('Update') . '"></form>');
			}
			else
			{
				$this->t->set_var('update','');
			}

			$this->t->fp('prefs','header');

			$phpgw->common->phpgw_header();
			echo parse_navbar();
		}

		function display_admin_header()
		{
			global $phpgw, $phpgw_info, $Update;

			$this->t->set_file(array('admin' => 'admin_header.tpl'));
            $this->t->set_block('admin','header');

			if ($Update)
			{
				$msg = $this->bonetsaint->check_config();

				if (is_array($msg))
				{
					$this->t->set_var('message',$phpgw->common->error_list($msg));
				}
				else
				{
					$this->bonetsaint->create_config();
					$this->t->set_var('message',lang('Netsaint configuration files have been created successfully !'));
					$this->bonetsaint->set_config_status('off');
				}
			}

			$this->set_app_langs();

			$this->t->set_var('link_comand',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.admin_comand&action=com_all'));
			$this->t->set_var('link_not',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.admin_comand&action=not_all'));

			$update_config = $this->bonetsaint->check_config_status();

			if ($update_config)
			{
				$this->t->set_var('update','<form method="POST"><input type="submit" name="Update" value="' . lang('Update') . '"></form>');
			}
			else
			{
				$this->t->set_var('update','');
			}

			$this->t->fp('admin','header');

			$phpgw->common->phpgw_header();
			echo parse_navbar();
		}

		function prefs_service()
		{
			global $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$this->t->set_file(array('filter' => 'filter.tpl',
									'service_list_t' => 'prefs_service.tpl'));
			$this->t->set_block('service_list_t','service_list','list');

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.prefs_service',
				'action'		=> 'service'
			);

			if (!$this->start)
			{
				$this->start = 0;
			}

			$service_list = $this->bonetsaint->read_items('service',$this->start,True,$this->query,$this->filter,$this->sort,$this->order,$this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bonetsaint->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bonetsaint->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bonetsaint->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('lang_action',lang('Services'));
			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

			$this->t->pfp('out','filter',True);

// ---------------- list header variable template-declarations --------------------------

			$this->t->set_var(sort_host,$this->nextmatchs->show_sort_order($this->sort,'s_host',$this->order,'/index.php',lang('Host'),$link_data));
			$this->t->set_var(sort_period,$this->nextmatchs->show_sort_order($this->sort,'s_period',$this->order,'/index.php',lang('Time period'),$link_data));
			$this->t->set_var(sort_cg,$this->nextmatchs->show_sort_order($this->sort,'cg',$this->order,'/index.php',lang('Contact group'),$link_data));
			$this->t->set_var(sort_modified,$this->nextmatchs->show_sort_order($this->sort,'c_date',$this->order,'/index.php',lang('last modified'),$link_data));

// -------------- end header declaration ---------------------------------------

			for ($i=0;$i<count($service_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);

				$new_date = $service_list[$i]['date'];
				$month = $phpgw->common->show_date(time(),'n');
				$day = $phpgw->common->show_date(time(),'d');
				$year = $phpgw->common->show_date(time(),'Y');
				$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
				$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

				$this->t->set_var(array
				(
					'host'		=> $phpgw->strip_html($service_list[$i]['host']),
					'period'	=> $phpgw->strip_html($service_list[$i]['period']),
					'cg'		=> $phpgw->strip_html($service_list[$i]['cg']),
					'modified'	=> $new_dateout
				));

				$link_data['i_id'] = $service_list[$i]['id'];
				$link_data['menuaction'] = 'netsaint.uinetsaint.view_service';

				$this->t->set_var('view',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_view_entry',lang('View'));

				if ($this->bonetsaint->check_perms($this->grants[$service_list[$i]['owner']],PHPGW_ACL_EDIT) || $service_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinetsaint.edit_service';

					$this->t->set_var('edit',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_edit_entry',lang('Edit'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit_entry','');
				}

				if ($this->bonetsaint->check_perms($this->grants[$service_list[$i]['owner']],PHPGW_ACL_DELETE) || $service_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinetsaint.delete_item';
					$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_delete_entry',lang('Delete'));
				}
				else
				{
					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete_entry','');
				}

				$this->t->fp('list','service_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data['menuaction'] = 'netsaint.uinetsaint.add_service';
			$link_data['cat_id'] = $this->cat_id;

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add service') .'"></form>');
			}
			else
			{
				if ($this->bonetsaint->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add service') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$this->t->pfp('out','service_list_t',True);
			$this->save_sessiondata('service');
//			$phpgw->common->phpgw_footer();
		}

		function prefs_escal()
		{
			global $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$this->t->set_file(array('filter' => 'filter.tpl',
									'escal_list_t' => 'prefs_escal.tpl'));
			$this->t->set_block('escal_list_t','escal_list','list');

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.prefs_escal',
				'action'		=> $action
			);

			if (!$this->start)
			{
				$this->start = 0;
			}

			$escal_list = $this->bonetsaint->read_items($action, $this->start, True, $this->query, $this->filter, $this->sort, $this->order, $this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bonetsaint->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bonetsaint->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bonetsaint->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			if ($action == 'host')
			{
				$this->t->set_var('lang_action',lang('Host group notification escalations'));
			}
			else
			{
				$this->t->set_var('lang_action',lang('Service notification escalations'));
			}
			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

			$this->t->pfp('out','filter',True);

// ---------------- list header variable template-declarations --------------------------

			if ($action == 'host')
			{
				$this->t->set_var(sort_name,$this->nextmatchs->show_sort_order($this->sort,'e_name',$this->order,'/index.php',lang('Host'),$link_data));
			}
			else
			{
				$this->t->set_var(sort_name,$this->nextmatchs->show_sort_order($this->sort,'e_name',$this->order,'/index.php',lang('Service'),$link_data));
			}
			$this->t->set_var(sort_first,$this->nextmatchs->show_sort_order($this->sort,'e_first',$this->order,'/index.php',lang('First'),$link_data));
			$this->t->set_var(sort_last,$this->nextmatchs->show_sort_order($this->sort,'e_lat',$this->order,'/index.php',lang('Last'),$link_data));
			$this->t->set_var(sort_modified,$this->nextmatchs->show_sort_order($this->sort,'c_date',$this->order,'/index.php',lang('last modified'),$link_data));

// -------------- end header declaration ---------------------------------------

			for ($i=0;$i<count($escal_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);

				$new_date = $escal_list[$i]['date'];
				$month = $phpgw->common->show_date(time(),'n');
				$day = $phpgw->common->show_date(time(),'d');
				$year = $phpgw->common->show_date(time(),'Y');
				$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
				$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

				$this->t->set_var(array
				(
					'e_name'	=> $phpgw->strip_html($escal_list[$i]['name']),
					'first'		=> $escal_list[$i]['first'],
					'last'		=> $escal_list[$i]['last'],
					'modified'	=> $new_dateout
				));

				$link_data['i_id'] = $escal_list[$i]['id'];
				$link_data['menuaction'] = 'netsaint.uinetsaint.view_escal';

				$this->t->set_var('view',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_view_entry',lang('View'));

				if ($this->bonetsaint->check_perms($this->grants[$escal_list[$i]['owner']],PHPGW_ACL_EDIT) || $escal_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinetsaint.edit_escal';

					$this->t->set_var('edit',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_edit_entry',lang('Edit'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit_entry','');
				}

				if ($this->bonetsaint->check_perms($this->grants[$escal_list[$i]['owner']],PHPGW_ACL_DELETE) || $escal_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinetsaint.delete_item';
					$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_delete_entry',lang('Delete'));
				}
				else
				{
					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete_entry','');
				}

				$this->t->fp('list','escal_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data['menuaction'] = 'netsaint.uinetsaint.add_escal';
			$link_data['cat_id'] = $this->cat_id;

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add') .'"></form>');
			}
			else
			{
				if ($this->bonetsaint->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$link_data['menuaction'] = 'netsaint.uinetsaint.prefs_escal';

			switch ($action)
			{
				case 'host':	$link_data['action'] = 'serv';
								$lang_etype = 'Service notification escalations'; break;
				case 'serv':	$link_data['action'] = 'host';
								$lang_etype = 'Host group notification escalations'; break;
			}

			$this->t->set_var('lang_etype',lang($lang_etype));
			$this->t->set_var('etype_action',$phpgw->link('/index.php',$link_data));

			$this->t->pfp('out','escal_list_t',True);
			$this->save_sessiondata($action);
//			$phpgw->common->phpgw_footer();
		}

		function admin_comand()
		{
			global $phpgw, $phpgw_info, $action;

			$this->display_admin_header();

			$this->t->set_file(array('filter' => 'filter.tpl',
									'comand_list_t' => 'admin_comand.tpl'));
			$this->t->set_block('comand_list_t','comand_list','list');

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.admin_comand',
				'action'		=> $action
			);

			if (!$this->start)
			{
				$this->start = 0;
			}

			$comand_list = $this->bonetsaint->read_items('comand',$this->start,True,$this->query,$action,$this->sort,$this->order,$this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bonetsaint->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bonetsaint->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bonetsaint->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('lang_action',lang('Commands'));
			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
/*			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1)); */
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

			$this->t->pfp('out','filter',True);

// ---------------- list header variable template-declarations --------------------------

			$this->t->set_var(sort_name,$this->nextmatchs->show_sort_order($this->sort,'co_name',$this->order,'/index.php',lang('Command'),$link_data));
			$this->t->set_var(sort_modified,$this->nextmatchs->show_sort_order($this->sort,'co_date',$this->order,'/index.php',lang('last modified'),$link_data));
			$this->t->set_var(sort_type,$this->nextmatchs->show_sort_order($this->sort,'co_type',$this->order,'/index.php',lang('Command type'),$link_data));
			$this->t->set_var(sort_enabled,$this->nextmatchs->show_sort_order($this->sort,'co_enabled',$this->order,'/index.php',lang('Enabled'),$link_data));

// -------------- end header declaration ---------------------------------------

			for ($i=0;$i<count($comand_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);

				$new_date = $comand_list[$i]['date'];
				$month = $phpgw->common->show_date(time(),'n');
				$day = $phpgw->common->show_date(time(),'d');
				$year = $phpgw->common->show_date(time(),'Y');
				$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
				$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

				switch($comand_list[$i]['enabled'])
				{
					case '1': $enabled = 'Yes'; break;
					case '0': $enabled = 'No'; break;
				}

				switch($comand_list[$i]['type'])
				{
					case 'com': $type = 'Service check command'; break;
					case 'hnot': $type = 'Host notification command'; break;
					case 'snot': $type = 'Service notification command'; break;
				}

				$this->t->set_var(array
				(
					'co_name'	=> $phpgw->strip_html($comand_list[$i]['name']),
					'type'		=> lang($type),
					'enabled'	=> lang($enabled),
					'modified'	=> $new_dateout
				));

				$link_data['i_id'] = $comand_list[$i]['id'];
				$link_data['menuaction'] = 'netsaint.uinetsaint.view_comand';

				$this->t->set_var('view',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_view_entry',lang('View'));

				$link_data['menuaction'] = 'netsaint.uinetsaint.edit_comand';
				$this->t->set_var('edit',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_edit_entry',lang('Edit'));

				$link_data['menuaction'] = 'netsaint.uinetsaint.delete_item';
				$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_delete_entry',lang('Delete'));

				$this->t->fp('list','comand_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data['menuaction']	= 'netsaint.uinetsaint.add_comand';
			$link_data['cat_id']		= $this->cat_id;				

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add command') .'"></form>');
			}
			else
			{
				if ($this->bonetsaint->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add command') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$this->t->set_var('done_action',$phpgw->link('/admin/index.php'));

			$this->t->pfp('out','comand_list_t',True);
			$this->save_sessiondata($action);
//			$phpgw->common->phpgw_footer();
		}


		function add_service()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction' 	=> 'netsaint.uinetsaint.add_service',
				'action'		=> 'service'
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;

				$error = $this->bonetsaint->check_values('service',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonetsaint->save_item('service',$values);

					$link_data['menuaction'] = 'netsaint.uinetsaint.prefs_service';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('service_add' => 'service_form.tpl'));
			$this->t->set_block('service_add','add','addhandle');
			$this->t->set_block('service_add','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Add service'));

			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));

			$this->t->set_var('event_list','');
			$this->t->set_var('comand_list',$this->bonetsaint->select_comand_list('com_enabled',$values['comand']));

			$this->t->set_var('host_list',$this->bonshost->select_host_list($values['host']));

			$this->t->set_var('s_tp_list',$this->botimeperiod->select_tp_list('tp',$values['s_period']));
			$this->t->set_var('c_tp_list',$this->botimeperiod->select_tp_list('tp',$values['c_period']));

			$this->t->set_var('cg_list',$this->bonscontact->select_contact_list('cg',$values['cg']));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('vol','<input type="checkbox" name="values[vol]" value="True"' . ($values['vol'] == '1'?' checked':'') . '>');
			$this->t->set_var('rec','<input type="checkbox" name="values[rec]" value="True"' . ($values['rec'] == '1'?' checked':'') . '>');
			$this->t->set_var('crit','<input type="checkbox" name="values[crit]" value="True"' . ($values['crit'] == '1'?' checked':'') . '>');
			$this->t->set_var('warn','<input type="checkbox" name="values[warn]" value="True"' . ($values['warn'] == '1'?' checked':'') . '>');

			$this->t->set_var('max',$values['max']);
			$this->t->set_var('c_intval',$values['c_intval']);
			$this->t->set_var('r_intval',$values['r_intval']);

			$this->t->set_var('not_intval',$values['not_intval']);
			$this->t->set_var('descr',$values['descr']);

			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','service_add');
			$this->t->pfp('addhandle','add');

//			$phpgw->common->phpgw_footer();
		}

		function add_comand()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.add_comand',
				'action'		=> $action
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;

				$error = $this->bonetsaint->check_values('comand',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonetsaint->save_item('comand',$values);

					$link_data['menuaction'] = 'netsaint.uinetsaint.admin_comand';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_admin_header();

			$this->t->set_file(array('comand_add' => 'comand_form.tpl'));
			$this->t->set_block('comand_add','add','addhandle');
			$this->t->set_block('comand_add','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Add command'));

			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));
			$this->t->set_var('enabled','<input type="checkbox" name="values[enabled]" value="True"' . ($values['enabled'] == '1'?' checked':'') . '>');
			$this->t->set_var('line',$values['line']);
			$this->t->set_var('co_name',$values['name']);

			if ($action == 'com_all')
			{
				$this->t->set_var('lang_type','');
				$this->t->set_var('type','');
			}
			else
			{
				$this->t->set_var('lang_type',lang('Command type'));

				switch ($values['type'])
				{
					case 'snot' : $sselect = ' selected'; break;
					case 'hnot' : $hselect = ' selected'; break;
				}

				$type = '<select name="values[type]"><option value="snot"' . $sselect . '>' . lang('Service notification command') . '</option>' . "\n";
				$type .= '<option value="hnot"' . $hselect . '>' . lang('Host notification command') . '</option></select>' . "\n";

				$this->t->set_var('type',$type);
			}

			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','comand_add');
			$this->t->pfp('addhandle','add');

//			$phpgw->common->phpgw_footer();
		}

		function add_escal()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $action, $cg;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.add_escal',
				'action'			=> $action
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;
				$values['type'] = $action;

				if (is_array($cg))
				{
					$values['cg'] = implode(',',$cg);
				}

				$error = $this->bonetsaint->check_values('escal',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonetsaint->save_item('escal',$values);

					$link_data['menuaction'] = 'netsaint.uinetsaint.prefs_escal';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('escal_add' => 'escal_form.tpl'));
			$this->t->set_block('escal_add','add','addhandle');
			$this->t->set_block('escal_add','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));

			if ($action == 'host')
			{
				$this->t->set_var('lang_action',lang('Add host group notification escalation'));
				$this->t->set_var('lang_descr','');	
				$this->t->set_var('descr','');
				$this->t->set_var('host_list',$this->bonshost->select_host_list('hg',$values['name']));
			}
			else
			{
				$this->t->set_var('lang_action',lang('Add service notification escalation'));
				$this->t->set_var('lang_descr',lang('Description of service'));	
				$this->t->set_var('descr','<select name="values[descr]">' .  $this->bonetsaint->select_service_list($values['descr']) . '</select>');
				$this->t->set_var('host_list',$this->bonshost->select_host_list('host',$values['name']));
			}

			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));
			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('cg_list',$this->bonscontact->select_contact_list('cg',$values['cg']));

			$this->t->set_var('first',$values['first']);
			$this->t->set_var('last',$values['last']);

			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','escal_add');
			$this->t->pfp('addhandle','add');

//			$phpgw->common->phpgw_footer();
		}

		function edit_escal()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $action, $cg, $i_id;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.edit_escal',
				'action'		=> $action,
				'i_id'			=> $i_id
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;
				$values['type'] = $action;
				$values['id'] = $i_id;

				if (is_array($cg))
				{
					$values['cg'] = implode(',',$cg);
				}

				$error = $this->bonetsaint->check_values('escal',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonetsaint->save_item('escal',$values);

					$link_data['menuaction'] = 'netsaint.uinetsaint.prefs_escal';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('escal_edit' => 'escal_form.tpl'));
			$this->t->set_block('escal_edit','add','addhandle');
			$this->t->set_block('escal_edit','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));

			$values = $this->bonetsaint->read_single_item('escal',$i_id);

			if ($action == 'host')
			{
				$this->t->set_var('lang_action',lang('Edit host group notification escalation'));
				$this->t->set_var('lang_descr','');	
				$this->t->set_var('descr','');
				$this->t->set_var('host_list',$this->bonshost->select_host_list('hg',$values['name']));
			}
			else
			{
				$this->t->set_var('lang_action',lang('Edit service notification escalation'));
				$this->t->set_var('lang_descr',lang('Description of service'));	
				$this->t->set_var('descr','<select name="values[descr]">' .  $this->bonetsaint->select_service_list($values['descr']) . '</select>');
				$this->t->set_var('host_list',$this->bonshost->select_host_list('host',$values['name']));
			}

			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));
			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$saved_cg = explode(',',$phpgw->strip_html($values['cg']));
			$this->t->set_var('cg_list',$this->bonscontact->select_contact_list('cg',$saved_cg));

			$this->t->set_var('first',$values['first']);
			$this->t->set_var('last',$values['last']);

			if ($this->bonetsaint->check_perms($this->grants[$values['owner']],PHPGW_ACL_DELETE) || $values['owner'] == $this->account)
			{
				$link_data['menuaction'] = 'netsaint.uinetsaint.delete_item';
				$this->t->set_var('delete','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
									. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','escal_edit');
			$this->t->pfp('edithandle','edit');

//			$phpgw->common->phpgw_footer();
		}

		function edit_service()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $i_id, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.edit_service',
				'i_id'			=> $i_id,
				'action'		=> 'service'
			);

			if ($submit)
			{
				$values['cat']	= $cat_id;
				$values['id']	= $i_id;

				$error = $this->bonetsaint->check_values('service',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonetsaint->save_item('service',$values);

					$link_data['menuaction'] = 'netsaint.uinetsaint.prefs_service';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('service_edit' => 'service_form.tpl'));
			$this->t->set_block('service_edit','add','addhandle');
			$this->t->set_block('service_edit','edit','edithandle');

			$values = $this->bonetsaint->read_single_item('service',$i_id);

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Edit service'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$values['cat'],True));

			$this->t->set_var('event_list','');
			$this->t->set_var('comand_list',$this->bonetsaint->select_comand_list('com_enabled',$values['comand']));

			$this->t->set_var('host_list',$this->bonshost->select_host_list($values['host']));

			$this->t->set_var('s_tp_list',$this->botimeperiod->select_tp_list('tp',$values['s_period']));
			$this->t->set_var('c_tp_list',$this->botimeperiod->select_tp_list('tp',$values['c_period']));

			$this->t->set_var('cg_list',$this->bonscontact->select_contact_list('cg',$values['cg']));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('vol','<input type="checkbox" name="values[vol]" value="True"' . ($values['vol'] == '1'?' checked':'') . '>');
			$this->t->set_var('rec','<input type="checkbox" name="values[rec]" value="True"' . ($values['rec'] == '1'?' checked':'') . '>');
			$this->t->set_var('crit','<input type="checkbox" name="values[crit]" value="True"' . ($values['crit'] == '1'?' checked':'') . '>');
			$this->t->set_var('warn','<input type="checkbox" name="values[warn]" value="True"' . ($values['warn'] == '1'?' checked':'') . '>');

			$this->t->set_var('max',$values['max']);
			$this->t->set_var('c_intval',$values['c_intval']);
			$this->t->set_var('r_intval',$values['r_intval']);

			$this->t->set_var('not_intval',$values['not_intval']);
			$this->t->set_var('descr',$values['descr']);

			if ($this->bonetsaint->check_perms($this->grants[$values['owner']],PHPGW_ACL_DELETE) || $values['owner'] == $this->account)
			{
				$link_data['menuaction'] = 'netsaint.uinetsaint.delete_item';
				$this->t->set_var('delete','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
									. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','service_edit');
			$this->t->pfp('edithandle','edit');
//			$phpgw->common->phpgw_footer();
		}

		function edit_comand()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $i_id, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.edit_comand',
				'i_id'			=> $i_id,
				'action'		=> $action
			);

			if ($submit)
			{
				$values['cat']	= $cat_id;
				$values['id']	= $i_id;

				$error = $this->bonetsaint->check_values('comand',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonetsaint->save_item('comand',$values);

					$link_data['menuaction'] = 'netsaint.uinetsaint.admin_comand';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_admin_header();

			$this->t->set_file(array('comand_edit' => 'comand_form.tpl'));
			$this->t->set_block('comand_edit','add','addhandle');
			$this->t->set_block('comand_edit','edit','edithandle');

			$values = $this->bonetsaint->read_single_item('comand',$i_id);

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Edit command'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$values['cat'],True));
			$this->t->set_var('enabled','<input type="checkbox" name="values[enabled]" value="True"' . ($values['enabled'] == '1'?' checked':'') . '>');
			$this->t->set_var('co_name',$phpgw->strip_html($values['name']));
			$this->t->set_var('co_line',$phpgw->strip_html($values['line']));

			if ($action == 'com_all')
			{
				$this->t->set_var('lang_type','');
				$this->t->set_var('type','');
			}
			else
			{
				$this->t->set_var('lang_type',lang('Command type'));

				switch ($values['type'])
				{
					case 'snot' : $sselect = ' selected'; break;
					case 'hnot' : $hselect = ' selected'; break;
				}

				$type = '<select name="values[type]"><option value="snot"' . $sselect . '>' . lang('Service notification command') . '</option>' . "\n";
				$type .= '<option value="hnot"' . $hselect . '>' . lang('Host notification command') . '</option></select>' . "\n";

				$this->t->set_var('type',$type);
			}

			$link_data['menuaction'] = 'netsaint.uinetsaint.delete_item';
			$this->t->set_var('delete','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
									. '"><input type="submit" value="' . lang('Delete') .'"></form>');

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','comand_edit');
			$this->t->pfp('edithandle','edit');
//			$phpgw->common->phpgw_footer();
		}


		function delete_item()
		{
			global $phpgw, $confirm, $i_id, $action;

			switch($action)
			{
				case 'service'	: $menu = 'netsaint.uinetsaint.prefs_service'; break;
				case 'com_all'	: $menu = 'netsaint.uinetsaint.admin_comand'; break;
				case 'not_all'	: $menu = 'netsaint.uinetsaint.admin_comand'; break;
				case 'host'		: $menu = 'netsaint.uinetsaint.prefs_escal'; break;
				case 'serv'		: $menu = 'netsaint.uinetsaint.prefs_escal'; break;
			}

			$link_data = array
			(
				'menuaction'	=> $menu,
				'i_id'			=> $i_id,
				'action'		=> $action
			);

			if ($confirm)
			{
				$this->bonetsaint->delete_item($action,$i_id);
				Header('Location: ' . $phpgw->link('/index.php',$link_data));				
			}
			else
			{
				if ($action == 'service' || $action == 'serv' || $action == 'host')
				{
					$this->display_prefs_header();
				}
				else
				{
					$this->display_admin_header();
				}

				$this->t->set_file(array('delete' => 'delete.tpl'));

				$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('deleteheader',lang('Are you sure you want to delete this entry ?'));
				$this->t->set_var('lang_no',lang('No'));
				$this->t->set_var('lang_yes',lang('Yes'));
				$link_data['menuaction'] = 'netsaint.uinetsaint.delete_item';
				$this->t->set_var('action_url',$phpgw->link('/index.php',$link_data));

				$this->t->pfp('out','delete');
//				$phpgw->common->phpgw_footer();
			}
		}

		function view_service()
		{
			global $i_id, $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.prefs_service',
				'action'		=> 'service'
			);

			$this->t->set_file(array('view' => 'default_view.tpl'));
			$this->t->set_block('view','service','servicehandle');
			$this->t->set_block('view','escal','escalhandle');
			$this->t->set_block('view','contact','contacthandle');
			$this->t->set_block('view','cg','cghandle');
			$this->t->set_block('view','tp','tphandle');
			$this->t->set_block('view','host','hosthandle');
			$this->t->set_block('view','group','grouphandle');
			$this->t->set_block('view','done','donehandle');

			$s = $this->bonetsaint->read_single_item('service',$i_id);

			$this->t->set_var('lang_action',lang('View service'));
			$this->t->set_var('lang_name',lang('Host'));
			$this->t->set_var('lang_alias',lang('Description'));
			$this->t->set_var('cat',$this->cats->id2name($s['cat']));

			$new_date = $s['date'] + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
			$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);
			$this->t->set_var('new_date',$new_dateout);

			$descr = nl2br($phpgw->strip_html($s['descr']));

			$this->t->set_var('alias',$descr);
			$this->t->set_var('h_name',$phpgw->strip_html($s['host']));
			$this->t->set_var('access',lang($s['access']));

			$cached_data = $this->bonetsaint->cached_accounts(intval($s['owner']));
			$ownerout = $phpgw->strip_html($cached_data[$s['owner']]['account_lid'] . ' [' . $cached_data[$s['owner']]['firstname'] . ' '
										. $cached_data[$s['owner']]['lastname'] . ' ]');

			$this->t->set_var('owner',$ownerout);

			$this->t->set_var('event','&nbsp;');
			$this->t->set_var('comand',$phpgw->strip_html($s['comand']));

			switch($s['rec'])
			{
				case '1':	$rec = 'Yes'; break;
				case '0':	$rec = 'No'; break;
			}
			
			switch($s['vol'])
			{
				case '1':	$vol = 'Yes'; break;
				case '0':	$vol = 'No'; break;
			}

			switch($s['crit'])
			{
				case '1':	$crit = 'Yes'; break;
				case '0':	$crit = 'No'; break;
			}

			switch($s['warn'])
			{
				case '1':	$warn = 'Yes'; break;
				case '0':	$warn = 'No'; break;
			}

			$this->t->set_var('vol',lang($vol));
			$this->t->set_var('rec',lang($rec));
			$this->t->set_var('crit',lang($crit));
			$this->t->set_var('warn',lang($warn));

			$this->t->set_var('s_period',$phpgw->strip_html($s['s_period']));
			$this->t->set_var('c_period',$phpgw->strip_html($s['c_period']));

			$this->t->set_var('cg',$phpgw->strip_html($s['cg']));

			$this->t->set_var('max',$s['max']);
			$this->t->set_var('c_intval',$s['c_intval']);
			$this->t->set_var('r_intval',$s['r_intval']);

			$this->t->set_var('not_intval',$s['not_intval']);

			$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));

			$this->t->set_var('servicehandle','');
			$this->t->set_var('escalhandle','');
			$this->t->set_var('contacthandle','');
			$this->t->set_var('cghandle','');
			$this->t->set_var('hosthandle','');
			$this->t->set_var('grouphandle','');
			$this->t->set_var('tphandle','');
			$this->t->pfp('out','view');
			$this->t->pfp('servicehandle','service');
			$this->t->pfp('donehandle','done');
//			$phpgw->common->phpgw_footer();
		}

		function view_escal()
		{
			global $i_id, $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.prefs_escal',
				'action'		=> $action
			);

			$this->t->set_file(array('view' => 'default_view.tpl'));
			$this->t->set_block('view','escal','escalhandle');
			$this->t->set_block('view','service','servicehandle');
			$this->t->set_block('view','contact','contacthandle');
			$this->t->set_block('view','cg','cghandle');
			$this->t->set_block('view','tp','tphandle');
			$this->t->set_block('view','host','hosthandle');
			$this->t->set_block('view','group','grouphandle');
			$this->t->set_block('view','done','donehandle');

			$e = $this->bonetsaint->read_single_item('escal',$i_id);

			if ($action == 'host')
			{
				$this->t->set_var('lang_action',lang('View host group notification escalation'));
				$this->t->set_var('lang_name',lang('Host group'));
				$this->t->set_var('lang_alias','');
				$this->t->set_var('alias','&nbsp;');
			}
			else
			{
				$this->t->set_var('lang_action',lang('Edit service notification escalation'));
				$this->t->set_var('lang_name',lang('Host'));
				$this->t->set_var('lang_alias',lang('Description of service'));	
				$this->t->set_var('alias',$phpgw->strip_html($e['descr']));
			}

			$this->t->set_var('h_name',$phpgw->strip_html($e['name']));
			$this->t->set_var('cat',$this->cats->id2name($e['cat']));

			$new_date = $e['date'] + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
			$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);
			$this->t->set_var('new_date',$new_dateout);

			$this->t->set_var('access',lang($e['access']));

			$cached_data = $this->bonetsaint->cached_accounts(intval($e['owner']));
			$ownerout = $phpgw->strip_html($cached_data[$e['owner']]['account_lid'] . ' [' . $cached_data[$e['owner']]['firstname'] . ' '
										. $cached_data[$e['owner']]['lastname'] . ' ]');

			$this->t->set_var('owner',$ownerout);

			$this->t->set_var('first',$e['first']);
			$this->t->set_var('last',$e['last']);

			$this->t->set_var('cg',$phpgw->strip_html($e['cg']));

			$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));

			$this->t->set_var('escalhandle','');
			$this->t->set_var('servicehandle','');
			$this->t->set_var('contacthandle','');
			$this->t->set_var('cghandle','');
			$this->t->set_var('hosthandle','');
			$this->t->set_var('grouphandle','');
			$this->t->set_var('tphandle','');
			$this->t->pfp('out','view');
			$this->t->pfp('escalhandle','escal');
			$this->t->pfp('donehandle','done');
//			$phpgw->common->phpgw_footer();
		}


		function view_comand()
		{
			global $i_id, $phpgw, $phpgw_info, $action;

			$this->display_admin_header();

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinetsaint.admin_comand',
				'action'		=> $action
			);

			$this->t->set_file(array('view' => 'comand_view.tpl'));

			$co = $this->bonetsaint->read_single_item('comand',$i_id);

			$this->t->set_var('lang_action',lang('View command'));
			$this->t->set_var('cat',$this->cats->id2name($co['cat']));

			$new_date = $co['date'] + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
			$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);
			$this->t->set_var('new_date',$new_dateout);

			$line = nl2br($phpgw->strip_html($co['line']));

			$this->t->set_var('co_line',$line);
			$this->t->set_var('co_name',$phpgw->strip_html($co['name']));

			switch($co['enabled'])
			{
				case '1':	$enabled = 'Yes'; break;
				case '0':	$enabled = 'No'; break;
			}
			
			$this->t->set_var('enabled',lang($enabled));

			switch($co['type'])
			{
				case 'com':		$type = 'Service check command'; break;
				case 'hnot':	$type = 'Host notification command'; break;
				case 'snot':	$type = 'Service notification command'; break;
			}

			$this->t->set_var('lang_type',lang('Command type'));
			$this->t->set_var('type',lang($type));

			$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));

			$this->t->pfp('out','view');
//			$phpgw->common->phpgw_footer();
		}
	}
?>
