<?php
  /**************************************************************************\
  * phpGroupWare - Image Editor                                              *
  * http://www.phpgroupware.org                                              *
  * This application written by Miles Lott <milosch@phpgroupware.org>        *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: class.boimg.inc.php,v 1.3 2001/12/30 21:56:05 milosch Exp $ */

	/* img business object class */
	class boimg
	{
		var $so;
		var $grants;

		var $debug = False;

		var $start;
		var $limit;
		var $query;
		var $sort;
		var $order;
		var $filter;
		var $cat_id;
		var $total;

		function boimg($debug=False)
		{
			$this->so  = CreateObject('img.soimg',$debug);
			$this->img = CreateObject('img.img',$debug);
			$this->debug = $debug;
			$this->read_sessiondata();

			$this->grants = $this->so->grants;

			$start   = $GLOBALS['HTTP_POST_VARS']['start']   ? $GLOBALS['HTTP_POST_VARS']['start']   : $GLOBALS['HTTP_GET_VARS']['start'];
			$query   = $GLOBALS['HTTP_POST_VARS']['query']   ? $GLOBALS['HTTP_POST_VARS']['query']   : $GLOBALS['HTTP_GET_VARS']['query'];
			$sort    = $GLOBALS['HTTP_POST_VARS']['sort']    ? $GLOBALS['HTTP_POST_VARS']['sort']    : $GLOBALS['HTTP_GET_VARS']['sort'];
			$order   = $GLOBALS['HTTP_POST_VARS']['order']   ? $GLOBALS['HTTP_POST_VARS']['order']   : $GLOBALS['HTTP_GET_VARS']['order'];
			$filter  = $GLOBALS['HTTP_POST_VARS']['filter']  ? $GLOBALS['HTTP_POST_VARS']['filter']  : $GLOBALS['HTTP_GET_VARS']['filter'];
			$cat_id  = $GLOBALS['HTTP_POST_VARS']['cat_id']  ? $GLOBALS['HTTP_POST_VARS']['cat_id']  : $GLOBALS['HTTP_GET_VARS']['cat_id'];
			$fcat_id = $GLOBALS['HTTP_POST_VARS']['fcat_id'] ? $GLOBALS['HTTP_POST_VARS']['fcat_id'] : $GLOBALS['HTTP_GET_VARS']['fcat_id'];

			if(!empty($start) || ($start == '0') || ($start == 0))
			{
				$this->start = $start;
			}
			if($limit)
			{
				$this->limit  = $limit;
			}
			if((empty($query) && !empty($this->query)) || !empty($query))
			{
				$this->query  = $query;
			}

			if(isset($fcat_id)) { $this->cat_id = $fcat_id; }
			if($fcat_id == '0' || $fcat_id == 0 || $fcat_id == '') { $this->cat_id = 0; }
			if(isset($sort))    { $this->sort   = $sort;   }
			if(isset($order))   { $this->order  = $order;  }
			if(isset($filter))  { $this->filter = $filter; }
		}

		/* The next two functions are for reading list position data for admin display */
		function save_sessiondata($data)
		{
			$GLOBALS['phpgw']->session->appsession('session_data','img',$data);
		}

		function read_sessiondata()
		{
			$data = $GLOBALS['phpgw']->session->appsession('session_data','img');

			$this->start  = $data['start'];
			$this->limit  = $data['limit'];
			$this->query  = $data['query'];
			$this->sort   = $data['sort'];
			$this->order  = $data['order'];
			$this->filter = $data['filter'];
			$this->cat_id = $data['cat_id'];
		}

		function index($data='')
		{
			return $this->so->index($this->start,$this->query,$this->sort,$this->order,$this->cat_id,$this->limit);
		}

		function read($data)
		{
			return $this->so->read($data);
		}

		function add($data)
		{
			unset ($data['id']);
			return $this->so->edit($data);
		}

		function edit($data)
		{
			return $this->so->edit($data);
		}

		function delete($data)
		{
			if(is_array($data))
			{
				$id = $data['id'];
			}
			else
			{
				$id = $data;
			}
			return $this->so->delete($id);
		}
	}
?>
