<?php
/*
 * $Id: class.htmlTimeCards.inc.php,v 1.5 2001/06/04 04:42:10 themaniac Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */



class htmlTimeCards
{
	function PopulateActionLinks($include, $enclose, $id, $dark, &$linkArray, &$rolloverArray)
	{
		global $dcl_info;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('m', $include))
		{
			$linkName = 'M';

			$linkArray[$linkName] = "index.php?menuAction=ccs.boTimecards.modify&id=$id";
			$rolloverArray[$linkName] = 'Modify';
		}

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_DEL_WO'] && ereg('x', $include))
		{
			$linkName = 'X';

			$linkArray[$linkName] = "index.php?menuAction=ccs.boTimecards.delete&id=$id";
			$rolloverArray[$linkName] = 'Delete';
		}
	}

	function GetActionLinks($include, $enclose, $id, $dark)
	{
		$linkArray = array();
		$rolloverArray = array();
		$this->PopulateActionLinks($include, $enclose, $id, $dark, $linkArray, $rolloverArray);

		return GetLinkSet($linkArray, $rolloverArray, $enclose, $dark);
	}

	function PrintActionLinks($include, $enclose, $id, $dark)
	{
		$linkArray = array();
		$rolloverArray = array();
		$this->PopulateActionLinks($include, $enclose, $id, $dark, $linkArray, $rolloverArray);

		PrintLinkSet($linkArray, $rolloverArray, $enclose, $dark);
	}


	function GetTimeCards($ccs,  $editID = 0, $forDelete = false)
	{
		global $dcl_info,$phpgw, $phpgw_info;

		$retVal = '';
		$objTimeCard = CreateObject('ccs.dbTimeCards');
		if ($objTimeCard->GetTimeCards($ccs) != -1)
		{ 
			$objPersonnel = CreateObject('ccs.dbPersonnel');
			$objStatus = CreateObject('ccs.dbStatuses');
			$objAction = CreateObject('ccs.dbActions');

			$Template = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('ccs'));
			$Template->set_file(array('hForm' => 'htmlTimeCardDetail.tpl'));
			$Template->set_block('hForm', 'nodelete', 'hNodelete');
			$Template->set_block('hForm', 'delete', 'hDelete');

			$Template->set_var('hNodelete', '');
			$Template->set_var('hDelete', '');
			$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
			$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
			$Template->set_var('BTN_DELETE', 'Delete');
			$Template->set_var('BTN_CANCEL', 'Cancel');

			$Template->set_var('TXT_STATUS', 'Status');
			$Template->set_var('TXT_VERSION', 'Version');
			$Template->set_var('TXT_ACTION', 'Action');
			$Template->set_var('TXT_HOURS', 'Hours');
			$Template->set_var('TXT_DESCRIPTION', 'Description');

			for ($i = 0; $i < $objTimeCard->db->num_rows(); $i++)
			//while ($objTimeCard->db->next_record())
			{
				if (!$forDelete && $editID == $objTimeCard->id)
				{
					$retVal .= '<tr><th align="left" colspan="2">';
					$oTCF = CreateObject('ccs.htmlTimeCardForm');
					$retVal .= $oTCF->GetForm($objTimeCard->ccs, $objTimeCard);
					$retVal .= '</th></tr>';
				}
				else
				{ 
					$objAccount=CreateObject('phpgwapi.accounts');
					$objPersonnel->Load($objTimeCard->actionby);
					$actionby=htmlspecialchars($objAccount->id2name($objPersonnel->phpgwid));

					$Template->set_var('TXT_TITLE', 'Action '.'('.$actionby .' '.$objTimeCard->actionon .') '.
						htmlspecialchars($objTimeCard->summary)); 


					$Template->set_var('VAL_TIMECARDID', $objTimeCard->id);
					if (!$forDelete || $editID == 0)
					{
						$Template->set_var('LNK_OPTIONS', $this->GetActionLinks('mx', true, $objTimeCard->id, false));
						$Template->parse('hNodelete', 'nodelete');
					}
					else
						$Template->parse('hDelete', 'delete');

					$objStatus->Load($objTimeCard->status);
					$objAction->Load($objTimeCard->action);                

					$Template->set_var('VAL_STATUS', htmlspecialchars($objStatus->name));
					$Template->set_var('VAL_REVISION','');
					$Template->set_var('VAL_ACTION', htmlspecialchars($objAction->name));
					$Template->set_var('VAL_HOURS', '');
					$Template->set_var('VAL_DESCRIPTION', nl2br(htmlspecialchars($objTimeCard->description)));

					$retVal .= $Template->parse('out', 'hForm');
				}

				$objTimeCard->db->next_record();
				$objTimeCard->GetRow();
			}
		}

		return $retVal;
	}
}

?>
