Name:		opensaml
Summary:	Open source Security Assertion Markup Language implementation.
Version:	1.1
Release:	5
#Copyright:	University Corporation for Advanced Internet Development, Inc.
Group:		System Environment/Libraries
License:	Apache style
URL:		http://www.opensaml.org/
Source0:	http://wayf.internet2.edu/shibboleth/%{name}-%{version}.tar.gz
Source1:	http://wayf.internet2.edu/shibboleth/%{name}-%{version}.tar.gz.asc
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

BuildRequires:	openssl-devel, curl-devel >= 7.10.6, xerces-c-devel >= 2.6.1
BuildRequires:	xml-security-c-devel >= 1.1.0, log4cpp-devel >= 0.3.5
BuildRequires:	zlib-devel

# xerces-c, xml-security-c, log4cpp originally found at
#    http://cachalot.mine.nu/2/SRPMS.fdr/


%description
OpenSAML is an open source implementation of the Security Assertion
Markup Language Specification of the OASIS group.  It contains a set
of open source C++ libraries that are fully consistent with the SAML
1.0 and 1.1 CR specifications.

This package contains the opensaml runtime library.

%package devel
Summary: OpenSAML development Headers
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
OpenSAML is an open source implementation of the Security Assertion
Markup Language Specification of the OASIS group.  It contains a set
of open source C++ libraries that are fully consistent with the SAML
1.0 and 1.1 CR specifications.  

This package contains the headers and other necessary files to build
applications that use the opensaml library.

%prep
%setup -q

%build
%configure
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
rm -rf _docs

make install DESTDIR=$RPM_BUILD_ROOT
mv $RPM_BUILD_ROOT/usr/doc/opensaml _docs

%check || :
make check

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc _docs/LICENSE.txt _docs/NEWS.txt _docs/README.txt _docs/TODO.txt
%{_bindir}/samltest
%{_bindir}/signtest
%{_libdir}/libsaml.so.*
%dir %{_datadir}/xml/opensaml
%{_datadir}/xml/opensaml

%files devel
%defattr(-,root,root,-)
%{_includedir}
%{_libdir}/libsaml.so

%changelog
* Thu Aug 11 2005  Scott Cantor  <cantor.2@osu.edu>  - 1.1-5
- Reduce wasteful memory use in DOM

* Sun Apr 24 2005  Scott Cantor  <cantor.2@osu.edu>  - 1.1-1
- Updated test programs and location of schemas.

* Tue Oct 19 2004  Derek Atkins  <derek@ihtfp.com>  - 1.0-1
- Create SPEC file based on various versions in existence.
