/*
    pqrm.c - Remove job from a print queue on a server
    Copyright (C) 1998, 1999  Petr Vandrovec, David Woodhouse
  
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    Revision history:

	0.00  1998			David Woodhouse <dave@imladris.demon.co.uk>
					Petr Vandrovec <vandrove@vc.cvut.cz>
		Initial revision. Derived from pqlist.c.

	1.00  1999, November 20		Petr Vandrovec <vandrove@vc.cvut.cz>
		Added license.
 */

#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <ncp/nwcalls.h>

#include <libintl.h>
#define _(X) gettext(X)

int
main(int argc, char **argv)
{
	struct ncp_conn *conn;
	struct ncp_bindery_object q;
	long err;
	int i;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL)
	{
		com_err(argv[0], err, _("when initializing"));
		return 1;
	}

	if (argc < 3)
	{
		fprintf(stderr, _("usage: %s <queue> <jobID> [<jobID> ...]\n"), argv[0]);
		return 1;
	}


	if (ncp_get_bindery_object_id(conn, NCP_BINDERY_PQUEUE, 
                                      argv[1], &q) != 0)
	{
		char server[NW_MAX_SERVER_NAME_LEN];
		const char* sptr = server;
		NWCCODE err;

		err = NWCCGetConnInfo(conn, NWCC_INFO_SERVER_NAME,
			sizeof(server), server);
		if (err)
			sptr = "?";

                printf(_("Queue \"%s\" on server %s not found.\n"),
                       argv[1], sptr);
                ncp_close(conn);
                exit(1);

	}

	for (i=2; i<argc; i++) {
		u_int32_t jobID;
		char* end;

		jobID = strtoul(argv[i], &end, 16);
		if (*end) {
			fprintf(stderr, _("Cannot parse \"%s\" - jobID must be hexadecimal number\n"), argv[i]);
		} else {
			int err;

			err = NWRemoveJobFromQueue2(conn, q.object_id, jobID);
			if (err == 0x89D5) {
				fprintf(stderr, _("Job %08X does not exist\n"), jobID);
			} else if (err == 0x89D6) {
				fprintf(stderr, _("You have not rights to cancel job %08X\n"), jobID);
			} else if (err) {
				fprintf(stderr, _("Cannot cancel job %08X: %s\n"), jobID, strnwerror(err));
			}
		}
	}
	ncp_close(conn);
	return 0;
}

