/* cause program to be run once per day */

/* arguments:
 * argument 1	lock name
 * argument 2..n	command to execute
 */
#ifndef NO_SCCS_ID
static char *sccsid = "@(#)daylock.c	1.1 (bdr) 11/6/86";
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <errno.h>
#include "bdr.h"

Bool	lockedtoday();	/* lockedtoday returns true if locked today */
Bool	touch();	/* returns true if touch succeeded */
char	*Cmdname;

main( argc, argv )
	int	argc;
	char	*argv[];
{
	int	result;
	char	*Malloc();
	char	*usrcmd;

	if ( argc < 2 )
	{
		fprintf(stderr,
			"usage: %s <lock-file> <command> [<argument>]\n",
			argv[0]);
		exit(1);
	}
	Cmdname = argv[0];


	if ( lockedtoday( argv[1] ) )
		result = 1;
	else
	{
		if ( ! touch( argv[1] ) )
			result = 1;
		else
		{
			int	cmdsize, argidx;

		
			for (argidx = 2; argidx < argc; argidx++)
				cmdsize += strlen( argv[argidx] ) + 1;
			usrcmd = (char *) Malloc( cmdsize );

			strcpy(usrcmd, argv[2]);
			for ( argidx = 3; argidx < argc; argidx++)
				{
				strcat(usrcmd, " ");
				strcat(usrcmd, argv[argidx]);
				}
			strcat(usrcmd,'\0');

			/* ok, now execute the user's command */
			if ( system( usrcmd ) == 127 )
				{
				perror("");
				exit(1);
				}
			result = 0;
		}
	}
	exit (result);
}


Bool
lockedtoday( filename )
	char	*filename;
{

	/* check to see if the file specified as an argument has been touched
	 * (locked) today.  If so, return 0, else return 1.  If the file
	 * cannot be opened, assume it has not been touched, return 1
	 */
	long time();
	struct tm *localtime();
	struct stat	buf;
	Bool	result;

	if ( stat(filename, &buf) == 0 )
	{
		/* even though systime and buf.st_mtime are declared
		 * differently (thanks a lot berkeley) we are going
		 * to compare them, assuming they represent the same
		 * quality
		 */
		long	systime, secs_today;
		struct tm	*tptr;

		time( &systime );
		tptr = localtime( &systime );

		secs_today = tptr->tm_sec + ( tptr->tm_min * 60L ) +
		             ( tptr->tm_hour * 3600L );

		if ( ( systime - secs_today ) > buf.st_mtime )
			result = False;	/* locked before start of day */
		else
			result = True;	/* locked after start of day */
	}
	else
		result = False;
	return result;
}

Bool
touch( filename )
	char	*filename;
{
	/* create file if it does not exist, otherwise try to read then
	 * write first byte of file
	 * returns true if succeeded, false otherwise
	 */
	extern int	errno;

	FILE	*fp;
	char	buf;
	struct stat	statbuf;
	Bool	result, succeeded = False;

	/* first check to see if file exists */
	if ( stat(filename, &statbuf) != 0 )
	{
		if ( errno == ENOENT )
		{
			if ( (fp = fopen( filename, "w")) != NULL )
				if ( fwrite( &buf, sizeof(buf), 1, fp) != 0 )
					if ( fclose( fp ) != EOF )
						succeeded = True;
			if ( succeeded )
				result = True;
			else
			{
				fprintf(stderr, "%s: %s: ",Cmdname, filename);
				perror("");
				result = False;
			}
		}
		else
		{
			fprintf(stderr, "%s: %s: ",Cmdname, filename);
			perror("");
			result = False;
		}
	}
	else
	{
		if ( (fp = fopen( filename, "r+")) != NULL )
		{
			if ( fread( &buf, sizeof(buf), 1, fp ) != 0)
				if ( fseek( fp, 0L, 0) !=  -1 )
					if ( fwrite( &buf, sizeof(buf), 1, fp) != 0 )
						if ( fclose( fp ) != EOF )
							succeeded = True;

			if ( succeeded )
				result = True;
			else
			{
				fclose(fp);
				result = False;
			}
		}
		else
		{
			fprintf( stderr, "%s: %s: ", Cmdname, filename);
			perror("");
			result = False;
		}
	}
	return result;
}


char *
Malloc( size )
	register int	size;
{
	register char *vast_tracts ;
	char	*malloc();

	if ( ! ( vast_tracts = malloc( size ) ) )
	{
		fprintf(stderr, "%s: unable to allocate more space\n", Cmdname);
		exit(1);
	}
	return( vast_tracts );
}
