/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.io.*;
import java.sql.*;

/**
 *
 */
public class PutvalUnicode
    extends Putval
{
    private Reader reader;
    private char[] sourceChars;
    
    /**
     * creates a new PutValUnicode
     */
    public
    PutvalUnicode (
        Reader readerp,
        int length, int bufpos)
    {
        super(bufpos);
        if (length >= 0)
          this.reader = new ReaderFilter(readerp, length);
        else
          this.reader = readerp;
    }
    
    public PutvalUnicode(char[] source, int bufpos)
    {
        super(bufpos);
		this.reader = new java.io.CharArrayReader(source);
		this.sourceChars = source;	
    }
    
    public Object cloneForBatch()
    {
    	if(this.sourceChars == null) {
    		return this;
    	} else {
    		return new PutvalUnicode(this.sourceChars, getBufpos());
    	}
    }
    
    /**
     *
     * @return boolean
     */
    public boolean atEnd ()
    {
        return this.reader == null;
    }
    /**
     *
     * @param dataPart com.sap.dbtech.jdbc.packet.DataPart
     */
    public void transferStream (
        com.sap.dbtech.jdbc.packet.DataPart dataPart)
        throws SQLException
    {
        // System.err.println("Transferring stream.");
        boolean streamExhausted;
        if (!this.atEnd ()) {
            streamExhausted = dataPart.fillWithReader (this.reader, this.descriptorMark, this);
            if (streamExhausted) {
                try {
                    this.reader.close ();
                }
                catch (IOException exc) {
                    // ignore
                }
                this.reader = null;
            }
        }
    }
    /**
     *
     */
    public String toString ()
    {
        return "<PutValUnicode " + this.reader + ">";
    }


    public void reset ()
    {
        if(this.requestedData != null) {
            char [] data = this.requestedData.getBigUnicode(0, this.requestedLen);
            CharArrayReader firstChunk = new CharArrayReader(data);
            if(this.reader == null) {
                this.reader = firstChunk;
            } else {
                this.reader = new com.sap.dbtech.util.JoinReader(new Reader[] { firstChunk, this.reader });
            }
            this.requestedData=null;
        }
    }
}

