/*!
  @file           veo52.c
  @author         JoergM
  @special area   Time and Time Statistic Functions
  @brief          
  @see            

\if EMIT_LICENCE
  ========== licence begin  GPL
  Copyright (c) 2001-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end
\endif
*/



/*
 * INCLUDE FILES
 */
#include "heo52.h"
#include "geo50_0.h"
#include "RunTime/System/RTESys_MicroTime.h"
#include "RunTime/System/RTESys_Time.h"

/*
 *  DEFINES
 */
#define MOD__  "veo52.c:"
#define EO52_CENTURY_ADJUST 1900
#define EO52_MICROSECONDS_PER_SECOND (1000000U)

/*
 * ========================== GLOBAL FUNCTIONS ================================
 */
externC void vtimestamp (
tsp00_Timestamp stamp )
{
    DBGPAS;
    RTESys_BuildSQLTimeStamp(RTESys_MicroSecondTime(), stamp);
}

/*---------------------*/

externC void vUTCtimestamp (
tsp00_Timestamp stamp )
{
    DBGPAS;
    RTESys_BuildSQLGMTTimeStamp(RTESys_MicroSecondTime(), stamp);
}

/*---------------------*/

void eo52UpdateTaskStateStatisticRec(
 teo52_RelativeAndAbsoluteTime *pRec,
 teo52_TaskStateStatisticRec   *pState )
{
#undef MF__
#define MF__ MOD__"eo52UpdateRelativeAndAbsoluteTimeRec"
    pRec->ulAbsMicroSeconds += (pState->dispatcherLeaveTime - pState->dispatcherEnterTime);
    pRec->ulRelMicroSeconds += (pState->runqueueEnqueueTime - pState->dispatcherEnterTime);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
