/*!
  @file           gen60.h
  @author         JoergM
  @special area   vopmsg
  @brief          Message Output
  @see            example.html ...

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/



#ifndef GEN60_H
#define GEN60_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "geo00.h"
#include "SAPDBCommon/SAPDB_Types.h"
#include <stdarg.h>

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externC void sql60kc_msg ( tsp00_Uint1 prio ,
						   const char *text,
						   int   msg_type );

externC void sql60_write_to_util_diag ( const char     *text ,
                                        int      len );

externC void sql60_write_to_event_file ( const char     *text ,
                                         int      len );

externC void e60_deliver_msg (char *msg, 
							  int lgt );

externC int  en60InitializeMessageOutput( /* void */ );

externC void sqldbgwrite ( const char *text ,
                           ... );

externC void sqlerrwrite ( const char *text ,
                           ... );

externC void sqlwngwrite ( const char *text ,
                           ... );

externC int  en60OpenEventFile ( tsp00_VFilenamec VAR_ARRAY_REF Filename, tsp00_Int4 MaxSize );

externC void en60MessageOutputCall( SAPDB_Int4         msgOutputMask,
                                    SAPDB_Int4         msgNumber, 
                                    SAPDB_Int4         msgType, 
                                    SAPDB_Char const * msgLabel, 
                                    SAPDB_Char const * msgFormat,
                                    va_list            msgArguments );

#endif  /* GEN60_H */
