/****************************************************************************

  module      : hbd91.h

  -------------------------------------------------------------------------

  responsible : FerdiF

  special area: 
  description : Declaration of exported functions of modul vbd91.cpp


  version     : 7.4.4.1
  last changed: 2003-01-22  19:48
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 1998-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1998-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/

#ifndef HBD91_H
#define HBD91_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gbd900.h"
#include "gbd910.h"

#include "liveCache/LVC_ErrorTraceObject.hpp"
#include "Logging/Log_UndoFile.hpp"
#include "GarbageCollector/GC_IGarbageCollector.hpp" // PTS xxxxxxx FF 2002-02-12

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externCpp cbd900_ObjFileInfo*
bd91AddFileToObjFileDir (tgg00_TransContext   &Trans,
						 tgg00_FileId         &FileId,
						 cbd910_RootNode      &NptrsRoot);

/*---------------------------------------------------------------------------*/

externCpp cbd900_ObjFileInfo*
bd91AddFileToContObjFileDir (tgg00_TransContext   &Trans,
							 tgg00_FileId         &FileId,
    						 cbd910_RootNode      &NptrsRoot);

/*---------------------------------------------------------------------------*/

externC void
bd91DumpGarbColl (tgg00_VfFileref     &HostFile,
                 tsp00_Int4            BufferSize,
                 tsp00_Page           &Buffer,
                 tsp00_Int4           &OutPno,
                 tsp00_Int4           &OutPos,
                 tsp00_VfReturn       &HostError,
                 tsp00_ErrText        &ErrText);

/*---------------------------------------------------------------------------*/
externC void
bd91InfoGCReset( void );

/*---------------------------------------------------------------------------*/

externC void
bd91InfoGCStats (tsp00_Int4            idxGC,   
                 tsp00_TaskId         &taskId,
                 tsp00_Bool           &active,
                 tsp00_8ByteCounter   &activateCount,
                 tsp00_8ByteCounter   &deleteObj,
                 tsp00_8ByteCounter   &relHistEntryNormal,
                 tsp00_8ByteCounter   &relHistCreateObjFile,
                 tsp00_8ByteCounter   &relHistDeleteObj,
                 tsp00_8ByteCounter   &relHistDropObjFile,
                 tsp00_8ByteCounter   &relHistLockObj,
                 tsp00_8ByteCounter   &relHistInsertObj,
                 tsp00_8ByteCounter   &relHistNewObj,
                 tsp00_8ByteCounter   &relHistUpdateObj,
                 tsp00_8ByteCounter   &relPageEmpty,
                 tsp00_8ByteCounter   &relPageDropFile,
                 tsp00_8ByteCounter   &relDropFile );

/*---------------------------------------------------------------------------*/

externC void
bd91InfoContainerRoots (tgg00_TransContext       &Trans,
                        cbd900_ObjFileDirIter     **pObjFileIter,
                        cbd900_ContObjFileDirIter **pContObjFileIter,
                        tsp00_Addr                pStackarea,
                        tsp00_Int2                pStackareaLen,
                        tsp00_Int4                &ClassId,
                        tsp00_Int4                &Root,
                        tsp00_Int4                &ContainerSequelNo,
                        tsp00_Int2                &NumKeyPartitions,
                        tsp00_Bool                &VarContainer,
                        tsp00_Bool                &DeleteFlag,
                        tsp00_Int4                &MaxObjBodySize,
                        tsp00_Int4                &MaxObjPerPage,
                        tsp00_Int4                &MaxChains,
                        tsp00_Int2                &UnusedBytesPerPage);

/*---------------------------------------------------------------------------*/

externC void
bd91InfoContainerChains (tgg00_TransContext       &Trans,
                         cbd900_ObjFileDirIter     **pObjFileIter,
                         cbd900_ContObjFileDirIter **pContObjFileIter,
                         tsp00_Addr                pStackarea,
                         tsp00_Int2                pStackareaLen,
                         tsp00_Int4                &ClassId,
                         tsp00_Int4                &ContainerSequelNo,
                         tsp00_Int4                &ChainId,
                         tsp00_Int4                &Subroot,
                         tsp00_Int4                &ObjCount,
                         tsp00_Int4                &PageCount,
                         tsp00_Int4                &ActiveGC,
                         tsp00_Bool                &RelEmptyPages);

/*---------------------------------------------------------------------------*/

externC void
bd91InfoContainerKeys (tgg00_TransContext       &Trans,
                       cbd900_ObjFileDirIter   **pObjFileIter,
                       tsp00_Addr                pStackarea,
                       tsp00_Int2                pStackareaLen,
                       tsp00_Int2                &KeyIdx,
                       tsp00_Int4                &ClassId,
                       tsp00_Int4                &KeyRoot);

/*---------------------------------------------------------------------------*/

externC void
bd91InitObjFileDir (tgg00_TransContext &Trans);

/*---------------------------------------------------------------------------*/

externC void
bd91InitOMSGarbageCollection ();

/*---------------------------------------------------------------------------*/

externC tsp00_Int4 b91MaxRetentionTime();
 
/*---------------------------------------------------------------------------*/

externC tsp00_Int4 b91MinRetentionTime();

/*---------------------------------------------------------------------------*/
// PTS 1113635 FF 25-Jan-2002
externC void
bd91MigrateObjFile (tgg00_TransContext  &Trans,
                    tgg00_FileId        &ObjFileId);

/*---------------------------------------------------------------------------*/
// PTS 1113452 FF 16-Jan-2002

externC void
bd91RemoveObjFilesMarkedForDelete (tgg00_TransContext &Trans);

/*---------------------------------------------------------------------------*/

externC void
bd91StartOMSGarbageCollection (tgg00_TransContext   &Trans, 
                               tsp00_Bool            bIfGCWaitTimeDone);

/*---------------------------------------------------------------------------*/

externC void
bd91StartOMSGarbageCollectionAfterSpecialOp (tsp00_TaskId  TaskId);

/*---------------------------------------------------------------------------*/

externC void
bd91StopOMSGarbageCollectionForSpecialOp (tsp00_TaskId  TaskId);

/*---------------------------------------------------------------------------*/
// PTS 1116157 FF 2002-06-07
externC void
bd91StartOMSGarbageCollectionIfRequired (tgg00_TransContext   &Trans); 

/*---------------------------------------------------------------------------*/

externCpp void
bd91RemoveObjFromFile (tbd_current_tree        &Current,
                       cbd910_PrimObjDataNode  &NptrsPage,
					   cbd910_SubRootNode      &NptrsSubRoot,
                       tbd900_ObjFrame         *pObjFrame,
                       tgg92_KernelOid         &OId,
                       cbd900_ObjFileInfo      &ObjFileInfo, 
                       Log_UndoFile::Iterator  &historyIterator,
					   LVC_ErrorTraceObject    &ErrorTraceObject,
                       bool                     bNoKeyRemove); // new PTS 1128894 FF 31-MAR-2004

/*---------------------------------------------------------------------------*/

externCpp void
bd91RemoveObjFromPage (tbd_current_tree        &Current,
					   cbd910_PrimObjDataNode  &NptrsPage,
					   tbd900_ObjFrame         *pObjFrame,
                       tgg92_KernelOid         &OId,
					   cbd900_ObjFileInfo      &ObjFileInfo, 
					   LVC_ErrorTraceObject    &ErrorTraceObject,
                       bool                     bNoKeyRemove); // new PTS 1128894 FF 31-MAR-2004

/*---------------------------------------------------------------------------*/

externCpp void
bd91ReleaseUnusedObject (tgg00_TransContext      &Trans,
                         Log_UndoFile::Iterator  &historyIterator,
                         const tgg92_KernelOid   &OId,
                         tgg00_ObjFileNo          ObjFileNo,
                         const tgg91_PageRef     &WantedObjVers,
                         GC_IGarbageCollector    &IGarbColl);

/*---------------------------------------------------------------------------*/
// PTS 1119647 FF 2002-DEC-05
externCpp void
bd91DropObjFile (tgg00_TransContext      &Trans,
                 tgg00_ObjFileNo          ObjFileNo);

/*---------------------------------------------------------------------------*/
extern bool bd91MigrateToNewLockprotocol;       // UH 2003-07-03
extern bool bd91MigrateToDoubleLinkedFreelist;  // UH 2003-07-03

#endif /* HBD91_H */
