/****************************************************************************

  module      : Trace_Types.cpp

  -------------------------------------------------------------------------

  responsible : TorstenS

  special area:
  description : 

  last changed: 2000-12-14  18:15
  see also    :

  -------------------------------------------------------------------------

  copyright:    (c) 2000-2004 SAP AG




    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg11.h"

#include "Trace/Trace_Types.hpp"
#include "Trace/Trace_Entry.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

Trace_IBaseEntry::Trace_IBaseEntry( 
                                   tgg00_TransContext   &Trans,
                                   tgg00_Debug          Layer,
                                   tgg00_VtraceType     Type )
:
m_Trans( Trans ),
m_Layer( Layer ),
m_Type( Type )
{
};

/*---------------------------------------------------------------------------*/

Trace_IBaseEntry::~Trace_IBaseEntry()
{
};

/*---------------------------------------------------------------------------*/

SAPDB_Int4 
Trace_IBaseEntry::MaximumSize()
{ 
    return( sizeof( tgg11_VtraceBody ));
};

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

Trace_ILargeEntry::Trace_ILargeEntry( 
                                     tgg00_TransContext   &Trans,
                                     tgg00_Debug          Layer,
                                     tgg00_VtraceType     Type )
                                     :
m_Trans( Trans ),
m_Layer( Layer ),
m_Type( Type )
{
};

/*---------------------------------------------------------------------------*/

Trace_ILargeEntry::~Trace_ILargeEntry()
{
};

/*---------------------------------------------------------------------------*/

SAPDB_Int4
Trace_ILargeEntry::UsablePartSize()
{
    return( Trace_IBaseEntry::MaximumSize() - INTERNAL_HEADER_SIZE );
};

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/